/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_40;

import org.hl7.fhir.convertors.VersionConvertor_30_40;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Procedure;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Annotation;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Procedure;

public class Procedure30_40 {
    public static Procedure convertProcedure(org.hl7.fhir.dstu3.model.Procedure src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Procedure tgt = new Procedure();
        VersionConvertor_30_40.copyDomainResource(src, tgt, new String[0]);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(identifier));
        }
        for (Reference reference : src.getBasedOn()) {
            tgt.addBasedOn(VersionConvertor_30_40.convertReference(reference));
        }
        for (Reference reference : src.getPartOf()) {
            tgt.addPartOf(VersionConvertor_30_40.convertReference(reference));
        }
        if (src.getNotDone()) {
            tgt.setStatus(Procedure.ProcedureStatus.NOTDONE);
        } else if (src.hasStatus()) {
            tgt.setStatusElement(Procedure30_40.convertProcedureStatus(src.getStatusElement()));
        }
        if (src.hasNotDoneReason() && src.hasNotDoneReason()) {
            tgt.setStatusReason(VersionConvertor_30_40.convertCodeableConcept(src.getNotDoneReason()));
        }
        if (src.hasCategory() && src.hasCategory()) {
            tgt.setCategory(VersionConvertor_30_40.convertCodeableConcept(src.getCategory()));
        }
        if (src.hasCode() && src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertCodeableConcept(src.getCode()));
        }
        if (src.hasSubject() && src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_40.convertReference(src.getSubject()));
        }
        if (src.hasContext() && src.hasContext()) {
            tgt.setEncounter(VersionConvertor_30_40.convertReference(src.getContext()));
        }
        if (src.hasPerformed() && src.hasPerformed()) {
            tgt.setPerformed(VersionConvertor_30_40.convertType(src.getPerformed()));
        }
        for (Procedure.ProcedurePerformerComponent procedurePerformerComponent : src.getPerformer()) {
            tgt.addPerformer(Procedure30_40.convertProcedurePerformerComponent(procedurePerformerComponent));
        }
        if (src.hasLocation() && src.hasLocation()) {
            tgt.setLocation(VersionConvertor_30_40.convertReference(src.getLocation()));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getReasonCode()) {
            tgt.addReasonCode(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        for (Reference reference : src.getReasonReference()) {
            tgt.addReasonReference(VersionConvertor_30_40.convertReference(reference));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getBodySite()) {
            tgt.addBodySite(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        if (src.hasOutcome() && src.hasOutcome()) {
            tgt.setOutcome(VersionConvertor_30_40.convertCodeableConcept(src.getOutcome()));
        }
        for (Reference reference : src.getReport()) {
            tgt.addReport(VersionConvertor_30_40.convertReference(reference));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getComplication()) {
            tgt.addComplication(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        for (Reference reference : src.getComplicationDetail()) {
            tgt.addComplicationDetail(VersionConvertor_30_40.convertReference(reference));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getFollowUp()) {
            tgt.addFollowUp(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.dstu3.model.Annotation annotation : src.getNote()) {
            tgt.addNote(VersionConvertor_30_40.convertAnnotation(annotation));
        }
        for (Procedure.ProcedureFocalDeviceComponent procedureFocalDeviceComponent : src.getFocalDevice()) {
            tgt.addFocalDevice(Procedure30_40.convertProcedureFocalDeviceComponent(procedureFocalDeviceComponent));
        }
        for (Reference reference : src.getUsedReference()) {
            tgt.addUsedReference(VersionConvertor_30_40.convertReference(reference));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getUsedCode()) {
            tgt.addUsedCode(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Procedure convertProcedure(Procedure src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Procedure tgt = new org.hl7.fhir.dstu3.model.Procedure();
        VersionConvertor_30_40.copyDomainResource(src, tgt, new String[0]);
        for (org.hl7.fhir.r4.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(identifier));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getBasedOn()) {
            tgt.addBasedOn(VersionConvertor_30_40.convertReference(reference));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getPartOf()) {
            tgt.addPartOf(VersionConvertor_30_40.convertReference(reference));
        }
        if (src.hasStatus()) {
            Procedure.ProcedureStatus status = src.getStatus();
            if (Procedure.ProcedureStatus.NOTDONE.equals((Object)status)) {
                tgt.setStatus(Procedure.ProcedureStatus.SUSPENDED);
                tgt.setNotDone(true);
                if (src.hasStatusReason()) {
                    tgt.setNotDoneReason(VersionConvertor_30_40.convertCodeableConcept(src.getStatusReason()));
                }
            } else {
                if (src.hasStatus()) {
                    tgt.setStatusElement(Procedure30_40.convertProcedureStatus(src.getStatusElement()));
                }
                tgt.setNotDone(false);
            }
        }
        if (src.hasCategory() && src.hasCategory()) {
            tgt.setCategory(VersionConvertor_30_40.convertCodeableConcept(src.getCategory()));
        }
        if (src.hasCode() && src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertCodeableConcept(src.getCode()));
        }
        if (src.hasSubject() && src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_40.convertReference(src.getSubject()));
        }
        if (src.hasEncounter() && src.hasEncounter()) {
            tgt.setContext(VersionConvertor_30_40.convertReference(src.getEncounter()));
        }
        if (src.hasPerformed() && src.hasPerformed()) {
            tgt.setPerformed(VersionConvertor_30_40.convertType(src.getPerformed()));
        }
        for (Procedure.ProcedurePerformerComponent procedurePerformerComponent : src.getPerformer()) {
            tgt.addPerformer(Procedure30_40.convertProcedurePerformerComponent(procedurePerformerComponent));
        }
        if (src.hasLocation() && src.hasLocation()) {
            tgt.setLocation(VersionConvertor_30_40.convertReference(src.getLocation()));
        }
        for (CodeableConcept codeableConcept : src.getReasonCode()) {
            tgt.addReasonCode(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getReasonReference()) {
            tgt.addReasonReference(VersionConvertor_30_40.convertReference(reference));
        }
        for (CodeableConcept codeableConcept : src.getBodySite()) {
            tgt.addBodySite(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        if (src.hasOutcome() && src.hasOutcome()) {
            tgt.setOutcome(VersionConvertor_30_40.convertCodeableConcept(src.getOutcome()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getReport()) {
            tgt.addReport(VersionConvertor_30_40.convertReference(reference));
        }
        for (CodeableConcept codeableConcept : src.getComplication()) {
            tgt.addComplication(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getComplicationDetail()) {
            tgt.addComplicationDetail(VersionConvertor_30_40.convertReference(reference));
        }
        for (CodeableConcept codeableConcept : src.getFollowUp()) {
            tgt.addFollowUp(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        for (Annotation annotation : src.getNote()) {
            tgt.addNote(VersionConvertor_30_40.convertAnnotation(annotation));
        }
        for (Procedure.ProcedureFocalDeviceComponent procedureFocalDeviceComponent : src.getFocalDevice()) {
            tgt.addFocalDevice(Procedure30_40.convertProcedureFocalDeviceComponent(procedureFocalDeviceComponent));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getUsedReference()) {
            tgt.addUsedReference(VersionConvertor_30_40.convertReference(reference));
        }
        for (CodeableConcept codeableConcept : src.getUsedCode()) {
            tgt.addUsedCode(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        return tgt;
    }

    public static Procedure.ProcedureFocalDeviceComponent convertProcedureFocalDeviceComponent(Procedure.ProcedureFocalDeviceComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Procedure.ProcedureFocalDeviceComponent tgt = new Procedure.ProcedureFocalDeviceComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasAction() && src.hasAction()) {
            tgt.setAction(VersionConvertor_30_40.convertCodeableConcept(src.getAction()));
        }
        if (src.hasManipulated() && src.hasManipulated()) {
            tgt.setManipulated(VersionConvertor_30_40.convertReference(src.getManipulated()));
        }
        return tgt;
    }

    public static Procedure.ProcedureFocalDeviceComponent convertProcedureFocalDeviceComponent(Procedure.ProcedureFocalDeviceComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Procedure.ProcedureFocalDeviceComponent tgt = new Procedure.ProcedureFocalDeviceComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasAction() && src.hasAction()) {
            tgt.setAction(VersionConvertor_30_40.convertCodeableConcept(src.getAction()));
        }
        if (src.hasManipulated() && src.hasManipulated()) {
            tgt.setManipulated(VersionConvertor_30_40.convertReference(src.getManipulated()));
        }
        return tgt;
    }

    public static Procedure.ProcedurePerformerComponent convertProcedurePerformerComponent(Procedure.ProcedurePerformerComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Procedure.ProcedurePerformerComponent tgt = new Procedure.ProcedurePerformerComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasRole() && src.hasRole()) {
            tgt.setFunction(VersionConvertor_30_40.convertCodeableConcept(src.getRole()));
        }
        if (src.hasActor() && src.hasActor()) {
            tgt.setActor(VersionConvertor_30_40.convertReference(src.getActor()));
        }
        if (src.hasOnBehalfOf() && src.hasOnBehalfOf()) {
            tgt.setOnBehalfOf(VersionConvertor_30_40.convertReference(src.getOnBehalfOf()));
        }
        return tgt;
    }

    public static Procedure.ProcedurePerformerComponent convertProcedurePerformerComponent(Procedure.ProcedurePerformerComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Procedure.ProcedurePerformerComponent tgt = new Procedure.ProcedurePerformerComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasFunction() && src.hasFunction()) {
            tgt.setRole(VersionConvertor_30_40.convertCodeableConcept(src.getFunction()));
        }
        if (src.hasActor() && src.hasActor()) {
            tgt.setActor(VersionConvertor_30_40.convertReference(src.getActor()));
        }
        if (src.hasOnBehalfOf() && src.hasOnBehalfOf()) {
            tgt.setOnBehalfOf(VersionConvertor_30_40.convertReference(src.getOnBehalfOf()));
        }
        return tgt;
    }

    public static Enumeration<Procedure.ProcedureStatus> convertProcedureStatus(org.hl7.fhir.dstu3.model.Enumeration<Procedure.ProcedureStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Procedure.ProcedureStatus> tgt = new Enumeration<Procedure.ProcedureStatus>(new Procedure.ProcedureStatusEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((Procedure.ProcedureStatus)((Object)src.getValue())) {
            case PREPARATION: {
                tgt.setValue((Object)Procedure.ProcedureStatus.PREPARATION);
                break;
            }
            case INPROGRESS: {
                tgt.setValue((Object)Procedure.ProcedureStatus.INPROGRESS);
                break;
            }
            case SUSPENDED: {
                tgt.setValue((Object)Procedure.ProcedureStatus.ONHOLD);
                break;
            }
            case ABORTED: {
                tgt.setValue((Object)Procedure.ProcedureStatus.STOPPED);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)Procedure.ProcedureStatus.COMPLETED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Procedure.ProcedureStatus.ENTEREDINERROR);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)Procedure.ProcedureStatus.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)Procedure.ProcedureStatus.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<Procedure.ProcedureStatus> convertProcedureStatus(Enumeration<Procedure.ProcedureStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<Procedure.ProcedureStatus> tgt = new org.hl7.fhir.dstu3.model.Enumeration<Procedure.ProcedureStatus>(new Procedure.ProcedureStatusEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((Procedure.ProcedureStatus)((Object)src.getValue())) {
            case PREPARATION: {
                tgt.setValue((Object)Procedure.ProcedureStatus.PREPARATION);
                break;
            }
            case INPROGRESS: {
                tgt.setValue((Object)Procedure.ProcedureStatus.INPROGRESS);
                break;
            }
            case ONHOLD: {
                tgt.setValue((Object)Procedure.ProcedureStatus.SUSPENDED);
                break;
            }
            case STOPPED: {
                tgt.setValue((Object)Procedure.ProcedureStatus.ABORTED);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)Procedure.ProcedureStatus.COMPLETED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Procedure.ProcedureStatus.ENTEREDINERROR);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)Procedure.ProcedureStatus.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)Procedure.ProcedureStatus.NULL);
            }
        }
        return tgt;
    }
}

