/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_40;

import org.hl7.fhir.convertors.VersionConvertor_30_40;
import org.hl7.fhir.dstu3.model.ContactDetail;
import org.hl7.fhir.dstu3.model.Contributor;
import org.hl7.fhir.dstu3.model.DataRequirement;
import org.hl7.fhir.dstu3.model.IdType;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.PlanDefinition;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.RelatedArtifact;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.PlanDefinition;
import org.hl7.fhir.r4.model.TriggerDefinition;
import org.hl7.fhir.r4.model.UsageContext;

public class PlanDefinition30_40 {
    public static Enumeration<PlanDefinition.ActionCardinalityBehavior> convertActionCardinalityBehavior(org.hl7.fhir.dstu3.model.Enumeration<PlanDefinition.ActionCardinalityBehavior> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<PlanDefinition.ActionCardinalityBehavior> tgt = new Enumeration<PlanDefinition.ActionCardinalityBehavior>(new PlanDefinition.ActionCardinalityBehaviorEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((PlanDefinition.ActionCardinalityBehavior)((Object)src.getValue())) {
            case SINGLE: {
                tgt.setValue((Object)PlanDefinition.ActionCardinalityBehavior.SINGLE);
                break;
            }
            case MULTIPLE: {
                tgt.setValue((Object)PlanDefinition.ActionCardinalityBehavior.MULTIPLE);
                break;
            }
            default: {
                tgt.setValue((Object)PlanDefinition.ActionCardinalityBehavior.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<PlanDefinition.ActionCardinalityBehavior> convertActionCardinalityBehavior(Enumeration<PlanDefinition.ActionCardinalityBehavior> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<PlanDefinition.ActionCardinalityBehavior> tgt = new org.hl7.fhir.dstu3.model.Enumeration<PlanDefinition.ActionCardinalityBehavior>(new PlanDefinition.ActionCardinalityBehaviorEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((PlanDefinition.ActionCardinalityBehavior)((Object)src.getValue())) {
            case SINGLE: {
                tgt.setValue((Object)PlanDefinition.ActionCardinalityBehavior.SINGLE);
                break;
            }
            case MULTIPLE: {
                tgt.setValue((Object)PlanDefinition.ActionCardinalityBehavior.MULTIPLE);
                break;
            }
            default: {
                tgt.setValue((Object)PlanDefinition.ActionCardinalityBehavior.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<PlanDefinition.ActionConditionKind> convertActionConditionKind(Enumeration<PlanDefinition.ActionConditionKind> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<PlanDefinition.ActionConditionKind> tgt = new org.hl7.fhir.dstu3.model.Enumeration<PlanDefinition.ActionConditionKind>(new PlanDefinition.ActionConditionKindEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((PlanDefinition.ActionConditionKind)((Object)src.getValue())) {
            case APPLICABILITY: {
                tgt.setValue((Object)PlanDefinition.ActionConditionKind.APPLICABILITY);
                break;
            }
            case START: {
                tgt.setValue((Object)PlanDefinition.ActionConditionKind.START);
                break;
            }
            case STOP: {
                tgt.setValue((Object)PlanDefinition.ActionConditionKind.STOP);
                break;
            }
            default: {
                tgt.setValue((Object)PlanDefinition.ActionConditionKind.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<PlanDefinition.ActionConditionKind> convertActionConditionKind(org.hl7.fhir.dstu3.model.Enumeration<PlanDefinition.ActionConditionKind> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<PlanDefinition.ActionConditionKind> tgt = new Enumeration<PlanDefinition.ActionConditionKind>(new PlanDefinition.ActionConditionKindEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((PlanDefinition.ActionConditionKind)((Object)src.getValue())) {
            case APPLICABILITY: {
                tgt.setValue((Object)PlanDefinition.ActionConditionKind.APPLICABILITY);
                break;
            }
            case START: {
                tgt.setValue((Object)PlanDefinition.ActionConditionKind.START);
                break;
            }
            case STOP: {
                tgt.setValue((Object)PlanDefinition.ActionConditionKind.STOP);
                break;
            }
            default: {
                tgt.setValue((Object)PlanDefinition.ActionConditionKind.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<PlanDefinition.ActionGroupingBehavior> convertActionGroupingBehavior(Enumeration<PlanDefinition.ActionGroupingBehavior> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<PlanDefinition.ActionGroupingBehavior> tgt = new org.hl7.fhir.dstu3.model.Enumeration<PlanDefinition.ActionGroupingBehavior>(new PlanDefinition.ActionGroupingBehaviorEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((PlanDefinition.ActionGroupingBehavior)((Object)src.getValue())) {
            case VISUALGROUP: {
                tgt.setValue((Object)PlanDefinition.ActionGroupingBehavior.VISUALGROUP);
                break;
            }
            case LOGICALGROUP: {
                tgt.setValue((Object)PlanDefinition.ActionGroupingBehavior.LOGICALGROUP);
                break;
            }
            case SENTENCEGROUP: {
                tgt.setValue((Object)PlanDefinition.ActionGroupingBehavior.SENTENCEGROUP);
                break;
            }
            default: {
                tgt.setValue((Object)PlanDefinition.ActionGroupingBehavior.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<PlanDefinition.ActionGroupingBehavior> convertActionGroupingBehavior(org.hl7.fhir.dstu3.model.Enumeration<PlanDefinition.ActionGroupingBehavior> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<PlanDefinition.ActionGroupingBehavior> tgt = new Enumeration<PlanDefinition.ActionGroupingBehavior>(new PlanDefinition.ActionGroupingBehaviorEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((PlanDefinition.ActionGroupingBehavior)((Object)src.getValue())) {
            case VISUALGROUP: {
                tgt.setValue((Object)PlanDefinition.ActionGroupingBehavior.VISUALGROUP);
                break;
            }
            case LOGICALGROUP: {
                tgt.setValue((Object)PlanDefinition.ActionGroupingBehavior.LOGICALGROUP);
                break;
            }
            case SENTENCEGROUP: {
                tgt.setValue((Object)PlanDefinition.ActionGroupingBehavior.SENTENCEGROUP);
                break;
            }
            default: {
                tgt.setValue((Object)PlanDefinition.ActionGroupingBehavior.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<PlanDefinition.ActionParticipantType> convertActionParticipantType(Enumeration<PlanDefinition.ActionParticipantType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<PlanDefinition.ActionParticipantType> tgt = new org.hl7.fhir.dstu3.model.Enumeration<PlanDefinition.ActionParticipantType>(new PlanDefinition.ActionParticipantTypeEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((PlanDefinition.ActionParticipantType)((Object)src.getValue())) {
            case PATIENT: {
                tgt.setValue((Object)PlanDefinition.ActionParticipantType.PATIENT);
                break;
            }
            case PRACTITIONER: {
                tgt.setValue((Object)PlanDefinition.ActionParticipantType.PRACTITIONER);
                break;
            }
            case RELATEDPERSON: {
                tgt.setValue((Object)PlanDefinition.ActionParticipantType.RELATEDPERSON);
                break;
            }
            default: {
                tgt.setValue((Object)PlanDefinition.ActionParticipantType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<PlanDefinition.ActionParticipantType> convertActionParticipantType(org.hl7.fhir.dstu3.model.Enumeration<PlanDefinition.ActionParticipantType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<PlanDefinition.ActionParticipantType> tgt = new Enumeration<PlanDefinition.ActionParticipantType>(new PlanDefinition.ActionParticipantTypeEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((PlanDefinition.ActionParticipantType)((Object)src.getValue())) {
            case PATIENT: {
                tgt.setValue((Object)PlanDefinition.ActionParticipantType.PATIENT);
                break;
            }
            case PRACTITIONER: {
                tgt.setValue((Object)PlanDefinition.ActionParticipantType.PRACTITIONER);
                break;
            }
            case RELATEDPERSON: {
                tgt.setValue((Object)PlanDefinition.ActionParticipantType.RELATEDPERSON);
                break;
            }
            default: {
                tgt.setValue((Object)PlanDefinition.ActionParticipantType.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<PlanDefinition.ActionPrecheckBehavior> convertActionPrecheckBehavior(Enumeration<PlanDefinition.ActionPrecheckBehavior> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<PlanDefinition.ActionPrecheckBehavior> tgt = new org.hl7.fhir.dstu3.model.Enumeration<PlanDefinition.ActionPrecheckBehavior>(new PlanDefinition.ActionPrecheckBehaviorEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((PlanDefinition.ActionPrecheckBehavior)((Object)src.getValue())) {
            case YES: {
                tgt.setValue((Object)PlanDefinition.ActionPrecheckBehavior.YES);
                break;
            }
            case NO: {
                tgt.setValue((Object)PlanDefinition.ActionPrecheckBehavior.NO);
                break;
            }
            default: {
                tgt.setValue((Object)PlanDefinition.ActionPrecheckBehavior.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<PlanDefinition.ActionPrecheckBehavior> convertActionPrecheckBehavior(org.hl7.fhir.dstu3.model.Enumeration<PlanDefinition.ActionPrecheckBehavior> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<PlanDefinition.ActionPrecheckBehavior> tgt = new Enumeration<PlanDefinition.ActionPrecheckBehavior>(new PlanDefinition.ActionPrecheckBehaviorEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((PlanDefinition.ActionPrecheckBehavior)((Object)src.getValue())) {
            case YES: {
                tgt.setValue((Object)PlanDefinition.ActionPrecheckBehavior.YES);
                break;
            }
            case NO: {
                tgt.setValue((Object)PlanDefinition.ActionPrecheckBehavior.NO);
                break;
            }
            default: {
                tgt.setValue((Object)PlanDefinition.ActionPrecheckBehavior.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<PlanDefinition.ActionRelationshipType> convertActionRelationshipType(org.hl7.fhir.dstu3.model.Enumeration<PlanDefinition.ActionRelationshipType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<PlanDefinition.ActionRelationshipType> tgt = new Enumeration<PlanDefinition.ActionRelationshipType>(new PlanDefinition.ActionRelationshipTypeEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((PlanDefinition.ActionRelationshipType)((Object)src.getValue())) {
            case BEFORESTART: {
                tgt.setValue((Object)PlanDefinition.ActionRelationshipType.BEFORESTART);
                break;
            }
            case BEFORE: {
                tgt.setValue((Object)PlanDefinition.ActionRelationshipType.BEFORE);
                break;
            }
            case BEFOREEND: {
                tgt.setValue((Object)PlanDefinition.ActionRelationshipType.BEFOREEND);
                break;
            }
            case CONCURRENTWITHSTART: {
                tgt.setValue((Object)PlanDefinition.ActionRelationshipType.CONCURRENTWITHSTART);
                break;
            }
            case CONCURRENT: {
                tgt.setValue((Object)PlanDefinition.ActionRelationshipType.CONCURRENT);
                break;
            }
            case CONCURRENTWITHEND: {
                tgt.setValue((Object)PlanDefinition.ActionRelationshipType.CONCURRENTWITHEND);
                break;
            }
            case AFTERSTART: {
                tgt.setValue((Object)PlanDefinition.ActionRelationshipType.AFTERSTART);
                break;
            }
            case AFTER: {
                tgt.setValue((Object)PlanDefinition.ActionRelationshipType.AFTER);
                break;
            }
            case AFTEREND: {
                tgt.setValue((Object)PlanDefinition.ActionRelationshipType.AFTEREND);
                break;
            }
            default: {
                tgt.setValue((Object)PlanDefinition.ActionRelationshipType.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<PlanDefinition.ActionRelationshipType> convertActionRelationshipType(Enumeration<PlanDefinition.ActionRelationshipType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<PlanDefinition.ActionRelationshipType> tgt = new org.hl7.fhir.dstu3.model.Enumeration<PlanDefinition.ActionRelationshipType>(new PlanDefinition.ActionRelationshipTypeEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((PlanDefinition.ActionRelationshipType)((Object)src.getValue())) {
            case BEFORESTART: {
                tgt.setValue((Object)PlanDefinition.ActionRelationshipType.BEFORESTART);
                break;
            }
            case BEFORE: {
                tgt.setValue((Object)PlanDefinition.ActionRelationshipType.BEFORE);
                break;
            }
            case BEFOREEND: {
                tgt.setValue((Object)PlanDefinition.ActionRelationshipType.BEFOREEND);
                break;
            }
            case CONCURRENTWITHSTART: {
                tgt.setValue((Object)PlanDefinition.ActionRelationshipType.CONCURRENTWITHSTART);
                break;
            }
            case CONCURRENT: {
                tgt.setValue((Object)PlanDefinition.ActionRelationshipType.CONCURRENT);
                break;
            }
            case CONCURRENTWITHEND: {
                tgt.setValue((Object)PlanDefinition.ActionRelationshipType.CONCURRENTWITHEND);
                break;
            }
            case AFTERSTART: {
                tgt.setValue((Object)PlanDefinition.ActionRelationshipType.AFTERSTART);
                break;
            }
            case AFTER: {
                tgt.setValue((Object)PlanDefinition.ActionRelationshipType.AFTER);
                break;
            }
            case AFTEREND: {
                tgt.setValue((Object)PlanDefinition.ActionRelationshipType.AFTEREND);
                break;
            }
            default: {
                tgt.setValue((Object)PlanDefinition.ActionRelationshipType.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<PlanDefinition.ActionRequiredBehavior> convertActionRequiredBehavior(Enumeration<PlanDefinition.ActionRequiredBehavior> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<PlanDefinition.ActionRequiredBehavior> tgt = new org.hl7.fhir.dstu3.model.Enumeration<PlanDefinition.ActionRequiredBehavior>(new PlanDefinition.ActionRequiredBehaviorEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((PlanDefinition.ActionRequiredBehavior)((Object)src.getValue())) {
            case MUST: {
                tgt.setValue((Object)PlanDefinition.ActionRequiredBehavior.MUST);
                break;
            }
            case COULD: {
                tgt.setValue((Object)PlanDefinition.ActionRequiredBehavior.COULD);
                break;
            }
            case MUSTUNLESSDOCUMENTED: {
                tgt.setValue((Object)PlanDefinition.ActionRequiredBehavior.MUSTUNLESSDOCUMENTED);
                break;
            }
            default: {
                tgt.setValue((Object)PlanDefinition.ActionRequiredBehavior.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<PlanDefinition.ActionRequiredBehavior> convertActionRequiredBehavior(org.hl7.fhir.dstu3.model.Enumeration<PlanDefinition.ActionRequiredBehavior> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<PlanDefinition.ActionRequiredBehavior> tgt = new Enumeration<PlanDefinition.ActionRequiredBehavior>(new PlanDefinition.ActionRequiredBehaviorEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((PlanDefinition.ActionRequiredBehavior)((Object)src.getValue())) {
            case MUST: {
                tgt.setValue((Object)PlanDefinition.ActionRequiredBehavior.MUST);
                break;
            }
            case COULD: {
                tgt.setValue((Object)PlanDefinition.ActionRequiredBehavior.COULD);
                break;
            }
            case MUSTUNLESSDOCUMENTED: {
                tgt.setValue((Object)PlanDefinition.ActionRequiredBehavior.MUSTUNLESSDOCUMENTED);
                break;
            }
            default: {
                tgt.setValue((Object)PlanDefinition.ActionRequiredBehavior.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<PlanDefinition.ActionSelectionBehavior> convertActionSelectionBehavior(org.hl7.fhir.dstu3.model.Enumeration<PlanDefinition.ActionSelectionBehavior> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<PlanDefinition.ActionSelectionBehavior> tgt = new Enumeration<PlanDefinition.ActionSelectionBehavior>(new PlanDefinition.ActionSelectionBehaviorEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((PlanDefinition.ActionSelectionBehavior)((Object)src.getValue())) {
            case ANY: {
                tgt.setValue((Object)PlanDefinition.ActionSelectionBehavior.ANY);
                break;
            }
            case ALL: {
                tgt.setValue((Object)PlanDefinition.ActionSelectionBehavior.ALL);
                break;
            }
            case ALLORNONE: {
                tgt.setValue((Object)PlanDefinition.ActionSelectionBehavior.ALLORNONE);
                break;
            }
            case EXACTLYONE: {
                tgt.setValue((Object)PlanDefinition.ActionSelectionBehavior.EXACTLYONE);
                break;
            }
            case ATMOSTONE: {
                tgt.setValue((Object)PlanDefinition.ActionSelectionBehavior.ATMOSTONE);
                break;
            }
            case ONEORMORE: {
                tgt.setValue((Object)PlanDefinition.ActionSelectionBehavior.ONEORMORE);
                break;
            }
            default: {
                tgt.setValue((Object)PlanDefinition.ActionSelectionBehavior.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<PlanDefinition.ActionSelectionBehavior> convertActionSelectionBehavior(Enumeration<PlanDefinition.ActionSelectionBehavior> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<PlanDefinition.ActionSelectionBehavior> tgt = new org.hl7.fhir.dstu3.model.Enumeration<PlanDefinition.ActionSelectionBehavior>(new PlanDefinition.ActionSelectionBehaviorEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((PlanDefinition.ActionSelectionBehavior)((Object)src.getValue())) {
            case ANY: {
                tgt.setValue((Object)PlanDefinition.ActionSelectionBehavior.ANY);
                break;
            }
            case ALL: {
                tgt.setValue((Object)PlanDefinition.ActionSelectionBehavior.ALL);
                break;
            }
            case ALLORNONE: {
                tgt.setValue((Object)PlanDefinition.ActionSelectionBehavior.ALLORNONE);
                break;
            }
            case EXACTLYONE: {
                tgt.setValue((Object)PlanDefinition.ActionSelectionBehavior.EXACTLYONE);
                break;
            }
            case ATMOSTONE: {
                tgt.setValue((Object)PlanDefinition.ActionSelectionBehavior.ATMOSTONE);
                break;
            }
            case ONEORMORE: {
                tgt.setValue((Object)PlanDefinition.ActionSelectionBehavior.ONEORMORE);
                break;
            }
            default: {
                tgt.setValue((Object)PlanDefinition.ActionSelectionBehavior.NULL);
            }
        }
        return tgt;
    }

    public static PlanDefinition convertPlanDefinition(org.hl7.fhir.dstu3.model.PlanDefinition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        PlanDefinition tgt = new PlanDefinition();
        VersionConvertor_30_40.copyDomainResource(src, tgt, new String[0]);
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_30_40.convertUri(src.getUrlElement()));
        }
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(identifier));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_30_40.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_40.convertString(src.getNameElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(VersionConvertor_30_40.convertString(src.getTitleElement()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertCodeableConcept(src.getType()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((Enumeration)VersionConvertor_30_40.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_30_40.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasDateElement()) {
            tgt.setDateElement(VersionConvertor_30_40.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(VersionConvertor_30_40.convertString(src.getPublisherElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_40.convertMarkdown(src.getDescriptionElement()));
        }
        if (src.hasPurpose()) {
            tgt.setPurposeElement(VersionConvertor_30_40.convertMarkdown(src.getPurposeElement()));
        }
        if (src.hasUsage()) {
            tgt.setUsageElement(VersionConvertor_30_40.convertString(src.getUsageElement()));
        }
        if (src.hasApprovalDate()) {
            tgt.setApprovalDateElement(VersionConvertor_30_40.convertDate(src.getApprovalDateElement()));
        }
        if (src.hasLastReviewDate()) {
            tgt.setLastReviewDateElement(VersionConvertor_30_40.convertDate(src.getLastReviewDateElement()));
        }
        if (src.hasEffectivePeriod()) {
            tgt.setEffectivePeriod(VersionConvertor_30_40.convertPeriod(src.getEffectivePeriod()));
        }
        for (org.hl7.fhir.dstu3.model.UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(VersionConvertor_30_40.convertUsageContext(usageContext));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addJurisdiction(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getTopic()) {
            tgt.addTopic(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        for (Contributor contributor : src.getContributor()) {
            if (contributor.getType() == Contributor.ContributorType.AUTHOR) {
                for (ContactDetail c : contributor.getContact()) {
                    tgt.addAuthor(VersionConvertor_30_40.convertContactDetail(c));
                }
            }
            if (contributor.getType() == Contributor.ContributorType.EDITOR) {
                for (ContactDetail c : contributor.getContact()) {
                    tgt.addEditor(VersionConvertor_30_40.convertContactDetail(c));
                }
            }
            if (contributor.getType() == Contributor.ContributorType.REVIEWER) {
                for (ContactDetail c : contributor.getContact()) {
                    tgt.addReviewer(VersionConvertor_30_40.convertContactDetail(c));
                }
            }
            if (contributor.getType() != Contributor.ContributorType.ENDORSER) continue;
            for (ContactDetail c : contributor.getContact()) {
                tgt.addEndorser(VersionConvertor_30_40.convertContactDetail(c));
            }
        }
        for (ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(VersionConvertor_30_40.convertContactDetail(contactDetail));
        }
        if (src.hasCopyright()) {
            tgt.setCopyrightElement(VersionConvertor_30_40.convertMarkdown(src.getCopyrightElement()));
        }
        for (RelatedArtifact relatedArtifact : src.getRelatedArtifact()) {
            tgt.addRelatedArtifact(VersionConvertor_30_40.convertRelatedArtifact(relatedArtifact));
        }
        for (Reference reference : src.getLibrary()) {
            tgt.getLibrary().add(VersionConvertor_30_40.convertReferenceToCanonical(reference));
        }
        for (PlanDefinition.PlanDefinitionGoalComponent planDefinitionGoalComponent : src.getGoal()) {
            tgt.addGoal(PlanDefinition30_40.convertPlanDefinitionGoalComponent(planDefinitionGoalComponent));
        }
        for (PlanDefinition.PlanDefinitionActionComponent planDefinitionActionComponent : src.getAction()) {
            tgt.addAction(PlanDefinition30_40.convertPlanDefinitionActionComponent(planDefinitionActionComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.PlanDefinition convertPlanDefinition(PlanDefinition src) throws FHIRException {
        Contributor c;
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.PlanDefinition tgt = new org.hl7.fhir.dstu3.model.PlanDefinition();
        VersionConvertor_30_40.copyDomainResource(src, tgt, new String[0]);
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_30_40.convertUri(src.getUrlElement()));
        }
        for (org.hl7.fhir.r4.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(identifier));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_30_40.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_40.convertString(src.getNameElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(VersionConvertor_30_40.convertString(src.getTitleElement()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertCodeableConcept(src.getType()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((org.hl7.fhir.dstu3.model.Enumeration)VersionConvertor_30_40.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_30_40.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasDateElement()) {
            tgt.setDateElement(VersionConvertor_30_40.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(VersionConvertor_30_40.convertString(src.getPublisherElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_40.convertMarkdown(src.getDescriptionElement()));
        }
        if (src.hasPurpose()) {
            tgt.setPurposeElement(VersionConvertor_30_40.convertMarkdown(src.getPurposeElement()));
        }
        if (src.hasUsage()) {
            tgt.setUsageElement(VersionConvertor_30_40.convertString(src.getUsageElement()));
        }
        if (src.hasApprovalDate()) {
            tgt.setApprovalDateElement(VersionConvertor_30_40.convertDate(src.getApprovalDateElement()));
        }
        if (src.hasLastReviewDate()) {
            tgt.setLastReviewDateElement(VersionConvertor_30_40.convertDate(src.getLastReviewDateElement()));
        }
        if (src.hasEffectivePeriod()) {
            tgt.setEffectivePeriod(VersionConvertor_30_40.convertPeriod(src.getEffectivePeriod()));
        }
        for (UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(VersionConvertor_30_40.convertUsageContext(usageContext));
        }
        for (CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addJurisdiction(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        for (CodeableConcept codeableConcept : src.getTopic()) {
            tgt.addTopic(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.ContactDetail contactDetail : src.getAuthor()) {
            c = new Contributor();
            c.setType(Contributor.ContributorType.AUTHOR);
            c.addContact(VersionConvertor_30_40.convertContactDetail(contactDetail));
            tgt.addContributor(c);
        }
        for (org.hl7.fhir.r4.model.ContactDetail contactDetail : src.getEditor()) {
            c = new Contributor();
            c.setType(Contributor.ContributorType.EDITOR);
            c.addContact(VersionConvertor_30_40.convertContactDetail(contactDetail));
            tgt.addContributor(c);
        }
        for (org.hl7.fhir.r4.model.ContactDetail contactDetail : src.getReviewer()) {
            c = new Contributor();
            c.setType(Contributor.ContributorType.REVIEWER);
            c.addContact(VersionConvertor_30_40.convertContactDetail(contactDetail));
            tgt.addContributor(c);
        }
        for (org.hl7.fhir.r4.model.ContactDetail contactDetail : src.getEndorser()) {
            c = new Contributor();
            c.setType(Contributor.ContributorType.ENDORSER);
            c.addContact(VersionConvertor_30_40.convertContactDetail(contactDetail));
            tgt.addContributor(c);
        }
        for (org.hl7.fhir.r4.model.ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(VersionConvertor_30_40.convertContactDetail(contactDetail));
        }
        if (src.hasCopyright()) {
            tgt.setCopyrightElement(VersionConvertor_30_40.convertMarkdown(src.getCopyrightElement()));
        }
        for (org.hl7.fhir.r4.model.RelatedArtifact relatedArtifact : src.getRelatedArtifact()) {
            tgt.addRelatedArtifact(VersionConvertor_30_40.convertRelatedArtifact(relatedArtifact));
        }
        for (CanonicalType canonicalType : src.getLibrary()) {
            tgt.addLibrary(VersionConvertor_30_40.convertCanonicalToReference(canonicalType));
        }
        for (PlanDefinition.PlanDefinitionGoalComponent planDefinitionGoalComponent : src.getGoal()) {
            tgt.addGoal(PlanDefinition30_40.convertPlanDefinitionGoalComponent(planDefinitionGoalComponent));
        }
        for (PlanDefinition.PlanDefinitionActionComponent planDefinitionActionComponent : src.getAction()) {
            tgt.addAction(PlanDefinition30_40.convertPlanDefinitionActionComponent(planDefinitionActionComponent));
        }
        return tgt;
    }

    public static PlanDefinition.PlanDefinitionActionComponent convertPlanDefinitionActionComponent(PlanDefinition.PlanDefinitionActionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        PlanDefinition.PlanDefinitionActionComponent tgt = new PlanDefinition.PlanDefinitionActionComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasLabel()) {
            tgt.setPrefixElement(VersionConvertor_30_40.convertString(src.getLabelElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(VersionConvertor_30_40.convertString(src.getTitleElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_40.convertString(src.getDescriptionElement()));
        }
        if (src.hasTextEquivalent()) {
            tgt.setTextEquivalentElement(VersionConvertor_30_40.convertString(src.getTextEquivalentElement()));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getCode()) {
            tgt.addCode(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getReason()) {
            tgt.addReason(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        for (RelatedArtifact relatedArtifact : src.getDocumentation()) {
            tgt.addDocumentation(VersionConvertor_30_40.convertRelatedArtifact(relatedArtifact));
        }
        for (IdType idType : src.getGoalId()) {
            tgt.addGoalId(idType.getValue());
        }
        for (org.hl7.fhir.dstu3.model.TriggerDefinition triggerDefinition : src.getTriggerDefinition()) {
            tgt.addTrigger(VersionConvertor_30_40.convertTriggerDefinition(triggerDefinition));
        }
        for (PlanDefinition.PlanDefinitionActionConditionComponent planDefinitionActionConditionComponent : src.getCondition()) {
            tgt.addCondition(PlanDefinition30_40.convertPlanDefinitionActionConditionComponent(planDefinitionActionConditionComponent));
        }
        for (DataRequirement dataRequirement : src.getInput()) {
            tgt.addInput(VersionConvertor_30_40.convertDataRequirement(dataRequirement));
        }
        for (DataRequirement dataRequirement : src.getOutput()) {
            tgt.addOutput(VersionConvertor_30_40.convertDataRequirement(dataRequirement));
        }
        for (PlanDefinition.PlanDefinitionActionRelatedActionComponent planDefinitionActionRelatedActionComponent : src.getRelatedAction()) {
            tgt.addRelatedAction(PlanDefinition30_40.convertPlanDefinitionActionRelatedActionComponent(planDefinitionActionRelatedActionComponent));
        }
        if (src.hasTiming()) {
            tgt.setTiming(VersionConvertor_30_40.convertType(src.getTiming()));
        }
        for (PlanDefinition.PlanDefinitionActionParticipantComponent planDefinitionActionParticipantComponent : src.getParticipant()) {
            tgt.addParticipant(PlanDefinition30_40.convertPlanDefinitionActionParticipantComponent(planDefinitionActionParticipantComponent));
        }
        if (src.hasType()) {
            tgt.getType().addCoding(VersionConvertor_30_40.convertCoding(src.getType()));
        }
        if (src.hasGroupingBehavior()) {
            tgt.setGroupingBehaviorElement(PlanDefinition30_40.convertActionGroupingBehavior(src.getGroupingBehaviorElement()));
        }
        if (src.hasSelectionBehavior()) {
            tgt.setSelectionBehaviorElement(PlanDefinition30_40.convertActionSelectionBehavior(src.getSelectionBehaviorElement()));
        }
        if (src.hasRequiredBehavior()) {
            tgt.setRequiredBehaviorElement(PlanDefinition30_40.convertActionRequiredBehavior(src.getRequiredBehaviorElement()));
        }
        if (src.hasPrecheckBehavior()) {
            tgt.setPrecheckBehaviorElement(PlanDefinition30_40.convertActionPrecheckBehavior(src.getPrecheckBehaviorElement()));
        }
        if (src.hasCardinalityBehavior()) {
            tgt.setCardinalityBehaviorElement(PlanDefinition30_40.convertActionCardinalityBehavior(src.getCardinalityBehaviorElement()));
        }
        if (src.hasDefinition()) {
            tgt.setDefinition(VersionConvertor_30_40.convertReferenceToCanonical(src.getDefinition()));
        }
        if (src.hasTransform()) {
            tgt.setTransformElement(VersionConvertor_30_40.convertReferenceToCanonical(src.getTransform()));
        }
        for (PlanDefinition.PlanDefinitionActionDynamicValueComponent planDefinitionActionDynamicValueComponent : src.getDynamicValue()) {
            tgt.addDynamicValue(PlanDefinition30_40.convertPlanDefinitionActionDynamicValueComponent(planDefinitionActionDynamicValueComponent));
        }
        for (PlanDefinition.PlanDefinitionActionComponent planDefinitionActionComponent : src.getAction()) {
            tgt.addAction(PlanDefinition30_40.convertPlanDefinitionActionComponent(planDefinitionActionComponent));
        }
        return tgt;
    }

    public static PlanDefinition.PlanDefinitionActionComponent convertPlanDefinitionActionComponent(PlanDefinition.PlanDefinitionActionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        PlanDefinition.PlanDefinitionActionComponent tgt = new PlanDefinition.PlanDefinitionActionComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasPrefix()) {
            tgt.setLabelElement(VersionConvertor_30_40.convertString(src.getPrefixElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(VersionConvertor_30_40.convertString(src.getTitleElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_40.convertString(src.getDescriptionElement()));
        }
        if (src.hasTextEquivalent()) {
            tgt.setTextEquivalentElement(VersionConvertor_30_40.convertString(src.getTextEquivalentElement()));
        }
        for (CodeableConcept codeableConcept : src.getCode()) {
            tgt.addCode(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        for (CodeableConcept codeableConcept : src.getReason()) {
            tgt.addReason(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.RelatedArtifact relatedArtifact : src.getDocumentation()) {
            tgt.addDocumentation(VersionConvertor_30_40.convertRelatedArtifact(relatedArtifact));
        }
        for (org.hl7.fhir.r4.model.IdType idType : src.getGoalId()) {
            tgt.addGoalId(idType.getValue());
        }
        for (TriggerDefinition triggerDefinition : src.getTrigger()) {
            tgt.addTriggerDefinition(VersionConvertor_30_40.convertTriggerDefinition(triggerDefinition));
        }
        for (PlanDefinition.PlanDefinitionActionConditionComponent planDefinitionActionConditionComponent : src.getCondition()) {
            tgt.addCondition(PlanDefinition30_40.convertPlanDefinitionActionConditionComponent(planDefinitionActionConditionComponent));
        }
        for (org.hl7.fhir.r4.model.DataRequirement dataRequirement : src.getInput()) {
            tgt.addInput(VersionConvertor_30_40.convertDataRequirement(dataRequirement));
        }
        for (org.hl7.fhir.r4.model.DataRequirement dataRequirement : src.getOutput()) {
            tgt.addOutput(VersionConvertor_30_40.convertDataRequirement(dataRequirement));
        }
        for (PlanDefinition.PlanDefinitionActionRelatedActionComponent planDefinitionActionRelatedActionComponent : src.getRelatedAction()) {
            tgt.addRelatedAction(PlanDefinition30_40.convertPlanDefinitionActionRelatedActionComponent(planDefinitionActionRelatedActionComponent));
        }
        if (src.hasTiming()) {
            tgt.setTiming(VersionConvertor_30_40.convertType(src.getTiming()));
        }
        for (PlanDefinition.PlanDefinitionActionParticipantComponent planDefinitionActionParticipantComponent : src.getParticipant()) {
            tgt.addParticipant(PlanDefinition30_40.convertPlanDefinitionActionParticipantComponent(planDefinitionActionParticipantComponent));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertCoding(src.getType().getCodingFirstRep()));
        }
        if (src.hasGroupingBehavior()) {
            tgt.setGroupingBehaviorElement(PlanDefinition30_40.convertActionGroupingBehavior(src.getGroupingBehaviorElement()));
        }
        if (src.hasSelectionBehavior()) {
            tgt.setSelectionBehaviorElement(PlanDefinition30_40.convertActionSelectionBehavior(src.getSelectionBehaviorElement()));
        }
        if (src.hasRequiredBehavior()) {
            tgt.setRequiredBehaviorElement(PlanDefinition30_40.convertActionRequiredBehavior(src.getRequiredBehaviorElement()));
        }
        if (src.hasPrecheckBehavior()) {
            tgt.setPrecheckBehaviorElement(PlanDefinition30_40.convertActionPrecheckBehavior(src.getPrecheckBehaviorElement()));
        }
        if (src.hasCardinalityBehavior()) {
            tgt.setCardinalityBehaviorElement(PlanDefinition30_40.convertActionCardinalityBehavior(src.getCardinalityBehaviorElement()));
        }
        if (src.hasDefinitionCanonicalType()) {
            tgt.setDefinition(VersionConvertor_30_40.convertCanonicalToReference(src.getDefinitionCanonicalType()));
        }
        if (src.hasTransform()) {
            tgt.setTransform(VersionConvertor_30_40.convertCanonicalToReference(src.getTransformElement()));
        }
        for (PlanDefinition.PlanDefinitionActionDynamicValueComponent planDefinitionActionDynamicValueComponent : src.getDynamicValue()) {
            tgt.addDynamicValue(PlanDefinition30_40.convertPlanDefinitionActionDynamicValueComponent(planDefinitionActionDynamicValueComponent));
        }
        for (PlanDefinition.PlanDefinitionActionComponent planDefinitionActionComponent : src.getAction()) {
            tgt.addAction(PlanDefinition30_40.convertPlanDefinitionActionComponent(planDefinitionActionComponent));
        }
        return tgt;
    }

    public static PlanDefinition.PlanDefinitionActionConditionComponent convertPlanDefinitionActionConditionComponent(PlanDefinition.PlanDefinitionActionConditionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        PlanDefinition.PlanDefinitionActionConditionComponent tgt = new PlanDefinition.PlanDefinitionActionConditionComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasKind()) {
            tgt.setKindElement(PlanDefinition30_40.convertActionConditionKind(src.getKindElement()));
        }
        if (src.hasDescription()) {
            tgt.getExpression().setDescription(src.getDescription());
        }
        if (src.hasLanguage()) {
            tgt.getExpression().setLanguage(src.getLanguage());
        }
        if (src.hasExpression()) {
            tgt.getExpression().setExpression(src.getExpression());
        }
        return tgt;
    }

    public static PlanDefinition.PlanDefinitionActionConditionComponent convertPlanDefinitionActionConditionComponent(PlanDefinition.PlanDefinitionActionConditionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        PlanDefinition.PlanDefinitionActionConditionComponent tgt = new PlanDefinition.PlanDefinitionActionConditionComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasKind()) {
            tgt.setKindElement(PlanDefinition30_40.convertActionConditionKind(src.getKindElement()));
        }
        if (src.getExpression().hasDescription()) {
            tgt.setDescription(src.getExpression().getDescription());
        }
        if (src.getExpression().hasLanguage()) {
            tgt.setLanguage(src.getExpression().getLanguage());
        }
        if (src.getExpression().hasExpression()) {
            tgt.setExpression(src.getExpression().getExpression());
        }
        return tgt;
    }

    public static PlanDefinition.PlanDefinitionActionDynamicValueComponent convertPlanDefinitionActionDynamicValueComponent(PlanDefinition.PlanDefinitionActionDynamicValueComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        PlanDefinition.PlanDefinitionActionDynamicValueComponent tgt = new PlanDefinition.PlanDefinitionActionDynamicValueComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasDescription()) {
            tgt.getExpression().setDescription(src.getDescription());
        }
        if (src.hasPath()) {
            tgt.setPathElement(VersionConvertor_30_40.convertString(src.getPathElement()));
        }
        if (src.hasLanguage()) {
            tgt.getExpression().setLanguage(src.getLanguage());
        }
        if (src.hasExpression()) {
            tgt.getExpression().setExpression(src.getExpression());
        }
        return tgt;
    }

    public static PlanDefinition.PlanDefinitionActionDynamicValueComponent convertPlanDefinitionActionDynamicValueComponent(PlanDefinition.PlanDefinitionActionDynamicValueComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        PlanDefinition.PlanDefinitionActionDynamicValueComponent tgt = new PlanDefinition.PlanDefinitionActionDynamicValueComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.getExpression().hasDescription()) {
            tgt.setDescription(src.getExpression().getDescription());
        }
        if (src.hasPath()) {
            tgt.setPathElement(VersionConvertor_30_40.convertString(src.getPathElement()));
        }
        if (src.getExpression().hasLanguage()) {
            tgt.setLanguage(src.getExpression().getLanguage());
        }
        if (src.getExpression().hasExpression()) {
            tgt.setExpression(src.getExpression().getExpression());
        }
        return tgt;
    }

    public static PlanDefinition.PlanDefinitionActionParticipantComponent convertPlanDefinitionActionParticipantComponent(PlanDefinition.PlanDefinitionActionParticipantComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        PlanDefinition.PlanDefinitionActionParticipantComponent tgt = new PlanDefinition.PlanDefinitionActionParticipantComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(PlanDefinition30_40.convertActionParticipantType(src.getTypeElement()));
        }
        if (src.hasRole()) {
            tgt.setRole(VersionConvertor_30_40.convertCodeableConcept(src.getRole()));
        }
        return tgt;
    }

    public static PlanDefinition.PlanDefinitionActionParticipantComponent convertPlanDefinitionActionParticipantComponent(PlanDefinition.PlanDefinitionActionParticipantComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        PlanDefinition.PlanDefinitionActionParticipantComponent tgt = new PlanDefinition.PlanDefinitionActionParticipantComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(PlanDefinition30_40.convertActionParticipantType(src.getTypeElement()));
        }
        if (src.hasRole()) {
            tgt.setRole(VersionConvertor_30_40.convertCodeableConcept(src.getRole()));
        }
        return tgt;
    }

    public static PlanDefinition.PlanDefinitionActionRelatedActionComponent convertPlanDefinitionActionRelatedActionComponent(PlanDefinition.PlanDefinitionActionRelatedActionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        PlanDefinition.PlanDefinitionActionRelatedActionComponent tgt = new PlanDefinition.PlanDefinitionActionRelatedActionComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasActionId()) {
            tgt.setActionIdElement(VersionConvertor_30_40.convertId(src.getActionIdElement()));
        }
        if (src.hasRelationship()) {
            tgt.setRelationshipElement(PlanDefinition30_40.convertActionRelationshipType(src.getRelationshipElement()));
        }
        if (src.hasOffset()) {
            tgt.setOffset(VersionConvertor_30_40.convertType(src.getOffset()));
        }
        return tgt;
    }

    public static PlanDefinition.PlanDefinitionActionRelatedActionComponent convertPlanDefinitionActionRelatedActionComponent(PlanDefinition.PlanDefinitionActionRelatedActionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        PlanDefinition.PlanDefinitionActionRelatedActionComponent tgt = new PlanDefinition.PlanDefinitionActionRelatedActionComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasActionId()) {
            tgt.setActionIdElement(VersionConvertor_30_40.convertId(src.getActionIdElement()));
        }
        if (src.hasRelationship()) {
            tgt.setRelationshipElement(PlanDefinition30_40.convertActionRelationshipType(src.getRelationshipElement()));
        }
        if (src.hasOffset()) {
            tgt.setOffset(VersionConvertor_30_40.convertType(src.getOffset()));
        }
        return tgt;
    }

    public static PlanDefinition.PlanDefinitionGoalComponent convertPlanDefinitionGoalComponent(PlanDefinition.PlanDefinitionGoalComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        PlanDefinition.PlanDefinitionGoalComponent tgt = new PlanDefinition.PlanDefinitionGoalComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasCategory()) {
            tgt.setCategory(VersionConvertor_30_40.convertCodeableConcept(src.getCategory()));
        }
        if (src.hasDescription()) {
            tgt.setDescription(VersionConvertor_30_40.convertCodeableConcept(src.getDescription()));
        }
        if (src.hasPriority()) {
            tgt.setPriority(VersionConvertor_30_40.convertCodeableConcept(src.getPriority()));
        }
        if (src.hasStart()) {
            tgt.setStart(VersionConvertor_30_40.convertCodeableConcept(src.getStart()));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getAddresses()) {
            tgt.addAddresses(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        for (RelatedArtifact relatedArtifact : src.getDocumentation()) {
            tgt.addDocumentation(VersionConvertor_30_40.convertRelatedArtifact(relatedArtifact));
        }
        for (PlanDefinition.PlanDefinitionGoalTargetComponent planDefinitionGoalTargetComponent : src.getTarget()) {
            tgt.addTarget(PlanDefinition30_40.convertPlanDefinitionGoalTargetComponent(planDefinitionGoalTargetComponent));
        }
        return tgt;
    }

    public static PlanDefinition.PlanDefinitionGoalComponent convertPlanDefinitionGoalComponent(PlanDefinition.PlanDefinitionGoalComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        PlanDefinition.PlanDefinitionGoalComponent tgt = new PlanDefinition.PlanDefinitionGoalComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasCategory()) {
            tgt.setCategory(VersionConvertor_30_40.convertCodeableConcept(src.getCategory()));
        }
        if (src.hasDescription()) {
            tgt.setDescription(VersionConvertor_30_40.convertCodeableConcept(src.getDescription()));
        }
        if (src.hasPriority()) {
            tgt.setPriority(VersionConvertor_30_40.convertCodeableConcept(src.getPriority()));
        }
        if (src.hasStart()) {
            tgt.setStart(VersionConvertor_30_40.convertCodeableConcept(src.getStart()));
        }
        for (CodeableConcept codeableConcept : src.getAddresses()) {
            tgt.addAddresses(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.RelatedArtifact relatedArtifact : src.getDocumentation()) {
            tgt.addDocumentation(VersionConvertor_30_40.convertRelatedArtifact(relatedArtifact));
        }
        for (PlanDefinition.PlanDefinitionGoalTargetComponent planDefinitionGoalTargetComponent : src.getTarget()) {
            tgt.addTarget(PlanDefinition30_40.convertPlanDefinitionGoalTargetComponent(planDefinitionGoalTargetComponent));
        }
        return tgt;
    }

    public static PlanDefinition.PlanDefinitionGoalTargetComponent convertPlanDefinitionGoalTargetComponent(PlanDefinition.PlanDefinitionGoalTargetComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        PlanDefinition.PlanDefinitionGoalTargetComponent tgt = new PlanDefinition.PlanDefinitionGoalTargetComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasMeasure()) {
            tgt.setMeasure(VersionConvertor_30_40.convertCodeableConcept(src.getMeasure()));
        }
        if (src.hasDetail()) {
            tgt.setDetail(VersionConvertor_30_40.convertType(src.getDetail()));
        }
        if (src.hasDue()) {
            tgt.setDue(VersionConvertor_30_40.convertDuration(src.getDue()));
        }
        return tgt;
    }

    public static PlanDefinition.PlanDefinitionGoalTargetComponent convertPlanDefinitionGoalTargetComponent(PlanDefinition.PlanDefinitionGoalTargetComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        PlanDefinition.PlanDefinitionGoalTargetComponent tgt = new PlanDefinition.PlanDefinitionGoalTargetComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasMeasure()) {
            tgt.setMeasure(VersionConvertor_30_40.convertCodeableConcept(src.getMeasure()));
        }
        if (src.hasDetail()) {
            tgt.setDetail(VersionConvertor_30_40.convertType(src.getDetail()));
        }
        if (src.hasDue()) {
            tgt.setDue(VersionConvertor_30_40.convertDuration(src.getDue()));
        }
        return tgt;
    }
}

