/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_40;

import org.hl7.fhir.convertors.VersionConvertor_30_40;
import org.hl7.fhir.dstu3.model.Medication;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Medication;

public class Medication30_40 {
    public static org.hl7.fhir.r4.model.Medication convertMedication(Medication src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.Medication tgt = new org.hl7.fhir.r4.model.Medication();
        VersionConvertor_30_40.copyDomainResource(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertCodeableConcept(src.getCode()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Medication30_40.convertMedicationStatus(src.getStatusElement()));
        }
        if (src.hasManufacturer()) {
            tgt.setManufacturer(VersionConvertor_30_40.convertReference(src.getManufacturer()));
        }
        if (src.hasForm()) {
            tgt.setForm(VersionConvertor_30_40.convertCodeableConcept(src.getForm()));
        }
        for (Medication.MedicationIngredientComponent t : src.getIngredient()) {
            tgt.addIngredient(Medication30_40.convertMedicationIngredientComponent(t));
        }
        if (src.hasPackage()) {
            tgt.setBatch(Medication30_40.convertMedicationPackageBatchComponent(src.getPackage().getBatchFirstRep()));
        }
        return tgt;
    }

    public static Medication convertMedication(org.hl7.fhir.r4.model.Medication src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Medication tgt = new Medication();
        VersionConvertor_30_40.copyDomainResource(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertCodeableConcept(src.getCode()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Medication30_40.convertMedicationStatus(src.getStatusElement()));
        }
        if (src.hasManufacturer()) {
            tgt.setManufacturer(VersionConvertor_30_40.convertReference(src.getManufacturer()));
        }
        if (src.hasForm()) {
            tgt.setForm(VersionConvertor_30_40.convertCodeableConcept(src.getForm()));
        }
        for (Medication.MedicationIngredientComponent t : src.getIngredient()) {
            tgt.addIngredient(Medication30_40.convertMedicationIngredientComponent(t));
        }
        if (src.hasBatch()) {
            tgt.getPackage().addBatch(Medication30_40.convertMedicationPackageBatchComponent(src.getBatch()));
        }
        return tgt;
    }

    public static Medication.MedicationIngredientComponent convertMedicationIngredientComponent(Medication.MedicationIngredientComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Medication.MedicationIngredientComponent tgt = new Medication.MedicationIngredientComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasItem()) {
            tgt.setItem(VersionConvertor_30_40.convertType(src.getItem()));
        }
        if (src.hasIsActive()) {
            tgt.setIsActiveElement(VersionConvertor_30_40.convertBoolean(src.getIsActiveElement()));
        }
        if (src.hasStrength()) {
            tgt.setAmount(VersionConvertor_30_40.convertRatio(src.getStrength()));
        }
        return tgt;
    }

    public static Medication.MedicationIngredientComponent convertMedicationIngredientComponent(Medication.MedicationIngredientComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Medication.MedicationIngredientComponent tgt = new Medication.MedicationIngredientComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasItem()) {
            tgt.setItem(VersionConvertor_30_40.convertType(src.getItem()));
        }
        if (src.hasIsActive()) {
            tgt.setIsActiveElement(VersionConvertor_30_40.convertBoolean(src.getIsActiveElement()));
        }
        if (src.hasAmount()) {
            tgt.setStrength(VersionConvertor_30_40.convertRatio(src.getAmount()));
        }
        return tgt;
    }

    public static Medication.MedicationPackageBatchComponent convertMedicationPackageBatchComponent(Medication.MedicationBatchComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Medication.MedicationPackageBatchComponent tgt = new Medication.MedicationPackageBatchComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasLotNumber()) {
            tgt.setLotNumberElement(VersionConvertor_30_40.convertString(src.getLotNumberElement()));
        }
        if (src.hasExpirationDate()) {
            tgt.setExpirationDateElement(VersionConvertor_30_40.convertDateTime(src.getExpirationDateElement()));
        }
        return tgt;
    }

    public static Medication.MedicationBatchComponent convertMedicationPackageBatchComponent(Medication.MedicationPackageBatchComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Medication.MedicationBatchComponent tgt = new Medication.MedicationBatchComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasLotNumber()) {
            tgt.setLotNumberElement(VersionConvertor_30_40.convertString(src.getLotNumberElement()));
        }
        if (src.hasExpirationDate()) {
            tgt.setExpirationDateElement(VersionConvertor_30_40.convertDateTime(src.getExpirationDateElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<Medication.MedicationStatus> convertMedicationStatus(Enumeration<Medication.MedicationStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<Medication.MedicationStatus> tgt = new org.hl7.fhir.dstu3.model.Enumeration<Medication.MedicationStatus>(new Medication.MedicationStatusEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((Medication.MedicationStatus)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)Medication.MedicationStatus.ACTIVE);
                break;
            }
            case INACTIVE: {
                tgt.setValue((Object)Medication.MedicationStatus.INACTIVE);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Medication.MedicationStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)Medication.MedicationStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Medication.MedicationStatus> convertMedicationStatus(org.hl7.fhir.dstu3.model.Enumeration<Medication.MedicationStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Medication.MedicationStatus> tgt = new Enumeration<Medication.MedicationStatus>(new Medication.MedicationStatusEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((Medication.MedicationStatus)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)Medication.MedicationStatus.ACTIVE);
                break;
            }
            case INACTIVE: {
                tgt.setValue((Object)Medication.MedicationStatus.INACTIVE);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Medication.MedicationStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)Medication.MedicationStatus.NULL);
            }
        }
        return tgt;
    }
}

