/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_40;

import org.hl7.fhir.dstu3.model.Enumerations;
import org.hl7.fhir.dstu3.model.ExpansionProfile;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r4.model.Type;

public class ExpansionProfile30_40 {
    public static Parameters convertExpansionProfile(ExpansionProfile src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Parameters tgt = new Parameters();
        if (src.hasUrl()) {
            tgt.addParameter("profile-url", src.getUrl());
        }
        if (src.hasVersion()) {
            tgt.addParameter("profile-version", src.getVersion());
        }
        if (src.hasName()) {
            tgt.addParameter("profile-name", src.getName());
        }
        if (src.hasStatus()) {
            tgt.addParameter("profile-status", src.getStatus().toCode());
        }
        for (ExpansionProfile.ExpansionProfileFixedVersionComponent expansionProfileFixedVersionComponent : src.getFixedVersion()) {
            if (expansionProfileFixedVersionComponent.getMode() == ExpansionProfile.SystemVersionProcessingMode.DEFAULT) {
                tgt.addParameter("system-version", expansionProfileFixedVersionComponent.getSystem() + "|" + expansionProfileFixedVersionComponent.getVersion());
                continue;
            }
            if (expansionProfileFixedVersionComponent.getMode() == ExpansionProfile.SystemVersionProcessingMode.CHECK) {
                tgt.addParameter("check-system-version", expansionProfileFixedVersionComponent.getSystem() + "|" + expansionProfileFixedVersionComponent.getVersion());
                continue;
            }
            if (expansionProfileFixedVersionComponent.getMode() != ExpansionProfile.SystemVersionProcessingMode.OVERRIDE) continue;
            tgt.addParameter("force-system-version", expansionProfileFixedVersionComponent.getSystem() + "|" + expansionProfileFixedVersionComponent.getVersion());
        }
        if (src.hasExcludedSystem()) {
            tgt.addParameter("exclude-system", src.getExcludedSystem().getSystem() + "|" + src.getExcludedSystem().getVersion());
        }
        if (src.hasIncludeDesignations()) {
            tgt.addParameter("includeDesignations", src.getIncludeDesignations());
        }
        for (ExpansionProfile.DesignationIncludeDesignationComponent designationIncludeDesignationComponent : src.getDesignation().getInclude().getDesignation()) {
            if (designationIncludeDesignationComponent.hasLanguage()) {
                tgt.addParameter("designation", "urn:ietf:bcp:47|" + designationIncludeDesignationComponent.getLanguage());
            }
            if (!designationIncludeDesignationComponent.hasUse()) continue;
            tgt.addParameter("designation", designationIncludeDesignationComponent.getUse().getSystem() + "|" + designationIncludeDesignationComponent.getUse().getCode());
        }
        if (src.hasIncludeDefinition()) {
            tgt.addParameter("includeDefinition", src.getIncludeDefinition());
        }
        if (src.hasActiveOnly()) {
            tgt.addParameter("activeOnly", src.getActiveOnly());
        }
        if (src.hasExcludeNested()) {
            tgt.addParameter("excludeNested", src.getExcludeNested());
        }
        if (src.hasExcludeNotForUI()) {
            tgt.addParameter("excludeNotForUI", src.getExcludeNotForUI());
        }
        if (src.hasExcludePostCoordinated()) {
            tgt.addParameter("excludePostCoordinated", src.getExcludePostCoordinated());
        }
        if (src.hasDisplayLanguage()) {
            tgt.addParameter("excludePostCoordinated", src.getDisplayLanguage());
        }
        if (src.hasLimitedExpansion()) {
            tgt.addParameter("limitedExpansion", src.getLimitedExpansion());
        }
        return tgt;
    }

    public static ExpansionProfile convertExpansionProfile(Parameters src) throws FHIRException {
        String[] v;
        if (src == null) {
            return null;
        }
        ExpansionProfile tgt = new ExpansionProfile();
        if (src.hasParameter("profile-url")) {
            tgt.setUrl(src.getParameter("profile-url").primitiveValue());
        }
        if (src.hasParameter("profile-version")) {
            tgt.setVersion(src.getParameter("profile-version").primitiveValue());
        }
        if (src.hasParameter("profile-name")) {
            tgt.setName(src.getParameter("profile-name").primitiveValue());
        }
        if (src.hasParameter("profile-status")) {
            tgt.setStatus(Enumerations.PublicationStatus.fromCode(src.getParameter("profile-status").primitiveValue()));
        }
        for (Type t : src.getParameters("system-version")) {
            v = t.primitiveValue().split("\\|");
            tgt.addFixedVersion().setSystem(v[0]).setVersion(v[1]).setMode(ExpansionProfile.SystemVersionProcessingMode.DEFAULT);
        }
        for (Type t : src.getParameters("force-system-version")) {
            v = t.primitiveValue().split("\\|");
            tgt.addFixedVersion().setSystem(v[0]).setVersion(v[1]).setMode(ExpansionProfile.SystemVersionProcessingMode.OVERRIDE);
        }
        for (Type t : src.getParameters("check-system-version")) {
            v = t.primitiveValue().split("\\|");
            tgt.addFixedVersion().setSystem(v[0]).setVersion(v[1]).setMode(ExpansionProfile.SystemVersionProcessingMode.CHECK);
        }
        for (Type t : src.getParameters("exclude-system")) {
            v = t.primitiveValue().split("\\|");
            tgt.getExcludedSystem().setSystem(v[0]).setVersion(v[1]);
        }
        if (src.hasParameter("includeDesignations")) {
            tgt.setIncludeDesignations(src.getParameterBool(""));
        }
        for (Type t : src.getParameters("designation")) {
            v = t.primitiveValue().split("\\|");
            if ("urn:ietf:bcp:47".equals(v[0])) {
                tgt.getDesignation().getInclude().addDesignation().setLanguage(v[1]);
                continue;
            }
            tgt.getDesignation().getInclude().addDesignation().getUse().setSystem(v[0]).setCode(v[1]);
        }
        if (src.hasParameter("includeDefinition")) {
            tgt.setIncludeDefinition(src.getParameterBool("includeDefinition"));
        }
        if (src.hasParameter("activeOnly")) {
            tgt.setActiveOnly(src.getParameterBool("activeOnly"));
        }
        if (src.hasParameter("excludeNested")) {
            tgt.setExcludeNested(src.getParameterBool("excludeNested"));
        }
        if (src.hasParameter("excludeNotForUI")) {
            tgt.setExcludeNotForUI(src.getParameterBool("excludeNotForUI"));
        }
        if (src.hasParameter("excludeNotForUI")) {
            tgt.setExcludePostCoordinated(src.getParameterBool("excludeNotForUI"));
        }
        if (src.hasParameter("displayLanguage")) {
            tgt.setDisplayLanguage(src.getParameter("displayLanguage").primitiveValue());
        }
        if (src.hasParameter("limitedExpansion")) {
            tgt.setLimitedExpansion(src.getParameterBool("getParameterBool"));
        }
        return tgt;
    }
}

