/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_40;

import org.hl7.fhir.convertors.VersionConvertor_30_40;
import org.hl7.fhir.dstu3.model.CodeType;
import org.hl7.fhir.dstu3.model.Endpoint;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.ContactPoint;
import org.hl7.fhir.r4.model.Endpoint;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.StringType;

public class Endpoint30_40 {
    public static Endpoint convertEndpoint(org.hl7.fhir.dstu3.model.Endpoint src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Endpoint tgt = new Endpoint();
        VersionConvertor_30_40.copyDomainResource(src, tgt, new String[0]);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Endpoint30_40.convertEndpointStatus(src.getStatusElement()));
        }
        if (src.hasConnectionType()) {
            tgt.setConnectionType(VersionConvertor_30_40.convertCoding(src.getConnectionType()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_40.convertString(src.getNameElement()));
        }
        if (src.hasManagingOrganization()) {
            tgt.setManagingOrganization(VersionConvertor_30_40.convertReference(src.getManagingOrganization()));
        }
        for (org.hl7.fhir.dstu3.model.ContactPoint contactPoint : src.getContact()) {
            tgt.addContact(VersionConvertor_30_40.convertContactPoint(contactPoint));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_40.convertPeriod(src.getPeriod()));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getPayloadType()) {
            tgt.addPayloadType(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        for (CodeType codeType : src.getPayloadMimeType()) {
            tgt.addPayloadMimeType((String)codeType.getValue());
        }
        if (src.hasAddress()) {
            tgt.setAddress(src.getAddress());
        }
        for (org.hl7.fhir.dstu3.model.StringType stringType : src.getHeader()) {
            tgt.addHeader((String)stringType.getValue());
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Endpoint convertEndpoint(Endpoint src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Endpoint tgt = new org.hl7.fhir.dstu3.model.Endpoint();
        VersionConvertor_30_40.copyDomainResource(src, tgt, new String[0]);
        for (org.hl7.fhir.r4.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Endpoint30_40.convertEndpointStatus(src.getStatusElement()));
        }
        if (src.hasConnectionType()) {
            tgt.setConnectionType(VersionConvertor_30_40.convertCoding(src.getConnectionType()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_40.convertString(src.getNameElement()));
        }
        if (src.hasManagingOrganization()) {
            tgt.setManagingOrganization(VersionConvertor_30_40.convertReference(src.getManagingOrganization()));
        }
        for (ContactPoint contactPoint : src.getContact()) {
            tgt.addContact(VersionConvertor_30_40.convertContactPoint(contactPoint));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_40.convertPeriod(src.getPeriod()));
        }
        for (CodeableConcept codeableConcept : src.getPayloadType()) {
            tgt.addPayloadType(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.CodeType codeType : src.getPayloadMimeType()) {
            tgt.addPayloadMimeType((String)codeType.getValue());
        }
        if (src.hasAddress()) {
            tgt.setAddress(src.getAddress());
        }
        for (StringType stringType : src.getHeader()) {
            tgt.addHeader((String)stringType.getValue());
        }
        return tgt;
    }

    public static Enumeration<Endpoint.EndpointStatus> convertEndpointStatus(org.hl7.fhir.dstu3.model.Enumeration<Endpoint.EndpointStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Endpoint.EndpointStatus> tgt = new Enumeration<Endpoint.EndpointStatus>(new Endpoint.EndpointStatusEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((Endpoint.EndpointStatus)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)Endpoint.EndpointStatus.ACTIVE);
                break;
            }
            case SUSPENDED: {
                tgt.setValue((Object)Endpoint.EndpointStatus.SUSPENDED);
                break;
            }
            case ERROR: {
                tgt.setValue((Object)Endpoint.EndpointStatus.ERROR);
                break;
            }
            case OFF: {
                tgt.setValue((Object)Endpoint.EndpointStatus.OFF);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Endpoint.EndpointStatus.ENTEREDINERROR);
                break;
            }
            case TEST: {
                tgt.setValue((Object)Endpoint.EndpointStatus.TEST);
                break;
            }
            default: {
                tgt.setValue((Object)Endpoint.EndpointStatus.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<Endpoint.EndpointStatus> convertEndpointStatus(Enumeration<Endpoint.EndpointStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<Endpoint.EndpointStatus> tgt = new org.hl7.fhir.dstu3.model.Enumeration<Endpoint.EndpointStatus>(new Endpoint.EndpointStatusEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((Endpoint.EndpointStatus)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)Endpoint.EndpointStatus.ACTIVE);
                break;
            }
            case SUSPENDED: {
                tgt.setValue((Object)Endpoint.EndpointStatus.SUSPENDED);
                break;
            }
            case ERROR: {
                tgt.setValue((Object)Endpoint.EndpointStatus.ERROR);
                break;
            }
            case OFF: {
                tgt.setValue((Object)Endpoint.EndpointStatus.OFF);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Endpoint.EndpointStatus.ENTEREDINERROR);
                break;
            }
            case TEST: {
                tgt.setValue((Object)Endpoint.EndpointStatus.TEST);
                break;
            }
            default: {
                tgt.setValue((Object)Endpoint.EndpointStatus.NULL);
            }
        }
        return tgt;
    }
}

