/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_40;

import java.util.stream.Collectors;
import org.hl7.fhir.convertors.VersionConvertor_30_40;
import org.hl7.fhir.dstu3.model.CodeSystem;
import org.hl7.fhir.dstu3.model.ContactDetail;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.CodeSystem;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.UsageContext;

public class CodeSystem30_40 {
    public static CodeSystem convertCodeSystem(org.hl7.fhir.dstu3.model.CodeSystem src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CodeSystem tgt = new CodeSystem();
        VersionConvertor_30_40.copyDomainResource(src, tgt, new String[0]);
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_30_40.convertUri(src.getUrlElement()));
        }
        if (src.hasIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_30_40.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_40.convertString(src.getNameElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(VersionConvertor_30_40.convertString(src.getTitleElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((Enumeration)VersionConvertor_30_40.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_30_40.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasDateElement()) {
            tgt.setDateElement(VersionConvertor_30_40.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(VersionConvertor_30_40.convertString(src.getPublisherElement()));
        }
        for (ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(VersionConvertor_30_40.convertContactDetail(contactDetail));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_40.convertMarkdown(src.getDescriptionElement()));
        }
        for (org.hl7.fhir.dstu3.model.UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(VersionConvertor_30_40.convertUsageContext(usageContext));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addJurisdiction(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPurpose()) {
            tgt.setPurposeElement(VersionConvertor_30_40.convertMarkdown(src.getPurposeElement()));
        }
        if (src.hasCopyright()) {
            tgt.setCopyrightElement(VersionConvertor_30_40.convertMarkdown(src.getCopyrightElement()));
        }
        if (src.hasCaseSensitive()) {
            tgt.setCaseSensitiveElement(VersionConvertor_30_40.convertBoolean(src.getCaseSensitiveElement()));
        }
        if (src.hasValueSet()) {
            tgt.setValueSet(src.getValueSet());
        }
        if (src.hasHierarchyMeaning()) {
            tgt.setHierarchyMeaningElement(CodeSystem30_40.convertCodeSystemHierarchyMeaning(src.getHierarchyMeaningElement()));
        }
        if (src.hasCompositional()) {
            tgt.setCompositionalElement(VersionConvertor_30_40.convertBoolean(src.getCompositionalElement()));
        }
        if (src.hasVersionNeeded()) {
            tgt.setVersionNeededElement(VersionConvertor_30_40.convertBoolean(src.getVersionNeededElement()));
        }
        if (src.hasContent()) {
            tgt.setContentElement(CodeSystem30_40.convertCodeSystemContentMode(src.getContentElement()));
        }
        if (src.hasCount()) {
            tgt.setCountElement(VersionConvertor_30_40.convertUnsignedInt(src.getCountElement()));
        }
        for (CodeSystem.CodeSystemFilterComponent codeSystemFilterComponent : src.getFilter()) {
            tgt.addFilter(CodeSystem30_40.convertCodeSystemFilterComponent(codeSystemFilterComponent));
        }
        for (CodeSystem.PropertyComponent propertyComponent : src.getProperty()) {
            tgt.addProperty(CodeSystem30_40.convertPropertyComponent(propertyComponent));
        }
        for (CodeSystem.ConceptDefinitionComponent conceptDefinitionComponent : src.getConcept()) {
            tgt.addConcept(CodeSystem30_40.convertConceptDefinitionComponent(conceptDefinitionComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.CodeSystem convertCodeSystem(CodeSystem src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.CodeSystem tgt = new org.hl7.fhir.dstu3.model.CodeSystem();
        VersionConvertor_30_40.copyDomainResource(src, tgt, new String[0]);
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_30_40.convertUri(src.getUrlElement()));
        }
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_30_40.convertIdentifier(src.getIdentifierFirstRep()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_30_40.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_40.convertString(src.getNameElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(VersionConvertor_30_40.convertString(src.getTitleElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((org.hl7.fhir.dstu3.model.Enumeration)VersionConvertor_30_40.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_30_40.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasDateElement()) {
            tgt.setDateElement(VersionConvertor_30_40.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(VersionConvertor_30_40.convertString(src.getPublisherElement()));
        }
        for (org.hl7.fhir.r4.model.ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(VersionConvertor_30_40.convertContactDetail(contactDetail));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_40.convertMarkdown(src.getDescriptionElement()));
        }
        for (UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(VersionConvertor_30_40.convertUsageContext(usageContext));
        }
        for (CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addJurisdiction(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPurpose()) {
            tgt.setPurposeElement(VersionConvertor_30_40.convertMarkdown(src.getPurposeElement()));
        }
        if (src.hasCopyright()) {
            tgt.setCopyrightElement(VersionConvertor_30_40.convertMarkdown(src.getCopyrightElement()));
        }
        if (src.hasCaseSensitive()) {
            tgt.setCaseSensitiveElement(VersionConvertor_30_40.convertBoolean(src.getCaseSensitiveElement()));
        }
        if (src.hasValueSet()) {
            tgt.setValueSet(src.getValueSet());
        }
        if (src.hasHierarchyMeaning()) {
            tgt.setHierarchyMeaningElement(CodeSystem30_40.convertCodeSystemHierarchyMeaning(src.getHierarchyMeaningElement()));
        }
        if (src.hasCompositional()) {
            tgt.setCompositionalElement(VersionConvertor_30_40.convertBoolean(src.getCompositionalElement()));
        }
        if (src.hasVersionNeeded()) {
            tgt.setVersionNeededElement(VersionConvertor_30_40.convertBoolean(src.getVersionNeededElement()));
        }
        if (src.hasContent()) {
            tgt.setContentElement(CodeSystem30_40.convertCodeSystemContentMode(src.getContentElement()));
        }
        if (src.hasCount()) {
            tgt.setCountElement(VersionConvertor_30_40.convertUnsignedInt(src.getCountElement()));
        }
        for (CodeSystem.CodeSystemFilterComponent codeSystemFilterComponent : src.getFilter()) {
            tgt.addFilter(CodeSystem30_40.convertCodeSystemFilterComponent(codeSystemFilterComponent));
        }
        for (CodeSystem.PropertyComponent propertyComponent : src.getProperty()) {
            tgt.addProperty(CodeSystem30_40.convertPropertyComponent(propertyComponent));
        }
        for (CodeSystem.ConceptDefinitionComponent conceptDefinitionComponent : src.getConcept()) {
            tgt.addConcept(CodeSystem30_40.convertConceptDefinitionComponent(conceptDefinitionComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<CodeSystem.CodeSystemContentMode> convertCodeSystemContentMode(Enumeration<CodeSystem.CodeSystemContentMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<CodeSystem.CodeSystemContentMode> tgt = new org.hl7.fhir.dstu3.model.Enumeration<CodeSystem.CodeSystemContentMode>(new CodeSystem.CodeSystemContentModeEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((CodeSystem.CodeSystemContentMode)((Object)src.getValue())) {
            case NOTPRESENT: {
                tgt.setValue((Object)CodeSystem.CodeSystemContentMode.NOTPRESENT);
                break;
            }
            case EXAMPLE: {
                tgt.setValue((Object)CodeSystem.CodeSystemContentMode.EXAMPLE);
                break;
            }
            case FRAGMENT: {
                tgt.setValue((Object)CodeSystem.CodeSystemContentMode.FRAGMENT);
                break;
            }
            case COMPLETE: {
                tgt.setValue((Object)CodeSystem.CodeSystemContentMode.COMPLETE);
                break;
            }
            default: {
                tgt.setValue((Object)CodeSystem.CodeSystemContentMode.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<CodeSystem.CodeSystemContentMode> convertCodeSystemContentMode(org.hl7.fhir.dstu3.model.Enumeration<CodeSystem.CodeSystemContentMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<CodeSystem.CodeSystemContentMode> tgt = new Enumeration<CodeSystem.CodeSystemContentMode>(new CodeSystem.CodeSystemContentModeEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((CodeSystem.CodeSystemContentMode)((Object)src.getValue())) {
            case NOTPRESENT: {
                tgt.setValue((Object)CodeSystem.CodeSystemContentMode.NOTPRESENT);
                break;
            }
            case EXAMPLE: {
                tgt.setValue((Object)CodeSystem.CodeSystemContentMode.EXAMPLE);
                break;
            }
            case FRAGMENT: {
                tgt.setValue((Object)CodeSystem.CodeSystemContentMode.FRAGMENT);
                break;
            }
            case COMPLETE: {
                tgt.setValue((Object)CodeSystem.CodeSystemContentMode.COMPLETE);
                break;
            }
            default: {
                tgt.setValue((Object)CodeSystem.CodeSystemContentMode.NULL);
            }
        }
        return tgt;
    }

    public static CodeSystem.CodeSystemFilterComponent convertCodeSystemFilterComponent(CodeSystem.CodeSystemFilterComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CodeSystem.CodeSystemFilterComponent tgt = new CodeSystem.CodeSystemFilterComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_30_40.convertCode(src.getCodeElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_40.convertString(src.getDescriptionElement()));
        }
        tgt.setOperator(src.getOperator().stream().map(CodeSystem30_40::convertFilterOperator).collect(Collectors.toList()));
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_30_40.convertString(src.getValueElement()));
        }
        return tgt;
    }

    public static CodeSystem.CodeSystemFilterComponent convertCodeSystemFilterComponent(CodeSystem.CodeSystemFilterComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CodeSystem.CodeSystemFilterComponent tgt = new CodeSystem.CodeSystemFilterComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_30_40.convertCode(src.getCodeElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_40.convertString(src.getDescriptionElement()));
        }
        tgt.setOperator(src.getOperator().stream().map(CodeSystem30_40::convertFilterOperator).collect(Collectors.toList()));
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_30_40.convertString(src.getValueElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<CodeSystem.CodeSystemHierarchyMeaning> convertCodeSystemHierarchyMeaning(Enumeration<CodeSystem.CodeSystemHierarchyMeaning> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<CodeSystem.CodeSystemHierarchyMeaning> tgt = new org.hl7.fhir.dstu3.model.Enumeration<CodeSystem.CodeSystemHierarchyMeaning>(new CodeSystem.CodeSystemHierarchyMeaningEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((CodeSystem.CodeSystemHierarchyMeaning)((Object)src.getValue())) {
            case GROUPEDBY: {
                tgt.setValue((Object)CodeSystem.CodeSystemHierarchyMeaning.GROUPEDBY);
                break;
            }
            case ISA: {
                tgt.setValue((Object)CodeSystem.CodeSystemHierarchyMeaning.ISA);
                break;
            }
            case PARTOF: {
                tgt.setValue((Object)CodeSystem.CodeSystemHierarchyMeaning.PARTOF);
                break;
            }
            case CLASSIFIEDWITH: {
                tgt.setValue((Object)CodeSystem.CodeSystemHierarchyMeaning.CLASSIFIEDWITH);
                break;
            }
            default: {
                tgt.setValue((Object)CodeSystem.CodeSystemHierarchyMeaning.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<CodeSystem.CodeSystemHierarchyMeaning> convertCodeSystemHierarchyMeaning(org.hl7.fhir.dstu3.model.Enumeration<CodeSystem.CodeSystemHierarchyMeaning> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<CodeSystem.CodeSystemHierarchyMeaning> tgt = new Enumeration<CodeSystem.CodeSystemHierarchyMeaning>(new CodeSystem.CodeSystemHierarchyMeaningEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((CodeSystem.CodeSystemHierarchyMeaning)((Object)src.getValue())) {
            case GROUPEDBY: {
                tgt.setValue((Object)CodeSystem.CodeSystemHierarchyMeaning.GROUPEDBY);
                break;
            }
            case ISA: {
                tgt.setValue((Object)CodeSystem.CodeSystemHierarchyMeaning.ISA);
                break;
            }
            case PARTOF: {
                tgt.setValue((Object)CodeSystem.CodeSystemHierarchyMeaning.PARTOF);
                break;
            }
            case CLASSIFIEDWITH: {
                tgt.setValue((Object)CodeSystem.CodeSystemHierarchyMeaning.CLASSIFIEDWITH);
                break;
            }
            default: {
                tgt.setValue((Object)CodeSystem.CodeSystemHierarchyMeaning.NULL);
            }
        }
        return tgt;
    }

    public static CodeSystem.ConceptDefinitionComponent convertConceptDefinitionComponent(CodeSystem.ConceptDefinitionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CodeSystem.ConceptDefinitionComponent tgt = new CodeSystem.ConceptDefinitionComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_30_40.convertCode(src.getCodeElement()));
        }
        if (src.hasDisplay()) {
            tgt.setDisplayElement(VersionConvertor_30_40.convertString(src.getDisplayElement()));
        }
        if (src.hasDefinition()) {
            tgt.setDefinitionElement(VersionConvertor_30_40.convertString(src.getDefinitionElement()));
        }
        for (CodeSystem.ConceptDefinitionDesignationComponent conceptDefinitionDesignationComponent : src.getDesignation()) {
            tgt.addDesignation(CodeSystem30_40.convertConceptDefinitionDesignationComponent(conceptDefinitionDesignationComponent));
        }
        for (CodeSystem.ConceptPropertyComponent conceptPropertyComponent : src.getProperty()) {
            tgt.addProperty(CodeSystem30_40.convertConceptPropertyComponent(conceptPropertyComponent));
        }
        for (CodeSystem.ConceptDefinitionComponent conceptDefinitionComponent : src.getConcept()) {
            tgt.addConcept(CodeSystem30_40.convertConceptDefinitionComponent(conceptDefinitionComponent));
        }
        return tgt;
    }

    public static CodeSystem.ConceptDefinitionComponent convertConceptDefinitionComponent(CodeSystem.ConceptDefinitionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CodeSystem.ConceptDefinitionComponent tgt = new CodeSystem.ConceptDefinitionComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_30_40.convertCode(src.getCodeElement()));
        }
        if (src.hasDisplay()) {
            tgt.setDisplayElement(VersionConvertor_30_40.convertString(src.getDisplayElement()));
        }
        if (src.hasDefinition()) {
            tgt.setDefinitionElement(VersionConvertor_30_40.convertString(src.getDefinitionElement()));
        }
        for (CodeSystem.ConceptDefinitionDesignationComponent conceptDefinitionDesignationComponent : src.getDesignation()) {
            tgt.addDesignation(CodeSystem30_40.convertConceptDefinitionDesignationComponent(conceptDefinitionDesignationComponent));
        }
        for (CodeSystem.ConceptPropertyComponent conceptPropertyComponent : src.getProperty()) {
            tgt.addProperty(CodeSystem30_40.convertConceptPropertyComponent(conceptPropertyComponent));
        }
        for (CodeSystem.ConceptDefinitionComponent conceptDefinitionComponent : src.getConcept()) {
            tgt.addConcept(CodeSystem30_40.convertConceptDefinitionComponent(conceptDefinitionComponent));
        }
        return tgt;
    }

    public static CodeSystem.ConceptDefinitionDesignationComponent convertConceptDefinitionDesignationComponent(CodeSystem.ConceptDefinitionDesignationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CodeSystem.ConceptDefinitionDesignationComponent tgt = new CodeSystem.ConceptDefinitionDesignationComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasLanguage()) {
            tgt.setLanguageElement(VersionConvertor_30_40.convertCode(src.getLanguageElement()));
        }
        if (src.hasUse()) {
            tgt.setUse(VersionConvertor_30_40.convertCoding(src.getUse()));
        }
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_30_40.convertString(src.getValueElement()));
        }
        return tgt;
    }

    public static CodeSystem.ConceptDefinitionDesignationComponent convertConceptDefinitionDesignationComponent(CodeSystem.ConceptDefinitionDesignationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CodeSystem.ConceptDefinitionDesignationComponent tgt = new CodeSystem.ConceptDefinitionDesignationComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasLanguage()) {
            tgt.setLanguageElement(VersionConvertor_30_40.convertCode(src.getLanguageElement()));
        }
        if (src.hasUse()) {
            tgt.setUse(VersionConvertor_30_40.convertCoding(src.getUse()));
        }
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_30_40.convertString(src.getValueElement()));
        }
        return tgt;
    }

    public static CodeSystem.ConceptPropertyComponent convertConceptPropertyComponent(CodeSystem.ConceptPropertyComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CodeSystem.ConceptPropertyComponent tgt = new CodeSystem.ConceptPropertyComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_30_40.convertCode(src.getCodeElement()));
        }
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_30_40.convertType(src.getValue()));
        }
        return tgt;
    }

    public static CodeSystem.ConceptPropertyComponent convertConceptPropertyComponent(CodeSystem.ConceptPropertyComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CodeSystem.ConceptPropertyComponent tgt = new CodeSystem.ConceptPropertyComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_30_40.convertCode(src.getCodeElement()));
        }
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_30_40.convertType(src.getValue()));
        }
        return tgt;
    }

    public static CodeSystem.PropertyComponent convertPropertyComponent(CodeSystem.PropertyComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CodeSystem.PropertyComponent tgt = new CodeSystem.PropertyComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_30_40.convertCode(src.getCodeElement()));
        }
        if (src.hasUri()) {
            tgt.setUriElement(VersionConvertor_30_40.convertUri(src.getUriElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_40.convertString(src.getDescriptionElement()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(CodeSystem30_40.convertPropertyType(src.getTypeElement()));
        }
        return tgt;
    }

    public static CodeSystem.PropertyComponent convertPropertyComponent(CodeSystem.PropertyComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CodeSystem.PropertyComponent tgt = new CodeSystem.PropertyComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_30_40.convertCode(src.getCodeElement()));
        }
        if (src.hasUri()) {
            tgt.setUriElement(VersionConvertor_30_40.convertUri(src.getUriElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_40.convertString(src.getDescriptionElement()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(CodeSystem30_40.convertPropertyType(src.getTypeElement()));
        }
        return tgt;
    }

    public static Enumeration<CodeSystem.PropertyType> convertPropertyType(org.hl7.fhir.dstu3.model.Enumeration<CodeSystem.PropertyType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<CodeSystem.PropertyType> tgt = new Enumeration<CodeSystem.PropertyType>(new CodeSystem.PropertyTypeEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((CodeSystem.PropertyType)((Object)src.getValue())) {
            case CODE: {
                tgt.setValue((Object)CodeSystem.PropertyType.CODE);
                break;
            }
            case CODING: {
                tgt.setValue((Object)CodeSystem.PropertyType.CODING);
                break;
            }
            case STRING: {
                tgt.setValue((Object)CodeSystem.PropertyType.STRING);
                break;
            }
            case INTEGER: {
                tgt.setValue((Object)CodeSystem.PropertyType.INTEGER);
                break;
            }
            case BOOLEAN: {
                tgt.setValue((Object)CodeSystem.PropertyType.BOOLEAN);
                break;
            }
            case DATETIME: {
                tgt.setValue((Object)CodeSystem.PropertyType.DATETIME);
                break;
            }
            default: {
                tgt.setValue((Object)CodeSystem.PropertyType.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<CodeSystem.PropertyType> convertPropertyType(Enumeration<CodeSystem.PropertyType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<CodeSystem.PropertyType> tgt = new org.hl7.fhir.dstu3.model.Enumeration<CodeSystem.PropertyType>(new CodeSystem.PropertyTypeEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((CodeSystem.PropertyType)((Object)src.getValue())) {
            case CODE: {
                tgt.setValue((Object)CodeSystem.PropertyType.CODE);
                break;
            }
            case CODING: {
                tgt.setValue((Object)CodeSystem.PropertyType.CODING);
                break;
            }
            case STRING: {
                tgt.setValue((Object)CodeSystem.PropertyType.STRING);
                break;
            }
            case INTEGER: {
                tgt.setValue((Object)CodeSystem.PropertyType.INTEGER);
                break;
            }
            case BOOLEAN: {
                tgt.setValue((Object)CodeSystem.PropertyType.BOOLEAN);
                break;
            }
            case DATETIME: {
                tgt.setValue((Object)CodeSystem.PropertyType.DATETIME);
                break;
            }
            default: {
                tgt.setValue((Object)CodeSystem.PropertyType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<CodeSystem.FilterOperator> convertFilterOperator(org.hl7.fhir.dstu3.model.Enumeration<CodeSystem.FilterOperator> src) {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<CodeSystem.FilterOperator> tgt = new Enumeration<CodeSystem.FilterOperator>(new CodeSystem.FilterOperatorEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((CodeSystem.FilterOperator)((Object)src.getValue())) {
            case EQUAL: {
                tgt.setValue((Object)CodeSystem.FilterOperator.EQUAL);
                break;
            }
            case ISA: {
                tgt.setValue((Object)CodeSystem.FilterOperator.ISA);
                break;
            }
            case DESCENDENTOF: {
                tgt.setValue((Object)CodeSystem.FilterOperator.DESCENDENTOF);
                break;
            }
            case ISNOTA: {
                tgt.setValue((Object)CodeSystem.FilterOperator.ISNOTA);
                break;
            }
            case REGEX: {
                tgt.setValue((Object)CodeSystem.FilterOperator.REGEX);
                break;
            }
            case IN: {
                tgt.setValue((Object)CodeSystem.FilterOperator.IN);
                break;
            }
            case NOTIN: {
                tgt.setValue((Object)CodeSystem.FilterOperator.NOTIN);
                break;
            }
            case GENERALIZES: {
                tgt.setValue((Object)CodeSystem.FilterOperator.GENERALIZES);
                break;
            }
            case EXISTS: {
                tgt.setValue((Object)CodeSystem.FilterOperator.EXISTS);
                break;
            }
            default: {
                tgt.setValue((Object)CodeSystem.FilterOperator.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<CodeSystem.FilterOperator> convertFilterOperator(Enumeration<CodeSystem.FilterOperator> src) {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<CodeSystem.FilterOperator> tgt = new org.hl7.fhir.dstu3.model.Enumeration<CodeSystem.FilterOperator>(new CodeSystem.FilterOperatorEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((CodeSystem.FilterOperator)((Object)src.getValue())) {
            case EQUAL: {
                tgt.setValue((Object)CodeSystem.FilterOperator.EQUAL);
                break;
            }
            case ISA: {
                tgt.setValue((Object)CodeSystem.FilterOperator.ISA);
                break;
            }
            case DESCENDENTOF: {
                tgt.setValue((Object)CodeSystem.FilterOperator.DESCENDENTOF);
                break;
            }
            case ISNOTA: {
                tgt.setValue((Object)CodeSystem.FilterOperator.ISNOTA);
                break;
            }
            case REGEX: {
                tgt.setValue((Object)CodeSystem.FilterOperator.REGEX);
                break;
            }
            case IN: {
                tgt.setValue((Object)CodeSystem.FilterOperator.IN);
                break;
            }
            case NOTIN: {
                tgt.setValue((Object)CodeSystem.FilterOperator.NOTIN);
                break;
            }
            case GENERALIZES: {
                tgt.setValue((Object)CodeSystem.FilterOperator.GENERALIZES);
                break;
            }
            case EXISTS: {
                tgt.setValue((Object)CodeSystem.FilterOperator.EXISTS);
                break;
            }
            default: {
                tgt.setValue((Object)CodeSystem.FilterOperator.NULL);
            }
        }
        return tgt;
    }
}

