/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv14_50;

import org.hl7.fhir.convertors.VersionConvertor_14_50;
import org.hl7.fhir.dstu2016may.model.CodeType;
import org.hl7.fhir.dstu2016may.model.ContactPoint;
import org.hl7.fhir.dstu2016may.model.Identifier;
import org.hl7.fhir.dstu2016may.model.Questionnaire;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Questionnaire;
import org.hl7.fhir.r5.model.UsageContext;

public class Questionnaire14_50 {
    public static org.hl7.fhir.r5.model.Questionnaire convertQuestionnaire(Questionnaire src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Questionnaire tgt = new org.hl7.fhir.r5.model.Questionnaire();
        VersionConvertor_14_50.copyDomainResource(src, tgt, new String[0]);
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_14_50.convertUri(src.getUrlElement()));
        }
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_14_50.convertIdentifier(identifier));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_14_50.convertString(src.getVersionElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((Enumeration)Questionnaire14_50.convertQuestionnaireStatus(src.getStatusElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_14_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(VersionConvertor_14_50.convertString(src.getPublisherElement()));
        }
        for (ContactPoint contactPoint : src.getTelecom()) {
            tgt.addContact(Questionnaire14_50.convertQuestionnaireContactComponent(contactPoint));
        }
        for (org.hl7.fhir.dstu2016may.model.CodeableConcept codeableConcept : src.getUseContext()) {
            if (VersionConvertor_14_50.isJurisdiction(codeableConcept)) {
                tgt.addJurisdiction(VersionConvertor_14_50.convertCodeableConcept(codeableConcept));
                continue;
            }
            tgt.addUseContext(VersionConvertor_14_50.convertCodeableConceptToUsageContext(codeableConcept));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(VersionConvertor_14_50.convertString(src.getTitleElement()));
        }
        for (org.hl7.fhir.dstu2016may.model.Coding coding : src.getConcept()) {
            tgt.addCode(VersionConvertor_14_50.convertCoding(coding));
        }
        for (CodeType codeType : src.getSubjectType()) {
            tgt.addSubjectType((String)codeType.getValue());
        }
        for (Questionnaire.QuestionnaireItemComponent questionnaireItemComponent : src.getItem()) {
            tgt.addItem(Questionnaire14_50.convertQuestionnaireItemComponent(questionnaireItemComponent));
        }
        return tgt;
    }

    public static Questionnaire convertQuestionnaire(org.hl7.fhir.r5.model.Questionnaire src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Questionnaire tgt = new Questionnaire();
        VersionConvertor_14_50.copyDomainResource(src, tgt, new String[0]);
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_14_50.convertUri(src.getUrlElement()));
        }
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_14_50.convertIdentifier(identifier));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_14_50.convertString(src.getVersionElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Questionnaire14_50.convertQuestionnaireStatus(src.getStatusElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_14_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(VersionConvertor_14_50.convertString(src.getPublisherElement()));
        }
        for (ContactDetail contactDetail : src.getContact()) {
            for (org.hl7.fhir.r5.model.ContactPoint t1 : contactDetail.getTelecom()) {
                tgt.addTelecom(VersionConvertor_14_50.convertContactPoint(t1));
            }
        }
        for (UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(VersionConvertor_14_50.convertCodeableConcept(usageContext.getValueCodeableConcept()));
        }
        for (CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addUseContext(VersionConvertor_14_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(VersionConvertor_14_50.convertString(src.getTitleElement()));
        }
        for (Coding coding : src.getCode()) {
            tgt.addConcept(VersionConvertor_14_50.convertCoding(coding));
        }
        for (org.hl7.fhir.r5.model.CodeType codeType : src.getSubjectType()) {
            tgt.addSubjectType((String)codeType.getValue());
        }
        for (Questionnaire.QuestionnaireItemComponent questionnaireItemComponent : src.getItem()) {
            tgt.addItem(Questionnaire14_50.convertQuestionnaireItemComponent(questionnaireItemComponent));
        }
        return tgt;
    }

    public static ContactDetail convertQuestionnaireContactComponent(ContactPoint src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ContactDetail tgt = new ContactDetail();
        VersionConvertor_14_50.copyElement(src, tgt, new String[0]);
        tgt.addTelecom(VersionConvertor_14_50.convertContactPoint(src));
        return tgt;
    }

    public static Questionnaire.QuestionnaireItemComponent convertQuestionnaireItemComponent(Questionnaire.QuestionnaireItemComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Questionnaire.QuestionnaireItemComponent tgt = new Questionnaire.QuestionnaireItemComponent();
        VersionConvertor_14_50.copyElement(src, tgt, new String[0]);
        if (src.hasLinkId()) {
            tgt.setLinkIdElement(VersionConvertor_14_50.convertString(src.getLinkIdElement()));
        }
        for (Coding coding : src.getCode()) {
            tgt.addConcept(VersionConvertor_14_50.convertCoding(coding));
        }
        if (src.hasPrefix()) {
            tgt.setPrefixElement(VersionConvertor_14_50.convertString(src.getPrefixElement()));
        }
        if (src.hasText()) {
            tgt.setTextElement(VersionConvertor_14_50.convertString(src.getTextElement()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(Questionnaire14_50.convertQuestionnaireItemType(src.getTypeElement()));
        }
        for (Questionnaire.QuestionnaireItemEnableWhenComponent questionnaireItemEnableWhenComponent : src.getEnableWhen()) {
            tgt.addEnableWhen(Questionnaire14_50.convertQuestionnaireItemEnableWhenComponent(questionnaireItemEnableWhenComponent));
        }
        if (src.hasRequired()) {
            tgt.setRequiredElement(VersionConvertor_14_50.convertBoolean(src.getRequiredElement()));
        }
        if (src.hasRepeats()) {
            tgt.setRepeatsElement(VersionConvertor_14_50.convertBoolean(src.getRepeatsElement()));
        }
        if (src.hasReadOnly()) {
            tgt.setReadOnlyElement(VersionConvertor_14_50.convertBoolean(src.getReadOnlyElement()));
        }
        if (src.hasMaxLength()) {
            tgt.setMaxLengthElement(VersionConvertor_14_50.convertInteger(src.getMaxLengthElement()));
        }
        if (src.hasAnswerValueSetElement()) {
            tgt.setOptions(VersionConvertor_14_50.convertCanonicalToReference(src.getAnswerValueSetElement()));
        }
        for (Questionnaire.QuestionnaireItemAnswerOptionComponent questionnaireItemAnswerOptionComponent : src.getAnswerOption()) {
            tgt.addOption(Questionnaire14_50.convertQuestionnaireItemOptionComponent(questionnaireItemAnswerOptionComponent));
        }
        if (src.hasInitial()) {
            tgt.setInitial(VersionConvertor_14_50.convertType(src.getInitialFirstRep().getValue()));
        }
        for (Questionnaire.QuestionnaireItemComponent questionnaireItemComponent : src.getItem()) {
            tgt.addItem(Questionnaire14_50.convertQuestionnaireItemComponent(questionnaireItemComponent));
        }
        return tgt;
    }

    public static Questionnaire.QuestionnaireItemComponent convertQuestionnaireItemComponent(Questionnaire.QuestionnaireItemComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Questionnaire.QuestionnaireItemComponent tgt = new Questionnaire.QuestionnaireItemComponent();
        VersionConvertor_14_50.copyElement(src, tgt, new String[0]);
        if (src.hasLinkId()) {
            tgt.setLinkIdElement(VersionConvertor_14_50.convertString(src.getLinkIdElement()));
        }
        for (org.hl7.fhir.dstu2016may.model.Coding coding : src.getConcept()) {
            tgt.addCode(VersionConvertor_14_50.convertCoding(coding));
        }
        if (src.hasPrefix()) {
            tgt.setPrefixElement(VersionConvertor_14_50.convertString(src.getPrefixElement()));
        }
        if (src.hasText()) {
            tgt.setTextElement(VersionConvertor_14_50.convertString(src.getTextElement()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(Questionnaire14_50.convertQuestionnaireItemType(src.getTypeElement()));
        }
        for (Questionnaire.QuestionnaireItemEnableWhenComponent questionnaireItemEnableWhenComponent : src.getEnableWhen()) {
            tgt.addEnableWhen(Questionnaire14_50.convertQuestionnaireItemEnableWhenComponent(questionnaireItemEnableWhenComponent));
        }
        if (src.hasRequired()) {
            tgt.setRequiredElement(VersionConvertor_14_50.convertBoolean(src.getRequiredElement()));
        }
        if (src.hasRepeats()) {
            tgt.setRepeatsElement(VersionConvertor_14_50.convertBoolean(src.getRepeatsElement()));
        }
        if (src.hasReadOnly()) {
            tgt.setReadOnlyElement(VersionConvertor_14_50.convertBoolean(src.getReadOnlyElement()));
        }
        if (src.hasMaxLength()) {
            tgt.setMaxLengthElement(VersionConvertor_14_50.convertInteger(src.getMaxLengthElement()));
        }
        if (src.hasOptions()) {
            tgt.setAnswerValueSetElement(VersionConvertor_14_50.convertReferenceToCanonical(src.getOptions()));
        }
        for (Questionnaire.QuestionnaireItemOptionComponent questionnaireItemOptionComponent : src.getOption()) {
            tgt.addAnswerOption(Questionnaire14_50.convertQuestionnaireItemOptionComponent(questionnaireItemOptionComponent));
        }
        if (src.hasInitial()) {
            tgt.addInitial().setValue(VersionConvertor_14_50.convertType(src.getInitial()));
        }
        for (Questionnaire.QuestionnaireItemComponent questionnaireItemComponent : src.getItem()) {
            tgt.addItem(Questionnaire14_50.convertQuestionnaireItemComponent(questionnaireItemComponent));
        }
        return tgt;
    }

    public static Questionnaire.QuestionnaireItemEnableWhenComponent convertQuestionnaireItemEnableWhenComponent(Questionnaire.QuestionnaireItemEnableWhenComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Questionnaire.QuestionnaireItemEnableWhenComponent tgt = new Questionnaire.QuestionnaireItemEnableWhenComponent();
        VersionConvertor_14_50.copyElement(src, tgt, new String[0]);
        if (src.hasQuestionElement()) {
            tgt.setQuestionElement(VersionConvertor_14_50.convertString(src.getQuestionElement()));
        }
        if (src.hasAnswered()) {
            tgt.setOperator(Questionnaire.QuestionnaireItemOperator.EXISTS);
            if (src.hasAnsweredElement()) {
                tgt.setAnswer(VersionConvertor_14_50.convertType(src.getAnsweredElement()));
            }
        }
        if (src.hasAnswer()) {
            tgt.setAnswer(VersionConvertor_14_50.convertType(src.getAnswer()));
        }
        return tgt;
    }

    public static Questionnaire.QuestionnaireItemEnableWhenComponent convertQuestionnaireItemEnableWhenComponent(Questionnaire.QuestionnaireItemEnableWhenComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Questionnaire.QuestionnaireItemEnableWhenComponent tgt = new Questionnaire.QuestionnaireItemEnableWhenComponent();
        VersionConvertor_14_50.copyElement(src, tgt, new String[0]);
        if (src.hasQuestionElement()) {
            tgt.setQuestionElement(VersionConvertor_14_50.convertString(src.getQuestionElement()));
        }
        if (src.hasOperator() && src.getOperator() == Questionnaire.QuestionnaireItemOperator.EXISTS) {
            tgt.setAnswered((Boolean)src.getAnswerBooleanType().getValue());
        } else {
            tgt.setAnswer(VersionConvertor_14_50.convertType(src.getAnswer()));
        }
        return tgt;
    }

    public static Questionnaire.QuestionnaireItemOptionComponent convertQuestionnaireItemOptionComponent(Questionnaire.QuestionnaireItemAnswerOptionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Questionnaire.QuestionnaireItemOptionComponent tgt = new Questionnaire.QuestionnaireItemOptionComponent();
        VersionConvertor_14_50.copyElement(src, tgt, new String[0]);
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_14_50.convertType(src.getValue()));
        }
        return tgt;
    }

    public static Questionnaire.QuestionnaireItemAnswerOptionComponent convertQuestionnaireItemOptionComponent(Questionnaire.QuestionnaireItemOptionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Questionnaire.QuestionnaireItemAnswerOptionComponent tgt = new Questionnaire.QuestionnaireItemAnswerOptionComponent();
        VersionConvertor_14_50.copyElement(src, tgt, new String[0]);
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_14_50.convertType(src.getValue()));
        }
        return tgt;
    }

    public static Enumeration<Questionnaire.QuestionnaireItemType> convertQuestionnaireItemType(org.hl7.fhir.dstu2016may.model.Enumeration<Questionnaire.QuestionnaireItemType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Questionnaire.QuestionnaireItemType> tgt = new Enumeration<Questionnaire.QuestionnaireItemType>(new Questionnaire.QuestionnaireItemTypeEnumFactory());
        VersionConvertor_14_50.copyElement(src, tgt, new String[0]);
        switch ((Questionnaire.QuestionnaireItemType)((Object)src.getValue())) {
            case GROUP: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.GROUP);
                break;
            }
            case DISPLAY: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.DISPLAY);
                break;
            }
            case QUESTION: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.GROUP);
                break;
            }
            case BOOLEAN: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.BOOLEAN);
                break;
            }
            case DECIMAL: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.DECIMAL);
                break;
            }
            case INTEGER: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.INTEGER);
                break;
            }
            case DATE: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.DATE);
                break;
            }
            case DATETIME: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.DATETIME);
                break;
            }
            case INSTANT: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.DATETIME);
                break;
            }
            case TIME: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.TIME);
                break;
            }
            case STRING: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.STRING);
                break;
            }
            case TEXT: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.TEXT);
                break;
            }
            case URL: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.URL);
                break;
            }
            case CHOICE: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.CHOICE);
                break;
            }
            case OPENCHOICE: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.OPENCHOICE);
                break;
            }
            case ATTACHMENT: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.ATTACHMENT);
                break;
            }
            case REFERENCE: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.REFERENCE);
                break;
            }
            case QUANTITY: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.QUANTITY);
                break;
            }
            default: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Enumeration<Questionnaire.QuestionnaireItemType> convertQuestionnaireItemType(Enumeration<Questionnaire.QuestionnaireItemType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Enumeration<Questionnaire.QuestionnaireItemType> tgt = new org.hl7.fhir.dstu2016may.model.Enumeration<Questionnaire.QuestionnaireItemType>(new Questionnaire.QuestionnaireItemTypeEnumFactory());
        VersionConvertor_14_50.copyElement(src, tgt, new String[0]);
        switch ((Questionnaire.QuestionnaireItemType)((Object)src.getValue())) {
            case GROUP: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.GROUP);
                break;
            }
            case DISPLAY: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.DISPLAY);
                break;
            }
            case BOOLEAN: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.BOOLEAN);
                break;
            }
            case DECIMAL: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.DECIMAL);
                break;
            }
            case INTEGER: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.INTEGER);
                break;
            }
            case DATE: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.DATE);
                break;
            }
            case DATETIME: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.DATETIME);
                break;
            }
            case TIME: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.TIME);
                break;
            }
            case STRING: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.STRING);
                break;
            }
            case TEXT: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.TEXT);
                break;
            }
            case URL: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.URL);
                break;
            }
            case CHOICE: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.CHOICE);
                break;
            }
            case OPENCHOICE: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.OPENCHOICE);
                break;
            }
            case ATTACHMENT: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.ATTACHMENT);
                break;
            }
            case REFERENCE: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.REFERENCE);
                break;
            }
            case QUANTITY: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.QUANTITY);
                break;
            }
            default: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Enumerations.PublicationStatus> convertQuestionnaireStatus(org.hl7.fhir.dstu2016may.model.Enumeration<Questionnaire.QuestionnaireStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Enumerations.PublicationStatus> tgt = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
        VersionConvertor_14_50.copyElement(src, tgt, new String[0]);
        switch ((Questionnaire.QuestionnaireStatus)((Object)src.getValue())) {
            case DRAFT: {
                tgt.setValue((Object)Enumerations.PublicationStatus.DRAFT);
                break;
            }
            case PUBLISHED: {
                tgt.setValue((Object)Enumerations.PublicationStatus.ACTIVE);
                break;
            }
            case RETIRED: {
                tgt.setValue((Object)Enumerations.PublicationStatus.RETIRED);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.PublicationStatus.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Enumeration<Questionnaire.QuestionnaireStatus> convertQuestionnaireStatus(Enumeration<Enumerations.PublicationStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Enumeration<Questionnaire.QuestionnaireStatus> tgt = new org.hl7.fhir.dstu2016may.model.Enumeration<Questionnaire.QuestionnaireStatus>(new Questionnaire.QuestionnaireStatusEnumFactory());
        VersionConvertor_14_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.PublicationStatus)((Object)src.getValue())) {
            case DRAFT: {
                tgt.setValue((Object)Questionnaire.QuestionnaireStatus.DRAFT);
                break;
            }
            case ACTIVE: {
                tgt.setValue((Object)Questionnaire.QuestionnaireStatus.PUBLISHED);
                break;
            }
            case RETIRED: {
                tgt.setValue((Object)Questionnaire.QuestionnaireStatus.RETIRED);
                break;
            }
            default: {
                tgt.setValue((Object)Questionnaire.QuestionnaireStatus.NULL);
            }
        }
        return tgt;
    }
}

