/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv14_40;

import org.hl7.fhir.convertors.VersionConvertor_14_40;
import org.hl7.fhir.dstu2016may.model.CodeableConcept;
import org.hl7.fhir.dstu2016may.model.ContactPoint;
import org.hl7.fhir.dstu2016may.model.ValueSet;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.ContactDetail;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.r4.model.UsageContext;
import org.hl7.fhir.r4.model.ValueSet;

public class ValueSet14_40 {
    public static ValueSet.ConceptReferenceComponent convertConceptReferenceComponent(ValueSet.ConceptReferenceComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet.ConceptReferenceComponent tgt = new ValueSet.ConceptReferenceComponent();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasCodeElement()) {
            tgt.setCodeElement(VersionConvertor_14_40.convertCode(src.getCodeElement()));
        }
        if (src.hasDisplay()) {
            tgt.setDisplayElement(VersionConvertor_14_40.convertString(src.getDisplayElement()));
        }
        for (ValueSet.ConceptReferenceDesignationComponent t : src.getDesignation()) {
            tgt.addDesignation(ValueSet14_40.convertConceptReferenceDesignationComponent(t));
        }
        return tgt;
    }

    public static ValueSet.ConceptReferenceComponent convertConceptReferenceComponent(ValueSet.ConceptReferenceComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet.ConceptReferenceComponent tgt = new ValueSet.ConceptReferenceComponent();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasCodeElement()) {
            tgt.setCodeElement(VersionConvertor_14_40.convertCode(src.getCodeElement()));
        }
        if (src.hasDisplay()) {
            tgt.setDisplayElement(VersionConvertor_14_40.convertString(src.getDisplayElement()));
        }
        for (ValueSet.ConceptReferenceDesignationComponent t : src.getDesignation()) {
            tgt.addDesignation(ValueSet14_40.convertConceptReferenceDesignationComponent(t));
        }
        return tgt;
    }

    public static ValueSet.ConceptReferenceDesignationComponent convertConceptReferenceDesignationComponent(ValueSet.ConceptReferenceDesignationComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet.ConceptReferenceDesignationComponent tgt = new ValueSet.ConceptReferenceDesignationComponent();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasLanguage()) {
            tgt.setLanguageElement(VersionConvertor_14_40.convertCode(src.getLanguageElement()));
        }
        if (src.hasUse()) {
            tgt.setUse(VersionConvertor_14_40.convertCoding(src.getUse()));
        }
        if (src.hasValueElement()) {
            tgt.setValueElement(VersionConvertor_14_40.convertString(src.getValueElement()));
        }
        return tgt;
    }

    public static ValueSet.ConceptReferenceDesignationComponent convertConceptReferenceDesignationComponent(ValueSet.ConceptReferenceDesignationComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet.ConceptReferenceDesignationComponent tgt = new ValueSet.ConceptReferenceDesignationComponent();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasLanguage()) {
            tgt.setLanguageElement(VersionConvertor_14_40.convertCode(src.getLanguageElement()));
        }
        if (src.hasUse()) {
            tgt.setUse(VersionConvertor_14_40.convertCoding(src.getUse()));
        }
        if (src.hasValueElement()) {
            tgt.setValueElement(VersionConvertor_14_40.convertString(src.getValueElement()));
        }
        return tgt;
    }

    public static ValueSet.ConceptSetComponent convertConceptSetComponent(ValueSet.ConceptSetComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet.ConceptSetComponent tgt = new ValueSet.ConceptSetComponent();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasSystemElement()) {
            tgt.setSystemElement(VersionConvertor_14_40.convertUri(src.getSystemElement()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_14_40.convertString(src.getVersionElement()));
        }
        for (ValueSet.ConceptReferenceComponent conceptReferenceComponent : src.getConcept()) {
            tgt.addConcept(ValueSet14_40.convertConceptReferenceComponent(conceptReferenceComponent));
        }
        for (ValueSet.ConceptSetFilterComponent conceptSetFilterComponent : src.getFilter()) {
            tgt.addFilter(ValueSet14_40.convertConceptSetFilterComponent(conceptSetFilterComponent));
        }
        return tgt;
    }

    public static ValueSet.ConceptSetComponent convertConceptSetComponent(ValueSet.ConceptSetComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet.ConceptSetComponent tgt = new ValueSet.ConceptSetComponent();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasSystemElement()) {
            tgt.setSystemElement(VersionConvertor_14_40.convertUri(src.getSystemElement()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_14_40.convertString(src.getVersionElement()));
        }
        for (ValueSet.ConceptReferenceComponent conceptReferenceComponent : src.getConcept()) {
            tgt.addConcept(ValueSet14_40.convertConceptReferenceComponent(conceptReferenceComponent));
        }
        for (ValueSet.ConceptSetFilterComponent conceptSetFilterComponent : src.getFilter()) {
            tgt.addFilter(ValueSet14_40.convertConceptSetFilterComponent(conceptSetFilterComponent));
        }
        return tgt;
    }

    public static ValueSet.ConceptSetFilterComponent convertConceptSetFilterComponent(ValueSet.ConceptSetFilterComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet.ConceptSetFilterComponent tgt = new ValueSet.ConceptSetFilterComponent();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasPropertyElement()) {
            tgt.setPropertyElement(VersionConvertor_14_40.convertCode(src.getPropertyElement()));
        }
        if (src.hasOp()) {
            tgt.setOpElement(ValueSet14_40.convertFilterOperator(src.getOpElement()));
        }
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        return tgt;
    }

    public static ValueSet.ConceptSetFilterComponent convertConceptSetFilterComponent(ValueSet.ConceptSetFilterComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet.ConceptSetFilterComponent tgt = new ValueSet.ConceptSetFilterComponent();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasPropertyElement()) {
            tgt.setPropertyElement(VersionConvertor_14_40.convertCode(src.getPropertyElement()));
        }
        if (src.hasOp()) {
            tgt.setOpElement(ValueSet14_40.convertFilterOperator(src.getOpElement()));
        }
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        return tgt;
    }

    public static Enumeration<ValueSet.FilterOperator> convertFilterOperator(org.hl7.fhir.dstu2016may.model.Enumeration<ValueSet.FilterOperator> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ValueSet.FilterOperator> tgt = new Enumeration<ValueSet.FilterOperator>(new ValueSet.FilterOperatorEnumFactory());
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        switch ((ValueSet.FilterOperator)((Object)src.getValue())) {
            case EQUAL: {
                tgt.setValue((Object)ValueSet.FilterOperator.EQUAL);
                break;
            }
            case ISA: {
                tgt.setValue((Object)ValueSet.FilterOperator.ISA);
                break;
            }
            case ISNOTA: {
                tgt.setValue((Object)ValueSet.FilterOperator.ISNOTA);
                break;
            }
            case REGEX: {
                tgt.setValue((Object)ValueSet.FilterOperator.REGEX);
                break;
            }
            case IN: {
                tgt.setValue((Object)ValueSet.FilterOperator.IN);
                break;
            }
            case NOTIN: {
                tgt.setValue((Object)ValueSet.FilterOperator.NOTIN);
                break;
            }
            default: {
                tgt.setValue((Object)ValueSet.FilterOperator.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Enumeration<ValueSet.FilterOperator> convertFilterOperator(Enumeration<ValueSet.FilterOperator> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Enumeration<ValueSet.FilterOperator> tgt = new org.hl7.fhir.dstu2016may.model.Enumeration<ValueSet.FilterOperator>(new ValueSet.FilterOperatorEnumFactory());
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        switch ((ValueSet.FilterOperator)((Object)src.getValue())) {
            case EQUAL: {
                tgt.setValue((Object)ValueSet.FilterOperator.EQUAL);
                break;
            }
            case ISA: {
                tgt.setValue((Object)ValueSet.FilterOperator.ISA);
                break;
            }
            case ISNOTA: {
                tgt.setValue((Object)ValueSet.FilterOperator.ISNOTA);
                break;
            }
            case REGEX: {
                tgt.setValue((Object)ValueSet.FilterOperator.REGEX);
                break;
            }
            case IN: {
                tgt.setValue((Object)ValueSet.FilterOperator.IN);
                break;
            }
            case NOTIN: {
                tgt.setValue((Object)ValueSet.FilterOperator.NOTIN);
                break;
            }
            default: {
                tgt.setValue((Object)ValueSet.FilterOperator.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.ValueSet convertValueSet(ValueSet src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.ValueSet tgt = new org.hl7.fhir.r4.model.ValueSet();
        VersionConvertor_14_40.copyDomainResource(src, tgt, new String[0]);
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_14_40.convertUri(src.getUrlElement()));
        }
        if (src.hasIdentifier()) {
            tgt.addIdentifier(VersionConvertor_14_40.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_14_40.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_14_40.convertString(src.getNameElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((Enumeration)VersionConvertor_14_40.convertConformanceResourceStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_14_40.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(VersionConvertor_14_40.convertString(src.getPublisherElement()));
        }
        for (ValueSet.ValueSetContactComponent valueSetContactComponent : src.getContact()) {
            tgt.addContact(ValueSet14_40.convertValueSetContactComponent(valueSetContactComponent));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_14_40.convertDateTime(src.getDateElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (CodeableConcept codeableConcept : src.getUseContext()) {
            if (VersionConvertor_14_40.isJurisdiction(codeableConcept)) {
                tgt.addJurisdiction(VersionConvertor_14_40.convertCodeableConcept(codeableConcept));
                continue;
            }
            tgt.addUseContext(VersionConvertor_14_40.convertCodeableConceptToUsageContext(codeableConcept));
        }
        if (src.hasImmutable()) {
            tgt.setImmutableElement(VersionConvertor_14_40.convertBoolean(src.getImmutableElement()));
        }
        if (src.hasRequirements()) {
            tgt.setPurpose(src.getRequirements());
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        if (src.hasExtensible()) {
            tgt.addExtension("http://hl7.org/fhir/StructureDefinition/valueset-extensible", new BooleanType(src.getExtensible()));
        }
        if (src.hasCompose()) {
            tgt.setCompose(ValueSet14_40.convertValueSetComposeComponent(src.getCompose()));
        }
        if (src.hasLockedDate()) {
            tgt.getCompose().setLockedDate(src.getLockedDate());
        }
        if (src.hasExpansion()) {
            tgt.setExpansion(ValueSet14_40.convertValueSetExpansionComponent(src.getExpansion()));
        }
        return tgt;
    }

    public static ValueSet convertValueSet(org.hl7.fhir.r4.model.ValueSet src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet tgt = new ValueSet();
        VersionConvertor_14_40.copyDomainResource(src, tgt, new String[0]);
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_14_40.convertUri(src.getUrlElement()));
        }
        for (Identifier identifier : src.getIdentifier()) {
            tgt.setIdentifier(VersionConvertor_14_40.convertIdentifier(identifier));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_14_40.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_14_40.convertString(src.getNameElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(VersionConvertor_14_40.convertConformanceResourceStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_14_40.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(VersionConvertor_14_40.convertString(src.getPublisherElement()));
        }
        for (ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(ValueSet14_40.convertValueSetContactComponent(contactDetail));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_14_40.convertDateTime(src.getDateElement()));
        }
        if (src.getCompose().hasLockedDate()) {
            tgt.setLockedDate(src.getCompose().getLockedDate());
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (UsageContext usageContext : src.getUseContext()) {
            if (!usageContext.hasValueCodeableConcept()) continue;
            tgt.addUseContext(VersionConvertor_14_40.convertCodeableConcept(usageContext.getValueCodeableConcept()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addUseContext(VersionConvertor_14_40.convertCodeableConcept(codeableConcept));
        }
        if (src.hasImmutable()) {
            tgt.setImmutableElement(VersionConvertor_14_40.convertBoolean(src.getImmutableElement()));
        }
        if (src.hasPurpose()) {
            tgt.setRequirements(src.getPurpose());
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        if (src.hasExtension("http://hl7.org/fhir/StructureDefinition/valueset-extensible")) {
            tgt.setExtensible(((BooleanType)src.getExtensionByUrl("http://hl7.org/fhir/StructureDefinition/valueset-extensible").getValue()).booleanValue());
        }
        if (src.hasCompose()) {
            tgt.setCompose(ValueSet14_40.convertValueSetComposeComponent(src.getCompose()));
        }
        if (src.hasExpansion()) {
            tgt.setExpansion(ValueSet14_40.convertValueSetExpansionComponent(src.getExpansion()));
        }
        return tgt;
    }

    public static ValueSet.ValueSetComposeComponent convertValueSetComposeComponent(ValueSet.ValueSetComposeComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet.ValueSetComposeComponent tgt = new ValueSet.ValueSetComposeComponent();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        for (org.hl7.fhir.dstu2016may.model.UriType uriType : src.getImport()) {
            tgt.addInclude().addValueSet((String)uriType.getValue());
        }
        for (ValueSet.ConceptSetComponent conceptSetComponent : src.getInclude()) {
            tgt.addInclude(ValueSet14_40.convertConceptSetComponent(conceptSetComponent));
        }
        for (ValueSet.ConceptSetComponent conceptSetComponent : src.getExclude()) {
            tgt.addExclude(ValueSet14_40.convertConceptSetComponent(conceptSetComponent));
        }
        return tgt;
    }

    public static ValueSet.ValueSetComposeComponent convertValueSetComposeComponent(ValueSet.ValueSetComposeComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet.ValueSetComposeComponent tgt = new ValueSet.ValueSetComposeComponent();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        for (ValueSet.ConceptSetComponent t : src.getInclude()) {
            for (UriType uriType : t.getValueSet()) {
                tgt.addImport((String)uriType.getValue());
            }
            tgt.addInclude(ValueSet14_40.convertConceptSetComponent(t));
        }
        for (ValueSet.ConceptSetComponent t : src.getExclude()) {
            tgt.addExclude(ValueSet14_40.convertConceptSetComponent(t));
        }
        return tgt;
    }

    public static ValueSet.ValueSetContactComponent convertValueSetContactComponent(ContactDetail src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet.ValueSetContactComponent tgt = new ValueSet.ValueSetContactComponent();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_14_40.convertString(src.getNameElement()));
        }
        for (org.hl7.fhir.r4.model.ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_14_40.convertContactPoint(t));
        }
        return tgt;
    }

    public static ContactDetail convertValueSetContactComponent(ValueSet.ValueSetContactComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ContactDetail tgt = new ContactDetail();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_14_40.convertString(src.getNameElement()));
        }
        for (ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_14_40.convertContactPoint(t));
        }
        return tgt;
    }

    public static ValueSet.ValueSetExpansionComponent convertValueSetExpansionComponent(ValueSet.ValueSetExpansionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet.ValueSetExpansionComponent tgt = new ValueSet.ValueSetExpansionComponent();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasIdentifierElement()) {
            tgt.setIdentifierElement(VersionConvertor_14_40.convertUri(src.getIdentifierElement()));
        }
        if (src.hasTimestampElement()) {
            tgt.setTimestampElement(VersionConvertor_14_40.convertDateTime(src.getTimestampElement()));
        }
        if (src.hasTotal()) {
            tgt.setTotalElement(VersionConvertor_14_40.convertInteger(src.getTotalElement()));
        }
        if (src.hasOffset()) {
            tgt.setOffsetElement(VersionConvertor_14_40.convertInteger(src.getOffsetElement()));
        }
        for (ValueSet.ValueSetExpansionParameterComponent valueSetExpansionParameterComponent : src.getParameter()) {
            tgt.addParameter(ValueSet14_40.convertValueSetExpansionParameterComponent(valueSetExpansionParameterComponent));
        }
        for (ValueSet.ValueSetExpansionContainsComponent valueSetExpansionContainsComponent : src.getContains()) {
            tgt.addContains(ValueSet14_40.convertValueSetExpansionContainsComponent(valueSetExpansionContainsComponent));
        }
        return tgt;
    }

    public static ValueSet.ValueSetExpansionComponent convertValueSetExpansionComponent(ValueSet.ValueSetExpansionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet.ValueSetExpansionComponent tgt = new ValueSet.ValueSetExpansionComponent();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasIdentifierElement()) {
            tgt.setIdentifierElement(VersionConvertor_14_40.convertUri(src.getIdentifierElement()));
        }
        if (src.hasTimestampElement()) {
            tgt.setTimestampElement(VersionConvertor_14_40.convertDateTime(src.getTimestampElement()));
        }
        if (src.hasTotal()) {
            tgt.setTotalElement(VersionConvertor_14_40.convertInteger(src.getTotalElement()));
        }
        if (src.hasOffset()) {
            tgt.setOffsetElement(VersionConvertor_14_40.convertInteger(src.getOffsetElement()));
        }
        for (ValueSet.ValueSetExpansionParameterComponent valueSetExpansionParameterComponent : src.getParameter()) {
            tgt.addParameter(ValueSet14_40.convertValueSetExpansionParameterComponent(valueSetExpansionParameterComponent));
        }
        for (ValueSet.ValueSetExpansionContainsComponent valueSetExpansionContainsComponent : src.getContains()) {
            tgt.addContains(ValueSet14_40.convertValueSetExpansionContainsComponent(valueSetExpansionContainsComponent));
        }
        return tgt;
    }

    public static ValueSet.ValueSetExpansionContainsComponent convertValueSetExpansionContainsComponent(ValueSet.ValueSetExpansionContainsComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet.ValueSetExpansionContainsComponent tgt = new ValueSet.ValueSetExpansionContainsComponent();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_14_40.convertUri(src.getSystemElement()));
        }
        if (src.hasAbstract()) {
            tgt.setAbstractElement(VersionConvertor_14_40.convertBoolean(src.getAbstractElement()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_14_40.convertString(src.getVersionElement()));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_14_40.convertCode(src.getCodeElement()));
        }
        if (src.hasDisplay()) {
            tgt.setDisplayElement(VersionConvertor_14_40.convertString(src.getDisplayElement()));
        }
        for (ValueSet.ValueSetExpansionContainsComponent t : src.getContains()) {
            tgt.addContains(ValueSet14_40.convertValueSetExpansionContainsComponent(t));
        }
        return tgt;
    }

    public static ValueSet.ValueSetExpansionContainsComponent convertValueSetExpansionContainsComponent(ValueSet.ValueSetExpansionContainsComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet.ValueSetExpansionContainsComponent tgt = new ValueSet.ValueSetExpansionContainsComponent();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_14_40.convertUri(src.getSystemElement()));
        }
        if (src.hasAbstract()) {
            tgt.setAbstractElement(VersionConvertor_14_40.convertBoolean(src.getAbstractElement()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_14_40.convertString(src.getVersionElement()));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_14_40.convertCode(src.getCodeElement()));
        }
        if (src.hasDisplay()) {
            tgt.setDisplayElement(VersionConvertor_14_40.convertString(src.getDisplayElement()));
        }
        for (ValueSet.ValueSetExpansionContainsComponent t : src.getContains()) {
            tgt.addContains(ValueSet14_40.convertValueSetExpansionContainsComponent(t));
        }
        return tgt;
    }

    public static ValueSet.ValueSetExpansionParameterComponent convertValueSetExpansionParameterComponent(ValueSet.ValueSetExpansionParameterComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet.ValueSetExpansionParameterComponent tgt = new ValueSet.ValueSetExpansionParameterComponent();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_14_40.convertString(src.getNameElement()));
        }
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_14_40.convertType(src.getValue()));
        }
        return tgt;
    }

    public static ValueSet.ValueSetExpansionParameterComponent convertValueSetExpansionParameterComponent(ValueSet.ValueSetExpansionParameterComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet.ValueSetExpansionParameterComponent tgt = new ValueSet.ValueSetExpansionParameterComponent();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_14_40.convertString(src.getNameElement()));
        }
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_14_40.convertType(src.getValue()));
        }
        return tgt;
    }
}

