/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv14_40;

import org.hl7.fhir.convertors.VersionConvertor_14_40;
import org.hl7.fhir.dstu2016may.model.CodeableConcept;
import org.hl7.fhir.dstu2016may.model.ContactPoint;
import org.hl7.fhir.dstu2016may.model.DataElement;
import org.hl7.fhir.dstu2016may.model.ElementDefinition;
import org.hl7.fhir.dstu2016may.model.Identifier;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.ContactDetail;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.StructureDefinition;

public class DataElement14_40 {
    public static StructureDefinition convertDataElement(DataElement src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        StructureDefinition tgt = new StructureDefinition();
        VersionConvertor_14_40.copyDomainResource(src, tgt, new String[0]);
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_14_40.convertUri(src.getUrlElement()));
        }
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_14_40.convertIdentifier(identifier));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_14_40.convertString(src.getVersionElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((Enumeration)VersionConvertor_14_40.convertConformanceResourceStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_14_40.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(VersionConvertor_14_40.convertString(src.getPublisherElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_14_40.convertDateTime(src.getDateElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_14_40.convertString(src.getNameElement()));
        }
        for (DataElement.DataElementContactComponent dataElementContactComponent : src.getContact()) {
            tgt.addContact(DataElement14_40.convertDataElementContactComponent(dataElementContactComponent));
        }
        for (CodeableConcept codeableConcept : src.getUseContext()) {
            if (VersionConvertor_14_40.isJurisdiction(codeableConcept)) {
                tgt.addJurisdiction(VersionConvertor_14_40.convertCodeableConcept(codeableConcept));
                continue;
            }
            tgt.addUseContext(VersionConvertor_14_40.convertCodeableConceptToUsageContext(codeableConcept));
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        for (DataElement.DataElementMappingComponent dataElementMappingComponent : src.getMapping()) {
            tgt.addMapping(DataElement14_40.convertDataElementMappingComponent(dataElementMappingComponent));
        }
        for (ElementDefinition elementDefinition : src.getElement()) {
            tgt.getSnapshot().addElement(VersionConvertor_14_40.convertElementDefinition(elementDefinition, src.getElement(), src.getElement().indexOf(elementDefinition)));
        }
        tgt.setKind(StructureDefinition.StructureDefinitionKind.COMPLEXTYPE);
        tgt.setAbstract(false);
        tgt.setType(tgt.getName());
        tgt.setBaseDefinition("http://hl7.org/fhir/StructureDefinition/Element");
        tgt.setDerivation(StructureDefinition.TypeDerivationRule.SPECIALIZATION);
        return tgt;
    }

    public static DataElement.DataElementContactComponent convertDataElementContactComponent(ContactDetail src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        DataElement.DataElementContactComponent tgt = new DataElement.DataElementContactComponent();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_14_40.convertString(src.getNameElement()));
        }
        for (org.hl7.fhir.r4.model.ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_14_40.convertContactPoint(t));
        }
        return tgt;
    }

    public static ContactDetail convertDataElementContactComponent(DataElement.DataElementContactComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ContactDetail tgt = new ContactDetail();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_14_40.convertString(src.getNameElement()));
        }
        for (ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_14_40.convertContactPoint(t));
        }
        return tgt;
    }

    public static StructureDefinition.StructureDefinitionMappingComponent convertDataElementMappingComponent(DataElement.DataElementMappingComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        StructureDefinition.StructureDefinitionMappingComponent tgt = new StructureDefinition.StructureDefinitionMappingComponent();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasIdentityElement()) {
            tgt.setIdentityElement(VersionConvertor_14_40.convertId(src.getIdentityElement()));
        }
        if (src.hasUri()) {
            tgt.setUriElement(VersionConvertor_14_40.convertUri(src.getUriElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_14_40.convertString(src.getNameElement()));
        }
        if (src.hasComment()) {
            tgt.setCommentElement(VersionConvertor_14_40.convertString(src.getCommentElement()));
        }
        return tgt;
    }
}

