/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv14_40;

import org.hl7.fhir.convertors.VersionConvertor_14_40;
import org.hl7.fhir.dstu2016may.model.Bundle;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.Enumeration;

public class Bundle14_40 {
    public static Bundle convertBundle(org.hl7.fhir.dstu2016may.model.Bundle src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Bundle tgt = new Bundle();
        VersionConvertor_14_40.copyResource(src, tgt);
        if (src.hasType()) {
            tgt.setTypeElement(Bundle14_40.convertBundleType(src.getTypeElement()));
        }
        if (src.hasTotal()) {
            tgt.setTotalElement(VersionConvertor_14_40.convertUnsignedInt(src.getTotalElement()));
        }
        for (Bundle.BundleLinkComponent bundleLinkComponent : src.getLink()) {
            tgt.addLink(Bundle14_40.convertBundleLinkComponent(bundleLinkComponent));
        }
        for (Bundle.BundleEntryComponent bundleEntryComponent : src.getEntry()) {
            tgt.addEntry(Bundle14_40.convertBundleEntryComponent(bundleEntryComponent));
        }
        if (src.hasSignature()) {
            tgt.setSignature(VersionConvertor_14_40.convertSignature(src.getSignature()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Bundle convertBundle(Bundle src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Bundle tgt = new org.hl7.fhir.dstu2016may.model.Bundle();
        VersionConvertor_14_40.copyResource(src, tgt);
        if (src.hasType()) {
            tgt.setTypeElement(Bundle14_40.convertBundleType(src.getTypeElement()));
        }
        if (src.hasTotal()) {
            tgt.setTotalElement(VersionConvertor_14_40.convertUnsignedInt(src.getTotalElement()));
        }
        for (Bundle.BundleLinkComponent bundleLinkComponent : src.getLink()) {
            tgt.addLink(Bundle14_40.convertBundleLinkComponent(bundleLinkComponent));
        }
        for (Bundle.BundleEntryComponent bundleEntryComponent : src.getEntry()) {
            tgt.addEntry(Bundle14_40.convertBundleEntryComponent(bundleEntryComponent));
        }
        if (src.hasSignature()) {
            tgt.setSignature(VersionConvertor_14_40.convertSignature(src.getSignature()));
        }
        return tgt;
    }

    public static Bundle.BundleEntryComponent convertBundleEntryComponent(Bundle.BundleEntryComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Bundle.BundleEntryComponent tgt = new Bundle.BundleEntryComponent();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        for (Bundle.BundleLinkComponent t : src.getLink()) {
            tgt.addLink(Bundle14_40.convertBundleLinkComponent(t));
        }
        if (src.hasFullUrl()) {
            tgt.setFullUrlElement(VersionConvertor_14_40.convertUri(src.getFullUrlElement()));
        }
        if (src.hasResource()) {
            tgt.setResource(VersionConvertor_14_40.convertResource(src.getResource()));
        }
        if (src.hasSearch()) {
            tgt.setSearch(Bundle14_40.convertBundleEntrySearchComponent(src.getSearch()));
        }
        if (src.hasRequest()) {
            tgt.setRequest(Bundle14_40.convertBundleEntryRequestComponent(src.getRequest()));
        }
        if (src.hasResponse()) {
            tgt.setResponse(Bundle14_40.convertBundleEntryResponseComponent(src.getResponse()));
        }
        return tgt;
    }

    public static Bundle.BundleEntryComponent convertBundleEntryComponent(Bundle.BundleEntryComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Bundle.BundleEntryComponent tgt = new Bundle.BundleEntryComponent();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        for (Bundle.BundleLinkComponent t : src.getLink()) {
            tgt.addLink(Bundle14_40.convertBundleLinkComponent(t));
        }
        if (src.hasFullUrl()) {
            tgt.setFullUrlElement(VersionConvertor_14_40.convertUri(src.getFullUrlElement()));
        }
        if (src.hasResource()) {
            tgt.setResource(VersionConvertor_14_40.convertResource(src.getResource()));
        }
        if (src.hasSearch()) {
            tgt.setSearch(Bundle14_40.convertBundleEntrySearchComponent(src.getSearch()));
        }
        if (src.hasRequest()) {
            tgt.setRequest(Bundle14_40.convertBundleEntryRequestComponent(src.getRequest()));
        }
        if (src.hasResponse()) {
            tgt.setResponse(Bundle14_40.convertBundleEntryResponseComponent(src.getResponse()));
        }
        return tgt;
    }

    public static Bundle.BundleEntryRequestComponent convertBundleEntryRequestComponent(Bundle.BundleEntryRequestComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Bundle.BundleEntryRequestComponent tgt = new Bundle.BundleEntryRequestComponent();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasMethod()) {
            tgt.setMethodElement(Bundle14_40.convertHTTPVerb(src.getMethodElement()));
        }
        if (src.hasUrlElement()) {
            tgt.setUrlElement(VersionConvertor_14_40.convertUri(src.getUrlElement()));
        }
        if (src.hasIfNoneMatch()) {
            tgt.setIfNoneMatchElement(VersionConvertor_14_40.convertString(src.getIfNoneMatchElement()));
        }
        if (src.hasIfModifiedSince()) {
            tgt.setIfModifiedSinceElement(VersionConvertor_14_40.convertInstant(src.getIfModifiedSinceElement()));
        }
        if (src.hasIfMatch()) {
            tgt.setIfMatchElement(VersionConvertor_14_40.convertString(src.getIfMatchElement()));
        }
        if (src.hasIfNoneExist()) {
            tgt.setIfNoneExistElement(VersionConvertor_14_40.convertString(src.getIfNoneExistElement()));
        }
        return tgt;
    }

    public static Bundle.BundleEntryRequestComponent convertBundleEntryRequestComponent(Bundle.BundleEntryRequestComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Bundle.BundleEntryRequestComponent tgt = new Bundle.BundleEntryRequestComponent();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasMethod()) {
            tgt.setMethodElement(Bundle14_40.convertHTTPVerb(src.getMethodElement()));
        }
        if (src.hasUrlElement()) {
            tgt.setUrlElement(VersionConvertor_14_40.convertUri(src.getUrlElement()));
        }
        if (src.hasIfNoneMatch()) {
            tgt.setIfNoneMatchElement(VersionConvertor_14_40.convertString(src.getIfNoneMatchElement()));
        }
        if (src.hasIfModifiedSince()) {
            tgt.setIfModifiedSinceElement(VersionConvertor_14_40.convertInstant(src.getIfModifiedSinceElement()));
        }
        if (src.hasIfMatch()) {
            tgt.setIfMatchElement(VersionConvertor_14_40.convertString(src.getIfMatchElement()));
        }
        if (src.hasIfNoneExist()) {
            tgt.setIfNoneExistElement(VersionConvertor_14_40.convertString(src.getIfNoneExistElement()));
        }
        return tgt;
    }

    public static Bundle.BundleEntryResponseComponent convertBundleEntryResponseComponent(Bundle.BundleEntryResponseComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Bundle.BundleEntryResponseComponent tgt = new Bundle.BundleEntryResponseComponent();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasStatusElement()) {
            tgt.setStatusElement(VersionConvertor_14_40.convertString(src.getStatusElement()));
        }
        if (src.hasLocation()) {
            tgt.setLocationElement(VersionConvertor_14_40.convertUri(src.getLocationElement()));
        }
        if (src.hasEtag()) {
            tgt.setEtagElement(VersionConvertor_14_40.convertString(src.getEtagElement()));
        }
        if (src.hasLastModified()) {
            tgt.setLastModifiedElement(VersionConvertor_14_40.convertInstant(src.getLastModifiedElement()));
        }
        return tgt;
    }

    public static Bundle.BundleEntryResponseComponent convertBundleEntryResponseComponent(Bundle.BundleEntryResponseComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Bundle.BundleEntryResponseComponent tgt = new Bundle.BundleEntryResponseComponent();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasStatusElement()) {
            tgt.setStatusElement(VersionConvertor_14_40.convertString(src.getStatusElement()));
        }
        if (src.hasLocation()) {
            tgt.setLocationElement(VersionConvertor_14_40.convertUri(src.getLocationElement()));
        }
        if (src.hasEtag()) {
            tgt.setEtagElement(VersionConvertor_14_40.convertString(src.getEtagElement()));
        }
        if (src.hasLastModified()) {
            tgt.setLastModifiedElement(VersionConvertor_14_40.convertInstant(src.getLastModifiedElement()));
        }
        return tgt;
    }

    public static Bundle.BundleEntrySearchComponent convertBundleEntrySearchComponent(Bundle.BundleEntrySearchComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Bundle.BundleEntrySearchComponent tgt = new Bundle.BundleEntrySearchComponent();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasMode()) {
            tgt.setModeElement(Bundle14_40.convertSearchEntryMode(src.getModeElement()));
        }
        if (src.hasScore()) {
            tgt.setScoreElement(VersionConvertor_14_40.convertDecimal(src.getScoreElement()));
        }
        return tgt;
    }

    public static Bundle.BundleEntrySearchComponent convertBundleEntrySearchComponent(Bundle.BundleEntrySearchComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Bundle.BundleEntrySearchComponent tgt = new Bundle.BundleEntrySearchComponent();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasMode()) {
            tgt.setModeElement(Bundle14_40.convertSearchEntryMode(src.getModeElement()));
        }
        if (src.hasScore()) {
            tgt.setScoreElement(VersionConvertor_14_40.convertDecimal(src.getScoreElement()));
        }
        return tgt;
    }

    public static Bundle.BundleLinkComponent convertBundleLinkComponent(Bundle.BundleLinkComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Bundle.BundleLinkComponent tgt = new Bundle.BundleLinkComponent();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasRelationElement()) {
            tgt.setRelationElement(VersionConvertor_14_40.convertString(src.getRelationElement()));
        }
        if (src.hasUrlElement()) {
            tgt.setUrlElement(VersionConvertor_14_40.convertUri(src.getUrlElement()));
        }
        return tgt;
    }

    public static Bundle.BundleLinkComponent convertBundleLinkComponent(Bundle.BundleLinkComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Bundle.BundleLinkComponent tgt = new Bundle.BundleLinkComponent();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasRelationElement()) {
            tgt.setRelationElement(VersionConvertor_14_40.convertString(src.getRelationElement()));
        }
        if (src.hasUrlElement()) {
            tgt.setUrlElement(VersionConvertor_14_40.convertUri(src.getUrlElement()));
        }
        return tgt;
    }

    public static Enumeration<Bundle.BundleType> convertBundleType(org.hl7.fhir.dstu2016may.model.Enumeration<Bundle.BundleType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Bundle.BundleType> tgt = new Enumeration<Bundle.BundleType>(new Bundle.BundleTypeEnumFactory());
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        switch ((Bundle.BundleType)((Object)src.getValue())) {
            case DOCUMENT: {
                tgt.setValue((Object)Bundle.BundleType.DOCUMENT);
                break;
            }
            case MESSAGE: {
                tgt.setValue((Object)Bundle.BundleType.MESSAGE);
                break;
            }
            case TRANSACTION: {
                tgt.setValue((Object)Bundle.BundleType.TRANSACTION);
                break;
            }
            case TRANSACTIONRESPONSE: {
                tgt.setValue((Object)Bundle.BundleType.TRANSACTIONRESPONSE);
                break;
            }
            case BATCH: {
                tgt.setValue((Object)Bundle.BundleType.BATCH);
                break;
            }
            case BATCHRESPONSE: {
                tgt.setValue((Object)Bundle.BundleType.BATCHRESPONSE);
                break;
            }
            case HISTORY: {
                tgt.setValue((Object)Bundle.BundleType.HISTORY);
                break;
            }
            case SEARCHSET: {
                tgt.setValue((Object)Bundle.BundleType.SEARCHSET);
                break;
            }
            case COLLECTION: {
                tgt.setValue((Object)Bundle.BundleType.COLLECTION);
                break;
            }
            default: {
                tgt.setValue((Object)Bundle.BundleType.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Enumeration<Bundle.BundleType> convertBundleType(Enumeration<Bundle.BundleType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Enumeration<Bundle.BundleType> tgt = new org.hl7.fhir.dstu2016may.model.Enumeration<Bundle.BundleType>(new Bundle.BundleTypeEnumFactory());
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        switch ((Bundle.BundleType)((Object)src.getValue())) {
            case DOCUMENT: {
                tgt.setValue((Object)Bundle.BundleType.DOCUMENT);
                break;
            }
            case MESSAGE: {
                tgt.setValue((Object)Bundle.BundleType.MESSAGE);
                break;
            }
            case TRANSACTION: {
                tgt.setValue((Object)Bundle.BundleType.TRANSACTION);
                break;
            }
            case TRANSACTIONRESPONSE: {
                tgt.setValue((Object)Bundle.BundleType.TRANSACTIONRESPONSE);
                break;
            }
            case BATCH: {
                tgt.setValue((Object)Bundle.BundleType.BATCH);
                break;
            }
            case BATCHRESPONSE: {
                tgt.setValue((Object)Bundle.BundleType.BATCHRESPONSE);
                break;
            }
            case HISTORY: {
                tgt.setValue((Object)Bundle.BundleType.HISTORY);
                break;
            }
            case SEARCHSET: {
                tgt.setValue((Object)Bundle.BundleType.SEARCHSET);
                break;
            }
            case COLLECTION: {
                tgt.setValue((Object)Bundle.BundleType.COLLECTION);
                break;
            }
            default: {
                tgt.setValue((Object)Bundle.BundleType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Bundle.HTTPVerb> convertHTTPVerb(org.hl7.fhir.dstu2016may.model.Enumeration<Bundle.HTTPVerb> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Bundle.HTTPVerb> tgt = new Enumeration<Bundle.HTTPVerb>(new Bundle.HTTPVerbEnumFactory());
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        switch ((Bundle.HTTPVerb)((Object)src.getValue())) {
            case GET: {
                tgt.setValue((Object)Bundle.HTTPVerb.GET);
                break;
            }
            case POST: {
                tgt.setValue((Object)Bundle.HTTPVerb.POST);
                break;
            }
            case PUT: {
                tgt.setValue((Object)Bundle.HTTPVerb.PUT);
                break;
            }
            case DELETE: {
                tgt.setValue((Object)Bundle.HTTPVerb.DELETE);
                break;
            }
            default: {
                tgt.setValue((Object)Bundle.HTTPVerb.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Enumeration<Bundle.HTTPVerb> convertHTTPVerb(Enumeration<Bundle.HTTPVerb> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Enumeration<Bundle.HTTPVerb> tgt = new org.hl7.fhir.dstu2016may.model.Enumeration<Bundle.HTTPVerb>(new Bundle.HTTPVerbEnumFactory());
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        switch ((Bundle.HTTPVerb)((Object)src.getValue())) {
            case GET: {
                tgt.setValue((Object)Bundle.HTTPVerb.GET);
                break;
            }
            case POST: {
                tgt.setValue((Object)Bundle.HTTPVerb.POST);
                break;
            }
            case PUT: {
                tgt.setValue((Object)Bundle.HTTPVerb.PUT);
                break;
            }
            case DELETE: {
                tgt.setValue((Object)Bundle.HTTPVerb.DELETE);
                break;
            }
            default: {
                tgt.setValue((Object)Bundle.HTTPVerb.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Bundle.SearchEntryMode> convertSearchEntryMode(org.hl7.fhir.dstu2016may.model.Enumeration<Bundle.SearchEntryMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Bundle.SearchEntryMode> tgt = new Enumeration<Bundle.SearchEntryMode>(new Bundle.SearchEntryModeEnumFactory());
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        switch ((Bundle.SearchEntryMode)((Object)src.getValue())) {
            case MATCH: {
                tgt.setValue((Object)Bundle.SearchEntryMode.MATCH);
                break;
            }
            case INCLUDE: {
                tgt.setValue((Object)Bundle.SearchEntryMode.INCLUDE);
                break;
            }
            case OUTCOME: {
                tgt.setValue((Object)Bundle.SearchEntryMode.OUTCOME);
                break;
            }
            default: {
                tgt.setValue((Object)Bundle.SearchEntryMode.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Enumeration<Bundle.SearchEntryMode> convertSearchEntryMode(Enumeration<Bundle.SearchEntryMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Enumeration<Bundle.SearchEntryMode> tgt = new org.hl7.fhir.dstu2016may.model.Enumeration<Bundle.SearchEntryMode>(new Bundle.SearchEntryModeEnumFactory());
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        switch ((Bundle.SearchEntryMode)((Object)src.getValue())) {
            case MATCH: {
                tgt.setValue((Object)Bundle.SearchEntryMode.MATCH);
                break;
            }
            case INCLUDE: {
                tgt.setValue((Object)Bundle.SearchEntryMode.INCLUDE);
                break;
            }
            case OUTCOME: {
                tgt.setValue((Object)Bundle.SearchEntryMode.OUTCOME);
                break;
            }
            default: {
                tgt.setValue((Object)Bundle.SearchEntryMode.NULL);
            }
        }
        return tgt;
    }
}

