/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv14_30;

import org.hl7.fhir.convertors.VersionConvertor_14_30;
import org.hl7.fhir.dstu2016may.model.ContactPoint;
import org.hl7.fhir.dstu2016may.model.Enumeration;
import org.hl7.fhir.dstu2016may.model.IntegerType;
import org.hl7.fhir.dstu2016may.model.Reference;
import org.hl7.fhir.dstu2016may.model.TestScript;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.ContactDetail;
import org.hl7.fhir.dstu3.model.TestScript;
import org.hl7.fhir.dstu3.model.UriType;
import org.hl7.fhir.dstu3.model.UsageContext;
import org.hl7.fhir.exceptions.FHIRException;

public class TestScript14_30 {
    public static org.hl7.fhir.dstu3.model.Enumeration<TestScript.AssertionDirectionType> convertAssertionDirectionType(Enumeration<TestScript.AssertionDirectionType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<TestScript.AssertionDirectionType> tgt = new org.hl7.fhir.dstu3.model.Enumeration<TestScript.AssertionDirectionType>(new TestScript.AssertionDirectionTypeEnumFactory());
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        switch ((TestScript.AssertionDirectionType)((Object)src.getValue())) {
            case RESPONSE: {
                tgt.setValue((Object)TestScript.AssertionDirectionType.RESPONSE);
                break;
            }
            case REQUEST: {
                tgt.setValue((Object)TestScript.AssertionDirectionType.REQUEST);
                break;
            }
            default: {
                tgt.setValue((Object)TestScript.AssertionDirectionType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<TestScript.AssertionDirectionType> convertAssertionDirectionType(org.hl7.fhir.dstu3.model.Enumeration<TestScript.AssertionDirectionType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<TestScript.AssertionDirectionType> tgt = new Enumeration<TestScript.AssertionDirectionType>(new TestScript.AssertionDirectionTypeEnumFactory());
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        switch ((TestScript.AssertionDirectionType)((Object)src.getValue())) {
            case RESPONSE: {
                tgt.setValue((Object)TestScript.AssertionDirectionType.RESPONSE);
                break;
            }
            case REQUEST: {
                tgt.setValue((Object)TestScript.AssertionDirectionType.REQUEST);
                break;
            }
            default: {
                tgt.setValue((Object)TestScript.AssertionDirectionType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<TestScript.AssertionOperatorType> convertAssertionOperatorType(org.hl7.fhir.dstu3.model.Enumeration<TestScript.AssertionOperatorType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<TestScript.AssertionOperatorType> tgt = new Enumeration<TestScript.AssertionOperatorType>(new TestScript.AssertionOperatorTypeEnumFactory());
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        switch ((TestScript.AssertionOperatorType)((Object)src.getValue())) {
            case EQUALS: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.EQUALS);
                break;
            }
            case NOTEQUALS: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.NOTEQUALS);
                break;
            }
            case IN: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.IN);
                break;
            }
            case NOTIN: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.NOTIN);
                break;
            }
            case GREATERTHAN: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.GREATERTHAN);
                break;
            }
            case LESSTHAN: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.LESSTHAN);
                break;
            }
            case EMPTY: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.EMPTY);
                break;
            }
            case NOTEMPTY: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.NOTEMPTY);
                break;
            }
            case CONTAINS: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.CONTAINS);
                break;
            }
            case NOTCONTAINS: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.NOTCONTAINS);
                break;
            }
            default: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<TestScript.AssertionOperatorType> convertAssertionOperatorType(Enumeration<TestScript.AssertionOperatorType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<TestScript.AssertionOperatorType> tgt = new org.hl7.fhir.dstu3.model.Enumeration<TestScript.AssertionOperatorType>(new TestScript.AssertionOperatorTypeEnumFactory());
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        switch ((TestScript.AssertionOperatorType)((Object)src.getValue())) {
            case EQUALS: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.EQUALS);
                break;
            }
            case NOTEQUALS: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.NOTEQUALS);
                break;
            }
            case IN: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.IN);
                break;
            }
            case NOTIN: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.NOTIN);
                break;
            }
            case GREATERTHAN: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.GREATERTHAN);
                break;
            }
            case LESSTHAN: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.LESSTHAN);
                break;
            }
            case EMPTY: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.EMPTY);
                break;
            }
            case NOTEMPTY: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.NOTEMPTY);
                break;
            }
            case CONTAINS: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.CONTAINS);
                break;
            }
            case NOTCONTAINS: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.NOTCONTAINS);
                break;
            }
            default: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<TestScript.AssertionResponseTypes> convertAssertionResponseTypes(Enumeration<TestScript.AssertionResponseTypes> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<TestScript.AssertionResponseTypes> tgt = new org.hl7.fhir.dstu3.model.Enumeration<TestScript.AssertionResponseTypes>(new TestScript.AssertionResponseTypesEnumFactory());
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        switch ((TestScript.AssertionResponseTypes)((Object)src.getValue())) {
            case OKAY: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.OKAY);
                break;
            }
            case CREATED: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.CREATED);
                break;
            }
            case NOCONTENT: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.NOCONTENT);
                break;
            }
            case NOTMODIFIED: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.NOTMODIFIED);
                break;
            }
            case BAD: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.BAD);
                break;
            }
            case FORBIDDEN: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.FORBIDDEN);
                break;
            }
            case NOTFOUND: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.NOTFOUND);
                break;
            }
            case METHODNOTALLOWED: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.METHODNOTALLOWED);
                break;
            }
            case CONFLICT: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.CONFLICT);
                break;
            }
            case GONE: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.GONE);
                break;
            }
            case PRECONDITIONFAILED: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.PRECONDITIONFAILED);
                break;
            }
            case UNPROCESSABLE: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.UNPROCESSABLE);
                break;
            }
            default: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<TestScript.AssertionResponseTypes> convertAssertionResponseTypes(org.hl7.fhir.dstu3.model.Enumeration<TestScript.AssertionResponseTypes> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<TestScript.AssertionResponseTypes> tgt = new Enumeration<TestScript.AssertionResponseTypes>(new TestScript.AssertionResponseTypesEnumFactory());
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        switch ((TestScript.AssertionResponseTypes)((Object)src.getValue())) {
            case OKAY: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.OKAY);
                break;
            }
            case CREATED: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.CREATED);
                break;
            }
            case NOCONTENT: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.NOCONTENT);
                break;
            }
            case NOTMODIFIED: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.NOTMODIFIED);
                break;
            }
            case BAD: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.BAD);
                break;
            }
            case FORBIDDEN: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.FORBIDDEN);
                break;
            }
            case NOTFOUND: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.NOTFOUND);
                break;
            }
            case METHODNOTALLOWED: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.METHODNOTALLOWED);
                break;
            }
            case CONFLICT: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.CONFLICT);
                break;
            }
            case GONE: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.GONE);
                break;
            }
            case PRECONDITIONFAILED: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.PRECONDITIONFAILED);
                break;
            }
            case UNPROCESSABLE: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.UNPROCESSABLE);
                break;
            }
            default: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<TestScript.ContentType> convertContentType(Enumeration<TestScript.ContentType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<TestScript.ContentType> tgt = new org.hl7.fhir.dstu3.model.Enumeration<TestScript.ContentType>(new TestScript.ContentTypeEnumFactory());
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        switch ((TestScript.ContentType)((Object)src.getValue())) {
            case XML: {
                tgt.setValue((Object)TestScript.ContentType.XML);
                break;
            }
            case JSON: {
                tgt.setValue((Object)TestScript.ContentType.JSON);
                break;
            }
            default: {
                tgt.setValue((Object)TestScript.ContentType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<TestScript.ContentType> convertContentType(org.hl7.fhir.dstu3.model.Enumeration<TestScript.ContentType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<TestScript.ContentType> tgt = new Enumeration<TestScript.ContentType>(new TestScript.ContentTypeEnumFactory());
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        switch ((TestScript.ContentType)((Object)src.getValue())) {
            case XML: {
                tgt.setValue((Object)TestScript.ContentType.XML);
                break;
            }
            case JSON: {
                tgt.setValue((Object)TestScript.ContentType.JSON);
                break;
            }
            default: {
                tgt.setValue((Object)TestScript.ContentType.NULL);
            }
        }
        return tgt;
    }

    public static TestScript.SetupActionAssertComponent convertSetupActionAssertComponent(TestScript.SetupActionAssertComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.SetupActionAssertComponent tgt = new TestScript.SetupActionAssertComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasLabel()) {
            tgt.setLabelElement(VersionConvertor_14_30.convertString(src.getLabelElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_14_30.convertString(src.getDescriptionElement()));
        }
        if (src.hasDirection()) {
            tgt.setDirectionElement(TestScript14_30.convertAssertionDirectionType(src.getDirectionElement()));
        }
        if (src.hasCompareToSourceId()) {
            tgt.setCompareToSourceIdElement(VersionConvertor_14_30.convertString(src.getCompareToSourceIdElement()));
        }
        if (src.hasCompareToSourcePath()) {
            tgt.setCompareToSourcePathElement(VersionConvertor_14_30.convertString(src.getCompareToSourcePathElement()));
        }
        if (src.hasContentType()) {
            tgt.setContentTypeElement(TestScript14_30.convertContentType(src.getContentTypeElement()));
        }
        if (src.hasHeaderField()) {
            tgt.setHeaderFieldElement(VersionConvertor_14_30.convertString(src.getHeaderFieldElement()));
        }
        if (src.hasMinimumId()) {
            tgt.setMinimumIdElement(VersionConvertor_14_30.convertString(src.getMinimumIdElement()));
        }
        if (src.hasNavigationLinks()) {
            tgt.setNavigationLinksElement(VersionConvertor_14_30.convertBoolean(src.getNavigationLinksElement()));
        }
        if (src.hasOperator()) {
            tgt.setOperatorElement(TestScript14_30.convertAssertionOperatorType(src.getOperatorElement()));
        }
        if (src.hasPath()) {
            tgt.setPathElement(VersionConvertor_14_30.convertString(src.getPathElement()));
        }
        if (src.hasResource()) {
            tgt.setResourceElement(VersionConvertor_14_30.convertCode(src.getResourceElement()));
        }
        if (src.hasResponse()) {
            tgt.setResponseElement(TestScript14_30.convertAssertionResponseTypes(src.getResponseElement()));
        }
        if (src.hasResponseCode()) {
            tgt.setResponseCodeElement(VersionConvertor_14_30.convertString(src.getResponseCodeElement()));
        }
        if (src.hasRule()) {
            tgt.setRule(TestScript14_30.convertSetupActionAssertRuleComponent(src.getRule()));
        }
        if (src.hasRuleset()) {
            tgt.setRuleset(TestScript14_30.convertSetupActionAssertRulesetComponent(src.getRuleset()));
        }
        if (src.hasSourceId()) {
            tgt.setSourceIdElement(VersionConvertor_14_30.convertId(src.getSourceIdElement()));
        }
        if (src.hasValidateProfileId()) {
            tgt.setValidateProfileIdElement(VersionConvertor_14_30.convertId(src.getValidateProfileIdElement()));
        }
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_14_30.convertString(src.getValueElement()));
        }
        if (src.hasWarningOnly()) {
            tgt.setWarningOnlyElement(VersionConvertor_14_30.convertBoolean(src.getWarningOnlyElement()));
        }
        return tgt;
    }

    public static TestScript.SetupActionAssertComponent convertSetupActionAssertComponent(TestScript.SetupActionAssertComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.SetupActionAssertComponent tgt = new TestScript.SetupActionAssertComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasLabel()) {
            tgt.setLabelElement(VersionConvertor_14_30.convertString(src.getLabelElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_14_30.convertString(src.getDescriptionElement()));
        }
        if (src.hasDirection()) {
            tgt.setDirectionElement(TestScript14_30.convertAssertionDirectionType(src.getDirectionElement()));
        }
        if (src.hasCompareToSourceId()) {
            tgt.setCompareToSourceIdElement(VersionConvertor_14_30.convertString(src.getCompareToSourceIdElement()));
        }
        if (src.hasCompareToSourcePath()) {
            tgt.setCompareToSourcePathElement(VersionConvertor_14_30.convertString(src.getCompareToSourcePathElement()));
        }
        if (src.hasContentType()) {
            tgt.setContentTypeElement(TestScript14_30.convertContentType(src.getContentTypeElement()));
        }
        if (src.hasHeaderField()) {
            tgt.setHeaderFieldElement(VersionConvertor_14_30.convertString(src.getHeaderFieldElement()));
        }
        if (src.hasMinimumId()) {
            tgt.setMinimumIdElement(VersionConvertor_14_30.convertString(src.getMinimumIdElement()));
        }
        if (src.hasNavigationLinks()) {
            tgt.setNavigationLinksElement(VersionConvertor_14_30.convertBoolean(src.getNavigationLinksElement()));
        }
        if (src.hasOperator()) {
            tgt.setOperatorElement(TestScript14_30.convertAssertionOperatorType(src.getOperatorElement()));
        }
        if (src.hasPath()) {
            tgt.setPathElement(VersionConvertor_14_30.convertString(src.getPathElement()));
        }
        if (src.hasResource()) {
            tgt.setResourceElement(VersionConvertor_14_30.convertCode(src.getResourceElement()));
        }
        if (src.hasResponse()) {
            tgt.setResponseElement(TestScript14_30.convertAssertionResponseTypes(src.getResponseElement()));
        }
        if (src.hasResponseCode()) {
            tgt.setResponseCodeElement(VersionConvertor_14_30.convertString(src.getResponseCodeElement()));
        }
        if (src.hasRule()) {
            tgt.setRule(TestScript14_30.convertSetupActionAssertRuleComponent(src.getRule()));
        }
        if (src.hasRuleset()) {
            tgt.setRuleset(TestScript14_30.convertSetupActionAssertRulesetComponent(src.getRuleset()));
        }
        if (src.hasSourceId()) {
            tgt.setSourceIdElement(VersionConvertor_14_30.convertId(src.getSourceIdElement()));
        }
        if (src.hasValidateProfileId()) {
            tgt.setValidateProfileIdElement(VersionConvertor_14_30.convertId(src.getValidateProfileIdElement()));
        }
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_14_30.convertString(src.getValueElement()));
        }
        if (src.hasWarningOnly()) {
            tgt.setWarningOnlyElement(VersionConvertor_14_30.convertBoolean(src.getWarningOnlyElement()));
        }
        return tgt;
    }

    public static TestScript.SetupActionAssertRuleComponent convertSetupActionAssertRuleComponent(TestScript.ActionAssertRuleComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.SetupActionAssertRuleComponent tgt = new TestScript.SetupActionAssertRuleComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        for (TestScript.ActionAssertRuleParamComponent t : src.getParam()) {
            tgt.addParam(TestScript14_30.convertSetupActionAssertRuleParamComponent(t));
        }
        return tgt;
    }

    public static TestScript.ActionAssertRuleComponent convertSetupActionAssertRuleComponent(TestScript.SetupActionAssertRuleComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.ActionAssertRuleComponent tgt = new TestScript.ActionAssertRuleComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        for (TestScript.SetupActionAssertRuleParamComponent t : src.getParam()) {
            tgt.addParam(TestScript14_30.convertSetupActionAssertRuleParamComponent(t));
        }
        return tgt;
    }

    public static TestScript.ActionAssertRuleParamComponent convertSetupActionAssertRuleParamComponent(TestScript.SetupActionAssertRuleParamComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.ActionAssertRuleParamComponent tgt = new TestScript.ActionAssertRuleParamComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_14_30.convertString(src.getNameElement()));
        }
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_14_30.convertString(src.getValueElement()));
        }
        return tgt;
    }

    public static TestScript.SetupActionAssertRuleParamComponent convertSetupActionAssertRuleParamComponent(TestScript.ActionAssertRuleParamComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.SetupActionAssertRuleParamComponent tgt = new TestScript.SetupActionAssertRuleParamComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_14_30.convertString(src.getNameElement()));
        }
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_14_30.convertString(src.getValueElement()));
        }
        return tgt;
    }

    public static TestScript.SetupActionAssertRulesetComponent convertSetupActionAssertRulesetComponent(TestScript.ActionAssertRulesetComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.SetupActionAssertRulesetComponent tgt = new TestScript.SetupActionAssertRulesetComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        for (TestScript.ActionAssertRulesetRuleComponent t : src.getRule()) {
            tgt.addRule(TestScript14_30.convertSetupActionAssertRulesetRuleComponent(t));
        }
        return tgt;
    }

    public static TestScript.ActionAssertRulesetComponent convertSetupActionAssertRulesetComponent(TestScript.SetupActionAssertRulesetComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.ActionAssertRulesetComponent tgt = new TestScript.ActionAssertRulesetComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        for (TestScript.SetupActionAssertRulesetRuleComponent t : src.getRule()) {
            tgt.addRule(TestScript14_30.convertSetupActionAssertRulesetRuleComponent(t));
        }
        return tgt;
    }

    public static TestScript.ActionAssertRulesetRuleComponent convertSetupActionAssertRulesetRuleComponent(TestScript.SetupActionAssertRulesetRuleComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.ActionAssertRulesetRuleComponent tgt = new TestScript.ActionAssertRulesetRuleComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        for (TestScript.SetupActionAssertRulesetRuleParamComponent t : src.getParam()) {
            tgt.addParam(TestScript14_30.convertSetupActionAssertRulesetRuleParamComponent(t));
        }
        return tgt;
    }

    public static TestScript.SetupActionAssertRulesetRuleComponent convertSetupActionAssertRulesetRuleComponent(TestScript.ActionAssertRulesetRuleComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.SetupActionAssertRulesetRuleComponent tgt = new TestScript.SetupActionAssertRulesetRuleComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        for (TestScript.ActionAssertRulesetRuleParamComponent t : src.getParam()) {
            tgt.addParam(TestScript14_30.convertSetupActionAssertRulesetRuleParamComponent(t));
        }
        return tgt;
    }

    public static TestScript.SetupActionAssertRulesetRuleParamComponent convertSetupActionAssertRulesetRuleParamComponent(TestScript.ActionAssertRulesetRuleParamComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.SetupActionAssertRulesetRuleParamComponent tgt = new TestScript.SetupActionAssertRulesetRuleParamComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_14_30.convertString(src.getNameElement()));
        }
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_14_30.convertString(src.getValueElement()));
        }
        return tgt;
    }

    public static TestScript.ActionAssertRulesetRuleParamComponent convertSetupActionAssertRulesetRuleParamComponent(TestScript.SetupActionAssertRulesetRuleParamComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.ActionAssertRulesetRuleParamComponent tgt = new TestScript.ActionAssertRulesetRuleParamComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_14_30.convertString(src.getNameElement()));
        }
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_14_30.convertString(src.getValueElement()));
        }
        return tgt;
    }

    public static TestScript.SetupActionComponent convertSetupActionComponent(TestScript.SetupActionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.SetupActionComponent tgt = new TestScript.SetupActionComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasOperation()) {
            tgt.setOperation(TestScript14_30.convertSetupActionOperationComponent(src.getOperation()));
        }
        if (src.hasAssert()) {
            tgt.setAssert(TestScript14_30.convertSetupActionAssertComponent(src.getAssert()));
        }
        return tgt;
    }

    public static TestScript.SetupActionComponent convertSetupActionComponent(TestScript.SetupActionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.SetupActionComponent tgt = new TestScript.SetupActionComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasOperation()) {
            tgt.setOperation(TestScript14_30.convertSetupActionOperationComponent(src.getOperation()));
        }
        if (src.hasAssert()) {
            tgt.setAssert(TestScript14_30.convertSetupActionAssertComponent(src.getAssert()));
        }
        return tgt;
    }

    public static TestScript.SetupActionOperationComponent convertSetupActionOperationComponent(TestScript.SetupActionOperationComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.SetupActionOperationComponent tgt = new TestScript.SetupActionOperationComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setType(VersionConvertor_14_30.convertCoding(src.getType()));
        }
        if (src.hasResource()) {
            tgt.setResourceElement(VersionConvertor_14_30.convertCode(src.getResourceElement()));
        }
        if (src.hasLabel()) {
            tgt.setLabelElement(VersionConvertor_14_30.convertString(src.getLabelElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_14_30.convertString(src.getDescriptionElement()));
        }
        if (src.hasAccept()) {
            tgt.setAcceptElement(TestScript14_30.convertContentType(src.getAcceptElement()));
        }
        if (src.hasContentType()) {
            tgt.setContentTypeElement(TestScript14_30.convertContentType(src.getContentTypeElement()));
        }
        if (src.hasDestination()) {
            tgt.setDestinationElement(VersionConvertor_14_30.convertInteger(src.getDestinationElement()));
        }
        if (src.hasEncodeRequestUrl()) {
            tgt.setEncodeRequestUrlElement(VersionConvertor_14_30.convertBoolean(src.getEncodeRequestUrlElement()));
        }
        if (src.hasOrigin()) {
            tgt.setOriginElement(VersionConvertor_14_30.convertInteger(src.getOriginElement()));
        }
        if (src.hasParams()) {
            tgt.setParamsElement(VersionConvertor_14_30.convertString(src.getParamsElement()));
        }
        for (TestScript.SetupActionOperationRequestHeaderComponent t : src.getRequestHeader()) {
            tgt.addRequestHeader(TestScript14_30.convertSetupActionOperationRequestHeaderComponent(t));
        }
        if (src.hasResponseId()) {
            tgt.setResponseIdElement(VersionConvertor_14_30.convertId(src.getResponseIdElement()));
        }
        if (src.hasSourceId()) {
            tgt.setSourceIdElement(VersionConvertor_14_30.convertId(src.getSourceIdElement()));
        }
        if (src.hasTargetId()) {
            tgt.setTargetId(src.getTargetId());
        }
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_14_30.convertString(src.getUrlElement()));
        }
        return tgt;
    }

    public static TestScript.SetupActionOperationComponent convertSetupActionOperationComponent(TestScript.SetupActionOperationComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.SetupActionOperationComponent tgt = new TestScript.SetupActionOperationComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasResource()) {
            tgt.setResourceElement(VersionConvertor_14_30.convertCode(src.getResourceElement()));
        }
        if (src.hasLabel()) {
            tgt.setLabelElement(VersionConvertor_14_30.convertString(src.getLabelElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_14_30.convertString(src.getDescriptionElement()));
        }
        if (src.hasAccept()) {
            tgt.setAcceptElement(TestScript14_30.convertContentType(src.getAcceptElement()));
        }
        if (src.hasContentType()) {
            tgt.setContentTypeElement(TestScript14_30.convertContentType(src.getContentTypeElement()));
        }
        if (src.hasDestination()) {
            tgt.setDestinationElement(VersionConvertor_14_30.convertInteger(src.getDestinationElement()));
        }
        if (src.hasEncodeRequestUrl()) {
            tgt.setEncodeRequestUrlElement(VersionConvertor_14_30.convertBoolean(src.getEncodeRequestUrlElement()));
        }
        if (src.hasOrigin()) {
            tgt.setOriginElement(VersionConvertor_14_30.convertInteger(src.getOriginElement()));
        }
        if (src.hasParams()) {
            tgt.setParamsElement(VersionConvertor_14_30.convertString(src.getParamsElement()));
        }
        for (TestScript.SetupActionOperationRequestHeaderComponent t : src.getRequestHeader()) {
            tgt.addRequestHeader(TestScript14_30.convertSetupActionOperationRequestHeaderComponent(t));
        }
        if (src.hasResponseId()) {
            tgt.setResponseIdElement(VersionConvertor_14_30.convertId(src.getResponseIdElement()));
        }
        if (src.hasSourceId()) {
            tgt.setSourceIdElement(VersionConvertor_14_30.convertId(src.getSourceIdElement()));
        }
        if (src.hasTargetId()) {
            tgt.setTargetId(src.getTargetId());
        }
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_14_30.convertString(src.getUrlElement()));
        }
        return tgt;
    }

    public static TestScript.SetupActionOperationRequestHeaderComponent convertSetupActionOperationRequestHeaderComponent(TestScript.SetupActionOperationRequestHeaderComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.SetupActionOperationRequestHeaderComponent tgt = new TestScript.SetupActionOperationRequestHeaderComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasFieldElement()) {
            tgt.setFieldElement(VersionConvertor_14_30.convertString(src.getFieldElement()));
        }
        if (src.hasValueElement()) {
            tgt.setValueElement(VersionConvertor_14_30.convertString(src.getValueElement()));
        }
        return tgt;
    }

    public static TestScript.SetupActionOperationRequestHeaderComponent convertSetupActionOperationRequestHeaderComponent(TestScript.SetupActionOperationRequestHeaderComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.SetupActionOperationRequestHeaderComponent tgt = new TestScript.SetupActionOperationRequestHeaderComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasFieldElement()) {
            tgt.setFieldElement(VersionConvertor_14_30.convertString(src.getFieldElement()));
        }
        if (src.hasValueElement()) {
            tgt.setValueElement(VersionConvertor_14_30.convertString(src.getValueElement()));
        }
        return tgt;
    }

    public static TestScript.TeardownActionComponent convertTeardownActionComponent(TestScript.TeardownActionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TeardownActionComponent tgt = new TestScript.TeardownActionComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasOperation()) {
            tgt.setOperation(TestScript14_30.convertSetupActionOperationComponent(src.getOperation()));
        }
        return tgt;
    }

    public static TestScript.TeardownActionComponent convertTeardownActionComponent(TestScript.TeardownActionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TeardownActionComponent tgt = new TestScript.TeardownActionComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasOperation()) {
            tgt.setOperation(TestScript14_30.convertSetupActionOperationComponent(src.getOperation()));
        }
        return tgt;
    }

    public static TestScript.TestActionComponent convertTestActionComponent(TestScript.TestActionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestActionComponent tgt = new TestScript.TestActionComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasOperation()) {
            tgt.setOperation(TestScript14_30.convertSetupActionOperationComponent(src.getOperation()));
        }
        if (src.hasAssert()) {
            tgt.setAssert(TestScript14_30.convertSetupActionAssertComponent(src.getAssert()));
        }
        return tgt;
    }

    public static TestScript.TestActionComponent convertTestActionComponent(TestScript.TestActionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestActionComponent tgt = new TestScript.TestActionComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasOperation()) {
            tgt.setOperation(TestScript14_30.convertSetupActionOperationComponent(src.getOperation()));
        }
        if (src.hasAssert()) {
            tgt.setAssert(TestScript14_30.convertSetupActionAssertComponent(src.getAssert()));
        }
        return tgt;
    }

    public static TestScript convertTestScript(org.hl7.fhir.dstu2016may.model.TestScript src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript tgt = new TestScript();
        VersionConvertor_14_30.copyDomainResource(src, tgt);
        if (src.hasUrlElement()) {
            tgt.setUrlElement(VersionConvertor_14_30.convertUri(src.getUrlElement()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_14_30.convertString(src.getVersionElement()));
        }
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_14_30.convertString(src.getNameElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((org.hl7.fhir.dstu3.model.Enumeration)VersionConvertor_14_30.convertConformanceResourceStatus(src.getStatusElement()));
        }
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_14_30.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_14_30.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(VersionConvertor_14_30.convertString(src.getPublisherElement()));
        }
        for (TestScript.TestScriptContactComponent testScriptContactComponent : src.getContact()) {
            tgt.addContact(TestScript14_30.convertTestScriptContactComponent(testScriptContactComponent));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_14_30.convertDateTime(src.getDateElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (org.hl7.fhir.dstu2016may.model.CodeableConcept codeableConcept : src.getUseContext()) {
            if (VersionConvertor_14_30.isJurisdiction(codeableConcept)) {
                tgt.addJurisdiction(VersionConvertor_14_30.convertCodeableConcept(codeableConcept));
                continue;
            }
            tgt.addUseContext(VersionConvertor_14_30.convertCodeableConceptToUsageContext(codeableConcept));
        }
        if (src.hasRequirements()) {
            tgt.setPurpose(src.getRequirements());
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        for (TestScript.TestScriptOriginComponent testScriptOriginComponent : src.getOrigin()) {
            tgt.addOrigin(TestScript14_30.convertTestScriptOriginComponent(testScriptOriginComponent));
        }
        for (TestScript.TestScriptDestinationComponent testScriptDestinationComponent : src.getDestination()) {
            tgt.addDestination(TestScript14_30.convertTestScriptDestinationComponent(testScriptDestinationComponent));
        }
        if (src.hasMetadata()) {
            tgt.setMetadata(TestScript14_30.convertTestScriptMetadataComponent(src.getMetadata()));
        }
        for (TestScript.TestScriptFixtureComponent testScriptFixtureComponent : src.getFixture()) {
            tgt.addFixture(TestScript14_30.convertTestScriptFixtureComponent(testScriptFixtureComponent));
        }
        for (Reference reference : src.getProfile()) {
            tgt.addProfile(VersionConvertor_14_30.convertReference(reference));
        }
        for (TestScript.TestScriptVariableComponent testScriptVariableComponent : src.getVariable()) {
            tgt.addVariable(TestScript14_30.convertTestScriptVariableComponent(testScriptVariableComponent));
        }
        for (TestScript.TestScriptRuleComponent testScriptRuleComponent : src.getRule()) {
            tgt.addRule(TestScript14_30.convertTestScriptRuleComponent(testScriptRuleComponent));
        }
        for (TestScript.TestScriptRulesetComponent testScriptRulesetComponent : src.getRuleset()) {
            tgt.addRuleset(TestScript14_30.convertTestScriptRulesetComponent(testScriptRulesetComponent));
        }
        if (src.hasSetup()) {
            tgt.setSetup(TestScript14_30.convertTestScriptSetupComponent(src.getSetup()));
        }
        for (TestScript.TestScriptTestComponent testScriptTestComponent : src.getTest()) {
            tgt.addTest(TestScript14_30.convertTestScriptTestComponent(testScriptTestComponent));
        }
        if (src.hasTeardown()) {
            tgt.setTeardown(TestScript14_30.convertTestScriptTeardownComponent(src.getTeardown()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.TestScript convertTestScript(TestScript src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.TestScript tgt = new org.hl7.fhir.dstu2016may.model.TestScript();
        VersionConvertor_14_30.copyDomainResource(src, tgt);
        if (src.hasUrlElement()) {
            tgt.setUrlElement(VersionConvertor_14_30.convertUri(src.getUrlElement()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_14_30.convertString(src.getVersionElement()));
        }
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_14_30.convertString(src.getNameElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(VersionConvertor_14_30.convertConformanceResourceStatus(src.getStatusElement()));
        }
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_14_30.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_14_30.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(VersionConvertor_14_30.convertString(src.getPublisherElement()));
        }
        for (ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(TestScript14_30.convertTestScriptContactComponent(contactDetail));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_14_30.convertDateTime(src.getDateElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (UsageContext usageContext : src.getUseContext()) {
            if (!usageContext.hasValueCodeableConcept()) continue;
            tgt.addUseContext(VersionConvertor_14_30.convertCodeableConcept(usageContext.getValueCodeableConcept()));
        }
        for (CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addUseContext(VersionConvertor_14_30.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPurpose()) {
            tgt.setRequirements(src.getPurpose());
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        for (TestScript.TestScriptOriginComponent testScriptOriginComponent : src.getOrigin()) {
            tgt.addOrigin(TestScript14_30.convertTestScriptOriginComponent(testScriptOriginComponent));
        }
        for (TestScript.TestScriptDestinationComponent testScriptDestinationComponent : src.getDestination()) {
            tgt.addDestination(TestScript14_30.convertTestScriptDestinationComponent(testScriptDestinationComponent));
        }
        if (src.hasMetadata()) {
            tgt.setMetadata(TestScript14_30.convertTestScriptMetadataComponent(src.getMetadata()));
        }
        for (TestScript.TestScriptFixtureComponent testScriptFixtureComponent : src.getFixture()) {
            tgt.addFixture(TestScript14_30.convertTestScriptFixtureComponent(testScriptFixtureComponent));
        }
        for (org.hl7.fhir.dstu3.model.Reference reference : src.getProfile()) {
            tgt.addProfile(VersionConvertor_14_30.convertReference(reference));
        }
        for (TestScript.TestScriptVariableComponent testScriptVariableComponent : src.getVariable()) {
            tgt.addVariable(TestScript14_30.convertTestScriptVariableComponent(testScriptVariableComponent));
        }
        for (TestScript.TestScriptRuleComponent testScriptRuleComponent : src.getRule()) {
            tgt.addRule(TestScript14_30.convertTestScriptRuleComponent(testScriptRuleComponent));
        }
        for (TestScript.TestScriptRulesetComponent testScriptRulesetComponent : src.getRuleset()) {
            tgt.addRuleset(TestScript14_30.convertTestScriptRulesetComponent(testScriptRulesetComponent));
        }
        if (src.hasSetup()) {
            tgt.setSetup(TestScript14_30.convertTestScriptSetupComponent(src.getSetup()));
        }
        for (TestScript.TestScriptTestComponent testScriptTestComponent : src.getTest()) {
            tgt.addTest(TestScript14_30.convertTestScriptTestComponent(testScriptTestComponent));
        }
        if (src.hasTeardown()) {
            tgt.setTeardown(TestScript14_30.convertTestScriptTeardownComponent(src.getTeardown()));
        }
        return tgt;
    }

    public static TestScript.TestScriptContactComponent convertTestScriptContactComponent(ContactDetail src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptContactComponent tgt = new TestScript.TestScriptContactComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_14_30.convertString(src.getNameElement()));
        }
        for (org.hl7.fhir.dstu3.model.ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_14_30.convertContactPoint(t));
        }
        return tgt;
    }

    public static ContactDetail convertTestScriptContactComponent(TestScript.TestScriptContactComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ContactDetail tgt = new ContactDetail();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_14_30.convertString(src.getNameElement()));
        }
        for (ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_14_30.convertContactPoint(t));
        }
        return tgt;
    }

    public static TestScript.TestScriptDestinationComponent convertTestScriptDestinationComponent(TestScript.TestScriptDestinationComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptDestinationComponent tgt = new TestScript.TestScriptDestinationComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasIndexElement()) {
            tgt.setIndexElement(VersionConvertor_14_30.convertInteger(src.getIndexElement()));
        }
        if (src.hasProfile()) {
            tgt.setProfile(VersionConvertor_14_30.convertCoding(src.getProfile()));
        }
        return tgt;
    }

    public static TestScript.TestScriptDestinationComponent convertTestScriptDestinationComponent(TestScript.TestScriptDestinationComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptDestinationComponent tgt = new TestScript.TestScriptDestinationComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasIndexElement()) {
            tgt.setIndexElement(VersionConvertor_14_30.convertInteger(src.getIndexElement()));
        }
        if (src.hasProfile()) {
            tgt.setProfile(VersionConvertor_14_30.convertCoding(src.getProfile()));
        }
        return tgt;
    }

    public static TestScript.TestScriptFixtureComponent convertTestScriptFixtureComponent(TestScript.TestScriptFixtureComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptFixtureComponent tgt = new TestScript.TestScriptFixtureComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasAutocreate()) {
            tgt.setAutocreateElement(VersionConvertor_14_30.convertBoolean(src.getAutocreateElement()));
        }
        if (src.hasAutodelete()) {
            tgt.setAutodeleteElement(VersionConvertor_14_30.convertBoolean(src.getAutodeleteElement()));
        }
        if (src.hasResource()) {
            tgt.setResource(VersionConvertor_14_30.convertReference(src.getResource()));
        }
        return tgt;
    }

    public static TestScript.TestScriptFixtureComponent convertTestScriptFixtureComponent(TestScript.TestScriptFixtureComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptFixtureComponent tgt = new TestScript.TestScriptFixtureComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasAutocreate()) {
            tgt.setAutocreateElement(VersionConvertor_14_30.convertBoolean(src.getAutocreateElement()));
        }
        if (src.hasAutodelete()) {
            tgt.setAutodeleteElement(VersionConvertor_14_30.convertBoolean(src.getAutodeleteElement()));
        }
        if (src.hasResource()) {
            tgt.setResource(VersionConvertor_14_30.convertReference(src.getResource()));
        }
        return tgt;
    }

    public static TestScript.TestScriptMetadataCapabilityComponent convertTestScriptMetadataCapabilityComponent(TestScript.TestScriptMetadataCapabilityComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptMetadataCapabilityComponent tgt = new TestScript.TestScriptMetadataCapabilityComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasRequired()) {
            tgt.setRequiredElement(VersionConvertor_14_30.convertBoolean(src.getRequiredElement()));
        }
        if (src.hasValidated()) {
            tgt.setValidatedElement(VersionConvertor_14_30.convertBoolean(src.getValidatedElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_14_30.convertString(src.getDescriptionElement()));
        }
        for (IntegerType integerType : src.getOrigin()) {
            tgt.addOrigin((Integer)integerType.getValue());
        }
        if (src.hasDestination()) {
            tgt.setDestinationElement(VersionConvertor_14_30.convertInteger(src.getDestinationElement()));
        }
        for (org.hl7.fhir.dstu2016may.model.UriType uriType : src.getLink()) {
            tgt.addLink((String)uriType.getValue());
        }
        if (src.hasConformance()) {
            tgt.setCapabilities(VersionConvertor_14_30.convertReference(src.getConformance()));
        }
        return tgt;
    }

    public static TestScript.TestScriptMetadataCapabilityComponent convertTestScriptMetadataCapabilityComponent(TestScript.TestScriptMetadataCapabilityComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptMetadataCapabilityComponent tgt = new TestScript.TestScriptMetadataCapabilityComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasRequired()) {
            tgt.setRequiredElement(VersionConvertor_14_30.convertBoolean(src.getRequiredElement()));
        }
        if (src.hasValidated()) {
            tgt.setValidatedElement(VersionConvertor_14_30.convertBoolean(src.getValidatedElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_14_30.convertString(src.getDescriptionElement()));
        }
        for (org.hl7.fhir.dstu3.model.IntegerType integerType : src.getOrigin()) {
            tgt.addOrigin((Integer)integerType.getValue());
        }
        if (src.hasDestination()) {
            tgt.setDestinationElement(VersionConvertor_14_30.convertInteger(src.getDestinationElement()));
        }
        for (UriType uriType : src.getLink()) {
            tgt.addLink((String)uriType.getValue());
        }
        if (src.hasCapabilities()) {
            tgt.setConformance(VersionConvertor_14_30.convertReference(src.getCapabilities()));
        }
        return tgt;
    }

    public static TestScript.TestScriptMetadataComponent convertTestScriptMetadataComponent(TestScript.TestScriptMetadataComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptMetadataComponent tgt = new TestScript.TestScriptMetadataComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        for (TestScript.TestScriptMetadataLinkComponent testScriptMetadataLinkComponent : src.getLink()) {
            tgt.addLink(TestScript14_30.convertTestScriptMetadataLinkComponent(testScriptMetadataLinkComponent));
        }
        for (TestScript.TestScriptMetadataCapabilityComponent testScriptMetadataCapabilityComponent : src.getCapability()) {
            tgt.addCapability(TestScript14_30.convertTestScriptMetadataCapabilityComponent(testScriptMetadataCapabilityComponent));
        }
        return tgt;
    }

    public static TestScript.TestScriptMetadataComponent convertTestScriptMetadataComponent(TestScript.TestScriptMetadataComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptMetadataComponent tgt = new TestScript.TestScriptMetadataComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        for (TestScript.TestScriptMetadataLinkComponent testScriptMetadataLinkComponent : src.getLink()) {
            tgt.addLink(TestScript14_30.convertTestScriptMetadataLinkComponent(testScriptMetadataLinkComponent));
        }
        for (TestScript.TestScriptMetadataCapabilityComponent testScriptMetadataCapabilityComponent : src.getCapability()) {
            tgt.addCapability(TestScript14_30.convertTestScriptMetadataCapabilityComponent(testScriptMetadataCapabilityComponent));
        }
        return tgt;
    }

    public static TestScript.TestScriptMetadataLinkComponent convertTestScriptMetadataLinkComponent(TestScript.TestScriptMetadataLinkComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptMetadataLinkComponent tgt = new TestScript.TestScriptMetadataLinkComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasUrlElement()) {
            tgt.setUrlElement(VersionConvertor_14_30.convertUri(src.getUrlElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_14_30.convertString(src.getDescriptionElement()));
        }
        return tgt;
    }

    public static TestScript.TestScriptMetadataLinkComponent convertTestScriptMetadataLinkComponent(TestScript.TestScriptMetadataLinkComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptMetadataLinkComponent tgt = new TestScript.TestScriptMetadataLinkComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasUrlElement()) {
            tgt.setUrlElement(VersionConvertor_14_30.convertUri(src.getUrlElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_14_30.convertString(src.getDescriptionElement()));
        }
        return tgt;
    }

    public static TestScript.TestScriptOriginComponent convertTestScriptOriginComponent(TestScript.TestScriptOriginComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptOriginComponent tgt = new TestScript.TestScriptOriginComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasIndexElement()) {
            tgt.setIndexElement(VersionConvertor_14_30.convertInteger(src.getIndexElement()));
        }
        if (src.hasProfile()) {
            tgt.setProfile(VersionConvertor_14_30.convertCoding(src.getProfile()));
        }
        return tgt;
    }

    public static TestScript.TestScriptOriginComponent convertTestScriptOriginComponent(TestScript.TestScriptOriginComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptOriginComponent tgt = new TestScript.TestScriptOriginComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasIndexElement()) {
            tgt.setIndexElement(VersionConvertor_14_30.convertInteger(src.getIndexElement()));
        }
        if (src.hasProfile()) {
            tgt.setProfile(VersionConvertor_14_30.convertCoding(src.getProfile()));
        }
        return tgt;
    }

    public static TestScript.TestScriptRuleComponent convertTestScriptRuleComponent(TestScript.TestScriptRuleComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptRuleComponent tgt = new TestScript.TestScriptRuleComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasResource()) {
            tgt.setResource(VersionConvertor_14_30.convertReference(src.getResource()));
        }
        for (TestScript.TestScriptRuleParamComponent t : src.getParam()) {
            tgt.addParam(TestScript14_30.convertTestScriptRuleParamComponent(t));
        }
        return tgt;
    }

    public static TestScript.TestScriptRuleComponent convertTestScriptRuleComponent(TestScript.TestScriptRuleComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptRuleComponent tgt = new TestScript.TestScriptRuleComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasResource()) {
            tgt.setResource(VersionConvertor_14_30.convertReference(src.getResource()));
        }
        for (TestScript.RuleParamComponent t : src.getParam()) {
            tgt.addParam(TestScript14_30.convertTestScriptRuleParamComponent(t));
        }
        return tgt;
    }

    public static TestScript.RuleParamComponent convertTestScriptRuleParamComponent(TestScript.TestScriptRuleParamComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.RuleParamComponent tgt = new TestScript.RuleParamComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_14_30.convertString(src.getNameElement()));
        }
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_14_30.convertString(src.getValueElement()));
        }
        return tgt;
    }

    public static TestScript.TestScriptRuleParamComponent convertTestScriptRuleParamComponent(TestScript.RuleParamComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptRuleParamComponent tgt = new TestScript.TestScriptRuleParamComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_14_30.convertString(src.getNameElement()));
        }
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_14_30.convertString(src.getValueElement()));
        }
        return tgt;
    }

    public static TestScript.TestScriptRulesetComponent convertTestScriptRulesetComponent(TestScript.TestScriptRulesetComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptRulesetComponent tgt = new TestScript.TestScriptRulesetComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasResource()) {
            tgt.setResource(VersionConvertor_14_30.convertReference(src.getResource()));
        }
        for (TestScript.TestScriptRulesetRuleComponent t : src.getRule()) {
            tgt.addRule(TestScript14_30.convertTestScriptRulesetRuleComponent(t));
        }
        return tgt;
    }

    public static TestScript.TestScriptRulesetComponent convertTestScriptRulesetComponent(TestScript.TestScriptRulesetComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptRulesetComponent tgt = new TestScript.TestScriptRulesetComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasResource()) {
            tgt.setResource(VersionConvertor_14_30.convertReference(src.getResource()));
        }
        for (TestScript.RulesetRuleComponent t : src.getRule()) {
            tgt.addRule(TestScript14_30.convertTestScriptRulesetRuleComponent(t));
        }
        return tgt;
    }

    public static TestScript.TestScriptRulesetRuleComponent convertTestScriptRulesetRuleComponent(TestScript.RulesetRuleComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptRulesetRuleComponent tgt = new TestScript.TestScriptRulesetRuleComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        for (TestScript.RulesetRuleParamComponent t : src.getParam()) {
            tgt.addParam(TestScript14_30.convertTestScriptRulesetRuleParamComponent(t));
        }
        return tgt;
    }

    public static TestScript.RulesetRuleComponent convertTestScriptRulesetRuleComponent(TestScript.TestScriptRulesetRuleComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.RulesetRuleComponent tgt = new TestScript.RulesetRuleComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        for (TestScript.TestScriptRulesetRuleParamComponent t : src.getParam()) {
            tgt.addParam(TestScript14_30.convertTestScriptRulesetRuleParamComponent(t));
        }
        return tgt;
    }

    public static TestScript.TestScriptRulesetRuleParamComponent convertTestScriptRulesetRuleParamComponent(TestScript.RulesetRuleParamComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptRulesetRuleParamComponent tgt = new TestScript.TestScriptRulesetRuleParamComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_14_30.convertString(src.getNameElement()));
        }
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_14_30.convertString(src.getValueElement()));
        }
        return tgt;
    }

    public static TestScript.RulesetRuleParamComponent convertTestScriptRulesetRuleParamComponent(TestScript.TestScriptRulesetRuleParamComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.RulesetRuleParamComponent tgt = new TestScript.RulesetRuleParamComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_14_30.convertString(src.getNameElement()));
        }
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_14_30.convertString(src.getValueElement()));
        }
        return tgt;
    }

    public static TestScript.TestScriptSetupComponent convertTestScriptSetupComponent(TestScript.TestScriptSetupComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptSetupComponent tgt = new TestScript.TestScriptSetupComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        for (TestScript.SetupActionComponent t : src.getAction()) {
            tgt.addAction(TestScript14_30.convertSetupActionComponent(t));
        }
        return tgt;
    }

    public static TestScript.TestScriptSetupComponent convertTestScriptSetupComponent(TestScript.TestScriptSetupComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptSetupComponent tgt = new TestScript.TestScriptSetupComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        for (TestScript.SetupActionComponent t : src.getAction()) {
            tgt.addAction(TestScript14_30.convertSetupActionComponent(t));
        }
        return tgt;
    }

    public static TestScript.TestScriptTeardownComponent convertTestScriptTeardownComponent(TestScript.TestScriptTeardownComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptTeardownComponent tgt = new TestScript.TestScriptTeardownComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        for (TestScript.TeardownActionComponent t : src.getAction()) {
            tgt.addAction(TestScript14_30.convertTeardownActionComponent(t));
        }
        return tgt;
    }

    public static TestScript.TestScriptTeardownComponent convertTestScriptTeardownComponent(TestScript.TestScriptTeardownComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptTeardownComponent tgt = new TestScript.TestScriptTeardownComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        for (TestScript.TeardownActionComponent t : src.getAction()) {
            tgt.addAction(TestScript14_30.convertTeardownActionComponent(t));
        }
        return tgt;
    }

    public static TestScript.TestScriptTestComponent convertTestScriptTestComponent(TestScript.TestScriptTestComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptTestComponent tgt = new TestScript.TestScriptTestComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_14_30.convertString(src.getNameElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_14_30.convertString(src.getDescriptionElement()));
        }
        for (TestScript.TestActionComponent t : src.getAction()) {
            tgt.addAction(TestScript14_30.convertTestActionComponent(t));
        }
        return tgt;
    }

    public static TestScript.TestScriptTestComponent convertTestScriptTestComponent(TestScript.TestScriptTestComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptTestComponent tgt = new TestScript.TestScriptTestComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_14_30.convertString(src.getNameElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_14_30.convertString(src.getDescriptionElement()));
        }
        for (TestScript.TestActionComponent t : src.getAction()) {
            tgt.addAction(TestScript14_30.convertTestActionComponent(t));
        }
        return tgt;
    }

    public static TestScript.TestScriptVariableComponent convertTestScriptVariableComponent(TestScript.TestScriptVariableComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptVariableComponent tgt = new TestScript.TestScriptVariableComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_14_30.convertString(src.getNameElement()));
        }
        if (src.hasDefaultValue()) {
            tgt.setDefaultValueElement(VersionConvertor_14_30.convertString(src.getDefaultValueElement()));
        }
        if (src.hasHeaderField()) {
            tgt.setHeaderFieldElement(VersionConvertor_14_30.convertString(src.getHeaderFieldElement()));
        }
        if (src.hasPath()) {
            tgt.setPathElement(VersionConvertor_14_30.convertString(src.getPathElement()));
        }
        if (src.hasSourceId()) {
            tgt.setSourceIdElement(VersionConvertor_14_30.convertId(src.getSourceIdElement()));
        }
        return tgt;
    }

    public static TestScript.TestScriptVariableComponent convertTestScriptVariableComponent(TestScript.TestScriptVariableComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptVariableComponent tgt = new TestScript.TestScriptVariableComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_14_30.convertString(src.getNameElement()));
        }
        if (src.hasDefaultValue()) {
            tgt.setDefaultValueElement(VersionConvertor_14_30.convertString(src.getDefaultValueElement()));
        }
        if (src.hasHeaderField()) {
            tgt.setHeaderFieldElement(VersionConvertor_14_30.convertString(src.getHeaderFieldElement()));
        }
        if (src.hasPath()) {
            tgt.setPathElement(VersionConvertor_14_30.convertString(src.getPathElement()));
        }
        if (src.hasSourceId()) {
            tgt.setSourceIdElement(VersionConvertor_14_30.convertId(src.getSourceIdElement()));
        }
        return tgt;
    }
}

