/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_50;

import org.hl7.fhir.convertors.VersionConvertor_10_50;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.TestScript;
import org.hl7.fhir.dstu2.model.UriType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.ContactPoint;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.TestScript;
import org.hl7.fhir.r5.model.UsageContext;

public class TestScript10_50 {
    public static org.hl7.fhir.dstu2.model.Enumeration<TestScript.AssertionDirectionType> convertAssertionDirectionType(Enumeration<TestScript.AssertionDirectionType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.Enumeration<TestScript.AssertionDirectionType> tgt = new org.hl7.fhir.dstu2.model.Enumeration<TestScript.AssertionDirectionType>(new TestScript.AssertionDirectionTypeEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((TestScript.AssertionDirectionType)((Object)src.getValue())) {
            case RESPONSE: {
                tgt.setValue((Object)TestScript.AssertionDirectionType.RESPONSE);
                break;
            }
            case REQUEST: {
                tgt.setValue((Object)TestScript.AssertionDirectionType.REQUEST);
                break;
            }
            default: {
                tgt.setValue((Object)TestScript.AssertionDirectionType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<TestScript.AssertionDirectionType> convertAssertionDirectionType(org.hl7.fhir.dstu2.model.Enumeration<TestScript.AssertionDirectionType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<TestScript.AssertionDirectionType> tgt = new Enumeration<TestScript.AssertionDirectionType>(new TestScript.AssertionDirectionTypeEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((TestScript.AssertionDirectionType)((Object)src.getValue())) {
            case RESPONSE: {
                tgt.setValue((Object)TestScript.AssertionDirectionType.RESPONSE);
                break;
            }
            case REQUEST: {
                tgt.setValue((Object)TestScript.AssertionDirectionType.REQUEST);
                break;
            }
            default: {
                tgt.setValue((Object)TestScript.AssertionDirectionType.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.Enumeration<TestScript.AssertionOperatorType> convertAssertionOperatorType(Enumeration<TestScript.AssertionOperatorType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.Enumeration<TestScript.AssertionOperatorType> tgt = new org.hl7.fhir.dstu2.model.Enumeration<TestScript.AssertionOperatorType>(new TestScript.AssertionOperatorTypeEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((TestScript.AssertionOperatorType)((Object)src.getValue())) {
            case EQUALS: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.EQUALS);
                break;
            }
            case NOTEQUALS: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.NOTEQUALS);
                break;
            }
            case IN: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.IN);
                break;
            }
            case NOTIN: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.NOTIN);
                break;
            }
            case GREATERTHAN: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.GREATERTHAN);
                break;
            }
            case LESSTHAN: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.LESSTHAN);
                break;
            }
            case EMPTY: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.EMPTY);
                break;
            }
            case NOTEMPTY: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.NOTEMPTY);
                break;
            }
            case CONTAINS: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.CONTAINS);
                break;
            }
            case NOTCONTAINS: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.NOTCONTAINS);
                break;
            }
            default: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<TestScript.AssertionOperatorType> convertAssertionOperatorType(org.hl7.fhir.dstu2.model.Enumeration<TestScript.AssertionOperatorType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<TestScript.AssertionOperatorType> tgt = new Enumeration<TestScript.AssertionOperatorType>(new TestScript.AssertionOperatorTypeEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((TestScript.AssertionOperatorType)((Object)src.getValue())) {
            case EQUALS: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.EQUALS);
                break;
            }
            case NOTEQUALS: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.NOTEQUALS);
                break;
            }
            case IN: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.IN);
                break;
            }
            case NOTIN: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.NOTIN);
                break;
            }
            case GREATERTHAN: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.GREATERTHAN);
                break;
            }
            case LESSTHAN: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.LESSTHAN);
                break;
            }
            case EMPTY: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.EMPTY);
                break;
            }
            case NOTEMPTY: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.NOTEMPTY);
                break;
            }
            case CONTAINS: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.CONTAINS);
                break;
            }
            case NOTCONTAINS: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.NOTCONTAINS);
                break;
            }
            default: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<TestScript.AssertionResponseTypes> convertAssertionResponseTypes(org.hl7.fhir.dstu2.model.Enumeration<TestScript.AssertionResponseTypes> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<TestScript.AssertionResponseTypes> tgt = new Enumeration<TestScript.AssertionResponseTypes>(new TestScript.AssertionResponseTypesEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((TestScript.AssertionResponseTypes)((Object)src.getValue())) {
            case OKAY: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.OKAY);
                break;
            }
            case CREATED: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.CREATED);
                break;
            }
            case NOCONTENT: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.NOCONTENT);
                break;
            }
            case NOTMODIFIED: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.NOTMODIFIED);
                break;
            }
            case BAD: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.BAD);
                break;
            }
            case FORBIDDEN: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.FORBIDDEN);
                break;
            }
            case NOTFOUND: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.NOTFOUND);
                break;
            }
            case METHODNOTALLOWED: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.METHODNOTALLOWED);
                break;
            }
            case CONFLICT: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.CONFLICT);
                break;
            }
            case GONE: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.GONE);
                break;
            }
            case PRECONDITIONFAILED: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.PRECONDITIONFAILED);
                break;
            }
            case UNPROCESSABLE: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.UNPROCESSABLE);
                break;
            }
            default: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.Enumeration<TestScript.AssertionResponseTypes> convertAssertionResponseTypes(Enumeration<TestScript.AssertionResponseTypes> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.Enumeration<TestScript.AssertionResponseTypes> tgt = new org.hl7.fhir.dstu2.model.Enumeration<TestScript.AssertionResponseTypes>(new TestScript.AssertionResponseTypesEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((TestScript.AssertionResponseTypes)((Object)src.getValue())) {
            case OKAY: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.OKAY);
                break;
            }
            case CREATED: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.CREATED);
                break;
            }
            case NOCONTENT: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.NOCONTENT);
                break;
            }
            case NOTMODIFIED: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.NOTMODIFIED);
                break;
            }
            case BAD: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.BAD);
                break;
            }
            case FORBIDDEN: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.FORBIDDEN);
                break;
            }
            case NOTFOUND: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.NOTFOUND);
                break;
            }
            case METHODNOTALLOWED: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.METHODNOTALLOWED);
                break;
            }
            case CONFLICT: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.CONFLICT);
                break;
            }
            case GONE: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.GONE);
                break;
            }
            case PRECONDITIONFAILED: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.PRECONDITIONFAILED);
                break;
            }
            case UNPROCESSABLE: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.UNPROCESSABLE);
                break;
            }
            default: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.NULL);
            }
        }
        return tgt;
    }

    public static String convertContentType(TestScript.ContentType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case XML: {
                return "application/fhir+xml";
            }
            case JSON: {
                return "application/fhir+json";
            }
        }
        return null;
    }

    public static TestScript.ContentType convertContentType(String src) throws FHIRException {
        if (src == null) {
            return null;
        }
        if (src.contains("xml")) {
            return TestScript.ContentType.XML;
        }
        if (src.contains("json")) {
            return TestScript.ContentType.JSON;
        }
        return TestScript.ContentType.NULL;
    }

    public static TestScript.SetupActionAssertComponent convertSetupActionAssertComponent(TestScript.TestScriptSetupActionAssertComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.SetupActionAssertComponent tgt = new TestScript.SetupActionAssertComponent();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        if (src.hasLabelElement()) {
            tgt.setLabelElement(VersionConvertor_10_50.convertString(src.getLabelElement()));
        }
        if (src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_10_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasDirection()) {
            tgt.setDirectionElement(TestScript10_50.convertAssertionDirectionType(src.getDirectionElement()));
        }
        if (src.hasCompareToSourceIdElement()) {
            tgt.setCompareToSourceIdElement(VersionConvertor_10_50.convertString(src.getCompareToSourceIdElement()));
        }
        if (src.hasCompareToSourcePathElement()) {
            tgt.setCompareToSourcePathElement(VersionConvertor_10_50.convertString(src.getCompareToSourcePathElement()));
        }
        if (src.hasContentType()) {
            tgt.setContentType(TestScript10_50.convertContentType(src.getContentType()));
        }
        if (src.hasHeaderFieldElement()) {
            tgt.setHeaderFieldElement(VersionConvertor_10_50.convertString(src.getHeaderFieldElement()));
        }
        if (src.hasMinimumIdElement()) {
            tgt.setMinimumIdElement(VersionConvertor_10_50.convertString(src.getMinimumIdElement()));
        }
        if (src.hasNavigationLinksElement()) {
            tgt.setNavigationLinksElement(VersionConvertor_10_50.convertBoolean(src.getNavigationLinksElement()));
        }
        if (src.hasOperator()) {
            tgt.setOperatorElement(TestScript10_50.convertAssertionOperatorType(src.getOperatorElement()));
        }
        if (src.hasPathElement()) {
            tgt.setPathElement(VersionConvertor_10_50.convertString(src.getPathElement()));
        }
        if (src.hasResource()) {
            tgt.setResource(TestScript.FHIRDefinedType.fromCode(src.getResource()));
        }
        if (src.hasResponse()) {
            tgt.setResponseElement(TestScript10_50.convertAssertionResponseTypes(src.getResponseElement()));
        }
        if (src.hasResponseCodeElement()) {
            tgt.setResponseCodeElement(VersionConvertor_10_50.convertString(src.getResponseCodeElement()));
        }
        if (src.hasSourceIdElement()) {
            tgt.setSourceIdElement(VersionConvertor_10_50.convertId(src.getSourceIdElement()));
        }
        if (src.hasValidateProfileIdElement()) {
            tgt.setValidateProfileIdElement(VersionConvertor_10_50.convertId(src.getValidateProfileIdElement()));
        }
        if (src.hasValueElement()) {
            tgt.setValueElement(VersionConvertor_10_50.convertString(src.getValueElement()));
        }
        if (src.hasWarningOnlyElement()) {
            tgt.setWarningOnlyElement(VersionConvertor_10_50.convertBoolean(src.getWarningOnlyElement()));
        }
        return tgt;
    }

    public static TestScript.TestScriptSetupActionAssertComponent convertSetupActionAssertComponent(TestScript.SetupActionAssertComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptSetupActionAssertComponent tgt = new TestScript.TestScriptSetupActionAssertComponent();
        VersionConvertor_10_50.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasLabelElement()) {
            tgt.setLabelElement(VersionConvertor_10_50.convertString(src.getLabelElement()));
        }
        if (src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_10_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasDirection()) {
            tgt.setDirectionElement(TestScript10_50.convertAssertionDirectionType(src.getDirectionElement()));
        }
        if (src.hasCompareToSourceIdElement()) {
            tgt.setCompareToSourceIdElement(VersionConvertor_10_50.convertString(src.getCompareToSourceIdElement()));
        }
        if (src.hasCompareToSourcePathElement()) {
            tgt.setCompareToSourcePathElement(VersionConvertor_10_50.convertString(src.getCompareToSourcePathElement()));
        }
        if (src.hasContentType()) {
            tgt.setContentType(TestScript10_50.convertContentType(src.getContentType()));
        }
        if (src.hasHeaderFieldElement()) {
            tgt.setHeaderFieldElement(VersionConvertor_10_50.convertString(src.getHeaderFieldElement()));
        }
        if (src.hasMinimumIdElement()) {
            tgt.setMinimumIdElement(VersionConvertor_10_50.convertString(src.getMinimumIdElement()));
        }
        if (src.hasNavigationLinksElement()) {
            tgt.setNavigationLinksElement(VersionConvertor_10_50.convertBoolean(src.getNavigationLinksElement()));
        }
        if (src.hasOperator()) {
            tgt.setOperatorElement(TestScript10_50.convertAssertionOperatorType(src.getOperatorElement()));
        }
        if (src.hasPathElement()) {
            tgt.setPathElement(VersionConvertor_10_50.convertString(src.getPathElement()));
        }
        tgt.setResource(src.getResource().toCode());
        if (src.hasResponse()) {
            tgt.setResponseElement(TestScript10_50.convertAssertionResponseTypes(src.getResponseElement()));
        }
        if (src.hasResponseCodeElement()) {
            tgt.setResponseCodeElement(VersionConvertor_10_50.convertString(src.getResponseCodeElement()));
        }
        if (src.hasSourceIdElement()) {
            tgt.setSourceIdElement(VersionConvertor_10_50.convertId(src.getSourceIdElement()));
        }
        if (src.hasValidateProfileIdElement()) {
            tgt.setValidateProfileIdElement(VersionConvertor_10_50.convertId(src.getValidateProfileIdElement()));
        }
        if (src.hasValueElement()) {
            tgt.setValueElement(VersionConvertor_10_50.convertString(src.getValueElement()));
        }
        if (src.hasWarningOnlyElement()) {
            tgt.setWarningOnlyElement(VersionConvertor_10_50.convertBoolean(src.getWarningOnlyElement()));
        }
        return tgt;
    }

    public static TestScript.SetupActionComponent convertSetupActionComponent(TestScript.TestScriptSetupActionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.SetupActionComponent tgt = new TestScript.SetupActionComponent();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        if (src.hasOperation()) {
            tgt.setOperation(TestScript10_50.convertSetupActionOperationComponent(src.getOperation()));
        }
        if (src.hasAssert()) {
            tgt.setAssert(TestScript10_50.convertSetupActionAssertComponent(src.getAssert()));
        }
        return tgt;
    }

    public static TestScript.TestScriptSetupActionComponent convertSetupActionComponent(TestScript.SetupActionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptSetupActionComponent tgt = new TestScript.TestScriptSetupActionComponent();
        VersionConvertor_10_50.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasOperation()) {
            tgt.setOperation(TestScript10_50.convertSetupActionOperationComponent(src.getOperation()));
        }
        if (src.hasAssert()) {
            tgt.setAssert(TestScript10_50.convertSetupActionAssertComponent(src.getAssert()));
        }
        return tgt;
    }

    public static TestScript.TestScriptSetupActionOperationComponent convertSetupActionOperationComponent(TestScript.SetupActionOperationComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptSetupActionOperationComponent tgt = new TestScript.TestScriptSetupActionOperationComponent();
        VersionConvertor_10_50.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasType()) {
            tgt.setType(VersionConvertor_10_50.convertCoding(src.getType()));
        }
        tgt.setResource(src.getResource().toCode());
        if (src.hasLabelElement()) {
            tgt.setLabelElement(VersionConvertor_10_50.convertString(src.getLabelElement()));
        }
        if (src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_10_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasAccept()) {
            tgt.setAccept(TestScript10_50.convertContentType(src.getAccept()));
        }
        if (src.hasContentType()) {
            tgt.setContentType(TestScript10_50.convertContentType(src.getContentType()));
        }
        if (src.hasDestinationElement()) {
            tgt.setDestinationElement(VersionConvertor_10_50.convertInteger(src.getDestinationElement()));
        }
        if (src.hasEncodeRequestUrlElement()) {
            tgt.setEncodeRequestUrlElement(VersionConvertor_10_50.convertBoolean(src.getEncodeRequestUrlElement()));
        }
        if (src.hasParamsElement()) {
            tgt.setParamsElement(VersionConvertor_10_50.convertString(src.getParamsElement()));
        }
        for (TestScript.SetupActionOperationRequestHeaderComponent t : src.getRequestHeader()) {
            tgt.addRequestHeader(TestScript10_50.convertSetupActionOperationRequestHeaderComponent(t));
        }
        if (src.hasResponseIdElement()) {
            tgt.setResponseIdElement(VersionConvertor_10_50.convertId(src.getResponseIdElement()));
        }
        if (src.hasSourceIdElement()) {
            tgt.setSourceIdElement(VersionConvertor_10_50.convertId(src.getSourceIdElement()));
        }
        if (src.hasTargetId()) {
            tgt.setTargetId(src.getTargetId());
        }
        if (src.hasUrlElement()) {
            tgt.setUrlElement(VersionConvertor_10_50.convertString(src.getUrlElement()));
        }
        return tgt;
    }

    public static TestScript.SetupActionOperationComponent convertSetupActionOperationComponent(TestScript.TestScriptSetupActionOperationComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.SetupActionOperationComponent tgt = new TestScript.SetupActionOperationComponent();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setType(VersionConvertor_10_50.convertCoding(src.getType()));
        }
        if (src.hasResource()) {
            tgt.setResource(TestScript.FHIRDefinedType.fromCode(src.getResource()));
        }
        if (src.hasLabelElement()) {
            tgt.setLabelElement(VersionConvertor_10_50.convertString(src.getLabelElement()));
        }
        if (src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_10_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasAccept()) {
            tgt.setAccept(TestScript10_50.convertContentType(src.getAccept()));
        }
        if (src.hasContentType()) {
            tgt.setContentType(TestScript10_50.convertContentType(src.getContentType()));
        }
        if (src.hasDestinationElement()) {
            tgt.setDestinationElement(VersionConvertor_10_50.convertInteger(src.getDestinationElement()));
        }
        if (src.hasEncodeRequestUrlElement()) {
            tgt.setEncodeRequestUrlElement(VersionConvertor_10_50.convertBoolean(src.getEncodeRequestUrlElement()));
        }
        if (src.hasParamsElement()) {
            tgt.setParamsElement(VersionConvertor_10_50.convertString(src.getParamsElement()));
        }
        for (TestScript.TestScriptSetupActionOperationRequestHeaderComponent t : src.getRequestHeader()) {
            tgt.addRequestHeader(TestScript10_50.convertSetupActionOperationRequestHeaderComponent(t));
        }
        if (src.hasResponseIdElement()) {
            tgt.setResponseIdElement(VersionConvertor_10_50.convertId(src.getResponseIdElement()));
        }
        if (src.hasSourceIdElement()) {
            tgt.setSourceIdElement(VersionConvertor_10_50.convertId(src.getSourceIdElement()));
        }
        if (src.hasTargetId()) {
            tgt.setTargetId(src.getTargetId());
        }
        if (src.hasUrlElement()) {
            tgt.setUrlElement(VersionConvertor_10_50.convertString(src.getUrlElement()));
        }
        return tgt;
    }

    public static TestScript.SetupActionOperationRequestHeaderComponent convertSetupActionOperationRequestHeaderComponent(TestScript.TestScriptSetupActionOperationRequestHeaderComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.SetupActionOperationRequestHeaderComponent tgt = new TestScript.SetupActionOperationRequestHeaderComponent();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        if (src.hasFieldElement()) {
            tgt.setFieldElement(VersionConvertor_10_50.convertString(src.getFieldElement()));
        }
        if (src.hasValueElement()) {
            tgt.setValueElement(VersionConvertor_10_50.convertString(src.getValueElement()));
        }
        return tgt;
    }

    public static TestScript.TestScriptSetupActionOperationRequestHeaderComponent convertSetupActionOperationRequestHeaderComponent(TestScript.SetupActionOperationRequestHeaderComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptSetupActionOperationRequestHeaderComponent tgt = new TestScript.TestScriptSetupActionOperationRequestHeaderComponent();
        VersionConvertor_10_50.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasFieldElement()) {
            tgt.setFieldElement(VersionConvertor_10_50.convertString(src.getFieldElement()));
        }
        if (src.hasValueElement()) {
            tgt.setValueElement(VersionConvertor_10_50.convertString(src.getValueElement()));
        }
        return tgt;
    }

    public static TestScript.TeardownActionComponent convertTeardownActionComponent(TestScript.TestScriptTeardownActionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TeardownActionComponent tgt = new TestScript.TeardownActionComponent();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        if (src.hasOperation()) {
            tgt.setOperation(TestScript10_50.convertSetupActionOperationComponent(src.getOperation()));
        }
        return tgt;
    }

    public static TestScript.TestScriptTeardownActionComponent convertTeardownActionComponent(TestScript.TeardownActionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptTeardownActionComponent tgt = new TestScript.TestScriptTeardownActionComponent();
        VersionConvertor_10_50.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasOperation()) {
            tgt.setOperation(TestScript10_50.convertSetupActionOperationComponent(src.getOperation()));
        }
        return tgt;
    }

    public static TestScript.TestActionComponent convertTestActionComponent(TestScript.TestScriptTestActionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestActionComponent tgt = new TestScript.TestActionComponent();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        if (src.hasOperation()) {
            tgt.setOperation(TestScript10_50.convertSetupActionOperationComponent(src.getOperation()));
        }
        if (src.hasAssert()) {
            tgt.setAssert(TestScript10_50.convertSetupActionAssertComponent(src.getAssert()));
        }
        return tgt;
    }

    public static TestScript.TestScriptTestActionComponent convertTestActionComponent(TestScript.TestActionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptTestActionComponent tgt = new TestScript.TestScriptTestActionComponent();
        VersionConvertor_10_50.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasOperation()) {
            tgt.setOperation(TestScript10_50.convertSetupActionOperationComponent(src.getOperation()));
        }
        if (src.hasAssert()) {
            tgt.setAssert(TestScript10_50.convertSetupActionAssertComponent(src.getAssert()));
        }
        return tgt;
    }

    public static TestScript convertTestScript(org.hl7.fhir.dstu2.model.TestScript src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript tgt = new TestScript();
        VersionConvertor_10_50.copyDomainResource(src, tgt, new String[0]);
        if (src.hasUrlElement()) {
            tgt.setUrlElement(VersionConvertor_10_50.convertUri(src.getUrlElement()));
        }
        if (src.hasVersionElement()) {
            tgt.setVersionElement(VersionConvertor_10_50.convertString(src.getVersionElement()));
        }
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_50.convertString(src.getNameElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((Enumeration)VersionConvertor_10_50.convertConformanceResourceStatus(src.getStatusElement()));
        }
        if (src.hasIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_50.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_10_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasPublisherElement()) {
            tgt.setPublisherElement(VersionConvertor_10_50.convertString(src.getPublisherElement()));
        }
        for (TestScript.TestScriptContactComponent testScriptContactComponent : src.getContact()) {
            tgt.addContact(TestScript10_50.convertTestScriptContactComponent(testScriptContactComponent));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_10_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (org.hl7.fhir.dstu2.model.CodeableConcept codeableConcept : src.getUseContext()) {
            if (VersionConvertor_10_50.isJurisdiction(codeableConcept)) {
                tgt.addJurisdiction(VersionConvertor_10_50.convertCodeableConcept(codeableConcept));
                continue;
            }
            tgt.addUseContext(VersionConvertor_10_50.convertCodeableConceptToUsageContext(codeableConcept));
        }
        if (src.hasRequirements()) {
            tgt.setPurpose(src.getRequirements());
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        if (src.hasMetadata()) {
            tgt.setMetadata(TestScript10_50.convertTestScriptMetadataComponent(src.getMetadata()));
        }
        for (TestScript.TestScriptFixtureComponent testScriptFixtureComponent : src.getFixture()) {
            tgt.addFixture(TestScript10_50.convertTestScriptFixtureComponent(testScriptFixtureComponent));
        }
        for (org.hl7.fhir.dstu2.model.Reference reference : src.getProfile()) {
            tgt.addProfile(VersionConvertor_10_50.convertReference(reference));
        }
        for (TestScript.TestScriptVariableComponent testScriptVariableComponent : src.getVariable()) {
            tgt.addVariable(TestScript10_50.convertTestScriptVariableComponent(testScriptVariableComponent));
        }
        if (src.hasSetup()) {
            tgt.setSetup(TestScript10_50.convertTestScriptSetupComponent(src.getSetup()));
        }
        for (TestScript.TestScriptTestComponent testScriptTestComponent : src.getTest()) {
            tgt.addTest(TestScript10_50.convertTestScriptTestComponent(testScriptTestComponent));
        }
        if (src.hasTeardown()) {
            tgt.setTeardown(TestScript10_50.convertTestScriptTeardownComponent(src.getTeardown()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.TestScript convertTestScript(TestScript src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.TestScript tgt = new org.hl7.fhir.dstu2.model.TestScript();
        VersionConvertor_10_50.copyDomainResource(src, tgt, new String[0]);
        if (src.hasUrlElement()) {
            tgt.setUrlElement(VersionConvertor_10_50.convertUri(src.getUrlElement()));
        }
        if (src.hasVersionElement()) {
            tgt.setVersionElement(VersionConvertor_10_50.convertString(src.getVersionElement()));
        }
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_50.convertString(src.getNameElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(VersionConvertor_10_50.convertConformanceResourceStatus(src.getStatusElement()));
        }
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_10_50.convertIdentifier(src.getIdentifierFirstRep()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_10_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasPublisherElement()) {
            tgt.setPublisherElement(VersionConvertor_10_50.convertString(src.getPublisherElement()));
        }
        for (ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(TestScript10_50.convertTestScriptContactComponent(contactDetail));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_10_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (UsageContext usageContext : src.getUseContext()) {
            if (!usageContext.hasValueCodeableConcept()) continue;
            tgt.addUseContext(VersionConvertor_10_50.convertCodeableConcept(usageContext.getValueCodeableConcept()));
        }
        for (CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addUseContext(VersionConvertor_10_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPurpose()) {
            tgt.setRequirements(src.getPurpose());
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        if (src.hasMetadata()) {
            tgt.setMetadata(TestScript10_50.convertTestScriptMetadataComponent(src.getMetadata()));
        }
        for (TestScript.TestScriptFixtureComponent testScriptFixtureComponent : src.getFixture()) {
            tgt.addFixture(TestScript10_50.convertTestScriptFixtureComponent(testScriptFixtureComponent));
        }
        for (Reference reference : src.getProfile()) {
            tgt.addProfile(VersionConvertor_10_50.convertReference(reference));
        }
        for (TestScript.TestScriptVariableComponent testScriptVariableComponent : src.getVariable()) {
            tgt.addVariable(TestScript10_50.convertTestScriptVariableComponent(testScriptVariableComponent));
        }
        if (src.hasSetup()) {
            tgt.setSetup(TestScript10_50.convertTestScriptSetupComponent(src.getSetup()));
        }
        for (TestScript.TestScriptTestComponent testScriptTestComponent : src.getTest()) {
            tgt.addTest(TestScript10_50.convertTestScriptTestComponent(testScriptTestComponent));
        }
        if (src.hasTeardown()) {
            tgt.setTeardown(TestScript10_50.convertTestScriptTeardownComponent(src.getTeardown()));
        }
        return tgt;
    }

    public static ContactDetail convertTestScriptContactComponent(TestScript.TestScriptContactComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ContactDetail tgt = new ContactDetail();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_50.convertString(src.getNameElement()));
        }
        for (org.hl7.fhir.dstu2.model.ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_10_50.convertContactPoint(t));
        }
        return tgt;
    }

    public static TestScript.TestScriptContactComponent convertTestScriptContactComponent(ContactDetail src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptContactComponent tgt = new TestScript.TestScriptContactComponent();
        VersionConvertor_10_50.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_50.convertString(src.getNameElement()));
        }
        for (ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_10_50.convertContactPoint(t));
        }
        return tgt;
    }

    public static TestScript.TestScriptFixtureComponent convertTestScriptFixtureComponent(TestScript.TestScriptFixtureComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptFixtureComponent tgt = new TestScript.TestScriptFixtureComponent();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        if (src.hasAutocreateElement()) {
            tgt.setAutocreateElement(VersionConvertor_10_50.convertBoolean(src.getAutocreateElement()));
        }
        if (src.hasAutodeleteElement()) {
            tgt.setAutodeleteElement(VersionConvertor_10_50.convertBoolean(src.getAutodeleteElement()));
        }
        if (src.hasResource()) {
            tgt.setResource(VersionConvertor_10_50.convertReference(src.getResource()));
        }
        return tgt;
    }

    public static TestScript.TestScriptFixtureComponent convertTestScriptFixtureComponent(TestScript.TestScriptFixtureComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptFixtureComponent tgt = new TestScript.TestScriptFixtureComponent();
        VersionConvertor_10_50.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasAutocreateElement()) {
            tgt.setAutocreateElement(VersionConvertor_10_50.convertBoolean(src.getAutocreateElement()));
        }
        if (src.hasAutodeleteElement()) {
            tgt.setAutodeleteElement(VersionConvertor_10_50.convertBoolean(src.getAutodeleteElement()));
        }
        if (src.hasResource()) {
            tgt.setResource(VersionConvertor_10_50.convertReference(src.getResource()));
        }
        return tgt;
    }

    public static TestScript.TestScriptMetadataCapabilityComponent convertTestScriptMetadataCapabilityComponent(TestScript.TestScriptMetadataCapabilityComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptMetadataCapabilityComponent tgt = new TestScript.TestScriptMetadataCapabilityComponent();
        VersionConvertor_10_50.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasRequiredElement()) {
            tgt.setRequiredElement(VersionConvertor_10_50.convertBoolean(src.getRequiredElement()));
        }
        if (src.hasValidatedElement()) {
            tgt.setValidatedElement(VersionConvertor_10_50.convertBoolean(src.getValidatedElement()));
        }
        if (src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_10_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasDestinationElement()) {
            tgt.setDestinationElement(VersionConvertor_10_50.convertInteger(src.getDestinationElement()));
        }
        for (org.hl7.fhir.r5.model.UriType t : src.getLink()) {
            tgt.addLink((String)t.getValue());
        }
        if (src.hasCapabilitiesElement()) {
            tgt.setConformance(VersionConvertor_10_50.convertCanonicalToReference(src.getCapabilitiesElement()));
        }
        return tgt;
    }

    public static TestScript.TestScriptMetadataCapabilityComponent convertTestScriptMetadataCapabilityComponent(TestScript.TestScriptMetadataCapabilityComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptMetadataCapabilityComponent tgt = new TestScript.TestScriptMetadataCapabilityComponent();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        if (src.hasRequiredElement()) {
            tgt.setRequiredElement(VersionConvertor_10_50.convertBoolean(src.getRequiredElement()));
        }
        if (src.hasValidatedElement()) {
            tgt.setValidatedElement(VersionConvertor_10_50.convertBoolean(src.getValidatedElement()));
        }
        if (src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_10_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasDestinationElement()) {
            tgt.setDestinationElement(VersionConvertor_10_50.convertInteger(src.getDestinationElement()));
        }
        for (UriType t : src.getLink()) {
            tgt.addLink((String)t.getValue());
        }
        if (src.hasConformance()) {
            tgt.setCapabilitiesElement(VersionConvertor_10_50.convertReferenceToCanonical(src.getConformance()));
        }
        return tgt;
    }

    public static TestScript.TestScriptMetadataComponent convertTestScriptMetadataComponent(TestScript.TestScriptMetadataComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptMetadataComponent tgt = new TestScript.TestScriptMetadataComponent();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        for (TestScript.TestScriptMetadataLinkComponent testScriptMetadataLinkComponent : src.getLink()) {
            tgt.addLink(TestScript10_50.convertTestScriptMetadataLinkComponent(testScriptMetadataLinkComponent));
        }
        for (TestScript.TestScriptMetadataCapabilityComponent testScriptMetadataCapabilityComponent : src.getCapability()) {
            tgt.addCapability(TestScript10_50.convertTestScriptMetadataCapabilityComponent(testScriptMetadataCapabilityComponent));
        }
        return tgt;
    }

    public static TestScript.TestScriptMetadataComponent convertTestScriptMetadataComponent(TestScript.TestScriptMetadataComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptMetadataComponent tgt = new TestScript.TestScriptMetadataComponent();
        VersionConvertor_10_50.copyElement(src, (Element)tgt, new String[0]);
        for (TestScript.TestScriptMetadataLinkComponent testScriptMetadataLinkComponent : src.getLink()) {
            tgt.addLink(TestScript10_50.convertTestScriptMetadataLinkComponent(testScriptMetadataLinkComponent));
        }
        for (TestScript.TestScriptMetadataCapabilityComponent testScriptMetadataCapabilityComponent : src.getCapability()) {
            tgt.addCapability(TestScript10_50.convertTestScriptMetadataCapabilityComponent(testScriptMetadataCapabilityComponent));
        }
        return tgt;
    }

    public static TestScript.TestScriptMetadataLinkComponent convertTestScriptMetadataLinkComponent(TestScript.TestScriptMetadataLinkComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptMetadataLinkComponent tgt = new TestScript.TestScriptMetadataLinkComponent();
        VersionConvertor_10_50.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasUrlElement()) {
            tgt.setUrlElement(VersionConvertor_10_50.convertUri(src.getUrlElement()));
        }
        if (src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_10_50.convertString(src.getDescriptionElement()));
        }
        return tgt;
    }

    public static TestScript.TestScriptMetadataLinkComponent convertTestScriptMetadataLinkComponent(TestScript.TestScriptMetadataLinkComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptMetadataLinkComponent tgt = new TestScript.TestScriptMetadataLinkComponent();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        if (src.hasUrlElement()) {
            tgt.setUrlElement(VersionConvertor_10_50.convertUri(src.getUrlElement()));
        }
        if (src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_10_50.convertString(src.getDescriptionElement()));
        }
        return tgt;
    }

    public static TestScript.TestScriptSetupComponent convertTestScriptSetupComponent(TestScript.TestScriptSetupComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptSetupComponent tgt = new TestScript.TestScriptSetupComponent();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        for (TestScript.TestScriptSetupActionComponent t : src.getAction()) {
            tgt.addAction(TestScript10_50.convertSetupActionComponent(t));
        }
        return tgt;
    }

    public static TestScript.TestScriptSetupComponent convertTestScriptSetupComponent(TestScript.TestScriptSetupComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptSetupComponent tgt = new TestScript.TestScriptSetupComponent();
        VersionConvertor_10_50.copyElement(src, (Element)tgt, new String[0]);
        for (TestScript.SetupActionComponent t : src.getAction()) {
            tgt.addAction(TestScript10_50.convertSetupActionComponent(t));
        }
        return tgt;
    }

    public static TestScript.TestScriptTeardownComponent convertTestScriptTeardownComponent(TestScript.TestScriptTeardownComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptTeardownComponent tgt = new TestScript.TestScriptTeardownComponent();
        VersionConvertor_10_50.copyElement(src, (Element)tgt, new String[0]);
        for (TestScript.TeardownActionComponent t : src.getAction()) {
            tgt.addAction(TestScript10_50.convertTeardownActionComponent(t));
        }
        return tgt;
    }

    public static TestScript.TestScriptTeardownComponent convertTestScriptTeardownComponent(TestScript.TestScriptTeardownComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptTeardownComponent tgt = new TestScript.TestScriptTeardownComponent();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        for (TestScript.TestScriptTeardownActionComponent t : src.getAction()) {
            tgt.addAction(TestScript10_50.convertTeardownActionComponent(t));
        }
        return tgt;
    }

    public static TestScript.TestScriptTestComponent convertTestScriptTestComponent(TestScript.TestScriptTestComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptTestComponent tgt = new TestScript.TestScriptTestComponent();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_50.convertString(src.getNameElement()));
        }
        if (src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_10_50.convertString(src.getDescriptionElement()));
        }
        for (TestScript.TestScriptTestActionComponent t : src.getAction()) {
            tgt.addAction(TestScript10_50.convertTestActionComponent(t));
        }
        return tgt;
    }

    public static TestScript.TestScriptTestComponent convertTestScriptTestComponent(TestScript.TestScriptTestComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptTestComponent tgt = new TestScript.TestScriptTestComponent();
        VersionConvertor_10_50.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_50.convertString(src.getNameElement()));
        }
        if (src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_10_50.convertString(src.getDescriptionElement()));
        }
        for (TestScript.TestActionComponent t : src.getAction()) {
            tgt.addAction(TestScript10_50.convertTestActionComponent(t));
        }
        return tgt;
    }

    public static TestScript.TestScriptVariableComponent convertTestScriptVariableComponent(TestScript.TestScriptVariableComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptVariableComponent tgt = new TestScript.TestScriptVariableComponent();
        VersionConvertor_10_50.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_50.convertString(src.getNameElement()));
        }
        if (src.hasHeaderFieldElement()) {
            tgt.setHeaderFieldElement(VersionConvertor_10_50.convertString(src.getHeaderFieldElement()));
        }
        if (src.hasPathElement()) {
            tgt.setPathElement(VersionConvertor_10_50.convertString(src.getPathElement()));
        }
        if (src.hasSourceIdElement()) {
            tgt.setSourceIdElement(VersionConvertor_10_50.convertId(src.getSourceIdElement()));
        }
        return tgt;
    }

    public static TestScript.TestScriptVariableComponent convertTestScriptVariableComponent(TestScript.TestScriptVariableComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptVariableComponent tgt = new TestScript.TestScriptVariableComponent();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_50.convertString(src.getNameElement()));
        }
        if (src.hasHeaderFieldElement()) {
            tgt.setHeaderFieldElement(VersionConvertor_10_50.convertString(src.getHeaderFieldElement()));
        }
        if (src.hasPathElement()) {
            tgt.setPathElement(VersionConvertor_10_50.convertString(src.getPathElement()));
        }
        if (src.hasSourceIdElement()) {
            tgt.setSourceIdElement(VersionConvertor_10_50.convertId(src.getSourceIdElement()));
        }
        return tgt;
    }
}

