/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_50;

import org.hl7.fhir.convertors.VersionConvertor_10_50;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.SupplyDelivery;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.SupplyDelivery;

public class SupplyDelivery10_50 {
    public static org.hl7.fhir.dstu2.model.SupplyDelivery convertSupplyDelivery(SupplyDelivery src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.SupplyDelivery tgt = new org.hl7.fhir.dstu2.model.SupplyDelivery();
        VersionConvertor_10_50.copyDomainResource(src, tgt, new String[0]);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_10_50.convertIdentifier(src.getIdentifierFirstRep()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(SupplyDelivery10_50.convertSupplyDeliveryStatus(src.getStatusElement()));
        }
        if (src.hasPatient()) {
            tgt.setPatient(VersionConvertor_10_50.convertReference(src.getPatient()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_10_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasSupplier()) {
            tgt.setSupplier(VersionConvertor_10_50.convertReference(src.getSupplier()));
        }
        if (src.hasDestination()) {
            tgt.setDestination(VersionConvertor_10_50.convertReference(src.getDestination()));
        }
        for (Reference t : src.getReceiver()) {
            tgt.addReceiver(VersionConvertor_10_50.convertReference(t));
        }
        return tgt;
    }

    public static SupplyDelivery convertSupplyDelivery(org.hl7.fhir.dstu2.model.SupplyDelivery src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        SupplyDelivery tgt = new SupplyDelivery();
        VersionConvertor_10_50.copyDomainResource(src, tgt, new String[0]);
        if (src.hasIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_50.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(SupplyDelivery10_50.convertSupplyDeliveryStatus(src.getStatusElement()));
        }
        if (src.hasPatient()) {
            tgt.setPatient(VersionConvertor_10_50.convertReference(src.getPatient()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_10_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasSupplier()) {
            tgt.setSupplier(VersionConvertor_10_50.convertReference(src.getSupplier()));
        }
        if (src.hasDestination()) {
            tgt.setDestination(VersionConvertor_10_50.convertReference(src.getDestination()));
        }
        for (org.hl7.fhir.dstu2.model.Reference t : src.getReceiver()) {
            tgt.addReceiver(VersionConvertor_10_50.convertReference(t));
        }
        return tgt;
    }

    public static Enumeration<SupplyDelivery.SupplyDeliveryStatus> convertSupplyDeliveryStatus(org.hl7.fhir.r5.model.Enumeration<SupplyDelivery.SupplyDeliveryStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<SupplyDelivery.SupplyDeliveryStatus> tgt = new Enumeration<SupplyDelivery.SupplyDeliveryStatus>(new SupplyDelivery.SupplyDeliveryStatusEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((SupplyDelivery.SupplyDeliveryStatus)((Object)src.getValue())) {
            case INPROGRESS: {
                tgt.setValue((Object)SupplyDelivery.SupplyDeliveryStatus.INPROGRESS);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)SupplyDelivery.SupplyDeliveryStatus.COMPLETED);
                break;
            }
            case ABANDONED: {
                tgt.setValue((Object)SupplyDelivery.SupplyDeliveryStatus.ABANDONED);
                break;
            }
            default: {
                tgt.setValue((Object)SupplyDelivery.SupplyDeliveryStatus.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<SupplyDelivery.SupplyDeliveryStatus> convertSupplyDeliveryStatus(Enumeration<SupplyDelivery.SupplyDeliveryStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<SupplyDelivery.SupplyDeliveryStatus> tgt = new org.hl7.fhir.r5.model.Enumeration<SupplyDelivery.SupplyDeliveryStatus>(new SupplyDelivery.SupplyDeliveryStatusEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((SupplyDelivery.SupplyDeliveryStatus)((Object)src.getValue())) {
            case INPROGRESS: {
                tgt.setValue((Object)SupplyDelivery.SupplyDeliveryStatus.INPROGRESS);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)SupplyDelivery.SupplyDeliveryStatus.COMPLETED);
                break;
            }
            case ABANDONED: {
                tgt.setValue((Object)SupplyDelivery.SupplyDeliveryStatus.ABANDONED);
                break;
            }
            default: {
                tgt.setValue((Object)SupplyDelivery.SupplyDeliveryStatus.NULL);
            }
        }
        return tgt;
    }
}

