/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_50;

import org.hl7.fhir.convertors.VersionConvertor_10_50;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.Identifier;
import org.hl7.fhir.dstu2.model.Observation;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Observation;
import org.hl7.fhir.r5.model.Reference;

public class Observation10_50 {
    public static org.hl7.fhir.dstu2.model.Observation convertObservation(Observation src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.Observation tgt = new org.hl7.fhir.dstu2.model.Observation();
        VersionConvertor_10_50.copyDomainResource(src, tgt, new String[0]);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Observation10_50.convertObservationStatus(src.getStatusElement()));
        }
        for (CodeableConcept codeableConcept : src.getCategory()) {
            tgt.setCategory(VersionConvertor_10_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_10_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_10_50.convertReference(src.getSubject()));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(VersionConvertor_10_50.convertReference(src.getEncounter()));
        }
        if (src.hasEffective()) {
            tgt.setEffective(VersionConvertor_10_50.convertType(src.getEffective()));
        }
        if (src.hasIssuedElement()) {
            tgt.setIssuedElement(VersionConvertor_10_50.convertInstant(src.getIssuedElement()));
        }
        for (Reference reference : src.getPerformer()) {
            tgt.addPerformer(VersionConvertor_10_50.convertReference(reference));
        }
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_10_50.convertType(src.getValue()));
        }
        if (src.hasDataAbsentReason()) {
            tgt.setDataAbsentReason(VersionConvertor_10_50.convertCodeableConcept(src.getDataAbsentReason()));
        }
        if (src.hasInterpretation()) {
            tgt.setInterpretation(VersionConvertor_10_50.convertCodeableConcept(src.getInterpretationFirstRep()));
        }
        if (src.hasNote()) {
            tgt.setComments(src.getNoteFirstRep().getText());
        }
        if (src.hasBodySite()) {
            tgt.setBodySite(VersionConvertor_10_50.convertCodeableConcept(src.getBodySite()));
        }
        if (src.hasMethod()) {
            tgt.setMethod(VersionConvertor_10_50.convertCodeableConcept(src.getMethod()));
        }
        if (src.hasSpecimen()) {
            tgt.setSpecimen(VersionConvertor_10_50.convertReference(src.getSpecimen()));
        }
        if (src.hasDevice()) {
            tgt.setDevice(VersionConvertor_10_50.convertReference(src.getDevice()));
        }
        for (Observation.ObservationReferenceRangeComponent observationReferenceRangeComponent : src.getReferenceRange()) {
            tgt.addReferenceRange(Observation10_50.convertObservationReferenceRangeComponent(observationReferenceRangeComponent));
        }
        for (Reference reference : src.getHasMember()) {
            tgt.addRelated(Observation10_50.convertObservationRelatedComponent(reference, Observation.ObservationRelationshipType.HASMEMBER));
        }
        for (Reference reference : src.getDerivedFrom()) {
            tgt.addRelated(Observation10_50.convertObservationRelatedComponent(reference, Observation.ObservationRelationshipType.DERIVEDFROM));
        }
        for (Observation.ObservationComponentComponent observationComponentComponent : src.getComponent()) {
            tgt.addComponent(Observation10_50.convertObservationComponentComponent(observationComponentComponent));
        }
        return tgt;
    }

    public static Observation convertObservation(org.hl7.fhir.dstu2.model.Observation src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Observation tgt = new Observation();
        VersionConvertor_10_50.copyDomainResource(src, tgt, new String[0]);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Observation10_50.convertObservationStatus(src.getStatusElement()));
        }
        if (src.hasCategory()) {
            tgt.addCategory(VersionConvertor_10_50.convertCodeableConcept(src.getCategory()));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_10_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_10_50.convertReference(src.getSubject()));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(VersionConvertor_10_50.convertReference(src.getEncounter()));
        }
        if (src.hasEffective()) {
            tgt.setEffective(VersionConvertor_10_50.convertType(src.getEffective()));
        }
        if (src.hasIssuedElement()) {
            tgt.setIssuedElement(VersionConvertor_10_50.convertInstant(src.getIssuedElement()));
        }
        for (org.hl7.fhir.dstu2.model.Reference reference : src.getPerformer()) {
            tgt.addPerformer(VersionConvertor_10_50.convertReference(reference));
        }
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_10_50.convertType(src.getValue()));
        }
        if (src.hasDataAbsentReason()) {
            tgt.setDataAbsentReason(VersionConvertor_10_50.convertCodeableConcept(src.getDataAbsentReason()));
        }
        if (src.hasInterpretation()) {
            tgt.addInterpretation(VersionConvertor_10_50.convertCodeableConcept(src.getInterpretation()));
        }
        if (src.hasComments()) {
            tgt.addNote().setText(src.getComments());
        }
        if (src.hasBodySite()) {
            tgt.setBodySite(VersionConvertor_10_50.convertCodeableConcept(src.getBodySite()));
        }
        if (src.hasMethod()) {
            tgt.setMethod(VersionConvertor_10_50.convertCodeableConcept(src.getMethod()));
        }
        if (src.hasSpecimen()) {
            tgt.setSpecimen(VersionConvertor_10_50.convertReference(src.getSpecimen()));
        }
        if (src.hasDevice()) {
            tgt.setDevice(VersionConvertor_10_50.convertReference(src.getDevice()));
        }
        for (Observation.ObservationReferenceRangeComponent observationReferenceRangeComponent : src.getReferenceRange()) {
            tgt.addReferenceRange(Observation10_50.convertObservationReferenceRangeComponent(observationReferenceRangeComponent));
        }
        for (Observation.ObservationRelatedComponent observationRelatedComponent : src.getRelated()) {
            if (observationRelatedComponent.getType() == Observation.ObservationRelationshipType.HASMEMBER) {
                tgt.addHasMember(VersionConvertor_10_50.convertReference(observationRelatedComponent.getTarget()));
                continue;
            }
            if (observationRelatedComponent.getType() != Observation.ObservationRelationshipType.DERIVEDFROM) continue;
            tgt.addDerivedFrom(VersionConvertor_10_50.convertReference(observationRelatedComponent.getTarget()));
        }
        for (Observation.ObservationComponentComponent observationComponentComponent : src.getComponent()) {
            tgt.addComponent(Observation10_50.convertObservationComponentComponent(observationComponentComponent));
        }
        return tgt;
    }

    public static Observation.ObservationComponentComponent convertObservationComponentComponent(Observation.ObservationComponentComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Observation.ObservationComponentComponent tgt = new Observation.ObservationComponentComponent();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_10_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_10_50.convertType(src.getValue()));
        }
        if (src.hasDataAbsentReason()) {
            tgt.setDataAbsentReason(VersionConvertor_10_50.convertCodeableConcept(src.getDataAbsentReason()));
        }
        for (Observation.ObservationReferenceRangeComponent t : src.getReferenceRange()) {
            tgt.addReferenceRange(Observation10_50.convertObservationReferenceRangeComponent(t));
        }
        return tgt;
    }

    public static Observation.ObservationComponentComponent convertObservationComponentComponent(Observation.ObservationComponentComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Observation.ObservationComponentComponent tgt = new Observation.ObservationComponentComponent();
        VersionConvertor_10_50.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_10_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_10_50.convertType(src.getValue()));
        }
        if (src.hasDataAbsentReason()) {
            tgt.setDataAbsentReason(VersionConvertor_10_50.convertCodeableConcept(src.getDataAbsentReason()));
        }
        for (Observation.ObservationReferenceRangeComponent t : src.getReferenceRange()) {
            tgt.addReferenceRange(Observation10_50.convertObservationReferenceRangeComponent(t));
        }
        return tgt;
    }

    public static Observation.ObservationReferenceRangeComponent convertObservationReferenceRangeComponent(Observation.ObservationReferenceRangeComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Observation.ObservationReferenceRangeComponent tgt = new Observation.ObservationReferenceRangeComponent();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        if (src.hasLow()) {
            tgt.setLow(VersionConvertor_10_50.convertSimpleQuantity(src.getLow()));
        }
        if (src.hasHigh()) {
            tgt.setHigh(VersionConvertor_10_50.convertSimpleQuantity(src.getHigh()));
        }
        if (src.hasMeaning()) {
            tgt.setType(VersionConvertor_10_50.convertCodeableConcept(src.getMeaning()));
        }
        if (src.hasAge()) {
            tgt.setAge(VersionConvertor_10_50.convertRange(src.getAge()));
        }
        if (src.hasTextElement()) {
            tgt.setTextElement(VersionConvertor_10_50.convertString(src.getTextElement()));
        }
        return tgt;
    }

    public static Observation.ObservationReferenceRangeComponent convertObservationReferenceRangeComponent(Observation.ObservationReferenceRangeComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Observation.ObservationReferenceRangeComponent tgt = new Observation.ObservationReferenceRangeComponent();
        VersionConvertor_10_50.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasLow()) {
            tgt.setLow(VersionConvertor_10_50.convertSimpleQuantity(src.getLow()));
        }
        if (src.hasHigh()) {
            tgt.setHigh(VersionConvertor_10_50.convertSimpleQuantity(src.getHigh()));
        }
        if (src.hasType()) {
            tgt.setMeaning(VersionConvertor_10_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasAge()) {
            tgt.setAge(VersionConvertor_10_50.convertRange(src.getAge()));
        }
        if (src.hasTextElement()) {
            tgt.setTextElement(VersionConvertor_10_50.convertString(src.getTextElement()));
        }
        return tgt;
    }

    public static Observation.ObservationRelatedComponent convertObservationRelatedComponent(Reference src, Observation.ObservationRelationshipType type) throws FHIRException {
        if (src == null) {
            return null;
        }
        Observation.ObservationRelatedComponent tgt = new Observation.ObservationRelatedComponent();
        VersionConvertor_10_50.copyElement(src, (Element)tgt, new String[0]);
        tgt.setType(type);
        tgt.setTarget(VersionConvertor_10_50.convertReference(src));
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.ObservationStatus> convertObservationStatus(Enumeration<Observation.ObservationStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.ObservationStatus> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.ObservationStatus>(new Enumerations.ObservationStatusEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((Observation.ObservationStatus)((Object)src.getValue())) {
            case REGISTERED: {
                tgt.setValue((Object)Enumerations.ObservationStatus.REGISTERED);
                break;
            }
            case PRELIMINARY: {
                tgt.setValue((Object)Enumerations.ObservationStatus.PRELIMINARY);
                break;
            }
            case FINAL: {
                tgt.setValue((Object)Enumerations.ObservationStatus.FINAL);
                break;
            }
            case AMENDED: {
                tgt.setValue((Object)Enumerations.ObservationStatus.AMENDED);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)Enumerations.ObservationStatus.CANCELLED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Enumerations.ObservationStatus.ENTEREDINERROR);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)Enumerations.ObservationStatus.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.ObservationStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Observation.ObservationStatus> convertObservationStatus(org.hl7.fhir.r5.model.Enumeration<Enumerations.ObservationStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Observation.ObservationStatus> tgt = new Enumeration<Observation.ObservationStatus>(new Observation.ObservationStatusEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.ObservationStatus)((Object)src.getValue())) {
            case REGISTERED: {
                tgt.setValue((Object)Observation.ObservationStatus.REGISTERED);
                break;
            }
            case PRELIMINARY: {
                tgt.setValue((Object)Observation.ObservationStatus.PRELIMINARY);
                break;
            }
            case FINAL: {
                tgt.setValue((Object)Observation.ObservationStatus.FINAL);
                break;
            }
            case AMENDED: {
                tgt.setValue((Object)Observation.ObservationStatus.AMENDED);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)Observation.ObservationStatus.CANCELLED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Observation.ObservationStatus.ENTEREDINERROR);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)Observation.ObservationStatus.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)Observation.ObservationStatus.NULL);
            }
        }
        return tgt;
    }
}

