/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_50;

import org.hl7.fhir.convertors.VersionConvertor_10_50;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.MedicationDispense;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Dosage;
import org.hl7.fhir.r5.model.MedicationDispense;
import org.hl7.fhir.r5.model.Reference;

public class MedicationDispense10_50 {
    public static MedicationDispense convertMedicationDispense(org.hl7.fhir.dstu2.model.MedicationDispense src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        MedicationDispense tgt = new MedicationDispense();
        VersionConvertor_10_50.copyDomainResource(src, tgt, new String[0]);
        if (src.hasIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_50.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasStatusElement()) {
            tgt.setStatusElement(MedicationDispense10_50.convertMedicationDispenseStatus(src.getStatusElement()));
        }
        if (src.hasMedicationCodeableConcept()) {
            tgt.getMedication().setConcept(VersionConvertor_10_50.convertCodeableConcept(src.getMedicationCodeableConcept()));
        }
        if (src.hasMedicationReference()) {
            tgt.getMedication().setReference(VersionConvertor_10_50.convertReference(src.getMedicationReference()));
        }
        if (src.hasPatient()) {
            tgt.setSubject(VersionConvertor_10_50.convertReference(src.getPatient()));
        }
        for (org.hl7.fhir.dstu2.model.Reference reference : src.getAuthorizingPrescription()) {
            tgt.addAuthorizingPrescription(VersionConvertor_10_50.convertReference(reference));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_10_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(VersionConvertor_10_50.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasDaysSupply()) {
            tgt.setDaysSupply(VersionConvertor_10_50.convertSimpleQuantity(src.getDaysSupply()));
        }
        if (src.hasWhenPreparedElement()) {
            tgt.setWhenPreparedElement(VersionConvertor_10_50.convertDateTime(src.getWhenPreparedElement()));
        }
        if (src.hasWhenHandedOverElement()) {
            tgt.setWhenHandedOverElement(VersionConvertor_10_50.convertDateTime(src.getWhenHandedOverElement()));
        }
        if (src.hasDestination()) {
            tgt.setDestination(VersionConvertor_10_50.convertReference(src.getDestination()));
        }
        for (org.hl7.fhir.dstu2.model.Reference reference : src.getReceiver()) {
            tgt.addReceiver(VersionConvertor_10_50.convertReference(reference));
        }
        if (src.hasNote()) {
            tgt.addNote().setText(src.getNote());
        }
        for (MedicationDispense.MedicationDispenseDosageInstructionComponent medicationDispenseDosageInstructionComponent : src.getDosageInstruction()) {
            tgt.addDosageInstruction(MedicationDispense10_50.convertMedicationDispenseDosageInstructionComponent(medicationDispenseDosageInstructionComponent));
        }
        if (src.hasSubstitution()) {
            tgt.setSubstitution(MedicationDispense10_50.convertMedicationDispenseSubstitutionComponent(src.getSubstitution()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.MedicationDispense convertMedicationDispense(MedicationDispense src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.MedicationDispense tgt = new org.hl7.fhir.dstu2.model.MedicationDispense();
        VersionConvertor_10_50.copyDomainResource(src, tgt, new String[0]);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_10_50.convertIdentifier(src.getIdentifierFirstRep()));
        }
        if (src.hasStatusElement()) {
            tgt.setStatusElement(MedicationDispense10_50.convertMedicationDispenseStatus(src.getStatusElement()));
        }
        if (src.getMedication().hasConcept()) {
            tgt.setMedication(VersionConvertor_10_50.convertType(src.getMedication().getConcept()));
        }
        if (src.getMedication().hasReference()) {
            tgt.setMedication(VersionConvertor_10_50.convertType(src.getMedication().getReference()));
        }
        if (src.hasSubject()) {
            tgt.setPatient(VersionConvertor_10_50.convertReference(src.getSubject()));
        }
        for (Reference reference : src.getAuthorizingPrescription()) {
            tgt.addAuthorizingPrescription(VersionConvertor_10_50.convertReference(reference));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_10_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(VersionConvertor_10_50.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasDaysSupply()) {
            tgt.setDaysSupply(VersionConvertor_10_50.convertSimpleQuantity(src.getDaysSupply()));
        }
        if (src.hasWhenPreparedElement()) {
            tgt.setWhenPreparedElement(VersionConvertor_10_50.convertDateTime(src.getWhenPreparedElement()));
        }
        if (src.hasWhenHandedOverElement()) {
            tgt.setWhenHandedOverElement(VersionConvertor_10_50.convertDateTime(src.getWhenHandedOverElement()));
        }
        if (src.hasDestination()) {
            tgt.setDestination(VersionConvertor_10_50.convertReference(src.getDestination()));
        }
        for (Reference reference : src.getReceiver()) {
            tgt.addReceiver(VersionConvertor_10_50.convertReference(reference));
        }
        for (Annotation annotation : src.getNote()) {
            tgt.setNote(annotation.getText());
        }
        for (Dosage dosage : src.getDosageInstruction()) {
            tgt.addDosageInstruction(MedicationDispense10_50.convertMedicationDispenseDosageInstructionComponent(dosage));
        }
        if (src.hasSubstitution()) {
            tgt.setSubstitution(MedicationDispense10_50.convertMedicationDispenseSubstitutionComponent(src.getSubstitution()));
        }
        return tgt;
    }

    public static Dosage convertMedicationDispenseDosageInstructionComponent(MedicationDispense.MedicationDispenseDosageInstructionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Dosage tgt = new Dosage();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        if (src.hasTextElement()) {
            tgt.setTextElement(VersionConvertor_10_50.convertString(src.getTextElement()));
        }
        if (src.hasTiming()) {
            tgt.setTiming(VersionConvertor_10_50.convertTiming(src.getTiming()));
        }
        if (src.hasAsNeeded()) {
            tgt.setAsNeeded(VersionConvertor_10_50.convertType(src.getAsNeeded()));
        }
        if (src.hasSiteCodeableConcept()) {
            tgt.setSite(VersionConvertor_10_50.convertCodeableConcept(src.getSiteCodeableConcept()));
        }
        if (src.hasRoute()) {
            tgt.setRoute(VersionConvertor_10_50.convertCodeableConcept(src.getRoute()));
        }
        if (src.hasMethod()) {
            tgt.setMethod(VersionConvertor_10_50.convertCodeableConcept(src.getMethod()));
        }
        if (src.hasDose() || src.hasRate()) {
            Dosage.DosageDoseAndRateComponent dr = tgt.addDoseAndRate();
            if (src.hasDose()) {
                dr.setDose(VersionConvertor_10_50.convertType(src.getDose()));
            }
            if (src.hasRate()) {
                dr.setRate(VersionConvertor_10_50.convertType(src.getRate()));
            }
        }
        if (src.hasMaxDosePerPeriod()) {
            tgt.setMaxDosePerPeriod(VersionConvertor_10_50.convertRatio(src.getMaxDosePerPeriod()));
        }
        return tgt;
    }

    public static MedicationDispense.MedicationDispenseDosageInstructionComponent convertMedicationDispenseDosageInstructionComponent(Dosage src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        MedicationDispense.MedicationDispenseDosageInstructionComponent tgt = new MedicationDispense.MedicationDispenseDosageInstructionComponent();
        VersionConvertor_10_50.copyElement(src, (Element)tgt, new String[0]);
        tgt.setText(src.getText());
        tgt.setTiming(VersionConvertor_10_50.convertTiming(src.getTiming()));
        tgt.setAsNeeded(VersionConvertor_10_50.convertType(src.getAsNeeded()));
        tgt.setSite(VersionConvertor_10_50.convertType(src.getSite()));
        tgt.setRoute(VersionConvertor_10_50.convertCodeableConcept(src.getRoute()));
        tgt.setMethod(VersionConvertor_10_50.convertCodeableConcept(src.getMethod()));
        if (src.hasDoseAndRate() && src.getDoseAndRate().get(0).hasDose()) {
            tgt.setDose(VersionConvertor_10_50.convertType(src.getDoseAndRate().get(0).getDose()));
        }
        tgt.setMaxDosePerPeriod(VersionConvertor_10_50.convertRatio(src.getMaxDosePerPeriod()));
        if (src.hasDoseAndRate() && src.getDoseAndRate().get(0).hasRate()) {
            tgt.setRate(VersionConvertor_10_50.convertType(src.getDoseAndRate().get(0).getRate()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<MedicationDispense.MedicationDispenseStatusCodes> convertMedicationDispenseStatus(Enumeration<MedicationDispense.MedicationDispenseStatus> src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<MedicationDispense.MedicationDispenseStatusCodes> tgt = new org.hl7.fhir.r5.model.Enumeration<MedicationDispense.MedicationDispenseStatusCodes>(new MedicationDispense.MedicationDispenseStatusCodesEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((MedicationDispense.MedicationDispenseStatus)((Object)src.getValue())) {
            case COMPLETED: {
                tgt.setValue((Object)MedicationDispense.MedicationDispenseStatusCodes.COMPLETED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)MedicationDispense.MedicationDispenseStatusCodes.ENTEREDINERROR);
                break;
            }
            case INPROGRESS: {
                tgt.setValue((Object)MedicationDispense.MedicationDispenseStatusCodes.INPROGRESS);
                break;
            }
            case NULL: {
                tgt.setValue((Object)MedicationDispense.MedicationDispenseStatusCodes.NULL);
                break;
            }
            case ONHOLD: {
                tgt.setValue((Object)MedicationDispense.MedicationDispenseStatusCodes.ONHOLD);
                break;
            }
            case STOPPED: {
                tgt.setValue((Object)MedicationDispense.MedicationDispenseStatusCodes.STOPPED);
            }
        }
        return tgt;
    }

    public static Enumeration<MedicationDispense.MedicationDispenseStatus> convertMedicationDispenseStatus(org.hl7.fhir.r5.model.Enumeration<MedicationDispense.MedicationDispenseStatusCodes> src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Enumeration<MedicationDispense.MedicationDispenseStatus> tgt = new Enumeration<MedicationDispense.MedicationDispenseStatus>(new MedicationDispense.MedicationDispenseStatusEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((MedicationDispense.MedicationDispenseStatusCodes)((Object)src.getValue())) {
            case COMPLETED: {
                tgt.setValue((Object)MedicationDispense.MedicationDispenseStatus.COMPLETED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)MedicationDispense.MedicationDispenseStatus.ENTEREDINERROR);
                break;
            }
            case INPROGRESS: {
                tgt.setValue((Object)MedicationDispense.MedicationDispenseStatus.INPROGRESS);
                break;
            }
            case NULL: {
                tgt.setValue((Object)MedicationDispense.MedicationDispenseStatus.NULL);
                break;
            }
            case ONHOLD: {
                tgt.setValue((Object)MedicationDispense.MedicationDispenseStatus.ONHOLD);
                break;
            }
            case STOPPED: {
                tgt.setValue((Object)MedicationDispense.MedicationDispenseStatus.STOPPED);
            }
        }
        return tgt;
    }

    public static MedicationDispense.MedicationDispenseSubstitutionComponent convertMedicationDispenseSubstitutionComponent(MedicationDispense.MedicationDispenseSubstitutionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        MedicationDispense.MedicationDispenseSubstitutionComponent tgt = new MedicationDispense.MedicationDispenseSubstitutionComponent();
        VersionConvertor_10_50.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasType()) {
            tgt.setType(VersionConvertor_10_50.convertCodeableConcept(src.getType()));
        }
        for (CodeableConcept t : src.getReason()) {
            tgt.addReason(VersionConvertor_10_50.convertCodeableConcept(t));
        }
        if (src.hasResponsibleParty()) {
            tgt.addResponsibleParty(VersionConvertor_10_50.convertReference(src.getResponsibleParty()));
        }
        return tgt;
    }

    public static MedicationDispense.MedicationDispenseSubstitutionComponent convertMedicationDispenseSubstitutionComponent(MedicationDispense.MedicationDispenseSubstitutionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        MedicationDispense.MedicationDispenseSubstitutionComponent tgt = new MedicationDispense.MedicationDispenseSubstitutionComponent();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setType(VersionConvertor_10_50.convertCodeableConcept(src.getType()));
        }
        for (org.hl7.fhir.dstu2.model.CodeableConcept codeableConcept : src.getReason()) {
            tgt.addReason(VersionConvertor_10_50.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.dstu2.model.Reference reference : src.getResponsibleParty()) {
            tgt.setResponsibleParty(VersionConvertor_10_50.convertReference(reference));
        }
        return tgt;
    }
}

