/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_50;

import org.hl7.fhir.convertors.VersionConvertor_10_50;
import org.hl7.fhir.dstu2.model.BackboneElement;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.Identifier;
import org.hl7.fhir.dstu2.model.List_;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.ListResource;

public class List10_50 {
    public static List_ convertList(ListResource src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        List_ tgt = new List_();
        VersionConvertor_10_50.copyDomainResource(src, tgt, new String[0]);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_50.convertIdentifier(identifier));
        }
        if (src.hasTitleElement()) {
            tgt.setTitleElement(VersionConvertor_10_50.convertString(src.getTitleElement()));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_10_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_10_50.convertReference(src.getSubject()));
        }
        if (src.hasSource()) {
            tgt.setSource(VersionConvertor_10_50.convertReference(src.getSource()));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(VersionConvertor_10_50.convertReference(src.getEncounter()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(List10_50.convertListStatus(src.getStatusElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_10_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasOrderedBy()) {
            tgt.setOrderedBy(VersionConvertor_10_50.convertCodeableConcept(src.getOrderedBy()));
        }
        if (src.hasMode()) {
            tgt.setModeElement(List10_50.convertListMode(src.getModeElement()));
        }
        for (Annotation annotation : src.getNote()) {
            tgt.setNote(annotation.getText());
        }
        for (ListResource.ListResourceEntryComponent listResourceEntryComponent : src.getEntry()) {
            tgt.addEntry(List10_50.convertListEntry(listResourceEntryComponent));
        }
        return tgt;
    }

    public static ListResource convertList(List_ src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ListResource tgt = new ListResource();
        VersionConvertor_10_50.copyDomainResource(src, tgt, new String[0]);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_50.convertIdentifier(identifier));
        }
        if (src.hasTitleElement()) {
            tgt.setTitleElement(VersionConvertor_10_50.convertString(src.getTitleElement()));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_10_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_10_50.convertReference(src.getSubject()));
        }
        if (src.hasSource()) {
            tgt.setSource(VersionConvertor_10_50.convertReference(src.getSource()));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(VersionConvertor_10_50.convertReference(src.getEncounter()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(List10_50.convertListStatus(src.getStatusElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_10_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasOrderedBy()) {
            tgt.setOrderedBy(VersionConvertor_10_50.convertCodeableConcept(src.getOrderedBy()));
        }
        if (src.hasMode()) {
            tgt.setModeElement(List10_50.convertListMode(src.getModeElement()));
        }
        if (src.hasNote()) {
            tgt.addNote(new Annotation().setText(src.getNote()));
        }
        for (List_.ListEntryComponent listEntryComponent : src.getEntry()) {
            tgt.addEntry(List10_50.convertListEntry(listEntryComponent));
        }
        return tgt;
    }

    public static List_.ListEntryComponent convertListEntry(ListResource.ListResourceEntryComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        List_.ListEntryComponent tgt = new List_.ListEntryComponent();
        List10_50.copyBackboneElement(src, tgt);
        if (src.hasFlag()) {
            tgt.setFlag(VersionConvertor_10_50.convertCodeableConcept(src.getFlag()));
        }
        if (src.hasDeletedElement()) {
            tgt.setDeletedElement(VersionConvertor_10_50.convertBoolean(src.getDeletedElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_10_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasItem()) {
            tgt.setItem(VersionConvertor_10_50.convertReference(src.getItem()));
        }
        return tgt;
    }

    public static ListResource.ListResourceEntryComponent convertListEntry(List_.ListEntryComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ListResource.ListResourceEntryComponent tgt = new ListResource.ListResourceEntryComponent();
        List10_50.copyBackboneElement(src, tgt);
        if (src.hasFlag()) {
            tgt.setFlag(VersionConvertor_10_50.convertCodeableConcept(src.getFlag()));
        }
        if (src.hasDeletedElement()) {
            tgt.setDeletedElement(VersionConvertor_10_50.convertBoolean(src.getDeletedElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_10_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasItem()) {
            tgt.setItem(VersionConvertor_10_50.convertReference(src.getItem()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.ListMode> convertListMode(Enumeration<List_.ListMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.ListMode> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.ListMode>(new Enumerations.ListModeEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((List_.ListMode)((Object)src.getValue())) {
            case WORKING: {
                tgt.setValue((Object)Enumerations.ListMode.WORKING);
                break;
            }
            case SNAPSHOT: {
                tgt.setValue((Object)Enumerations.ListMode.SNAPSHOT);
                break;
            }
            case CHANGES: {
                tgt.setValue((Object)Enumerations.ListMode.CHANGES);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.ListMode.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<List_.ListMode> convertListMode(org.hl7.fhir.r5.model.Enumeration<Enumerations.ListMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<List_.ListMode> tgt = new Enumeration<List_.ListMode>(new List_.ListModeEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.ListMode)((Object)src.getValue())) {
            case WORKING: {
                tgt.setValue((Object)List_.ListMode.WORKING);
                break;
            }
            case SNAPSHOT: {
                tgt.setValue((Object)List_.ListMode.SNAPSHOT);
                break;
            }
            case CHANGES: {
                tgt.setValue((Object)List_.ListMode.CHANGES);
                break;
            }
            default: {
                tgt.setValue((Object)List_.ListMode.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<ListResource.ListStatus> convertListStatus(Enumeration<List_.ListStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<ListResource.ListStatus> tgt = new org.hl7.fhir.r5.model.Enumeration<ListResource.ListStatus>(new ListResource.ListStatusEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((List_.ListStatus)((Object)src.getValue())) {
            case CURRENT: {
                tgt.setValue((Object)ListResource.ListStatus.CURRENT);
                break;
            }
            case RETIRED: {
                tgt.setValue((Object)ListResource.ListStatus.RETIRED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)ListResource.ListStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)ListResource.ListStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<List_.ListStatus> convertListStatus(org.hl7.fhir.r5.model.Enumeration<ListResource.ListStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<List_.ListStatus> tgt = new Enumeration<List_.ListStatus>(new List_.ListStatusEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((ListResource.ListStatus)((Object)src.getValue())) {
            case CURRENT: {
                tgt.setValue((Object)List_.ListStatus.CURRENT);
                break;
            }
            case RETIRED: {
                tgt.setValue((Object)List_.ListStatus.RETIRED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)List_.ListStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)List_.ListStatus.NULL);
            }
        }
        return tgt;
    }

    public static void copyBackboneElement(BackboneElement src, org.hl7.fhir.r5.model.BackboneElement tgt) throws FHIRException {
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        for (org.hl7.fhir.dstu2.model.Extension e : src.getModifierExtension()) {
            tgt.addModifierExtension(VersionConvertor_10_50.convertExtension(e));
        }
    }

    public static void copyBackboneElement(org.hl7.fhir.r5.model.BackboneElement src, BackboneElement tgt) throws FHIRException {
        VersionConvertor_10_50.copyElement(src, (Element)tgt, new String[0]);
        for (Extension e : src.getModifierExtension()) {
            tgt.addModifierExtension(VersionConvertor_10_50.convertExtension(e));
        }
    }
}

