/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_50;

import org.hl7.fhir.convertors.VersionConvertor_10_50;
import org.hl7.fhir.dstu2.model.Coding;
import org.hl7.fhir.dstu2.model.DocumentReference;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.Enumerations;
import org.hl7.fhir.dstu2.model.Identifier;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.DocumentReference;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Reference;

public class DocumentReference10_50 {
    public static org.hl7.fhir.dstu2.model.CodeableConcept convertDocStatus(Enumerations.CompositionStatus docStatus) {
        org.hl7.fhir.dstu2.model.CodeableConcept cc = new org.hl7.fhir.dstu2.model.CodeableConcept();
        switch (docStatus) {
            case AMENDED: {
                cc.addCoding().setSystem("http://hl7.org/fhir/composition-status").setCode("amended");
                break;
            }
            case ENTEREDINERROR: {
                cc.addCoding().setSystem("http://hl7.org/fhir/composition-status").setCode("entered-in-error");
                break;
            }
            case FINAL: {
                cc.addCoding().setSystem("http://hl7.org/fhir/composition-status").setCode("final");
                break;
            }
            case PRELIMINARY: {
                cc.addCoding().setSystem("http://hl7.org/fhir/composition-status").setCode("preliminary");
                break;
            }
            default: {
                return null;
            }
        }
        return cc;
    }

    public static Enumerations.CompositionStatus convertDocStatus(org.hl7.fhir.dstu2.model.CodeableConcept cc) {
        if (VersionConvertor_10_50.hasConcept(cc, "http://hl7.org/fhir/composition-status", "preliminary")) {
            return Enumerations.CompositionStatus.PRELIMINARY;
        }
        if (VersionConvertor_10_50.hasConcept(cc, "http://hl7.org/fhir/composition-status", "final")) {
            return Enumerations.CompositionStatus.FINAL;
        }
        if (VersionConvertor_10_50.hasConcept(cc, "http://hl7.org/fhir/composition-status", "amended")) {
            return Enumerations.CompositionStatus.AMENDED;
        }
        if (VersionConvertor_10_50.hasConcept(cc, "http://hl7.org/fhir/composition-status", "entered-in-error")) {
            return Enumerations.CompositionStatus.ENTEREDINERROR;
        }
        return null;
    }

    public static DocumentReference convertDocumentReference(org.hl7.fhir.r5.model.DocumentReference src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        DocumentReference tgt = new DocumentReference();
        VersionConvertor_10_50.copyDomainResource(src, tgt, new String[0]);
        if (src.hasMasterIdentifier()) {
            tgt.setMasterIdentifier(VersionConvertor_10_50.convertIdentifier(src.getMasterIdentifier()));
        }
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_50.convertIdentifier(identifier));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_10_50.convertReference(src.getSubject()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_10_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasCategory()) {
            tgt.setClass_(VersionConvertor_10_50.convertCodeableConcept(src.getCategoryFirstRep()));
        }
        if (src.hasCustodian()) {
            tgt.setCustodian(VersionConvertor_10_50.convertReference(src.getCustodian()));
        }
        if (src.hasAuthenticator()) {
            tgt.setAuthenticator(VersionConvertor_10_50.convertReference(src.getAuthenticator()));
        }
        if (src.hasDate()) {
            tgt.setCreated(src.getDate());
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(DocumentReference10_50.convertDocumentReferenceStatus(src.getStatusElement()));
        }
        if (src.hasDocStatus()) {
            tgt.setDocStatus(DocumentReference10_50.convertDocStatus(src.getDocStatus()));
        }
        for (DocumentReference.DocumentReferenceRelatesToComponent documentReferenceRelatesToComponent : src.getRelatesTo()) {
            tgt.addRelatesTo(DocumentReference10_50.convertDocumentReferenceRelatesToComponent(documentReferenceRelatesToComponent));
        }
        if (src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_10_50.convertString(src.getDescriptionElement()));
        }
        for (CodeableConcept codeableConcept : src.getSecurityLabel()) {
            tgt.addSecurityLabel(VersionConvertor_10_50.convertCodeableConcept(codeableConcept));
        }
        for (DocumentReference.DocumentReferenceContentComponent documentReferenceContentComponent : src.getContent()) {
            tgt.addContent(DocumentReference10_50.convertDocumentReferenceContentComponent(documentReferenceContentComponent));
        }
        if (src.hasContext()) {
            tgt.setContext(DocumentReference10_50.convertDocumentReferenceContextComponent(src.getContext()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.DocumentReference convertDocumentReference(DocumentReference src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.DocumentReference tgt = new org.hl7.fhir.r5.model.DocumentReference();
        VersionConvertor_10_50.copyDomainResource(src, tgt, new String[0]);
        if (src.hasMasterIdentifier()) {
            tgt.setMasterIdentifier(VersionConvertor_10_50.convertIdentifier(src.getMasterIdentifier()));
        }
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_50.convertIdentifier(identifier));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_10_50.convertReference(src.getSubject()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_10_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasClass_()) {
            tgt.addCategory(VersionConvertor_10_50.convertCodeableConcept(src.getClass_()));
        }
        if (src.hasCustodian()) {
            tgt.setCustodian(VersionConvertor_10_50.convertReference(src.getCustodian()));
        }
        if (src.hasAuthenticator()) {
            tgt.setAuthenticator(VersionConvertor_10_50.convertReference(src.getAuthenticator()));
        }
        if (src.hasCreated()) {
            tgt.setDate(src.getCreated());
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(DocumentReference10_50.convertDocumentReferenceStatus(src.getStatusElement()));
        }
        if (src.hasDocStatus()) {
            tgt.setDocStatus(DocumentReference10_50.convertDocStatus(src.getDocStatus()));
        }
        for (DocumentReference.DocumentReferenceRelatesToComponent documentReferenceRelatesToComponent : src.getRelatesTo()) {
            tgt.addRelatesTo(DocumentReference10_50.convertDocumentReferenceRelatesToComponent(documentReferenceRelatesToComponent));
        }
        if (src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_10_50.convertString(src.getDescriptionElement()));
        }
        for (org.hl7.fhir.dstu2.model.CodeableConcept codeableConcept : src.getSecurityLabel()) {
            tgt.addSecurityLabel(VersionConvertor_10_50.convertCodeableConcept(codeableConcept));
        }
        for (DocumentReference.DocumentReferenceContentComponent documentReferenceContentComponent : src.getContent()) {
            tgt.addContent(DocumentReference10_50.convertDocumentReferenceContentComponent(documentReferenceContentComponent));
        }
        if (src.hasContext()) {
            tgt.setContext(DocumentReference10_50.convertDocumentReferenceContextComponent(src.getContext()));
        }
        return tgt;
    }

    public static DocumentReference.DocumentReferenceContentComponent convertDocumentReferenceContentComponent(DocumentReference.DocumentReferenceContentComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        DocumentReference.DocumentReferenceContentComponent tgt = new DocumentReference.DocumentReferenceContentComponent();
        VersionConvertor_10_50.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasAttachment()) {
            tgt.setAttachment(VersionConvertor_10_50.convertAttachment(src.getAttachment()));
        }
        if (src.hasFormat()) {
            tgt.addFormat(VersionConvertor_10_50.convertCoding(src.getFormat()));
        }
        return tgt;
    }

    public static DocumentReference.DocumentReferenceContentComponent convertDocumentReferenceContentComponent(DocumentReference.DocumentReferenceContentComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        DocumentReference.DocumentReferenceContentComponent tgt = new DocumentReference.DocumentReferenceContentComponent();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        if (src.hasAttachment()) {
            tgt.setAttachment(VersionConvertor_10_50.convertAttachment(src.getAttachment()));
        }
        for (Coding t : src.getFormat()) {
            tgt.setFormat(VersionConvertor_10_50.convertCoding(t));
        }
        return tgt;
    }

    public static DocumentReference.DocumentReferenceContextComponent convertDocumentReferenceContextComponent(DocumentReference.DocumentReferenceContextComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        DocumentReference.DocumentReferenceContextComponent tgt = new DocumentReference.DocumentReferenceContextComponent();
        VersionConvertor_10_50.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasEncounter()) {
            tgt.setEncounter(VersionConvertor_10_50.convertReference(src.getEncounterFirstRep()));
        }
        for (CodeableConcept codeableConcept : src.getEvent()) {
            tgt.addEvent(VersionConvertor_10_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_10_50.convertPeriod(src.getPeriod()));
        }
        if (src.hasFacilityType()) {
            tgt.setFacilityType(VersionConvertor_10_50.convertCodeableConcept(src.getFacilityType()));
        }
        if (src.hasPracticeSetting()) {
            tgt.setPracticeSetting(VersionConvertor_10_50.convertCodeableConcept(src.getPracticeSetting()));
        }
        if (src.hasSourcePatientInfo()) {
            tgt.setSourcePatientInfo(VersionConvertor_10_50.convertReference(src.getSourcePatientInfo()));
        }
        for (Reference reference : src.getRelated()) {
            tgt.addRelated(DocumentReference10_50.convertDocumentReferenceContextRelatedComponent(reference));
        }
        return tgt;
    }

    public static DocumentReference.DocumentReferenceContextComponent convertDocumentReferenceContextComponent(DocumentReference.DocumentReferenceContextComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        DocumentReference.DocumentReferenceContextComponent tgt = new DocumentReference.DocumentReferenceContextComponent();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        if (src.hasEncounter()) {
            tgt.addEncounter(VersionConvertor_10_50.convertReference(src.getEncounter()));
        }
        for (org.hl7.fhir.dstu2.model.CodeableConcept codeableConcept : src.getEvent()) {
            tgt.addEvent(VersionConvertor_10_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_10_50.convertPeriod(src.getPeriod()));
        }
        if (src.hasFacilityType()) {
            tgt.setFacilityType(VersionConvertor_10_50.convertCodeableConcept(src.getFacilityType()));
        }
        if (src.hasPracticeSetting()) {
            tgt.setPracticeSetting(VersionConvertor_10_50.convertCodeableConcept(src.getPracticeSetting()));
        }
        if (src.hasSourcePatientInfo()) {
            tgt.setSourcePatientInfo(VersionConvertor_10_50.convertReference(src.getSourcePatientInfo()));
        }
        for (DocumentReference.DocumentReferenceContextRelatedComponent documentReferenceContextRelatedComponent : src.getRelated()) {
            tgt.addRelated(DocumentReference10_50.convertDocumentReferenceContextRelatedComponent(documentReferenceContextRelatedComponent));
        }
        return tgt;
    }

    public static Reference convertDocumentReferenceContextRelatedComponent(DocumentReference.DocumentReferenceContextRelatedComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Reference tgt = VersionConvertor_10_50.convertReference(src.getRef());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_10_50.convertIdentifier(src.getIdentifier()));
        }
        return tgt;
    }

    public static DocumentReference.DocumentReferenceContextRelatedComponent convertDocumentReferenceContextRelatedComponent(Reference src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        DocumentReference.DocumentReferenceContextRelatedComponent tgt = new DocumentReference.DocumentReferenceContextRelatedComponent();
        VersionConvertor_10_50.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_10_50.convertIdentifier(src.getIdentifier()));
        }
        tgt.setRef(VersionConvertor_10_50.convertReference(src));
        return tgt;
    }

    public static DocumentReference.DocumentReferenceRelatesToComponent convertDocumentReferenceRelatesToComponent(DocumentReference.DocumentReferenceRelatesToComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        DocumentReference.DocumentReferenceRelatesToComponent tgt = new DocumentReference.DocumentReferenceRelatesToComponent();
        VersionConvertor_10_50.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCodeElement(DocumentReference10_50.convertDocumentRelationshipType(src.getCodeElement()));
        }
        if (src.hasTarget()) {
            tgt.setTarget(VersionConvertor_10_50.convertReference(src.getTarget()));
        }
        return tgt;
    }

    public static DocumentReference.DocumentReferenceRelatesToComponent convertDocumentReferenceRelatesToComponent(DocumentReference.DocumentReferenceRelatesToComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        DocumentReference.DocumentReferenceRelatesToComponent tgt = new DocumentReference.DocumentReferenceRelatesToComponent();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCodeElement(DocumentReference10_50.convertDocumentRelationshipType(src.getCodeElement()));
        }
        if (src.hasTarget()) {
            tgt.setTarget(VersionConvertor_10_50.convertReference(src.getTarget()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.DocumentReferenceStatus> convertDocumentReferenceStatus(Enumeration<Enumerations.DocumentReferenceStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.DocumentReferenceStatus> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.DocumentReferenceStatus>(new Enumerations.DocumentReferenceStatusEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.DocumentReferenceStatus)((Object)src.getValue())) {
            case CURRENT: {
                tgt.setValue((Object)Enumerations.DocumentReferenceStatus.CURRENT);
                break;
            }
            case SUPERSEDED: {
                tgt.setValue((Object)Enumerations.DocumentReferenceStatus.SUPERSEDED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Enumerations.DocumentReferenceStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.DocumentReferenceStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Enumerations.DocumentReferenceStatus> convertDocumentReferenceStatus(org.hl7.fhir.r5.model.Enumeration<Enumerations.DocumentReferenceStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Enumerations.DocumentReferenceStatus> tgt = new Enumeration<Enumerations.DocumentReferenceStatus>(new Enumerations.DocumentReferenceStatusEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.DocumentReferenceStatus)((Object)src.getValue())) {
            case CURRENT: {
                tgt.setValue((Object)Enumerations.DocumentReferenceStatus.CURRENT);
                break;
            }
            case SUPERSEDED: {
                tgt.setValue((Object)Enumerations.DocumentReferenceStatus.SUPERSEDED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Enumerations.DocumentReferenceStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.DocumentReferenceStatus.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.DocumentRelationshipType> convertDocumentRelationshipType(Enumeration<DocumentReference.DocumentRelationshipType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.DocumentRelationshipType> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.DocumentRelationshipType>(new Enumerations.DocumentRelationshipTypeEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((DocumentReference.DocumentRelationshipType)((Object)src.getValue())) {
            case REPLACES: {
                tgt.setValue((Object)Enumerations.DocumentRelationshipType.REPLACES);
                break;
            }
            case TRANSFORMS: {
                tgt.setValue((Object)Enumerations.DocumentRelationshipType.TRANSFORMS);
                break;
            }
            case SIGNS: {
                tgt.setValue((Object)Enumerations.DocumentRelationshipType.SIGNS);
                break;
            }
            case APPENDS: {
                tgt.setValue((Object)Enumerations.DocumentRelationshipType.APPENDS);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.DocumentRelationshipType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<DocumentReference.DocumentRelationshipType> convertDocumentRelationshipType(org.hl7.fhir.r5.model.Enumeration<Enumerations.DocumentRelationshipType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<DocumentReference.DocumentRelationshipType> tgt = new Enumeration<DocumentReference.DocumentRelationshipType>(new DocumentReference.DocumentRelationshipTypeEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.DocumentRelationshipType)((Object)src.getValue())) {
            case REPLACES: {
                tgt.setValue((Object)DocumentReference.DocumentRelationshipType.REPLACES);
                break;
            }
            case TRANSFORMS: {
                tgt.setValue((Object)DocumentReference.DocumentRelationshipType.TRANSFORMS);
                break;
            }
            case SIGNS: {
                tgt.setValue((Object)DocumentReference.DocumentRelationshipType.SIGNS);
                break;
            }
            case APPENDS: {
                tgt.setValue((Object)DocumentReference.DocumentRelationshipType.APPENDS);
                break;
            }
            default: {
                tgt.setValue((Object)DocumentReference.DocumentRelationshipType.NULL);
            }
        }
        return tgt;
    }
}

