/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_50;

import org.hl7.fhir.convertors.VersionConvertor_10_50;
import org.hl7.fhir.dstu2.model.Coding;
import org.hl7.fhir.dstu2.model.CommunicationRequest;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.Identifier;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.CommunicationRequest;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Reference;

public class CommunicationRequest10_50 {
    public static CommunicationRequest convertCommunicationRequest(org.hl7.fhir.r5.model.CommunicationRequest src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CommunicationRequest tgt = new CommunicationRequest();
        VersionConvertor_10_50.copyDomainResource(src, tgt, new String[0]);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_50.convertIdentifier(identifier));
        }
        if (src.hasCategory()) {
            tgt.setCategory(VersionConvertor_10_50.convertCodeableConcept(src.getCategoryFirstRep()));
        }
        if (src.hasInformationProvider()) {
            tgt.setSender(VersionConvertor_10_50.convertReference(src.getInformationProviderFirstRep()));
        }
        for (Reference reference : src.getRecipient()) {
            tgt.addRecipient(VersionConvertor_10_50.convertReference(reference));
        }
        for (CommunicationRequest.CommunicationRequestPayloadComponent communicationRequestPayloadComponent : src.getPayload()) {
            tgt.addPayload(CommunicationRequest10_50.convertCommunicationRequestPayloadComponent(communicationRequestPayloadComponent));
        }
        for (CodeableConcept codeableConcept : src.getMedium()) {
            tgt.addMedium(VersionConvertor_10_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasRequester()) {
            tgt.setRequester(VersionConvertor_10_50.convertReference(src.getRequester()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(CommunicationRequest10_50.convertCommunicationRequestStatus(src.getStatusElement()));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(VersionConvertor_10_50.convertReference(src.getEncounter()));
        }
        if (src.hasOccurrence()) {
            tgt.setScheduled(VersionConvertor_10_50.convertType(src.getOccurrence()));
        }
        for (CodeableReference codeableReference : src.getReason()) {
            if (!codeableReference.hasConcept()) continue;
            tgt.addReason(VersionConvertor_10_50.convertCodeableConcept(codeableReference.getConcept()));
        }
        if (src.hasAuthoredOnElement()) {
            tgt.setRequestedOnElement(VersionConvertor_10_50.convertDateTime(src.getAuthoredOnElement()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_10_50.convertReference(src.getSubject()));
        }
        if (src.hasPriority()) {
            tgt.setPriority(CommunicationRequest10_50.convertPriorityCode(src.getPriority()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.CommunicationRequest convertCommunicationRequest(CommunicationRequest src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.CommunicationRequest tgt = new org.hl7.fhir.r5.model.CommunicationRequest();
        VersionConvertor_10_50.copyDomainResource(src, tgt, new String[0]);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_50.convertIdentifier(identifier));
        }
        if (src.hasCategory()) {
            tgt.addCategory(VersionConvertor_10_50.convertCodeableConcept(src.getCategory()));
        }
        if (src.hasSender()) {
            tgt.addInformationProvider(VersionConvertor_10_50.convertReference(src.getSender()));
        }
        for (org.hl7.fhir.dstu2.model.Reference reference : src.getRecipient()) {
            tgt.addRecipient(VersionConvertor_10_50.convertReference(reference));
        }
        for (CommunicationRequest.CommunicationRequestPayloadComponent communicationRequestPayloadComponent : src.getPayload()) {
            tgt.addPayload(CommunicationRequest10_50.convertCommunicationRequestPayloadComponent(communicationRequestPayloadComponent));
        }
        for (org.hl7.fhir.dstu2.model.CodeableConcept codeableConcept : src.getMedium()) {
            tgt.addMedium(VersionConvertor_10_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasRequester()) {
            tgt.setRequester(VersionConvertor_10_50.convertReference(src.getRequester()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(CommunicationRequest10_50.convertCommunicationRequestStatus(src.getStatusElement()));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(VersionConvertor_10_50.convertReference(src.getEncounter()));
        }
        if (src.hasScheduled()) {
            tgt.setOccurrence(VersionConvertor_10_50.convertType(src.getScheduled()));
        }
        for (org.hl7.fhir.dstu2.model.CodeableConcept codeableConcept : src.getReason()) {
            tgt.addReason(VersionConvertor_10_50.convertCodeableConceptToCodableReference(codeableConcept));
        }
        if (src.hasRequestedOnElement()) {
            tgt.setAuthoredOnElement(VersionConvertor_10_50.convertDateTime(src.getRequestedOnElement()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_10_50.convertReference(src.getSubject()));
        }
        if (src.hasPriority()) {
            tgt.setPriority(CommunicationRequest10_50.convertPriorityCode(src.getPriority()));
        }
        return tgt;
    }

    public static CommunicationRequest.CommunicationRequestPayloadComponent convertCommunicationRequestPayloadComponent(CommunicationRequest.CommunicationRequestPayloadComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CommunicationRequest.CommunicationRequestPayloadComponent tgt = new CommunicationRequest.CommunicationRequestPayloadComponent();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        if (src.hasContent()) {
            tgt.setContent(VersionConvertor_10_50.convertType(src.getContent()));
        }
        return tgt;
    }

    public static CommunicationRequest.CommunicationRequestPayloadComponent convertCommunicationRequestPayloadComponent(CommunicationRequest.CommunicationRequestPayloadComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CommunicationRequest.CommunicationRequestPayloadComponent tgt = new CommunicationRequest.CommunicationRequestPayloadComponent();
        VersionConvertor_10_50.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasContent()) {
            tgt.setContent(VersionConvertor_10_50.convertType(src.getContent()));
        }
        return tgt;
    }

    public static Enumeration<CommunicationRequest.CommunicationRequestStatus> convertCommunicationRequestStatus(org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<CommunicationRequest.CommunicationRequestStatus> tgt = new Enumeration<CommunicationRequest.CommunicationRequestStatus>(new CommunicationRequest.CommunicationRequestStatusEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.RequestStatus)((Object)src.getValue())) {
            case DRAFT: {
                tgt.setValue((Object)CommunicationRequest.CommunicationRequestStatus.PROPOSED);
                break;
            }
            case ACTIVE: {
                tgt.setValue((Object)CommunicationRequest.CommunicationRequestStatus.INPROGRESS);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)CommunicationRequest.CommunicationRequestStatus.COMPLETED);
                break;
            }
            case ONHOLD: {
                tgt.setValue((Object)CommunicationRequest.CommunicationRequestStatus.SUSPENDED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)CommunicationRequest.CommunicationRequestStatus.REJECTED);
                break;
            }
            default: {
                tgt.setValue((Object)CommunicationRequest.CommunicationRequestStatus.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestStatus> convertCommunicationRequestStatus(Enumeration<CommunicationRequest.CommunicationRequestStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestStatus> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestStatus>(new Enumerations.RequestStatusEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((CommunicationRequest.CommunicationRequestStatus)((Object)src.getValue())) {
            case PROPOSED: {
                tgt.setValue((Object)Enumerations.RequestStatus.DRAFT);
                break;
            }
            case PLANNED: {
                tgt.setValue((Object)Enumerations.RequestStatus.ACTIVE);
                break;
            }
            case REQUESTED: {
                tgt.setValue((Object)Enumerations.RequestStatus.ACTIVE);
                break;
            }
            case RECEIVED: {
                tgt.setValue((Object)Enumerations.RequestStatus.ACTIVE);
                break;
            }
            case ACCEPTED: {
                tgt.setValue((Object)Enumerations.RequestStatus.ACTIVE);
                break;
            }
            case INPROGRESS: {
                tgt.setValue((Object)Enumerations.RequestStatus.ACTIVE);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)Enumerations.RequestStatus.COMPLETED);
                break;
            }
            case SUSPENDED: {
                tgt.setValue((Object)Enumerations.RequestStatus.ONHOLD);
                break;
            }
            case REJECTED: {
                tgt.setValue((Object)Enumerations.RequestStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.RequestStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumerations.RequestPriority convertPriorityCode(org.hl7.fhir.dstu2.model.CodeableConcept priority) {
        for (Coding c : priority.getCoding()) {
            if ("http://hl7.org/fhir/diagnostic-order-priority".equals(c.getSystem()) && "routine".equals(c.getCode())) {
                return Enumerations.RequestPriority.ROUTINE;
            }
            if ("http://hl7.org/fhir/diagnostic-order-priority".equals(c.getSystem()) && "urgent".equals(c.getCode())) {
                return Enumerations.RequestPriority.URGENT;
            }
            if ("http://hl7.org/fhir/diagnostic-order-priority".equals(c.getSystem()) && "stat".equals(c.getCode())) {
                return Enumerations.RequestPriority.STAT;
            }
            if (!"http://hl7.org/fhir/diagnostic-order-priority".equals(c.getSystem()) || !"asap".equals(c.getCode())) continue;
            return Enumerations.RequestPriority.ASAP;
        }
        return null;
    }

    public static org.hl7.fhir.dstu2.model.CodeableConcept convertPriorityCode(Enumerations.RequestPriority priority) {
        org.hl7.fhir.dstu2.model.CodeableConcept cc = new org.hl7.fhir.dstu2.model.CodeableConcept();
        switch (priority) {
            case ROUTINE: {
                cc.addCoding().setSystem("http://hl7.org/fhir/diagnostic-order-priority").setCode("routine");
                break;
            }
            case URGENT: {
                cc.addCoding().setSystem("http://hl7.org/fhir/diagnostic-order-priority").setCode("urgent");
                break;
            }
            case STAT: {
                cc.addCoding().setSystem("http://hl7.org/fhir/diagnostic-order-priority").setCode("stat");
                break;
            }
            case ASAP: {
                cc.addCoding().setSystem("http://hl7.org/fhir/diagnostic-order-priority").setCode("asap");
                break;
            }
            default: {
                return null;
            }
        }
        return cc;
    }
}

