/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_50;

import org.hl7.fhir.convertors.VersionConvertor_10_50;
import org.hl7.fhir.dstu2.model.AuditEvent;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.UriType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.AuditEvent;
import org.hl7.fhir.r5.model.Base64BinaryType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;

public class AuditEvent10_50 {
    public static AuditEvent convertAuditEvent(org.hl7.fhir.r5.model.AuditEvent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        AuditEvent tgt = new AuditEvent();
        VersionConvertor_10_50.copyDomainResource(src, tgt, new String[0]);
        tgt.getEvent().setType(VersionConvertor_10_50.convertCoding(src.getType()));
        for (Coding coding : src.getSubtype()) {
            tgt.getEvent().addSubtype(VersionConvertor_10_50.convertCoding(coding));
        }
        tgt.getEvent().setActionElement(AuditEvent10_50.convertAuditEventAction(src.getActionElement()));
        tgt.getEvent().setDateTime(src.getRecorded());
        if (src.hasOutcome() && src.getOutcome().hasCoding("http://terminology.hl7.org/CodeSystem/audit-event-outcome")) {
            tgt.getEvent().getOutcomeElement().setValueAsString(src.getOutcome().getCode("http://terminology.hl7.org/CodeSystem/audit-event-outcome"));
        }
        if (src.getOutcome().hasText()) {
            tgt.getEvent().setOutcomeDescElement(VersionConvertor_10_50.convertString(src.getOutcome().getTextElement()));
        }
        for (CodeableConcept codeableConcept : src.getPurposeOfEvent()) {
            for (Coding cc : codeableConcept.getCoding()) {
                tgt.getEvent().addPurposeOfEvent(VersionConvertor_10_50.convertCoding(cc));
            }
        }
        for (AuditEvent.AuditEventAgentComponent auditEventAgentComponent : src.getAgent()) {
            tgt.addParticipant(AuditEvent10_50.convertAuditEventAgentComponent(auditEventAgentComponent));
        }
        if (src.hasSource()) {
            tgt.setSource(AuditEvent10_50.convertAuditEventSourceComponent(src.getSource()));
        }
        for (AuditEvent.AuditEventEntityComponent auditEventEntityComponent : src.getEntity()) {
            tgt.addObject(AuditEvent10_50.convertAuditEventEntityComponent(auditEventEntityComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.AuditEvent convertAuditEvent(AuditEvent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.AuditEvent tgt = new org.hl7.fhir.r5.model.AuditEvent();
        VersionConvertor_10_50.copyDomainResource(src, tgt, new String[0]);
        if (src.hasEvent()) {
            if (src.hasType(new String[0])) {
                tgt.setType(VersionConvertor_10_50.convertCoding(src.getEvent().getType()));
            }
            for (org.hl7.fhir.dstu2.model.Coding coding : src.getEvent().getSubtype()) {
                tgt.addSubtype(VersionConvertor_10_50.convertCoding(coding));
            }
            tgt.setActionElement(AuditEvent10_50.convertAuditEventAction(src.getEvent().getActionElement()));
            tgt.setRecorded(src.getEvent().getDateTime());
            if (src.getEvent().hasOutcome()) {
                tgt.getOutcome().addCoding().setSystem("http://terminology.hl7.org/CodeSystem/audit-event-outcome").setCode(src.getEvent().getOutcome().toCode());
            }
            if (src.getEvent().hasOutcomeDesc()) {
                tgt.getOutcome().setTextElement(VersionConvertor_10_50.convertString(src.getEvent().getOutcomeDescElement()));
            }
            for (org.hl7.fhir.dstu2.model.Coding coding : src.getEvent().getPurposeOfEvent()) {
                tgt.addPurposeOfEvent().addCoding(VersionConvertor_10_50.convertCoding(coding));
            }
        }
        for (AuditEvent.AuditEventParticipantComponent auditEventParticipantComponent : src.getParticipant()) {
            tgt.addAgent(AuditEvent10_50.convertAuditEventAgentComponent(auditEventParticipantComponent));
        }
        if (src.hasSource()) {
            tgt.setSource(AuditEvent10_50.convertAuditEventSourceComponent(src.getSource()));
        }
        for (AuditEvent.AuditEventObjectComponent auditEventObjectComponent : src.getObject()) {
            tgt.addEntity(AuditEvent10_50.convertAuditEventEntityComponent(auditEventObjectComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<AuditEvent.AuditEventAction> convertAuditEventAction(Enumeration<AuditEvent.AuditEventAction> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<AuditEvent.AuditEventAction> tgt = new org.hl7.fhir.r5.model.Enumeration<AuditEvent.AuditEventAction>(new AuditEvent.AuditEventActionEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((AuditEvent.AuditEventAction)((Object)src.getValue())) {
            case C: {
                tgt.setValue((Object)AuditEvent.AuditEventAction.C);
                break;
            }
            case R: {
                tgt.setValue((Object)AuditEvent.AuditEventAction.R);
                break;
            }
            case U: {
                tgt.setValue((Object)AuditEvent.AuditEventAction.U);
                break;
            }
            case D: {
                tgt.setValue((Object)AuditEvent.AuditEventAction.D);
                break;
            }
            case E: {
                tgt.setValue((Object)AuditEvent.AuditEventAction.E);
                break;
            }
            default: {
                tgt.setValue((Object)AuditEvent.AuditEventAction.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<AuditEvent.AuditEventAction> convertAuditEventAction(org.hl7.fhir.r5.model.Enumeration<AuditEvent.AuditEventAction> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<AuditEvent.AuditEventAction> tgt = new Enumeration<AuditEvent.AuditEventAction>(new AuditEvent.AuditEventActionEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((AuditEvent.AuditEventAction)((Object)src.getValue())) {
            case C: {
                tgt.setValue((Object)AuditEvent.AuditEventAction.C);
                break;
            }
            case R: {
                tgt.setValue((Object)AuditEvent.AuditEventAction.R);
                break;
            }
            case U: {
                tgt.setValue((Object)AuditEvent.AuditEventAction.U);
                break;
            }
            case D: {
                tgt.setValue((Object)AuditEvent.AuditEventAction.D);
                break;
            }
            case E: {
                tgt.setValue((Object)AuditEvent.AuditEventAction.E);
                break;
            }
            default: {
                tgt.setValue((Object)AuditEvent.AuditEventAction.NULL);
            }
        }
        return tgt;
    }

    public static AuditEvent.AuditEventParticipantComponent convertAuditEventAgentComponent(AuditEvent.AuditEventAgentComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        AuditEvent.AuditEventParticipantComponent tgt = new AuditEvent.AuditEventParticipantComponent();
        VersionConvertor_10_50.copyElement(src, (Element)tgt, new String[0]);
        for (CodeableConcept codeableConcept : src.getRole()) {
            tgt.addRole(VersionConvertor_10_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasWho()) {
            if (src.getWho().hasIdentifier()) {
                tgt.setUserId(VersionConvertor_10_50.convertIdentifier(src.getWho().getIdentifier()));
            }
            if (src.getWho().hasReference() || src.getWho().hasDisplay() || src.getWho().hasExtension() || src.getWho().hasId()) {
                tgt.setReference(VersionConvertor_10_50.convertReference(src.getWho()));
            }
        }
        if (src.hasAltIdElement()) {
            tgt.setAltIdElement(VersionConvertor_10_50.convertString(src.getAltIdElement()));
        }
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_50.convertString(src.getNameElement()));
        }
        if (src.hasRequestorElement()) {
            tgt.setRequestorElement(VersionConvertor_10_50.convertBoolean(src.getRequestorElement()));
        }
        if (src.hasLocation()) {
            tgt.setLocation(VersionConvertor_10_50.convertReference(src.getLocation()));
        }
        for (org.hl7.fhir.r5.model.UriType uriType : src.getPolicy()) {
            tgt.addPolicy((String)uriType.getValue());
        }
        if (src.hasMedia()) {
            tgt.setMedia(VersionConvertor_10_50.convertCoding(src.getMedia()));
        }
        if (src.hasNetwork()) {
            tgt.setNetwork(AuditEvent10_50.convertAuditEventAgentNetworkComponent(src.getNetwork()));
        }
        for (CodeableConcept codeableConcept : src.getPurposeOfUse()) {
            for (Coding cc : codeableConcept.getCoding()) {
                tgt.addPurposeOfUse(VersionConvertor_10_50.convertCoding(cc));
            }
        }
        return tgt;
    }

    public static AuditEvent.AuditEventAgentComponent convertAuditEventAgentComponent(AuditEvent.AuditEventParticipantComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        AuditEvent.AuditEventAgentComponent tgt = new AuditEvent.AuditEventAgentComponent();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        for (org.hl7.fhir.dstu2.model.CodeableConcept codeableConcept : src.getRole()) {
            tgt.addRole(VersionConvertor_10_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasReference()) {
            tgt.setWho(VersionConvertor_10_50.convertReference(src.getReference()));
        }
        if (src.hasUserId()) {
            tgt.getWho().setIdentifier(VersionConvertor_10_50.convertIdentifier(src.getUserId()));
        }
        if (src.hasAltIdElement()) {
            tgt.setAltIdElement(VersionConvertor_10_50.convertString(src.getAltIdElement()));
        }
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_50.convertString(src.getNameElement()));
        }
        if (src.hasRequestorElement()) {
            tgt.setRequestorElement(VersionConvertor_10_50.convertBoolean(src.getRequestorElement()));
        }
        if (src.hasLocation()) {
            tgt.setLocation(VersionConvertor_10_50.convertReference(src.getLocation()));
        }
        for (UriType uriType : src.getPolicy()) {
            tgt.addPolicy((String)uriType.getValue());
        }
        if (src.hasMedia()) {
            tgt.setMedia(VersionConvertor_10_50.convertCoding(src.getMedia()));
        }
        if (src.hasNetwork()) {
            tgt.setNetwork(AuditEvent10_50.convertAuditEventAgentNetworkComponent(src.getNetwork()));
        }
        for (org.hl7.fhir.dstu2.model.Coding coding : src.getPurposeOfUse()) {
            tgt.addPurposeOfUse().addCoding(VersionConvertor_10_50.convertCoding(coding));
        }
        return tgt;
    }

    public static AuditEvent.AuditEventAgentNetworkComponent convertAuditEventAgentNetworkComponent(AuditEvent.AuditEventParticipantNetworkComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        AuditEvent.AuditEventAgentNetworkComponent tgt = new AuditEvent.AuditEventAgentNetworkComponent();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        if (src.hasAddressElement()) {
            tgt.setAddressElement(VersionConvertor_10_50.convertString(src.getAddressElement()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(AuditEvent10_50.convertAuditEventParticipantNetworkType(src.getTypeElement()));
        }
        return tgt;
    }

    public static AuditEvent.AuditEventParticipantNetworkComponent convertAuditEventAgentNetworkComponent(AuditEvent.AuditEventAgentNetworkComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        AuditEvent.AuditEventParticipantNetworkComponent tgt = new AuditEvent.AuditEventParticipantNetworkComponent();
        VersionConvertor_10_50.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasAddressElement()) {
            tgt.setAddressElement(VersionConvertor_10_50.convertString(src.getAddressElement()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(AuditEvent10_50.convertAuditEventParticipantNetworkType(src.getTypeElement()));
        }
        return tgt;
    }

    public static AuditEvent.AuditEventEntityComponent convertAuditEventEntityComponent(AuditEvent.AuditEventObjectComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        AuditEvent.AuditEventEntityComponent tgt = new AuditEvent.AuditEventEntityComponent();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        if (src.hasIdentifier()) {
            tgt.getWhat().setIdentifier(VersionConvertor_10_50.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasReference()) {
            tgt.setWhat(VersionConvertor_10_50.convertReference(src.getReference()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_10_50.convertCoding(src.getType()));
        }
        if (src.hasRole()) {
            tgt.setRole(VersionConvertor_10_50.convertCoding(src.getRole()));
        }
        if (src.hasLifecycle()) {
            tgt.setLifecycle(VersionConvertor_10_50.convertCoding(src.getLifecycle()));
        }
        for (org.hl7.fhir.dstu2.model.Coding coding : src.getSecurityLabel()) {
            tgt.addSecurityLabel(VersionConvertor_10_50.convertCoding(coding));
        }
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_50.convertString(src.getNameElement()));
        }
        if (src.hasQueryElement()) {
            tgt.setQueryElement(VersionConvertor_10_50.convertBase64Binary(src.getQueryElement()));
        }
        for (AuditEvent.AuditEventObjectDetailComponent auditEventObjectDetailComponent : src.getDetail()) {
            tgt.addDetail(AuditEvent10_50.convertAuditEventEntityDetailComponent(auditEventObjectDetailComponent));
        }
        return tgt;
    }

    public static AuditEvent.AuditEventObjectComponent convertAuditEventEntityComponent(AuditEvent.AuditEventEntityComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        AuditEvent.AuditEventObjectComponent tgt = new AuditEvent.AuditEventObjectComponent();
        VersionConvertor_10_50.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasWhat()) {
            if (src.getWhat().hasIdentifier()) {
                tgt.setIdentifier(VersionConvertor_10_50.convertIdentifier(src.getWhat().getIdentifier()));
            }
            if (src.getWhat().hasReference() || src.getWhat().hasDisplay() || src.getWhat().hasExtension() || src.getWhat().hasId()) {
                tgt.setReference(VersionConvertor_10_50.convertReference(src.getWhat()));
            }
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_10_50.convertCoding(src.getType()));
        }
        if (src.hasRole()) {
            tgt.setRole(VersionConvertor_10_50.convertCoding(src.getRole()));
        }
        if (src.hasLifecycle()) {
            tgt.setLifecycle(VersionConvertor_10_50.convertCoding(src.getLifecycle()));
        }
        for (Coding coding : src.getSecurityLabel()) {
            tgt.addSecurityLabel(VersionConvertor_10_50.convertCoding(coding));
        }
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_50.convertString(src.getNameElement()));
        }
        if (src.hasQueryElement()) {
            tgt.setQueryElement(VersionConvertor_10_50.convertBase64Binary(src.getQueryElement()));
        }
        for (AuditEvent.AuditEventEntityDetailComponent auditEventEntityDetailComponent : src.getDetail()) {
            tgt.addDetail(AuditEvent10_50.convertAuditEventEntityDetailComponent(auditEventEntityDetailComponent));
        }
        return tgt;
    }

    public static AuditEvent.AuditEventEntityDetailComponent convertAuditEventEntityDetailComponent(AuditEvent.AuditEventObjectDetailComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        AuditEvent.AuditEventEntityDetailComponent tgt = new AuditEvent.AuditEventEntityDetailComponent();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        if (src.hasTypeElement()) {
            tgt.setTypeElement(VersionConvertor_10_50.convertString(src.getTypeElement()));
        }
        if (src.hasValue()) {
            tgt.setValue(new Base64BinaryType(src.getValue()));
        }
        return tgt;
    }

    public static AuditEvent.AuditEventObjectDetailComponent convertAuditEventEntityDetailComponent(AuditEvent.AuditEventEntityDetailComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        AuditEvent.AuditEventObjectDetailComponent tgt = new AuditEvent.AuditEventObjectDetailComponent();
        VersionConvertor_10_50.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasTypeElement()) {
            tgt.setTypeElement(VersionConvertor_10_50.convertString(src.getTypeElement()));
        }
        if (src.hasValueStringType()) {
            tgt.setValue(((String)src.getValueStringType().getValue()).getBytes());
        } else if (src.hasValueBase64BinaryType()) {
            tgt.setValue(src.getValueBase64BinaryType().getValue());
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<AuditEvent.AuditEventAgentNetworkType> convertAuditEventParticipantNetworkType(Enumeration<AuditEvent.AuditEventParticipantNetworkType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<AuditEvent.AuditEventAgentNetworkType> tgt = new org.hl7.fhir.r5.model.Enumeration<AuditEvent.AuditEventAgentNetworkType>(new AuditEvent.AuditEventAgentNetworkTypeEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((AuditEvent.AuditEventParticipantNetworkType)((Object)src.getValue())) {
            case _1: {
                tgt.setValue((Object)AuditEvent.AuditEventAgentNetworkType._1);
                break;
            }
            case _2: {
                tgt.setValue((Object)AuditEvent.AuditEventAgentNetworkType._2);
                break;
            }
            case _3: {
                tgt.setValue((Object)AuditEvent.AuditEventAgentNetworkType._3);
                break;
            }
            case _4: {
                tgt.setValue((Object)AuditEvent.AuditEventAgentNetworkType._4);
                break;
            }
            case _5: {
                tgt.setValue((Object)AuditEvent.AuditEventAgentNetworkType._5);
                break;
            }
            default: {
                tgt.setValue((Object)AuditEvent.AuditEventAgentNetworkType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<AuditEvent.AuditEventParticipantNetworkType> convertAuditEventParticipantNetworkType(org.hl7.fhir.r5.model.Enumeration<AuditEvent.AuditEventAgentNetworkType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<AuditEvent.AuditEventParticipantNetworkType> tgt = new Enumeration<AuditEvent.AuditEventParticipantNetworkType>(new AuditEvent.AuditEventParticipantNetworkTypeEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((AuditEvent.AuditEventAgentNetworkType)((Object)src.getValue())) {
            case _1: {
                tgt.setValue((Object)AuditEvent.AuditEventParticipantNetworkType._1);
                break;
            }
            case _2: {
                tgt.setValue((Object)AuditEvent.AuditEventParticipantNetworkType._2);
                break;
            }
            case _3: {
                tgt.setValue((Object)AuditEvent.AuditEventParticipantNetworkType._3);
                break;
            }
            case _4: {
                tgt.setValue((Object)AuditEvent.AuditEventParticipantNetworkType._4);
                break;
            }
            case _5: {
                tgt.setValue((Object)AuditEvent.AuditEventParticipantNetworkType._5);
                break;
            }
            default: {
                tgt.setValue((Object)AuditEvent.AuditEventParticipantNetworkType.NULL);
            }
        }
        return tgt;
    }

    public static AuditEvent.AuditEventSourceComponent convertAuditEventSourceComponent(AuditEvent.AuditEventSourceComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        AuditEvent.AuditEventSourceComponent tgt = new AuditEvent.AuditEventSourceComponent();
        VersionConvertor_10_50.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasSiteElement()) {
            tgt.setSiteElement(VersionConvertor_10_50.convertString(src.getSiteElement()));
        }
        if (src.hasObserver()) {
            tgt.setIdentifier(VersionConvertor_10_50.convertIdentifier(src.getObserver().getIdentifier()));
        }
        for (Coding t : src.getType()) {
            tgt.addType(VersionConvertor_10_50.convertCoding(t));
        }
        return tgt;
    }

    public static AuditEvent.AuditEventSourceComponent convertAuditEventSourceComponent(AuditEvent.AuditEventSourceComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        AuditEvent.AuditEventSourceComponent tgt = new AuditEvent.AuditEventSourceComponent();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        if (src.hasSiteElement()) {
            tgt.setSiteElement(VersionConvertor_10_50.convertString(src.getSiteElement()));
        }
        if (src.hasIdentifier()) {
            tgt.getObserver().setIdentifier(VersionConvertor_10_50.convertIdentifier(src.getIdentifier()));
        }
        for (org.hl7.fhir.dstu2.model.Coding t : src.getType()) {
            tgt.addType(VersionConvertor_10_50.convertCoding(t));
        }
        return tgt;
    }
}

