/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_40;

import java.util.List;
import org.hl7.fhir.convertors.VersionConvertorAdvisor40;
import org.hl7.fhir.convertors.VersionConvertor_10_40;
import org.hl7.fhir.dstu2.model.CodeableConcept;
import org.hl7.fhir.dstu2.model.ContactPoint;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.UriType;
import org.hl7.fhir.dstu2.model.ValueSet;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.CodeSystem;
import org.hl7.fhir.r4.model.ContactDetail;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.UsageContext;
import org.hl7.fhir.r4.model.ValueSet;
import org.hl7.fhir.r4.terminologies.CodeSystemUtilities;

public class ValueSet10_40 {
    public static ValueSet.ConceptReferenceComponent convertConceptReferenceComponent(ValueSet.ConceptReferenceComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet.ConceptReferenceComponent tgt = new ValueSet.ConceptReferenceComponent();
        VersionConvertor_10_40.copyElement(src, tgt);
        if (src.hasCodeElement()) {
            tgt.setCodeElement(VersionConvertor_10_40.convertCode(src.getCodeElement()));
        }
        if (src.hasDisplayElement()) {
            tgt.setDisplayElement(VersionConvertor_10_40.convertString(src.getDisplayElement()));
        }
        for (ValueSet.ConceptDefinitionDesignationComponent t : src.getDesignation()) {
            tgt.addDesignation(ValueSet10_40.convertConceptReferenceDesignationComponent(t));
        }
        return tgt;
    }

    public static ValueSet.ConceptReferenceComponent convertConceptReferenceComponent(ValueSet.ConceptReferenceComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet.ConceptReferenceComponent tgt = new ValueSet.ConceptReferenceComponent();
        VersionConvertor_10_40.copyElement(src, (Element)tgt);
        if (src.hasCodeElement()) {
            tgt.setCodeElement(VersionConvertor_10_40.convertCode(src.getCodeElement()));
        }
        if (src.hasDisplayElement()) {
            tgt.setDisplayElement(VersionConvertor_10_40.convertString(src.getDisplayElement()));
        }
        for (ValueSet.ConceptReferenceDesignationComponent t : src.getDesignation()) {
            tgt.addDesignation(ValueSet10_40.convertConceptReferenceDesignationComponent(t));
        }
        return tgt;
    }

    public static ValueSet.ConceptReferenceDesignationComponent convertConceptReferenceDesignationComponent(ValueSet.ConceptDefinitionDesignationComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet.ConceptReferenceDesignationComponent tgt = new ValueSet.ConceptReferenceDesignationComponent();
        VersionConvertor_10_40.copyElement(src, tgt);
        if (src.hasLanguageElement()) {
            tgt.setLanguageElement(VersionConvertor_10_40.convertCode(src.getLanguageElement()));
        }
        if (src.hasUse()) {
            tgt.setUse(VersionConvertor_10_40.convertCoding(src.getUse()));
        }
        if (src.hasValueElement()) {
            tgt.setValueElement(VersionConvertor_10_40.convertString(src.getValueElement()));
        }
        return tgt;
    }

    public static ValueSet.ConceptDefinitionDesignationComponent convertConceptReferenceDesignationComponent(ValueSet.ConceptReferenceDesignationComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet.ConceptDefinitionDesignationComponent tgt = new ValueSet.ConceptDefinitionDesignationComponent();
        VersionConvertor_10_40.copyElement(src, (Element)tgt);
        if (src.hasLanguageElement()) {
            tgt.setLanguageElement(VersionConvertor_10_40.convertCode(src.getLanguageElement()));
        }
        if (src.hasUse()) {
            tgt.setUse(VersionConvertor_10_40.convertCoding(src.getUse()));
        }
        if (src.hasValueElement()) {
            tgt.setValueElement(VersionConvertor_10_40.convertString(src.getValueElement()));
        }
        return tgt;
    }

    public static ValueSet.ConceptSetComponent convertConceptSetComponent(ValueSet.ConceptSetComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet.ConceptSetComponent tgt = new ValueSet.ConceptSetComponent();
        VersionConvertor_10_40.copyElement(src, tgt);
        if (src.hasSystemElement()) {
            tgt.setSystemElement(VersionConvertor_10_40.convertUri(src.getSystemElement()));
        }
        if (src.hasVersionElement()) {
            tgt.setVersionElement(VersionConvertor_10_40.convertString(src.getVersionElement()));
        }
        for (ValueSet.ConceptReferenceComponent conceptReferenceComponent : src.getConcept()) {
            tgt.addConcept(ValueSet10_40.convertConceptReferenceComponent(conceptReferenceComponent));
        }
        for (ValueSet.ConceptSetFilterComponent conceptSetFilterComponent : src.getFilter()) {
            tgt.addFilter(ValueSet10_40.convertConceptSetFilterComponent(conceptSetFilterComponent));
        }
        return tgt;
    }

    public static ValueSet.ConceptSetComponent convertConceptSetComponent(ValueSet.ConceptSetComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet.ConceptSetComponent tgt = new ValueSet.ConceptSetComponent();
        VersionConvertor_10_40.copyElement(src, (Element)tgt);
        if (src.hasSystemElement()) {
            tgt.setSystemElement(VersionConvertor_10_40.convertUri(src.getSystemElement()));
        }
        if (src.hasVersionElement()) {
            tgt.setVersionElement(VersionConvertor_10_40.convertString(src.getVersionElement()));
        }
        for (ValueSet.ConceptReferenceComponent conceptReferenceComponent : src.getConcept()) {
            tgt.addConcept(ValueSet10_40.convertConceptReferenceComponent(conceptReferenceComponent));
        }
        for (ValueSet.ConceptSetFilterComponent conceptSetFilterComponent : src.getFilter()) {
            tgt.addFilter(ValueSet10_40.convertConceptSetFilterComponent(conceptSetFilterComponent));
        }
        return tgt;
    }

    public static ValueSet.ConceptSetFilterComponent convertConceptSetFilterComponent(ValueSet.ConceptSetFilterComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet.ConceptSetFilterComponent tgt = new ValueSet.ConceptSetFilterComponent();
        VersionConvertor_10_40.copyElement(src, (Element)tgt);
        if (src.hasPropertyElement()) {
            tgt.setPropertyElement(VersionConvertor_10_40.convertCode(src.getPropertyElement()));
        }
        if (src.hasOp()) {
            tgt.setOpElement(ValueSet10_40.convertFilterOperator(src.getOpElement()));
        }
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        return tgt;
    }

    public static ValueSet.ConceptSetFilterComponent convertConceptSetFilterComponent(ValueSet.ConceptSetFilterComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet.ConceptSetFilterComponent tgt = new ValueSet.ConceptSetFilterComponent();
        VersionConvertor_10_40.copyElement(src, tgt);
        if (src.hasPropertyElement()) {
            tgt.setPropertyElement(VersionConvertor_10_40.convertCode(src.getPropertyElement()));
        }
        if (src.hasOp()) {
            tgt.setOpElement(ValueSet10_40.convertFilterOperator(src.getOpElement()));
        }
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        return tgt;
    }

    public static Enumeration<ValueSet.FilterOperator> convertFilterOperator(org.hl7.fhir.dstu2.model.Enumeration<ValueSet.FilterOperator> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ValueSet.FilterOperator> tgt = new Enumeration<ValueSet.FilterOperator>(new ValueSet.FilterOperatorEnumFactory());
        VersionConvertor_10_40.copyElement(src, tgt);
        switch ((ValueSet.FilterOperator)((Object)src.getValue())) {
            case EQUAL: {
                tgt.setValue((Object)ValueSet.FilterOperator.EQUAL);
                break;
            }
            case ISA: {
                tgt.setValue((Object)ValueSet.FilterOperator.ISA);
                break;
            }
            case ISNOTA: {
                tgt.setValue((Object)ValueSet.FilterOperator.ISNOTA);
                break;
            }
            case REGEX: {
                tgt.setValue((Object)ValueSet.FilterOperator.REGEX);
                break;
            }
            case IN: {
                tgt.setValue((Object)ValueSet.FilterOperator.IN);
                break;
            }
            case NOTIN: {
                tgt.setValue((Object)ValueSet.FilterOperator.NOTIN);
                break;
            }
            default: {
                tgt.setValue((Object)ValueSet.FilterOperator.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.Enumeration<ValueSet.FilterOperator> convertFilterOperator(Enumeration<ValueSet.FilterOperator> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.Enumeration<ValueSet.FilterOperator> tgt = new org.hl7.fhir.dstu2.model.Enumeration<ValueSet.FilterOperator>(new ValueSet.FilterOperatorEnumFactory());
        VersionConvertor_10_40.copyElement(src, tgt);
        switch ((ValueSet.FilterOperator)((Object)src.getValue())) {
            case EQUAL: {
                tgt.setValue((Object)ValueSet.FilterOperator.EQUAL);
                break;
            }
            case ISA: {
                tgt.setValue((Object)ValueSet.FilterOperator.ISA);
                break;
            }
            case ISNOTA: {
                tgt.setValue((Object)ValueSet.FilterOperator.ISNOTA);
                break;
            }
            case REGEX: {
                tgt.setValue((Object)ValueSet.FilterOperator.REGEX);
                break;
            }
            case IN: {
                tgt.setValue((Object)ValueSet.FilterOperator.IN);
                break;
            }
            case NOTIN: {
                tgt.setValue((Object)ValueSet.FilterOperator.NOTIN);
                break;
            }
            default: {
                tgt.setValue((Object)ValueSet.FilterOperator.NULL);
            }
        }
        return tgt;
    }

    public static ValueSet convertValueSet(org.hl7.fhir.dstu2.model.ValueSet src) throws FHIRException {
        return ValueSet10_40.convertValueSet(src, null);
    }

    public static ValueSet convertValueSet(org.hl7.fhir.dstu2.model.ValueSet src, VersionConvertorAdvisor40 advisor) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet tgt = new ValueSet();
        VersionConvertor_10_40.copyDomainResource(src, tgt, new String[0]);
        if (src.hasUrlElement()) {
            tgt.setUrlElement(VersionConvertor_10_40.convertUri(src.getUrlElement()));
        }
        if (src.hasIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_40.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasVersionElement()) {
            tgt.setVersionElement(VersionConvertor_10_40.convertString(src.getVersionElement()));
        }
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_40.convertString(src.getNameElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((Enumeration)VersionConvertor_10_40.convertConformanceResourceStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_10_40.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasPublisherElement()) {
            tgt.setPublisherElement(VersionConvertor_10_40.convertString(src.getPublisherElement()));
        }
        for (ValueSet.ValueSetContactComponent valueSetContactComponent : src.getContact()) {
            tgt.addContact(ValueSet10_40.convertValueSetContactComponent(valueSetContactComponent));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_10_40.convertDateTime(src.getDateElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (CodeableConcept codeableConcept : src.getUseContext()) {
            if (VersionConvertor_10_40.isJurisdiction(codeableConcept)) {
                tgt.addJurisdiction(VersionConvertor_10_40.convertCodeableConcept(codeableConcept));
                continue;
            }
            tgt.addUseContext(VersionConvertor_10_40.convertCodeableConceptToUsageContext(codeableConcept));
        }
        if (src.hasImmutableElement()) {
            tgt.setImmutableElement(VersionConvertor_10_40.convertBoolean(src.getImmutableElement()));
        }
        if (src.hasRequirements()) {
            tgt.setPurpose(src.getRequirements());
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        if (src.hasExtensible()) {
            tgt.addExtension("http://hl7.org/fhir/StructureDefinition/valueset-extensible", new BooleanType(src.getExtensible()));
        }
        if (src.hasCompose()) {
            if (src.hasCompose()) {
                tgt.setCompose(ValueSet10_40.convertValueSetComposeComponent(src.getCompose()));
            }
            tgt.getCompose().setLockedDate(src.getLockedDate());
        }
        if (src.hasCodeSystem() && advisor != null) {
            CodeSystem tgtcs = new CodeSystem();
            VersionConvertor_10_40.copyDomainResource(src, tgtcs, new String[0]);
            tgtcs.setUrl(src.getCodeSystem().getSystem());
            tgtcs.addIdentifier(VersionConvertor_10_40.convertIdentifier(src.getIdentifier()));
            tgtcs.setVersion(src.getCodeSystem().getVersion());
            tgtcs.setName(src.getName() + " Code System");
            tgtcs.setStatusElement((Enumeration)VersionConvertor_10_40.convertConformanceResourceStatus(src.getStatusElement()));
            if (src.hasExperimental()) {
                tgtcs.setExperimental(src.getExperimental());
            }
            tgtcs.setPublisher(src.getPublisher());
            for (ValueSet.ValueSetContactComponent valueSetContactComponent : src.getContact()) {
                tgtcs.addContact(ValueSet10_40.convertValueSetContactComponent(valueSetContactComponent));
            }
            if (src.hasDate()) {
                tgtcs.setDate(src.getDate());
            }
            tgtcs.setDescription(src.getDescription());
            for (CodeableConcept codeableConcept : src.getUseContext()) {
                if (VersionConvertor_10_40.isJurisdiction(codeableConcept)) {
                    tgtcs.addJurisdiction(VersionConvertor_10_40.convertCodeableConcept(codeableConcept));
                    continue;
                }
                tgtcs.addUseContext(VersionConvertor_10_40.convertCodeableConceptToUsageContext(codeableConcept));
            }
            tgtcs.setPurpose(src.getRequirements());
            tgtcs.setCopyright(src.getCopyright());
            tgtcs.setContent(CodeSystem.CodeSystemContentMode.COMPLETE);
            tgtcs.setCaseSensitive(src.getCodeSystem().getCaseSensitive());
            for (ValueSet.ConceptDefinitionComponent conceptDefinitionComponent : src.getCodeSystem().getConcept()) {
                ValueSet10_40.processConcept(tgtcs.getConcept(), conceptDefinitionComponent, tgtcs);
            }
            advisor.handleCodeSystem(tgtcs, tgt);
            tgt.setUserData("r2-cs", tgtcs);
            tgt.getCompose().addInclude().setSystem(tgtcs.getUrl());
        }
        if (src.hasExpansion()) {
            tgt.setExpansion(ValueSet10_40.convertValueSetExpansionComponent(src.getExpansion()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.ValueSet convertValueSet(ValueSet src, VersionConvertorAdvisor40 advisor) throws FHIRException {
        CodeSystem srcCS;
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.ValueSet tgt = new org.hl7.fhir.dstu2.model.ValueSet();
        VersionConvertor_10_40.copyDomainResource(src, tgt, new String[0]);
        if (src.hasUrlElement()) {
            tgt.setUrlElement(VersionConvertor_10_40.convertUri(src.getUrlElement()));
        }
        for (Identifier identifier : src.getIdentifier()) {
            tgt.setIdentifier(VersionConvertor_10_40.convertIdentifier(identifier));
        }
        if (src.hasVersionElement()) {
            tgt.setVersionElement(VersionConvertor_10_40.convertString(src.getVersionElement()));
        }
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_40.convertString(src.getNameElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(VersionConvertor_10_40.convertConformanceResourceStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_10_40.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasPublisherElement()) {
            tgt.setPublisherElement(VersionConvertor_10_40.convertString(src.getPublisherElement()));
        }
        for (ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(ValueSet10_40.convertValueSetContactComponent(contactDetail));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_10_40.convertDateTime(src.getDateElement()));
        }
        tgt.setLockedDate(src.getCompose().getLockedDate());
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (UsageContext usageContext : src.getUseContext()) {
            if (!usageContext.hasValueCodeableConcept()) continue;
            tgt.addUseContext(VersionConvertor_10_40.convertCodeableConcept(usageContext.getValueCodeableConcept()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addUseContext(VersionConvertor_10_40.convertCodeableConcept(codeableConcept));
        }
        if (src.hasImmutableElement()) {
            tgt.setImmutableElement(VersionConvertor_10_40.convertBoolean(src.getImmutableElement()));
        }
        if (src.hasPurpose()) {
            tgt.setRequirements(src.getPurpose());
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        if (src.hasExtension("http://hl7.org/fhir/StructureDefinition/valueset-extensible")) {
            tgt.setExtensible(((BooleanType)src.getExtensionByUrl("http://hl7.org/fhir/StructureDefinition/valueset-extensible").getValue()).booleanValue());
        }
        if ((srcCS = (CodeSystem)src.getUserData("r2-cs")) == null) {
            srcCS = advisor.getCodeSystem(src);
        }
        if (srcCS != null) {
            tgt.getCodeSystem().setSystem(srcCS.getUrl());
            tgt.getCodeSystem().setVersion(srcCS.getVersion());
            tgt.getCodeSystem().setCaseSensitive(srcCS.getCaseSensitive());
            for (CodeSystem.ConceptDefinitionComponent cs : srcCS.getConcept()) {
                ValueSet10_40.processConcept(tgt.getCodeSystem().getConcept(), cs, srcCS);
            }
        }
        if (src.hasCompose()) {
            tgt.setCompose(ValueSet10_40.convertValueSetComposeComponent(src.getCompose(), srcCS == null ? null : srcCS.getUrl()));
        }
        if (src.hasExpansion()) {
            tgt.setExpansion(ValueSet10_40.convertValueSetExpansionComponent(src.getExpansion()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.ValueSet convertValueSet(ValueSet src) throws FHIRException {
        return ValueSet10_40.convertValueSet(src, null);
    }

    public static ValueSet.ValueSetComposeComponent convertValueSetComposeComponent(ValueSet.ValueSetComposeComponent src, String noSystem) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet.ValueSetComposeComponent tgt = new ValueSet.ValueSetComposeComponent();
        VersionConvertor_10_40.copyElement(src, (Element)tgt);
        for (ValueSet.ConceptSetComponent t : src.getInclude()) {
            for (org.hl7.fhir.r4.model.UriType uriType : t.getValueSet()) {
                tgt.addImport((String)uriType.getValue());
            }
            if (noSystem != null && t.getSystem().equals(noSystem)) continue;
            tgt.addInclude(ValueSet10_40.convertConceptSetComponent(t));
        }
        for (ValueSet.ConceptSetComponent t : src.getExclude()) {
            tgt.addExclude(ValueSet10_40.convertConceptSetComponent(t));
        }
        return tgt;
    }

    public static ValueSet.ValueSetComposeComponent convertValueSetComposeComponent(ValueSet.ValueSetComposeComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet.ValueSetComposeComponent tgt = new ValueSet.ValueSetComposeComponent();
        VersionConvertor_10_40.copyElement(src, tgt);
        for (UriType uriType : src.getImport()) {
            tgt.addInclude().addValueSet((String)uriType.getValue());
        }
        for (ValueSet.ConceptSetComponent conceptSetComponent : src.getInclude()) {
            tgt.addInclude(ValueSet10_40.convertConceptSetComponent(conceptSetComponent));
        }
        for (ValueSet.ConceptSetComponent conceptSetComponent : src.getExclude()) {
            tgt.addExclude(ValueSet10_40.convertConceptSetComponent(conceptSetComponent));
        }
        return tgt;
    }

    public static ContactDetail convertValueSetContactComponent(ValueSet.ValueSetContactComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ContactDetail tgt = new ContactDetail();
        VersionConvertor_10_40.copyElement(src, tgt);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_40.convertString(src.getNameElement()));
        }
        for (ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_10_40.convertContactPoint(t));
        }
        return tgt;
    }

    public static ValueSet.ValueSetContactComponent convertValueSetContactComponent(ContactDetail src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet.ValueSetContactComponent tgt = new ValueSet.ValueSetContactComponent();
        VersionConvertor_10_40.copyElement(src, (Element)tgt);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_40.convertString(src.getNameElement()));
        }
        for (org.hl7.fhir.r4.model.ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_10_40.convertContactPoint(t));
        }
        return tgt;
    }

    public static ValueSet.ValueSetExpansionComponent convertValueSetExpansionComponent(ValueSet.ValueSetExpansionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet.ValueSetExpansionComponent tgt = new ValueSet.ValueSetExpansionComponent();
        VersionConvertor_10_40.copyElement(src, (Element)tgt);
        if (src.hasIdentifierElement()) {
            tgt.setIdentifierElement(VersionConvertor_10_40.convertUri(src.getIdentifierElement()));
        }
        if (src.hasTimestampElement()) {
            tgt.setTimestampElement(VersionConvertor_10_40.convertDateTime(src.getTimestampElement()));
        }
        if (src.hasTotalElement()) {
            tgt.setTotalElement(VersionConvertor_10_40.convertInteger(src.getTotalElement()));
        }
        if (src.hasOffsetElement()) {
            tgt.setOffsetElement(VersionConvertor_10_40.convertInteger(src.getOffsetElement()));
        }
        for (ValueSet.ValueSetExpansionParameterComponent valueSetExpansionParameterComponent : src.getParameter()) {
            tgt.addParameter(ValueSet10_40.convertValueSetExpansionParameterComponent(valueSetExpansionParameterComponent));
        }
        for (ValueSet.ValueSetExpansionContainsComponent valueSetExpansionContainsComponent : src.getContains()) {
            tgt.addContains(ValueSet10_40.convertValueSetExpansionContainsComponent(valueSetExpansionContainsComponent));
        }
        return tgt;
    }

    public static ValueSet.ValueSetExpansionComponent convertValueSetExpansionComponent(ValueSet.ValueSetExpansionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet.ValueSetExpansionComponent tgt = new ValueSet.ValueSetExpansionComponent();
        VersionConvertor_10_40.copyElement(src, tgt);
        if (src.hasIdentifierElement()) {
            tgt.setIdentifierElement(VersionConvertor_10_40.convertUri(src.getIdentifierElement()));
        }
        if (src.hasTimestampElement()) {
            tgt.setTimestampElement(VersionConvertor_10_40.convertDateTime(src.getTimestampElement()));
        }
        if (src.hasTotalElement()) {
            tgt.setTotalElement(VersionConvertor_10_40.convertInteger(src.getTotalElement()));
        }
        if (src.hasOffsetElement()) {
            tgt.setOffsetElement(VersionConvertor_10_40.convertInteger(src.getOffsetElement()));
        }
        for (ValueSet.ValueSetExpansionParameterComponent valueSetExpansionParameterComponent : src.getParameter()) {
            tgt.addParameter(ValueSet10_40.convertValueSetExpansionParameterComponent(valueSetExpansionParameterComponent));
        }
        for (ValueSet.ValueSetExpansionContainsComponent valueSetExpansionContainsComponent : src.getContains()) {
            tgt.addContains(ValueSet10_40.convertValueSetExpansionContainsComponent(valueSetExpansionContainsComponent));
        }
        return tgt;
    }

    public static ValueSet.ValueSetExpansionContainsComponent convertValueSetExpansionContainsComponent(ValueSet.ValueSetExpansionContainsComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet.ValueSetExpansionContainsComponent tgt = new ValueSet.ValueSetExpansionContainsComponent();
        VersionConvertor_10_40.copyElement(src, (Element)tgt);
        if (src.hasSystemElement()) {
            tgt.setSystemElement(VersionConvertor_10_40.convertUri(src.getSystemElement()));
        }
        if (src.hasAbstractElement()) {
            tgt.setAbstractElement(VersionConvertor_10_40.convertBoolean(src.getAbstractElement()));
        }
        if (src.hasVersionElement()) {
            tgt.setVersionElement(VersionConvertor_10_40.convertString(src.getVersionElement()));
        }
        if (src.hasCodeElement()) {
            tgt.setCodeElement(VersionConvertor_10_40.convertCode(src.getCodeElement()));
        }
        if (src.hasDisplayElement()) {
            tgt.setDisplayElement(VersionConvertor_10_40.convertString(src.getDisplayElement()));
        }
        for (ValueSet.ValueSetExpansionContainsComponent t : src.getContains()) {
            tgt.addContains(ValueSet10_40.convertValueSetExpansionContainsComponent(t));
        }
        return tgt;
    }

    public static ValueSet.ValueSetExpansionContainsComponent convertValueSetExpansionContainsComponent(ValueSet.ValueSetExpansionContainsComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet.ValueSetExpansionContainsComponent tgt = new ValueSet.ValueSetExpansionContainsComponent();
        VersionConvertor_10_40.copyElement(src, tgt);
        if (src.hasSystemElement()) {
            tgt.setSystemElement(VersionConvertor_10_40.convertUri(src.getSystemElement()));
        }
        if (src.hasAbstractElement()) {
            tgt.setAbstractElement(VersionConvertor_10_40.convertBoolean(src.getAbstractElement()));
        }
        if (src.hasVersionElement()) {
            tgt.setVersionElement(VersionConvertor_10_40.convertString(src.getVersionElement()));
        }
        if (src.hasCodeElement()) {
            tgt.setCodeElement(VersionConvertor_10_40.convertCode(src.getCodeElement()));
        }
        if (src.hasDisplayElement()) {
            tgt.setDisplayElement(VersionConvertor_10_40.convertString(src.getDisplayElement()));
        }
        for (ValueSet.ValueSetExpansionContainsComponent t : src.getContains()) {
            tgt.addContains(ValueSet10_40.convertValueSetExpansionContainsComponent(t));
        }
        return tgt;
    }

    public static ValueSet.ValueSetExpansionParameterComponent convertValueSetExpansionParameterComponent(ValueSet.ValueSetExpansionParameterComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet.ValueSetExpansionParameterComponent tgt = new ValueSet.ValueSetExpansionParameterComponent();
        VersionConvertor_10_40.copyElement(src, tgt);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_40.convertString(src.getNameElement()));
        }
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_10_40.convertType(src.getValue()));
        }
        return tgt;
    }

    public static ValueSet.ValueSetExpansionParameterComponent convertValueSetExpansionParameterComponent(ValueSet.ValueSetExpansionParameterComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet.ValueSetExpansionParameterComponent tgt = new ValueSet.ValueSetExpansionParameterComponent();
        VersionConvertor_10_40.copyElement(src, (Element)tgt);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_40.convertString(src.getNameElement()));
        }
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_10_40.convertType(src.getValue()));
        }
        return tgt;
    }

    public static void processConcept(List<CodeSystem.ConceptDefinitionComponent> concepts, ValueSet.ConceptDefinitionComponent cs, CodeSystem tgtcs) throws FHIRException {
        CodeSystem.ConceptDefinitionComponent ct = new CodeSystem.ConceptDefinitionComponent();
        concepts.add(ct);
        ct.setCode(cs.getCode());
        ct.setDisplay(cs.getDisplay());
        ct.setDefinition(cs.getDefinition());
        if (cs.getAbstract()) {
            CodeSystemUtilities.setNotSelectable(tgtcs, ct);
        }
        for (ValueSet.ConceptDefinitionDesignationComponent csd : cs.getDesignation()) {
            CodeSystem.ConceptDefinitionDesignationComponent cst = new CodeSystem.ConceptDefinitionDesignationComponent();
            cst.setLanguage(csd.getLanguage());
            cst.setUse(VersionConvertor_10_40.convertCoding(csd.getUse()));
            cst.setValue(csd.getValue());
        }
        for (ValueSet.ConceptDefinitionComponent csc : cs.getConcept()) {
            ValueSet10_40.processConcept(ct.getConcept(), csc, tgtcs);
        }
    }

    public static void processConcept(List<ValueSet.ConceptDefinitionComponent> concepts, CodeSystem.ConceptDefinitionComponent cs, CodeSystem srcCS) throws FHIRException {
        ValueSet.ConceptDefinitionComponent ct = new ValueSet.ConceptDefinitionComponent();
        concepts.add(ct);
        ct.setCode(cs.getCode());
        ct.setDisplay(cs.getDisplay());
        ct.setDefinition(cs.getDefinition());
        if (CodeSystemUtilities.isNotSelectable(srcCS, cs)) {
            ct.setAbstract(true);
        }
        for (CodeSystem.ConceptDefinitionDesignationComponent csd : cs.getDesignation()) {
            ValueSet.ConceptDefinitionDesignationComponent cst = new ValueSet.ConceptDefinitionDesignationComponent();
            cst.setLanguage(csd.getLanguage());
            cst.setUse(VersionConvertor_10_40.convertCoding(csd.getUse()));
            cst.setValue(csd.getValue());
        }
        for (CodeSystem.ConceptDefinitionComponent csc : cs.getConcept()) {
            ValueSet10_40.processConcept(ct.getConcept(), csc, srcCS);
        }
    }
}

