/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_30;

import org.hl7.fhir.convertors.VersionConvertor_10_30;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.Substance;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Substance;
import org.hl7.fhir.exceptions.FHIRException;

public class Substance10_30 {
    public static Substance convertSubstance(org.hl7.fhir.dstu3.model.Substance src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Substance tgt = new Substance();
        VersionConvertor_10_30.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_30.convertIdentifier(identifier));
        }
        for (CodeableConcept codeableConcept : src.getCategory()) {
            tgt.addCategory(VersionConvertor_10_30.convertCodeableConcept(codeableConcept));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_10_30.convertCodeableConcept(src.getCode()));
        }
        if (src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_10_30.convertString(src.getDescriptionElement()));
        }
        for (Substance.SubstanceInstanceComponent substanceInstanceComponent : src.getInstance()) {
            tgt.addInstance(Substance10_30.convertSubstanceInstanceComponent(substanceInstanceComponent));
        }
        for (Substance.SubstanceIngredientComponent substanceIngredientComponent : src.getIngredient()) {
            tgt.addIngredient(Substance10_30.convertSubstanceIngredientComponent(substanceIngredientComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Substance convertSubstance(Substance src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Substance tgt = new org.hl7.fhir.dstu3.model.Substance();
        VersionConvertor_10_30.copyDomainResource(src, tgt);
        for (org.hl7.fhir.dstu2.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_30.convertIdentifier(identifier));
        }
        for (org.hl7.fhir.dstu2.model.CodeableConcept codeableConcept : src.getCategory()) {
            tgt.addCategory(VersionConvertor_10_30.convertCodeableConcept(codeableConcept));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_10_30.convertCodeableConcept(src.getCode()));
        }
        if (src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_10_30.convertString(src.getDescriptionElement()));
        }
        for (Substance.SubstanceInstanceComponent substanceInstanceComponent : src.getInstance()) {
            tgt.addInstance(Substance10_30.convertSubstanceInstanceComponent(substanceInstanceComponent));
        }
        for (Substance.SubstanceIngredientComponent substanceIngredientComponent : src.getIngredient()) {
            tgt.addIngredient(Substance10_30.convertSubstanceIngredientComponent(substanceIngredientComponent));
        }
        return tgt;
    }

    public static Substance.SubstanceIngredientComponent convertSubstanceIngredientComponent(Substance.SubstanceIngredientComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Substance.SubstanceIngredientComponent tgt = new Substance.SubstanceIngredientComponent();
        VersionConvertor_10_30.copyElement(src, tgt);
        if (src.hasQuantity()) {
            tgt.setQuantity(VersionConvertor_10_30.convertRatio(src.getQuantity()));
        }
        if (src.hasSubstance()) {
            tgt.setSubstance(VersionConvertor_10_30.convertReference(src.getSubstance()));
        }
        return tgt;
    }

    public static Substance.SubstanceIngredientComponent convertSubstanceIngredientComponent(Substance.SubstanceIngredientComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Substance.SubstanceIngredientComponent tgt = new Substance.SubstanceIngredientComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasQuantity()) {
            tgt.setQuantity(VersionConvertor_10_30.convertRatio(src.getQuantity()));
        }
        return tgt;
    }

    public static Substance.SubstanceInstanceComponent convertSubstanceInstanceComponent(Substance.SubstanceInstanceComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Substance.SubstanceInstanceComponent tgt = new Substance.SubstanceInstanceComponent();
        VersionConvertor_10_30.copyElement(src, tgt);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_10_30.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasExpiryElement()) {
            tgt.setExpiryElement(VersionConvertor_10_30.convertDateTime(src.getExpiryElement()));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(VersionConvertor_10_30.convertSimpleQuantity(src.getQuantity()));
        }
        return tgt;
    }

    public static Substance.SubstanceInstanceComponent convertSubstanceInstanceComponent(Substance.SubstanceInstanceComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Substance.SubstanceInstanceComponent tgt = new Substance.SubstanceInstanceComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_10_30.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasExpiryElement()) {
            tgt.setExpiryElement(VersionConvertor_10_30.convertDateTime(src.getExpiryElement()));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(VersionConvertor_10_30.convertSimpleQuantity(src.getQuantity()));
        }
        return tgt;
    }
}

