/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_30;

import org.hl7.fhir.convertors.VersionConvertor_10_30;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.ProcedureRequest;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.ProcedureRequest;
import org.hl7.fhir.exceptions.FHIRException;

public class ProcedureRequest10_30 {
    public static org.hl7.fhir.dstu3.model.ProcedureRequest convertProcedureRequest(ProcedureRequest src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.ProcedureRequest tgt = new org.hl7.fhir.dstu3.model.ProcedureRequest();
        VersionConvertor_10_30.copyDomainResource(src, tgt);
        for (org.hl7.fhir.dstu2.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_30.convertIdentifier(identifier));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_10_30.convertReference(src.getSubject()));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_10_30.convertCodeableConcept(src.getCode()));
        }
        for (org.hl7.fhir.dstu2.model.CodeableConcept codeableConcept : src.getBodySite()) {
            tgt.addBodySite(VersionConvertor_10_30.convertCodeableConcept(codeableConcept));
        }
        if (src.hasReasonCodeableConcept()) {
            tgt.addReasonCode(VersionConvertor_10_30.convertCodeableConcept(src.getReasonCodeableConcept()));
        }
        if (src.hasScheduled()) {
            tgt.setOccurrence(VersionConvertor_10_30.convertType(src.getScheduled()));
        }
        if (src.hasEncounter()) {
            tgt.setContext(VersionConvertor_10_30.convertReference(src.getEncounter()));
        }
        if (src.hasPerformer()) {
            tgt.setPerformer(VersionConvertor_10_30.convertReference(src.getPerformer()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(ProcedureRequest10_30.convertProcedureRequestStatus(src.getStatusElement()));
        }
        if (src.hasAsNeeded()) {
            tgt.setAsNeeded(VersionConvertor_10_30.convertType(src.getAsNeeded()));
        }
        if (src.hasOrderedOnElement()) {
            tgt.setAuthoredOnElement(VersionConvertor_10_30.convertDateTime(src.getOrderedOnElement()));
        }
        if (src.hasPriority()) {
            tgt.setPriorityElement(ProcedureRequest10_30.convertProcedureRequestPriority(src.getPriorityElement()));
        }
        return tgt;
    }

    public static ProcedureRequest convertProcedureRequest(org.hl7.fhir.dstu3.model.ProcedureRequest src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ProcedureRequest tgt = new ProcedureRequest();
        VersionConvertor_10_30.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_30.convertIdentifier(identifier));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_10_30.convertReference(src.getSubject()));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_10_30.convertCodeableConcept(src.getCode()));
        }
        for (CodeableConcept codeableConcept : src.getBodySite()) {
            tgt.addBodySite(VersionConvertor_10_30.convertCodeableConcept(codeableConcept));
        }
        if (src.hasReasonCode()) {
            tgt.setReason(VersionConvertor_10_30.convertType(src.getReasonCodeFirstRep()));
        }
        if (src.hasOccurrence()) {
            tgt.setScheduled(VersionConvertor_10_30.convertType(src.getOccurrence()));
        }
        if (src.hasContext()) {
            tgt.setEncounter(VersionConvertor_10_30.convertReference(src.getContext()));
        }
        if (src.hasPerformer()) {
            tgt.setPerformer(VersionConvertor_10_30.convertReference(src.getPerformer()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(ProcedureRequest10_30.convertProcedureRequestStatus(src.getStatusElement()));
        }
        if (src.hasAsNeeded()) {
            tgt.setAsNeeded(VersionConvertor_10_30.convertType(src.getAsNeeded()));
        }
        if (src.hasAuthoredOnElement()) {
            tgt.setOrderedOnElement(VersionConvertor_10_30.convertDateTime(src.getAuthoredOnElement()));
        }
        if (src.hasPriority()) {
            tgt.setPriorityElement(ProcedureRequest10_30.convertProcedureRequestPriority(src.getPriorityElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<ProcedureRequest.ProcedureRequestPriority> convertProcedureRequestPriority(Enumeration<ProcedureRequest.ProcedureRequestPriority> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<ProcedureRequest.ProcedureRequestPriority> tgt = new org.hl7.fhir.dstu3.model.Enumeration<ProcedureRequest.ProcedureRequestPriority>(new ProcedureRequest.ProcedureRequestPriorityEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        switch ((ProcedureRequest.ProcedureRequestPriority)((Object)src.getValue())) {
            case ROUTINE: {
                tgt.setValue((Object)ProcedureRequest.ProcedureRequestPriority.ROUTINE);
                break;
            }
            case URGENT: {
                tgt.setValue((Object)ProcedureRequest.ProcedureRequestPriority.URGENT);
                break;
            }
            case STAT: {
                tgt.setValue((Object)ProcedureRequest.ProcedureRequestPriority.STAT);
                break;
            }
            case ASAP: {
                tgt.setValue((Object)ProcedureRequest.ProcedureRequestPriority.ASAP);
                break;
            }
            default: {
                tgt.setValue((Object)ProcedureRequest.ProcedureRequestPriority.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<ProcedureRequest.ProcedureRequestPriority> convertProcedureRequestPriority(org.hl7.fhir.dstu3.model.Enumeration<ProcedureRequest.ProcedureRequestPriority> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ProcedureRequest.ProcedureRequestPriority> tgt = new Enumeration<ProcedureRequest.ProcedureRequestPriority>(new ProcedureRequest.ProcedureRequestPriorityEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        switch ((ProcedureRequest.ProcedureRequestPriority)((Object)src.getValue())) {
            case ROUTINE: {
                tgt.setValue((Object)ProcedureRequest.ProcedureRequestPriority.ROUTINE);
                break;
            }
            case URGENT: {
                tgt.setValue((Object)ProcedureRequest.ProcedureRequestPriority.URGENT);
                break;
            }
            case STAT: {
                tgt.setValue((Object)ProcedureRequest.ProcedureRequestPriority.STAT);
                break;
            }
            case ASAP: {
                tgt.setValue((Object)ProcedureRequest.ProcedureRequestPriority.ASAP);
                break;
            }
            default: {
                tgt.setValue((Object)ProcedureRequest.ProcedureRequestPriority.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<ProcedureRequest.ProcedureRequestStatus> convertProcedureRequestStatus(org.hl7.fhir.dstu3.model.Enumeration<ProcedureRequest.ProcedureRequestStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ProcedureRequest.ProcedureRequestStatus> tgt = new Enumeration<ProcedureRequest.ProcedureRequestStatus>(new ProcedureRequest.ProcedureRequestStatusEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        switch ((ProcedureRequest.ProcedureRequestStatus)((Object)src.getValue())) {
            case DRAFT: {
                tgt.setValue((Object)ProcedureRequest.ProcedureRequestStatus.DRAFT);
                break;
            }
            case ACTIVE: {
                tgt.setValue((Object)ProcedureRequest.ProcedureRequestStatus.INPROGRESS);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)ProcedureRequest.ProcedureRequestStatus.COMPLETED);
                break;
            }
            case SUSPENDED: {
                tgt.setValue((Object)ProcedureRequest.ProcedureRequestStatus.SUSPENDED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)ProcedureRequest.ProcedureRequestStatus.ABORTED);
                break;
            }
            default: {
                tgt.setValue((Object)ProcedureRequest.ProcedureRequestStatus.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<ProcedureRequest.ProcedureRequestStatus> convertProcedureRequestStatus(Enumeration<ProcedureRequest.ProcedureRequestStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<ProcedureRequest.ProcedureRequestStatus> tgt = new org.hl7.fhir.dstu3.model.Enumeration<ProcedureRequest.ProcedureRequestStatus>(new ProcedureRequest.ProcedureRequestStatusEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        switch ((ProcedureRequest.ProcedureRequestStatus)((Object)src.getValue())) {
            case PROPOSED: {
                tgt.setValue((Object)ProcedureRequest.ProcedureRequestStatus.DRAFT);
                break;
            }
            case DRAFT: {
                tgt.setValue((Object)ProcedureRequest.ProcedureRequestStatus.DRAFT);
                break;
            }
            case REQUESTED: {
                tgt.setValue((Object)ProcedureRequest.ProcedureRequestStatus.ACTIVE);
                break;
            }
            case RECEIVED: {
                tgt.setValue((Object)ProcedureRequest.ProcedureRequestStatus.ACTIVE);
                break;
            }
            case ACCEPTED: {
                tgt.setValue((Object)ProcedureRequest.ProcedureRequestStatus.ACTIVE);
                break;
            }
            case INPROGRESS: {
                tgt.setValue((Object)ProcedureRequest.ProcedureRequestStatus.ACTIVE);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)ProcedureRequest.ProcedureRequestStatus.COMPLETED);
                break;
            }
            case SUSPENDED: {
                tgt.setValue((Object)ProcedureRequest.ProcedureRequestStatus.SUSPENDED);
                break;
            }
            case ABORTED: {
                tgt.setValue((Object)ProcedureRequest.ProcedureRequestStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)ProcedureRequest.ProcedureRequestStatus.NULL);
            }
        }
        return tgt;
    }
}

