/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_30;

import org.hl7.fhir.convertors.VersionConvertor_10_30;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.Procedure;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Procedure;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.exceptions.FHIRException;

public class Procedure10_30 {
    public static Procedure convertProcedure(org.hl7.fhir.dstu3.model.Procedure src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Procedure tgt = new Procedure();
        VersionConvertor_10_30.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_30.convertIdentifier(identifier));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_10_30.convertReference(src.getSubject()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Procedure10_30.convertProcedureStatus(src.getStatusElement()));
        }
        if (src.hasCategory()) {
            tgt.setCategory(VersionConvertor_10_30.convertCodeableConcept(src.getCategory()));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_10_30.convertCodeableConcept(src.getCode()));
        }
        if (src.hasNotDoneElement()) {
            tgt.setNotPerformedElement(VersionConvertor_10_30.convertBoolean(src.getNotDoneElement()));
        }
        if (src.hasNotDoneReason()) {
            tgt.addReasonNotPerformed(VersionConvertor_10_30.convertCodeableConcept(src.getNotDoneReason()));
        }
        for (CodeableConcept codeableConcept : src.getBodySite()) {
            tgt.addBodySite(VersionConvertor_10_30.convertCodeableConcept(codeableConcept));
        }
        if (src.hasReasonCode()) {
            tgt.setReason(VersionConvertor_10_30.convertType(src.getReasonCodeFirstRep()));
        }
        for (Procedure.ProcedurePerformerComponent procedurePerformerComponent : src.getPerformer()) {
            tgt.addPerformer(Procedure10_30.convertProcedurePerformerComponent(procedurePerformerComponent));
        }
        if (src.hasPerformed()) {
            tgt.setPerformed(VersionConvertor_10_30.convertType(src.getPerformed()));
        }
        if (src.hasContext()) {
            tgt.setEncounter(VersionConvertor_10_30.convertReference(src.getContext()));
        }
        if (src.hasLocation()) {
            tgt.setLocation(VersionConvertor_10_30.convertReference(src.getLocation()));
        }
        if (src.hasOutcome()) {
            tgt.setOutcome(VersionConvertor_10_30.convertCodeableConcept(src.getOutcome()));
        }
        for (Reference reference : src.getReport()) {
            tgt.addReport(VersionConvertor_10_30.convertReference(reference));
        }
        for (CodeableConcept codeableConcept : src.getComplication()) {
            tgt.addComplication(VersionConvertor_10_30.convertCodeableConcept(codeableConcept));
        }
        for (CodeableConcept codeableConcept : src.getFollowUp()) {
            tgt.addFollowUp(VersionConvertor_10_30.convertCodeableConcept(codeableConcept));
        }
        if (src.hasBasedOn()) {
            tgt.setRequest(VersionConvertor_10_30.convertReference(src.getBasedOnFirstRep()));
        }
        for (Procedure.ProcedureFocalDeviceComponent procedureFocalDeviceComponent : src.getFocalDevice()) {
            tgt.addFocalDevice(Procedure10_30.convertProcedureFocalDeviceComponent(procedureFocalDeviceComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Procedure convertProcedure(Procedure src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Procedure tgt = new org.hl7.fhir.dstu3.model.Procedure();
        VersionConvertor_10_30.copyDomainResource(src, tgt);
        for (org.hl7.fhir.dstu2.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_30.convertIdentifier(identifier));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_10_30.convertReference(src.getSubject()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Procedure10_30.convertProcedureStatus(src.getStatusElement()));
        }
        if (src.hasCategory()) {
            tgt.setCategory(VersionConvertor_10_30.convertCodeableConcept(src.getCategory()));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_10_30.convertCodeableConcept(src.getCode()));
        }
        if (src.hasNotPerformedElement()) {
            tgt.setNotDoneElement(VersionConvertor_10_30.convertBoolean(src.getNotPerformedElement()));
        }
        if (src.hasReasonNotPerformed()) {
            tgt.setNotDoneReason(VersionConvertor_10_30.convertCodeableConcept(src.getReasonNotPerformed().get(0)));
        }
        for (org.hl7.fhir.dstu2.model.CodeableConcept codeableConcept : src.getBodySite()) {
            tgt.addBodySite(VersionConvertor_10_30.convertCodeableConcept(codeableConcept));
        }
        if (src.hasReasonCodeableConcept()) {
            tgt.addReasonCode(VersionConvertor_10_30.convertCodeableConcept(src.getReasonCodeableConcept()));
        }
        for (Procedure.ProcedurePerformerComponent procedurePerformerComponent : src.getPerformer()) {
            tgt.addPerformer(Procedure10_30.convertProcedurePerformerComponent(procedurePerformerComponent));
        }
        if (src.hasPerformed()) {
            tgt.setPerformed(VersionConvertor_10_30.convertType(src.getPerformed()));
        }
        if (src.hasEncounter()) {
            tgt.setContext(VersionConvertor_10_30.convertReference(src.getEncounter()));
        }
        if (src.hasLocation()) {
            tgt.setLocation(VersionConvertor_10_30.convertReference(src.getLocation()));
        }
        if (src.hasOutcome()) {
            tgt.setOutcome(VersionConvertor_10_30.convertCodeableConcept(src.getOutcome()));
        }
        for (org.hl7.fhir.dstu2.model.Reference reference : src.getReport()) {
            tgt.addReport(VersionConvertor_10_30.convertReference(reference));
        }
        for (org.hl7.fhir.dstu2.model.CodeableConcept codeableConcept : src.getComplication()) {
            tgt.addComplication(VersionConvertor_10_30.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.dstu2.model.CodeableConcept codeableConcept : src.getFollowUp()) {
            tgt.addFollowUp(VersionConvertor_10_30.convertCodeableConcept(codeableConcept));
        }
        if (src.hasRequest()) {
            tgt.addBasedOn(VersionConvertor_10_30.convertReference(src.getRequest()));
        }
        for (Procedure.ProcedureFocalDeviceComponent procedureFocalDeviceComponent : src.getFocalDevice()) {
            tgt.addFocalDevice(Procedure10_30.convertProcedureFocalDeviceComponent(procedureFocalDeviceComponent));
        }
        return tgt;
    }

    public static Procedure.ProcedureFocalDeviceComponent convertProcedureFocalDeviceComponent(Procedure.ProcedureFocalDeviceComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Procedure.ProcedureFocalDeviceComponent tgt = new Procedure.ProcedureFocalDeviceComponent();
        VersionConvertor_10_30.copyElement(src, tgt);
        if (src.hasAction()) {
            tgt.setAction(VersionConvertor_10_30.convertCodeableConcept(src.getAction()));
        }
        if (src.hasManipulated()) {
            tgt.setManipulated(VersionConvertor_10_30.convertReference(src.getManipulated()));
        }
        return tgt;
    }

    public static Procedure.ProcedureFocalDeviceComponent convertProcedureFocalDeviceComponent(Procedure.ProcedureFocalDeviceComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Procedure.ProcedureFocalDeviceComponent tgt = new Procedure.ProcedureFocalDeviceComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasAction()) {
            tgt.setAction(VersionConvertor_10_30.convertCodeableConcept(src.getAction()));
        }
        if (src.hasManipulated()) {
            tgt.setManipulated(VersionConvertor_10_30.convertReference(src.getManipulated()));
        }
        return tgt;
    }

    public static Procedure.ProcedurePerformerComponent convertProcedurePerformerComponent(Procedure.ProcedurePerformerComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Procedure.ProcedurePerformerComponent tgt = new Procedure.ProcedurePerformerComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasActor()) {
            tgt.setActor(VersionConvertor_10_30.convertReference(src.getActor()));
        }
        if (src.hasRole()) {
            tgt.setRole(VersionConvertor_10_30.convertCodeableConcept(src.getRole()));
        }
        return tgt;
    }

    public static Procedure.ProcedurePerformerComponent convertProcedurePerformerComponent(Procedure.ProcedurePerformerComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Procedure.ProcedurePerformerComponent tgt = new Procedure.ProcedurePerformerComponent();
        VersionConvertor_10_30.copyElement(src, tgt);
        if (src.hasActor()) {
            tgt.setActor(VersionConvertor_10_30.convertReference(src.getActor()));
        }
        if (src.hasRole()) {
            tgt.setRole(VersionConvertor_10_30.convertCodeableConcept(src.getRole()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<Procedure.ProcedureStatus> convertProcedureStatus(Enumeration<Procedure.ProcedureStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<Procedure.ProcedureStatus> tgt = new org.hl7.fhir.dstu3.model.Enumeration<Procedure.ProcedureStatus>(new Procedure.ProcedureStatusEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        switch ((Procedure.ProcedureStatus)((Object)src.getValue())) {
            case INPROGRESS: {
                tgt.setValue((Object)Procedure.ProcedureStatus.INPROGRESS);
                break;
            }
            case ABORTED: {
                tgt.setValue((Object)Procedure.ProcedureStatus.ABORTED);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)Procedure.ProcedureStatus.COMPLETED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Procedure.ProcedureStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)Procedure.ProcedureStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Procedure.ProcedureStatus> convertProcedureStatus(org.hl7.fhir.dstu3.model.Enumeration<Procedure.ProcedureStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Procedure.ProcedureStatus> tgt = new Enumeration<Procedure.ProcedureStatus>(new Procedure.ProcedureStatusEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        switch ((Procedure.ProcedureStatus)((Object)src.getValue())) {
            case INPROGRESS: {
                tgt.setValue((Object)Procedure.ProcedureStatus.INPROGRESS);
                break;
            }
            case ABORTED: {
                tgt.setValue((Object)Procedure.ProcedureStatus.ABORTED);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)Procedure.ProcedureStatus.COMPLETED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Procedure.ProcedureStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)Procedure.ProcedureStatus.NULL);
            }
        }
        return tgt;
    }
}

