/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_30;

import org.hl7.fhir.convertors.VersionConvertor_10_30;
import org.hl7.fhir.dstu2.model.ContactPoint;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.Practitioner;
import org.hl7.fhir.dstu3.model.Address;
import org.hl7.fhir.dstu3.model.Attachment;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.HumanName;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Practitioner;
import org.hl7.fhir.exceptions.FHIRException;

public class Practitioner10_30 {
    public static org.hl7.fhir.dstu3.model.Practitioner convertPractitioner(Practitioner src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Practitioner tgt = new org.hl7.fhir.dstu3.model.Practitioner();
        VersionConvertor_10_30.copyDomainResource(src, tgt);
        for (org.hl7.fhir.dstu2.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_30.convertIdentifier(identifier));
        }
        if (src.hasActiveElement()) {
            tgt.setActiveElement(VersionConvertor_10_30.convertBoolean(src.getActiveElement()));
        }
        if (src.hasName()) {
            tgt.addName(VersionConvertor_10_30.convertHumanName(src.getName()));
        }
        for (ContactPoint contactPoint : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_10_30.convertContactPoint(contactPoint));
        }
        for (org.hl7.fhir.dstu2.model.Address address : src.getAddress()) {
            tgt.addAddress(VersionConvertor_10_30.convertAddress(address));
        }
        if (src.hasGender()) {
            tgt.setGenderElement(VersionConvertor_10_30.convertAdministrativeGender(src.getGenderElement()));
        }
        if (src.hasBirthDateElement()) {
            tgt.setBirthDateElement(VersionConvertor_10_30.convertDate(src.getBirthDateElement()));
        }
        for (org.hl7.fhir.dstu2.model.Attachment attachment : src.getPhoto()) {
            tgt.addPhoto(VersionConvertor_10_30.convertAttachment(attachment));
        }
        for (Practitioner.PractitionerQualificationComponent practitionerQualificationComponent : src.getQualification()) {
            tgt.addQualification(Practitioner10_30.convertPractitionerQualificationComponent(practitionerQualificationComponent));
        }
        for (org.hl7.fhir.dstu2.model.CodeableConcept codeableConcept : src.getCommunication()) {
            tgt.addCommunication(VersionConvertor_10_30.convertCodeableConcept(codeableConcept));
        }
        return tgt;
    }

    public static Practitioner convertPractitioner(org.hl7.fhir.dstu3.model.Practitioner src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Practitioner tgt = new Practitioner();
        VersionConvertor_10_30.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_30.convertIdentifier(identifier));
        }
        if (src.hasActiveElement()) {
            tgt.setActiveElement(VersionConvertor_10_30.convertBoolean(src.getActiveElement()));
        }
        for (HumanName humanName : src.getName()) {
            tgt.setName(VersionConvertor_10_30.convertHumanName(humanName));
        }
        for (org.hl7.fhir.dstu3.model.ContactPoint contactPoint : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_10_30.convertContactPoint(contactPoint));
        }
        for (Address address : src.getAddress()) {
            tgt.addAddress(VersionConvertor_10_30.convertAddress(address));
        }
        if (src.hasGender()) {
            tgt.setGenderElement(VersionConvertor_10_30.convertAdministrativeGender(src.getGenderElement()));
        }
        if (src.hasBirthDateElement()) {
            tgt.setBirthDateElement(VersionConvertor_10_30.convertDate(src.getBirthDateElement()));
        }
        for (Attachment attachment : src.getPhoto()) {
            tgt.addPhoto(VersionConvertor_10_30.convertAttachment(attachment));
        }
        for (Practitioner.PractitionerQualificationComponent practitionerQualificationComponent : src.getQualification()) {
            tgt.addQualification(Practitioner10_30.convertPractitionerQualificationComponent(practitionerQualificationComponent));
        }
        for (CodeableConcept codeableConcept : src.getCommunication()) {
            tgt.addCommunication(VersionConvertor_10_30.convertCodeableConcept(codeableConcept));
        }
        return tgt;
    }

    public static Practitioner.PractitionerQualificationComponent convertPractitionerQualificationComponent(Practitioner.PractitionerQualificationComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Practitioner.PractitionerQualificationComponent tgt = new Practitioner.PractitionerQualificationComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_30.convertIdentifier(t));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_10_30.convertCodeableConcept(src.getCode()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_10_30.convertPeriod(src.getPeriod()));
        }
        if (src.hasIssuer()) {
            tgt.setIssuer(VersionConvertor_10_30.convertReference(src.getIssuer()));
        }
        return tgt;
    }

    public static Practitioner.PractitionerQualificationComponent convertPractitionerQualificationComponent(Practitioner.PractitionerQualificationComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Practitioner.PractitionerQualificationComponent tgt = new Practitioner.PractitionerQualificationComponent();
        VersionConvertor_10_30.copyElement(src, tgt);
        for (org.hl7.fhir.dstu2.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_30.convertIdentifier(t));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_10_30.convertCodeableConcept(src.getCode()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_10_30.convertPeriod(src.getPeriod()));
        }
        if (src.hasIssuer()) {
            tgt.setIssuer(VersionConvertor_10_30.convertReference(src.getIssuer()));
        }
        return tgt;
    }
}

