/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_30;

import org.hl7.fhir.convertors.VersionConvertor_10_30;
import org.hl7.fhir.dstu2.model.CodeableConcept;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.Patient;
import org.hl7.fhir.dstu3.model.Address;
import org.hl7.fhir.dstu3.model.Attachment;
import org.hl7.fhir.dstu3.model.ContactPoint;
import org.hl7.fhir.dstu3.model.HumanName;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Patient;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.exceptions.FHIRException;

public class Patient10_30 {
    public static Patient.AnimalComponent convertAnimalComponent(Patient.AnimalComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Patient.AnimalComponent tgt = new Patient.AnimalComponent();
        VersionConvertor_10_30.copyElement(src, tgt);
        if (src.hasSpecies()) {
            tgt.setSpecies(VersionConvertor_10_30.convertCodeableConcept(src.getSpecies()));
        }
        if (src.hasBreed()) {
            tgt.setBreed(VersionConvertor_10_30.convertCodeableConcept(src.getBreed()));
        }
        if (src.hasGenderStatus()) {
            tgt.setGenderStatus(VersionConvertor_10_30.convertCodeableConcept(src.getGenderStatus()));
        }
        return tgt;
    }

    public static Patient.AnimalComponent convertAnimalComponent(Patient.AnimalComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Patient.AnimalComponent tgt = new Patient.AnimalComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasSpecies()) {
            tgt.setSpecies(VersionConvertor_10_30.convertCodeableConcept(src.getSpecies()));
        }
        if (src.hasBreed()) {
            tgt.setBreed(VersionConvertor_10_30.convertCodeableConcept(src.getBreed()));
        }
        if (src.hasGenderStatus()) {
            tgt.setGenderStatus(VersionConvertor_10_30.convertCodeableConcept(src.getGenderStatus()));
        }
        return tgt;
    }

    public static Patient.ContactComponent convertContactComponent(Patient.ContactComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Patient.ContactComponent tgt = new Patient.ContactComponent();
        VersionConvertor_10_30.copyElement(src, tgt);
        for (CodeableConcept codeableConcept : src.getRelationship()) {
            tgt.addRelationship(VersionConvertor_10_30.convertCodeableConcept(codeableConcept));
        }
        if (src.hasName()) {
            tgt.setName(VersionConvertor_10_30.convertHumanName(src.getName()));
        }
        for (org.hl7.fhir.dstu2.model.ContactPoint contactPoint : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_10_30.convertContactPoint(contactPoint));
        }
        if (src.hasAddress()) {
            tgt.setAddress(VersionConvertor_10_30.convertAddress(src.getAddress()));
        }
        if (src.hasGender()) {
            tgt.setGenderElement(VersionConvertor_10_30.convertAdministrativeGender(src.getGenderElement()));
        }
        if (src.hasOrganization()) {
            tgt.setOrganization(VersionConvertor_10_30.convertReference(src.getOrganization()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_10_30.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static Patient.ContactComponent convertContactComponent(Patient.ContactComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Patient.ContactComponent tgt = new Patient.ContactComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getRelationship()) {
            tgt.addRelationship(VersionConvertor_10_30.convertCodeableConcept(codeableConcept));
        }
        if (src.hasName()) {
            tgt.setName(VersionConvertor_10_30.convertHumanName(src.getName()));
        }
        for (ContactPoint contactPoint : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_10_30.convertContactPoint(contactPoint));
        }
        if (src.hasAddress()) {
            tgt.setAddress(VersionConvertor_10_30.convertAddress(src.getAddress()));
        }
        if (src.hasGender()) {
            tgt.setGenderElement(VersionConvertor_10_30.convertAdministrativeGender(src.getGenderElement()));
        }
        if (src.hasOrganization()) {
            tgt.setOrganization(VersionConvertor_10_30.convertReference(src.getOrganization()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_10_30.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static Enumeration<Patient.LinkType> convertLinkType(org.hl7.fhir.dstu3.model.Enumeration<Patient.LinkType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Patient.LinkType> tgt = new Enumeration<Patient.LinkType>(new Patient.LinkTypeEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        switch ((Patient.LinkType)((Object)src.getValue())) {
            case REPLACEDBY: {
                tgt.setValue((Object)Patient.LinkType.REPLACE);
                break;
            }
            case REPLACES: {
                tgt.setValue((Object)Patient.LinkType.REPLACE);
                break;
            }
            case REFER: {
                tgt.setValue((Object)Patient.LinkType.REFER);
                break;
            }
            case SEEALSO: {
                tgt.setValue((Object)Patient.LinkType.SEEALSO);
                break;
            }
            default: {
                tgt.setValue((Object)Patient.LinkType.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<Patient.LinkType> convertLinkType(Enumeration<Patient.LinkType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<Patient.LinkType> tgt = new org.hl7.fhir.dstu3.model.Enumeration<Patient.LinkType>(new Patient.LinkTypeEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        switch ((Patient.LinkType)((Object)src.getValue())) {
            case REPLACE: {
                tgt.setValue((Object)Patient.LinkType.REPLACEDBY);
                break;
            }
            case REFER: {
                tgt.setValue((Object)Patient.LinkType.REFER);
                break;
            }
            case SEEALSO: {
                tgt.setValue((Object)Patient.LinkType.SEEALSO);
                break;
            }
            default: {
                tgt.setValue((Object)Patient.LinkType.NULL);
            }
        }
        return tgt;
    }

    public static Patient convertPatient(org.hl7.fhir.dstu2.model.Patient src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Patient tgt = new Patient();
        VersionConvertor_10_30.copyDomainResource(src, tgt);
        for (org.hl7.fhir.dstu2.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_30.convertIdentifier(identifier));
        }
        if (src.hasActiveElement()) {
            tgt.setActiveElement(VersionConvertor_10_30.convertBoolean(src.getActiveElement()));
        }
        for (org.hl7.fhir.dstu2.model.HumanName humanName : src.getName()) {
            tgt.addName(VersionConvertor_10_30.convertHumanName(humanName));
        }
        for (org.hl7.fhir.dstu2.model.ContactPoint contactPoint : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_10_30.convertContactPoint(contactPoint));
        }
        if (src.hasGender()) {
            tgt.setGenderElement(VersionConvertor_10_30.convertAdministrativeGender(src.getGenderElement()));
        }
        if (src.hasBirthDateElement()) {
            tgt.setBirthDateElement(VersionConvertor_10_30.convertDate(src.getBirthDateElement()));
        }
        if (src.hasDeceased()) {
            tgt.setDeceased(VersionConvertor_10_30.convertType(src.getDeceased()));
        }
        for (org.hl7.fhir.dstu2.model.Address address : src.getAddress()) {
            tgt.addAddress(VersionConvertor_10_30.convertAddress(address));
        }
        if (src.hasMaritalStatus()) {
            tgt.setMaritalStatus(VersionConvertor_10_30.convertCodeableConcept(src.getMaritalStatus()));
        }
        if (src.hasMultipleBirth()) {
            tgt.setMultipleBirth(VersionConvertor_10_30.convertType(src.getMultipleBirth()));
        }
        for (org.hl7.fhir.dstu2.model.Attachment attachment : src.getPhoto()) {
            tgt.addPhoto(VersionConvertor_10_30.convertAttachment(attachment));
        }
        for (Patient.ContactComponent contactComponent : src.getContact()) {
            tgt.addContact(Patient10_30.convertContactComponent(contactComponent));
        }
        if (src.hasAnimal()) {
            tgt.setAnimal(Patient10_30.convertAnimalComponent(src.getAnimal()));
        }
        for (Patient.PatientCommunicationComponent patientCommunicationComponent : src.getCommunication()) {
            tgt.addCommunication(Patient10_30.convertPatientCommunicationComponent(patientCommunicationComponent));
        }
        for (org.hl7.fhir.dstu2.model.Reference reference : src.getCareProvider()) {
            tgt.addGeneralPractitioner(VersionConvertor_10_30.convertReference(reference));
        }
        if (src.hasManagingOrganization()) {
            tgt.setManagingOrganization(VersionConvertor_10_30.convertReference(src.getManagingOrganization()));
        }
        for (Patient.PatientLinkComponent patientLinkComponent : src.getLink()) {
            tgt.addLink(Patient10_30.convertPatientLinkComponent(patientLinkComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.Patient convertPatient(Patient src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.Patient tgt = new org.hl7.fhir.dstu2.model.Patient();
        VersionConvertor_10_30.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_30.convertIdentifier(identifier));
        }
        if (src.hasActiveElement()) {
            tgt.setActiveElement(VersionConvertor_10_30.convertBoolean(src.getActiveElement()));
        }
        for (HumanName humanName : src.getName()) {
            tgt.addName(VersionConvertor_10_30.convertHumanName(humanName));
        }
        for (ContactPoint contactPoint : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_10_30.convertContactPoint(contactPoint));
        }
        if (src.hasGender()) {
            tgt.setGenderElement(VersionConvertor_10_30.convertAdministrativeGender(src.getGenderElement()));
        }
        if (src.hasBirthDateElement()) {
            tgt.setBirthDateElement(VersionConvertor_10_30.convertDate(src.getBirthDateElement()));
        }
        if (src.hasDeceased()) {
            tgt.setDeceased(VersionConvertor_10_30.convertType(src.getDeceased()));
        }
        for (Address address : src.getAddress()) {
            tgt.addAddress(VersionConvertor_10_30.convertAddress(address));
        }
        if (src.hasMaritalStatus()) {
            tgt.setMaritalStatus(VersionConvertor_10_30.convertCodeableConcept(src.getMaritalStatus()));
        }
        if (src.hasMultipleBirth()) {
            tgt.setMultipleBirth(VersionConvertor_10_30.convertType(src.getMultipleBirth()));
        }
        for (Attachment attachment : src.getPhoto()) {
            tgt.addPhoto(VersionConvertor_10_30.convertAttachment(attachment));
        }
        for (Patient.ContactComponent contactComponent : src.getContact()) {
            tgt.addContact(Patient10_30.convertContactComponent(contactComponent));
        }
        if (src.hasAnimal()) {
            tgt.setAnimal(Patient10_30.convertAnimalComponent(src.getAnimal()));
        }
        for (Patient.PatientCommunicationComponent patientCommunicationComponent : src.getCommunication()) {
            tgt.addCommunication(Patient10_30.convertPatientCommunicationComponent(patientCommunicationComponent));
        }
        for (Reference reference : src.getGeneralPractitioner()) {
            tgt.addCareProvider(VersionConvertor_10_30.convertReference(reference));
        }
        if (src.hasManagingOrganization()) {
            tgt.setManagingOrganization(VersionConvertor_10_30.convertReference(src.getManagingOrganization()));
        }
        for (Patient.PatientLinkComponent patientLinkComponent : src.getLink()) {
            tgt.addLink(Patient10_30.convertPatientLinkComponent(patientLinkComponent));
        }
        return tgt;
    }

    public static Patient.PatientCommunicationComponent convertPatientCommunicationComponent(Patient.PatientCommunicationComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Patient.PatientCommunicationComponent tgt = new Patient.PatientCommunicationComponent();
        VersionConvertor_10_30.copyElement(src, tgt);
        if (src.hasLanguage()) {
            tgt.setLanguage(VersionConvertor_10_30.convertCodeableConcept(src.getLanguage()));
        }
        if (src.hasPreferredElement()) {
            tgt.setPreferredElement(VersionConvertor_10_30.convertBoolean(src.getPreferredElement()));
        }
        return tgt;
    }

    public static Patient.PatientCommunicationComponent convertPatientCommunicationComponent(Patient.PatientCommunicationComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Patient.PatientCommunicationComponent tgt = new Patient.PatientCommunicationComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasLanguage()) {
            tgt.setLanguage(VersionConvertor_10_30.convertCodeableConcept(src.getLanguage()));
        }
        if (src.hasPreferredElement()) {
            tgt.setPreferredElement(VersionConvertor_10_30.convertBoolean(src.getPreferredElement()));
        }
        return tgt;
    }

    public static Patient.PatientLinkComponent convertPatientLinkComponent(Patient.PatientLinkComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Patient.PatientLinkComponent tgt = new Patient.PatientLinkComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasOther()) {
            tgt.setOther(VersionConvertor_10_30.convertReference(src.getOther()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(Patient10_30.convertLinkType(src.getTypeElement()));
        }
        return tgt;
    }

    public static Patient.PatientLinkComponent convertPatientLinkComponent(Patient.PatientLinkComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Patient.PatientLinkComponent tgt = new Patient.PatientLinkComponent();
        VersionConvertor_10_30.copyElement(src, tgt);
        if (src.hasOther()) {
            tgt.setOther(VersionConvertor_10_30.convertReference(src.getOther()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(Patient10_30.convertLinkType(src.getTypeElement()));
        }
        return tgt;
    }
}

