/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_30;

import org.hl7.fhir.convertors.VersionConvertor_10_30;
import org.hl7.fhir.dstu2.model.CodeType;
import org.hl7.fhir.dstu2.model.CodeableConcept;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.ImplementationGuide;
import org.hl7.fhir.dstu2.model.StringType;
import org.hl7.fhir.dstu3.model.ContactDetail;
import org.hl7.fhir.dstu3.model.ContactPoint;
import org.hl7.fhir.dstu3.model.ImplementationGuide;
import org.hl7.fhir.dstu3.model.UriType;
import org.hl7.fhir.dstu3.model.UsageContext;
import org.hl7.fhir.exceptions.FHIRException;

public class ImplementationGuide10_30 {
    public static org.hl7.fhir.dstu3.model.Enumeration<ImplementationGuide.GuideDependencyType> convertGuideDependencyType(Enumeration<ImplementationGuide.GuideDependencyType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<ImplementationGuide.GuideDependencyType> tgt = new org.hl7.fhir.dstu3.model.Enumeration<ImplementationGuide.GuideDependencyType>(new ImplementationGuide.GuideDependencyTypeEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        switch ((ImplementationGuide.GuideDependencyType)((Object)src.getValue())) {
            case REFERENCE: {
                tgt.setValue((Object)ImplementationGuide.GuideDependencyType.REFERENCE);
                break;
            }
            case INCLUSION: {
                tgt.setValue((Object)ImplementationGuide.GuideDependencyType.INCLUSION);
                break;
            }
            default: {
                tgt.setValue((Object)ImplementationGuide.GuideDependencyType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<ImplementationGuide.GuideDependencyType> convertGuideDependencyType(org.hl7.fhir.dstu3.model.Enumeration<ImplementationGuide.GuideDependencyType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ImplementationGuide.GuideDependencyType> tgt = new Enumeration<ImplementationGuide.GuideDependencyType>(new ImplementationGuide.GuideDependencyTypeEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        switch ((ImplementationGuide.GuideDependencyType)((Object)src.getValue())) {
            case REFERENCE: {
                tgt.setValue((Object)ImplementationGuide.GuideDependencyType.REFERENCE);
                break;
            }
            case INCLUSION: {
                tgt.setValue((Object)ImplementationGuide.GuideDependencyType.INCLUSION);
                break;
            }
            default: {
                tgt.setValue((Object)ImplementationGuide.GuideDependencyType.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<ImplementationGuide.GuidePageKind> convertGuidePageKind(Enumeration<ImplementationGuide.GuidePageKind> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<ImplementationGuide.GuidePageKind> tgt = new org.hl7.fhir.dstu3.model.Enumeration<ImplementationGuide.GuidePageKind>(new ImplementationGuide.GuidePageKindEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        switch ((ImplementationGuide.GuidePageKind)((Object)src.getValue())) {
            case PAGE: {
                tgt.setValue((Object)ImplementationGuide.GuidePageKind.PAGE);
                break;
            }
            case EXAMPLE: {
                tgt.setValue((Object)ImplementationGuide.GuidePageKind.EXAMPLE);
                break;
            }
            case LIST: {
                tgt.setValue((Object)ImplementationGuide.GuidePageKind.LIST);
                break;
            }
            case INCLUDE: {
                tgt.setValue((Object)ImplementationGuide.GuidePageKind.INCLUDE);
                break;
            }
            case DIRECTORY: {
                tgt.setValue((Object)ImplementationGuide.GuidePageKind.DIRECTORY);
                break;
            }
            case DICTIONARY: {
                tgt.setValue((Object)ImplementationGuide.GuidePageKind.DICTIONARY);
                break;
            }
            case TOC: {
                tgt.setValue((Object)ImplementationGuide.GuidePageKind.TOC);
                break;
            }
            case RESOURCE: {
                tgt.setValue((Object)ImplementationGuide.GuidePageKind.RESOURCE);
                break;
            }
            default: {
                tgt.setValue((Object)ImplementationGuide.GuidePageKind.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<ImplementationGuide.GuidePageKind> convertGuidePageKind(org.hl7.fhir.dstu3.model.Enumeration<ImplementationGuide.GuidePageKind> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ImplementationGuide.GuidePageKind> tgt = new Enumeration<ImplementationGuide.GuidePageKind>(new ImplementationGuide.GuidePageKindEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        switch ((ImplementationGuide.GuidePageKind)((Object)src.getValue())) {
            case PAGE: {
                tgt.setValue((Object)ImplementationGuide.GuidePageKind.PAGE);
                break;
            }
            case EXAMPLE: {
                tgt.setValue((Object)ImplementationGuide.GuidePageKind.EXAMPLE);
                break;
            }
            case LIST: {
                tgt.setValue((Object)ImplementationGuide.GuidePageKind.LIST);
                break;
            }
            case INCLUDE: {
                tgt.setValue((Object)ImplementationGuide.GuidePageKind.INCLUDE);
                break;
            }
            case DIRECTORY: {
                tgt.setValue((Object)ImplementationGuide.GuidePageKind.DIRECTORY);
                break;
            }
            case DICTIONARY: {
                tgt.setValue((Object)ImplementationGuide.GuidePageKind.DICTIONARY);
                break;
            }
            case TOC: {
                tgt.setValue((Object)ImplementationGuide.GuidePageKind.TOC);
                break;
            }
            case RESOURCE: {
                tgt.setValue((Object)ImplementationGuide.GuidePageKind.RESOURCE);
                break;
            }
            default: {
                tgt.setValue((Object)ImplementationGuide.GuidePageKind.NULL);
            }
        }
        return tgt;
    }

    public static ImplementationGuide convertImplementationGuide(org.hl7.fhir.dstu2.model.ImplementationGuide src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ImplementationGuide tgt = new ImplementationGuide();
        VersionConvertor_10_30.copyDomainResource(src, tgt);
        if (src.hasUrlElement()) {
            tgt.setUrlElement(VersionConvertor_10_30.convertUri(src.getUrlElement()));
        }
        if (src.hasVersionElement()) {
            tgt.setVersionElement(VersionConvertor_10_30.convertString(src.getVersionElement()));
        }
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_30.convertString(src.getNameElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((org.hl7.fhir.dstu3.model.Enumeration)VersionConvertor_10_30.convertConformanceResourceStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_10_30.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasPublisherElement()) {
            tgt.setPublisherElement(VersionConvertor_10_30.convertString(src.getPublisherElement()));
        }
        for (ImplementationGuide.ImplementationGuideContactComponent implementationGuideContactComponent : src.getContact()) {
            tgt.addContact(ImplementationGuide10_30.convertImplementationGuideContactComponent(implementationGuideContactComponent));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_10_30.convertDateTime(src.getDateElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (CodeableConcept codeableConcept : src.getUseContext()) {
            if (VersionConvertor_10_30.isJurisdiction(codeableConcept)) {
                tgt.addJurisdiction(VersionConvertor_10_30.convertCodeableConcept(codeableConcept));
                continue;
            }
            tgt.addUseContext(VersionConvertor_10_30.convertCodeableConceptToUsageContext(codeableConcept));
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        if (src.hasFhirVersionElement()) {
            tgt.setFhirVersionElement(VersionConvertor_10_30.convertId(src.getFhirVersionElement()));
        }
        for (ImplementationGuide.ImplementationGuideDependencyComponent implementationGuideDependencyComponent : src.getDependency()) {
            tgt.addDependency(ImplementationGuide10_30.convertImplementationGuideDependencyComponent(implementationGuideDependencyComponent));
        }
        for (ImplementationGuide.ImplementationGuidePackageComponent implementationGuidePackageComponent : src.getPackage()) {
            tgt.addPackage(ImplementationGuide10_30.convertImplementationGuidePackageComponent(implementationGuidePackageComponent));
        }
        for (ImplementationGuide.ImplementationGuideGlobalComponent implementationGuideGlobalComponent : src.getGlobal()) {
            tgt.addGlobal(ImplementationGuide10_30.convertImplementationGuideGlobalComponent(implementationGuideGlobalComponent));
        }
        for (org.hl7.fhir.dstu2.model.UriType uriType : src.getBinary()) {
            tgt.addBinary((String)uriType.getValue());
        }
        if (src.hasPage()) {
            tgt.setPage(ImplementationGuide10_30.convertImplementationGuidePageComponent(src.getPage()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.ImplementationGuide convertImplementationGuide(ImplementationGuide src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.ImplementationGuide tgt = new org.hl7.fhir.dstu2.model.ImplementationGuide();
        VersionConvertor_10_30.copyDomainResource(src, tgt);
        if (src.hasUrlElement()) {
            tgt.setUrlElement(VersionConvertor_10_30.convertUri(src.getUrlElement()));
        }
        if (src.hasVersionElement()) {
            tgt.setVersionElement(VersionConvertor_10_30.convertString(src.getVersionElement()));
        }
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_30.convertString(src.getNameElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(VersionConvertor_10_30.convertConformanceResourceStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_10_30.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasPublisherElement()) {
            tgt.setPublisherElement(VersionConvertor_10_30.convertString(src.getPublisherElement()));
        }
        for (ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(ImplementationGuide10_30.convertImplementationGuideContactComponent(contactDetail));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_10_30.convertDateTime(src.getDateElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (UsageContext usageContext : src.getUseContext()) {
            if (!usageContext.hasValueCodeableConcept()) continue;
            tgt.addUseContext(VersionConvertor_10_30.convertCodeableConcept(usageContext.getValueCodeableConcept()));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addUseContext(VersionConvertor_10_30.convertCodeableConcept(codeableConcept));
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        if (src.hasFhirVersionElement()) {
            tgt.setFhirVersionElement(VersionConvertor_10_30.convertId(src.getFhirVersionElement()));
        }
        for (ImplementationGuide.ImplementationGuideDependencyComponent implementationGuideDependencyComponent : src.getDependency()) {
            tgt.addDependency(ImplementationGuide10_30.convertImplementationGuideDependencyComponent(implementationGuideDependencyComponent));
        }
        for (ImplementationGuide.ImplementationGuidePackageComponent implementationGuidePackageComponent : src.getPackage()) {
            tgt.addPackage(ImplementationGuide10_30.convertImplementationGuidePackageComponent(implementationGuidePackageComponent));
        }
        for (ImplementationGuide.ImplementationGuideGlobalComponent implementationGuideGlobalComponent : src.getGlobal()) {
            tgt.addGlobal(ImplementationGuide10_30.convertImplementationGuideGlobalComponent(implementationGuideGlobalComponent));
        }
        for (UriType uriType : src.getBinary()) {
            tgt.addBinary((String)uriType.getValue());
        }
        if (src.hasPage()) {
            tgt.setPage(ImplementationGuide10_30.convertImplementationGuidePageComponent(src.getPage()));
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuideContactComponent convertImplementationGuideContactComponent(ContactDetail src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ImplementationGuide.ImplementationGuideContactComponent tgt = new ImplementationGuide.ImplementationGuideContactComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_30.convertString(src.getNameElement()));
        }
        for (ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_10_30.convertContactPoint(t));
        }
        return tgt;
    }

    public static ContactDetail convertImplementationGuideContactComponent(ImplementationGuide.ImplementationGuideContactComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ContactDetail tgt = new ContactDetail();
        VersionConvertor_10_30.copyElement(src, tgt);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_30.convertString(src.getNameElement()));
        }
        for (org.hl7.fhir.dstu2.model.ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_10_30.convertContactPoint(t));
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuideDependencyComponent convertImplementationGuideDependencyComponent(ImplementationGuide.ImplementationGuideDependencyComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ImplementationGuide.ImplementationGuideDependencyComponent tgt = new ImplementationGuide.ImplementationGuideDependencyComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasType()) {
            tgt.setTypeElement(ImplementationGuide10_30.convertGuideDependencyType(src.getTypeElement()));
        }
        if (src.hasUriElement()) {
            tgt.setUriElement(VersionConvertor_10_30.convertUri(src.getUriElement()));
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuideDependencyComponent convertImplementationGuideDependencyComponent(ImplementationGuide.ImplementationGuideDependencyComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ImplementationGuide.ImplementationGuideDependencyComponent tgt = new ImplementationGuide.ImplementationGuideDependencyComponent();
        VersionConvertor_10_30.copyElement(src, tgt);
        if (src.hasType()) {
            tgt.setTypeElement(ImplementationGuide10_30.convertGuideDependencyType(src.getTypeElement()));
        }
        if (src.hasUriElement()) {
            tgt.setUriElement(VersionConvertor_10_30.convertUri(src.getUriElement()));
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuideGlobalComponent convertImplementationGuideGlobalComponent(ImplementationGuide.ImplementationGuideGlobalComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ImplementationGuide.ImplementationGuideGlobalComponent tgt = new ImplementationGuide.ImplementationGuideGlobalComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasTypeElement()) {
            tgt.setTypeElement(VersionConvertor_10_30.convertCode(src.getTypeElement()));
        }
        if (src.hasProfile()) {
            tgt.setProfile(VersionConvertor_10_30.convertReference(src.getProfile()));
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuideGlobalComponent convertImplementationGuideGlobalComponent(ImplementationGuide.ImplementationGuideGlobalComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ImplementationGuide.ImplementationGuideGlobalComponent tgt = new ImplementationGuide.ImplementationGuideGlobalComponent();
        VersionConvertor_10_30.copyElement(src, tgt);
        if (src.hasTypeElement()) {
            tgt.setTypeElement(VersionConvertor_10_30.convertCode(src.getTypeElement()));
        }
        if (src.hasProfile()) {
            tgt.setProfile(VersionConvertor_10_30.convertReference(src.getProfile()));
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuidePackageComponent convertImplementationGuidePackageComponent(ImplementationGuide.ImplementationGuidePackageComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ImplementationGuide.ImplementationGuidePackageComponent tgt = new ImplementationGuide.ImplementationGuidePackageComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_30.convertString(src.getNameElement()));
        }
        if (src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_10_30.convertString(src.getDescriptionElement()));
        }
        for (ImplementationGuide.ImplementationGuidePackageResourceComponent t : src.getResource()) {
            tgt.addResource(ImplementationGuide10_30.convertImplementationGuidePackageResourceComponent(t));
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuidePackageComponent convertImplementationGuidePackageComponent(ImplementationGuide.ImplementationGuidePackageComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ImplementationGuide.ImplementationGuidePackageComponent tgt = new ImplementationGuide.ImplementationGuidePackageComponent();
        VersionConvertor_10_30.copyElement(src, tgt);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_30.convertString(src.getNameElement()));
        }
        if (src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_10_30.convertString(src.getDescriptionElement()));
        }
        for (ImplementationGuide.ImplementationGuidePackageResourceComponent t : src.getResource()) {
            tgt.addResource(ImplementationGuide10_30.convertImplementationGuidePackageResourceComponent(t));
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuidePackageResourceComponent convertImplementationGuidePackageResourceComponent(ImplementationGuide.ImplementationGuidePackageResourceComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ImplementationGuide.ImplementationGuidePackageResourceComponent tgt = new ImplementationGuide.ImplementationGuidePackageResourceComponent();
        VersionConvertor_10_30.copyElement(src, tgt);
        tgt.setExample(src.getPurpose() == ImplementationGuide.GuideResourcePurpose.EXAMPLE);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_30.convertString(src.getNameElement()));
        }
        if (src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_10_30.convertString(src.getDescriptionElement()));
        }
        if (src.hasAcronymElement()) {
            tgt.setAcronymElement(VersionConvertor_10_30.convertString(src.getAcronymElement()));
        }
        if (src.hasSource()) {
            tgt.setSource(VersionConvertor_10_30.convertType(src.getSource()));
        }
        if (src.hasExampleFor()) {
            tgt.setExampleFor(VersionConvertor_10_30.convertReference(src.getExampleFor()));
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuidePackageResourceComponent convertImplementationGuidePackageResourceComponent(ImplementationGuide.ImplementationGuidePackageResourceComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ImplementationGuide.ImplementationGuidePackageResourceComponent tgt = new ImplementationGuide.ImplementationGuidePackageResourceComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.getExample()) {
            tgt.setPurpose(ImplementationGuide.GuideResourcePurpose.EXAMPLE);
        } else {
            tgt.setPurpose(ImplementationGuide.GuideResourcePurpose.PROFILE);
        }
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_30.convertString(src.getNameElement()));
        }
        if (src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_10_30.convertString(src.getDescriptionElement()));
        }
        if (src.hasAcronymElement()) {
            tgt.setAcronymElement(VersionConvertor_10_30.convertString(src.getAcronymElement()));
        }
        if (src.hasSource()) {
            tgt.setSource(VersionConvertor_10_30.convertType(src.getSource()));
        }
        if (src.hasExampleFor()) {
            tgt.setExampleFor(VersionConvertor_10_30.convertReference(src.getExampleFor()));
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuidePageComponent convertImplementationGuidePageComponent(ImplementationGuide.ImplementationGuidePageComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ImplementationGuide.ImplementationGuidePageComponent tgt = new ImplementationGuide.ImplementationGuidePageComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasSourceElement()) {
            tgt.setSourceElement(VersionConvertor_10_30.convertUri(src.getSourceElement()));
        }
        if (src.hasTitleElement()) {
            tgt.setNameElement(VersionConvertor_10_30.convertString(src.getTitleElement()));
        }
        if (src.hasKind()) {
            tgt.setKindElement(ImplementationGuide10_30.convertGuidePageKind(src.getKindElement()));
        }
        for (org.hl7.fhir.dstu3.model.CodeType codeType : src.getType()) {
            tgt.addType((String)codeType.getValue());
        }
        for (org.hl7.fhir.dstu3.model.StringType stringType : src.getPackage()) {
            tgt.addPackage((String)stringType.getValue());
        }
        if (src.hasFormatElement()) {
            tgt.setFormatElement(VersionConvertor_10_30.convertCode(src.getFormatElement()));
        }
        for (ImplementationGuide.ImplementationGuidePageComponent implementationGuidePageComponent : src.getPage()) {
            tgt.addPage(ImplementationGuide10_30.convertImplementationGuidePageComponent(implementationGuidePageComponent));
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuidePageComponent convertImplementationGuidePageComponent(ImplementationGuide.ImplementationGuidePageComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ImplementationGuide.ImplementationGuidePageComponent tgt = new ImplementationGuide.ImplementationGuidePageComponent();
        VersionConvertor_10_30.copyElement(src, tgt);
        if (src.hasSourceElement()) {
            tgt.setSourceElement(VersionConvertor_10_30.convertUri(src.getSourceElement()));
        }
        if (src.hasNameElement()) {
            tgt.setTitleElement(VersionConvertor_10_30.convertString(src.getNameElement()));
        }
        if (src.hasKind()) {
            tgt.setKindElement(ImplementationGuide10_30.convertGuidePageKind(src.getKindElement()));
        }
        for (CodeType codeType : src.getType()) {
            tgt.addType((String)codeType.getValue());
        }
        for (StringType stringType : src.getPackage()) {
            tgt.addPackage((String)stringType.getValue());
        }
        if (src.hasFormatElement()) {
            tgt.setFormatElement(VersionConvertor_10_30.convertCode(src.getFormatElement()));
        }
        for (ImplementationGuide.ImplementationGuidePageComponent implementationGuidePageComponent : src.getPage()) {
            tgt.addPage(ImplementationGuide10_30.convertImplementationGuidePageComponent(implementationGuidePageComponent));
        }
        return tgt;
    }
}

