/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_30;

import org.hl7.fhir.convertors.VersionConvertor_10_30;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.ImagingStudy;
import org.hl7.fhir.dstu3.model.Coding;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.ImagingStudy;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.exceptions.FHIRException;

public class ImagingStudy10_30 {
    public static ImagingStudy convertImagingStudy(org.hl7.fhir.dstu2.model.ImagingStudy src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ImagingStudy tgt = new ImagingStudy();
        VersionConvertor_10_30.copyDomainResource(src, tgt);
        if (src.hasUidElement()) {
            tgt.setUidElement(VersionConvertor_10_30.convertOid(src.getUidElement()));
        }
        if (src.hasAccession()) {
            tgt.setAccession(VersionConvertor_10_30.convertIdentifier(src.getAccession()));
        }
        for (org.hl7.fhir.dstu2.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_30.convertIdentifier(identifier));
        }
        if (src.hasAvailability()) {
            tgt.setAvailabilityElement(ImagingStudy10_30.convertInstanceAvailability(src.getAvailabilityElement()));
        }
        for (org.hl7.fhir.dstu2.model.Coding coding : src.getModalityList()) {
            tgt.addModalityList(VersionConvertor_10_30.convertCoding(coding));
        }
        if (src.hasPatient()) {
            tgt.setPatient(VersionConvertor_10_30.convertReference(src.getPatient()));
        }
        if (src.hasStartedElement()) {
            tgt.setStartedElement(VersionConvertor_10_30.convertDateTime(src.getStartedElement()));
        }
        if (src.hasReferrer()) {
            tgt.setReferrer(VersionConvertor_10_30.convertReference(src.getReferrer()));
        }
        if (src.hasInterpreter()) {
            tgt.addInterpreter(VersionConvertor_10_30.convertReference(src.getInterpreter()));
        }
        if (src.hasNumberOfSeriesElement()) {
            tgt.setNumberOfSeriesElement(VersionConvertor_10_30.convertUnsignedInt(src.getNumberOfSeriesElement()));
        }
        if (src.hasNumberOfInstancesElement()) {
            tgt.setNumberOfInstancesElement(VersionConvertor_10_30.convertUnsignedInt(src.getNumberOfInstancesElement()));
        }
        for (org.hl7.fhir.dstu2.model.Reference reference : src.getProcedure()) {
            tgt.addProcedureReference(VersionConvertor_10_30.convertReference(reference));
        }
        if (src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_10_30.convertString(src.getDescriptionElement()));
        }
        for (ImagingStudy.ImagingStudySeriesComponent imagingStudySeriesComponent : src.getSeries()) {
            tgt.addSeries(ImagingStudy10_30.convertImagingStudySeriesComponent(imagingStudySeriesComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.ImagingStudy convertImagingStudy(ImagingStudy src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.ImagingStudy tgt = new org.hl7.fhir.dstu2.model.ImagingStudy();
        VersionConvertor_10_30.copyDomainResource(src, tgt);
        if (src.hasUidElement()) {
            tgt.setUidElement(VersionConvertor_10_30.convertOid(src.getUidElement()));
        }
        if (src.hasAccession()) {
            tgt.setAccession(VersionConvertor_10_30.convertIdentifier(src.getAccession()));
        }
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_30.convertIdentifier(identifier));
        }
        if (src.hasAvailability()) {
            tgt.setAvailabilityElement(ImagingStudy10_30.convertInstanceAvailability(src.getAvailabilityElement()));
        }
        for (Coding coding : src.getModalityList()) {
            tgt.addModalityList(VersionConvertor_10_30.convertCoding(coding));
        }
        if (src.hasPatient()) {
            tgt.setPatient(VersionConvertor_10_30.convertReference(src.getPatient()));
        }
        if (src.hasStartedElement()) {
            tgt.setStartedElement(VersionConvertor_10_30.convertDateTime(src.getStartedElement()));
        }
        if (src.hasReferrer()) {
            tgt.setReferrer(VersionConvertor_10_30.convertReference(src.getReferrer()));
        }
        for (Reference reference : src.getInterpreter()) {
            tgt.setInterpreter(VersionConvertor_10_30.convertReference(reference));
        }
        if (src.hasNumberOfSeriesElement()) {
            tgt.setNumberOfSeriesElement(VersionConvertor_10_30.convertUnsignedInt(src.getNumberOfSeriesElement()));
        }
        if (src.hasNumberOfInstancesElement()) {
            tgt.setNumberOfInstancesElement(VersionConvertor_10_30.convertUnsignedInt(src.getNumberOfInstancesElement()));
        }
        for (Reference reference : src.getProcedureReference()) {
            tgt.addProcedure(VersionConvertor_10_30.convertReference(reference));
        }
        if (src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_10_30.convertString(src.getDescriptionElement()));
        }
        for (ImagingStudy.ImagingStudySeriesComponent imagingStudySeriesComponent : src.getSeries()) {
            tgt.addSeries(ImagingStudy10_30.convertImagingStudySeriesComponent(imagingStudySeriesComponent));
        }
        return tgt;
    }

    public static ImagingStudy.ImagingStudySeriesComponent convertImagingStudySeriesComponent(ImagingStudy.ImagingStudySeriesComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ImagingStudy.ImagingStudySeriesComponent tgt = new ImagingStudy.ImagingStudySeriesComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasUidElement()) {
            tgt.setUidElement(VersionConvertor_10_30.convertOid(src.getUidElement()));
        }
        if (src.hasNumberElement()) {
            tgt.setNumberElement(VersionConvertor_10_30.convertUnsignedInt(src.getNumberElement()));
        }
        if (src.hasModality()) {
            tgt.setModality(VersionConvertor_10_30.convertCoding(src.getModality()));
        }
        if (src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_10_30.convertString(src.getDescriptionElement()));
        }
        if (src.hasNumberOfInstancesElement()) {
            tgt.setNumberOfInstancesElement(VersionConvertor_10_30.convertUnsignedInt(src.getNumberOfInstancesElement()));
        }
        if (src.hasAvailability()) {
            tgt.setAvailabilityElement(ImagingStudy10_30.convertInstanceAvailability(src.getAvailabilityElement()));
        }
        if (src.hasBodySite()) {
            tgt.setBodySite(VersionConvertor_10_30.convertCoding(src.getBodySite()));
        }
        if (src.hasLaterality()) {
            tgt.setLaterality(VersionConvertor_10_30.convertCoding(src.getLaterality()));
        }
        if (src.hasStartedElement()) {
            tgt.setStartedElement(VersionConvertor_10_30.convertDateTime(src.getStartedElement()));
        }
        for (ImagingStudy.ImagingStudySeriesInstanceComponent t : src.getInstance()) {
            tgt.addInstance(ImagingStudy10_30.convertImagingStudySeriesInstanceComponent(t));
        }
        return tgt;
    }

    public static ImagingStudy.ImagingStudySeriesComponent convertImagingStudySeriesComponent(ImagingStudy.ImagingStudySeriesComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ImagingStudy.ImagingStudySeriesComponent tgt = new ImagingStudy.ImagingStudySeriesComponent();
        VersionConvertor_10_30.copyElement(src, tgt);
        if (src.hasUidElement()) {
            tgt.setUidElement(VersionConvertor_10_30.convertOid(src.getUidElement()));
        }
        if (src.hasNumberElement()) {
            tgt.setNumberElement(VersionConvertor_10_30.convertUnsignedInt(src.getNumberElement()));
        }
        if (src.hasModality()) {
            tgt.setModality(VersionConvertor_10_30.convertCoding(src.getModality()));
        }
        if (src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_10_30.convertString(src.getDescriptionElement()));
        }
        if (src.hasNumberOfInstancesElement()) {
            tgt.setNumberOfInstancesElement(VersionConvertor_10_30.convertUnsignedInt(src.getNumberOfInstancesElement()));
        }
        if (src.hasAvailability()) {
            tgt.setAvailabilityElement(ImagingStudy10_30.convertInstanceAvailability(src.getAvailabilityElement()));
        }
        if (src.hasBodySite()) {
            tgt.setBodySite(VersionConvertor_10_30.convertCoding(src.getBodySite()));
        }
        if (src.hasLaterality()) {
            tgt.setLaterality(VersionConvertor_10_30.convertCoding(src.getLaterality()));
        }
        if (src.hasStartedElement()) {
            tgt.setStartedElement(VersionConvertor_10_30.convertDateTime(src.getStartedElement()));
        }
        for (ImagingStudy.ImagingStudySeriesInstanceComponent t : src.getInstance()) {
            tgt.addInstance(ImagingStudy10_30.convertImagingStudySeriesInstanceComponent(t));
        }
        return tgt;
    }

    public static ImagingStudy.ImagingStudySeriesInstanceComponent convertImagingStudySeriesInstanceComponent(ImagingStudy.ImagingStudySeriesInstanceComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ImagingStudy.ImagingStudySeriesInstanceComponent tgt = new ImagingStudy.ImagingStudySeriesInstanceComponent();
        VersionConvertor_10_30.copyElement(src, tgt);
        if (src.hasUidElement()) {
            tgt.setUidElement(VersionConvertor_10_30.convertOid(src.getUidElement()));
        }
        if (src.hasNumberElement()) {
            tgt.setNumberElement(VersionConvertor_10_30.convertUnsignedInt(src.getNumberElement()));
        }
        if (src.hasSopClassElement()) {
            tgt.setSopClassElement(VersionConvertor_10_30.convertOid(src.getSopClassElement()));
        }
        if (src.hasTitleElement()) {
            tgt.setTitleElement(VersionConvertor_10_30.convertString(src.getTitleElement()));
        }
        return tgt;
    }

    public static ImagingStudy.ImagingStudySeriesInstanceComponent convertImagingStudySeriesInstanceComponent(ImagingStudy.ImagingStudySeriesInstanceComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ImagingStudy.ImagingStudySeriesInstanceComponent tgt = new ImagingStudy.ImagingStudySeriesInstanceComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasUidElement()) {
            tgt.setUidElement(VersionConvertor_10_30.convertOid(src.getUidElement()));
        }
        if (src.hasNumberElement()) {
            tgt.setNumberElement(VersionConvertor_10_30.convertUnsignedInt(src.getNumberElement()));
        }
        if (src.hasSopClassElement()) {
            tgt.setSopClassElement(VersionConvertor_10_30.convertOid(src.getSopClassElement()));
        }
        if (src.hasTitleElement()) {
            tgt.setTitleElement(VersionConvertor_10_30.convertString(src.getTitleElement()));
        }
        return tgt;
    }

    public static Enumeration<ImagingStudy.InstanceAvailability> convertInstanceAvailability(org.hl7.fhir.dstu3.model.Enumeration<ImagingStudy.InstanceAvailability> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ImagingStudy.InstanceAvailability> tgt = new Enumeration<ImagingStudy.InstanceAvailability>(new ImagingStudy.InstanceAvailabilityEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        switch ((ImagingStudy.InstanceAvailability)((Object)src.getValue())) {
            case ONLINE: {
                tgt.setValue((Object)ImagingStudy.InstanceAvailability.ONLINE);
                break;
            }
            case OFFLINE: {
                tgt.setValue((Object)ImagingStudy.InstanceAvailability.OFFLINE);
                break;
            }
            case NEARLINE: {
                tgt.setValue((Object)ImagingStudy.InstanceAvailability.NEARLINE);
                break;
            }
            case UNAVAILABLE: {
                tgt.setValue((Object)ImagingStudy.InstanceAvailability.UNAVAILABLE);
                break;
            }
            default: {
                tgt.setValue((Object)ImagingStudy.InstanceAvailability.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<ImagingStudy.InstanceAvailability> convertInstanceAvailability(Enumeration<ImagingStudy.InstanceAvailability> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<ImagingStudy.InstanceAvailability> tgt = new org.hl7.fhir.dstu3.model.Enumeration<ImagingStudy.InstanceAvailability>(new ImagingStudy.InstanceAvailabilityEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        switch ((ImagingStudy.InstanceAvailability)((Object)src.getValue())) {
            case ONLINE: {
                tgt.setValue((Object)ImagingStudy.InstanceAvailability.ONLINE);
                break;
            }
            case OFFLINE: {
                tgt.setValue((Object)ImagingStudy.InstanceAvailability.OFFLINE);
                break;
            }
            case NEARLINE: {
                tgt.setValue((Object)ImagingStudy.InstanceAvailability.NEARLINE);
                break;
            }
            case UNAVAILABLE: {
                tgt.setValue((Object)ImagingStudy.InstanceAvailability.UNAVAILABLE);
                break;
            }
            default: {
                tgt.setValue((Object)ImagingStudy.InstanceAvailability.NULL);
            }
        }
        return tgt;
    }
}

