/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_30;

import java.util.ArrayList;
import org.hl7.fhir.convertors.VersionConvertor_10_30;
import org.hl7.fhir.dstu2.model.CodeableConcept;
import org.hl7.fhir.dstu2.model.DataElement;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu3.model.ContactDetail;
import org.hl7.fhir.dstu3.model.ContactPoint;
import org.hl7.fhir.dstu3.model.DataElement;
import org.hl7.fhir.dstu3.model.ElementDefinition;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.UsageContext;
import org.hl7.fhir.exceptions.FHIRException;

public class DataElement10_30 {
    public static org.hl7.fhir.dstu2.model.DataElement convertDataElement(DataElement src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.DataElement tgt = new org.hl7.fhir.dstu2.model.DataElement();
        VersionConvertor_10_30.copyDomainResource(src, tgt);
        if (src.hasUrlElement()) {
            tgt.setUrlElement(VersionConvertor_10_30.convertUri(src.getUrlElement()));
        }
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_30.convertIdentifier(identifier));
        }
        if (src.hasVersionElement()) {
            tgt.setVersionElement(VersionConvertor_10_30.convertString(src.getVersionElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(VersionConvertor_10_30.convertConformanceResourceStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_10_30.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasPublisherElement()) {
            tgt.setPublisherElement(VersionConvertor_10_30.convertString(src.getPublisherElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_10_30.convertDateTime(src.getDateElement()));
        }
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_30.convertString(src.getNameElement()));
        }
        for (ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(DataElement10_30.convertDataElementContactComponent(contactDetail));
        }
        for (UsageContext usageContext : src.getUseContext()) {
            if (!usageContext.hasValueCodeableConcept()) continue;
            tgt.addUseContext(VersionConvertor_10_30.convertCodeableConcept(usageContext.getValueCodeableConcept()));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addUseContext(VersionConvertor_10_30.convertCodeableConcept(codeableConcept));
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        if (src.hasStringency()) {
            tgt.setStringencyElement(DataElement10_30.convertDataElementStringency(src.getStringencyElement()));
        }
        for (DataElement.DataElementMappingComponent dataElementMappingComponent : src.getMapping()) {
            tgt.addMapping(DataElement10_30.convertDataElementMappingComponent(dataElementMappingComponent));
        }
        for (ElementDefinition elementDefinition : src.getElement()) {
            tgt.addElement(VersionConvertor_10_30.convertElementDefinition(elementDefinition));
        }
        return tgt;
    }

    public static DataElement convertDataElement(org.hl7.fhir.dstu2.model.DataElement src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        DataElement tgt = new DataElement();
        VersionConvertor_10_30.copyDomainResource(src, tgt);
        if (src.hasUrlElement()) {
            tgt.setUrlElement(VersionConvertor_10_30.convertUri(src.getUrlElement()));
        }
        for (org.hl7.fhir.dstu2.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_30.convertIdentifier(identifier));
        }
        if (src.hasVersionElement()) {
            tgt.setVersionElement(VersionConvertor_10_30.convertString(src.getVersionElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((org.hl7.fhir.dstu3.model.Enumeration)VersionConvertor_10_30.convertConformanceResourceStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_10_30.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasPublisherElement()) {
            tgt.setPublisherElement(VersionConvertor_10_30.convertString(src.getPublisherElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_10_30.convertDateTime(src.getDateElement()));
        }
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_30.convertString(src.getNameElement()));
        }
        for (DataElement.DataElementContactComponent dataElementContactComponent : src.getContact()) {
            tgt.addContact(DataElement10_30.convertDataElementContactComponent(dataElementContactComponent));
        }
        for (CodeableConcept codeableConcept : src.getUseContext()) {
            if (VersionConvertor_10_30.isJurisdiction(codeableConcept)) {
                tgt.addJurisdiction(VersionConvertor_10_30.convertCodeableConcept(codeableConcept));
                continue;
            }
            tgt.addUseContext(VersionConvertor_10_30.convertCodeableConceptToUsageContext(codeableConcept));
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        if (src.hasStringency()) {
            tgt.setStringencyElement(DataElement10_30.convertDataElementStringency(src.getStringencyElement()));
        }
        for (DataElement.DataElementMappingComponent dataElementMappingComponent : src.getMapping()) {
            tgt.addMapping(DataElement10_30.convertDataElementMappingComponent(dataElementMappingComponent));
        }
        ArrayList<String> slicePaths = new ArrayList<String>();
        for (org.hl7.fhir.dstu2.model.ElementDefinition t : src.getElement()) {
            if (t.hasSlicing()) {
                slicePaths.add(t.getPath());
            }
            tgt.addElement(VersionConvertor_10_30.convertElementDefinition(t, slicePaths));
        }
        return tgt;
    }

    public static ContactDetail convertDataElementContactComponent(DataElement.DataElementContactComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ContactDetail tgt = new ContactDetail();
        VersionConvertor_10_30.copyElement(src, tgt);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_30.convertString(src.getNameElement()));
        }
        for (org.hl7.fhir.dstu2.model.ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_10_30.convertContactPoint(t));
        }
        return tgt;
    }

    public static DataElement.DataElementContactComponent convertDataElementContactComponent(ContactDetail src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        DataElement.DataElementContactComponent tgt = new DataElement.DataElementContactComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_30.convertString(src.getNameElement()));
        }
        for (ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_10_30.convertContactPoint(t));
        }
        return tgt;
    }

    public static DataElement.DataElementMappingComponent convertDataElementMappingComponent(DataElement.DataElementMappingComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        DataElement.DataElementMappingComponent tgt = new DataElement.DataElementMappingComponent();
        VersionConvertor_10_30.copyElement(src, tgt);
        if (src.hasIdentityElement()) {
            tgt.setIdentityElement(VersionConvertor_10_30.convertId(src.getIdentityElement()));
        }
        if (src.hasUriElement()) {
            tgt.setUriElement(VersionConvertor_10_30.convertUri(src.getUriElement()));
        }
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_30.convertString(src.getNameElement()));
        }
        if (src.hasCommentsElement()) {
            tgt.setCommentElement(VersionConvertor_10_30.convertString(src.getCommentsElement()));
        }
        return tgt;
    }

    public static DataElement.DataElementMappingComponent convertDataElementMappingComponent(DataElement.DataElementMappingComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        DataElement.DataElementMappingComponent tgt = new DataElement.DataElementMappingComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasIdentityElement()) {
            tgt.setIdentityElement(VersionConvertor_10_30.convertId(src.getIdentityElement()));
        }
        if (src.hasUriElement()) {
            tgt.setUriElement(VersionConvertor_10_30.convertUri(src.getUriElement()));
        }
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_30.convertString(src.getNameElement()));
        }
        if (src.hasCommentElement()) {
            tgt.setCommentsElement(VersionConvertor_10_30.convertString(src.getCommentElement()));
        }
        return tgt;
    }

    public static Enumeration<DataElement.DataElementStringency> convertDataElementStringency(org.hl7.fhir.dstu3.model.Enumeration<DataElement.DataElementStringency> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<DataElement.DataElementStringency> tgt = new Enumeration<DataElement.DataElementStringency>(new DataElement.DataElementStringencyEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        switch ((DataElement.DataElementStringency)((Object)src.getValue())) {
            case COMPARABLE: {
                tgt.setValue((Object)DataElement.DataElementStringency.COMPARABLE);
                break;
            }
            case FULLYSPECIFIED: {
                tgt.setValue((Object)DataElement.DataElementStringency.FULLYSPECIFIED);
                break;
            }
            case EQUIVALENT: {
                tgt.setValue((Object)DataElement.DataElementStringency.EQUIVALENT);
                break;
            }
            case CONVERTABLE: {
                tgt.setValue((Object)DataElement.DataElementStringency.CONVERTABLE);
                break;
            }
            case SCALEABLE: {
                tgt.setValue((Object)DataElement.DataElementStringency.SCALEABLE);
                break;
            }
            case FLEXIBLE: {
                tgt.setValue((Object)DataElement.DataElementStringency.FLEXIBLE);
                break;
            }
            default: {
                tgt.setValue((Object)DataElement.DataElementStringency.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<DataElement.DataElementStringency> convertDataElementStringency(Enumeration<DataElement.DataElementStringency> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<DataElement.DataElementStringency> tgt = new org.hl7.fhir.dstu3.model.Enumeration<DataElement.DataElementStringency>(new DataElement.DataElementStringencyEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        switch ((DataElement.DataElementStringency)((Object)src.getValue())) {
            case COMPARABLE: {
                tgt.setValue((Object)DataElement.DataElementStringency.COMPARABLE);
                break;
            }
            case FULLYSPECIFIED: {
                tgt.setValue((Object)DataElement.DataElementStringency.FULLYSPECIFIED);
                break;
            }
            case EQUIVALENT: {
                tgt.setValue((Object)DataElement.DataElementStringency.EQUIVALENT);
                break;
            }
            case CONVERTABLE: {
                tgt.setValue((Object)DataElement.DataElementStringency.CONVERTABLE);
                break;
            }
            case SCALEABLE: {
                tgt.setValue((Object)DataElement.DataElementStringency.SCALEABLE);
                break;
            }
            case FLEXIBLE: {
                tgt.setValue((Object)DataElement.DataElementStringency.FLEXIBLE);
                break;
            }
            default: {
                tgt.setValue((Object)DataElement.DataElementStringency.NULL);
            }
        }
        return tgt;
    }
}

