/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_30;

import org.apache.commons.codec.binary.Base64;
import org.hl7.fhir.convertors.VersionConvertor_10_30;
import org.hl7.fhir.dstu2.model.CodeableConcept;
import org.hl7.fhir.dstu2.model.Contract;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu3.model.Contract;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.Signature;
import org.hl7.fhir.exceptions.FHIRException;

public class Contract10_30 {
    public static Contract.AgentComponent convertAgentComponent(Contract.ActorComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Contract.AgentComponent tgt = new Contract.AgentComponent();
        VersionConvertor_10_30.copyElement(src, tgt);
        if (src.hasEntity()) {
            tgt.setActor(VersionConvertor_10_30.convertReference(src.getEntity()));
        }
        for (CodeableConcept t : src.getRole()) {
            tgt.addRole(VersionConvertor_10_30.convertCodeableConcept(t));
        }
        return tgt;
    }

    public static Contract.ActorComponent convertAgentComponent(Contract.AgentComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Contract.ActorComponent tgt = new Contract.ActorComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasActor()) {
            tgt.setEntity(VersionConvertor_10_30.convertReference(src.getActor()));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept t : src.getRole()) {
            tgt.addRole(VersionConvertor_10_30.convertCodeableConcept(t));
        }
        return tgt;
    }

    public static Contract.ComputableLanguageComponent convertComputableLanguageComponent(Contract.ComputableLanguageComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Contract.ComputableLanguageComponent tgt = new Contract.ComputableLanguageComponent();
        VersionConvertor_10_30.copyElement(src, tgt);
        if (src.hasContent()) {
            tgt.setContent(VersionConvertor_10_30.convertType(src.getContent()));
        }
        return tgt;
    }

    public static Contract.ComputableLanguageComponent convertComputableLanguageComponent(Contract.ComputableLanguageComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Contract.ComputableLanguageComponent tgt = new Contract.ComputableLanguageComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasContent()) {
            tgt.setContent(VersionConvertor_10_30.convertType(src.getContent()));
        }
        return tgt;
    }

    public static Contract convertContract(org.hl7.fhir.dstu3.model.Contract src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Contract tgt = new Contract();
        VersionConvertor_10_30.copyDomainResource(src, tgt);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_10_30.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasIssuedElement()) {
            tgt.setIssuedElement(VersionConvertor_10_30.convertDateTime(src.getIssuedElement()));
        }
        if (src.hasApplies()) {
            tgt.setApplies(VersionConvertor_10_30.convertPeriod(src.getApplies()));
        }
        for (Reference reference : src.getSubject()) {
            tgt.addSubject(VersionConvertor_10_30.convertReference(reference));
        }
        for (Reference reference : src.getAuthority()) {
            tgt.addAuthority(VersionConvertor_10_30.convertReference(reference));
        }
        for (Reference reference : src.getDomain()) {
            tgt.addDomain(VersionConvertor_10_30.convertReference(reference));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_10_30.convertCodeableConcept(src.getType()));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getSubType()) {
            tgt.addSubType(VersionConvertor_10_30.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getAction()) {
            tgt.addAction(VersionConvertor_10_30.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getActionReason()) {
            tgt.addActionReason(VersionConvertor_10_30.convertCodeableConcept(codeableConcept));
        }
        for (Contract.AgentComponent agentComponent : src.getAgent()) {
            tgt.addActor(Contract10_30.convertAgentComponent(agentComponent));
        }
        for (Contract.SignatoryComponent signatoryComponent : src.getSigner()) {
            tgt.addSigner(Contract10_30.convertSignatoryComponent(signatoryComponent));
        }
        for (Contract.ValuedItemComponent valuedItemComponent : src.getValuedItem()) {
            tgt.addValuedItem(Contract10_30.convertValuedItemComponent(valuedItemComponent));
        }
        for (Contract.TermComponent termComponent : src.getTerm()) {
            tgt.addTerm(Contract10_30.convertTermComponent(termComponent));
        }
        if (src.hasBinding()) {
            tgt.setBinding(VersionConvertor_10_30.convertType(src.getBinding()));
        }
        for (Contract.FriendlyLanguageComponent friendlyLanguageComponent : src.getFriendly()) {
            tgt.addFriendly(Contract10_30.convertFriendlyLanguageComponent(friendlyLanguageComponent));
        }
        for (Contract.LegalLanguageComponent legalLanguageComponent : src.getLegal()) {
            tgt.addLegal(Contract10_30.convertLegalLanguageComponent(legalLanguageComponent));
        }
        for (Contract.ComputableLanguageComponent computableLanguageComponent : src.getRule()) {
            tgt.addRule(Contract10_30.convertComputableLanguageComponent(computableLanguageComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Contract convertContract(Contract src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Contract tgt = new org.hl7.fhir.dstu3.model.Contract();
        VersionConvertor_10_30.copyDomainResource(src, tgt);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_10_30.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasIssuedElement()) {
            tgt.setIssuedElement(VersionConvertor_10_30.convertDateTime(src.getIssuedElement()));
        }
        if (src.hasApplies()) {
            tgt.setApplies(VersionConvertor_10_30.convertPeriod(src.getApplies()));
        }
        for (org.hl7.fhir.dstu2.model.Reference reference : src.getSubject()) {
            tgt.addSubject(VersionConvertor_10_30.convertReference(reference));
        }
        for (org.hl7.fhir.dstu2.model.Reference reference : src.getAuthority()) {
            tgt.addAuthority(VersionConvertor_10_30.convertReference(reference));
        }
        for (org.hl7.fhir.dstu2.model.Reference reference : src.getDomain()) {
            tgt.addDomain(VersionConvertor_10_30.convertReference(reference));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_10_30.convertCodeableConcept(src.getType()));
        }
        for (CodeableConcept codeableConcept : src.getSubType()) {
            tgt.addSubType(VersionConvertor_10_30.convertCodeableConcept(codeableConcept));
        }
        for (CodeableConcept codeableConcept : src.getAction()) {
            tgt.addAction(VersionConvertor_10_30.convertCodeableConcept(codeableConcept));
        }
        for (CodeableConcept codeableConcept : src.getActionReason()) {
            tgt.addActionReason(VersionConvertor_10_30.convertCodeableConcept(codeableConcept));
        }
        for (Contract.ActorComponent actorComponent : src.getActor()) {
            tgt.addAgent(Contract10_30.convertAgentComponent(actorComponent));
        }
        for (Contract.SignatoryComponent signatoryComponent : src.getSigner()) {
            tgt.addSigner(Contract10_30.convertSignatoryComponent(signatoryComponent));
        }
        for (Contract.ValuedItemComponent valuedItemComponent : src.getValuedItem()) {
            tgt.addValuedItem(Contract10_30.convertValuedItemComponent(valuedItemComponent));
        }
        for (Contract.TermComponent termComponent : src.getTerm()) {
            tgt.addTerm(Contract10_30.convertTermComponent(termComponent));
        }
        if (src.hasBinding()) {
            tgt.setBinding(VersionConvertor_10_30.convertType(src.getBinding()));
        }
        for (Contract.FriendlyLanguageComponent friendlyLanguageComponent : src.getFriendly()) {
            tgt.addFriendly(Contract10_30.convertFriendlyLanguageComponent(friendlyLanguageComponent));
        }
        for (Contract.LegalLanguageComponent legalLanguageComponent : src.getLegal()) {
            tgt.addLegal(Contract10_30.convertLegalLanguageComponent(legalLanguageComponent));
        }
        for (Contract.ComputableLanguageComponent computableLanguageComponent : src.getRule()) {
            tgt.addRule(Contract10_30.convertComputableLanguageComponent(computableLanguageComponent));
        }
        return tgt;
    }

    public static Contract.FriendlyLanguageComponent convertFriendlyLanguageComponent(Contract.FriendlyLanguageComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Contract.FriendlyLanguageComponent tgt = new Contract.FriendlyLanguageComponent();
        VersionConvertor_10_30.copyElement(src, tgt);
        if (src.hasContent()) {
            tgt.setContent(VersionConvertor_10_30.convertType(src.getContent()));
        }
        return tgt;
    }

    public static Contract.FriendlyLanguageComponent convertFriendlyLanguageComponent(Contract.FriendlyLanguageComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Contract.FriendlyLanguageComponent tgt = new Contract.FriendlyLanguageComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasContent()) {
            tgt.setContent(VersionConvertor_10_30.convertType(src.getContent()));
        }
        return tgt;
    }

    public static Contract.LegalLanguageComponent convertLegalLanguageComponent(Contract.LegalLanguageComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Contract.LegalLanguageComponent tgt = new Contract.LegalLanguageComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasContent()) {
            tgt.setContent(VersionConvertor_10_30.convertType(src.getContent()));
        }
        return tgt;
    }

    public static Contract.LegalLanguageComponent convertLegalLanguageComponent(Contract.LegalLanguageComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Contract.LegalLanguageComponent tgt = new Contract.LegalLanguageComponent();
        VersionConvertor_10_30.copyElement(src, tgt);
        if (src.hasContent()) {
            tgt.setContent(VersionConvertor_10_30.convertType(src.getContent()));
        }
        return tgt;
    }

    public static Contract.SignatoryComponent convertSignatoryComponent(Contract.SignatoryComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Contract.SignatoryComponent tgt = new Contract.SignatoryComponent();
        VersionConvertor_10_30.copyElement(src, tgt);
        if (src.hasType()) {
            tgt.setType(VersionConvertor_10_30.convertCoding(src.getType()));
        }
        if (src.hasParty()) {
            tgt.setParty(VersionConvertor_10_30.convertReference(src.getParty()));
        }
        if (src.hasSignature()) {
            tgt.addSignature(new Signature().setBlob(src.getSignature().getBytes()));
        }
        return tgt;
    }

    public static Contract.SignatoryComponent convertSignatoryComponent(Contract.SignatoryComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Contract.SignatoryComponent tgt = new Contract.SignatoryComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasType()) {
            tgt.setType(VersionConvertor_10_30.convertCoding(src.getType()));
        }
        if (src.hasParty()) {
            tgt.setParty(VersionConvertor_10_30.convertReference(src.getParty()));
        }
        for (Signature t : src.getSignature()) {
            tgt.setSignature(Base64.encodeBase64String(t.getBlob()));
        }
        return tgt;
    }

    public static Contract.TermActorComponent convertTermAgentComponent(Contract.TermAgentComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Contract.TermActorComponent tgt = new Contract.TermActorComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasActor()) {
            tgt.setEntity(VersionConvertor_10_30.convertReference(src.getActor()));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept t : src.getRole()) {
            tgt.addRole(VersionConvertor_10_30.convertCodeableConcept(t));
        }
        return tgt;
    }

    public static Contract.TermAgentComponent convertTermAgentComponent(Contract.TermActorComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Contract.TermAgentComponent tgt = new Contract.TermAgentComponent();
        VersionConvertor_10_30.copyElement(src, tgt);
        if (src.hasEntity()) {
            tgt.setActor(VersionConvertor_10_30.convertReference(src.getEntity()));
        }
        for (CodeableConcept t : src.getRole()) {
            tgt.addRole(VersionConvertor_10_30.convertCodeableConcept(t));
        }
        return tgt;
    }

    public static Contract.TermComponent convertTermComponent(Contract.TermComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Contract.TermComponent tgt = new Contract.TermComponent();
        VersionConvertor_10_30.copyElement(src, tgt);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_10_30.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasIssuedElement()) {
            tgt.setIssuedElement(VersionConvertor_10_30.convertDateTime(src.getIssuedElement()));
        }
        if (src.hasApplies()) {
            tgt.setApplies(VersionConvertor_10_30.convertPeriod(src.getApplies()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_10_30.convertCodeableConcept(src.getType()));
        }
        if (src.hasSubType()) {
            tgt.setSubType(VersionConvertor_10_30.convertCodeableConcept(src.getSubType()));
        }
        for (CodeableConcept codeableConcept : src.getAction()) {
            tgt.addAction(VersionConvertor_10_30.convertCodeableConcept(codeableConcept));
        }
        for (CodeableConcept codeableConcept : src.getActionReason()) {
            tgt.addActionReason(VersionConvertor_10_30.convertCodeableConcept(codeableConcept));
        }
        for (Contract.TermActorComponent termActorComponent : src.getActor()) {
            tgt.addAgent(Contract10_30.convertTermAgentComponent(termActorComponent));
        }
        if (src.hasTextElement()) {
            tgt.setTextElement(VersionConvertor_10_30.convertString(src.getTextElement()));
        }
        for (Contract.TermValuedItemComponent termValuedItemComponent : src.getValuedItem()) {
            tgt.addValuedItem(Contract10_30.convertTermValuedItemComponent(termValuedItemComponent));
        }
        for (Contract.TermComponent termComponent : src.getGroup()) {
            tgt.addGroup(Contract10_30.convertTermComponent(termComponent));
        }
        return tgt;
    }

    public static Contract.TermComponent convertTermComponent(Contract.TermComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Contract.TermComponent tgt = new Contract.TermComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_10_30.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasIssuedElement()) {
            tgt.setIssuedElement(VersionConvertor_10_30.convertDateTime(src.getIssuedElement()));
        }
        if (src.hasApplies()) {
            tgt.setApplies(VersionConvertor_10_30.convertPeriod(src.getApplies()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_10_30.convertCodeableConcept(src.getType()));
        }
        if (src.hasSubType()) {
            tgt.setSubType(VersionConvertor_10_30.convertCodeableConcept(src.getSubType()));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getAction()) {
            tgt.addAction(VersionConvertor_10_30.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getActionReason()) {
            tgt.addActionReason(VersionConvertor_10_30.convertCodeableConcept(codeableConcept));
        }
        for (Contract.TermAgentComponent termAgentComponent : src.getAgent()) {
            tgt.addActor(Contract10_30.convertTermAgentComponent(termAgentComponent));
        }
        if (src.hasTextElement()) {
            tgt.setTextElement(VersionConvertor_10_30.convertString(src.getTextElement()));
        }
        for (Contract.TermValuedItemComponent termValuedItemComponent : src.getValuedItem()) {
            tgt.addValuedItem(Contract10_30.convertTermValuedItemComponent(termValuedItemComponent));
        }
        for (Contract.TermComponent termComponent : src.getGroup()) {
            tgt.addGroup(Contract10_30.convertTermComponent(termComponent));
        }
        return tgt;
    }

    public static Contract.TermValuedItemComponent convertTermValuedItemComponent(Contract.TermValuedItemComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Contract.TermValuedItemComponent tgt = new Contract.TermValuedItemComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasEntity()) {
            tgt.setEntity(VersionConvertor_10_30.convertType(src.getEntity()));
        }
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_10_30.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasEffectiveTimeElement()) {
            tgt.setEffectiveTimeElement(VersionConvertor_10_30.convertDateTime(src.getEffectiveTimeElement()));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(VersionConvertor_10_30.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasUnitPrice()) {
            tgt.setUnitPrice(VersionConvertor_10_30.convertMoney(src.getUnitPrice()));
        }
        if (src.hasFactorElement()) {
            tgt.setFactorElement(VersionConvertor_10_30.convertDecimal(src.getFactorElement()));
        }
        if (src.hasPointsElement()) {
            tgt.setPointsElement(VersionConvertor_10_30.convertDecimal(src.getPointsElement()));
        }
        if (src.hasNet()) {
            tgt.setNet(VersionConvertor_10_30.convertMoney(src.getNet()));
        }
        return tgt;
    }

    public static Contract.TermValuedItemComponent convertTermValuedItemComponent(Contract.TermValuedItemComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Contract.TermValuedItemComponent tgt = new Contract.TermValuedItemComponent();
        VersionConvertor_10_30.copyElement(src, tgt);
        if (src.hasEntity()) {
            tgt.setEntity(VersionConvertor_10_30.convertType(src.getEntity()));
        }
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_10_30.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasEffectiveTimeElement()) {
            tgt.setEffectiveTimeElement(VersionConvertor_10_30.convertDateTime(src.getEffectiveTimeElement()));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(VersionConvertor_10_30.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasUnitPrice()) {
            tgt.setUnitPrice(VersionConvertor_10_30.convertMoney(src.getUnitPrice()));
        }
        if (src.hasFactorElement()) {
            tgt.setFactorElement(VersionConvertor_10_30.convertDecimal(src.getFactorElement()));
        }
        if (src.hasPointsElement()) {
            tgt.setPointsElement(VersionConvertor_10_30.convertDecimal(src.getPointsElement()));
        }
        if (src.hasNet()) {
            tgt.setNet(VersionConvertor_10_30.convertMoney(src.getNet()));
        }
        return tgt;
    }

    public static Contract.ValuedItemComponent convertValuedItemComponent(Contract.ValuedItemComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Contract.ValuedItemComponent tgt = new Contract.ValuedItemComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasEntity()) {
            tgt.setEntity(VersionConvertor_10_30.convertType(src.getEntity()));
        }
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_10_30.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasEffectiveTimeElement()) {
            tgt.setEffectiveTimeElement(VersionConvertor_10_30.convertDateTime(src.getEffectiveTimeElement()));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(VersionConvertor_10_30.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasUnitPrice()) {
            tgt.setUnitPrice(VersionConvertor_10_30.convertMoney(src.getUnitPrice()));
        }
        if (src.hasFactorElement()) {
            tgt.setFactorElement(VersionConvertor_10_30.convertDecimal(src.getFactorElement()));
        }
        if (src.hasPointsElement()) {
            tgt.setPointsElement(VersionConvertor_10_30.convertDecimal(src.getPointsElement()));
        }
        if (src.hasNet()) {
            tgt.setNet(VersionConvertor_10_30.convertMoney(src.getNet()));
        }
        return tgt;
    }

    public static Contract.ValuedItemComponent convertValuedItemComponent(Contract.ValuedItemComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Contract.ValuedItemComponent tgt = new Contract.ValuedItemComponent();
        VersionConvertor_10_30.copyElement(src, tgt);
        if (src.hasEntity()) {
            tgt.setEntity(VersionConvertor_10_30.convertType(src.getEntity()));
        }
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_10_30.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasEffectiveTimeElement()) {
            tgt.setEffectiveTimeElement(VersionConvertor_10_30.convertDateTime(src.getEffectiveTimeElement()));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(VersionConvertor_10_30.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasUnitPrice()) {
            tgt.setUnitPrice(VersionConvertor_10_30.convertMoney(src.getUnitPrice()));
        }
        if (src.hasFactorElement()) {
            tgt.setFactorElement(VersionConvertor_10_30.convertDecimal(src.getFactorElement()));
        }
        if (src.hasPointsElement()) {
            tgt.setPointsElement(VersionConvertor_10_30.convertDecimal(src.getPointsElement()));
        }
        if (src.hasNet()) {
            tgt.setNet(VersionConvertor_10_30.convertMoney(src.getNet()));
        }
        return tgt;
    }
}

