/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors;

import java.math.BigDecimal;
import java.util.Date;
import java.util.stream.Collectors;
import org.hl7.fhir.convertors.conv40_50.Account40_50;
import org.hl7.fhir.convertors.conv40_50.ActivityDefinition40_50;
import org.hl7.fhir.convertors.conv40_50.AllergyIntolerance40_50;
import org.hl7.fhir.convertors.conv40_50.Appointment40_50;
import org.hl7.fhir.convertors.conv40_50.AppointmentResponse40_50;
import org.hl7.fhir.convertors.conv40_50.AuditEvent40_50;
import org.hl7.fhir.convertors.conv40_50.Basic40_50;
import org.hl7.fhir.convertors.conv40_50.Binary40_50;
import org.hl7.fhir.convertors.conv40_50.BiologicallyDerivedProduct40_50;
import org.hl7.fhir.convertors.conv40_50.BodyStructure40_50;
import org.hl7.fhir.convertors.conv40_50.Bundle40_50;
import org.hl7.fhir.convertors.conv40_50.CapabilityStatement40_50;
import org.hl7.fhir.convertors.conv40_50.CarePlan40_50;
import org.hl7.fhir.convertors.conv40_50.CareTeam40_50;
import org.hl7.fhir.convertors.conv40_50.ChargeItem40_50;
import org.hl7.fhir.convertors.conv40_50.ChargeItemDefinition40_50;
import org.hl7.fhir.convertors.conv40_50.Claim40_50;
import org.hl7.fhir.convertors.conv40_50.ClaimResponse40_50;
import org.hl7.fhir.convertors.conv40_50.ClinicalImpression40_50;
import org.hl7.fhir.convertors.conv40_50.CodeSystem40_50;
import org.hl7.fhir.convertors.conv40_50.Communication40_50;
import org.hl7.fhir.convertors.conv40_50.CommunicationRequest40_50;
import org.hl7.fhir.convertors.conv40_50.CompartmentDefinition40_50;
import org.hl7.fhir.convertors.conv40_50.Composition40_50;
import org.hl7.fhir.convertors.conv40_50.ConceptMap40_50;
import org.hl7.fhir.convertors.conv40_50.Condition40_50;
import org.hl7.fhir.convertors.conv40_50.Consent40_50;
import org.hl7.fhir.convertors.conv40_50.Contract40_50;
import org.hl7.fhir.convertors.conv40_50.Coverage40_50;
import org.hl7.fhir.convertors.conv40_50.CoverageEligibilityRequest40_50;
import org.hl7.fhir.convertors.conv40_50.CoverageEligibilityResponse40_50;
import org.hl7.fhir.convertors.conv40_50.DetectedIssue40_50;
import org.hl7.fhir.convertors.conv40_50.Device40_50;
import org.hl7.fhir.convertors.conv40_50.DeviceDefinition40_50;
import org.hl7.fhir.convertors.conv40_50.DeviceMetric40_50;
import org.hl7.fhir.convertors.conv40_50.DeviceRequest40_50;
import org.hl7.fhir.convertors.conv40_50.DeviceUseStatement40_50;
import org.hl7.fhir.convertors.conv40_50.DiagnosticReport40_50;
import org.hl7.fhir.convertors.conv40_50.DocumentManifest40_50;
import org.hl7.fhir.convertors.conv40_50.DocumentReference40_50;
import org.hl7.fhir.convertors.conv40_50.Encounter40_50;
import org.hl7.fhir.convertors.conv40_50.Endpoint40_50;
import org.hl7.fhir.convertors.conv40_50.EnrollmentRequest40_50;
import org.hl7.fhir.convertors.conv40_50.EnrollmentResponse40_50;
import org.hl7.fhir.convertors.conv40_50.Enumerations40_50;
import org.hl7.fhir.convertors.conv40_50.EpisodeOfCare40_50;
import org.hl7.fhir.convertors.conv40_50.EventDefinition40_50;
import org.hl7.fhir.convertors.conv40_50.ExampleScenario40_50;
import org.hl7.fhir.convertors.conv40_50.ExplanationOfBenefit40_50;
import org.hl7.fhir.convertors.conv40_50.FamilyMemberHistory40_50;
import org.hl7.fhir.convertors.conv40_50.Flag40_50;
import org.hl7.fhir.convertors.conv40_50.Goal40_50;
import org.hl7.fhir.convertors.conv40_50.GraphDefinition40_50;
import org.hl7.fhir.convertors.conv40_50.Group40_50;
import org.hl7.fhir.convertors.conv40_50.GuidanceResponse40_50;
import org.hl7.fhir.convertors.conv40_50.HealthcareService40_50;
import org.hl7.fhir.convertors.conv40_50.ImagingStudy40_50;
import org.hl7.fhir.convertors.conv40_50.Immunization40_50;
import org.hl7.fhir.convertors.conv40_50.ImmunizationEvaluation40_50;
import org.hl7.fhir.convertors.conv40_50.ImmunizationRecommendation40_50;
import org.hl7.fhir.convertors.conv40_50.ImplementationGuide40_50;
import org.hl7.fhir.convertors.conv40_50.InsurancePlan40_50;
import org.hl7.fhir.convertors.conv40_50.Invoice40_50;
import org.hl7.fhir.convertors.conv40_50.Library40_50;
import org.hl7.fhir.convertors.conv40_50.Linkage40_50;
import org.hl7.fhir.convertors.conv40_50.ListResource40_50;
import org.hl7.fhir.convertors.conv40_50.Location40_50;
import org.hl7.fhir.convertors.conv40_50.Measure40_50;
import org.hl7.fhir.convertors.conv40_50.MeasureReport40_50;
import org.hl7.fhir.convertors.conv40_50.Media40_50;
import org.hl7.fhir.convertors.conv40_50.Medication40_50;
import org.hl7.fhir.convertors.conv40_50.MedicationAdministration40_50;
import org.hl7.fhir.convertors.conv40_50.MedicationDispense40_50;
import org.hl7.fhir.convertors.conv40_50.MedicationKnowledge40_50;
import org.hl7.fhir.convertors.conv40_50.MedicationRequest40_50;
import org.hl7.fhir.convertors.conv40_50.MedicationStatement40_50;
import org.hl7.fhir.convertors.conv40_50.MedicinalProductDefinition40_50;
import org.hl7.fhir.convertors.conv40_50.MessageDefinition40_50;
import org.hl7.fhir.convertors.conv40_50.MessageHeader40_50;
import org.hl7.fhir.convertors.conv40_50.MolecularSequence40_50;
import org.hl7.fhir.convertors.conv40_50.NamingSystem40_50;
import org.hl7.fhir.convertors.conv40_50.NutritionOrder40_50;
import org.hl7.fhir.convertors.conv40_50.Observation40_50;
import org.hl7.fhir.convertors.conv40_50.ObservationDefinition40_50;
import org.hl7.fhir.convertors.conv40_50.OperationDefinition40_50;
import org.hl7.fhir.convertors.conv40_50.OperationOutcome40_50;
import org.hl7.fhir.convertors.conv40_50.Organization40_50;
import org.hl7.fhir.convertors.conv40_50.OrganizationAffiliation40_50;
import org.hl7.fhir.convertors.conv40_50.Parameters40_50;
import org.hl7.fhir.convertors.conv40_50.Patient40_50;
import org.hl7.fhir.convertors.conv40_50.PaymentNotice40_50;
import org.hl7.fhir.convertors.conv40_50.PaymentReconciliation40_50;
import org.hl7.fhir.convertors.conv40_50.Person40_50;
import org.hl7.fhir.convertors.conv40_50.PlanDefinition40_50;
import org.hl7.fhir.convertors.conv40_50.Practitioner40_50;
import org.hl7.fhir.convertors.conv40_50.PractitionerRole40_50;
import org.hl7.fhir.convertors.conv40_50.Procedure40_50;
import org.hl7.fhir.convertors.conv40_50.Provenance40_50;
import org.hl7.fhir.convertors.conv40_50.Questionnaire40_50;
import org.hl7.fhir.convertors.conv40_50.QuestionnaireResponse40_50;
import org.hl7.fhir.convertors.conv40_50.RelatedPerson40_50;
import org.hl7.fhir.convertors.conv40_50.RequestGroup40_50;
import org.hl7.fhir.convertors.conv40_50.ResearchStudy40_50;
import org.hl7.fhir.convertors.conv40_50.ResearchSubject40_50;
import org.hl7.fhir.convertors.conv40_50.RiskAssessment40_50;
import org.hl7.fhir.convertors.conv40_50.Schedule40_50;
import org.hl7.fhir.convertors.conv40_50.SearchParameter40_50;
import org.hl7.fhir.convertors.conv40_50.ServiceRequest40_50;
import org.hl7.fhir.convertors.conv40_50.Slot40_50;
import org.hl7.fhir.convertors.conv40_50.Specimen40_50;
import org.hl7.fhir.convertors.conv40_50.SpecimenDefinition40_50;
import org.hl7.fhir.convertors.conv40_50.StructureDefinition40_50;
import org.hl7.fhir.convertors.conv40_50.StructureMap40_50;
import org.hl7.fhir.convertors.conv40_50.Substance40_50;
import org.hl7.fhir.convertors.conv40_50.SubstanceNucleicAcid40_50;
import org.hl7.fhir.convertors.conv40_50.SubstancePolymer40_50;
import org.hl7.fhir.convertors.conv40_50.SubstanceProtein40_50;
import org.hl7.fhir.convertors.conv40_50.SubstanceReferenceInformation40_50;
import org.hl7.fhir.convertors.conv40_50.SubstanceSourceMaterial40_50;
import org.hl7.fhir.convertors.conv40_50.SupplyDelivery40_50;
import org.hl7.fhir.convertors.conv40_50.SupplyRequest40_50;
import org.hl7.fhir.convertors.conv40_50.Task40_50;
import org.hl7.fhir.convertors.conv40_50.TerminologyCapabilities40_50;
import org.hl7.fhir.convertors.conv40_50.TestReport40_50;
import org.hl7.fhir.convertors.conv40_50.TestScript40_50;
import org.hl7.fhir.convertors.conv40_50.ValueSet40_50;
import org.hl7.fhir.convertors.conv40_50.VerificationResult40_50;
import org.hl7.fhir.convertors.conv40_50.VisionPrescription40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Account;
import org.hl7.fhir.r4.model.Address;
import org.hl7.fhir.r4.model.Age;
import org.hl7.fhir.r4.model.AppointmentResponse;
import org.hl7.fhir.r4.model.Attachment;
import org.hl7.fhir.r4.model.BackboneElement;
import org.hl7.fhir.r4.model.Basic;
import org.hl7.fhir.r4.model.Binary;
import org.hl7.fhir.r4.model.BiologicallyDerivedProduct;
import org.hl7.fhir.r4.model.BodyStructure;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.ChargeItemDefinition;
import org.hl7.fhir.r4.model.Claim;
import org.hl7.fhir.r4.model.CodeSystem;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Communication;
import org.hl7.fhir.r4.model.Condition;
import org.hl7.fhir.r4.model.Consent;
import org.hl7.fhir.r4.model.ContactDetail;
import org.hl7.fhir.r4.model.ContactPoint;
import org.hl7.fhir.r4.model.Contract;
import org.hl7.fhir.r4.model.Contributor;
import org.hl7.fhir.r4.model.Coverage;
import org.hl7.fhir.r4.model.DataRequirement;
import org.hl7.fhir.r4.model.DateType;
import org.hl7.fhir.r4.model.DetectedIssue;
import org.hl7.fhir.r4.model.Device;
import org.hl7.fhir.r4.model.DeviceUseStatement;
import org.hl7.fhir.r4.model.Distance;
import org.hl7.fhir.r4.model.DocumentManifest;
import org.hl7.fhir.r4.model.Dosage;
import org.hl7.fhir.r4.model.Element;
import org.hl7.fhir.r4.model.ElementDefinition;
import org.hl7.fhir.r4.model.EnrollmentResponse;
import org.hl7.fhir.r4.model.EpisodeOfCare;
import org.hl7.fhir.r4.model.EventDefinition;
import org.hl7.fhir.r4.model.ExampleScenario;
import org.hl7.fhir.r4.model.Expression;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.Flag;
import org.hl7.fhir.r4.model.Goal;
import org.hl7.fhir.r4.model.GuidanceResponse;
import org.hl7.fhir.r4.model.HealthcareService;
import org.hl7.fhir.r4.model.HumanName;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Immunization;
import org.hl7.fhir.r4.model.ImmunizationRecommendation;
import org.hl7.fhir.r4.model.InstantType;
import org.hl7.fhir.r4.model.InsurancePlan;
import org.hl7.fhir.r4.model.Invoice;
import org.hl7.fhir.r4.model.Library;
import org.hl7.fhir.r4.model.ListResource;
import org.hl7.fhir.r4.model.Location;
import org.hl7.fhir.r4.model.Measure;
import org.hl7.fhir.r4.model.MeasureReport;
import org.hl7.fhir.r4.model.Media;
import org.hl7.fhir.r4.model.MedicationDispense;
import org.hl7.fhir.r4.model.MedicationStatement;
import org.hl7.fhir.r4.model.MedicinalProduct;
import org.hl7.fhir.r4.model.MessageDefinition;
import org.hl7.fhir.r4.model.MolecularSequence;
import org.hl7.fhir.r4.model.Narrative;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.OrganizationAffiliation;
import org.hl7.fhir.r4.model.ParameterDefinition;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.PaymentNotice;
import org.hl7.fhir.r4.model.PaymentReconciliation;
import org.hl7.fhir.r4.model.Period;
import org.hl7.fhir.r4.model.Person;
import org.hl7.fhir.r4.model.PlanDefinition;
import org.hl7.fhir.r4.model.PositiveIntType;
import org.hl7.fhir.r4.model.Procedure;
import org.hl7.fhir.r4.model.ProdCharacteristic;
import org.hl7.fhir.r4.model.ProductShelfLife;
import org.hl7.fhir.r4.model.Provenance;
import org.hl7.fhir.r4.model.Quantity;
import org.hl7.fhir.r4.model.RelatedArtifact;
import org.hl7.fhir.r4.model.ResearchStudy;
import org.hl7.fhir.r4.model.ResearchSubject;
import org.hl7.fhir.r4.model.RiskAssessment;
import org.hl7.fhir.r4.model.SampledData;
import org.hl7.fhir.r4.model.ServiceRequest;
import org.hl7.fhir.r4.model.Specimen;
import org.hl7.fhir.r4.model.SpecimenDefinition;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.StructureMap;
import org.hl7.fhir.r4.model.Substance;
import org.hl7.fhir.r4.model.SubstanceAmount;
import org.hl7.fhir.r4.model.SubstanceSourceMaterial;
import org.hl7.fhir.r4.model.Timing;
import org.hl7.fhir.r4.model.TriggerDefinition;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.r4.model.UnsignedIntType;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.r4.model.UsageContext;
import org.hl7.fhir.r4.model.UuidType;
import org.hl7.fhir.r4.model.VerificationResult;
import org.hl7.fhir.r4.model.VisionPrescription;
import org.hl7.fhir.r5.model.ActivityDefinition;
import org.hl7.fhir.r5.model.Address;
import org.hl7.fhir.r5.model.AllergyIntolerance;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.Appointment;
import org.hl7.fhir.r5.model.AuditEvent;
import org.hl7.fhir.r5.model.BackboneType;
import org.hl7.fhir.r5.model.Base64BinaryType;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.CarePlan;
import org.hl7.fhir.r5.model.CareTeam;
import org.hl7.fhir.r5.model.ChargeItem;
import org.hl7.fhir.r5.model.ClaimResponse;
import org.hl7.fhir.r5.model.ClinicalImpression;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.CommunicationRequest;
import org.hl7.fhir.r5.model.CompartmentDefinition;
import org.hl7.fhir.r5.model.Composition;
import org.hl7.fhir.r5.model.ConceptMap;
import org.hl7.fhir.r5.model.ContactPoint;
import org.hl7.fhir.r5.model.Contributor;
import org.hl7.fhir.r5.model.Count;
import org.hl7.fhir.r5.model.CoverageEligibilityRequest;
import org.hl7.fhir.r5.model.CoverageEligibilityResponse;
import org.hl7.fhir.r5.model.DataRequirement;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DecimalType;
import org.hl7.fhir.r5.model.DeviceDefinition;
import org.hl7.fhir.r5.model.DeviceMetric;
import org.hl7.fhir.r5.model.DeviceRequest;
import org.hl7.fhir.r5.model.DiagnosticReport;
import org.hl7.fhir.r5.model.DocumentReference;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Dosage;
import org.hl7.fhir.r5.model.Duration;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Encounter;
import org.hl7.fhir.r5.model.Endpoint;
import org.hl7.fhir.r5.model.EnrollmentRequest;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.ExplanationOfBenefit;
import org.hl7.fhir.r5.model.FamilyMemberHistory;
import org.hl7.fhir.r5.model.GraphDefinition;
import org.hl7.fhir.r5.model.Group;
import org.hl7.fhir.r5.model.HumanName;
import org.hl7.fhir.r5.model.IdType;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.ImagingStudy;
import org.hl7.fhir.r5.model.ImmunizationEvaluation;
import org.hl7.fhir.r5.model.ImplementationGuide;
import org.hl7.fhir.r5.model.Integer64Type;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.Linkage;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.MarketingStatus;
import org.hl7.fhir.r5.model.Medication;
import org.hl7.fhir.r5.model.MedicationAdministration;
import org.hl7.fhir.r5.model.MedicationKnowledge;
import org.hl7.fhir.r5.model.MedicationRequest;
import org.hl7.fhir.r5.model.MedicationUsage;
import org.hl7.fhir.r5.model.MedicinalProductDefinition;
import org.hl7.fhir.r5.model.MessageHeader;
import org.hl7.fhir.r5.model.Meta;
import org.hl7.fhir.r5.model.Money;
import org.hl7.fhir.r5.model.MoneyQuantity;
import org.hl7.fhir.r5.model.NamingSystem;
import org.hl7.fhir.r5.model.Narrative;
import org.hl7.fhir.r5.model.NutritionOrder;
import org.hl7.fhir.r5.model.Observation;
import org.hl7.fhir.r5.model.ObservationDefinition;
import org.hl7.fhir.r5.model.OidType;
import org.hl7.fhir.r5.model.OperationDefinition;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.ParameterDefinition;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.Population;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.Questionnaire;
import org.hl7.fhir.r5.model.QuestionnaireResponse;
import org.hl7.fhir.r5.model.Range;
import org.hl7.fhir.r5.model.Ratio;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RelatedArtifact;
import org.hl7.fhir.r5.model.RelatedPerson;
import org.hl7.fhir.r5.model.RequestGroup;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.Schedule;
import org.hl7.fhir.r5.model.SearchParameter;
import org.hl7.fhir.r5.model.Signature;
import org.hl7.fhir.r5.model.SimpleQuantity;
import org.hl7.fhir.r5.model.Slot;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.SubstanceAmount;
import org.hl7.fhir.r5.model.SubstanceNucleicAcid;
import org.hl7.fhir.r5.model.SubstancePolymer;
import org.hl7.fhir.r5.model.SubstanceProtein;
import org.hl7.fhir.r5.model.SubstanceReferenceInformation;
import org.hl7.fhir.r5.model.SupplyDelivery;
import org.hl7.fhir.r5.model.SupplyRequest;
import org.hl7.fhir.r5.model.Task;
import org.hl7.fhir.r5.model.TerminologyCapabilities;
import org.hl7.fhir.r5.model.TestReport;
import org.hl7.fhir.r5.model.TestScript;
import org.hl7.fhir.r5.model.TimeType;
import org.hl7.fhir.r5.model.Timing;
import org.hl7.fhir.r5.model.TriggerDefinition;
import org.hl7.fhir.r5.model.UrlType;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class VersionConvertor_40_50 {
    public static boolean isExemptExtension(String url, String[] extensionsToIgnore) {
        boolean ok = false;
        for (String s2 : extensionsToIgnore) {
            if (!s2.equals(url)) continue;
            ok = true;
        }
        return ok;
    }

    protected static void copyElement(Element src, org.hl7.fhir.r5.model.Element tgt, String ... extensionsToIgnore) throws FHIRException {
        if (src.hasId()) {
            tgt.setId(src.getId());
        }
        for (Extension e : src.getExtension()) {
            if (VersionConvertor_40_50.isExemptExtension(e.getUrl(), extensionsToIgnore)) continue;
            tgt.addExtension(VersionConvertor_40_50.convertExtension(e));
        }
    }

    protected static void copyElement(org.hl7.fhir.r5.model.Element src, Element tgt, String ... extensionsToIgnore) throws FHIRException {
        if (src.hasId()) {
            tgt.setId(src.getId());
        }
        for (org.hl7.fhir.r5.model.Extension e : src.getExtension()) {
            if (VersionConvertor_40_50.isExemptExtension(e.getUrl(), extensionsToIgnore)) continue;
            tgt.addExtension(VersionConvertor_40_50.convertExtension(e));
        }
    }

    protected static void copyEnumeration(org.hl7.fhir.r4.model.Enumeration<?> src, Enumeration<?> tgt) throws FHIRException {
        if (src.hasId()) {
            tgt.setId(src.getId());
        }
        for (Extension e : src.getExtension()) {
            tgt.addExtension(VersionConvertor_40_50.convertExtension(e));
        }
    }

    protected static void copyEnumeration(Enumeration<?> src, org.hl7.fhir.r4.model.Enumeration<?> tgt) throws FHIRException {
        if (src.hasId()) {
            tgt.setId(src.getId());
        }
        for (org.hl7.fhir.r5.model.Extension e : src.getExtension()) {
            tgt.addExtension(VersionConvertor_40_50.convertExtension(e));
        }
    }

    protected static void copyBackboneElement(BackboneElement src, org.hl7.fhir.r5.model.BackboneElement tgt) throws FHIRException {
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        for (Extension e : src.getModifierExtension()) {
            tgt.addModifierExtension(VersionConvertor_40_50.convertExtension(e));
        }
    }

    protected static void copyBackboneElement(org.hl7.fhir.r5.model.BackboneElement src, BackboneElement tgt) throws FHIRException {
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        for (org.hl7.fhir.r5.model.Extension e : src.getModifierExtension()) {
            tgt.addModifierExtension(VersionConvertor_40_50.convertExtension(e));
        }
    }

    protected static void copyBackboneElement(BackboneType src, org.hl7.fhir.r4.model.BackboneType tgt) throws FHIRException {
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        for (org.hl7.fhir.r5.model.Extension e : src.getModifierExtension()) {
            tgt.addModifierExtension(VersionConvertor_40_50.convertExtension(e));
        }
    }

    protected static void copyBackboneElement(org.hl7.fhir.r4.model.BackboneType src, BackboneType tgt) throws FHIRException {
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        for (Extension e : src.getModifierExtension()) {
            tgt.addModifierExtension(VersionConvertor_40_50.convertExtension(e));
        }
    }

    protected static XhtmlNode convertXhtml(XhtmlNode src) throws FHIRException {
        return src;
    }

    public static Base64BinaryType convertBase64Binary(org.hl7.fhir.r4.model.Base64BinaryType src) throws FHIRException {
        Base64BinaryType tgt = src.hasValue() ? new Base64BinaryType(src.getValue()) : new Base64BinaryType();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Base64BinaryType convertBase64Binary(Base64BinaryType src) throws FHIRException {
        org.hl7.fhir.r4.model.Base64BinaryType tgt = src.hasValue() ? new org.hl7.fhir.r4.model.Base64BinaryType(src.getValue()) : new org.hl7.fhir.r4.model.Base64BinaryType();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static BooleanType convertBoolean(org.hl7.fhir.r4.model.BooleanType src) throws FHIRException {
        BooleanType tgt = src.hasValue() ? new BooleanType((Boolean)src.getValue()) : new BooleanType();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.r4.model.BooleanType convertBoolean(BooleanType src) throws FHIRException {
        org.hl7.fhir.r4.model.BooleanType tgt = src.hasValue() ? new org.hl7.fhir.r4.model.BooleanType((Boolean)src.getValue()) : new org.hl7.fhir.r4.model.BooleanType();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static CanonicalType convertCanonical(org.hl7.fhir.r4.model.CanonicalType src) throws FHIRException {
        CanonicalType tgt = src.hasValue() ? new CanonicalType((String)src.getValue()) : new CanonicalType();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.r4.model.CanonicalType convertCanonical(CanonicalType src) throws FHIRException {
        org.hl7.fhir.r4.model.CanonicalType tgt = src.hasValue() ? new org.hl7.fhir.r4.model.CanonicalType((String)src.getValue()) : new org.hl7.fhir.r4.model.CanonicalType();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.r5.model.CodeType convertCode(CodeType src) throws FHIRException {
        org.hl7.fhir.r5.model.CodeType tgt = src.hasValue() ? new org.hl7.fhir.r5.model.CodeType((String)src.getValue()) : new org.hl7.fhir.r5.model.CodeType();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static CodeType convertCode(org.hl7.fhir.r5.model.CodeType src) throws FHIRException {
        CodeType tgt = src.hasValue() ? new CodeType((String)src.getValue()) : new CodeType();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.r5.model.DateType convertDate(DateType src) throws FHIRException {
        org.hl7.fhir.r5.model.DateType tgt = src.hasValue() ? new org.hl7.fhir.r5.model.DateType((Date)src.getValue()) : new org.hl7.fhir.r5.model.DateType();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static DateType convertDate(org.hl7.fhir.r5.model.DateType src) throws FHIRException {
        DateType tgt = src.hasValue() ? new DateType((Date)src.getValue()) : new DateType();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static DateTimeType convertDateTime(org.hl7.fhir.r4.model.DateTimeType src) throws FHIRException {
        DateTimeType tgt = src.hasValue() ? new DateTimeType((Date)src.getValue()) : new DateTimeType();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.r4.model.DateTimeType convertDateTime(DateTimeType src) throws FHIRException {
        org.hl7.fhir.r4.model.DateTimeType tgt = src.hasValue() ? new org.hl7.fhir.r4.model.DateTimeType((Date)src.getValue()) : new org.hl7.fhir.r4.model.DateTimeType();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static DecimalType convertDecimal(org.hl7.fhir.r4.model.DecimalType src) throws FHIRException {
        DecimalType tgt = src.hasValue() ? new DecimalType((BigDecimal)src.getValue()) : new DecimalType();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.r4.model.DecimalType convertDecimal(DecimalType src) throws FHIRException {
        org.hl7.fhir.r4.model.DecimalType tgt = src.hasValue() ? new org.hl7.fhir.r4.model.DecimalType((BigDecimal)src.getValue()) : new org.hl7.fhir.r4.model.DecimalType();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static IdType convertId(org.hl7.fhir.r4.model.IdType src) throws FHIRException {
        IdType tgt = src.hasValue() ? new IdType(src.getValue()) : new IdType();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.r4.model.IdType convertId(IdType src) throws FHIRException {
        org.hl7.fhir.r4.model.IdType tgt = src.hasValue() ? new org.hl7.fhir.r4.model.IdType(src.getValue()) : new org.hl7.fhir.r4.model.IdType();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.r5.model.InstantType convertInstant(InstantType src) throws FHIRException {
        org.hl7.fhir.r5.model.InstantType tgt = src.hasValue() ? new org.hl7.fhir.r5.model.InstantType((Date)src.getValue()) : new org.hl7.fhir.r5.model.InstantType();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static InstantType convertInstant(org.hl7.fhir.r5.model.InstantType src) throws FHIRException {
        InstantType tgt = src.hasValue() ? new InstantType((Date)src.getValue()) : new InstantType();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static IntegerType convertInteger(org.hl7.fhir.r4.model.IntegerType src) throws FHIRException {
        IntegerType tgt = src.hasValue() ? new IntegerType((Integer)src.getValue()) : new IntegerType();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static Integer64Type convertUnsignedIntToInteger64(UnsignedIntType src) throws FHIRException {
        Integer64Type tgt = src.hasValue() ? new Integer64Type((Long)((Object)((Integer)src.getValue()))) : new Integer64Type();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static UnsignedIntType convertInteger64ToUnsignedInt(Integer64Type src) throws FHIRException {
        UnsignedIntType tgt = src.hasValue() ? new UnsignedIntType(Math.toIntExact((Long)src.getValue())) : new UnsignedIntType();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.r4.model.IntegerType convertInteger(IntegerType src) throws FHIRException {
        org.hl7.fhir.r4.model.IntegerType tgt = src.hasValue() ? new org.hl7.fhir.r4.model.IntegerType((Integer)src.getValue()) : new org.hl7.fhir.r4.model.IntegerType();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static MarkdownType convertMarkdown(org.hl7.fhir.r4.model.MarkdownType src) throws FHIRException {
        MarkdownType tgt = src.hasValue() ? new MarkdownType((String)src.getValue()) : new MarkdownType();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.r4.model.MarkdownType convertMarkdown(MarkdownType src) throws FHIRException {
        org.hl7.fhir.r4.model.MarkdownType tgt = src.hasValue() ? new org.hl7.fhir.r4.model.MarkdownType((String)src.getValue()) : new org.hl7.fhir.r4.model.MarkdownType();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static OidType convertOid(org.hl7.fhir.r4.model.OidType src) throws FHIRException {
        OidType tgt = src.hasValue() ? new OidType((String)src.getValue()) : new OidType();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.r4.model.OidType convertOid(OidType src) throws FHIRException {
        org.hl7.fhir.r4.model.OidType tgt = src.hasValue() ? new org.hl7.fhir.r4.model.OidType((String)src.getValue()) : new org.hl7.fhir.r4.model.OidType();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.r5.model.PositiveIntType convertPositiveInt(PositiveIntType src) throws FHIRException {
        org.hl7.fhir.r5.model.PositiveIntType tgt = src.hasValue() ? new org.hl7.fhir.r5.model.PositiveIntType((Integer)src.getValue()) : new org.hl7.fhir.r5.model.PositiveIntType();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static PositiveIntType convertPositiveInt(org.hl7.fhir.r5.model.PositiveIntType src) throws FHIRException {
        PositiveIntType tgt = src.hasValue() ? new PositiveIntType((Integer)src.getValue()) : new PositiveIntType();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.r5.model.StringType convertString(StringType src) throws FHIRException {
        org.hl7.fhir.r5.model.StringType tgt = src.hasValue() ? new org.hl7.fhir.r5.model.StringType((String)src.getValue()) : new org.hl7.fhir.r5.model.StringType();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static StringType convertString(org.hl7.fhir.r5.model.StringType src) throws FHIRException {
        StringType tgt = src.hasValue() ? new StringType((String)src.getValue()) : new StringType();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static TimeType convertTime(org.hl7.fhir.r4.model.TimeType src) throws FHIRException {
        TimeType tgt = src.hasValue() ? new TimeType((String)src.getValue()) : new TimeType();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.r4.model.TimeType convertTime(TimeType src) throws FHIRException {
        org.hl7.fhir.r4.model.TimeType tgt = src.hasValue() ? new org.hl7.fhir.r4.model.TimeType((String)src.getValue()) : new org.hl7.fhir.r4.model.TimeType();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.r5.model.UnsignedIntType convertUnsignedInt(UnsignedIntType src) throws FHIRException {
        org.hl7.fhir.r5.model.UnsignedIntType tgt = src.hasValue() ? new org.hl7.fhir.r5.model.UnsignedIntType((Integer)src.getValue()) : new org.hl7.fhir.r5.model.UnsignedIntType();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static UnsignedIntType convertUnsignedInt(org.hl7.fhir.r5.model.UnsignedIntType src) throws FHIRException {
        UnsignedIntType tgt = src.hasValue() ? new UnsignedIntType((Integer)src.getValue()) : new UnsignedIntType();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.r5.model.UriType convertUri(UriType src) throws FHIRException {
        org.hl7.fhir.r5.model.UriType tgt = src.hasValue() ? new org.hl7.fhir.r5.model.UriType((String)src.getValue()) : new org.hl7.fhir.r5.model.UriType();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static UriType convertUri(org.hl7.fhir.r5.model.UriType src) throws FHIRException {
        UriType tgt = src.hasValue() ? new UriType((String)src.getValue()) : new UriType();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static UrlType convertUrl(org.hl7.fhir.r4.model.UrlType src) throws FHIRException {
        UrlType tgt = src.hasValue() ? new UrlType((String)src.getValue()) : new UrlType();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.r4.model.UrlType convertUrl(UrlType src) throws FHIRException {
        org.hl7.fhir.r4.model.UrlType tgt = src.hasValue() ? new org.hl7.fhir.r4.model.UrlType((String)src.getValue()) : new org.hl7.fhir.r4.model.UrlType();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.r5.model.UuidType convertUuid(UuidType src) throws FHIRException {
        org.hl7.fhir.r5.model.UuidType tgt = src.hasValue() ? new org.hl7.fhir.r5.model.UuidType((String)src.getValue()) : new org.hl7.fhir.r5.model.UuidType();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static UuidType convertUuid(org.hl7.fhir.r5.model.UuidType src) throws FHIRException {
        UuidType tgt = src.hasValue() ? new UuidType((String)src.getValue()) : new UuidType();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Extension convertExtension(Extension src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.Extension tgt = new org.hl7.fhir.r5.model.Extension();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_40_50.convertUri(src.getUrlElement()));
        }
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_40_50.convertType(src.getValue()));
        }
        return tgt;
    }

    public static Extension convertExtension(org.hl7.fhir.r5.model.Extension src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Extension tgt = new Extension();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_40_50.convertUri(src.getUrlElement()));
        }
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_40_50.convertType(src.getValue()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Narrative convertNarrative(Narrative src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.Narrative tgt = new org.hl7.fhir.r5.model.Narrative();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasStatus()) {
            tgt.setStatusElement(VersionConvertor_40_50.convertNarrativeStatus(src.getStatusElement()));
        }
        if (src.hasDiv()) {
            tgt.setDiv(VersionConvertor_40_50.convertXhtml(src.getDiv()));
        }
        return tgt;
    }

    public static Narrative convertNarrative(org.hl7.fhir.r5.model.Narrative src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Narrative tgt = new Narrative();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasStatus()) {
            tgt.setStatusElement(VersionConvertor_40_50.convertNarrativeStatus(src.getStatusElement()));
        }
        if (src.hasDiv()) {
            tgt.setDiv(VersionConvertor_40_50.convertXhtml(src.getDiv()));
        }
        return tgt;
    }

    public static Enumeration<Narrative.NarrativeStatus> convertNarrativeStatus(org.hl7.fhir.r4.model.Enumeration<Narrative.NarrativeStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Narrative.NarrativeStatus> tgt = new Enumeration<Narrative.NarrativeStatus>(new Narrative.NarrativeStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Narrative.NarrativeStatus)((Object)src.getValue())) {
            case GENERATED: {
                tgt.setValue((Object)Narrative.NarrativeStatus.GENERATED);
                break;
            }
            case EXTENSIONS: {
                tgt.setValue((Object)Narrative.NarrativeStatus.EXTENSIONS);
                break;
            }
            case ADDITIONAL: {
                tgt.setValue((Object)Narrative.NarrativeStatus.ADDITIONAL);
                break;
            }
            case EMPTY: {
                tgt.setValue((Object)Narrative.NarrativeStatus.EMPTY);
                break;
            }
            default: {
                tgt.setValue((Object)Narrative.NarrativeStatus.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Enumeration<Narrative.NarrativeStatus> convertNarrativeStatus(Enumeration<Narrative.NarrativeStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Enumeration<Narrative.NarrativeStatus> tgt = new org.hl7.fhir.r4.model.Enumeration<Narrative.NarrativeStatus>(new Narrative.NarrativeStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Narrative.NarrativeStatus)((Object)src.getValue())) {
            case GENERATED: {
                tgt.setValue((Object)Narrative.NarrativeStatus.GENERATED);
                break;
            }
            case EXTENSIONS: {
                tgt.setValue((Object)Narrative.NarrativeStatus.EXTENSIONS);
                break;
            }
            case ADDITIONAL: {
                tgt.setValue((Object)Narrative.NarrativeStatus.ADDITIONAL);
                break;
            }
            case EMPTY: {
                tgt.setValue((Object)Narrative.NarrativeStatus.EMPTY);
                break;
            }
            default: {
                tgt.setValue((Object)Narrative.NarrativeStatus.NULL);
            }
        }
        return tgt;
    }

    public static Address convertAddress(org.hl7.fhir.r4.model.Address src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Address tgt = new Address();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasUse()) {
            tgt.setUseElement(VersionConvertor_40_50.convertAddressUse(src.getUseElement()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(VersionConvertor_40_50.convertAddressType(src.getTypeElement()));
        }
        if (src.hasText()) {
            tgt.setTextElement(VersionConvertor_40_50.convertString(src.getTextElement()));
        }
        for (StringType t : src.getLine()) {
            tgt.getLine().add(VersionConvertor_40_50.convertString(t));
        }
        if (src.hasCity()) {
            tgt.setCityElement(VersionConvertor_40_50.convertString(src.getCityElement()));
        }
        if (src.hasDistrict()) {
            tgt.setDistrictElement(VersionConvertor_40_50.convertString(src.getDistrictElement()));
        }
        if (src.hasState()) {
            tgt.setStateElement(VersionConvertor_40_50.convertString(src.getStateElement()));
        }
        if (src.hasPostalCode()) {
            tgt.setPostalCodeElement(VersionConvertor_40_50.convertString(src.getPostalCodeElement()));
        }
        if (src.hasCountry()) {
            tgt.setCountryElement(VersionConvertor_40_50.convertString(src.getCountryElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_40_50.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Address convertAddress(Address src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.Address tgt = new org.hl7.fhir.r4.model.Address();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasUse()) {
            tgt.setUseElement(VersionConvertor_40_50.convertAddressUse(src.getUseElement()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(VersionConvertor_40_50.convertAddressType(src.getTypeElement()));
        }
        if (src.hasText()) {
            tgt.setTextElement(VersionConvertor_40_50.convertString(src.getTextElement()));
        }
        for (org.hl7.fhir.r5.model.StringType t : src.getLine()) {
            tgt.getLine().add(VersionConvertor_40_50.convertString(t));
        }
        if (src.hasCity()) {
            tgt.setCityElement(VersionConvertor_40_50.convertString(src.getCityElement()));
        }
        if (src.hasDistrict()) {
            tgt.setDistrictElement(VersionConvertor_40_50.convertString(src.getDistrictElement()));
        }
        if (src.hasState()) {
            tgt.setStateElement(VersionConvertor_40_50.convertString(src.getStateElement()));
        }
        if (src.hasPostalCode()) {
            tgt.setPostalCodeElement(VersionConvertor_40_50.convertString(src.getPostalCodeElement()));
        }
        if (src.hasCountry()) {
            tgt.setCountryElement(VersionConvertor_40_50.convertString(src.getCountryElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_40_50.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static Enumeration<Address.AddressUse> convertAddressUse(org.hl7.fhir.r4.model.Enumeration<Address.AddressUse> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Address.AddressUse> tgt = new Enumeration<Address.AddressUse>(new Address.AddressUseEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Address.AddressUse)((Object)src.getValue())) {
            case HOME: {
                tgt.setValue((Object)Address.AddressUse.HOME);
                break;
            }
            case WORK: {
                tgt.setValue((Object)Address.AddressUse.WORK);
                break;
            }
            case TEMP: {
                tgt.setValue((Object)Address.AddressUse.TEMP);
                break;
            }
            case OLD: {
                tgt.setValue((Object)Address.AddressUse.OLD);
                break;
            }
            case BILLING: {
                tgt.setValue((Object)Address.AddressUse.BILLING);
                break;
            }
            default: {
                tgt.setValue((Object)Address.AddressUse.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Enumeration<Address.AddressUse> convertAddressUse(Enumeration<Address.AddressUse> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Enumeration<Address.AddressUse> tgt = new org.hl7.fhir.r4.model.Enumeration<Address.AddressUse>(new Address.AddressUseEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Address.AddressUse)((Object)src.getValue())) {
            case HOME: {
                tgt.setValue((Object)Address.AddressUse.HOME);
                break;
            }
            case WORK: {
                tgt.setValue((Object)Address.AddressUse.WORK);
                break;
            }
            case TEMP: {
                tgt.setValue((Object)Address.AddressUse.TEMP);
                break;
            }
            case OLD: {
                tgt.setValue((Object)Address.AddressUse.OLD);
                break;
            }
            case BILLING: {
                tgt.setValue((Object)Address.AddressUse.BILLING);
                break;
            }
            default: {
                tgt.setValue((Object)Address.AddressUse.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Address.AddressType> convertAddressType(org.hl7.fhir.r4.model.Enumeration<Address.AddressType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Address.AddressType> tgt = new Enumeration<Address.AddressType>(new Address.AddressTypeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Address.AddressType)((Object)src.getValue())) {
            case POSTAL: {
                tgt.setValue((Object)Address.AddressType.POSTAL);
                break;
            }
            case PHYSICAL: {
                tgt.setValue((Object)Address.AddressType.PHYSICAL);
                break;
            }
            case BOTH: {
                tgt.setValue((Object)Address.AddressType.BOTH);
                break;
            }
            default: {
                tgt.setValue((Object)Address.AddressType.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Enumeration<Address.AddressType> convertAddressType(Enumeration<Address.AddressType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Enumeration<Address.AddressType> tgt = new org.hl7.fhir.r4.model.Enumeration<Address.AddressType>(new Address.AddressTypeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Address.AddressType)((Object)src.getValue())) {
            case POSTAL: {
                tgt.setValue((Object)Address.AddressType.POSTAL);
                break;
            }
            case PHYSICAL: {
                tgt.setValue((Object)Address.AddressType.PHYSICAL);
                break;
            }
            case BOTH: {
                tgt.setValue((Object)Address.AddressType.BOTH);
                break;
            }
            default: {
                tgt.setValue((Object)Address.AddressType.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Age convertAge(Age src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.Age tgt = new org.hl7.fhir.r5.model.Age();
        VersionConvertor_40_50.copyQuantity(src, tgt);
        return tgt;
    }

    public static Age convertAge(org.hl7.fhir.r5.model.Age src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Age tgt = new Age();
        VersionConvertor_40_50.copyQuantity(src, tgt);
        return tgt;
    }

    public static Annotation convertAnnotation(org.hl7.fhir.r4.model.Annotation src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Annotation tgt = new Annotation();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasAuthor()) {
            tgt.setAuthor(VersionConvertor_40_50.convertType(src.getAuthor()));
        }
        if (src.hasTime()) {
            tgt.setTimeElement(VersionConvertor_40_50.convertDateTime(src.getTimeElement()));
        }
        if (src.hasText()) {
            tgt.setTextElement(VersionConvertor_40_50.convertMarkdown(src.getTextElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Annotation convertAnnotation(Annotation src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.Annotation tgt = new org.hl7.fhir.r4.model.Annotation();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasAuthor()) {
            tgt.setAuthor(VersionConvertor_40_50.convertType(src.getAuthor()));
        }
        if (src.hasTime()) {
            tgt.setTimeElement(VersionConvertor_40_50.convertDateTime(src.getTimeElement()));
        }
        if (src.hasText()) {
            tgt.setTextElement(VersionConvertor_40_50.convertMarkdown(src.getTextElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Attachment convertAttachment(Attachment src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.Attachment tgt = new org.hl7.fhir.r5.model.Attachment();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasContentType()) {
            tgt.setContentTypeElement(VersionConvertor_40_50.convertCode(src.getContentTypeElement()));
        }
        if (src.hasLanguage()) {
            tgt.setLanguageElement(VersionConvertor_40_50.convertCode(src.getLanguageElement()));
        }
        if (src.hasData()) {
            tgt.setDataElement(VersionConvertor_40_50.convertBase64Binary(src.getDataElement()));
        }
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_40_50.convertUrl(src.getUrlElement()));
        }
        if (src.hasSize()) {
            tgt.setSizeElement(VersionConvertor_40_50.convertUnsignedIntToInteger64(src.getSizeElement()));
        }
        if (src.hasHash()) {
            tgt.setHashElement(VersionConvertor_40_50.convertBase64Binary(src.getHashElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(VersionConvertor_40_50.convertString(src.getTitleElement()));
        }
        if (src.hasCreation()) {
            tgt.setCreationElement(VersionConvertor_40_50.convertDateTime(src.getCreationElement()));
        }
        return tgt;
    }

    public static Attachment convertAttachment(org.hl7.fhir.r5.model.Attachment src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Attachment tgt = new Attachment();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasContentType()) {
            tgt.setContentTypeElement(VersionConvertor_40_50.convertCode(src.getContentTypeElement()));
        }
        if (src.hasLanguage()) {
            tgt.setLanguageElement(VersionConvertor_40_50.convertCode(src.getLanguageElement()));
        }
        if (src.hasData()) {
            tgt.setDataElement(VersionConvertor_40_50.convertBase64Binary(src.getDataElement()));
        }
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_40_50.convertUrl(src.getUrlElement()));
        }
        if (src.hasSize()) {
            tgt.setSizeElement(VersionConvertor_40_50.convertInteger64ToUnsignedInt(src.getSizeElement()));
        }
        if (src.hasHash()) {
            tgt.setHashElement(VersionConvertor_40_50.convertBase64Binary(src.getHashElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(VersionConvertor_40_50.convertString(src.getTitleElement()));
        }
        if (src.hasCreation()) {
            tgt.setCreationElement(VersionConvertor_40_50.convertDateTime(src.getCreationElement()));
        }
        return tgt;
    }

    public static CodeableConcept convertCodeableConcept(org.hl7.fhir.r4.model.CodeableConcept src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CodeableConcept tgt = new CodeableConcept();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        for (Coding t : src.getCoding()) {
            tgt.addCoding(VersionConvertor_40_50.convertCoding(t));
        }
        if (src.hasText()) {
            tgt.setTextElement(VersionConvertor_40_50.convertString(src.getTextElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.CodeableConcept convertCodeableConcept(CodeableConcept src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.CodeableConcept tgt = new org.hl7.fhir.r4.model.CodeableConcept();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        for (org.hl7.fhir.r5.model.Coding t : src.getCoding()) {
            tgt.addCoding(VersionConvertor_40_50.convertCoding(t));
        }
        if (src.hasText()) {
            tgt.setTextElement(VersionConvertor_40_50.convertString(src.getTextElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Coding convertCoding(Coding src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.Coding tgt = new org.hl7.fhir.r5.model.Coding();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_40_50.convertUri(src.getSystemElement()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_40_50.convertString(src.getVersionElement()));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_40_50.convertCode(src.getCodeElement()));
        }
        if (src.hasDisplay()) {
            tgt.setDisplayElement(VersionConvertor_40_50.convertString(src.getDisplayElement()));
        }
        if (src.hasUserSelected()) {
            tgt.setUserSelectedElement(VersionConvertor_40_50.convertBoolean(src.getUserSelectedElement()));
        }
        return tgt;
    }

    public static Coding convertCoding(org.hl7.fhir.r5.model.Coding src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Coding tgt = new Coding();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_40_50.convertUri(src.getSystemElement()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_40_50.convertString(src.getVersionElement()));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_40_50.convertCode(src.getCodeElement()));
        }
        if (src.hasDisplay()) {
            tgt.setDisplayElement(VersionConvertor_40_50.convertString(src.getDisplayElement()));
        }
        if (src.hasUserSelected()) {
            tgt.setUserSelectedElement(VersionConvertor_40_50.convertBoolean(src.getUserSelectedElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.ContactDetail convertContactDetail(ContactDetail src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.ContactDetail tgt = new org.hl7.fhir.r5.model.ContactDetail();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_40_50.convertString(src.getNameElement()));
        }
        for (org.hl7.fhir.r4.model.ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_40_50.convertContactPoint(t));
        }
        return tgt;
    }

    public static ContactDetail convertContactDetail(org.hl7.fhir.r5.model.ContactDetail src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ContactDetail tgt = new ContactDetail();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_40_50.convertString(src.getNameElement()));
        }
        for (ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_40_50.convertContactPoint(t));
        }
        return tgt;
    }

    public static ContactPoint convertContactPoint(org.hl7.fhir.r4.model.ContactPoint src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ContactPoint tgt = new ContactPoint();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_40_50.convertContactPointSystem(src.getSystemElement()));
        }
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_40_50.convertString(src.getValueElement()));
        }
        if (src.hasUse()) {
            tgt.setUseElement(VersionConvertor_40_50.convertContactPointUse(src.getUseElement()));
        }
        if (src.hasRank()) {
            tgt.setRankElement(VersionConvertor_40_50.convertPositiveInt(src.getRankElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_40_50.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.ContactPoint convertContactPoint(ContactPoint src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.ContactPoint tgt = new org.hl7.fhir.r4.model.ContactPoint();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_40_50.convertContactPointSystem(src.getSystemElement()));
        }
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_40_50.convertString(src.getValueElement()));
        }
        if (src.hasUse()) {
            tgt.setUseElement(VersionConvertor_40_50.convertContactPointUse(src.getUseElement()));
        }
        if (src.hasRank()) {
            tgt.setRankElement(VersionConvertor_40_50.convertPositiveInt(src.getRankElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_40_50.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static Enumeration<ContactPoint.ContactPointSystem> convertContactPointSystem(org.hl7.fhir.r4.model.Enumeration<ContactPoint.ContactPointSystem> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ContactPoint.ContactPointSystem> tgt = new Enumeration<ContactPoint.ContactPointSystem>(new ContactPoint.ContactPointSystemEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((ContactPoint.ContactPointSystem)((Object)src.getValue())) {
            case PHONE: {
                tgt.setValue((Object)ContactPoint.ContactPointSystem.PHONE);
                break;
            }
            case FAX: {
                tgt.setValue((Object)ContactPoint.ContactPointSystem.FAX);
                break;
            }
            case EMAIL: {
                tgt.setValue((Object)ContactPoint.ContactPointSystem.EMAIL);
                break;
            }
            case PAGER: {
                tgt.setValue((Object)ContactPoint.ContactPointSystem.PAGER);
                break;
            }
            case URL: {
                tgt.setValue((Object)ContactPoint.ContactPointSystem.URL);
                break;
            }
            case SMS: {
                tgt.setValue((Object)ContactPoint.ContactPointSystem.SMS);
                break;
            }
            case OTHER: {
                tgt.setValue((Object)ContactPoint.ContactPointSystem.OTHER);
                break;
            }
            default: {
                tgt.setValue((Object)ContactPoint.ContactPointSystem.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Enumeration<ContactPoint.ContactPointSystem> convertContactPointSystem(Enumeration<ContactPoint.ContactPointSystem> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Enumeration<ContactPoint.ContactPointSystem> tgt = new org.hl7.fhir.r4.model.Enumeration<ContactPoint.ContactPointSystem>(new ContactPoint.ContactPointSystemEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((ContactPoint.ContactPointSystem)((Object)src.getValue())) {
            case PHONE: {
                tgt.setValue((Object)ContactPoint.ContactPointSystem.PHONE);
                break;
            }
            case FAX: {
                tgt.setValue((Object)ContactPoint.ContactPointSystem.FAX);
                break;
            }
            case EMAIL: {
                tgt.setValue((Object)ContactPoint.ContactPointSystem.EMAIL);
                break;
            }
            case PAGER: {
                tgt.setValue((Object)ContactPoint.ContactPointSystem.PAGER);
                break;
            }
            case URL: {
                tgt.setValue((Object)ContactPoint.ContactPointSystem.URL);
                break;
            }
            case SMS: {
                tgt.setValue((Object)ContactPoint.ContactPointSystem.SMS);
                break;
            }
            case OTHER: {
                tgt.setValue((Object)ContactPoint.ContactPointSystem.OTHER);
                break;
            }
            default: {
                tgt.setValue((Object)ContactPoint.ContactPointSystem.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<ContactPoint.ContactPointUse> convertContactPointUse(org.hl7.fhir.r4.model.Enumeration<ContactPoint.ContactPointUse> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ContactPoint.ContactPointUse> tgt = new Enumeration<ContactPoint.ContactPointUse>(new ContactPoint.ContactPointUseEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((ContactPoint.ContactPointUse)((Object)src.getValue())) {
            case HOME: {
                tgt.setValue((Object)ContactPoint.ContactPointUse.HOME);
                break;
            }
            case WORK: {
                tgt.setValue((Object)ContactPoint.ContactPointUse.WORK);
                break;
            }
            case TEMP: {
                tgt.setValue((Object)ContactPoint.ContactPointUse.TEMP);
                break;
            }
            case OLD: {
                tgt.setValue((Object)ContactPoint.ContactPointUse.OLD);
                break;
            }
            case MOBILE: {
                tgt.setValue((Object)ContactPoint.ContactPointUse.MOBILE);
                break;
            }
            default: {
                tgt.setValue((Object)ContactPoint.ContactPointUse.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Enumeration<ContactPoint.ContactPointUse> convertContactPointUse(Enumeration<ContactPoint.ContactPointUse> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Enumeration<ContactPoint.ContactPointUse> tgt = new org.hl7.fhir.r4.model.Enumeration<ContactPoint.ContactPointUse>(new ContactPoint.ContactPointUseEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((ContactPoint.ContactPointUse)((Object)src.getValue())) {
            case HOME: {
                tgt.setValue((Object)ContactPoint.ContactPointUse.HOME);
                break;
            }
            case WORK: {
                tgt.setValue((Object)ContactPoint.ContactPointUse.WORK);
                break;
            }
            case TEMP: {
                tgt.setValue((Object)ContactPoint.ContactPointUse.TEMP);
                break;
            }
            case OLD: {
                tgt.setValue((Object)ContactPoint.ContactPointUse.OLD);
                break;
            }
            case MOBILE: {
                tgt.setValue((Object)ContactPoint.ContactPointUse.MOBILE);
                break;
            }
            default: {
                tgt.setValue((Object)ContactPoint.ContactPointUse.NULL);
            }
        }
        return tgt;
    }

    public static Contributor convertContributor(org.hl7.fhir.r4.model.Contributor src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Contributor tgt = new Contributor();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(VersionConvertor_40_50.convertContributorType(src.getTypeElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_40_50.convertString(src.getNameElement()));
        }
        for (ContactDetail t : src.getContact()) {
            tgt.addContact(VersionConvertor_40_50.convertContactDetail(t));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Contributor convertContributor(Contributor src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.Contributor tgt = new org.hl7.fhir.r4.model.Contributor();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(VersionConvertor_40_50.convertContributorType(src.getTypeElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_40_50.convertString(src.getNameElement()));
        }
        for (org.hl7.fhir.r5.model.ContactDetail t : src.getContact()) {
            tgt.addContact(VersionConvertor_40_50.convertContactDetail(t));
        }
        return tgt;
    }

    public static Enumeration<Contributor.ContributorType> convertContributorType(org.hl7.fhir.r4.model.Enumeration<Contributor.ContributorType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Contributor.ContributorType> tgt = new Enumeration<Contributor.ContributorType>(new Contributor.ContributorTypeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Contributor.ContributorType)((Object)src.getValue())) {
            case AUTHOR: {
                tgt.setValue((Object)Contributor.ContributorType.AUTHOR);
                break;
            }
            case EDITOR: {
                tgt.setValue((Object)Contributor.ContributorType.EDITOR);
                break;
            }
            case REVIEWER: {
                tgt.setValue((Object)Contributor.ContributorType.REVIEWER);
                break;
            }
            case ENDORSER: {
                tgt.setValue((Object)Contributor.ContributorType.ENDORSER);
                break;
            }
            default: {
                tgt.setValue((Object)Contributor.ContributorType.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Enumeration<Contributor.ContributorType> convertContributorType(Enumeration<Contributor.ContributorType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Enumeration<Contributor.ContributorType> tgt = new org.hl7.fhir.r4.model.Enumeration<Contributor.ContributorType>(new Contributor.ContributorTypeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Contributor.ContributorType)((Object)src.getValue())) {
            case AUTHOR: {
                tgt.setValue((Object)Contributor.ContributorType.AUTHOR);
                break;
            }
            case EDITOR: {
                tgt.setValue((Object)Contributor.ContributorType.EDITOR);
                break;
            }
            case REVIEWER: {
                tgt.setValue((Object)Contributor.ContributorType.REVIEWER);
                break;
            }
            case ENDORSER: {
                tgt.setValue((Object)Contributor.ContributorType.ENDORSER);
                break;
            }
            default: {
                tgt.setValue((Object)Contributor.ContributorType.NULL);
            }
        }
        return tgt;
    }

    public static Count convertCount(org.hl7.fhir.r4.model.Count src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Count tgt = new Count();
        VersionConvertor_40_50.copyQuantity(src, tgt);
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Count convertCount(Count src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.Count tgt = new org.hl7.fhir.r4.model.Count();
        VersionConvertor_40_50.copyQuantity(src, tgt);
        return tgt;
    }

    public static org.hl7.fhir.r5.model.DataRequirement convertDataRequirement(DataRequirement src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.DataRequirement tgt = new org.hl7.fhir.r5.model.DataRequirement();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setType(Enumerations.FHIRAllTypes.fromCode(src.getType()));
        }
        for (org.hl7.fhir.r4.model.CanonicalType canonicalType : src.getProfile()) {
            tgt.getProfile().add(VersionConvertor_40_50.convertCanonical(canonicalType));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_40_50.convertType(src.getSubject()));
        }
        for (StringType stringType : src.getMustSupport()) {
            tgt.getMustSupport().add(VersionConvertor_40_50.convertString(stringType));
        }
        for (DataRequirement.DataRequirementCodeFilterComponent dataRequirementCodeFilterComponent : src.getCodeFilter()) {
            tgt.addCodeFilter(VersionConvertor_40_50.convertDataRequirementCodeFilterComponent(dataRequirementCodeFilterComponent));
        }
        for (DataRequirement.DataRequirementDateFilterComponent dataRequirementDateFilterComponent : src.getDateFilter()) {
            tgt.addDateFilter(VersionConvertor_40_50.convertDataRequirementDateFilterComponent(dataRequirementDateFilterComponent));
        }
        if (src.hasLimit()) {
            tgt.setLimitElement(VersionConvertor_40_50.convertPositiveInt(src.getLimitElement()));
        }
        for (DataRequirement.DataRequirementSortComponent dataRequirementSortComponent : src.getSort()) {
            tgt.addSort(VersionConvertor_40_50.convertDataRequirementSortComponent(dataRequirementSortComponent));
        }
        return tgt;
    }

    public static DataRequirement convertDataRequirement(org.hl7.fhir.r5.model.DataRequirement src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DataRequirement tgt = new DataRequirement();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setType(src.getType().toCode());
        }
        for (CanonicalType canonicalType : src.getProfile()) {
            tgt.getProfile().add(VersionConvertor_40_50.convertCanonical(canonicalType));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_40_50.convertType(src.getSubject()));
        }
        for (org.hl7.fhir.r5.model.StringType stringType : src.getMustSupport()) {
            tgt.getMustSupport().add(VersionConvertor_40_50.convertString(stringType));
        }
        for (DataRequirement.DataRequirementCodeFilterComponent dataRequirementCodeFilterComponent : src.getCodeFilter()) {
            tgt.addCodeFilter(VersionConvertor_40_50.convertDataRequirementCodeFilterComponent(dataRequirementCodeFilterComponent));
        }
        for (DataRequirement.DataRequirementDateFilterComponent dataRequirementDateFilterComponent : src.getDateFilter()) {
            tgt.addDateFilter(VersionConvertor_40_50.convertDataRequirementDateFilterComponent(dataRequirementDateFilterComponent));
        }
        if (src.hasLimit()) {
            tgt.setLimitElement(VersionConvertor_40_50.convertPositiveInt(src.getLimitElement()));
        }
        for (DataRequirement.DataRequirementSortComponent dataRequirementSortComponent : src.getSort()) {
            tgt.addSort(VersionConvertor_40_50.convertDataRequirementSortComponent(dataRequirementSortComponent));
        }
        return tgt;
    }

    public static DataRequirement.DataRequirementCodeFilterComponent convertDataRequirementCodeFilterComponent(DataRequirement.DataRequirementCodeFilterComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DataRequirement.DataRequirementCodeFilterComponent tgt = new DataRequirement.DataRequirementCodeFilterComponent();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasPath()) {
            tgt.setPathElement(VersionConvertor_40_50.convertString(src.getPathElement()));
        }
        if (src.hasSearchParam()) {
            tgt.setSearchParamElement(VersionConvertor_40_50.convertString(src.getSearchParamElement()));
        }
        if (src.hasValueSet()) {
            tgt.setValueSetElement(VersionConvertor_40_50.convertCanonical(src.getValueSetElement()));
        }
        for (Coding t : src.getCode()) {
            tgt.addCode(VersionConvertor_40_50.convertCoding(t));
        }
        return tgt;
    }

    public static DataRequirement.DataRequirementCodeFilterComponent convertDataRequirementCodeFilterComponent(DataRequirement.DataRequirementCodeFilterComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DataRequirement.DataRequirementCodeFilterComponent tgt = new DataRequirement.DataRequirementCodeFilterComponent();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasPath()) {
            tgt.setPathElement(VersionConvertor_40_50.convertString(src.getPathElement()));
        }
        if (src.hasSearchParam()) {
            tgt.setSearchParamElement(VersionConvertor_40_50.convertString(src.getSearchParamElement()));
        }
        if (src.hasValueSet()) {
            tgt.setValueSetElement(VersionConvertor_40_50.convertCanonical(src.getValueSetElement()));
        }
        for (org.hl7.fhir.r5.model.Coding t : src.getCode()) {
            tgt.addCode(VersionConvertor_40_50.convertCoding(t));
        }
        return tgt;
    }

    public static DataRequirement.DataRequirementDateFilterComponent convertDataRequirementDateFilterComponent(DataRequirement.DataRequirementDateFilterComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DataRequirement.DataRequirementDateFilterComponent tgt = new DataRequirement.DataRequirementDateFilterComponent();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasPath()) {
            tgt.setPathElement(VersionConvertor_40_50.convertString(src.getPathElement()));
        }
        if (src.hasSearchParam()) {
            tgt.setSearchParamElement(VersionConvertor_40_50.convertString(src.getSearchParamElement()));
        }
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_40_50.convertType(src.getValue()));
        }
        return tgt;
    }

    public static DataRequirement.DataRequirementDateFilterComponent convertDataRequirementDateFilterComponent(DataRequirement.DataRequirementDateFilterComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DataRequirement.DataRequirementDateFilterComponent tgt = new DataRequirement.DataRequirementDateFilterComponent();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasPath()) {
            tgt.setPathElement(VersionConvertor_40_50.convertString(src.getPathElement()));
        }
        if (src.hasSearchParam()) {
            tgt.setSearchParamElement(VersionConvertor_40_50.convertString(src.getSearchParamElement()));
        }
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_40_50.convertType(src.getValue()));
        }
        return tgt;
    }

    public static DataRequirement.DataRequirementSortComponent convertDataRequirementSortComponent(DataRequirement.DataRequirementSortComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DataRequirement.DataRequirementSortComponent tgt = new DataRequirement.DataRequirementSortComponent();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasPath()) {
            tgt.setPathElement(VersionConvertor_40_50.convertString(src.getPathElement()));
        }
        if (src.hasDirection()) {
            tgt.setDirectionElement(VersionConvertor_40_50.convertSortDirection(src.getDirectionElement()));
        }
        return tgt;
    }

    public static DataRequirement.DataRequirementSortComponent convertDataRequirementSortComponent(DataRequirement.DataRequirementSortComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DataRequirement.DataRequirementSortComponent tgt = new DataRequirement.DataRequirementSortComponent();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasPath()) {
            tgt.setPathElement(VersionConvertor_40_50.convertString(src.getPathElement()));
        }
        if (src.hasDirection()) {
            tgt.setDirectionElement(VersionConvertor_40_50.convertSortDirection(src.getDirectionElement()));
        }
        return tgt;
    }

    public static Enumeration<DataRequirement.SortDirection> convertSortDirection(org.hl7.fhir.r4.model.Enumeration<DataRequirement.SortDirection> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<DataRequirement.SortDirection> tgt = new Enumeration<DataRequirement.SortDirection>(new DataRequirement.SortDirectionEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((DataRequirement.SortDirection)((Object)src.getValue())) {
            case ASCENDING: {
                tgt.setValue((Object)DataRequirement.SortDirection.ASCENDING);
                break;
            }
            case DESCENDING: {
                tgt.setValue((Object)DataRequirement.SortDirection.DESCENDING);
                break;
            }
            default: {
                tgt.setValue((Object)DataRequirement.SortDirection.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Enumeration<DataRequirement.SortDirection> convertSortDirection(Enumeration<DataRequirement.SortDirection> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Enumeration<DataRequirement.SortDirection> tgt = new org.hl7.fhir.r4.model.Enumeration<DataRequirement.SortDirection>(new DataRequirement.SortDirectionEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((DataRequirement.SortDirection)((Object)src.getValue())) {
            case ASCENDING: {
                tgt.setValue((Object)DataRequirement.SortDirection.ASCENDING);
                break;
            }
            case DESCENDING: {
                tgt.setValue((Object)DataRequirement.SortDirection.DESCENDING);
                break;
            }
            default: {
                tgt.setValue((Object)DataRequirement.SortDirection.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Distance convertDistance(Distance src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.Distance tgt = new org.hl7.fhir.r5.model.Distance();
        VersionConvertor_40_50.copyQuantity(src, tgt);
        return tgt;
    }

    public static Distance convertDistance(org.hl7.fhir.r5.model.Distance src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Distance tgt = new Distance();
        VersionConvertor_40_50.copyQuantity(src, tgt);
        return tgt;
    }

    public static Dosage convertDosage(org.hl7.fhir.r4.model.Dosage src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Dosage tgt = new Dosage();
        VersionConvertor_40_50.copyBackboneElement(src, tgt);
        if (src.hasSequence()) {
            tgt.setSequenceElement(VersionConvertor_40_50.convertInteger(src.getSequenceElement()));
        }
        if (src.hasText()) {
            tgt.setTextElement(VersionConvertor_40_50.convertString(src.getTextElement()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getAdditionalInstruction()) {
            tgt.addAdditionalInstruction(VersionConvertor_40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPatientInstruction()) {
            tgt.setPatientInstructionElement(VersionConvertor_40_50.convertString(src.getPatientInstructionElement()));
        }
        if (src.hasTiming()) {
            tgt.setTiming(VersionConvertor_40_50.convertTiming(src.getTiming()));
        }
        if (src.hasAsNeeded()) {
            tgt.setAsNeeded(VersionConvertor_40_50.convertType(src.getAsNeeded()));
        }
        if (src.hasSite()) {
            tgt.setSite(VersionConvertor_40_50.convertCodeableConcept(src.getSite()));
        }
        if (src.hasRoute()) {
            tgt.setRoute(VersionConvertor_40_50.convertCodeableConcept(src.getRoute()));
        }
        if (src.hasMethod()) {
            tgt.setMethod(VersionConvertor_40_50.convertCodeableConcept(src.getMethod()));
        }
        for (Dosage.DosageDoseAndRateComponent dosageDoseAndRateComponent : src.getDoseAndRate()) {
            tgt.addDoseAndRate(VersionConvertor_40_50.convertDosageDoseAndRateComponent(dosageDoseAndRateComponent));
        }
        if (src.hasMaxDosePerPeriod()) {
            tgt.setMaxDosePerPeriod(VersionConvertor_40_50.convertRatio(src.getMaxDosePerPeriod()));
        }
        if (src.hasMaxDosePerAdministration()) {
            tgt.setMaxDosePerAdministration(VersionConvertor_40_50.convertSimpleQuantity(src.getMaxDosePerAdministration()));
        }
        if (src.hasMaxDosePerLifetime()) {
            tgt.setMaxDosePerLifetime(VersionConvertor_40_50.convertSimpleQuantity(src.getMaxDosePerLifetime()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Dosage convertDosage(Dosage src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.Dosage tgt = new org.hl7.fhir.r4.model.Dosage();
        VersionConvertor_40_50.copyBackboneElement(src, tgt);
        if (src.hasSequence()) {
            tgt.setSequenceElement(VersionConvertor_40_50.convertInteger(src.getSequenceElement()));
        }
        if (src.hasText()) {
            tgt.setTextElement(VersionConvertor_40_50.convertString(src.getTextElement()));
        }
        for (CodeableConcept codeableConcept : src.getAdditionalInstruction()) {
            tgt.addAdditionalInstruction(VersionConvertor_40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPatientInstruction()) {
            tgt.setPatientInstructionElement(VersionConvertor_40_50.convertString(src.getPatientInstructionElement()));
        }
        if (src.hasTiming()) {
            tgt.setTiming(VersionConvertor_40_50.convertTiming(src.getTiming()));
        }
        if (src.hasAsNeeded()) {
            tgt.setAsNeeded(VersionConvertor_40_50.convertType(src.getAsNeeded()));
        }
        if (src.hasSite()) {
            tgt.setSite(VersionConvertor_40_50.convertCodeableConcept(src.getSite()));
        }
        if (src.hasRoute()) {
            tgt.setRoute(VersionConvertor_40_50.convertCodeableConcept(src.getRoute()));
        }
        if (src.hasMethod()) {
            tgt.setMethod(VersionConvertor_40_50.convertCodeableConcept(src.getMethod()));
        }
        for (Dosage.DosageDoseAndRateComponent dosageDoseAndRateComponent : src.getDoseAndRate()) {
            tgt.addDoseAndRate(VersionConvertor_40_50.convertDosageDoseAndRateComponent(dosageDoseAndRateComponent));
        }
        if (src.hasMaxDosePerPeriod()) {
            tgt.setMaxDosePerPeriod(VersionConvertor_40_50.convertRatio(src.getMaxDosePerPeriod()));
        }
        if (src.hasMaxDosePerAdministration()) {
            tgt.setMaxDosePerAdministration(VersionConvertor_40_50.convertSimpleQuantity(src.getMaxDosePerAdministration()));
        }
        if (src.hasMaxDosePerLifetime()) {
            tgt.setMaxDosePerLifetime(VersionConvertor_40_50.convertSimpleQuantity(src.getMaxDosePerLifetime()));
        }
        return tgt;
    }

    public static Dosage.DosageDoseAndRateComponent convertDosageDoseAndRateComponent(Dosage.DosageDoseAndRateComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Dosage.DosageDoseAndRateComponent tgt = new Dosage.DosageDoseAndRateComponent();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setType(VersionConvertor_40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasDose()) {
            tgt.setDose(VersionConvertor_40_50.convertType(src.getDose()));
        }
        if (src.hasRate()) {
            tgt.setRate(VersionConvertor_40_50.convertType(src.getRate()));
        }
        return tgt;
    }

    public static Dosage.DosageDoseAndRateComponent convertDosageDoseAndRateComponent(Dosage.DosageDoseAndRateComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Dosage.DosageDoseAndRateComponent tgt = new Dosage.DosageDoseAndRateComponent();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setType(VersionConvertor_40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasDose()) {
            tgt.setDose(VersionConvertor_40_50.convertType(src.getDose()));
        }
        if (src.hasRate()) {
            tgt.setRate(VersionConvertor_40_50.convertType(src.getRate()));
        }
        return tgt;
    }

    public static Duration convertDuration(org.hl7.fhir.r4.model.Duration src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Duration tgt = new Duration();
        VersionConvertor_40_50.copyQuantity(src, tgt);
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Duration convertDuration(Duration src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.Duration tgt = new org.hl7.fhir.r4.model.Duration();
        VersionConvertor_40_50.copyQuantity(src, tgt);
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Expression convertExpression(Expression src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.Expression tgt = new org.hl7.fhir.r5.model.Expression();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_40_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_40_50.convertId(src.getNameElement()));
        }
        if (src.hasLanguage()) {
            tgt.setLanguageElement(VersionConvertor_40_50.convertCode(src.getLanguageElement()));
        }
        if (src.hasExpression()) {
            tgt.setExpressionElement(VersionConvertor_40_50.convertString(src.getExpressionElement()));
        }
        if (src.hasReference()) {
            tgt.setReferenceElement(VersionConvertor_40_50.convertUri(src.getReferenceElement()));
        }
        return tgt;
    }

    public static Expression convertExpression(org.hl7.fhir.r5.model.Expression src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Expression tgt = new Expression();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_40_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_40_50.convertId(src.getNameElement()));
        }
        if (src.hasLanguage()) {
            tgt.setLanguageElement(VersionConvertor_40_50.convertCode(src.getLanguageElement()));
        }
        if (src.hasExpression()) {
            tgt.setExpressionElement(VersionConvertor_40_50.convertString(src.getExpressionElement()));
        }
        if (src.hasReference()) {
            tgt.setReferenceElement(VersionConvertor_40_50.convertUri(src.getReferenceElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.HumanName convertHumanName(HumanName src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.HumanName tgt = new org.hl7.fhir.r5.model.HumanName();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasUse()) {
            tgt.setUseElement(VersionConvertor_40_50.convertNameUse(src.getUseElement()));
        }
        if (src.hasText()) {
            tgt.setTextElement(VersionConvertor_40_50.convertString(src.getTextElement()));
        }
        if (src.hasFamily()) {
            tgt.setFamilyElement(VersionConvertor_40_50.convertString(src.getFamilyElement()));
        }
        for (StringType t : src.getGiven()) {
            tgt.getGiven().add(VersionConvertor_40_50.convertString(t));
        }
        for (StringType t : src.getPrefix()) {
            tgt.getPrefix().add(VersionConvertor_40_50.convertString(t));
        }
        for (StringType t : src.getSuffix()) {
            tgt.getSuffix().add(VersionConvertor_40_50.convertString(t));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_40_50.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static HumanName convertHumanName(org.hl7.fhir.r5.model.HumanName src) throws FHIRException {
        if (src == null) {
            return null;
        }
        HumanName tgt = new HumanName();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasUse()) {
            tgt.setUseElement(VersionConvertor_40_50.convertNameUse(src.getUseElement()));
        }
        if (src.hasText()) {
            tgt.setTextElement(VersionConvertor_40_50.convertString(src.getTextElement()));
        }
        if (src.hasFamily()) {
            tgt.setFamilyElement(VersionConvertor_40_50.convertString(src.getFamilyElement()));
        }
        for (org.hl7.fhir.r5.model.StringType t : src.getGiven()) {
            tgt.getGiven().add(VersionConvertor_40_50.convertString(t));
        }
        for (org.hl7.fhir.r5.model.StringType t : src.getPrefix()) {
            tgt.getPrefix().add(VersionConvertor_40_50.convertString(t));
        }
        for (org.hl7.fhir.r5.model.StringType t : src.getSuffix()) {
            tgt.getSuffix().add(VersionConvertor_40_50.convertString(t));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_40_50.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static Enumeration<HumanName.NameUse> convertNameUse(org.hl7.fhir.r4.model.Enumeration<HumanName.NameUse> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<HumanName.NameUse> tgt = new Enumeration<HumanName.NameUse>(new HumanName.NameUseEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((HumanName.NameUse)((Object)src.getValue())) {
            case USUAL: {
                tgt.setValue((Object)HumanName.NameUse.USUAL);
                break;
            }
            case OFFICIAL: {
                tgt.setValue((Object)HumanName.NameUse.OFFICIAL);
                break;
            }
            case TEMP: {
                tgt.setValue((Object)HumanName.NameUse.TEMP);
                break;
            }
            case NICKNAME: {
                tgt.setValue((Object)HumanName.NameUse.NICKNAME);
                break;
            }
            case ANONYMOUS: {
                tgt.setValue((Object)HumanName.NameUse.ANONYMOUS);
                break;
            }
            case OLD: {
                tgt.setValue((Object)HumanName.NameUse.OLD);
                break;
            }
            case MAIDEN: {
                tgt.setValue((Object)HumanName.NameUse.MAIDEN);
                break;
            }
            default: {
                tgt.setValue((Object)HumanName.NameUse.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Enumeration<HumanName.NameUse> convertNameUse(Enumeration<HumanName.NameUse> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Enumeration<HumanName.NameUse> tgt = new org.hl7.fhir.r4.model.Enumeration<HumanName.NameUse>(new HumanName.NameUseEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((HumanName.NameUse)((Object)src.getValue())) {
            case USUAL: {
                tgt.setValue((Object)HumanName.NameUse.USUAL);
                break;
            }
            case OFFICIAL: {
                tgt.setValue((Object)HumanName.NameUse.OFFICIAL);
                break;
            }
            case TEMP: {
                tgt.setValue((Object)HumanName.NameUse.TEMP);
                break;
            }
            case NICKNAME: {
                tgt.setValue((Object)HumanName.NameUse.NICKNAME);
                break;
            }
            case ANONYMOUS: {
                tgt.setValue((Object)HumanName.NameUse.ANONYMOUS);
                break;
            }
            case OLD: {
                tgt.setValue((Object)HumanName.NameUse.OLD);
                break;
            }
            case MAIDEN: {
                tgt.setValue((Object)HumanName.NameUse.MAIDEN);
                break;
            }
            default: {
                tgt.setValue((Object)HumanName.NameUse.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Identifier convertIdentifier(Identifier src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.Identifier tgt = new org.hl7.fhir.r5.model.Identifier();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasUse()) {
            tgt.setUseElement(VersionConvertor_40_50.convertIdentifierUse(src.getUseElement()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_40_50.convertUri(src.getSystemElement()));
        }
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_40_50.convertString(src.getValueElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_40_50.convertPeriod(src.getPeriod()));
        }
        if (src.hasAssigner()) {
            tgt.setAssigner(VersionConvertor_40_50.convertReference(src.getAssigner()));
        }
        return tgt;
    }

    public static Identifier convertIdentifier(org.hl7.fhir.r5.model.Identifier src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Identifier tgt = new Identifier();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasUse()) {
            tgt.setUseElement(VersionConvertor_40_50.convertIdentifierUse(src.getUseElement()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_40_50.convertUri(src.getSystemElement()));
        }
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_40_50.convertString(src.getValueElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_40_50.convertPeriod(src.getPeriod()));
        }
        if (src.hasAssigner()) {
            tgt.setAssigner(VersionConvertor_40_50.convertReference(src.getAssigner()));
        }
        return tgt;
    }

    public static Enumeration<Identifier.IdentifierUse> convertIdentifierUse(org.hl7.fhir.r4.model.Enumeration<Identifier.IdentifierUse> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Identifier.IdentifierUse> tgt = new Enumeration<Identifier.IdentifierUse>(new Identifier.IdentifierUseEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Identifier.IdentifierUse)((Object)src.getValue())) {
            case USUAL: {
                tgt.setValue((Object)Identifier.IdentifierUse.USUAL);
                break;
            }
            case OFFICIAL: {
                tgt.setValue((Object)Identifier.IdentifierUse.OFFICIAL);
                break;
            }
            case TEMP: {
                tgt.setValue((Object)Identifier.IdentifierUse.TEMP);
                break;
            }
            case SECONDARY: {
                tgt.setValue((Object)Identifier.IdentifierUse.SECONDARY);
                break;
            }
            case OLD: {
                tgt.setValue((Object)Identifier.IdentifierUse.OLD);
                break;
            }
            default: {
                tgt.setValue((Object)Identifier.IdentifierUse.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Enumeration<Identifier.IdentifierUse> convertIdentifierUse(Enumeration<Identifier.IdentifierUse> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Enumeration<Identifier.IdentifierUse> tgt = new org.hl7.fhir.r4.model.Enumeration<Identifier.IdentifierUse>(new Identifier.IdentifierUseEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Identifier.IdentifierUse)((Object)src.getValue())) {
            case USUAL: {
                tgt.setValue((Object)Identifier.IdentifierUse.USUAL);
                break;
            }
            case OFFICIAL: {
                tgt.setValue((Object)Identifier.IdentifierUse.OFFICIAL);
                break;
            }
            case TEMP: {
                tgt.setValue((Object)Identifier.IdentifierUse.TEMP);
                break;
            }
            case SECONDARY: {
                tgt.setValue((Object)Identifier.IdentifierUse.SECONDARY);
                break;
            }
            case OLD: {
                tgt.setValue((Object)Identifier.IdentifierUse.OLD);
                break;
            }
            default: {
                tgt.setValue((Object)Identifier.IdentifierUse.NULL);
            }
        }
        return tgt;
    }

    public static MarketingStatus convertMarketingStatus(org.hl7.fhir.r4.model.MarketingStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MarketingStatus tgt = new MarketingStatus();
        VersionConvertor_40_50.copyBackboneElement(src, tgt);
        if (src.hasCountry()) {
            tgt.setCountry(VersionConvertor_40_50.convertCodeableConcept(src.getCountry()));
        }
        if (src.hasJurisdiction()) {
            tgt.setJurisdiction(VersionConvertor_40_50.convertCodeableConcept(src.getJurisdiction()));
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_40_50.convertCodeableConcept(src.getStatus()));
        }
        if (src.hasDateRange()) {
            tgt.setDateRange(VersionConvertor_40_50.convertPeriod(src.getDateRange()));
        }
        if (src.hasRestoreDate()) {
            tgt.setRestoreDateElement(VersionConvertor_40_50.convertDateTime(src.getRestoreDateElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.MarketingStatus convertMarketingStatus(MarketingStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.MarketingStatus tgt = new org.hl7.fhir.r4.model.MarketingStatus();
        VersionConvertor_40_50.copyBackboneElement(src, tgt);
        if (src.hasCountry()) {
            tgt.setCountry(VersionConvertor_40_50.convertCodeableConcept(src.getCountry()));
        }
        if (src.hasJurisdiction()) {
            tgt.setJurisdiction(VersionConvertor_40_50.convertCodeableConcept(src.getJurisdiction()));
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_40_50.convertCodeableConcept(src.getStatus()));
        }
        if (src.hasDateRange()) {
            tgt.setDateRange(VersionConvertor_40_50.convertPeriod(src.getDateRange()));
        }
        if (src.hasRestoreDate()) {
            tgt.setRestoreDateElement(VersionConvertor_40_50.convertDateTime(src.getRestoreDateElement()));
        }
        return tgt;
    }

    public static Meta convertMeta(org.hl7.fhir.r4.model.Meta src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Meta tgt = new Meta();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasVersionId()) {
            tgt.setVersionIdElement(VersionConvertor_40_50.convertId(src.getVersionIdElement()));
        }
        if (src.hasLastUpdated()) {
            tgt.setLastUpdatedElement(VersionConvertor_40_50.convertInstant(src.getLastUpdatedElement()));
        }
        if (src.hasSource()) {
            tgt.setSourceElement(VersionConvertor_40_50.convertUri(src.getSourceElement()));
        }
        for (org.hl7.fhir.r4.model.CanonicalType canonicalType : src.getProfile()) {
            tgt.getProfile().add(VersionConvertor_40_50.convertCanonical(canonicalType));
        }
        for (Coding coding : src.getSecurity()) {
            tgt.addSecurity(VersionConvertor_40_50.convertCoding(coding));
        }
        for (Coding coding : src.getTag()) {
            tgt.addTag(VersionConvertor_40_50.convertCoding(coding));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Meta convertMeta(Meta src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.Meta tgt = new org.hl7.fhir.r4.model.Meta();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasVersionId()) {
            tgt.setVersionIdElement(VersionConvertor_40_50.convertId(src.getVersionIdElement()));
        }
        if (src.hasLastUpdated()) {
            tgt.setLastUpdatedElement(VersionConvertor_40_50.convertInstant(src.getLastUpdatedElement()));
        }
        if (src.hasSource()) {
            tgt.setSourceElement(VersionConvertor_40_50.convertUri(src.getSourceElement()));
        }
        for (CanonicalType canonicalType : src.getProfile()) {
            tgt.getProfile().add(VersionConvertor_40_50.convertCanonical(canonicalType));
        }
        for (org.hl7.fhir.r5.model.Coding coding : src.getSecurity()) {
            tgt.addSecurity(VersionConvertor_40_50.convertCoding(coding));
        }
        for (org.hl7.fhir.r5.model.Coding coding : src.getTag()) {
            tgt.addTag(VersionConvertor_40_50.convertCoding(coding));
        }
        return tgt;
    }

    public static Money convertMoney(org.hl7.fhir.r4.model.Money src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Money tgt = new Money();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_40_50.convertDecimal(src.getValueElement()));
        }
        if (src.hasCurrency()) {
            tgt.setCurrencyElement(VersionConvertor_40_50.convertCode(src.getCurrencyElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Money convertMoney(Money src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.Money tgt = new org.hl7.fhir.r4.model.Money();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_40_50.convertDecimal(src.getValueElement()));
        }
        if (src.hasCurrency()) {
            tgt.setCurrencyElement(VersionConvertor_40_50.convertCode(src.getCurrencyElement()));
        }
        return tgt;
    }

    public static ParameterDefinition convertParameterDefinition(org.hl7.fhir.r4.model.ParameterDefinition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ParameterDefinition tgt = new ParameterDefinition();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_40_50.convertCode(src.getNameElement()));
        }
        if (src.hasUse()) {
            tgt.setUseElement(VersionConvertor_40_50.convertParameterUse(src.getUseElement()));
        }
        if (src.hasMin()) {
            tgt.setMinElement(VersionConvertor_40_50.convertInteger(src.getMinElement()));
        }
        if (src.hasMax()) {
            tgt.setMaxElement(VersionConvertor_40_50.convertString(src.getMaxElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentationElement(VersionConvertor_40_50.convertString(src.getDocumentationElement()));
        }
        if (src.hasType()) {
            tgt.setType(Enumerations.FHIRAllTypes.fromCode(src.getType()));
        }
        if (src.hasProfile()) {
            tgt.setProfileElement(VersionConvertor_40_50.convertCanonical(src.getProfileElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.ParameterDefinition convertParameterDefinition(ParameterDefinition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.ParameterDefinition tgt = new org.hl7.fhir.r4.model.ParameterDefinition();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_40_50.convertCode(src.getNameElement()));
        }
        if (src.hasUse()) {
            tgt.setUseElement(VersionConvertor_40_50.convertParameterUse(src.getUseElement()));
        }
        if (src.hasMin()) {
            tgt.setMinElement(VersionConvertor_40_50.convertInteger(src.getMinElement()));
        }
        if (src.hasMax()) {
            tgt.setMaxElement(VersionConvertor_40_50.convertString(src.getMaxElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentationElement(VersionConvertor_40_50.convertString(src.getDocumentationElement()));
        }
        if (src.hasType()) {
            tgt.setType(src.getType().toCode());
        }
        if (src.hasProfile()) {
            tgt.setProfileElement(VersionConvertor_40_50.convertCanonical(src.getProfileElement()));
        }
        return tgt;
    }

    public static Enumeration<Enumerations.OperationParameterUse> convertParameterUse(org.hl7.fhir.r4.model.Enumeration<ParameterDefinition.ParameterUse> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Enumerations.OperationParameterUse> tgt = new Enumeration<Enumerations.OperationParameterUse>(new Enumerations.OperationParameterUseEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((ParameterDefinition.ParameterUse)((Object)src.getValue())) {
            case IN: {
                tgt.setValue((Object)Enumerations.OperationParameterUse.IN);
                break;
            }
            case OUT: {
                tgt.setValue((Object)Enumerations.OperationParameterUse.OUT);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.OperationParameterUse.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Enumeration<ParameterDefinition.ParameterUse> convertParameterUse(Enumeration<Enumerations.OperationParameterUse> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Enumeration<ParameterDefinition.ParameterUse> tgt = new org.hl7.fhir.r4.model.Enumeration<ParameterDefinition.ParameterUse>(new ParameterDefinition.ParameterUseEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.OperationParameterUse)((Object)src.getValue())) {
            case IN: {
                tgt.setValue((Object)ParameterDefinition.ParameterUse.IN);
                break;
            }
            case OUT: {
                tgt.setValue((Object)ParameterDefinition.ParameterUse.OUT);
                break;
            }
            default: {
                tgt.setValue((Object)ParameterDefinition.ParameterUse.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Period convertPeriod(Period src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.Period tgt = new org.hl7.fhir.r5.model.Period();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasStart()) {
            tgt.setStartElement(VersionConvertor_40_50.convertDateTime(src.getStartElement()));
        }
        if (src.hasEnd()) {
            tgt.setEndElement(VersionConvertor_40_50.convertDateTime(src.getEndElement()));
        }
        return tgt;
    }

    public static Period convertPeriod(org.hl7.fhir.r5.model.Period src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Period tgt = new Period();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasStart()) {
            tgt.setStartElement(VersionConvertor_40_50.convertDateTime(src.getStartElement()));
        }
        if (src.hasEnd()) {
            tgt.setEndElement(VersionConvertor_40_50.convertDateTime(src.getEndElement()));
        }
        return tgt;
    }

    public static Population convertPopulation(org.hl7.fhir.r4.model.Population src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Population tgt = new Population();
        VersionConvertor_40_50.copyBackboneElement(src, tgt);
        if (src.hasAge()) {
            tgt.setAge(VersionConvertor_40_50.convertType(src.getAge()));
        }
        if (src.hasGender()) {
            tgt.setGender(VersionConvertor_40_50.convertCodeableConcept(src.getGender()));
        }
        if (src.hasRace()) {
            tgt.setRace(VersionConvertor_40_50.convertCodeableConcept(src.getRace()));
        }
        if (src.hasPhysiologicalCondition()) {
            tgt.setPhysiologicalCondition(VersionConvertor_40_50.convertCodeableConcept(src.getPhysiologicalCondition()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Population convertPopulation(Population src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.Population tgt = new org.hl7.fhir.r4.model.Population();
        VersionConvertor_40_50.copyBackboneElement(src, tgt);
        if (src.hasAge()) {
            tgt.setAge(VersionConvertor_40_50.convertType(src.getAge()));
        }
        if (src.hasGender()) {
            tgt.setGender(VersionConvertor_40_50.convertCodeableConcept(src.getGender()));
        }
        if (src.hasRace()) {
            tgt.setRace(VersionConvertor_40_50.convertCodeableConcept(src.getRace()));
        }
        if (src.hasPhysiologicalCondition()) {
            tgt.setPhysiologicalCondition(VersionConvertor_40_50.convertCodeableConcept(src.getPhysiologicalCondition()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.ProdCharacteristic convertProdCharacteristic(ProdCharacteristic src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.ProdCharacteristic tgt = new org.hl7.fhir.r5.model.ProdCharacteristic();
        VersionConvertor_40_50.copyBackboneElement(src, tgt);
        if (src.hasHeight()) {
            tgt.setHeight(VersionConvertor_40_50.convertQuantity(src.getHeight()));
        }
        if (src.hasWidth()) {
            tgt.setWidth(VersionConvertor_40_50.convertQuantity(src.getWidth()));
        }
        if (src.hasDepth()) {
            tgt.setDepth(VersionConvertor_40_50.convertQuantity(src.getDepth()));
        }
        if (src.hasWeight()) {
            tgt.setWeight(VersionConvertor_40_50.convertQuantity(src.getWeight()));
        }
        if (src.hasNominalVolume()) {
            tgt.setNominalVolume(VersionConvertor_40_50.convertQuantity(src.getNominalVolume()));
        }
        if (src.hasExternalDiameter()) {
            tgt.setExternalDiameter(VersionConvertor_40_50.convertQuantity(src.getExternalDiameter()));
        }
        if (src.hasShape()) {
            tgt.setShapeElement(VersionConvertor_40_50.convertString(src.getShapeElement()));
        }
        for (StringType stringType : src.getColor()) {
            tgt.getColor().add(VersionConvertor_40_50.convertString(stringType));
        }
        for (StringType stringType : src.getImprint()) {
            tgt.getImprint().add(VersionConvertor_40_50.convertString(stringType));
        }
        for (Attachment attachment : src.getImage()) {
            tgt.addImage(VersionConvertor_40_50.convertAttachment(attachment));
        }
        if (src.hasScoring()) {
            tgt.setScoring(VersionConvertor_40_50.convertCodeableConcept(src.getScoring()));
        }
        return tgt;
    }

    public static ProdCharacteristic convertProdCharacteristic(org.hl7.fhir.r5.model.ProdCharacteristic src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ProdCharacteristic tgt = new ProdCharacteristic();
        VersionConvertor_40_50.copyBackboneElement(src, tgt);
        if (src.hasHeight()) {
            tgt.setHeight(VersionConvertor_40_50.convertQuantity(src.getHeight()));
        }
        if (src.hasWidth()) {
            tgt.setWidth(VersionConvertor_40_50.convertQuantity(src.getWidth()));
        }
        if (src.hasDepth()) {
            tgt.setDepth(VersionConvertor_40_50.convertQuantity(src.getDepth()));
        }
        if (src.hasWeight()) {
            tgt.setWeight(VersionConvertor_40_50.convertQuantity(src.getWeight()));
        }
        if (src.hasNominalVolume()) {
            tgt.setNominalVolume(VersionConvertor_40_50.convertQuantity(src.getNominalVolume()));
        }
        if (src.hasExternalDiameter()) {
            tgt.setExternalDiameter(VersionConvertor_40_50.convertQuantity(src.getExternalDiameter()));
        }
        if (src.hasShape()) {
            tgt.setShapeElement(VersionConvertor_40_50.convertString(src.getShapeElement()));
        }
        for (org.hl7.fhir.r5.model.StringType stringType : src.getColor()) {
            tgt.getColor().add(VersionConvertor_40_50.convertString(stringType));
        }
        for (org.hl7.fhir.r5.model.StringType stringType : src.getImprint()) {
            tgt.getImprint().add(VersionConvertor_40_50.convertString(stringType));
        }
        for (org.hl7.fhir.r5.model.Attachment attachment : src.getImage()) {
            tgt.addImage(VersionConvertor_40_50.convertAttachment(attachment));
        }
        if (src.hasScoring()) {
            tgt.setScoring(VersionConvertor_40_50.convertCodeableConcept(src.getScoring()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.ProductShelfLife convertProductShelfLife(ProductShelfLife src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.ProductShelfLife tgt = new org.hl7.fhir.r5.model.ProductShelfLife();
        VersionConvertor_40_50.copyBackboneElement(src, tgt);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_40_50.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_40_50.convertQuantity(src.getPeriod()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept t : src.getSpecialPrecautionsForStorage()) {
            tgt.addSpecialPrecautionsForStorage(VersionConvertor_40_50.convertCodeableConcept(t));
        }
        return tgt;
    }

    public static ProductShelfLife convertProductShelfLife(org.hl7.fhir.r5.model.ProductShelfLife src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ProductShelfLife tgt = new ProductShelfLife();
        VersionConvertor_40_50.copyBackboneElement(src, tgt);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_40_50.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_40_50.convertQuantity(src.getPeriod()));
        }
        for (CodeableConcept t : src.getSpecialPrecautionsForStorage()) {
            tgt.addSpecialPrecautionsForStorage(VersionConvertor_40_50.convertCodeableConcept(t));
        }
        return tgt;
    }

    public static void copyQuantity(Quantity src, org.hl7.fhir.r5.model.Quantity tgt) throws FHIRException {
        if (src == null || tgt == null) {
            return;
        }
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        if (src.hasComparator()) {
            tgt.setComparatorElement(VersionConvertor_40_50.convertQuantityComparator(src.getComparatorElement()));
        }
        if (src.hasUnit()) {
            tgt.setUnit(src.getUnit());
        }
        if (src.hasSystem()) {
            tgt.setSystem(src.getSystem());
        }
        if (src.hasCode()) {
            tgt.setCode(src.getCode());
        }
    }

    public static void copyQuantity(org.hl7.fhir.r5.model.Quantity src, Quantity tgt) throws FHIRException {
        if (src == null || tgt == null) {
            return;
        }
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        if (src.hasComparator()) {
            tgt.setComparatorElement(VersionConvertor_40_50.convertQuantityComparator(src.getComparatorElement()));
        }
        if (src.hasUnit()) {
            tgt.setUnit(src.getUnit());
        }
        if (src.hasSystem()) {
            tgt.setSystem(src.getSystem());
        }
        if (src.hasCode()) {
            tgt.setCode(src.getCode());
        }
    }

    public static org.hl7.fhir.r5.model.Quantity convertQuantity(Quantity src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.Quantity tgt = new org.hl7.fhir.r5.model.Quantity();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_40_50.convertDecimal(src.getValueElement()));
        }
        if (src.hasComparator()) {
            tgt.setComparatorElement(VersionConvertor_40_50.convertQuantityComparator(src.getComparatorElement()));
        }
        if (src.hasUnit()) {
            tgt.setUnitElement(VersionConvertor_40_50.convertString(src.getUnitElement()));
        }
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_40_50.convertUri(src.getSystemElement()));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_40_50.convertCode(src.getCodeElement()));
        }
        return tgt;
    }

    public static Quantity convertQuantity(org.hl7.fhir.r5.model.Quantity src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Quantity tgt = new Quantity();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_40_50.convertDecimal(src.getValueElement()));
        }
        if (src.hasComparator()) {
            tgt.setComparatorElement(VersionConvertor_40_50.convertQuantityComparator(src.getComparatorElement()));
        }
        if (src.hasUnit()) {
            tgt.setUnitElement(VersionConvertor_40_50.convertString(src.getUnitElement()));
        }
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_40_50.convertUri(src.getSystemElement()));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_40_50.convertCode(src.getCodeElement()));
        }
        return tgt;
    }

    public static Enumeration<Enumerations.QuantityComparator> convertQuantityComparator(org.hl7.fhir.r4.model.Enumeration<Quantity.QuantityComparator> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Enumerations.QuantityComparator> tgt = new Enumeration<Enumerations.QuantityComparator>(new Enumerations.QuantityComparatorEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Quantity.QuantityComparator)((Object)src.getValue())) {
            case LESS_THAN: {
                tgt.setValue((Object)Enumerations.QuantityComparator.LESS_THAN);
                break;
            }
            case LESS_OR_EQUAL: {
                tgt.setValue((Object)Enumerations.QuantityComparator.LESS_OR_EQUAL);
                break;
            }
            case GREATER_OR_EQUAL: {
                tgt.setValue((Object)Enumerations.QuantityComparator.GREATER_OR_EQUAL);
                break;
            }
            case GREATER_THAN: {
                tgt.setValue((Object)Enumerations.QuantityComparator.GREATER_THAN);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.QuantityComparator.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Enumeration<Quantity.QuantityComparator> convertQuantityComparator(Enumeration<Enumerations.QuantityComparator> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Enumeration<Quantity.QuantityComparator> tgt = new org.hl7.fhir.r4.model.Enumeration<Quantity.QuantityComparator>(new Quantity.QuantityComparatorEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.QuantityComparator)((Object)src.getValue())) {
            case LESS_THAN: {
                tgt.setValue((Object)Quantity.QuantityComparator.LESS_THAN);
                break;
            }
            case LESS_OR_EQUAL: {
                tgt.setValue((Object)Quantity.QuantityComparator.LESS_OR_EQUAL);
                break;
            }
            case GREATER_OR_EQUAL: {
                tgt.setValue((Object)Quantity.QuantityComparator.GREATER_OR_EQUAL);
                break;
            }
            case GREATER_THAN: {
                tgt.setValue((Object)Quantity.QuantityComparator.GREATER_THAN);
                break;
            }
            default: {
                tgt.setValue((Object)Quantity.QuantityComparator.NULL);
            }
        }
        return tgt;
    }

    public static Range convertRange(org.hl7.fhir.r4.model.Range src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Range tgt = new Range();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasLow()) {
            tgt.setLow(VersionConvertor_40_50.convertSimpleQuantity(src.getLow()));
        }
        if (src.hasHigh()) {
            tgt.setHigh(VersionConvertor_40_50.convertSimpleQuantity(src.getHigh()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Range convertRange(Range src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.Range tgt = new org.hl7.fhir.r4.model.Range();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasLow()) {
            tgt.setLow(VersionConvertor_40_50.convertSimpleQuantity(src.getLow()));
        }
        if (src.hasHigh()) {
            tgt.setHigh(VersionConvertor_40_50.convertSimpleQuantity(src.getHigh()));
        }
        return tgt;
    }

    public static Ratio convertRatio(org.hl7.fhir.r4.model.Ratio src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Ratio tgt = new Ratio();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasNumerator()) {
            tgt.setNumerator(VersionConvertor_40_50.convertQuantity(src.getNumerator()));
        }
        if (src.hasDenominator()) {
            tgt.setDenominator(VersionConvertor_40_50.convertQuantity(src.getDenominator()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Ratio convertRatio(Ratio src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.Ratio tgt = new org.hl7.fhir.r4.model.Ratio();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasNumerator()) {
            tgt.setNumerator(VersionConvertor_40_50.convertQuantity(src.getNumerator()));
        }
        if (src.hasDenominator()) {
            tgt.setDenominator(VersionConvertor_40_50.convertQuantity(src.getDenominator()));
        }
        return tgt;
    }

    public static Reference convertReference(org.hl7.fhir.r4.model.Reference src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Reference tgt = new Reference();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasReference()) {
            tgt.setReferenceElement(VersionConvertor_40_50.convertString(src.getReferenceElement_()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(VersionConvertor_40_50.convertUri(src.getTypeElement()));
        }
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_40_50.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasDisplay()) {
            tgt.setDisplayElement(VersionConvertor_40_50.convertString(src.getDisplayElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Reference convertReference(Reference src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.Reference tgt = new org.hl7.fhir.r4.model.Reference();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasReference()) {
            tgt.setReferenceElement(VersionConvertor_40_50.convertString(src.getReferenceElement_()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(VersionConvertor_40_50.convertUri(src.getTypeElement()));
        }
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_40_50.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasDisplay()) {
            tgt.setDisplayElement(VersionConvertor_40_50.convertString(src.getDisplayElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.RelatedArtifact convertRelatedArtifact(RelatedArtifact src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.RelatedArtifact tgt = new org.hl7.fhir.r5.model.RelatedArtifact();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(VersionConvertor_40_50.convertRelatedArtifactType(src.getTypeElement()));
        }
        if (src.hasLabel()) {
            tgt.setLabelElement(VersionConvertor_40_50.convertString(src.getLabelElement()));
        }
        if (src.hasDisplay()) {
            tgt.setDisplayElement(VersionConvertor_40_50.convertString(src.getDisplayElement()));
        }
        if (src.hasCitation()) {
            tgt.setCitationElement(VersionConvertor_40_50.convertMarkdown(src.getCitationElement()));
        }
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_40_50.convertUrl(src.getUrlElement()));
        }
        if (src.hasDocument()) {
            tgt.setDocument(VersionConvertor_40_50.convertAttachment(src.getDocument()));
        }
        if (src.hasResource()) {
            tgt.setResourceElement(VersionConvertor_40_50.convertCanonical(src.getResourceElement()));
        }
        return tgt;
    }

    public static RelatedArtifact convertRelatedArtifact(org.hl7.fhir.r5.model.RelatedArtifact src) throws FHIRException {
        if (src == null) {
            return null;
        }
        RelatedArtifact tgt = new RelatedArtifact();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(VersionConvertor_40_50.convertRelatedArtifactType(src.getTypeElement()));
        }
        if (src.hasLabel()) {
            tgt.setLabelElement(VersionConvertor_40_50.convertString(src.getLabelElement()));
        }
        if (src.hasDisplay()) {
            tgt.setDisplayElement(VersionConvertor_40_50.convertString(src.getDisplayElement()));
        }
        if (src.hasCitation()) {
            tgt.setCitationElement(VersionConvertor_40_50.convertMarkdown(src.getCitationElement()));
        }
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_40_50.convertUrl(src.getUrlElement()));
        }
        if (src.hasDocument()) {
            tgt.setDocument(VersionConvertor_40_50.convertAttachment(src.getDocument()));
        }
        if (src.hasResource()) {
            tgt.setResourceElement(VersionConvertor_40_50.convertCanonical(src.getResourceElement()));
        }
        return tgt;
    }

    public static Enumeration<RelatedArtifact.RelatedArtifactType> convertRelatedArtifactType(org.hl7.fhir.r4.model.Enumeration<RelatedArtifact.RelatedArtifactType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<RelatedArtifact.RelatedArtifactType> tgt = new Enumeration<RelatedArtifact.RelatedArtifactType>(new RelatedArtifact.RelatedArtifactTypeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((RelatedArtifact.RelatedArtifactType)((Object)src.getValue())) {
            case DOCUMENTATION: {
                tgt.setValue((Object)RelatedArtifact.RelatedArtifactType.DOCUMENTATION);
                break;
            }
            case JUSTIFICATION: {
                tgt.setValue((Object)RelatedArtifact.RelatedArtifactType.JUSTIFICATION);
                break;
            }
            case CITATION: {
                tgt.setValue((Object)RelatedArtifact.RelatedArtifactType.CITATION);
                break;
            }
            case PREDECESSOR: {
                tgt.setValue((Object)RelatedArtifact.RelatedArtifactType.PREDECESSOR);
                break;
            }
            case SUCCESSOR: {
                tgt.setValue((Object)RelatedArtifact.RelatedArtifactType.SUCCESSOR);
                break;
            }
            case DERIVEDFROM: {
                tgt.setValue((Object)RelatedArtifact.RelatedArtifactType.DERIVEDFROM);
                break;
            }
            case DEPENDSON: {
                tgt.setValue((Object)RelatedArtifact.RelatedArtifactType.DEPENDSON);
                break;
            }
            case COMPOSEDOF: {
                tgt.setValue((Object)RelatedArtifact.RelatedArtifactType.COMPOSEDOF);
                break;
            }
            default: {
                tgt.setValue((Object)RelatedArtifact.RelatedArtifactType.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Enumeration<RelatedArtifact.RelatedArtifactType> convertRelatedArtifactType(Enumeration<RelatedArtifact.RelatedArtifactType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Enumeration<RelatedArtifact.RelatedArtifactType> tgt = new org.hl7.fhir.r4.model.Enumeration<RelatedArtifact.RelatedArtifactType>(new RelatedArtifact.RelatedArtifactTypeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((RelatedArtifact.RelatedArtifactType)((Object)src.getValue())) {
            case DOCUMENTATION: {
                tgt.setValue((Object)RelatedArtifact.RelatedArtifactType.DOCUMENTATION);
                break;
            }
            case JUSTIFICATION: {
                tgt.setValue((Object)RelatedArtifact.RelatedArtifactType.JUSTIFICATION);
                break;
            }
            case CITATION: {
                tgt.setValue((Object)RelatedArtifact.RelatedArtifactType.CITATION);
                break;
            }
            case PREDECESSOR: {
                tgt.setValue((Object)RelatedArtifact.RelatedArtifactType.PREDECESSOR);
                break;
            }
            case SUCCESSOR: {
                tgt.setValue((Object)RelatedArtifact.RelatedArtifactType.SUCCESSOR);
                break;
            }
            case DERIVEDFROM: {
                tgt.setValue((Object)RelatedArtifact.RelatedArtifactType.DERIVEDFROM);
                break;
            }
            case DEPENDSON: {
                tgt.setValue((Object)RelatedArtifact.RelatedArtifactType.DEPENDSON);
                break;
            }
            case COMPOSEDOF: {
                tgt.setValue((Object)RelatedArtifact.RelatedArtifactType.COMPOSEDOF);
                break;
            }
            default: {
                tgt.setValue((Object)RelatedArtifact.RelatedArtifactType.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.SampledData convertSampledData(SampledData src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.SampledData tgt = new org.hl7.fhir.r5.model.SampledData();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasOrigin()) {
            tgt.setOrigin(VersionConvertor_40_50.convertSimpleQuantity(src.getOrigin()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriodElement(VersionConvertor_40_50.convertDecimal(src.getPeriodElement()));
        }
        if (src.hasFactor()) {
            tgt.setFactorElement(VersionConvertor_40_50.convertDecimal(src.getFactorElement()));
        }
        if (src.hasLowerLimit()) {
            tgt.setLowerLimitElement(VersionConvertor_40_50.convertDecimal(src.getLowerLimitElement()));
        }
        if (src.hasUpperLimit()) {
            tgt.setUpperLimitElement(VersionConvertor_40_50.convertDecimal(src.getUpperLimitElement()));
        }
        if (src.hasDimensions()) {
            tgt.setDimensionsElement(VersionConvertor_40_50.convertPositiveInt(src.getDimensionsElement()));
        }
        if (src.hasData()) {
            tgt.setDataElement(VersionConvertor_40_50.convertString(src.getDataElement()));
        }
        return tgt;
    }

    public static SampledData convertSampledData(org.hl7.fhir.r5.model.SampledData src) throws FHIRException {
        if (src == null) {
            return null;
        }
        SampledData tgt = new SampledData();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasOrigin()) {
            tgt.setOrigin(VersionConvertor_40_50.convertSimpleQuantity(src.getOrigin()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriodElement(VersionConvertor_40_50.convertDecimal(src.getPeriodElement()));
        }
        if (src.hasFactor()) {
            tgt.setFactorElement(VersionConvertor_40_50.convertDecimal(src.getFactorElement()));
        }
        if (src.hasLowerLimit()) {
            tgt.setLowerLimitElement(VersionConvertor_40_50.convertDecimal(src.getLowerLimitElement()));
        }
        if (src.hasUpperLimit()) {
            tgt.setUpperLimitElement(VersionConvertor_40_50.convertDecimal(src.getUpperLimitElement()));
        }
        if (src.hasDimensions()) {
            tgt.setDimensionsElement(VersionConvertor_40_50.convertPositiveInt(src.getDimensionsElement()));
        }
        if (src.hasData()) {
            tgt.setDataElement(VersionConvertor_40_50.convertString(src.getDataElement()));
        }
        return tgt;
    }

    public static Signature convertSignature(org.hl7.fhir.r4.model.Signature src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Signature tgt = new Signature();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        for (Coding t : src.getType()) {
            tgt.addType(VersionConvertor_40_50.convertCoding(t));
        }
        if (src.hasWhen()) {
            tgt.setWhenElement(VersionConvertor_40_50.convertInstant(src.getWhenElement()));
        }
        if (src.hasWho()) {
            tgt.setWho(VersionConvertor_40_50.convertReference(src.getWho()));
        }
        if (src.hasOnBehalfOf()) {
            tgt.setOnBehalfOf(VersionConvertor_40_50.convertReference(src.getOnBehalfOf()));
        }
        if (src.hasTargetFormat()) {
            tgt.setTargetFormatElement(VersionConvertor_40_50.convertCode(src.getTargetFormatElement()));
        }
        if (src.hasSigFormat()) {
            tgt.setSigFormatElement(VersionConvertor_40_50.convertCode(src.getSigFormatElement()));
        }
        if (src.hasData()) {
            tgt.setDataElement(VersionConvertor_40_50.convertBase64Binary(src.getDataElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Signature convertSignature(Signature src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.Signature tgt = new org.hl7.fhir.r4.model.Signature();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        for (org.hl7.fhir.r5.model.Coding t : src.getType()) {
            tgt.addType(VersionConvertor_40_50.convertCoding(t));
        }
        if (src.hasWhen()) {
            tgt.setWhenElement(VersionConvertor_40_50.convertInstant(src.getWhenElement()));
        }
        if (src.hasWho()) {
            tgt.setWho(VersionConvertor_40_50.convertReference(src.getWho()));
        }
        if (src.hasOnBehalfOf()) {
            tgt.setOnBehalfOf(VersionConvertor_40_50.convertReference(src.getOnBehalfOf()));
        }
        if (src.hasTargetFormat()) {
            tgt.setTargetFormatElement(VersionConvertor_40_50.convertCode(src.getTargetFormatElement()));
        }
        if (src.hasSigFormat()) {
            tgt.setSigFormatElement(VersionConvertor_40_50.convertCode(src.getSigFormatElement()));
        }
        if (src.hasData()) {
            tgt.setDataElement(VersionConvertor_40_50.convertBase64Binary(src.getDataElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.SubstanceAmount convertSubstanceAmount(SubstanceAmount src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.SubstanceAmount tgt = new org.hl7.fhir.r5.model.SubstanceAmount();
        VersionConvertor_40_50.copyBackboneElement(src, tgt);
        if (src.hasAmount()) {
            tgt.setAmount(VersionConvertor_40_50.convertType(src.getAmount()));
        }
        if (src.hasAmountType()) {
            tgt.setAmountType(VersionConvertor_40_50.convertCodeableConcept(src.getAmountType()));
        }
        if (src.hasAmountText()) {
            tgt.setAmountTextElement(VersionConvertor_40_50.convertString(src.getAmountTextElement()));
        }
        if (src.hasReferenceRange()) {
            tgt.setReferenceRange(VersionConvertor_40_50.convertSubstanceAmountReferenceRangeComponent(src.getReferenceRange()));
        }
        return tgt;
    }

    public static SubstanceAmount convertSubstanceAmount(org.hl7.fhir.r5.model.SubstanceAmount src) throws FHIRException {
        if (src == null) {
            return null;
        }
        SubstanceAmount tgt = new SubstanceAmount();
        VersionConvertor_40_50.copyBackboneElement(src, tgt);
        if (src.hasAmount()) {
            tgt.setAmount(VersionConvertor_40_50.convertType(src.getAmount()));
        }
        if (src.hasAmountType()) {
            tgt.setAmountType(VersionConvertor_40_50.convertCodeableConcept(src.getAmountType()));
        }
        if (src.hasAmountText()) {
            tgt.setAmountTextElement(VersionConvertor_40_50.convertString(src.getAmountTextElement()));
        }
        if (src.hasReferenceRange()) {
            tgt.setReferenceRange(VersionConvertor_40_50.convertSubstanceAmountReferenceRangeComponent(src.getReferenceRange()));
        }
        return tgt;
    }

    public static SubstanceAmount.SubstanceAmountReferenceRangeComponent convertSubstanceAmountReferenceRangeComponent(SubstanceAmount.SubstanceAmountReferenceRangeComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        SubstanceAmount.SubstanceAmountReferenceRangeComponent tgt = new SubstanceAmount.SubstanceAmountReferenceRangeComponent();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasLowLimit()) {
            tgt.setLowLimit(VersionConvertor_40_50.convertQuantity(src.getLowLimit()));
        }
        if (src.hasHighLimit()) {
            tgt.setHighLimit(VersionConvertor_40_50.convertQuantity(src.getHighLimit()));
        }
        return tgt;
    }

    public static SubstanceAmount.SubstanceAmountReferenceRangeComponent convertSubstanceAmountReferenceRangeComponent(SubstanceAmount.SubstanceAmountReferenceRangeComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        SubstanceAmount.SubstanceAmountReferenceRangeComponent tgt = new SubstanceAmount.SubstanceAmountReferenceRangeComponent();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasLowLimit()) {
            tgt.setLowLimit(VersionConvertor_40_50.convertQuantity(src.getLowLimit()));
        }
        if (src.hasHighLimit()) {
            tgt.setHighLimit(VersionConvertor_40_50.convertQuantity(src.getHighLimit()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Timing convertTiming(Timing src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.Timing tgt = new org.hl7.fhir.r5.model.Timing();
        VersionConvertor_40_50.copyBackboneElement(src, tgt);
        for (org.hl7.fhir.r4.model.DateTimeType t : src.getEvent()) {
            tgt.getEvent().add(VersionConvertor_40_50.convertDateTime(t));
        }
        if (src.hasRepeat()) {
            tgt.setRepeat(VersionConvertor_40_50.convertTimingRepeatComponent(src.getRepeat()));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_40_50.convertCodeableConcept(src.getCode()));
        }
        return tgt;
    }

    public static Timing convertTiming(org.hl7.fhir.r5.model.Timing src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Timing tgt = new Timing();
        VersionConvertor_40_50.copyBackboneElement(src, tgt);
        for (DateTimeType t : src.getEvent()) {
            tgt.getEvent().add(VersionConvertor_40_50.convertDateTime(t));
        }
        if (src.hasRepeat()) {
            tgt.setRepeat(VersionConvertor_40_50.convertTimingRepeatComponent(src.getRepeat()));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_40_50.convertCodeableConcept(src.getCode()));
        }
        return tgt;
    }

    public static Timing.TimingRepeatComponent convertTimingRepeatComponent(Timing.TimingRepeatComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Timing.TimingRepeatComponent tgt = new Timing.TimingRepeatComponent();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasBounds()) {
            tgt.setBounds(VersionConvertor_40_50.convertType(src.getBounds()));
        }
        if (src.hasCount()) {
            tgt.setCountElement(VersionConvertor_40_50.convertPositiveInt(src.getCountElement()));
        }
        if (src.hasCountMax()) {
            tgt.setCountMaxElement(VersionConvertor_40_50.convertPositiveInt(src.getCountMaxElement()));
        }
        if (src.hasDuration()) {
            tgt.setDurationElement(VersionConvertor_40_50.convertDecimal(src.getDurationElement()));
        }
        if (src.hasDurationMax()) {
            tgt.setDurationMaxElement(VersionConvertor_40_50.convertDecimal(src.getDurationMaxElement()));
        }
        if (src.hasDurationUnit()) {
            tgt.setDurationUnitElement(VersionConvertor_40_50.convertUnitsOfTime(src.getDurationUnitElement()));
        }
        if (src.hasFrequency()) {
            tgt.setFrequencyElement(VersionConvertor_40_50.convertPositiveInt(src.getFrequencyElement()));
        }
        if (src.hasFrequencyMax()) {
            tgt.setFrequencyMaxElement(VersionConvertor_40_50.convertPositiveInt(src.getFrequencyMaxElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriodElement(VersionConvertor_40_50.convertDecimal(src.getPeriodElement()));
        }
        if (src.hasPeriodMax()) {
            tgt.setPeriodMaxElement(VersionConvertor_40_50.convertDecimal(src.getPeriodMaxElement()));
        }
        if (src.hasPeriodUnit()) {
            tgt.setPeriodUnitElement(VersionConvertor_40_50.convertUnitsOfTime(src.getPeriodUnitElement()));
        }
        tgt.setDayOfWeek(src.getDayOfWeek().stream().map(VersionConvertor_40_50::convertDayOfWeek).collect(Collectors.toList()));
        tgt.setWhen(src.getWhen().stream().map(VersionConvertor_40_50::convertEventTiming).collect(Collectors.toList()));
        for (org.hl7.fhir.r4.model.TimeType t : src.getTimeOfDay()) {
            tgt.getTimeOfDay().add(VersionConvertor_40_50.convertTime(t));
        }
        if (src.hasOffset()) {
            tgt.setOffsetElement(VersionConvertor_40_50.convertUnsignedInt(src.getOffsetElement()));
        }
        return tgt;
    }

    public static Timing.TimingRepeatComponent convertTimingRepeatComponent(Timing.TimingRepeatComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Timing.TimingRepeatComponent tgt = new Timing.TimingRepeatComponent();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasBounds()) {
            tgt.setBounds(VersionConvertor_40_50.convertType(src.getBounds()));
        }
        if (src.hasCount()) {
            tgt.setCountElement(VersionConvertor_40_50.convertPositiveInt(src.getCountElement()));
        }
        if (src.hasCountMax()) {
            tgt.setCountMaxElement(VersionConvertor_40_50.convertPositiveInt(src.getCountMaxElement()));
        }
        if (src.hasDuration()) {
            tgt.setDurationElement(VersionConvertor_40_50.convertDecimal(src.getDurationElement()));
        }
        if (src.hasDurationMax()) {
            tgt.setDurationMaxElement(VersionConvertor_40_50.convertDecimal(src.getDurationMaxElement()));
        }
        if (src.hasDurationUnit()) {
            tgt.setDurationUnitElement(VersionConvertor_40_50.convertUnitsOfTime(src.getDurationUnitElement()));
        }
        if (src.hasFrequency()) {
            tgt.setFrequencyElement(VersionConvertor_40_50.convertPositiveInt(src.getFrequencyElement()));
        }
        if (src.hasFrequencyMax()) {
            tgt.setFrequencyMaxElement(VersionConvertor_40_50.convertPositiveInt(src.getFrequencyMaxElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriodElement(VersionConvertor_40_50.convertDecimal(src.getPeriodElement()));
        }
        if (src.hasPeriodMax()) {
            tgt.setPeriodMaxElement(VersionConvertor_40_50.convertDecimal(src.getPeriodMaxElement()));
        }
        if (src.hasPeriodUnit()) {
            tgt.setPeriodUnitElement(VersionConvertor_40_50.convertUnitsOfTime(src.getPeriodUnitElement()));
        }
        tgt.setDayOfWeek(src.getDayOfWeek().stream().map(VersionConvertor_40_50::convertDayOfWeek).collect(Collectors.toList()));
        tgt.setWhen(src.getWhen().stream().map(VersionConvertor_40_50::convertEventTiming).collect(Collectors.toList()));
        for (TimeType t : src.getTimeOfDay()) {
            tgt.getTimeOfDay().add(VersionConvertor_40_50.convertTime(t));
        }
        if (src.hasOffset()) {
            tgt.setOffsetElement(VersionConvertor_40_50.convertUnsignedInt(src.getOffsetElement()));
        }
        return tgt;
    }

    public static Enumeration<Timing.UnitsOfTime> convertUnitsOfTime(org.hl7.fhir.r4.model.Enumeration<Timing.UnitsOfTime> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Timing.UnitsOfTime> tgt = new Enumeration<Timing.UnitsOfTime>(new Timing.UnitsOfTimeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Timing.UnitsOfTime)((Object)src.getValue())) {
            case S: {
                tgt.setValue((Object)Timing.UnitsOfTime.S);
                break;
            }
            case MIN: {
                tgt.setValue((Object)Timing.UnitsOfTime.MIN);
                break;
            }
            case H: {
                tgt.setValue((Object)Timing.UnitsOfTime.H);
                break;
            }
            case D: {
                tgt.setValue((Object)Timing.UnitsOfTime.D);
                break;
            }
            case WK: {
                tgt.setValue((Object)Timing.UnitsOfTime.WK);
                break;
            }
            case MO: {
                tgt.setValue((Object)Timing.UnitsOfTime.MO);
                break;
            }
            case A: {
                tgt.setValue((Object)Timing.UnitsOfTime.A);
                break;
            }
            default: {
                tgt.setValue((Object)Timing.UnitsOfTime.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Enumeration<Timing.UnitsOfTime> convertUnitsOfTime(Enumeration<Timing.UnitsOfTime> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Enumeration<Timing.UnitsOfTime> tgt = new org.hl7.fhir.r4.model.Enumeration<Timing.UnitsOfTime>(new Timing.UnitsOfTimeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Timing.UnitsOfTime)((Object)src.getValue())) {
            case S: {
                tgt.setValue((Object)Timing.UnitsOfTime.S);
                break;
            }
            case MIN: {
                tgt.setValue((Object)Timing.UnitsOfTime.MIN);
                break;
            }
            case H: {
                tgt.setValue((Object)Timing.UnitsOfTime.H);
                break;
            }
            case D: {
                tgt.setValue((Object)Timing.UnitsOfTime.D);
                break;
            }
            case WK: {
                tgt.setValue((Object)Timing.UnitsOfTime.WK);
                break;
            }
            case MO: {
                tgt.setValue((Object)Timing.UnitsOfTime.MO);
                break;
            }
            case A: {
                tgt.setValue((Object)Timing.UnitsOfTime.A);
                break;
            }
            default: {
                tgt.setValue((Object)Timing.UnitsOfTime.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Enumerations.DaysOfWeek> convertDayOfWeek(org.hl7.fhir.r4.model.Enumeration<Timing.DayOfWeek> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Enumerations.DaysOfWeek> tgt = new Enumeration<Enumerations.DaysOfWeek>(new Enumerations.DaysOfWeekEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Timing.DayOfWeek)((Object)src.getValue())) {
            case MON: {
                tgt.setValue((Object)Enumerations.DaysOfWeek.MON);
                break;
            }
            case TUE: {
                tgt.setValue((Object)Enumerations.DaysOfWeek.TUE);
                break;
            }
            case WED: {
                tgt.setValue((Object)Enumerations.DaysOfWeek.WED);
                break;
            }
            case THU: {
                tgt.setValue((Object)Enumerations.DaysOfWeek.THU);
                break;
            }
            case FRI: {
                tgt.setValue((Object)Enumerations.DaysOfWeek.FRI);
                break;
            }
            case SAT: {
                tgt.setValue((Object)Enumerations.DaysOfWeek.SAT);
                break;
            }
            case SUN: {
                tgt.setValue((Object)Enumerations.DaysOfWeek.SUN);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.DaysOfWeek.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Enumeration<Timing.DayOfWeek> convertDayOfWeek(Enumeration<Enumerations.DaysOfWeek> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Enumeration<Timing.DayOfWeek> tgt = new org.hl7.fhir.r4.model.Enumeration<Timing.DayOfWeek>(new Timing.DayOfWeekEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.DaysOfWeek)((Object)src.getValue())) {
            case MON: {
                tgt.setValue((Object)Timing.DayOfWeek.MON);
                break;
            }
            case TUE: {
                tgt.setValue((Object)Timing.DayOfWeek.TUE);
                break;
            }
            case WED: {
                tgt.setValue((Object)Timing.DayOfWeek.WED);
                break;
            }
            case THU: {
                tgt.setValue((Object)Timing.DayOfWeek.THU);
                break;
            }
            case FRI: {
                tgt.setValue((Object)Timing.DayOfWeek.FRI);
                break;
            }
            case SAT: {
                tgt.setValue((Object)Timing.DayOfWeek.SAT);
                break;
            }
            case SUN: {
                tgt.setValue((Object)Timing.DayOfWeek.SUN);
                break;
            }
            default: {
                tgt.setValue((Object)Timing.DayOfWeek.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Timing.EventTiming> convertEventTiming(org.hl7.fhir.r4.model.Enumeration<Timing.EventTiming> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Timing.EventTiming> tgt = new Enumeration<Timing.EventTiming>(new Timing.EventTimingEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Timing.EventTiming)((Object)src.getValue())) {
            case MORN: {
                tgt.setValue((Object)Timing.EventTiming.MORN);
                break;
            }
            case MORN_EARLY: {
                tgt.setValue((Object)Timing.EventTiming.MORN_EARLY);
                break;
            }
            case MORN_LATE: {
                tgt.setValue((Object)Timing.EventTiming.MORN_LATE);
                break;
            }
            case NOON: {
                tgt.setValue((Object)Timing.EventTiming.NOON);
                break;
            }
            case AFT: {
                tgt.setValue((Object)Timing.EventTiming.AFT);
                break;
            }
            case AFT_EARLY: {
                tgt.setValue((Object)Timing.EventTiming.AFT_EARLY);
                break;
            }
            case AFT_LATE: {
                tgt.setValue((Object)Timing.EventTiming.AFT_LATE);
                break;
            }
            case EVE: {
                tgt.setValue((Object)Timing.EventTiming.EVE);
                break;
            }
            case EVE_EARLY: {
                tgt.setValue((Object)Timing.EventTiming.EVE_EARLY);
                break;
            }
            case EVE_LATE: {
                tgt.setValue((Object)Timing.EventTiming.EVE_LATE);
                break;
            }
            case NIGHT: {
                tgt.setValue((Object)Timing.EventTiming.NIGHT);
                break;
            }
            case PHS: {
                tgt.setValue((Object)Timing.EventTiming.PHS);
                break;
            }
            case HS: {
                tgt.setValue((Object)Timing.EventTiming.HS);
                break;
            }
            case WAKE: {
                tgt.setValue((Object)Timing.EventTiming.WAKE);
                break;
            }
            case C: {
                tgt.setValue((Object)Timing.EventTiming.C);
                break;
            }
            case CM: {
                tgt.setValue((Object)Timing.EventTiming.CM);
                break;
            }
            case CD: {
                tgt.setValue((Object)Timing.EventTiming.CD);
                break;
            }
            case CV: {
                tgt.setValue((Object)Timing.EventTiming.CV);
                break;
            }
            case AC: {
                tgt.setValue((Object)Timing.EventTiming.AC);
                break;
            }
            case ACM: {
                tgt.setValue((Object)Timing.EventTiming.ACM);
                break;
            }
            case ACD: {
                tgt.setValue((Object)Timing.EventTiming.ACD);
                break;
            }
            case ACV: {
                tgt.setValue((Object)Timing.EventTiming.ACV);
                break;
            }
            case PC: {
                tgt.setValue((Object)Timing.EventTiming.PC);
                break;
            }
            case PCM: {
                tgt.setValue((Object)Timing.EventTiming.PCM);
                break;
            }
            case PCD: {
                tgt.setValue((Object)Timing.EventTiming.PCD);
                break;
            }
            case PCV: {
                tgt.setValue((Object)Timing.EventTiming.PCV);
                break;
            }
            default: {
                tgt.setValue((Object)Timing.EventTiming.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Enumeration<Timing.EventTiming> convertEventTiming(Enumeration<Timing.EventTiming> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Enumeration<Timing.EventTiming> tgt = new org.hl7.fhir.r4.model.Enumeration<Timing.EventTiming>(new Timing.EventTimingEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Timing.EventTiming)((Object)src.getValue())) {
            case MORN: {
                tgt.setValue((Object)Timing.EventTiming.MORN);
                break;
            }
            case MORN_EARLY: {
                tgt.setValue((Object)Timing.EventTiming.MORN_EARLY);
                break;
            }
            case MORN_LATE: {
                tgt.setValue((Object)Timing.EventTiming.MORN_LATE);
                break;
            }
            case NOON: {
                tgt.setValue((Object)Timing.EventTiming.NOON);
                break;
            }
            case AFT: {
                tgt.setValue((Object)Timing.EventTiming.AFT);
                break;
            }
            case AFT_EARLY: {
                tgt.setValue((Object)Timing.EventTiming.AFT_EARLY);
                break;
            }
            case AFT_LATE: {
                tgt.setValue((Object)Timing.EventTiming.AFT_LATE);
                break;
            }
            case EVE: {
                tgt.setValue((Object)Timing.EventTiming.EVE);
                break;
            }
            case EVE_EARLY: {
                tgt.setValue((Object)Timing.EventTiming.EVE_EARLY);
                break;
            }
            case EVE_LATE: {
                tgt.setValue((Object)Timing.EventTiming.EVE_LATE);
                break;
            }
            case NIGHT: {
                tgt.setValue((Object)Timing.EventTiming.NIGHT);
                break;
            }
            case PHS: {
                tgt.setValue((Object)Timing.EventTiming.PHS);
                break;
            }
            case HS: {
                tgt.setValue((Object)Timing.EventTiming.HS);
                break;
            }
            case WAKE: {
                tgt.setValue((Object)Timing.EventTiming.WAKE);
                break;
            }
            case C: {
                tgt.setValue((Object)Timing.EventTiming.C);
                break;
            }
            case CM: {
                tgt.setValue((Object)Timing.EventTiming.CM);
                break;
            }
            case CD: {
                tgt.setValue((Object)Timing.EventTiming.CD);
                break;
            }
            case CV: {
                tgt.setValue((Object)Timing.EventTiming.CV);
                break;
            }
            case AC: {
                tgt.setValue((Object)Timing.EventTiming.AC);
                break;
            }
            case ACM: {
                tgt.setValue((Object)Timing.EventTiming.ACM);
                break;
            }
            case ACD: {
                tgt.setValue((Object)Timing.EventTiming.ACD);
                break;
            }
            case ACV: {
                tgt.setValue((Object)Timing.EventTiming.ACV);
                break;
            }
            case PC: {
                tgt.setValue((Object)Timing.EventTiming.PC);
                break;
            }
            case PCM: {
                tgt.setValue((Object)Timing.EventTiming.PCM);
                break;
            }
            case PCD: {
                tgt.setValue((Object)Timing.EventTiming.PCD);
                break;
            }
            case PCV: {
                tgt.setValue((Object)Timing.EventTiming.PCV);
                break;
            }
            default: {
                tgt.setValue((Object)Timing.EventTiming.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.TriggerDefinition convertTriggerDefinition(TriggerDefinition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.TriggerDefinition tgt = new org.hl7.fhir.r5.model.TriggerDefinition();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(VersionConvertor_40_50.convertTriggerType(src.getTypeElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_40_50.convertString(src.getNameElement()));
        }
        if (src.hasTiming()) {
            tgt.setTiming(VersionConvertor_40_50.convertType(src.getTiming()));
        }
        for (DataRequirement t : src.getData()) {
            tgt.addData(VersionConvertor_40_50.convertDataRequirement(t));
        }
        if (src.hasCondition()) {
            tgt.setCondition(VersionConvertor_40_50.convertExpression(src.getCondition()));
        }
        return tgt;
    }

    public static TriggerDefinition convertTriggerDefinition(org.hl7.fhir.r5.model.TriggerDefinition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TriggerDefinition tgt = new TriggerDefinition();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(VersionConvertor_40_50.convertTriggerType(src.getTypeElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_40_50.convertString(src.getNameElement()));
        }
        if (src.hasTiming()) {
            tgt.setTiming(VersionConvertor_40_50.convertType(src.getTiming()));
        }
        for (org.hl7.fhir.r5.model.DataRequirement t : src.getData()) {
            tgt.addData(VersionConvertor_40_50.convertDataRequirement(t));
        }
        if (src.hasCondition()) {
            tgt.setCondition(VersionConvertor_40_50.convertExpression(src.getCondition()));
        }
        return tgt;
    }

    public static Enumeration<TriggerDefinition.TriggerType> convertTriggerType(org.hl7.fhir.r4.model.Enumeration<TriggerDefinition.TriggerType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<TriggerDefinition.TriggerType> tgt = new Enumeration<TriggerDefinition.TriggerType>(new TriggerDefinition.TriggerTypeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((TriggerDefinition.TriggerType)((Object)src.getValue())) {
            case NAMEDEVENT: {
                tgt.setValue((Object)TriggerDefinition.TriggerType.NAMEDEVENT);
                break;
            }
            case PERIODIC: {
                tgt.setValue((Object)TriggerDefinition.TriggerType.PERIODIC);
                break;
            }
            case DATACHANGED: {
                tgt.setValue((Object)TriggerDefinition.TriggerType.DATACHANGED);
                break;
            }
            case DATAADDED: {
                tgt.setValue((Object)TriggerDefinition.TriggerType.DATAADDED);
                break;
            }
            case DATAMODIFIED: {
                tgt.setValue((Object)TriggerDefinition.TriggerType.DATAMODIFIED);
                break;
            }
            case DATAREMOVED: {
                tgt.setValue((Object)TriggerDefinition.TriggerType.DATAREMOVED);
                break;
            }
            case DATAACCESSED: {
                tgt.setValue((Object)TriggerDefinition.TriggerType.DATAACCESSED);
                break;
            }
            case DATAACCESSENDED: {
                tgt.setValue((Object)TriggerDefinition.TriggerType.DATAACCESSENDED);
                break;
            }
            default: {
                tgt.setValue((Object)TriggerDefinition.TriggerType.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Enumeration<TriggerDefinition.TriggerType> convertTriggerType(Enumeration<TriggerDefinition.TriggerType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Enumeration<TriggerDefinition.TriggerType> tgt = new org.hl7.fhir.r4.model.Enumeration<TriggerDefinition.TriggerType>(new TriggerDefinition.TriggerTypeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((TriggerDefinition.TriggerType)((Object)src.getValue())) {
            case NAMEDEVENT: {
                tgt.setValue((Object)TriggerDefinition.TriggerType.NAMEDEVENT);
                break;
            }
            case PERIODIC: {
                tgt.setValue((Object)TriggerDefinition.TriggerType.PERIODIC);
                break;
            }
            case DATACHANGED: {
                tgt.setValue((Object)TriggerDefinition.TriggerType.DATACHANGED);
                break;
            }
            case DATAADDED: {
                tgt.setValue((Object)TriggerDefinition.TriggerType.DATAADDED);
                break;
            }
            case DATAMODIFIED: {
                tgt.setValue((Object)TriggerDefinition.TriggerType.DATAMODIFIED);
                break;
            }
            case DATAREMOVED: {
                tgt.setValue((Object)TriggerDefinition.TriggerType.DATAREMOVED);
                break;
            }
            case DATAACCESSED: {
                tgt.setValue((Object)TriggerDefinition.TriggerType.DATAACCESSED);
                break;
            }
            case DATAACCESSENDED: {
                tgt.setValue((Object)TriggerDefinition.TriggerType.DATAACCESSENDED);
                break;
            }
            default: {
                tgt.setValue((Object)TriggerDefinition.TriggerType.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.UsageContext convertUsageContext(UsageContext src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.UsageContext tgt = new org.hl7.fhir.r5.model.UsageContext();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_40_50.convertCoding(src.getCode()));
        }
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_40_50.convertType(src.getValue()));
        }
        return tgt;
    }

    public static UsageContext convertUsageContext(org.hl7.fhir.r5.model.UsageContext src) throws FHIRException {
        if (src == null) {
            return null;
        }
        UsageContext tgt = new UsageContext();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_40_50.convertCoding(src.getCode()));
        }
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_40_50.convertType(src.getValue()));
        }
        return tgt;
    }

    public static ElementDefinition convertElementDefinition(org.hl7.fhir.r4.model.ElementDefinition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ElementDefinition tgt = new ElementDefinition();
        VersionConvertor_40_50.copyBackboneElement(src, tgt);
        if (src.hasPath()) {
            tgt.setPathElement(VersionConvertor_40_50.convertString(src.getPathElement()));
        }
        tgt.setRepresentation(src.getRepresentation().stream().map(VersionConvertor_40_50::convertPropertyRepresentation).collect(Collectors.toList()));
        if (src.hasSliceName()) {
            tgt.setSliceNameElement(VersionConvertor_40_50.convertString(src.getSliceNameElement()));
        }
        if (src.hasSliceIsConstraining()) {
            tgt.setSliceIsConstrainingElement(VersionConvertor_40_50.convertBoolean(src.getSliceIsConstrainingElement()));
        }
        if (src.hasLabel()) {
            tgt.setLabelElement(VersionConvertor_40_50.convertString(src.getLabelElement()));
        }
        for (Coding coding : src.getCode()) {
            tgt.addCode(VersionConvertor_40_50.convertCoding(coding));
        }
        if (src.hasSlicing()) {
            tgt.setSlicing(VersionConvertor_40_50.convertElementDefinitionSlicingComponent(src.getSlicing()));
        }
        if (src.hasShort()) {
            tgt.setShortElement(VersionConvertor_40_50.convertString(src.getShortElement()));
        }
        if (src.hasDefinition()) {
            tgt.setDefinitionElement(VersionConvertor_40_50.convertMarkdown(src.getDefinitionElement()));
        }
        if (src.hasComment()) {
            tgt.setCommentElement(VersionConvertor_40_50.convertMarkdown(src.getCommentElement()));
        }
        if (src.hasRequirements()) {
            tgt.setRequirementsElement(VersionConvertor_40_50.convertMarkdown(src.getRequirementsElement()));
        }
        for (StringType stringType : src.getAlias()) {
            tgt.getAlias().add(VersionConvertor_40_50.convertString(stringType));
        }
        if (src.hasMin()) {
            tgt.setMinElement(VersionConvertor_40_50.convertUnsignedInt(src.getMinElement()));
        }
        if (src.hasMax()) {
            tgt.setMaxElement(VersionConvertor_40_50.convertString(src.getMaxElement()));
        }
        if (src.hasBase()) {
            tgt.setBase(VersionConvertor_40_50.convertElementDefinitionBaseComponent(src.getBase()));
        }
        if (src.hasContentReference()) {
            tgt.setContentReferenceElement(VersionConvertor_40_50.convertUri(src.getContentReferenceElement()));
        }
        for (ElementDefinition.TypeRefComponent typeRefComponent : src.getType()) {
            tgt.addType(VersionConvertor_40_50.convertTypeRefComponent(typeRefComponent));
        }
        if (src.hasDefaultValue()) {
            tgt.setDefaultValue(VersionConvertor_40_50.convertType(src.getDefaultValue()));
        }
        if (src.hasMeaningWhenMissing()) {
            tgt.setMeaningWhenMissingElement(VersionConvertor_40_50.convertMarkdown(src.getMeaningWhenMissingElement()));
        }
        if (src.hasOrderMeaning()) {
            tgt.setOrderMeaningElement(VersionConvertor_40_50.convertString(src.getOrderMeaningElement()));
        }
        if (src.hasFixed()) {
            tgt.setFixed(VersionConvertor_40_50.convertType(src.getFixed()));
        }
        if (src.hasPattern()) {
            tgt.setPattern(VersionConvertor_40_50.convertType(src.getPattern()));
        }
        for (ElementDefinition.ElementDefinitionExampleComponent elementDefinitionExampleComponent : src.getExample()) {
            tgt.addExample(VersionConvertor_40_50.convertElementDefinitionExampleComponent(elementDefinitionExampleComponent));
        }
        if (src.hasMinValue()) {
            tgt.setMinValue(VersionConvertor_40_50.convertType(src.getMinValue()));
        }
        if (src.hasMaxValue()) {
            tgt.setMaxValue(VersionConvertor_40_50.convertType(src.getMaxValue()));
        }
        if (src.hasMaxLength()) {
            tgt.setMaxLengthElement(VersionConvertor_40_50.convertInteger(src.getMaxLengthElement()));
        }
        for (org.hl7.fhir.r4.model.IdType idType : src.getCondition()) {
            tgt.getCondition().add(VersionConvertor_40_50.convertId(idType));
        }
        for (ElementDefinition.ElementDefinitionConstraintComponent elementDefinitionConstraintComponent : src.getConstraint()) {
            tgt.addConstraint(VersionConvertor_40_50.convertElementDefinitionConstraintComponent(elementDefinitionConstraintComponent));
        }
        if (src.hasMustSupport()) {
            tgt.setMustSupportElement(VersionConvertor_40_50.convertBoolean(src.getMustSupportElement()));
        }
        if (src.hasIsModifier()) {
            tgt.setIsModifierElement(VersionConvertor_40_50.convertBoolean(src.getIsModifierElement()));
        }
        if (src.hasIsModifierReason()) {
            tgt.setIsModifierReasonElement(VersionConvertor_40_50.convertString(src.getIsModifierReasonElement()));
        }
        if (src.hasIsSummary()) {
            tgt.setIsSummaryElement(VersionConvertor_40_50.convertBoolean(src.getIsSummaryElement()));
        }
        if (src.hasBinding()) {
            tgt.setBinding(VersionConvertor_40_50.convertElementDefinitionBindingComponent(src.getBinding()));
        }
        for (ElementDefinition.ElementDefinitionMappingComponent elementDefinitionMappingComponent : src.getMapping()) {
            tgt.addMapping(VersionConvertor_40_50.convertElementDefinitionMappingComponent(elementDefinitionMappingComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.ElementDefinition convertElementDefinition(ElementDefinition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.ElementDefinition tgt = new org.hl7.fhir.r4.model.ElementDefinition();
        VersionConvertor_40_50.copyBackboneElement(src, tgt);
        if (src.hasPath()) {
            tgt.setPathElement(VersionConvertor_40_50.convertString(src.getPathElement()));
        }
        tgt.setRepresentation(src.getRepresentation().stream().map(VersionConvertor_40_50::convertPropertyRepresentation).collect(Collectors.toList()));
        if (src.hasSliceName()) {
            tgt.setSliceNameElement(VersionConvertor_40_50.convertString(src.getSliceNameElement()));
        }
        if (src.hasSliceIsConstraining()) {
            tgt.setSliceIsConstrainingElement(VersionConvertor_40_50.convertBoolean(src.getSliceIsConstrainingElement()));
        }
        if (src.hasLabel()) {
            tgt.setLabelElement(VersionConvertor_40_50.convertString(src.getLabelElement()));
        }
        for (org.hl7.fhir.r5.model.Coding coding : src.getCode()) {
            tgt.addCode(VersionConvertor_40_50.convertCoding(coding));
        }
        if (src.hasSlicing()) {
            tgt.setSlicing(VersionConvertor_40_50.convertElementDefinitionSlicingComponent(src.getSlicing()));
        }
        if (src.hasShort()) {
            tgt.setShortElement(VersionConvertor_40_50.convertString(src.getShortElement()));
        }
        if (src.hasDefinition()) {
            tgt.setDefinitionElement(VersionConvertor_40_50.convertMarkdown(src.getDefinitionElement()));
        }
        if (src.hasComment()) {
            tgt.setCommentElement(VersionConvertor_40_50.convertMarkdown(src.getCommentElement()));
        }
        if (src.hasRequirements()) {
            tgt.setRequirementsElement(VersionConvertor_40_50.convertMarkdown(src.getRequirementsElement()));
        }
        for (org.hl7.fhir.r5.model.StringType stringType : src.getAlias()) {
            tgt.getAlias().add(VersionConvertor_40_50.convertString(stringType));
        }
        if (src.hasMin()) {
            tgt.setMinElement(VersionConvertor_40_50.convertUnsignedInt(src.getMinElement()));
        }
        if (src.hasMax()) {
            tgt.setMaxElement(VersionConvertor_40_50.convertString(src.getMaxElement()));
        }
        if (src.hasBase()) {
            tgt.setBase(VersionConvertor_40_50.convertElementDefinitionBaseComponent(src.getBase()));
        }
        if (src.hasContentReference()) {
            tgt.setContentReferenceElement(VersionConvertor_40_50.convertUri(src.getContentReferenceElement()));
        }
        for (ElementDefinition.TypeRefComponent typeRefComponent : src.getType()) {
            tgt.addType(VersionConvertor_40_50.convertTypeRefComponent(typeRefComponent));
        }
        if (src.hasDefaultValue()) {
            tgt.setDefaultValue(VersionConvertor_40_50.convertType(src.getDefaultValue()));
        }
        if (src.hasMeaningWhenMissing()) {
            tgt.setMeaningWhenMissingElement(VersionConvertor_40_50.convertMarkdown(src.getMeaningWhenMissingElement()));
        }
        if (src.hasOrderMeaning()) {
            tgt.setOrderMeaningElement(VersionConvertor_40_50.convertString(src.getOrderMeaningElement()));
        }
        if (src.hasFixed()) {
            tgt.setFixed(VersionConvertor_40_50.convertType(src.getFixed()));
        }
        if (src.hasPattern()) {
            tgt.setPattern(VersionConvertor_40_50.convertType(src.getPattern()));
        }
        for (ElementDefinition.ElementDefinitionExampleComponent elementDefinitionExampleComponent : src.getExample()) {
            tgt.addExample(VersionConvertor_40_50.convertElementDefinitionExampleComponent(elementDefinitionExampleComponent));
        }
        if (src.hasMinValue()) {
            tgt.setMinValue(VersionConvertor_40_50.convertType(src.getMinValue()));
        }
        if (src.hasMaxValue()) {
            tgt.setMaxValue(VersionConvertor_40_50.convertType(src.getMaxValue()));
        }
        if (src.hasMaxLength()) {
            tgt.setMaxLengthElement(VersionConvertor_40_50.convertInteger(src.getMaxLengthElement()));
        }
        for (IdType idType : src.getCondition()) {
            tgt.getCondition().add(VersionConvertor_40_50.convertId(idType));
        }
        for (ElementDefinition.ElementDefinitionConstraintComponent elementDefinitionConstraintComponent : src.getConstraint()) {
            tgt.addConstraint(VersionConvertor_40_50.convertElementDefinitionConstraintComponent(elementDefinitionConstraintComponent));
        }
        if (src.hasMustSupport()) {
            tgt.setMustSupportElement(VersionConvertor_40_50.convertBoolean(src.getMustSupportElement()));
        }
        if (src.hasIsModifier()) {
            tgt.setIsModifierElement(VersionConvertor_40_50.convertBoolean(src.getIsModifierElement()));
        }
        if (src.hasIsModifierReason()) {
            tgt.setIsModifierReasonElement(VersionConvertor_40_50.convertString(src.getIsModifierReasonElement()));
        }
        if (src.hasIsSummary()) {
            tgt.setIsSummaryElement(VersionConvertor_40_50.convertBoolean(src.getIsSummaryElement()));
        }
        if (src.hasBinding()) {
            tgt.setBinding(VersionConvertor_40_50.convertElementDefinitionBindingComponent(src.getBinding()));
        }
        for (ElementDefinition.ElementDefinitionMappingComponent elementDefinitionMappingComponent : src.getMapping()) {
            tgt.addMapping(VersionConvertor_40_50.convertElementDefinitionMappingComponent(elementDefinitionMappingComponent));
        }
        return tgt;
    }

    public static Enumeration<ElementDefinition.PropertyRepresentation> convertPropertyRepresentation(org.hl7.fhir.r4.model.Enumeration<ElementDefinition.PropertyRepresentation> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ElementDefinition.PropertyRepresentation> tgt = new Enumeration<ElementDefinition.PropertyRepresentation>(new ElementDefinition.PropertyRepresentationEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((ElementDefinition.PropertyRepresentation)((Object)src.getValue())) {
            case XMLATTR: {
                tgt.setValue((Object)ElementDefinition.PropertyRepresentation.XMLATTR);
                break;
            }
            case XMLTEXT: {
                tgt.setValue((Object)ElementDefinition.PropertyRepresentation.XMLTEXT);
                break;
            }
            case TYPEATTR: {
                tgt.setValue((Object)ElementDefinition.PropertyRepresentation.TYPEATTR);
                break;
            }
            case CDATEXT: {
                tgt.setValue((Object)ElementDefinition.PropertyRepresentation.CDATEXT);
                break;
            }
            case XHTML: {
                tgt.setValue((Object)ElementDefinition.PropertyRepresentation.XHTML);
                break;
            }
            default: {
                tgt.setValue((Object)ElementDefinition.PropertyRepresentation.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Enumeration<ElementDefinition.PropertyRepresentation> convertPropertyRepresentation(Enumeration<ElementDefinition.PropertyRepresentation> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Enumeration<ElementDefinition.PropertyRepresentation> tgt = new org.hl7.fhir.r4.model.Enumeration<ElementDefinition.PropertyRepresentation>(new ElementDefinition.PropertyRepresentationEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((ElementDefinition.PropertyRepresentation)((Object)src.getValue())) {
            case XMLATTR: {
                tgt.setValue((Object)ElementDefinition.PropertyRepresentation.XMLATTR);
                break;
            }
            case XMLTEXT: {
                tgt.setValue((Object)ElementDefinition.PropertyRepresentation.XMLTEXT);
                break;
            }
            case TYPEATTR: {
                tgt.setValue((Object)ElementDefinition.PropertyRepresentation.TYPEATTR);
                break;
            }
            case CDATEXT: {
                tgt.setValue((Object)ElementDefinition.PropertyRepresentation.CDATEXT);
                break;
            }
            case XHTML: {
                tgt.setValue((Object)ElementDefinition.PropertyRepresentation.XHTML);
                break;
            }
            default: {
                tgt.setValue((Object)ElementDefinition.PropertyRepresentation.NULL);
            }
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionSlicingComponent convertElementDefinitionSlicingComponent(ElementDefinition.ElementDefinitionSlicingComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ElementDefinition.ElementDefinitionSlicingComponent tgt = new ElementDefinition.ElementDefinitionSlicingComponent();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        for (ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent t : src.getDiscriminator()) {
            tgt.addDiscriminator(VersionConvertor_40_50.convertElementDefinitionSlicingDiscriminatorComponent(t));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_40_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasOrdered()) {
            tgt.setOrderedElement(VersionConvertor_40_50.convertBoolean(src.getOrderedElement()));
        }
        if (src.hasRules()) {
            tgt.setRulesElement(VersionConvertor_40_50.convertSlicingRules(src.getRulesElement()));
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionSlicingComponent convertElementDefinitionSlicingComponent(ElementDefinition.ElementDefinitionSlicingComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ElementDefinition.ElementDefinitionSlicingComponent tgt = new ElementDefinition.ElementDefinitionSlicingComponent();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        for (ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent t : src.getDiscriminator()) {
            tgt.addDiscriminator(VersionConvertor_40_50.convertElementDefinitionSlicingDiscriminatorComponent(t));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_40_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasOrdered()) {
            tgt.setOrderedElement(VersionConvertor_40_50.convertBoolean(src.getOrderedElement()));
        }
        if (src.hasRules()) {
            tgt.setRulesElement(VersionConvertor_40_50.convertSlicingRules(src.getRulesElement()));
        }
        return tgt;
    }

    public static Enumeration<ElementDefinition.SlicingRules> convertSlicingRules(org.hl7.fhir.r4.model.Enumeration<ElementDefinition.SlicingRules> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ElementDefinition.SlicingRules> tgt = new Enumeration<ElementDefinition.SlicingRules>(new ElementDefinition.SlicingRulesEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((ElementDefinition.SlicingRules)((Object)src.getValue())) {
            case CLOSED: {
                tgt.setValue((Object)ElementDefinition.SlicingRules.CLOSED);
                break;
            }
            case OPEN: {
                tgt.setValue((Object)ElementDefinition.SlicingRules.OPEN);
                break;
            }
            case OPENATEND: {
                tgt.setValue((Object)ElementDefinition.SlicingRules.OPENATEND);
                break;
            }
            default: {
                tgt.setValue((Object)ElementDefinition.SlicingRules.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Enumeration<ElementDefinition.SlicingRules> convertSlicingRules(Enumeration<ElementDefinition.SlicingRules> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Enumeration<ElementDefinition.SlicingRules> tgt = new org.hl7.fhir.r4.model.Enumeration<ElementDefinition.SlicingRules>(new ElementDefinition.SlicingRulesEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((ElementDefinition.SlicingRules)((Object)src.getValue())) {
            case CLOSED: {
                tgt.setValue((Object)ElementDefinition.SlicingRules.CLOSED);
                break;
            }
            case OPEN: {
                tgt.setValue((Object)ElementDefinition.SlicingRules.OPEN);
                break;
            }
            case OPENATEND: {
                tgt.setValue((Object)ElementDefinition.SlicingRules.OPENATEND);
                break;
            }
            default: {
                tgt.setValue((Object)ElementDefinition.SlicingRules.NULL);
            }
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent convertElementDefinitionSlicingDiscriminatorComponent(ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent tgt = new ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(VersionConvertor_40_50.convertDiscriminatorType(src.getTypeElement()));
        }
        if (src.hasPath()) {
            tgt.setPathElement(VersionConvertor_40_50.convertString(src.getPathElement()));
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent convertElementDefinitionSlicingDiscriminatorComponent(ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent tgt = new ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(VersionConvertor_40_50.convertDiscriminatorType(src.getTypeElement()));
        }
        if (src.hasPath()) {
            tgt.setPathElement(VersionConvertor_40_50.convertString(src.getPathElement()));
        }
        return tgt;
    }

    public static Enumeration<ElementDefinition.DiscriminatorType> convertDiscriminatorType(org.hl7.fhir.r4.model.Enumeration<ElementDefinition.DiscriminatorType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ElementDefinition.DiscriminatorType> tgt = new Enumeration<ElementDefinition.DiscriminatorType>(new ElementDefinition.DiscriminatorTypeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((ElementDefinition.DiscriminatorType)((Object)src.getValue())) {
            case VALUE: {
                tgt.setValue((Object)ElementDefinition.DiscriminatorType.VALUE);
                break;
            }
            case EXISTS: {
                tgt.setValue((Object)ElementDefinition.DiscriminatorType.EXISTS);
                break;
            }
            case PATTERN: {
                tgt.setValue((Object)ElementDefinition.DiscriminatorType.PATTERN);
                break;
            }
            case TYPE: {
                tgt.setValue((Object)ElementDefinition.DiscriminatorType.TYPE);
                break;
            }
            case PROFILE: {
                tgt.setValue((Object)ElementDefinition.DiscriminatorType.PROFILE);
                break;
            }
            default: {
                tgt.setValue((Object)ElementDefinition.DiscriminatorType.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Enumeration<ElementDefinition.DiscriminatorType> convertDiscriminatorType(Enumeration<ElementDefinition.DiscriminatorType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Enumeration<ElementDefinition.DiscriminatorType> tgt = new org.hl7.fhir.r4.model.Enumeration<ElementDefinition.DiscriminatorType>(new ElementDefinition.DiscriminatorTypeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((ElementDefinition.DiscriminatorType)((Object)src.getValue())) {
            case VALUE: {
                tgt.setValue((Object)ElementDefinition.DiscriminatorType.VALUE);
                break;
            }
            case EXISTS: {
                tgt.setValue((Object)ElementDefinition.DiscriminatorType.EXISTS);
                break;
            }
            case PATTERN: {
                tgt.setValue((Object)ElementDefinition.DiscriminatorType.PATTERN);
                break;
            }
            case TYPE: {
                tgt.setValue((Object)ElementDefinition.DiscriminatorType.TYPE);
                break;
            }
            case PROFILE: {
                tgt.setValue((Object)ElementDefinition.DiscriminatorType.PROFILE);
                break;
            }
            default: {
                tgt.setValue((Object)ElementDefinition.DiscriminatorType.NULL);
            }
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionBaseComponent convertElementDefinitionBaseComponent(ElementDefinition.ElementDefinitionBaseComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ElementDefinition.ElementDefinitionBaseComponent tgt = new ElementDefinition.ElementDefinitionBaseComponent();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasPath()) {
            tgt.setPathElement(VersionConvertor_40_50.convertString(src.getPathElement()));
        }
        if (src.hasMin()) {
            tgt.setMinElement(VersionConvertor_40_50.convertUnsignedInt(src.getMinElement()));
        }
        if (src.hasMax()) {
            tgt.setMaxElement(VersionConvertor_40_50.convertString(src.getMaxElement()));
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionBaseComponent convertElementDefinitionBaseComponent(ElementDefinition.ElementDefinitionBaseComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ElementDefinition.ElementDefinitionBaseComponent tgt = new ElementDefinition.ElementDefinitionBaseComponent();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasPath()) {
            tgt.setPathElement(VersionConvertor_40_50.convertString(src.getPathElement()));
        }
        if (src.hasMin()) {
            tgt.setMinElement(VersionConvertor_40_50.convertUnsignedInt(src.getMinElement()));
        }
        if (src.hasMax()) {
            tgt.setMaxElement(VersionConvertor_40_50.convertString(src.getMaxElement()));
        }
        return tgt;
    }

    public static ElementDefinition.TypeRefComponent convertTypeRefComponent(ElementDefinition.TypeRefComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ElementDefinition.TypeRefComponent tgt = new ElementDefinition.TypeRefComponent();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_40_50.convertUri(src.getCodeElement()));
        }
        for (org.hl7.fhir.r4.model.CanonicalType t : src.getProfile()) {
            tgt.getProfile().add(VersionConvertor_40_50.convertCanonical(t));
        }
        for (org.hl7.fhir.r4.model.CanonicalType t : src.getTargetProfile()) {
            tgt.getTargetProfile().add(VersionConvertor_40_50.convertCanonical(t));
        }
        tgt.setAggregation(src.getAggregation().stream().map(VersionConvertor_40_50::convertAggregationMode).collect(Collectors.toList()));
        if (src.hasVersioning()) {
            tgt.setVersioningElement(VersionConvertor_40_50.convertReferenceVersionRules(src.getVersioningElement()));
        }
        return tgt;
    }

    public static ElementDefinition.TypeRefComponent convertTypeRefComponent(ElementDefinition.TypeRefComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ElementDefinition.TypeRefComponent tgt = new ElementDefinition.TypeRefComponent();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_40_50.convertUri(src.getCodeElement()));
        }
        for (CanonicalType t : src.getProfile()) {
            tgt.getProfile().add(VersionConvertor_40_50.convertCanonical(t));
        }
        for (CanonicalType t : src.getTargetProfile()) {
            tgt.getTargetProfile().add(VersionConvertor_40_50.convertCanonical(t));
        }
        tgt.setAggregation(src.getAggregation().stream().map(VersionConvertor_40_50::convertAggregationMode).collect(Collectors.toList()));
        if (src.hasVersioning()) {
            tgt.setVersioningElement(VersionConvertor_40_50.convertReferenceVersionRules(src.getVersioningElement()));
        }
        return tgt;
    }

    public static Enumeration<ElementDefinition.AggregationMode> convertAggregationMode(org.hl7.fhir.r4.model.Enumeration<ElementDefinition.AggregationMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ElementDefinition.AggregationMode> tgt = new Enumeration<ElementDefinition.AggregationMode>(new ElementDefinition.AggregationModeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((ElementDefinition.AggregationMode)((Object)src.getValue())) {
            case CONTAINED: {
                tgt.setValue((Object)ElementDefinition.AggregationMode.CONTAINED);
                break;
            }
            case REFERENCED: {
                tgt.setValue((Object)ElementDefinition.AggregationMode.REFERENCED);
                break;
            }
            case BUNDLED: {
                tgt.setValue((Object)ElementDefinition.AggregationMode.BUNDLED);
                break;
            }
            default: {
                tgt.setValue((Object)ElementDefinition.AggregationMode.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Enumeration<ElementDefinition.AggregationMode> convertAggregationMode(Enumeration<ElementDefinition.AggregationMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Enumeration<ElementDefinition.AggregationMode> tgt = new org.hl7.fhir.r4.model.Enumeration<ElementDefinition.AggregationMode>(new ElementDefinition.AggregationModeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((ElementDefinition.AggregationMode)((Object)src.getValue())) {
            case CONTAINED: {
                tgt.setValue((Object)ElementDefinition.AggregationMode.CONTAINED);
                break;
            }
            case REFERENCED: {
                tgt.setValue((Object)ElementDefinition.AggregationMode.REFERENCED);
                break;
            }
            case BUNDLED: {
                tgt.setValue((Object)ElementDefinition.AggregationMode.BUNDLED);
                break;
            }
            default: {
                tgt.setValue((Object)ElementDefinition.AggregationMode.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<ElementDefinition.ReferenceVersionRules> convertReferenceVersionRules(org.hl7.fhir.r4.model.Enumeration<ElementDefinition.ReferenceVersionRules> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ElementDefinition.ReferenceVersionRules> tgt = new Enumeration<ElementDefinition.ReferenceVersionRules>(new ElementDefinition.ReferenceVersionRulesEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((ElementDefinition.ReferenceVersionRules)((Object)src.getValue())) {
            case EITHER: {
                tgt.setValue((Object)ElementDefinition.ReferenceVersionRules.EITHER);
                break;
            }
            case INDEPENDENT: {
                tgt.setValue((Object)ElementDefinition.ReferenceVersionRules.INDEPENDENT);
                break;
            }
            case SPECIFIC: {
                tgt.setValue((Object)ElementDefinition.ReferenceVersionRules.SPECIFIC);
                break;
            }
            default: {
                tgt.setValue((Object)ElementDefinition.ReferenceVersionRules.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Enumeration<ElementDefinition.ReferenceVersionRules> convertReferenceVersionRules(Enumeration<ElementDefinition.ReferenceVersionRules> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Enumeration<ElementDefinition.ReferenceVersionRules> tgt = new org.hl7.fhir.r4.model.Enumeration<ElementDefinition.ReferenceVersionRules>(new ElementDefinition.ReferenceVersionRulesEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((ElementDefinition.ReferenceVersionRules)((Object)src.getValue())) {
            case EITHER: {
                tgt.setValue((Object)ElementDefinition.ReferenceVersionRules.EITHER);
                break;
            }
            case INDEPENDENT: {
                tgt.setValue((Object)ElementDefinition.ReferenceVersionRules.INDEPENDENT);
                break;
            }
            case SPECIFIC: {
                tgt.setValue((Object)ElementDefinition.ReferenceVersionRules.SPECIFIC);
                break;
            }
            default: {
                tgt.setValue((Object)ElementDefinition.ReferenceVersionRules.NULL);
            }
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionExampleComponent convertElementDefinitionExampleComponent(ElementDefinition.ElementDefinitionExampleComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ElementDefinition.ElementDefinitionExampleComponent tgt = new ElementDefinition.ElementDefinitionExampleComponent();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasLabel()) {
            tgt.setLabelElement(VersionConvertor_40_50.convertString(src.getLabelElement()));
        }
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_40_50.convertType(src.getValue()));
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionExampleComponent convertElementDefinitionExampleComponent(ElementDefinition.ElementDefinitionExampleComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ElementDefinition.ElementDefinitionExampleComponent tgt = new ElementDefinition.ElementDefinitionExampleComponent();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasLabel()) {
            tgt.setLabelElement(VersionConvertor_40_50.convertString(src.getLabelElement()));
        }
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_40_50.convertType(src.getValue()));
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionConstraintComponent convertElementDefinitionConstraintComponent(ElementDefinition.ElementDefinitionConstraintComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ElementDefinition.ElementDefinitionConstraintComponent tgt = new ElementDefinition.ElementDefinitionConstraintComponent();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasKey()) {
            tgt.setKeyElement(VersionConvertor_40_50.convertId(src.getKeyElement()));
        }
        if (src.hasRequirements()) {
            tgt.setRequirementsElement(VersionConvertor_40_50.convertString(src.getRequirementsElement()));
        }
        if (src.hasSeverity()) {
            tgt.setSeverityElement(VersionConvertor_40_50.convertConstraintSeverity(src.getSeverityElement()));
        }
        if (src.hasHuman()) {
            tgt.setHumanElement(VersionConvertor_40_50.convertString(src.getHumanElement()));
        }
        if (src.hasExpression()) {
            tgt.setExpressionElement(VersionConvertor_40_50.convertString(src.getExpressionElement()));
        }
        if (src.hasXpath()) {
            tgt.setXpathElement(VersionConvertor_40_50.convertString(src.getXpathElement()));
        }
        if (src.hasSource()) {
            tgt.setSourceElement(VersionConvertor_40_50.convertCanonical(src.getSourceElement()));
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionConstraintComponent convertElementDefinitionConstraintComponent(ElementDefinition.ElementDefinitionConstraintComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ElementDefinition.ElementDefinitionConstraintComponent tgt = new ElementDefinition.ElementDefinitionConstraintComponent();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasKey()) {
            tgt.setKeyElement(VersionConvertor_40_50.convertId(src.getKeyElement()));
        }
        if (src.hasRequirements()) {
            tgt.setRequirementsElement(VersionConvertor_40_50.convertString(src.getRequirementsElement()));
        }
        if (src.hasSeverity()) {
            tgt.setSeverityElement(VersionConvertor_40_50.convertConstraintSeverity(src.getSeverityElement()));
        }
        if (src.hasHuman()) {
            tgt.setHumanElement(VersionConvertor_40_50.convertString(src.getHumanElement()));
        }
        if (src.hasExpression()) {
            tgt.setExpressionElement(VersionConvertor_40_50.convertString(src.getExpressionElement()));
        }
        if (src.hasXpath()) {
            tgt.setXpathElement(VersionConvertor_40_50.convertString(src.getXpathElement()));
        }
        if (src.hasSource()) {
            tgt.setSourceElement(VersionConvertor_40_50.convertCanonical(src.getSourceElement()));
        }
        return tgt;
    }

    public static Enumeration<ElementDefinition.ConstraintSeverity> convertConstraintSeverity(org.hl7.fhir.r4.model.Enumeration<ElementDefinition.ConstraintSeverity> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ElementDefinition.ConstraintSeverity> tgt = new Enumeration<ElementDefinition.ConstraintSeverity>(new ElementDefinition.ConstraintSeverityEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((ElementDefinition.ConstraintSeverity)((Object)src.getValue())) {
            case ERROR: {
                tgt.setValue((Object)ElementDefinition.ConstraintSeverity.ERROR);
                break;
            }
            case WARNING: {
                tgt.setValue((Object)ElementDefinition.ConstraintSeverity.WARNING);
                break;
            }
            default: {
                tgt.setValue((Object)ElementDefinition.ConstraintSeverity.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Enumeration<ElementDefinition.ConstraintSeverity> convertConstraintSeverity(Enumeration<ElementDefinition.ConstraintSeverity> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Enumeration<ElementDefinition.ConstraintSeverity> tgt = new org.hl7.fhir.r4.model.Enumeration<ElementDefinition.ConstraintSeverity>(new ElementDefinition.ConstraintSeverityEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((ElementDefinition.ConstraintSeverity)((Object)src.getValue())) {
            case ERROR: {
                tgt.setValue((Object)ElementDefinition.ConstraintSeverity.ERROR);
                break;
            }
            case WARNING: {
                tgt.setValue((Object)ElementDefinition.ConstraintSeverity.WARNING);
                break;
            }
            default: {
                tgt.setValue((Object)ElementDefinition.ConstraintSeverity.NULL);
            }
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionBindingComponent convertElementDefinitionBindingComponent(ElementDefinition.ElementDefinitionBindingComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ElementDefinition.ElementDefinitionBindingComponent tgt = new ElementDefinition.ElementDefinitionBindingComponent();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasStrength()) {
            tgt.setStrengthElement(Enumerations40_50.convertBindingStrength(src.getStrengthElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_40_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasValueSet()) {
            tgt.setValueSetElement(VersionConvertor_40_50.convertCanonical(src.getValueSetElement()));
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionBindingComponent convertElementDefinitionBindingComponent(ElementDefinition.ElementDefinitionBindingComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ElementDefinition.ElementDefinitionBindingComponent tgt = new ElementDefinition.ElementDefinitionBindingComponent();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasStrength()) {
            tgt.setStrengthElement(Enumerations40_50.convertBindingStrength(src.getStrengthElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_40_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasValueSet()) {
            tgt.setValueSetElement(VersionConvertor_40_50.convertCanonical(src.getValueSetElement()));
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionMappingComponent convertElementDefinitionMappingComponent(ElementDefinition.ElementDefinitionMappingComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ElementDefinition.ElementDefinitionMappingComponent tgt = new ElementDefinition.ElementDefinitionMappingComponent();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasIdentity()) {
            tgt.setIdentityElement(VersionConvertor_40_50.convertId(src.getIdentityElement()));
        }
        if (src.hasLanguage()) {
            tgt.setLanguageElement(VersionConvertor_40_50.convertCode(src.getLanguageElement()));
        }
        if (src.hasMap()) {
            tgt.setMapElement(VersionConvertor_40_50.convertString(src.getMapElement()));
        }
        if (src.hasComment()) {
            tgt.setCommentElement(VersionConvertor_40_50.convertString(src.getCommentElement()));
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionMappingComponent convertElementDefinitionMappingComponent(ElementDefinition.ElementDefinitionMappingComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ElementDefinition.ElementDefinitionMappingComponent tgt = new ElementDefinition.ElementDefinitionMappingComponent();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasIdentity()) {
            tgt.setIdentityElement(VersionConvertor_40_50.convertId(src.getIdentityElement()));
        }
        if (src.hasLanguage()) {
            tgt.setLanguageElement(VersionConvertor_40_50.convertCode(src.getLanguageElement()));
        }
        if (src.hasMap()) {
            tgt.setMapElement(VersionConvertor_40_50.convertString(src.getMapElement()));
        }
        if (src.hasComment()) {
            tgt.setCommentElement(VersionConvertor_40_50.convertString(src.getCommentElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Quantity convertMoneyQuantity(Quantity src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.Quantity tgt = new org.hl7.fhir.r5.model.Quantity();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_40_50.convertDecimal(src.getValueElement()));
        }
        if (src.hasComparator()) {
            tgt.setComparatorElement(VersionConvertor_40_50.convertQuantityComparator(src.getComparatorElement()));
        }
        if (src.hasUnit()) {
            tgt.setUnitElement(VersionConvertor_40_50.convertString(src.getUnitElement()));
        }
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_40_50.convertUri(src.getSystemElement()));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_40_50.convertCode(src.getCodeElement()));
        }
        return tgt;
    }

    public static Quantity convertMoneyQuantity(org.hl7.fhir.r5.model.Quantity src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Quantity tgt = new Quantity();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_40_50.convertDecimal(src.getValueElement()));
        }
        if (src.hasComparator()) {
            tgt.setComparatorElement(VersionConvertor_40_50.convertQuantityComparator(src.getComparatorElement()));
        }
        if (src.hasUnit()) {
            tgt.setUnitElement(VersionConvertor_40_50.convertString(src.getUnitElement()));
        }
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_40_50.convertUri(src.getSystemElement()));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_40_50.convertCode(src.getCodeElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Quantity convertSimpleQuantity(Quantity src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.Quantity tgt = new org.hl7.fhir.r5.model.Quantity();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_40_50.convertDecimal(src.getValueElement()));
        }
        if (src.hasComparator()) {
            tgt.setComparatorElement(VersionConvertor_40_50.convertQuantityComparator(src.getComparatorElement()));
        }
        if (src.hasUnit()) {
            tgt.setUnitElement(VersionConvertor_40_50.convertString(src.getUnitElement()));
        }
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_40_50.convertUri(src.getSystemElement()));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_40_50.convertCode(src.getCodeElement()));
        }
        return tgt;
    }

    public static Quantity convertSimpleQuantity(org.hl7.fhir.r5.model.Quantity src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Quantity tgt = new Quantity();
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_40_50.convertDecimal(src.getValueElement()));
        }
        if (src.hasComparator()) {
            tgt.setComparatorElement(VersionConvertor_40_50.convertQuantityComparator(src.getComparatorElement()));
        }
        if (src.hasUnit()) {
            tgt.setUnitElement(VersionConvertor_40_50.convertString(src.getUnitElement()));
        }
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_40_50.convertUri(src.getSystemElement()));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_40_50.convertCode(src.getCodeElement()));
        }
        return tgt;
    }

    public static DataType convertType(Type src) throws FHIRException {
        if (src == null) {
            return null;
        }
        if (src instanceof org.hl7.fhir.r4.model.Base64BinaryType) {
            return VersionConvertor_40_50.convertBase64Binary((org.hl7.fhir.r4.model.Base64BinaryType)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.BooleanType) {
            return VersionConvertor_40_50.convertBoolean((org.hl7.fhir.r4.model.BooleanType)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.CanonicalType) {
            return VersionConvertor_40_50.convertCanonical((org.hl7.fhir.r4.model.CanonicalType)src);
        }
        if (src instanceof CodeType) {
            return VersionConvertor_40_50.convertCode((CodeType)src);
        }
        if (src instanceof DateType) {
            return VersionConvertor_40_50.convertDate((DateType)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.DateTimeType) {
            return VersionConvertor_40_50.convertDateTime((org.hl7.fhir.r4.model.DateTimeType)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.DecimalType) {
            return VersionConvertor_40_50.convertDecimal((org.hl7.fhir.r4.model.DecimalType)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.IdType) {
            return VersionConvertor_40_50.convertId((org.hl7.fhir.r4.model.IdType)src);
        }
        if (src instanceof InstantType) {
            return VersionConvertor_40_50.convertInstant((InstantType)src);
        }
        if (src instanceof UnsignedIntType) {
            return VersionConvertor_40_50.convertUnsignedInt((UnsignedIntType)src);
        }
        if (src instanceof PositiveIntType) {
            return VersionConvertor_40_50.convertPositiveInt((PositiveIntType)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.IntegerType) {
            return VersionConvertor_40_50.convertInteger((org.hl7.fhir.r4.model.IntegerType)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.MarkdownType) {
            return VersionConvertor_40_50.convertMarkdown((org.hl7.fhir.r4.model.MarkdownType)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.OidType) {
            return VersionConvertor_40_50.convertOid((org.hl7.fhir.r4.model.OidType)src);
        }
        if (src instanceof StringType) {
            return VersionConvertor_40_50.convertString((StringType)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.TimeType) {
            return VersionConvertor_40_50.convertTime((org.hl7.fhir.r4.model.TimeType)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.UrlType) {
            return VersionConvertor_40_50.convertUrl((org.hl7.fhir.r4.model.UrlType)src);
        }
        if (src instanceof UriType) {
            return VersionConvertor_40_50.convertUri((UriType)src);
        }
        if (src instanceof UuidType) {
            return VersionConvertor_40_50.convertUuid((UuidType)src);
        }
        if (src instanceof Extension) {
            return VersionConvertor_40_50.convertExtension((Extension)src);
        }
        if (src instanceof Narrative) {
            return VersionConvertor_40_50.convertNarrative((Narrative)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Address) {
            return VersionConvertor_40_50.convertAddress((org.hl7.fhir.r4.model.Address)src);
        }
        if (src instanceof Age) {
            return VersionConvertor_40_50.convertAge((Age)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Annotation) {
            return VersionConvertor_40_50.convertAnnotation((org.hl7.fhir.r4.model.Annotation)src);
        }
        if (src instanceof Attachment) {
            return VersionConvertor_40_50.convertAttachment((Attachment)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.CodeableConcept) {
            return VersionConvertor_40_50.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)src);
        }
        if (src instanceof Coding) {
            return VersionConvertor_40_50.convertCoding((Coding)src);
        }
        if (src instanceof ContactDetail) {
            return VersionConvertor_40_50.convertContactDetail((ContactDetail)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.ContactPoint) {
            return VersionConvertor_40_50.convertContactPoint((org.hl7.fhir.r4.model.ContactPoint)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Contributor) {
            return VersionConvertor_40_50.convertContributor((org.hl7.fhir.r4.model.Contributor)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Count) {
            return VersionConvertor_40_50.convertCount((org.hl7.fhir.r4.model.Count)src);
        }
        if (src instanceof DataRequirement) {
            return VersionConvertor_40_50.convertDataRequirement((DataRequirement)src);
        }
        if (src instanceof Distance) {
            return VersionConvertor_40_50.convertDistance((Distance)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Dosage) {
            return VersionConvertor_40_50.convertDosage((org.hl7.fhir.r4.model.Dosage)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Duration) {
            return VersionConvertor_40_50.convertDuration((org.hl7.fhir.r4.model.Duration)src);
        }
        if (src instanceof Expression) {
            return VersionConvertor_40_50.convertExpression((Expression)src);
        }
        if (src instanceof HumanName) {
            return VersionConvertor_40_50.convertHumanName((HumanName)src);
        }
        if (src instanceof Identifier) {
            return VersionConvertor_40_50.convertIdentifier((Identifier)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.MarketingStatus) {
            return VersionConvertor_40_50.convertMarketingStatus((org.hl7.fhir.r4.model.MarketingStatus)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Meta) {
            return VersionConvertor_40_50.convertMeta((org.hl7.fhir.r4.model.Meta)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Money) {
            return VersionConvertor_40_50.convertMoney((org.hl7.fhir.r4.model.Money)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.ParameterDefinition) {
            return VersionConvertor_40_50.convertParameterDefinition((org.hl7.fhir.r4.model.ParameterDefinition)src);
        }
        if (src instanceof Period) {
            return VersionConvertor_40_50.convertPeriod((Period)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Population) {
            return VersionConvertor_40_50.convertPopulation((org.hl7.fhir.r4.model.Population)src);
        }
        if (src instanceof ProdCharacteristic) {
            return VersionConvertor_40_50.convertProdCharacteristic((ProdCharacteristic)src);
        }
        if (src instanceof ProductShelfLife) {
            return VersionConvertor_40_50.convertProductShelfLife((ProductShelfLife)src);
        }
        if (src instanceof Quantity) {
            return VersionConvertor_40_50.convertQuantity((Quantity)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Range) {
            return VersionConvertor_40_50.convertRange((org.hl7.fhir.r4.model.Range)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Ratio) {
            return VersionConvertor_40_50.convertRatio((org.hl7.fhir.r4.model.Ratio)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Reference) {
            return VersionConvertor_40_50.convertReference((org.hl7.fhir.r4.model.Reference)src);
        }
        if (src instanceof RelatedArtifact) {
            return VersionConvertor_40_50.convertRelatedArtifact((RelatedArtifact)src);
        }
        if (src instanceof SampledData) {
            return VersionConvertor_40_50.convertSampledData((SampledData)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Signature) {
            return VersionConvertor_40_50.convertSignature((org.hl7.fhir.r4.model.Signature)src);
        }
        if (src instanceof SubstanceAmount) {
            return VersionConvertor_40_50.convertSubstanceAmount((SubstanceAmount)src);
        }
        if (src instanceof Timing) {
            return VersionConvertor_40_50.convertTiming((Timing)src);
        }
        if (src instanceof TriggerDefinition) {
            return VersionConvertor_40_50.convertTriggerDefinition((TriggerDefinition)src);
        }
        if (src instanceof UsageContext) {
            return VersionConvertor_40_50.convertUsageContext((UsageContext)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.ElementDefinition) {
            return VersionConvertor_40_50.convertElementDefinition((org.hl7.fhir.r4.model.ElementDefinition)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.MoneyQuantity) {
            return VersionConvertor_40_50.convertMoneyQuantity((org.hl7.fhir.r4.model.MoneyQuantity)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.SimpleQuantity) {
            return VersionConvertor_40_50.convertSimpleQuantity((org.hl7.fhir.r4.model.SimpleQuantity)src);
        }
        throw new Error("Unknown type " + src.fhirType());
    }

    public static Type convertType(DataType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        if (src instanceof Base64BinaryType) {
            return VersionConvertor_40_50.convertBase64Binary((Base64BinaryType)src);
        }
        if (src instanceof BooleanType) {
            return VersionConvertor_40_50.convertBoolean((BooleanType)src);
        }
        if (src instanceof CanonicalType) {
            return VersionConvertor_40_50.convertCanonical((CanonicalType)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.CodeType) {
            return VersionConvertor_40_50.convertCode((org.hl7.fhir.r5.model.CodeType)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.DateType) {
            return VersionConvertor_40_50.convertDate((org.hl7.fhir.r5.model.DateType)src);
        }
        if (src instanceof DateTimeType) {
            return VersionConvertor_40_50.convertDateTime((DateTimeType)src);
        }
        if (src instanceof DecimalType) {
            return VersionConvertor_40_50.convertDecimal((DecimalType)src);
        }
        if (src instanceof IdType) {
            return VersionConvertor_40_50.convertId((IdType)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.InstantType) {
            return VersionConvertor_40_50.convertInstant((org.hl7.fhir.r5.model.InstantType)src);
        }
        if (src instanceof MarkdownType) {
            return VersionConvertor_40_50.convertMarkdown((MarkdownType)src);
        }
        if (src instanceof OidType) {
            return VersionConvertor_40_50.convertOid((OidType)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.PositiveIntType) {
            return VersionConvertor_40_50.convertPositiveInt((org.hl7.fhir.r5.model.PositiveIntType)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.StringType) {
            return VersionConvertor_40_50.convertString((org.hl7.fhir.r5.model.StringType)src);
        }
        if (src instanceof TimeType) {
            return VersionConvertor_40_50.convertTime((TimeType)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.UnsignedIntType) {
            return VersionConvertor_40_50.convertUnsignedInt((org.hl7.fhir.r5.model.UnsignedIntType)src);
        }
        if (src instanceof IntegerType) {
            return VersionConvertor_40_50.convertInteger((IntegerType)src);
        }
        if (src instanceof UrlType) {
            return VersionConvertor_40_50.convertUrl((UrlType)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.UriType) {
            return VersionConvertor_40_50.convertUri((org.hl7.fhir.r5.model.UriType)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.UuidType) {
            return VersionConvertor_40_50.convertUuid((org.hl7.fhir.r5.model.UuidType)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Extension) {
            return VersionConvertor_40_50.convertExtension((org.hl7.fhir.r5.model.Extension)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Narrative) {
            return VersionConvertor_40_50.convertNarrative((org.hl7.fhir.r5.model.Narrative)src);
        }
        if (src instanceof Address) {
            return VersionConvertor_40_50.convertAddress((Address)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Age) {
            return VersionConvertor_40_50.convertAge((org.hl7.fhir.r5.model.Age)src);
        }
        if (src instanceof Annotation) {
            return VersionConvertor_40_50.convertAnnotation((Annotation)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Attachment) {
            return VersionConvertor_40_50.convertAttachment((org.hl7.fhir.r5.model.Attachment)src);
        }
        if (src instanceof CodeableConcept) {
            return VersionConvertor_40_50.convertCodeableConcept((CodeableConcept)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Coding) {
            return VersionConvertor_40_50.convertCoding((org.hl7.fhir.r5.model.Coding)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.ContactDetail) {
            return VersionConvertor_40_50.convertContactDetail((org.hl7.fhir.r5.model.ContactDetail)src);
        }
        if (src instanceof ContactPoint) {
            return VersionConvertor_40_50.convertContactPoint((ContactPoint)src);
        }
        if (src instanceof Contributor) {
            return VersionConvertor_40_50.convertContributor((Contributor)src);
        }
        if (src instanceof Count) {
            return VersionConvertor_40_50.convertCount((Count)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.DataRequirement) {
            return VersionConvertor_40_50.convertDataRequirement((org.hl7.fhir.r5.model.DataRequirement)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Distance) {
            return VersionConvertor_40_50.convertDistance((org.hl7.fhir.r5.model.Distance)src);
        }
        if (src instanceof Dosage) {
            return VersionConvertor_40_50.convertDosage((Dosage)src);
        }
        if (src instanceof Duration) {
            return VersionConvertor_40_50.convertDuration((Duration)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Expression) {
            return VersionConvertor_40_50.convertExpression((org.hl7.fhir.r5.model.Expression)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.HumanName) {
            return VersionConvertor_40_50.convertHumanName((org.hl7.fhir.r5.model.HumanName)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Identifier) {
            return VersionConvertor_40_50.convertIdentifier((org.hl7.fhir.r5.model.Identifier)src);
        }
        if (src instanceof MarketingStatus) {
            return VersionConvertor_40_50.convertMarketingStatus((MarketingStatus)src);
        }
        if (src instanceof Meta) {
            return VersionConvertor_40_50.convertMeta((Meta)src);
        }
        if (src instanceof Money) {
            return VersionConvertor_40_50.convertMoney((Money)src);
        }
        if (src instanceof ParameterDefinition) {
            return VersionConvertor_40_50.convertParameterDefinition((ParameterDefinition)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Period) {
            return VersionConvertor_40_50.convertPeriod((org.hl7.fhir.r5.model.Period)src);
        }
        if (src instanceof Population) {
            return VersionConvertor_40_50.convertPopulation((Population)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.ProdCharacteristic) {
            return VersionConvertor_40_50.convertProdCharacteristic((org.hl7.fhir.r5.model.ProdCharacteristic)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.ProductShelfLife) {
            return VersionConvertor_40_50.convertProductShelfLife((org.hl7.fhir.r5.model.ProductShelfLife)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Quantity) {
            return VersionConvertor_40_50.convertQuantity((org.hl7.fhir.r5.model.Quantity)src);
        }
        if (src instanceof Range) {
            return VersionConvertor_40_50.convertRange((Range)src);
        }
        if (src instanceof Ratio) {
            return VersionConvertor_40_50.convertRatio((Ratio)src);
        }
        if (src instanceof Reference) {
            return VersionConvertor_40_50.convertReference((Reference)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.RelatedArtifact) {
            return VersionConvertor_40_50.convertRelatedArtifact((org.hl7.fhir.r5.model.RelatedArtifact)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.SampledData) {
            return VersionConvertor_40_50.convertSampledData((org.hl7.fhir.r5.model.SampledData)src);
        }
        if (src instanceof Signature) {
            return VersionConvertor_40_50.convertSignature((Signature)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.SubstanceAmount) {
            return VersionConvertor_40_50.convertSubstanceAmount((org.hl7.fhir.r5.model.SubstanceAmount)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Timing) {
            return VersionConvertor_40_50.convertTiming((org.hl7.fhir.r5.model.Timing)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.TriggerDefinition) {
            return VersionConvertor_40_50.convertTriggerDefinition((org.hl7.fhir.r5.model.TriggerDefinition)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.UsageContext) {
            return VersionConvertor_40_50.convertUsageContext((org.hl7.fhir.r5.model.UsageContext)src);
        }
        if (src instanceof ElementDefinition) {
            return VersionConvertor_40_50.convertElementDefinition((ElementDefinition)src);
        }
        if (src instanceof MoneyQuantity) {
            return VersionConvertor_40_50.convertMoneyQuantity((MoneyQuantity)src);
        }
        if (src instanceof SimpleQuantity) {
            return VersionConvertor_40_50.convertSimpleQuantity((SimpleQuantity)src);
        }
        throw new Error("Unknown type " + src.fhirType());
    }

    protected static void copyDomainResource(org.hl7.fhir.r4.model.DomainResource src, DomainResource tgt) throws FHIRException {
        VersionConvertor_40_50.copyResource(src, tgt);
        if (src.hasText()) {
            tgt.setText(VersionConvertor_40_50.convertNarrative(src.getText()));
        }
        for (org.hl7.fhir.r4.model.Resource resource : src.getContained()) {
            tgt.addContained(VersionConvertor_40_50.convertResource(resource));
        }
        for (Extension extension : src.getExtension()) {
            tgt.addExtension(VersionConvertor_40_50.convertExtension(extension));
        }
        for (Extension extension : src.getModifierExtension()) {
            tgt.addModifierExtension(VersionConvertor_40_50.convertExtension(extension));
        }
    }

    protected static void copyDomainResource(DomainResource src, org.hl7.fhir.r4.model.DomainResource tgt) throws FHIRException {
        VersionConvertor_40_50.copyResource(src, tgt);
        if (src.hasText()) {
            tgt.setText(VersionConvertor_40_50.convertNarrative(src.getText()));
        }
        for (Resource resource : src.getContained()) {
            tgt.addContained(VersionConvertor_40_50.convertResource(resource));
        }
        for (org.hl7.fhir.r5.model.Extension extension : src.getExtension()) {
            tgt.addExtension(VersionConvertor_40_50.convertExtension(extension));
        }
        for (org.hl7.fhir.r5.model.Extension extension : src.getModifierExtension()) {
            tgt.addModifierExtension(VersionConvertor_40_50.convertExtension(extension));
        }
    }

    protected static void copyResource(org.hl7.fhir.r4.model.Resource src, Resource tgt) throws FHIRException {
        if (src.hasId()) {
            tgt.setIdElement(VersionConvertor_40_50.convertId(src.getIdElement()));
        }
        if (src.hasMeta()) {
            tgt.setMeta(VersionConvertor_40_50.convertMeta(src.getMeta()));
        }
        if (src.hasImplicitRules()) {
            tgt.setImplicitRulesElement(VersionConvertor_40_50.convertUri(src.getImplicitRulesElement()));
        }
        if (src.hasLanguage()) {
            tgt.setLanguageElement(VersionConvertor_40_50.convertCode(src.getLanguageElement()));
        }
    }

    protected static void copyResource(Resource src, org.hl7.fhir.r4.model.Resource tgt) throws FHIRException {
        if (src.hasId()) {
            tgt.setIdElement(VersionConvertor_40_50.convertId(src.getIdElement()));
        }
        if (src.hasMeta()) {
            tgt.setMeta(VersionConvertor_40_50.convertMeta(src.getMeta()));
        }
        if (src.hasImplicitRules()) {
            tgt.setImplicitRulesElement(VersionConvertor_40_50.convertUri(src.getImplicitRulesElement()));
        }
        if (src.hasLanguage()) {
            tgt.setLanguageElement(VersionConvertor_40_50.convertCode(src.getLanguageElement()));
        }
    }

    public static Resource convertResource(org.hl7.fhir.r4.model.Resource src) throws FHIRException {
        if (src == null) {
            return null;
        }
        if (src instanceof org.hl7.fhir.r4.model.Parameters) {
            return Parameters40_50.convertParameters((org.hl7.fhir.r4.model.Parameters)src);
        }
        if (src instanceof Account) {
            return Account40_50.convertAccount((Account)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.ActivityDefinition) {
            return ActivityDefinition40_50.convertActivityDefinition((org.hl7.fhir.r4.model.ActivityDefinition)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.AllergyIntolerance) {
            return AllergyIntolerance40_50.convertAllergyIntolerance((org.hl7.fhir.r4.model.AllergyIntolerance)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Appointment) {
            return Appointment40_50.convertAppointment((org.hl7.fhir.r4.model.Appointment)src);
        }
        if (src instanceof AppointmentResponse) {
            return AppointmentResponse40_50.convertAppointmentResponse((AppointmentResponse)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.AuditEvent) {
            return AuditEvent40_50.convertAuditEvent((org.hl7.fhir.r4.model.AuditEvent)src);
        }
        if (src instanceof Basic) {
            return Basic40_50.convertBasic((Basic)src);
        }
        if (src instanceof Binary) {
            return Binary40_50.convertBinary((Binary)src);
        }
        if (src instanceof BiologicallyDerivedProduct) {
            return BiologicallyDerivedProduct40_50.convertBiologicallyDerivedProduct((BiologicallyDerivedProduct)src);
        }
        if (src instanceof BodyStructure) {
            return BodyStructure40_50.convertBodyStructure((BodyStructure)src);
        }
        if (src instanceof Bundle) {
            return Bundle40_50.convertBundle((Bundle)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.CapabilityStatement) {
            return CapabilityStatement40_50.convertCapabilityStatement((org.hl7.fhir.r4.model.CapabilityStatement)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.CarePlan) {
            return CarePlan40_50.convertCarePlan((org.hl7.fhir.r4.model.CarePlan)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.CareTeam) {
            return CareTeam40_50.convertCareTeam((org.hl7.fhir.r4.model.CareTeam)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.ChargeItem) {
            return ChargeItem40_50.convertChargeItem((org.hl7.fhir.r4.model.ChargeItem)src);
        }
        if (src instanceof ChargeItemDefinition) {
            return ChargeItemDefinition40_50.convertChargeItemDefinition((ChargeItemDefinition)src);
        }
        if (src instanceof Claim) {
            return Claim40_50.convertClaim((Claim)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.ClaimResponse) {
            return ClaimResponse40_50.convertClaimResponse((org.hl7.fhir.r4.model.ClaimResponse)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.ClinicalImpression) {
            return ClinicalImpression40_50.convertClinicalImpression((org.hl7.fhir.r4.model.ClinicalImpression)src);
        }
        if (src instanceof CodeSystem) {
            return CodeSystem40_50.convertCodeSystem((CodeSystem)src);
        }
        if (src instanceof Communication) {
            return Communication40_50.convertCommunication((Communication)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.CommunicationRequest) {
            return CommunicationRequest40_50.convertCommunicationRequest((org.hl7.fhir.r4.model.CommunicationRequest)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.CompartmentDefinition) {
            return CompartmentDefinition40_50.convertCompartmentDefinition((org.hl7.fhir.r4.model.CompartmentDefinition)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Composition) {
            return Composition40_50.convertComposition((org.hl7.fhir.r4.model.Composition)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.ConceptMap) {
            return ConceptMap40_50.convertConceptMap((org.hl7.fhir.r4.model.ConceptMap)src);
        }
        if (src instanceof Condition) {
            return Condition40_50.convertCondition((Condition)src);
        }
        if (src instanceof Consent) {
            return Consent40_50.convertConsent((Consent)src);
        }
        if (src instanceof Contract) {
            return Contract40_50.convertContract((Contract)src);
        }
        if (src instanceof Coverage) {
            return Coverage40_50.convertCoverage((Coverage)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.CoverageEligibilityRequest) {
            return CoverageEligibilityRequest40_50.convertCoverageEligibilityRequest((org.hl7.fhir.r4.model.CoverageEligibilityRequest)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.CoverageEligibilityResponse) {
            return CoverageEligibilityResponse40_50.convertCoverageEligibilityResponse((org.hl7.fhir.r4.model.CoverageEligibilityResponse)src);
        }
        if (src instanceof DetectedIssue) {
            return DetectedIssue40_50.convertDetectedIssue((DetectedIssue)src);
        }
        if (src instanceof Device) {
            return Device40_50.convertDevice((Device)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.DeviceDefinition) {
            return DeviceDefinition40_50.convertDeviceDefinition((org.hl7.fhir.r4.model.DeviceDefinition)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.DeviceMetric) {
            return DeviceMetric40_50.convertDeviceMetric((org.hl7.fhir.r4.model.DeviceMetric)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.DeviceRequest) {
            return DeviceRequest40_50.convertDeviceRequest((org.hl7.fhir.r4.model.DeviceRequest)src);
        }
        if (src instanceof DeviceUseStatement) {
            return DeviceUseStatement40_50.convertDeviceUseStatement((DeviceUseStatement)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.DiagnosticReport) {
            return DiagnosticReport40_50.convertDiagnosticReport((org.hl7.fhir.r4.model.DiagnosticReport)src);
        }
        if (src instanceof DocumentManifest) {
            return DocumentManifest40_50.convertDocumentManifest((DocumentManifest)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.DocumentReference) {
            return DocumentReference40_50.convertDocumentReference((org.hl7.fhir.r4.model.DocumentReference)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Encounter) {
            return Encounter40_50.convertEncounter((org.hl7.fhir.r4.model.Encounter)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Endpoint) {
            return Endpoint40_50.convertEndpoint((org.hl7.fhir.r4.model.Endpoint)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.EnrollmentRequest) {
            return EnrollmentRequest40_50.convertEnrollmentRequest((org.hl7.fhir.r4.model.EnrollmentRequest)src);
        }
        if (src instanceof EnrollmentResponse) {
            return EnrollmentResponse40_50.convertEnrollmentResponse((EnrollmentResponse)src);
        }
        if (src instanceof EpisodeOfCare) {
            return EpisodeOfCare40_50.convertEpisodeOfCare((EpisodeOfCare)src);
        }
        if (src instanceof EventDefinition) {
            return EventDefinition40_50.convertEventDefinition((EventDefinition)src);
        }
        if (src instanceof ExampleScenario) {
            return ExampleScenario40_50.convertExampleScenario((ExampleScenario)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.ExplanationOfBenefit) {
            return ExplanationOfBenefit40_50.convertExplanationOfBenefit((org.hl7.fhir.r4.model.ExplanationOfBenefit)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.FamilyMemberHistory) {
            return FamilyMemberHistory40_50.convertFamilyMemberHistory((org.hl7.fhir.r4.model.FamilyMemberHistory)src);
        }
        if (src instanceof Flag) {
            return Flag40_50.convertFlag((Flag)src);
        }
        if (src instanceof Goal) {
            return Goal40_50.convertGoal((Goal)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.GraphDefinition) {
            return GraphDefinition40_50.convertGraphDefinition((org.hl7.fhir.r4.model.GraphDefinition)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Group) {
            return Group40_50.convertGroup((org.hl7.fhir.r4.model.Group)src);
        }
        if (src instanceof GuidanceResponse) {
            return GuidanceResponse40_50.convertGuidanceResponse((GuidanceResponse)src);
        }
        if (src instanceof HealthcareService) {
            return HealthcareService40_50.convertHealthcareService((HealthcareService)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.ImagingStudy) {
            return ImagingStudy40_50.convertImagingStudy((org.hl7.fhir.r4.model.ImagingStudy)src);
        }
        if (src instanceof Immunization) {
            return Immunization40_50.convertImmunization((Immunization)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.ImmunizationEvaluation) {
            return ImmunizationEvaluation40_50.convertImmunizationEvaluation((org.hl7.fhir.r4.model.ImmunizationEvaluation)src);
        }
        if (src instanceof ImmunizationRecommendation) {
            return ImmunizationRecommendation40_50.convertImmunizationRecommendation((ImmunizationRecommendation)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.ImplementationGuide) {
            return ImplementationGuide40_50.convertImplementationGuide((org.hl7.fhir.r4.model.ImplementationGuide)src);
        }
        if (src instanceof InsurancePlan) {
            return InsurancePlan40_50.convertInsurancePlan((InsurancePlan)src);
        }
        if (src instanceof Invoice) {
            return Invoice40_50.convertInvoice((Invoice)src);
        }
        if (src instanceof Library) {
            return Library40_50.convertLibrary((Library)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Linkage) {
            return Linkage40_50.convertLinkage((org.hl7.fhir.r4.model.Linkage)src);
        }
        if (src instanceof ListResource) {
            return ListResource40_50.convertListResource((ListResource)src);
        }
        if (src instanceof Location) {
            return Location40_50.convertLocation((Location)src);
        }
        if (src instanceof Measure) {
            return Measure40_50.convertMeasure((Measure)src);
        }
        if (src instanceof MeasureReport) {
            return MeasureReport40_50.convertMeasureReport((MeasureReport)src);
        }
        if (src instanceof Media) {
            return Media40_50.convertMedia((Media)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Medication) {
            return Medication40_50.convertMedication((org.hl7.fhir.r4.model.Medication)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.MedicationAdministration) {
            return MedicationAdministration40_50.convertMedicationAdministration((org.hl7.fhir.r4.model.MedicationAdministration)src);
        }
        if (src instanceof MedicationDispense) {
            return MedicationDispense40_50.convertMedicationDispense((MedicationDispense)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.MedicationKnowledge) {
            return MedicationKnowledge40_50.convertMedicationKnowledge((org.hl7.fhir.r4.model.MedicationKnowledge)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.MedicationRequest) {
            return MedicationRequest40_50.convertMedicationRequest((org.hl7.fhir.r4.model.MedicationRequest)src);
        }
        if (src instanceof MedicationStatement) {
            return MedicationStatement40_50.convertMedicationStatement((MedicationStatement)src);
        }
        if (src instanceof MedicinalProduct) {
            return MedicinalProductDefinition40_50.convertMedicinalProduct((MedicinalProduct)src);
        }
        if (src instanceof MessageDefinition) {
            return MessageDefinition40_50.convertMessageDefinition((MessageDefinition)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.MessageHeader) {
            return MessageHeader40_50.convertMessageHeader((org.hl7.fhir.r4.model.MessageHeader)src);
        }
        if (src instanceof MolecularSequence) {
            return MolecularSequence40_50.convertMolecularSequence((MolecularSequence)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.NamingSystem) {
            return NamingSystem40_50.convertNamingSystem((org.hl7.fhir.r4.model.NamingSystem)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.NutritionOrder) {
            return NutritionOrder40_50.convertNutritionOrder((org.hl7.fhir.r4.model.NutritionOrder)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Observation) {
            return Observation40_50.convertObservation((org.hl7.fhir.r4.model.Observation)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.ObservationDefinition) {
            return ObservationDefinition40_50.convertObservationDefinition((org.hl7.fhir.r4.model.ObservationDefinition)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.OperationDefinition) {
            return OperationDefinition40_50.convertOperationDefinition((org.hl7.fhir.r4.model.OperationDefinition)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.OperationOutcome) {
            return OperationOutcome40_50.convertOperationOutcome((org.hl7.fhir.r4.model.OperationOutcome)src);
        }
        if (src instanceof Organization) {
            return Organization40_50.convertOrganization((Organization)src);
        }
        if (src instanceof OrganizationAffiliation) {
            return OrganizationAffiliation40_50.convertOrganizationAffiliation((OrganizationAffiliation)src);
        }
        if (src instanceof Patient) {
            return Patient40_50.convertPatient((Patient)src);
        }
        if (src instanceof PaymentNotice) {
            return PaymentNotice40_50.convertPaymentNotice((PaymentNotice)src);
        }
        if (src instanceof PaymentReconciliation) {
            return PaymentReconciliation40_50.convertPaymentReconciliation((PaymentReconciliation)src);
        }
        if (src instanceof Person) {
            return Person40_50.convertPerson((Person)src);
        }
        if (src instanceof PlanDefinition) {
            return PlanDefinition40_50.convertPlanDefinition((PlanDefinition)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Practitioner) {
            return Practitioner40_50.convertPractitioner((org.hl7.fhir.r4.model.Practitioner)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.PractitionerRole) {
            return PractitionerRole40_50.convertPractitionerRole((org.hl7.fhir.r4.model.PractitionerRole)src);
        }
        if (src instanceof Procedure) {
            return Procedure40_50.convertProcedure((Procedure)src);
        }
        if (src instanceof Provenance) {
            return Provenance40_50.convertProvenance((Provenance)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Questionnaire) {
            return Questionnaire40_50.convertQuestionnaire((org.hl7.fhir.r4.model.Questionnaire)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.QuestionnaireResponse) {
            return QuestionnaireResponse40_50.convertQuestionnaireResponse((org.hl7.fhir.r4.model.QuestionnaireResponse)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.RelatedPerson) {
            return RelatedPerson40_50.convertRelatedPerson((org.hl7.fhir.r4.model.RelatedPerson)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.RequestGroup) {
            return RequestGroup40_50.convertRequestGroup((org.hl7.fhir.r4.model.RequestGroup)src);
        }
        if (src instanceof ResearchStudy) {
            return ResearchStudy40_50.convertResearchStudy((ResearchStudy)src);
        }
        if (src instanceof ResearchSubject) {
            return ResearchSubject40_50.convertResearchSubject((ResearchSubject)src);
        }
        if (src instanceof RiskAssessment) {
            return RiskAssessment40_50.convertRiskAssessment((RiskAssessment)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Schedule) {
            return Schedule40_50.convertSchedule((org.hl7.fhir.r4.model.Schedule)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.SearchParameter) {
            return SearchParameter40_50.convertSearchParameter((org.hl7.fhir.r4.model.SearchParameter)src);
        }
        if (src instanceof ServiceRequest) {
            return ServiceRequest40_50.convertServiceRequest((ServiceRequest)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Slot) {
            return Slot40_50.convertSlot((org.hl7.fhir.r4.model.Slot)src);
        }
        if (src instanceof Specimen) {
            return Specimen40_50.convertSpecimen((Specimen)src);
        }
        if (src instanceof SpecimenDefinition) {
            return SpecimenDefinition40_50.convertSpecimenDefinition((SpecimenDefinition)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.StructureDefinition) {
            return StructureDefinition40_50.convertStructureDefinition((org.hl7.fhir.r4.model.StructureDefinition)src);
        }
        if (src instanceof StructureMap) {
            return StructureMap40_50.convertStructureMap((StructureMap)src);
        }
        if (src instanceof Substance) {
            return Substance40_50.convertSubstance((Substance)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.SubstanceNucleicAcid) {
            return SubstanceNucleicAcid40_50.convertSubstanceNucleicAcid((org.hl7.fhir.r4.model.SubstanceNucleicAcid)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.SubstancePolymer) {
            return SubstancePolymer40_50.convertSubstancePolymer((org.hl7.fhir.r4.model.SubstancePolymer)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.SubstanceProtein) {
            return SubstanceProtein40_50.convertSubstanceProtein((org.hl7.fhir.r4.model.SubstanceProtein)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.SubstanceReferenceInformation) {
            return SubstanceReferenceInformation40_50.convertSubstanceReferenceInformation((org.hl7.fhir.r4.model.SubstanceReferenceInformation)src);
        }
        if (src instanceof SubstanceSourceMaterial) {
            return SubstanceSourceMaterial40_50.convertSubstanceSourceMaterial((SubstanceSourceMaterial)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.SupplyDelivery) {
            return SupplyDelivery40_50.convertSupplyDelivery((org.hl7.fhir.r4.model.SupplyDelivery)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.SupplyRequest) {
            return SupplyRequest40_50.convertSupplyRequest((org.hl7.fhir.r4.model.SupplyRequest)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Task) {
            return Task40_50.convertTask((org.hl7.fhir.r4.model.Task)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.TerminologyCapabilities) {
            return TerminologyCapabilities40_50.convertTerminologyCapabilities((org.hl7.fhir.r4.model.TerminologyCapabilities)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.TestReport) {
            return TestReport40_50.convertTestReport((org.hl7.fhir.r4.model.TestReport)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.TestScript) {
            return TestScript40_50.convertTestScript((org.hl7.fhir.r4.model.TestScript)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.ValueSet) {
            return ValueSet40_50.convertValueSet((org.hl7.fhir.r4.model.ValueSet)src);
        }
        if (src instanceof VerificationResult) {
            return VerificationResult40_50.convertVerificationResult((VerificationResult)src);
        }
        if (src instanceof VisionPrescription) {
            return VisionPrescription40_50.convertVisionPrescription((VisionPrescription)src);
        }
        throw new Error("Unknown resource " + src.fhirType());
    }

    public static org.hl7.fhir.r4.model.Resource convertResource(Resource src) throws FHIRException {
        if (src == null) {
            return null;
        }
        if (src instanceof Parameters) {
            return Parameters40_50.convertParameters((Parameters)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Account) {
            return Account40_50.convertAccount((org.hl7.fhir.r5.model.Account)src);
        }
        if (src instanceof ActivityDefinition) {
            return ActivityDefinition40_50.convertActivityDefinition((ActivityDefinition)src);
        }
        if (src instanceof AllergyIntolerance) {
            return AllergyIntolerance40_50.convertAllergyIntolerance((AllergyIntolerance)src);
        }
        if (src instanceof Appointment) {
            return Appointment40_50.convertAppointment((Appointment)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.AppointmentResponse) {
            return AppointmentResponse40_50.convertAppointmentResponse((org.hl7.fhir.r5.model.AppointmentResponse)src);
        }
        if (src instanceof AuditEvent) {
            return AuditEvent40_50.convertAuditEvent((AuditEvent)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Basic) {
            return Basic40_50.convertBasic((org.hl7.fhir.r5.model.Basic)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Binary) {
            return Binary40_50.convertBinary((org.hl7.fhir.r5.model.Binary)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.BiologicallyDerivedProduct) {
            return BiologicallyDerivedProduct40_50.convertBiologicallyDerivedProduct((org.hl7.fhir.r5.model.BiologicallyDerivedProduct)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.BodyStructure) {
            return BodyStructure40_50.convertBodyStructure((org.hl7.fhir.r5.model.BodyStructure)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Bundle) {
            return Bundle40_50.convertBundle((org.hl7.fhir.r5.model.Bundle)src);
        }
        if (src instanceof CapabilityStatement) {
            return CapabilityStatement40_50.convertCapabilityStatement((CapabilityStatement)src);
        }
        if (src instanceof CarePlan) {
            return CarePlan40_50.convertCarePlan((CarePlan)src);
        }
        if (src instanceof CareTeam) {
            return CareTeam40_50.convertCareTeam((CareTeam)src);
        }
        if (src instanceof ChargeItem) {
            return ChargeItem40_50.convertChargeItem((ChargeItem)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.ChargeItemDefinition) {
            return ChargeItemDefinition40_50.convertChargeItemDefinition((org.hl7.fhir.r5.model.ChargeItemDefinition)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Claim) {
            return Claim40_50.convertClaim((org.hl7.fhir.r5.model.Claim)src);
        }
        if (src instanceof ClaimResponse) {
            return ClaimResponse40_50.convertClaimResponse((ClaimResponse)src);
        }
        if (src instanceof ClinicalImpression) {
            return ClinicalImpression40_50.convertClinicalImpression((ClinicalImpression)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.CodeSystem) {
            return CodeSystem40_50.convertCodeSystem((org.hl7.fhir.r5.model.CodeSystem)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Communication) {
            return Communication40_50.convertCommunication((org.hl7.fhir.r5.model.Communication)src);
        }
        if (src instanceof CommunicationRequest) {
            return CommunicationRequest40_50.convertCommunicationRequest((CommunicationRequest)src);
        }
        if (src instanceof CompartmentDefinition) {
            return CompartmentDefinition40_50.convertCompartmentDefinition((CompartmentDefinition)src);
        }
        if (src instanceof Composition) {
            return Composition40_50.convertComposition((Composition)src);
        }
        if (src instanceof ConceptMap) {
            return ConceptMap40_50.convertConceptMap((ConceptMap)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Condition) {
            return Condition40_50.convertCondition((org.hl7.fhir.r5.model.Condition)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Consent) {
            return Consent40_50.convertConsent((org.hl7.fhir.r5.model.Consent)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Contract) {
            return Contract40_50.convertContract((org.hl7.fhir.r5.model.Contract)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Coverage) {
            return Coverage40_50.convertCoverage((org.hl7.fhir.r5.model.Coverage)src);
        }
        if (src instanceof CoverageEligibilityRequest) {
            return CoverageEligibilityRequest40_50.convertCoverageEligibilityRequest((CoverageEligibilityRequest)src);
        }
        if (src instanceof CoverageEligibilityResponse) {
            return CoverageEligibilityResponse40_50.convertCoverageEligibilityResponse((CoverageEligibilityResponse)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.DetectedIssue) {
            return DetectedIssue40_50.convertDetectedIssue((org.hl7.fhir.r5.model.DetectedIssue)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Device) {
            return Device40_50.convertDevice((org.hl7.fhir.r5.model.Device)src);
        }
        if (src instanceof DeviceDefinition) {
            return DeviceDefinition40_50.convertDeviceDefinition((DeviceDefinition)src);
        }
        if (src instanceof DeviceMetric) {
            return DeviceMetric40_50.convertDeviceMetric((DeviceMetric)src);
        }
        if (src instanceof DeviceRequest) {
            return DeviceRequest40_50.convertDeviceRequest((DeviceRequest)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.DeviceUseStatement) {
            return DeviceUseStatement40_50.convertDeviceUseStatement((org.hl7.fhir.r5.model.DeviceUseStatement)src);
        }
        if (src instanceof DiagnosticReport) {
            return DiagnosticReport40_50.convertDiagnosticReport((DiagnosticReport)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.DocumentManifest) {
            return DocumentManifest40_50.convertDocumentManifest((org.hl7.fhir.r5.model.DocumentManifest)src);
        }
        if (src instanceof DocumentReference) {
            return DocumentReference40_50.convertDocumentReference((DocumentReference)src);
        }
        if (src instanceof Encounter) {
            return Encounter40_50.convertEncounter((Encounter)src);
        }
        if (src instanceof Endpoint) {
            return Endpoint40_50.convertEndpoint((Endpoint)src);
        }
        if (src instanceof EnrollmentRequest) {
            return EnrollmentRequest40_50.convertEnrollmentRequest((EnrollmentRequest)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.EnrollmentResponse) {
            return EnrollmentResponse40_50.convertEnrollmentResponse((org.hl7.fhir.r5.model.EnrollmentResponse)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.EpisodeOfCare) {
            return EpisodeOfCare40_50.convertEpisodeOfCare((org.hl7.fhir.r5.model.EpisodeOfCare)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.EventDefinition) {
            return EventDefinition40_50.convertEventDefinition((org.hl7.fhir.r5.model.EventDefinition)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.ExampleScenario) {
            return ExampleScenario40_50.convertExampleScenario((org.hl7.fhir.r5.model.ExampleScenario)src);
        }
        if (src instanceof ExplanationOfBenefit) {
            return ExplanationOfBenefit40_50.convertExplanationOfBenefit((ExplanationOfBenefit)src);
        }
        if (src instanceof FamilyMemberHistory) {
            return FamilyMemberHistory40_50.convertFamilyMemberHistory((FamilyMemberHistory)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Flag) {
            return Flag40_50.convertFlag((org.hl7.fhir.r5.model.Flag)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Goal) {
            return Goal40_50.convertGoal((org.hl7.fhir.r5.model.Goal)src);
        }
        if (src instanceof GraphDefinition) {
            return GraphDefinition40_50.convertGraphDefinition((GraphDefinition)src);
        }
        if (src instanceof Group) {
            return Group40_50.convertGroup((Group)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.GuidanceResponse) {
            return GuidanceResponse40_50.convertGuidanceResponse((org.hl7.fhir.r5.model.GuidanceResponse)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.HealthcareService) {
            return HealthcareService40_50.convertHealthcareService((org.hl7.fhir.r5.model.HealthcareService)src);
        }
        if (src instanceof ImagingStudy) {
            return ImagingStudy40_50.convertImagingStudy((ImagingStudy)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Immunization) {
            return Immunization40_50.convertImmunization((org.hl7.fhir.r5.model.Immunization)src);
        }
        if (src instanceof ImmunizationEvaluation) {
            return ImmunizationEvaluation40_50.convertImmunizationEvaluation((ImmunizationEvaluation)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.ImmunizationRecommendation) {
            return ImmunizationRecommendation40_50.convertImmunizationRecommendation((org.hl7.fhir.r5.model.ImmunizationRecommendation)src);
        }
        if (src instanceof ImplementationGuide) {
            return ImplementationGuide40_50.convertImplementationGuide((ImplementationGuide)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.InsurancePlan) {
            return InsurancePlan40_50.convertInsurancePlan((org.hl7.fhir.r5.model.InsurancePlan)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Invoice) {
            return Invoice40_50.convertInvoice((org.hl7.fhir.r5.model.Invoice)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Library) {
            return Library40_50.convertLibrary((org.hl7.fhir.r5.model.Library)src);
        }
        if (src instanceof Linkage) {
            return Linkage40_50.convertLinkage((Linkage)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.ListResource) {
            return ListResource40_50.convertListResource((org.hl7.fhir.r5.model.ListResource)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Location) {
            return Location40_50.convertLocation((org.hl7.fhir.r5.model.Location)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Measure) {
            return Measure40_50.convertMeasure((org.hl7.fhir.r5.model.Measure)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.MeasureReport) {
            return MeasureReport40_50.convertMeasureReport((org.hl7.fhir.r5.model.MeasureReport)src);
        }
        if (src instanceof DocumentReference) {
            return Media40_50.convertMedia((DocumentReference)src);
        }
        if (src instanceof Medication) {
            return Medication40_50.convertMedication((Medication)src);
        }
        if (src instanceof MedicationAdministration) {
            return MedicationAdministration40_50.convertMedicationAdministration((MedicationAdministration)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.MedicationDispense) {
            return MedicationDispense40_50.convertMedicationDispense((org.hl7.fhir.r5.model.MedicationDispense)src);
        }
        if (src instanceof MedicationKnowledge) {
            return MedicationKnowledge40_50.convertMedicationKnowledge((MedicationKnowledge)src);
        }
        if (src instanceof MedicationRequest) {
            return MedicationRequest40_50.convertMedicationRequest((MedicationRequest)src);
        }
        if (src instanceof MedicationUsage) {
            return MedicationStatement40_50.convertMedicationStatement((MedicationUsage)src);
        }
        if (src instanceof MedicinalProductDefinition) {
            return MedicinalProductDefinition40_50.convertMedicinalProductDefinition((MedicinalProductDefinition)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.MessageDefinition) {
            return MessageDefinition40_50.convertMessageDefinition((org.hl7.fhir.r5.model.MessageDefinition)src);
        }
        if (src instanceof MessageHeader) {
            return MessageHeader40_50.convertMessageHeader((MessageHeader)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.MolecularSequence) {
            return MolecularSequence40_50.convertMolecularSequence((org.hl7.fhir.r5.model.MolecularSequence)src);
        }
        if (src instanceof NamingSystem) {
            return NamingSystem40_50.convertNamingSystem((NamingSystem)src);
        }
        if (src instanceof NutritionOrder) {
            return NutritionOrder40_50.convertNutritionOrder((NutritionOrder)src);
        }
        if (src instanceof Observation) {
            return Observation40_50.convertObservation((Observation)src);
        }
        if (src instanceof ObservationDefinition) {
            return ObservationDefinition40_50.convertObservationDefinition((ObservationDefinition)src);
        }
        if (src instanceof OperationDefinition) {
            return OperationDefinition40_50.convertOperationDefinition((OperationDefinition)src);
        }
        if (src instanceof OperationOutcome) {
            return OperationOutcome40_50.convertOperationOutcome((OperationOutcome)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Organization) {
            return Organization40_50.convertOrganization((org.hl7.fhir.r5.model.Organization)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.OrganizationAffiliation) {
            return OrganizationAffiliation40_50.convertOrganizationAffiliation((org.hl7.fhir.r5.model.OrganizationAffiliation)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Patient) {
            return Patient40_50.convertPatient((org.hl7.fhir.r5.model.Patient)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.PaymentNotice) {
            return PaymentNotice40_50.convertPaymentNotice((org.hl7.fhir.r5.model.PaymentNotice)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.PaymentReconciliation) {
            return PaymentReconciliation40_50.convertPaymentReconciliation((org.hl7.fhir.r5.model.PaymentReconciliation)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Person) {
            return Person40_50.convertPerson((org.hl7.fhir.r5.model.Person)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.PlanDefinition) {
            return PlanDefinition40_50.convertPlanDefinition((org.hl7.fhir.r5.model.PlanDefinition)src);
        }
        if (src instanceof Practitioner) {
            return Practitioner40_50.convertPractitioner((Practitioner)src);
        }
        if (src instanceof PractitionerRole) {
            return PractitionerRole40_50.convertPractitionerRole((PractitionerRole)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Procedure) {
            return Procedure40_50.convertProcedure((org.hl7.fhir.r5.model.Procedure)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Provenance) {
            return Provenance40_50.convertProvenance((org.hl7.fhir.r5.model.Provenance)src);
        }
        if (src instanceof Questionnaire) {
            return Questionnaire40_50.convertQuestionnaire((Questionnaire)src);
        }
        if (src instanceof QuestionnaireResponse) {
            return QuestionnaireResponse40_50.convertQuestionnaireResponse((QuestionnaireResponse)src);
        }
        if (src instanceof RelatedPerson) {
            return RelatedPerson40_50.convertRelatedPerson((RelatedPerson)src);
        }
        if (src instanceof RequestGroup) {
            return RequestGroup40_50.convertRequestGroup((RequestGroup)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.ResearchStudy) {
            return ResearchStudy40_50.convertResearchStudy((org.hl7.fhir.r5.model.ResearchStudy)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.ResearchSubject) {
            return ResearchSubject40_50.convertResearchSubject((org.hl7.fhir.r5.model.ResearchSubject)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.RiskAssessment) {
            return RiskAssessment40_50.convertRiskAssessment((org.hl7.fhir.r5.model.RiskAssessment)src);
        }
        if (src instanceof Schedule) {
            return Schedule40_50.convertSchedule((Schedule)src);
        }
        if (src instanceof SearchParameter) {
            return SearchParameter40_50.convertSearchParameter((SearchParameter)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.ServiceRequest) {
            return ServiceRequest40_50.convertServiceRequest((org.hl7.fhir.r5.model.ServiceRequest)src);
        }
        if (src instanceof Slot) {
            return Slot40_50.convertSlot((Slot)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Specimen) {
            return Specimen40_50.convertSpecimen((org.hl7.fhir.r5.model.Specimen)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.SpecimenDefinition) {
            return SpecimenDefinition40_50.convertSpecimenDefinition((org.hl7.fhir.r5.model.SpecimenDefinition)src);
        }
        if (src instanceof StructureDefinition) {
            return StructureDefinition40_50.convertStructureDefinition((StructureDefinition)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.StructureMap) {
            return StructureMap40_50.convertStructureMap((org.hl7.fhir.r5.model.StructureMap)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Substance) {
            return Substance40_50.convertSubstance((org.hl7.fhir.r5.model.Substance)src);
        }
        if (src instanceof SubstanceNucleicAcid) {
            return SubstanceNucleicAcid40_50.convertSubstanceNucleicAcid((SubstanceNucleicAcid)src);
        }
        if (src instanceof SubstancePolymer) {
            return SubstancePolymer40_50.convertSubstancePolymer((SubstancePolymer)src);
        }
        if (src instanceof SubstanceProtein) {
            return SubstanceProtein40_50.convertSubstanceProtein((SubstanceProtein)src);
        }
        if (src instanceof SubstanceReferenceInformation) {
            return SubstanceReferenceInformation40_50.convertSubstanceReferenceInformation((SubstanceReferenceInformation)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.SubstanceSourceMaterial) {
            return SubstanceSourceMaterial40_50.convertSubstanceSourceMaterial((org.hl7.fhir.r5.model.SubstanceSourceMaterial)src);
        }
        if (src instanceof SupplyDelivery) {
            return SupplyDelivery40_50.convertSupplyDelivery((SupplyDelivery)src);
        }
        if (src instanceof SupplyRequest) {
            return SupplyRequest40_50.convertSupplyRequest((SupplyRequest)src);
        }
        if (src instanceof Task) {
            return Task40_50.convertTask((Task)src);
        }
        if (src instanceof TerminologyCapabilities) {
            return TerminologyCapabilities40_50.convertTerminologyCapabilities((TerminologyCapabilities)src);
        }
        if (src instanceof TestReport) {
            return TestReport40_50.convertTestReport((TestReport)src);
        }
        if (src instanceof TestScript) {
            return TestScript40_50.convertTestScript((TestScript)src);
        }
        if (src instanceof ValueSet) {
            return ValueSet40_50.convertValueSet((ValueSet)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.VerificationResult) {
            return VerificationResult40_50.convertVerificationResult((org.hl7.fhir.r5.model.VerificationResult)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.VisionPrescription) {
            return VisionPrescription40_50.convertVisionPrescription((org.hl7.fhir.r5.model.VisionPrescription)src);
        }
        throw new Error("Unknown resource " + src.fhirType());
    }

    protected static org.hl7.fhir.r5.model.CodeType convertResourceEnum(CodeType src) {
        return VersionConvertor_40_50.convertCode(src);
    }

    protected static CodeType convertResourceEnum(org.hl7.fhir.r5.model.CodeType src) {
        return VersionConvertor_40_50.convertCode(src);
    }

    protected static CodeableReference convertReferenceToCodeableReference(org.hl7.fhir.r4.model.Reference src) {
        CodeableReference tgt = new CodeableReference();
        tgt.setReference(VersionConvertor_40_50.convertReference(src));
        return tgt;
    }

    protected static CodeableReference convertCodeableConceptToCodeableReference(org.hl7.fhir.r4.model.CodeableConcept src) {
        CodeableReference tgt = new CodeableReference();
        tgt.setConcept(VersionConvertor_40_50.convertCodeableConcept(src));
        return tgt;
    }
}

