/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.hl7.fhir.convertors.VersionConvertorConstants;
import org.hl7.fhir.convertors.conv30_40.ActivityDefinition30_40;
import org.hl7.fhir.convertors.conv30_40.AllergyIntolerance30_40;
import org.hl7.fhir.convertors.conv30_40.Appointment30_40;
import org.hl7.fhir.convertors.conv30_40.AppointmentResponse30_40;
import org.hl7.fhir.convertors.conv30_40.AuditEvent30_40;
import org.hl7.fhir.convertors.conv30_40.Basic30_40;
import org.hl7.fhir.convertors.conv30_40.Binary30_40;
import org.hl7.fhir.convertors.conv30_40.BodySite30_40;
import org.hl7.fhir.convertors.conv30_40.Bundle30_40;
import org.hl7.fhir.convertors.conv30_40.CapabilityStatement30_40;
import org.hl7.fhir.convertors.conv30_40.CarePlan30_40;
import org.hl7.fhir.convertors.conv30_40.CareTeam30_40;
import org.hl7.fhir.convertors.conv30_40.ClinicalImpression30_40;
import org.hl7.fhir.convertors.conv30_40.CodeSystem30_40;
import org.hl7.fhir.convertors.conv30_40.Communication30_40;
import org.hl7.fhir.convertors.conv30_40.CompartmentDefinition30_40;
import org.hl7.fhir.convertors.conv30_40.Composition30_40;
import org.hl7.fhir.convertors.conv30_40.ConceptMap30_40;
import org.hl7.fhir.convertors.conv30_40.Condition30_40;
import org.hl7.fhir.convertors.conv30_40.Consent30_40;
import org.hl7.fhir.convertors.conv30_40.DataElement30_40;
import org.hl7.fhir.convertors.conv30_40.DetectedIssue30_40;
import org.hl7.fhir.convertors.conv30_40.DeviceUseStatement30_40;
import org.hl7.fhir.convertors.conv30_40.DiagnosticReport30_40;
import org.hl7.fhir.convertors.conv30_40.DocumentReference30_40;
import org.hl7.fhir.convertors.conv30_40.Encounter30_40;
import org.hl7.fhir.convertors.conv30_40.Endpoint30_40;
import org.hl7.fhir.convertors.conv30_40.EpisodeOfCare30_40;
import org.hl7.fhir.convertors.conv30_40.ExpansionProfile30_40;
import org.hl7.fhir.convertors.conv30_40.FamilyMemberHistory30_40;
import org.hl7.fhir.convertors.conv30_40.Flag30_40;
import org.hl7.fhir.convertors.conv30_40.Goal30_40;
import org.hl7.fhir.convertors.conv30_40.GraphDefinition30_40;
import org.hl7.fhir.convertors.conv30_40.Group30_40;
import org.hl7.fhir.convertors.conv30_40.HealthcareService30_40;
import org.hl7.fhir.convertors.conv30_40.ImagingStudy30_40;
import org.hl7.fhir.convertors.conv30_40.Immunization30_40;
import org.hl7.fhir.convertors.conv30_40.ImplementationGuide30_40;
import org.hl7.fhir.convertors.conv30_40.Library30_40;
import org.hl7.fhir.convertors.conv30_40.Linkage30_40;
import org.hl7.fhir.convertors.conv30_40.List30_40;
import org.hl7.fhir.convertors.conv30_40.Location30_40;
import org.hl7.fhir.convertors.conv30_40.Media30_40;
import org.hl7.fhir.convertors.conv30_40.Medication30_40;
import org.hl7.fhir.convertors.conv30_40.MedicationAdministration30_40;
import org.hl7.fhir.convertors.conv30_40.MedicationDispense30_40;
import org.hl7.fhir.convertors.conv30_40.MedicationRequest30_40;
import org.hl7.fhir.convertors.conv30_40.MedicationStatement30_40;
import org.hl7.fhir.convertors.conv30_40.MessageDefinition30_40;
import org.hl7.fhir.convertors.conv30_40.MessageHeader30_40;
import org.hl7.fhir.convertors.conv30_40.NamingSystem30_40;
import org.hl7.fhir.convertors.conv30_40.Observation30_40;
import org.hl7.fhir.convertors.conv30_40.OperationDefinition30_40;
import org.hl7.fhir.convertors.conv30_40.OperationOutcome30_40;
import org.hl7.fhir.convertors.conv30_40.Organization30_40;
import org.hl7.fhir.convertors.conv30_40.Parameters30_40;
import org.hl7.fhir.convertors.conv30_40.Patient30_40;
import org.hl7.fhir.convertors.conv30_40.PaymentNotice30_40;
import org.hl7.fhir.convertors.conv30_40.Person30_40;
import org.hl7.fhir.convertors.conv30_40.PlanDefinition30_40;
import org.hl7.fhir.convertors.conv30_40.Practitioner30_40;
import org.hl7.fhir.convertors.conv30_40.PractitionerRole30_40;
import org.hl7.fhir.convertors.conv30_40.Procedure30_40;
import org.hl7.fhir.convertors.conv30_40.ProcedureRequest30_40;
import org.hl7.fhir.convertors.conv30_40.Provenance30_40;
import org.hl7.fhir.convertors.conv30_40.Questionnaire30_40;
import org.hl7.fhir.convertors.conv30_40.QuestionnaireResponse30_40;
import org.hl7.fhir.convertors.conv30_40.RelatedPerson30_40;
import org.hl7.fhir.convertors.conv30_40.RiskAssessment30_40;
import org.hl7.fhir.convertors.conv30_40.Schedule30_40;
import org.hl7.fhir.convertors.conv30_40.SearchParameter30_40;
import org.hl7.fhir.convertors.conv30_40.Sequence30_40;
import org.hl7.fhir.convertors.conv30_40.Slot30_40;
import org.hl7.fhir.convertors.conv30_40.Specimen30_40;
import org.hl7.fhir.convertors.conv30_40.StructureDefinition30_40;
import org.hl7.fhir.convertors.conv30_40.StructureMap30_40;
import org.hl7.fhir.convertors.conv30_40.Subscription30_40;
import org.hl7.fhir.convertors.conv30_40.Substance30_40;
import org.hl7.fhir.convertors.conv30_40.SupplyDelivery30_40;
import org.hl7.fhir.convertors.conv30_40.TestReport30_40;
import org.hl7.fhir.convertors.conv30_40.TestScript30_40;
import org.hl7.fhir.convertors.conv30_40.ValueSet30_40;
import org.hl7.fhir.dstu3.model.ActivityDefinition;
import org.hl7.fhir.dstu3.model.Address;
import org.hl7.fhir.dstu3.model.Annotation;
import org.hl7.fhir.dstu3.model.Appointment;
import org.hl7.fhir.dstu3.model.AppointmentResponse;
import org.hl7.fhir.dstu3.model.AuditEvent;
import org.hl7.fhir.dstu3.model.BodySite;
import org.hl7.fhir.dstu3.model.BooleanType;
import org.hl7.fhir.dstu3.model.CarePlan;
import org.hl7.fhir.dstu3.model.CodeType;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Coding;
import org.hl7.fhir.dstu3.model.CompartmentDefinition;
import org.hl7.fhir.dstu3.model.Composition;
import org.hl7.fhir.dstu3.model.ConceptMap;
import org.hl7.fhir.dstu3.model.Consent;
import org.hl7.fhir.dstu3.model.ContactDetail;
import org.hl7.fhir.dstu3.model.ContactPoint;
import org.hl7.fhir.dstu3.model.Contributor;
import org.hl7.fhir.dstu3.model.Count;
import org.hl7.fhir.dstu3.model.DataElement;
import org.hl7.fhir.dstu3.model.DataRequirement;
import org.hl7.fhir.dstu3.model.Distance;
import org.hl7.fhir.dstu3.model.DocumentManifest;
import org.hl7.fhir.dstu3.model.DocumentReference;
import org.hl7.fhir.dstu3.model.DomainResource;
import org.hl7.fhir.dstu3.model.ElementDefinition;
import org.hl7.fhir.dstu3.model.Encounter;
import org.hl7.fhir.dstu3.model.Endpoint;
import org.hl7.fhir.dstu3.model.Enumeration;
import org.hl7.fhir.dstu3.model.Enumerations;
import org.hl7.fhir.dstu3.model.EpisodeOfCare;
import org.hl7.fhir.dstu3.model.ExpansionProfile;
import org.hl7.fhir.dstu3.model.Flag;
import org.hl7.fhir.dstu3.model.Goal;
import org.hl7.fhir.dstu3.model.GraphDefinition;
import org.hl7.fhir.dstu3.model.HumanName;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.ImplementationGuide;
import org.hl7.fhir.dstu3.model.IntegerType;
import org.hl7.fhir.dstu3.model.Library;
import org.hl7.fhir.dstu3.model.Linkage;
import org.hl7.fhir.dstu3.model.ListResource;
import org.hl7.fhir.dstu3.model.Location;
import org.hl7.fhir.dstu3.model.MarkdownType;
import org.hl7.fhir.dstu3.model.Media;
import org.hl7.fhir.dstu3.model.MedicationRequest;
import org.hl7.fhir.dstu3.model.Money;
import org.hl7.fhir.dstu3.model.Narrative;
import org.hl7.fhir.dstu3.model.OidType;
import org.hl7.fhir.dstu3.model.OperationDefinition;
import org.hl7.fhir.dstu3.model.Organization;
import org.hl7.fhir.dstu3.model.ParameterDefinition;
import org.hl7.fhir.dstu3.model.Parameters;
import org.hl7.fhir.dstu3.model.Period;
import org.hl7.fhir.dstu3.model.PlanDefinition;
import org.hl7.fhir.dstu3.model.Practitioner;
import org.hl7.fhir.dstu3.model.PractitionerRole;
import org.hl7.fhir.dstu3.model.ProcedureRequest;
import org.hl7.fhir.dstu3.model.Quantity;
import org.hl7.fhir.dstu3.model.Questionnaire;
import org.hl7.fhir.dstu3.model.QuestionnaireResponse;
import org.hl7.fhir.dstu3.model.Range;
import org.hl7.fhir.dstu3.model.Ratio;
import org.hl7.fhir.dstu3.model.RelatedArtifact;
import org.hl7.fhir.dstu3.model.RelatedPerson;
import org.hl7.fhir.dstu3.model.Schedule;
import org.hl7.fhir.dstu3.model.Sequence;
import org.hl7.fhir.dstu3.model.Signature;
import org.hl7.fhir.dstu3.model.SimpleQuantity;
import org.hl7.fhir.dstu3.model.Specimen;
import org.hl7.fhir.dstu3.model.StructureDefinition;
import org.hl7.fhir.dstu3.model.Substance;
import org.hl7.fhir.dstu3.model.SupplyDelivery;
import org.hl7.fhir.dstu3.model.TestReport;
import org.hl7.fhir.dstu3.model.TestScript;
import org.hl7.fhir.dstu3.model.Timing;
import org.hl7.fhir.dstu3.model.TriggerDefinition;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.dstu3.model.UriType;
import org.hl7.fhir.dstu3.model.UsageContext;
import org.hl7.fhir.dstu3.model.UuidType;
import org.hl7.fhir.dstu3.model.ValueSet;
import org.hl7.fhir.dstu3.utils.ToolingExtensions;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Address;
import org.hl7.fhir.r4.model.Age;
import org.hl7.fhir.r4.model.AllergyIntolerance;
import org.hl7.fhir.r4.model.Attachment;
import org.hl7.fhir.r4.model.BackboneElement;
import org.hl7.fhir.r4.model.Base64BinaryType;
import org.hl7.fhir.r4.model.Basic;
import org.hl7.fhir.r4.model.Binary;
import org.hl7.fhir.r4.model.BodyStructure;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.CapabilityStatement;
import org.hl7.fhir.r4.model.CareTeam;
import org.hl7.fhir.r4.model.ClinicalImpression;
import org.hl7.fhir.r4.model.CodeSystem;
import org.hl7.fhir.r4.model.Communication;
import org.hl7.fhir.r4.model.Condition;
import org.hl7.fhir.r4.model.ContactPoint;
import org.hl7.fhir.r4.model.Contributor;
import org.hl7.fhir.r4.model.DataRequirement;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.DateType;
import org.hl7.fhir.r4.model.DecimalType;
import org.hl7.fhir.r4.model.DetectedIssue;
import org.hl7.fhir.r4.model.DeviceUseStatement;
import org.hl7.fhir.r4.model.DiagnosticReport;
import org.hl7.fhir.r4.model.DocumentManifest;
import org.hl7.fhir.r4.model.DocumentReference;
import org.hl7.fhir.r4.model.Dosage;
import org.hl7.fhir.r4.model.Duration;
import org.hl7.fhir.r4.model.Element;
import org.hl7.fhir.r4.model.ElementDefinition;
import org.hl7.fhir.r4.model.Encounter;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.EpisodeOfCare;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.FamilyMemberHistory;
import org.hl7.fhir.r4.model.Group;
import org.hl7.fhir.r4.model.HealthcareService;
import org.hl7.fhir.r4.model.HumanName;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.ImagingStudy;
import org.hl7.fhir.r4.model.Immunization;
import org.hl7.fhir.r4.model.InstantType;
import org.hl7.fhir.r4.model.Medication;
import org.hl7.fhir.r4.model.MedicationAdministration;
import org.hl7.fhir.r4.model.MedicationDispense;
import org.hl7.fhir.r4.model.MedicationStatement;
import org.hl7.fhir.r4.model.MessageDefinition;
import org.hl7.fhir.r4.model.MessageHeader;
import org.hl7.fhir.r4.model.Meta;
import org.hl7.fhir.r4.model.MolecularSequence;
import org.hl7.fhir.r4.model.NamingSystem;
import org.hl7.fhir.r4.model.Narrative;
import org.hl7.fhir.r4.model.Observation;
import org.hl7.fhir.r4.model.OperationOutcome;
import org.hl7.fhir.r4.model.ParameterDefinition;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.PaymentNotice;
import org.hl7.fhir.r4.model.Person;
import org.hl7.fhir.r4.model.PositiveIntType;
import org.hl7.fhir.r4.model.PractitionerRole;
import org.hl7.fhir.r4.model.Procedure;
import org.hl7.fhir.r4.model.Provenance;
import org.hl7.fhir.r4.model.Quantity;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.RelatedArtifact;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.RiskAssessment;
import org.hl7.fhir.r4.model.SampledData;
import org.hl7.fhir.r4.model.SearchParameter;
import org.hl7.fhir.r4.model.ServiceRequest;
import org.hl7.fhir.r4.model.Slot;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.StructureMap;
import org.hl7.fhir.r4.model.Subscription;
import org.hl7.fhir.r4.model.TerminologyCapabilities;
import org.hl7.fhir.r4.model.TestReport;
import org.hl7.fhir.r4.model.TestScript;
import org.hl7.fhir.r4.model.TimeType;
import org.hl7.fhir.r4.model.Timing;
import org.hl7.fhir.r4.model.TriggerDefinition;
import org.hl7.fhir.r4.model.UnsignedIntType;
import org.hl7.fhir.r4.model.ValueSet;
import org.hl7.fhir.utilities.Utilities;

public class VersionConvertor_30_40 {
    public static final String EXT_SRC_TYPE = "http://hl7.org/fhir/StructureDefinition/structuredefinition-fhir-type";
    public static List<String> CANONICAL_URLS = new ArrayList<String>();
    public static final String URN_IETF_RFC_3986 = "urn:ietf:rfc:3986";

    public static void copyElement(org.hl7.fhir.dstu3.model.Element src, Element tgt, String ... extensionsToIgnore) throws FHIRException {
        if (src.hasId()) {
            tgt.setId(src.getId());
        }
        for (org.hl7.fhir.dstu3.model.Extension e : src.getExtension()) {
            if (VersionConvertor_30_40.isExemptExtension(e.getUrl(), extensionsToIgnore)) continue;
            tgt.addExtension(VersionConvertor_30_40.convertExtension(e));
        }
    }

    public static void copyElement(Element src, org.hl7.fhir.dstu3.model.Element tgt, String ... extensionsToIgnore) throws FHIRException {
        if (src.hasId()) {
            tgt.setId(src.getId());
        }
        for (Extension e : src.getExtension()) {
            if (VersionConvertor_30_40.isExemptExtension(e.getUrl(), extensionsToIgnore)) continue;
            tgt.addExtension(VersionConvertor_30_40.convertExtension(e));
        }
    }

    public static void copyBackboneElement(org.hl7.fhir.dstu3.model.BackboneElement src, BackboneElement tgt) throws FHIRException {
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        for (org.hl7.fhir.dstu3.model.Extension e : src.getModifierExtension()) {
            tgt.addModifierExtension(VersionConvertor_30_40.convertExtension(e));
        }
    }

    public static void copyBackboneElement(BackboneElement src, org.hl7.fhir.dstu3.model.BackboneElement tgt) throws FHIRException {
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        for (Extension e : src.getModifierExtension()) {
            tgt.addModifierExtension(VersionConvertor_30_40.convertExtension(e));
        }
    }

    public static Base64BinaryType convertBase64Binary(org.hl7.fhir.dstu3.model.Base64BinaryType src) throws FHIRException {
        Base64BinaryType tgt = src.hasValue() ? new Base64BinaryType(src.getValue()) : new Base64BinaryType();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Base64BinaryType convertBase64Binary(Base64BinaryType src) throws FHIRException {
        org.hl7.fhir.dstu3.model.Base64BinaryType tgt = src.hasValue() ? new org.hl7.fhir.dstu3.model.Base64BinaryType(src.getValue()) : new org.hl7.fhir.dstu3.model.Base64BinaryType();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.r4.model.BooleanType convertBoolean(BooleanType src) throws FHIRException {
        org.hl7.fhir.r4.model.BooleanType tgt = src.hasValue() ? new org.hl7.fhir.r4.model.BooleanType((Boolean)src.getValue()) : new org.hl7.fhir.r4.model.BooleanType();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static BooleanType convertBoolean(org.hl7.fhir.r4.model.BooleanType src) throws FHIRException {
        BooleanType tgt = src.hasValue() ? new BooleanType((Boolean)src.getValue()) : new BooleanType();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.r4.model.CodeType convertCode(CodeType src) throws FHIRException {
        org.hl7.fhir.r4.model.CodeType tgt = src.hasValue() ? new org.hl7.fhir.r4.model.CodeType((String)src.getValue()) : new org.hl7.fhir.r4.model.CodeType();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static CodeType convertCode(org.hl7.fhir.r4.model.CodeType src) throws FHIRException {
        CodeType tgt = src.hasValue() ? new CodeType((String)src.getValue()) : new CodeType();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static DateType convertDate(org.hl7.fhir.dstu3.model.DateType src) throws FHIRException {
        DateType tgt = src.hasValue() ? new DateType(src.getValueAsString()) : new DateType();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static DateTimeType convertDateToDateTime(org.hl7.fhir.dstu3.model.DateType src) throws FHIRException {
        DateTimeType tgt = src.hasValue() ? new DateTimeType(src.getValueAsString()) : new DateTimeType();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.DateType convertDateTimeToDate(DateTimeType src) throws FHIRException {
        org.hl7.fhir.dstu3.model.DateType tgt = src.hasValue() ? new org.hl7.fhir.dstu3.model.DateType(src.getValueAsString()) : new org.hl7.fhir.dstu3.model.DateType();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.DateType convertDate(DateType src) throws FHIRException {
        org.hl7.fhir.dstu3.model.DateType tgt = src.hasValue() ? new org.hl7.fhir.dstu3.model.DateType(src.getValueAsString()) : new org.hl7.fhir.dstu3.model.DateType();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static DateTimeType convertDateTime(org.hl7.fhir.dstu3.model.DateTimeType src) throws FHIRException {
        DateTimeType tgt = src.hasValue() ? new DateTimeType(src.getValueAsString()) : new DateTimeType();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.DateTimeType convertDateTime(DateTimeType src) throws FHIRException {
        org.hl7.fhir.dstu3.model.DateTimeType tgt = src.hasValue() ? new org.hl7.fhir.dstu3.model.DateTimeType(src.getValueAsString()) : new org.hl7.fhir.dstu3.model.DateTimeType();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static DecimalType convertDecimal(org.hl7.fhir.dstu3.model.DecimalType src) throws FHIRException {
        DecimalType tgt = src.hasValue() ? new DecimalType((BigDecimal)src.getValue()) : new DecimalType();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.DecimalType convertDecimal(DecimalType src) throws FHIRException {
        org.hl7.fhir.dstu3.model.DecimalType tgt = src.hasValue() ? new org.hl7.fhir.dstu3.model.DecimalType((BigDecimal)src.getValue()) : new org.hl7.fhir.dstu3.model.DecimalType();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static IdType convertId(org.hl7.fhir.dstu3.model.IdType src) throws FHIRException {
        IdType tgt = src.hasValue() ? new IdType(src.getValue()) : new IdType();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.IdType convertId(IdType src) throws FHIRException {
        org.hl7.fhir.dstu3.model.IdType tgt = src.hasValue() ? new org.hl7.fhir.dstu3.model.IdType(src.getValue()) : new org.hl7.fhir.dstu3.model.IdType();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static InstantType convertInstant(org.hl7.fhir.dstu3.model.InstantType src) throws FHIRException {
        InstantType tgt = src.hasValue() ? new InstantType(src.getValueAsString()) : new InstantType();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.InstantType convertInstant(InstantType src) throws FHIRException {
        org.hl7.fhir.dstu3.model.InstantType tgt = src.hasValue() ? new org.hl7.fhir.dstu3.model.InstantType(src.getValueAsString()) : new org.hl7.fhir.dstu3.model.InstantType();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.r4.model.IntegerType convertInteger(IntegerType src) throws FHIRException {
        org.hl7.fhir.r4.model.IntegerType tgt = src.hasValue() ? new org.hl7.fhir.r4.model.IntegerType((Integer)src.getValue()) : new org.hl7.fhir.r4.model.IntegerType();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static IntegerType convertInteger(org.hl7.fhir.r4.model.IntegerType src) throws FHIRException {
        IntegerType tgt = src.hasValue() ? new IntegerType((Integer)src.getValue()) : new IntegerType();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.r4.model.MarkdownType convertMarkdown(MarkdownType src) throws FHIRException {
        org.hl7.fhir.r4.model.MarkdownType tgt = src.hasValue() ? new org.hl7.fhir.r4.model.MarkdownType((String)src.getValue()) : new org.hl7.fhir.r4.model.MarkdownType();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static MarkdownType convertMarkdown(org.hl7.fhir.r4.model.MarkdownType src) throws FHIRException {
        MarkdownType tgt = src.hasValue() ? new MarkdownType((String)src.getValue()) : new MarkdownType();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.r4.model.OidType convertOid(OidType src) throws FHIRException {
        org.hl7.fhir.r4.model.OidType tgt = src.hasValue() ? new org.hl7.fhir.r4.model.OidType((String)src.getValue()) : new org.hl7.fhir.r4.model.OidType();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static OidType convertOid(org.hl7.fhir.r4.model.OidType src) throws FHIRException {
        OidType tgt = src.hasValue() ? new OidType((String)src.getValue()) : new OidType();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static PositiveIntType convertPositiveInt(org.hl7.fhir.dstu3.model.PositiveIntType src) throws FHIRException {
        PositiveIntType tgt = src.hasValue() ? new PositiveIntType((Integer)src.getValue()) : new PositiveIntType();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.PositiveIntType convertPositiveInt(PositiveIntType src) throws FHIRException {
        org.hl7.fhir.dstu3.model.PositiveIntType tgt = src.hasValue() ? new org.hl7.fhir.dstu3.model.PositiveIntType((Integer)src.getValue()) : new org.hl7.fhir.dstu3.model.PositiveIntType();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static StringType convertString(org.hl7.fhir.dstu3.model.StringType src) throws FHIRException {
        StringType tgt = src.hasValue() ? new StringType((String)src.getValue()) : new StringType();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.StringType convertString(StringType src) throws FHIRException {
        org.hl7.fhir.dstu3.model.StringType tgt = src.hasValue() ? new org.hl7.fhir.dstu3.model.StringType((String)src.getValue()) : new org.hl7.fhir.dstu3.model.StringType();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static TimeType convertTime(org.hl7.fhir.dstu3.model.TimeType src) throws FHIRException {
        TimeType tgt = src.hasValue() ? new TimeType((String)src.getValue()) : new TimeType();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.TimeType convertTime(TimeType src) throws FHIRException {
        org.hl7.fhir.dstu3.model.TimeType tgt = src.hasValue() ? new org.hl7.fhir.dstu3.model.TimeType((String)src.getValue()) : new org.hl7.fhir.dstu3.model.TimeType();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static UnsignedIntType convertUnsignedInt(org.hl7.fhir.dstu3.model.UnsignedIntType src) throws FHIRException {
        UnsignedIntType tgt = src.hasValue() ? new UnsignedIntType((Integer)src.getValue()) : new UnsignedIntType();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.UnsignedIntType convertUnsignedInt(UnsignedIntType src) throws FHIRException {
        org.hl7.fhir.dstu3.model.UnsignedIntType tgt = src.hasValue() ? new org.hl7.fhir.dstu3.model.UnsignedIntType((Integer)src.getValue()) : new org.hl7.fhir.dstu3.model.UnsignedIntType();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.r4.model.UriType convertUri(UriType src) throws FHIRException {
        org.hl7.fhir.r4.model.UriType tgt = src.hasValue() ? new org.hl7.fhir.r4.model.UriType((String)src.getValue()) : new org.hl7.fhir.r4.model.UriType();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static UriType convertUri(org.hl7.fhir.r4.model.UriType src) throws FHIRException {
        UriType tgt = src.hasValue() ? new UriType((String)src.getValue()) : new UriType();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.r4.model.UuidType convertUuid(UuidType src) throws FHIRException {
        org.hl7.fhir.r4.model.UuidType tgt = src.hasValue() ? new org.hl7.fhir.r4.model.UuidType((String)src.getValue()) : new org.hl7.fhir.r4.model.UuidType();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static UuidType convertUuid(org.hl7.fhir.r4.model.UuidType src) throws FHIRException {
        UuidType tgt = src.hasValue() ? new UuidType((String)src.getValue()) : new UuidType();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static Extension convertExtension(org.hl7.fhir.dstu3.model.Extension src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Extension tgt = new Extension();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_30_40.convertUri(src.getUrlElement()));
        }
        if (src.hasValue()) {
            if (CANONICAL_URLS.contains(src.getUrl()) && src.getValue() instanceof org.hl7.fhir.dstu3.model.Reference) {
                tgt.setValue(VersionConvertor_30_40.convertReferenceToCanonical((org.hl7.fhir.dstu3.model.Reference)src.getValue()));
            } else {
                tgt.setValue(VersionConvertor_30_40.convertType(src.getValue()));
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Extension convertExtension(Extension src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Extension tgt = new org.hl7.fhir.dstu3.model.Extension();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_30_40.convertUri(src.getUrlElement()));
        }
        if (src.hasValue()) {
            if (CANONICAL_URLS.contains(src.getUrl()) && src.getValue() instanceof CanonicalType) {
                tgt.setValue(VersionConvertor_30_40.convertCanonicalToReference((CanonicalType)src.getValue()));
            } else {
                tgt.setValue(VersionConvertor_30_40.convertType(src.getValue()));
            }
        }
        return tgt;
    }

    public static Narrative convertNarrative(org.hl7.fhir.dstu3.model.Narrative src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Narrative tgt = new Narrative();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasStatus()) {
            tgt.setStatusElement(VersionConvertor_30_40.convertNarrativeStatus(src.getStatusElement()));
        }
        if (src.hasDiv()) {
            tgt.setDiv(src.getDiv());
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Narrative convertNarrative(Narrative src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Narrative tgt = new org.hl7.fhir.dstu3.model.Narrative();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasStatus()) {
            tgt.setStatusElement(VersionConvertor_30_40.convertNarrativeStatus(src.getStatusElement()));
        }
        if (src.hasDiv()) {
            tgt.setDiv(src.getDiv());
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Enumeration<Narrative.NarrativeStatus> convertNarrativeStatus(Enumeration<Narrative.NarrativeStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Enumeration<Narrative.NarrativeStatus> tgt = new org.hl7.fhir.r4.model.Enumeration<Narrative.NarrativeStatus>(new Narrative.NarrativeStatusEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((Narrative.NarrativeStatus)((Object)src.getValue())) {
            case GENERATED: {
                tgt.setValue((Object)Narrative.NarrativeStatus.GENERATED);
                break;
            }
            case EXTENSIONS: {
                tgt.setValue((Object)Narrative.NarrativeStatus.EXTENSIONS);
                break;
            }
            case ADDITIONAL: {
                tgt.setValue((Object)Narrative.NarrativeStatus.ADDITIONAL);
                break;
            }
            case EMPTY: {
                tgt.setValue((Object)Narrative.NarrativeStatus.EMPTY);
                break;
            }
            default: {
                tgt.setValue((Object)Narrative.NarrativeStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Narrative.NarrativeStatus> convertNarrativeStatus(org.hl7.fhir.r4.model.Enumeration<Narrative.NarrativeStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Narrative.NarrativeStatus> tgt = new Enumeration<Narrative.NarrativeStatus>(new Narrative.NarrativeStatusEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((Narrative.NarrativeStatus)((Object)src.getValue())) {
            case GENERATED: {
                tgt.setValue((Object)Narrative.NarrativeStatus.GENERATED);
                break;
            }
            case EXTENSIONS: {
                tgt.setValue((Object)Narrative.NarrativeStatus.EXTENSIONS);
                break;
            }
            case ADDITIONAL: {
                tgt.setValue((Object)Narrative.NarrativeStatus.ADDITIONAL);
                break;
            }
            case EMPTY: {
                tgt.setValue((Object)Narrative.NarrativeStatus.EMPTY);
                break;
            }
            default: {
                tgt.setValue((Object)Narrative.NarrativeStatus.NULL);
            }
        }
        return tgt;
    }

    public static Age convertAge(org.hl7.fhir.dstu3.model.Age src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Age tgt = new Age();
        VersionConvertor_30_40.copyQuantity(src, tgt);
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Age convertAge(Age src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Age tgt = new org.hl7.fhir.dstu3.model.Age();
        VersionConvertor_30_40.copyQuantity(src, tgt);
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Annotation convertAnnotation(Annotation src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.Annotation tgt = new org.hl7.fhir.r4.model.Annotation();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasAuthor()) {
            tgt.setAuthor(VersionConvertor_30_40.convertType(src.getAuthor()));
        }
        if (src.hasTime()) {
            tgt.setTimeElement(VersionConvertor_30_40.convertDateTime(src.getTimeElement()));
        }
        if (src.hasText()) {
            tgt.setText(src.getText());
        }
        return tgt;
    }

    public static Annotation convertAnnotation(org.hl7.fhir.r4.model.Annotation src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Annotation tgt = new Annotation();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasAuthor()) {
            tgt.setAuthor(VersionConvertor_30_40.convertType(src.getAuthor()));
        }
        if (src.hasTime()) {
            tgt.setTimeElement(VersionConvertor_30_40.convertDateTime(src.getTimeElement()));
        }
        if (src.hasText()) {
            tgt.setText(src.getText());
        }
        return tgt;
    }

    public static Attachment convertAttachment(org.hl7.fhir.dstu3.model.Attachment src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Attachment tgt = new Attachment();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasContentType()) {
            tgt.setContentTypeElement(VersionConvertor_30_40.convertCode(src.getContentTypeElement()));
        }
        if (src.hasLanguage()) {
            tgt.setLanguageElement(VersionConvertor_30_40.convertCode(src.getLanguageElement()));
        }
        if (src.hasData()) {
            tgt.setDataElement(VersionConvertor_30_40.convertBase64Binary(src.getDataElement()));
        }
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        if (src.hasSize()) {
            tgt.setSizeElement(VersionConvertor_30_40.convertUnsignedInt(src.getSizeElement()));
        }
        if (src.hasHash()) {
            tgt.setHashElement(VersionConvertor_30_40.convertBase64Binary(src.getHashElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(VersionConvertor_30_40.convertString(src.getTitleElement()));
        }
        if (src.hasCreation()) {
            tgt.setCreationElement(VersionConvertor_30_40.convertDateTime(src.getCreationElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Attachment convertAttachment(Attachment src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Attachment tgt = new org.hl7.fhir.dstu3.model.Attachment();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasContentType()) {
            tgt.setContentTypeElement(VersionConvertor_30_40.convertCode(src.getContentTypeElement()));
        }
        if (src.hasLanguage()) {
            tgt.setLanguageElement(VersionConvertor_30_40.convertCode(src.getLanguageElement()));
        }
        if (src.hasData()) {
            tgt.setDataElement(VersionConvertor_30_40.convertBase64Binary(src.getDataElement()));
        }
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        if (src.hasSize()) {
            tgt.setSizeElement(VersionConvertor_30_40.convertUnsignedInt(src.getSizeElement()));
        }
        if (src.hasHash()) {
            tgt.setHashElement(VersionConvertor_30_40.convertBase64Binary(src.getHashElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(VersionConvertor_30_40.convertString(src.getTitleElement()));
        }
        if (src.hasCreation()) {
            tgt.setCreationElement(VersionConvertor_30_40.convertDateTime(src.getCreationElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.CodeableConcept convertCodeableConcept(CodeableConcept src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.CodeableConcept tgt = new org.hl7.fhir.r4.model.CodeableConcept();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        for (Coding t : src.getCoding()) {
            tgt.addCoding(VersionConvertor_30_40.convertCoding(t));
        }
        if (src.hasText()) {
            tgt.setTextElement(VersionConvertor_30_40.convertString(src.getTextElement()));
        }
        return tgt;
    }

    public static CodeableConcept convertCodeableConcept(org.hl7.fhir.r4.model.CodeableConcept src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CodeableConcept tgt = new CodeableConcept();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        for (org.hl7.fhir.r4.model.Coding t : src.getCoding()) {
            tgt.addCoding(VersionConvertor_30_40.convertCoding(t));
        }
        if (src.hasText()) {
            tgt.setTextElement(VersionConvertor_30_40.convertString(src.getTextElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Coding convertCoding(Coding src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.Coding tgt = new org.hl7.fhir.r4.model.Coding();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_30_40.convertUri(src.getSystemElement()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_30_40.convertString(src.getVersionElement()));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_30_40.convertCode(src.getCodeElement()));
        }
        if (src.hasDisplay()) {
            tgt.setDisplayElement(VersionConvertor_30_40.convertString(src.getDisplayElement()));
        }
        if (src.hasUserSelected()) {
            tgt.setUserSelectedElement(VersionConvertor_30_40.convertBoolean(src.getUserSelectedElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Coding convertCoding(CodeType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.Coding tgt = new org.hl7.fhir.r4.model.Coding();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        tgt.setCode((String)src.getValue());
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Coding convertCoding(CodeableConcept src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.Coding tgt = new org.hl7.fhir.r4.model.Coding();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasCoding()) {
            if (src.getCodingFirstRep().hasSystem()) {
                tgt.setSystem(src.getCodingFirstRep().getSystem());
            }
            if (src.getCodingFirstRep().hasVersion()) {
                tgt.setVersion(src.getCodingFirstRep().getVersion());
            }
            if (src.getCodingFirstRep().hasCode()) {
                tgt.setCode(src.getCodingFirstRep().getCode());
            }
            if (src.getCodingFirstRep().hasDisplay()) {
                tgt.setDisplay(src.getCodingFirstRep().getDisplay());
            }
            if (src.getCodingFirstRep().hasUserSelected()) {
                tgt.setUserSelected(src.getCodingFirstRep().getUserSelected());
            }
        }
        return tgt;
    }

    public static Coding convertCoding(org.hl7.fhir.r4.model.CodeableConcept src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Coding tgt = new Coding();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasCoding()) {
            if (src.getCodingFirstRep().hasSystem()) {
                tgt.setSystem(src.getCodingFirstRep().getSystem());
            }
            if (src.getCodingFirstRep().hasVersion()) {
                tgt.setVersion(src.getCodingFirstRep().getVersion());
            }
            if (src.getCodingFirstRep().hasCode()) {
                tgt.setCode(src.getCodingFirstRep().getCode());
            }
            if (src.getCodingFirstRep().hasDisplay()) {
                tgt.setDisplay(src.getCodingFirstRep().getDisplay());
            }
            if (src.getCodingFirstRep().hasUserSelected()) {
                tgt.setUserSelected(src.getCodingFirstRep().getUserSelected());
            }
        }
        return tgt;
    }

    public static Coding convertCoding(org.hl7.fhir.r4.model.Coding src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Coding tgt = new Coding();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_30_40.convertUri(src.getSystemElement()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_30_40.convertString(src.getVersionElement()));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_30_40.convertCode(src.getCodeElement()));
        }
        if (src.hasDisplay()) {
            tgt.setDisplayElement(VersionConvertor_30_40.convertString(src.getDisplayElement()));
        }
        if (src.hasUserSelected()) {
            tgt.setUserSelectedElement(VersionConvertor_30_40.convertBoolean(src.getUserSelectedElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Count convertCount(Count src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.Count tgt = new org.hl7.fhir.r4.model.Count();
        VersionConvertor_30_40.copyQuantity(src, tgt);
        return tgt;
    }

    public static Count convertCount(org.hl7.fhir.r4.model.Count src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Count tgt = new Count();
        VersionConvertor_30_40.copyQuantity(src, tgt);
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Distance convertDistance(Distance src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.Distance tgt = new org.hl7.fhir.r4.model.Distance();
        VersionConvertor_30_40.copyQuantity(src, tgt);
        return tgt;
    }

    public static Distance convertDistance(org.hl7.fhir.r4.model.Distance src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Distance tgt = new Distance();
        VersionConvertor_30_40.copyQuantity(src, tgt);
        return tgt;
    }

    public static Duration convertDuration(org.hl7.fhir.dstu3.model.Duration src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Duration tgt = new Duration();
        VersionConvertor_30_40.copyQuantity(src, tgt);
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Duration convertDuration(Duration src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Duration tgt = new org.hl7.fhir.dstu3.model.Duration();
        VersionConvertor_30_40.copyQuantity(src, tgt);
        return tgt;
    }

    public static Identifier convertIdentifier(org.hl7.fhir.dstu3.model.Identifier src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Identifier tgt = new Identifier();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasUse()) {
            tgt.setUseElement(VersionConvertor_30_40.convertIdentifierUse(src.getUseElement()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertCodeableConcept(src.getType()));
        }
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_30_40.convertUri(src.getSystemElement()));
        }
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_30_40.convertString(src.getValueElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_40.convertPeriod(src.getPeriod()));
        }
        if (src.hasAssigner()) {
            tgt.setAssigner(VersionConvertor_30_40.convertReference(src.getAssigner()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Identifier convertIdentifier(Identifier src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Identifier tgt = new org.hl7.fhir.dstu3.model.Identifier();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasUse()) {
            tgt.setUseElement(VersionConvertor_30_40.convertIdentifierUse(src.getUseElement()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertCodeableConcept(src.getType()));
        }
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_30_40.convertUri(src.getSystemElement()));
        }
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_30_40.convertString(src.getValueElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_40.convertPeriod(src.getPeriod()));
        }
        if (src.hasAssigner()) {
            tgt.setAssigner(VersionConvertor_30_40.convertReference(src.getAssigner()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Enumeration<Identifier.IdentifierUse> convertIdentifierUse(Enumeration<Identifier.IdentifierUse> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Enumeration<Identifier.IdentifierUse> tgt = new org.hl7.fhir.r4.model.Enumeration<Identifier.IdentifierUse>(new Identifier.IdentifierUseEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((Identifier.IdentifierUse)((Object)src.getValue())) {
            case USUAL: {
                tgt.setValue((Object)Identifier.IdentifierUse.USUAL);
                break;
            }
            case OFFICIAL: {
                tgt.setValue((Object)Identifier.IdentifierUse.OFFICIAL);
                break;
            }
            case TEMP: {
                tgt.setValue((Object)Identifier.IdentifierUse.TEMP);
                break;
            }
            case SECONDARY: {
                tgt.setValue((Object)Identifier.IdentifierUse.SECONDARY);
                break;
            }
            default: {
                tgt.setValue((Object)Identifier.IdentifierUse.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Identifier.IdentifierUse> convertIdentifierUse(org.hl7.fhir.r4.model.Enumeration<Identifier.IdentifierUse> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Identifier.IdentifierUse> tgt = new Enumeration<Identifier.IdentifierUse>(new Identifier.IdentifierUseEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((Identifier.IdentifierUse)((Object)src.getValue())) {
            case USUAL: {
                tgt.setValue((Object)Identifier.IdentifierUse.USUAL);
                break;
            }
            case OFFICIAL: {
                tgt.setValue((Object)Identifier.IdentifierUse.OFFICIAL);
                break;
            }
            case TEMP: {
                tgt.setValue((Object)Identifier.IdentifierUse.TEMP);
                break;
            }
            case SECONDARY: {
                tgt.setValue((Object)Identifier.IdentifierUse.SECONDARY);
                break;
            }
            default: {
                tgt.setValue((Object)Identifier.IdentifierUse.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Money convertMoney(Money src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.Money tgt = new org.hl7.fhir.r4.model.Money();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_30_40.convertDecimal(src.getValueElement()));
        }
        if (src.hasCode()) {
            tgt.setCurrencyElement(VersionConvertor_30_40.convertCode(src.getCodeElement()));
        }
        return tgt;
    }

    public static Money convertMoney(org.hl7.fhir.r4.model.Money src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Money tgt = new Money();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_30_40.convertDecimal(src.getValueElement()));
        }
        if (src.hasCurrency()) {
            tgt.setCodeElement(VersionConvertor_30_40.convertCode(src.getCurrencyElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Period convertPeriod(Period src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.Period tgt = new org.hl7.fhir.r4.model.Period();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasStart()) {
            tgt.setStartElement(VersionConvertor_30_40.convertDateTime(src.getStartElement()));
        }
        if (src.hasEnd()) {
            tgt.setEndElement(VersionConvertor_30_40.convertDateTime(src.getEndElement()));
        }
        return tgt;
    }

    public static Period convertPeriod(org.hl7.fhir.r4.model.Period src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Period tgt = new Period();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasStart()) {
            tgt.setStartElement(VersionConvertor_30_40.convertDateTime(src.getStartElement()));
        }
        if (src.hasEnd()) {
            tgt.setEndElement(VersionConvertor_30_40.convertDateTime(src.getEndElement()));
        }
        return tgt;
    }

    public static void copyQuantity(org.hl7.fhir.dstu3.model.Quantity src, Quantity tgt) throws FHIRException {
        if (src == null || tgt == null) {
            return;
        }
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        if (src.hasComparator()) {
            tgt.setComparatorElement(VersionConvertor_30_40.convertQuantityComparator(src.getComparatorElement()));
        }
        if (src.hasUnit()) {
            tgt.setUnit(src.getUnit());
        }
        if (src.hasSystem()) {
            tgt.setSystem(src.getSystem());
        }
        if (src.hasCode()) {
            tgt.setCode(src.getCode());
        }
    }

    public static void copyQuantity(Quantity src, org.hl7.fhir.dstu3.model.Quantity tgt) throws FHIRException {
        if (src == null || tgt == null) {
            return;
        }
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        if (src.hasComparator()) {
            tgt.setComparatorElement(VersionConvertor_30_40.convertQuantityComparator(src.getComparatorElement()));
        }
        if (src.hasUnit()) {
            tgt.setUnit(src.getUnit());
        }
        if (src.hasSystem()) {
            tgt.setSystem(src.getSystem());
        }
        if (src.hasCode()) {
            tgt.setCode(src.getCode());
        }
    }

    public static Quantity convertQuantity(org.hl7.fhir.dstu3.model.Quantity src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Quantity tgt = new Quantity();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_30_40.convertDecimal(src.getValueElement()));
        }
        if (src.hasComparator()) {
            tgt.setComparatorElement(VersionConvertor_30_40.convertQuantityComparator(src.getComparatorElement()));
        }
        if (src.hasUnit()) {
            tgt.setUnitElement(VersionConvertor_30_40.convertString(src.getUnitElement()));
        }
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_30_40.convertUri(src.getSystemElement()));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_30_40.convertCode(src.getCodeElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Quantity convertQuantity(Quantity src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Quantity tgt = new org.hl7.fhir.dstu3.model.Quantity();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_30_40.convertDecimal(src.getValueElement()));
        }
        if (src.hasComparator()) {
            tgt.setComparatorElement(VersionConvertor_30_40.convertQuantityComparator(src.getComparatorElement()));
        }
        if (src.hasUnit()) {
            tgt.setUnitElement(VersionConvertor_30_40.convertString(src.getUnitElement()));
        }
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_30_40.convertUri(src.getSystemElement()));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_30_40.convertCode(src.getCodeElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Enumeration<Quantity.QuantityComparator> convertQuantityComparator(Enumeration<Quantity.QuantityComparator> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Enumeration<Quantity.QuantityComparator> tgt = new org.hl7.fhir.r4.model.Enumeration<Quantity.QuantityComparator>(new Quantity.QuantityComparatorEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((Quantity.QuantityComparator)((Object)src.getValue())) {
            case LESS_THAN: {
                tgt.setValue((Object)Quantity.QuantityComparator.LESS_THAN);
                break;
            }
            case LESS_OR_EQUAL: {
                tgt.setValue((Object)Quantity.QuantityComparator.LESS_OR_EQUAL);
                break;
            }
            case GREATER_OR_EQUAL: {
                tgt.setValue((Object)Quantity.QuantityComparator.GREATER_OR_EQUAL);
                break;
            }
            case GREATER_THAN: {
                tgt.setValue((Object)Quantity.QuantityComparator.GREATER_THAN);
                break;
            }
            default: {
                tgt.setValue((Object)Quantity.QuantityComparator.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Quantity.QuantityComparator> convertQuantityComparator(org.hl7.fhir.r4.model.Enumeration<Quantity.QuantityComparator> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Quantity.QuantityComparator> tgt = new Enumeration<Quantity.QuantityComparator>(new Quantity.QuantityComparatorEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((Quantity.QuantityComparator)((Object)src.getValue())) {
            case LESS_THAN: {
                tgt.setValue((Object)Quantity.QuantityComparator.LESS_THAN);
                break;
            }
            case LESS_OR_EQUAL: {
                tgt.setValue((Object)Quantity.QuantityComparator.LESS_OR_EQUAL);
                break;
            }
            case GREATER_OR_EQUAL: {
                tgt.setValue((Object)Quantity.QuantityComparator.GREATER_OR_EQUAL);
                break;
            }
            case GREATER_THAN: {
                tgt.setValue((Object)Quantity.QuantityComparator.GREATER_THAN);
                break;
            }
            default: {
                tgt.setValue((Object)Quantity.QuantityComparator.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Range convertRange(Range src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.Range tgt = new org.hl7.fhir.r4.model.Range();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasLow()) {
            tgt.setLow(VersionConvertor_30_40.convertSimpleQuantity(src.getLow()));
        }
        if (src.hasHigh()) {
            tgt.setHigh(VersionConvertor_30_40.convertSimpleQuantity(src.getHigh()));
        }
        return tgt;
    }

    public static Range convertRange(org.hl7.fhir.r4.model.Range src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Range tgt = new Range();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasLow()) {
            tgt.setLow(VersionConvertor_30_40.convertSimpleQuantity(src.getLow()));
        }
        if (src.hasHigh()) {
            tgt.setHigh(VersionConvertor_30_40.convertSimpleQuantity(src.getHigh()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Ratio convertRatio(Ratio src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.Ratio tgt = new org.hl7.fhir.r4.model.Ratio();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasNumerator()) {
            tgt.setNumerator(VersionConvertor_30_40.convertQuantity(src.getNumerator()));
        }
        if (src.hasDenominator()) {
            tgt.setDenominator(VersionConvertor_30_40.convertQuantity(src.getDenominator()));
        }
        return tgt;
    }

    public static Ratio convertRatio(org.hl7.fhir.r4.model.Ratio src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Ratio tgt = new Ratio();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasNumerator()) {
            tgt.setNumerator(VersionConvertor_30_40.convertQuantity(src.getNumerator()));
        }
        if (src.hasDenominator()) {
            tgt.setDenominator(VersionConvertor_30_40.convertQuantity(src.getDenominator()));
        }
        return tgt;
    }

    public static Reference convertReference(org.hl7.fhir.dstu3.model.Reference src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Reference tgt = new Reference();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasReference()) {
            tgt.setReference(src.getReference());
        }
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_30_40.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasDisplay()) {
            tgt.setDisplayElement(VersionConvertor_30_40.convertString(src.getDisplayElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Reference convertReference(Reference src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Reference tgt = new org.hl7.fhir.dstu3.model.Reference();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasReference()) {
            tgt.setReference(src.getReference());
        }
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_30_40.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasDisplay()) {
            tgt.setDisplayElement(VersionConvertor_30_40.convertString(src.getDisplayElement()));
        }
        return tgt;
    }

    public static SampledData convertSampledData(org.hl7.fhir.dstu3.model.SampledData src) throws FHIRException {
        if (src == null) {
            return null;
        }
        SampledData tgt = new SampledData();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasOrigin()) {
            tgt.setOrigin(VersionConvertor_30_40.convertSimpleQuantity(src.getOrigin()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriodElement(VersionConvertor_30_40.convertDecimal(src.getPeriodElement()));
        }
        if (src.hasFactor()) {
            tgt.setFactorElement(VersionConvertor_30_40.convertDecimal(src.getFactorElement()));
        }
        if (src.hasLowerLimit()) {
            tgt.setLowerLimitElement(VersionConvertor_30_40.convertDecimal(src.getLowerLimitElement()));
        }
        if (src.hasUpperLimit()) {
            tgt.setUpperLimitElement(VersionConvertor_30_40.convertDecimal(src.getUpperLimitElement()));
        }
        if (src.hasDimensions()) {
            tgt.setDimensionsElement(VersionConvertor_30_40.convertPositiveInt(src.getDimensionsElement()));
        }
        if (src.hasData()) {
            tgt.setDataElement(VersionConvertor_30_40.convertString(src.getDataElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.SampledData convertSampledData(SampledData src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.SampledData tgt = new org.hl7.fhir.dstu3.model.SampledData();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasOrigin()) {
            tgt.setOrigin(VersionConvertor_30_40.convertSimpleQuantity(src.getOrigin()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriodElement(VersionConvertor_30_40.convertDecimal(src.getPeriodElement()));
        }
        if (src.hasFactor()) {
            tgt.setFactorElement(VersionConvertor_30_40.convertDecimal(src.getFactorElement()));
        }
        if (src.hasLowerLimit()) {
            tgt.setLowerLimitElement(VersionConvertor_30_40.convertDecimal(src.getLowerLimitElement()));
        }
        if (src.hasUpperLimit()) {
            tgt.setUpperLimitElement(VersionConvertor_30_40.convertDecimal(src.getUpperLimitElement()));
        }
        if (src.hasDimensions()) {
            tgt.setDimensionsElement(VersionConvertor_30_40.convertPositiveInt(src.getDimensionsElement()));
        }
        if (src.hasData()) {
            tgt.setDataElement(VersionConvertor_30_40.convertString(src.getDataElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Signature convertSignature(Signature src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.Signature tgt = new org.hl7.fhir.r4.model.Signature();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        for (Coding t : src.getType()) {
            tgt.addType(VersionConvertor_30_40.convertCoding(t));
        }
        if (src.hasWhen()) {
            tgt.setWhenElement(VersionConvertor_30_40.convertInstant(src.getWhenElement()));
        }
        if (src.hasWho()) {
            if (src.hasWhoUriType()) {
                tgt.setWho(new Reference((String)src.getWhoUriType().getValue()));
            } else {
                tgt.setWho(VersionConvertor_30_40.convertReference(src.getWhoReference()));
            }
        }
        if (src.hasOnBehalfOf()) {
            if (src.hasOnBehalfOfUriType()) {
                tgt.setOnBehalfOf(new Reference(src.getOnBehalfOfUriType().primitiveValue()));
            } else {
                tgt.setOnBehalfOf(VersionConvertor_30_40.convertReference(src.getOnBehalfOfReference()));
            }
        }
        if (src.hasContentType()) {
            tgt.setSigFormatElement(VersionConvertor_30_40.convertCode(src.getContentTypeElement()));
        }
        if (src.hasBlob()) {
            tgt.setDataElement(VersionConvertor_30_40.convertBase64Binary(src.getBlobElement()));
        }
        return tgt;
    }

    public static Signature convertSignature(org.hl7.fhir.r4.model.Signature src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Signature tgt = new Signature();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        for (org.hl7.fhir.r4.model.Coding t : src.getType()) {
            tgt.addType(VersionConvertor_30_40.convertCoding(t));
        }
        if (src.hasWhen()) {
            tgt.setWhenElement(VersionConvertor_30_40.convertInstant(src.getWhenElement()));
        }
        if (src.hasWho()) {
            tgt.setWho(VersionConvertor_30_40.convertType(src.getWho()));
        }
        if (src.hasOnBehalfOf()) {
            tgt.setOnBehalfOf(VersionConvertor_30_40.convertType(src.getOnBehalfOf()));
        }
        if (src.hasSigFormat()) {
            tgt.setContentTypeElement(VersionConvertor_30_40.convertCode(src.getSigFormatElement()));
        }
        if (src.hasData()) {
            tgt.setBlobElement(VersionConvertor_30_40.convertBase64Binary(src.getDataElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Address convertAddress(Address src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.Address tgt = new org.hl7.fhir.r4.model.Address();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasUse()) {
            tgt.setUseElement(VersionConvertor_30_40.convertAddressUse(src.getUseElement()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(VersionConvertor_30_40.convertAddressType(src.getTypeElement()));
        }
        if (src.hasText()) {
            tgt.setTextElement(VersionConvertor_30_40.convertString(src.getTextElement()));
        }
        for (org.hl7.fhir.dstu3.model.StringType t : src.getLine()) {
            tgt.addLine((String)t.getValue());
        }
        if (src.hasCity()) {
            tgt.setCityElement(VersionConvertor_30_40.convertString(src.getCityElement()));
        }
        if (src.hasDistrict()) {
            tgt.setDistrictElement(VersionConvertor_30_40.convertString(src.getDistrictElement()));
        }
        if (src.hasState()) {
            tgt.setStateElement(VersionConvertor_30_40.convertString(src.getStateElement()));
        }
        if (src.hasPostalCode()) {
            tgt.setPostalCodeElement(VersionConvertor_30_40.convertString(src.getPostalCodeElement()));
        }
        if (src.hasCountry()) {
            tgt.setCountryElement(VersionConvertor_30_40.convertString(src.getCountryElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_40.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static Address convertAddress(org.hl7.fhir.r4.model.Address src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Address tgt = new Address();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasUse()) {
            tgt.setUseElement(VersionConvertor_30_40.convertAddressUse(src.getUseElement()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(VersionConvertor_30_40.convertAddressType(src.getTypeElement()));
        }
        if (src.hasText()) {
            tgt.setTextElement(VersionConvertor_30_40.convertString(src.getTextElement()));
        }
        for (StringType t : src.getLine()) {
            tgt.addLine((String)t.getValue());
        }
        if (src.hasCity()) {
            tgt.setCityElement(VersionConvertor_30_40.convertString(src.getCityElement()));
        }
        if (src.hasDistrict()) {
            tgt.setDistrictElement(VersionConvertor_30_40.convertString(src.getDistrictElement()));
        }
        if (src.hasState()) {
            tgt.setStateElement(VersionConvertor_30_40.convertString(src.getStateElement()));
        }
        if (src.hasPostalCode()) {
            tgt.setPostalCodeElement(VersionConvertor_30_40.convertString(src.getPostalCodeElement()));
        }
        if (src.hasCountry()) {
            tgt.setCountryElement(VersionConvertor_30_40.convertString(src.getCountryElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_40.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Enumeration<Address.AddressUse> convertAddressUse(Enumeration<Address.AddressUse> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Enumeration<Address.AddressUse> tgt = new org.hl7.fhir.r4.model.Enumeration<Address.AddressUse>(new Address.AddressUseEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((Address.AddressUse)((Object)src.getValue())) {
            case HOME: {
                tgt.setValue((Object)Address.AddressUse.HOME);
                break;
            }
            case WORK: {
                tgt.setValue((Object)Address.AddressUse.WORK);
                break;
            }
            case TEMP: {
                tgt.setValue((Object)Address.AddressUse.TEMP);
                break;
            }
            case OLD: {
                tgt.setValue((Object)Address.AddressUse.OLD);
                break;
            }
            default: {
                tgt.setValue((Object)Address.AddressUse.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Address.AddressUse> convertAddressUse(org.hl7.fhir.r4.model.Enumeration<Address.AddressUse> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Address.AddressUse> tgt = new Enumeration<Address.AddressUse>(new Address.AddressUseEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((Address.AddressUse)((Object)src.getValue())) {
            case HOME: {
                tgt.setValue((Object)Address.AddressUse.HOME);
                break;
            }
            case WORK: {
                tgt.setValue((Object)Address.AddressUse.WORK);
                break;
            }
            case TEMP: {
                tgt.setValue((Object)Address.AddressUse.TEMP);
                break;
            }
            case OLD: {
                tgt.setValue((Object)Address.AddressUse.OLD);
                break;
            }
            default: {
                tgt.setValue((Object)Address.AddressUse.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Enumeration<Address.AddressType> convertAddressType(Enumeration<Address.AddressType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Enumeration<Address.AddressType> tgt = new org.hl7.fhir.r4.model.Enumeration<Address.AddressType>(new Address.AddressTypeEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((Address.AddressType)((Object)src.getValue())) {
            case POSTAL: {
                tgt.setValue((Object)Address.AddressType.POSTAL);
                break;
            }
            case PHYSICAL: {
                tgt.setValue((Object)Address.AddressType.PHYSICAL);
                break;
            }
            case BOTH: {
                tgt.setValue((Object)Address.AddressType.BOTH);
                break;
            }
            default: {
                tgt.setValue((Object)Address.AddressType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Address.AddressType> convertAddressType(org.hl7.fhir.r4.model.Enumeration<Address.AddressType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Address.AddressType> tgt = new Enumeration<Address.AddressType>(new Address.AddressTypeEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((Address.AddressType)((Object)src.getValue())) {
            case POSTAL: {
                tgt.setValue((Object)Address.AddressType.POSTAL);
                break;
            }
            case PHYSICAL: {
                tgt.setValue((Object)Address.AddressType.PHYSICAL);
                break;
            }
            case BOTH: {
                tgt.setValue((Object)Address.AddressType.BOTH);
                break;
            }
            default: {
                tgt.setValue((Object)Address.AddressType.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.ContactDetail convertContactDetail(ContactDetail src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.ContactDetail tgt = new org.hl7.fhir.r4.model.ContactDetail();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_40.convertString(src.getNameElement()));
        }
        for (org.hl7.fhir.dstu3.model.ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_30_40.convertContactPoint(t));
        }
        return tgt;
    }

    public static ContactDetail convertContactDetail(org.hl7.fhir.r4.model.ContactDetail src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ContactDetail tgt = new ContactDetail();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_40.convertString(src.getNameElement()));
        }
        for (ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_30_40.convertContactPoint(t));
        }
        return tgt;
    }

    public static ContactPoint convertContactPoint(org.hl7.fhir.dstu3.model.ContactPoint src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ContactPoint tgt = new ContactPoint();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_30_40.convertContactPointSystem(src.getSystemElement()));
        }
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_30_40.convertString(src.getValueElement()));
        }
        if (src.hasUse()) {
            tgt.setUseElement(VersionConvertor_30_40.convertContactPointUse(src.getUseElement()));
        }
        if (src.hasRank()) {
            tgt.setRankElement(VersionConvertor_30_40.convertPositiveInt(src.getRankElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_40.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.ContactPoint convertContactPoint(ContactPoint src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.ContactPoint tgt = new org.hl7.fhir.dstu3.model.ContactPoint();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_30_40.convertContactPointSystem(src.getSystemElement()));
        }
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_30_40.convertString(src.getValueElement()));
        }
        if (src.hasUse()) {
            tgt.setUseElement(VersionConvertor_30_40.convertContactPointUse(src.getUseElement()));
        }
        if (src.hasRank()) {
            tgt.setRankElement(VersionConvertor_30_40.convertPositiveInt(src.getRankElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_40.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Enumeration<ContactPoint.ContactPointSystem> convertContactPointSystem(Enumeration<ContactPoint.ContactPointSystem> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Enumeration<ContactPoint.ContactPointSystem> tgt = new org.hl7.fhir.r4.model.Enumeration<ContactPoint.ContactPointSystem>(new ContactPoint.ContactPointSystemEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((ContactPoint.ContactPointSystem)((Object)src.getValue())) {
            case PHONE: {
                tgt.setValue((Object)ContactPoint.ContactPointSystem.PHONE);
                break;
            }
            case FAX: {
                tgt.setValue((Object)ContactPoint.ContactPointSystem.FAX);
                break;
            }
            case EMAIL: {
                tgt.setValue((Object)ContactPoint.ContactPointSystem.EMAIL);
                break;
            }
            case PAGER: {
                tgt.setValue((Object)ContactPoint.ContactPointSystem.PAGER);
                break;
            }
            case URL: {
                tgt.setValue((Object)ContactPoint.ContactPointSystem.URL);
                break;
            }
            case SMS: {
                tgt.setValue((Object)ContactPoint.ContactPointSystem.SMS);
                break;
            }
            case OTHER: {
                tgt.setValue((Object)ContactPoint.ContactPointSystem.OTHER);
                break;
            }
            default: {
                tgt.setValue((Object)ContactPoint.ContactPointSystem.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<ContactPoint.ContactPointSystem> convertContactPointSystem(org.hl7.fhir.r4.model.Enumeration<ContactPoint.ContactPointSystem> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ContactPoint.ContactPointSystem> tgt = new Enumeration<ContactPoint.ContactPointSystem>(new ContactPoint.ContactPointSystemEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((ContactPoint.ContactPointSystem)((Object)src.getValue())) {
            case PHONE: {
                tgt.setValue((Object)ContactPoint.ContactPointSystem.PHONE);
                break;
            }
            case FAX: {
                tgt.setValue((Object)ContactPoint.ContactPointSystem.FAX);
                break;
            }
            case EMAIL: {
                tgt.setValue((Object)ContactPoint.ContactPointSystem.EMAIL);
                break;
            }
            case PAGER: {
                tgt.setValue((Object)ContactPoint.ContactPointSystem.PAGER);
                break;
            }
            case URL: {
                tgt.setValue((Object)ContactPoint.ContactPointSystem.URL);
                break;
            }
            case SMS: {
                tgt.setValue((Object)ContactPoint.ContactPointSystem.SMS);
                break;
            }
            case OTHER: {
                tgt.setValue((Object)ContactPoint.ContactPointSystem.OTHER);
                break;
            }
            default: {
                tgt.setValue((Object)ContactPoint.ContactPointSystem.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Enumeration<ContactPoint.ContactPointUse> convertContactPointUse(Enumeration<ContactPoint.ContactPointUse> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Enumeration<ContactPoint.ContactPointUse> tgt = new org.hl7.fhir.r4.model.Enumeration<ContactPoint.ContactPointUse>(new ContactPoint.ContactPointUseEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((ContactPoint.ContactPointUse)((Object)src.getValue())) {
            case HOME: {
                tgt.setValue((Object)ContactPoint.ContactPointUse.HOME);
                break;
            }
            case WORK: {
                tgt.setValue((Object)ContactPoint.ContactPointUse.WORK);
                break;
            }
            case TEMP: {
                tgt.setValue((Object)ContactPoint.ContactPointUse.TEMP);
                break;
            }
            case OLD: {
                tgt.setValue((Object)ContactPoint.ContactPointUse.OLD);
                break;
            }
            case MOBILE: {
                tgt.setValue((Object)ContactPoint.ContactPointUse.MOBILE);
                break;
            }
            default: {
                tgt.setValue((Object)ContactPoint.ContactPointUse.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<ContactPoint.ContactPointUse> convertContactPointUse(org.hl7.fhir.r4.model.Enumeration<ContactPoint.ContactPointUse> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ContactPoint.ContactPointUse> tgt = new Enumeration<ContactPoint.ContactPointUse>(new ContactPoint.ContactPointUseEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((ContactPoint.ContactPointUse)((Object)src.getValue())) {
            case HOME: {
                tgt.setValue((Object)ContactPoint.ContactPointUse.HOME);
                break;
            }
            case WORK: {
                tgt.setValue((Object)ContactPoint.ContactPointUse.WORK);
                break;
            }
            case TEMP: {
                tgt.setValue((Object)ContactPoint.ContactPointUse.TEMP);
                break;
            }
            case OLD: {
                tgt.setValue((Object)ContactPoint.ContactPointUse.OLD);
                break;
            }
            case MOBILE: {
                tgt.setValue((Object)ContactPoint.ContactPointUse.MOBILE);
                break;
            }
            default: {
                tgt.setValue((Object)ContactPoint.ContactPointUse.NULL);
            }
        }
        return tgt;
    }

    public static Contributor convertContributor(org.hl7.fhir.dstu3.model.Contributor src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Contributor tgt = new Contributor();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(VersionConvertor_30_40.convertContributorType(src.getTypeElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_40.convertString(src.getNameElement()));
        }
        for (ContactDetail t : src.getContact()) {
            tgt.addContact(VersionConvertor_30_40.convertContactDetail(t));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Contributor convertContributor(Contributor src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Contributor tgt = new org.hl7.fhir.dstu3.model.Contributor();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(VersionConvertor_30_40.convertContributorType(src.getTypeElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_40.convertString(src.getNameElement()));
        }
        for (org.hl7.fhir.r4.model.ContactDetail t : src.getContact()) {
            tgt.addContact(VersionConvertor_30_40.convertContactDetail(t));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Enumeration<Contributor.ContributorType> convertContributorType(Enumeration<Contributor.ContributorType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Enumeration<Contributor.ContributorType> tgt = new org.hl7.fhir.r4.model.Enumeration<Contributor.ContributorType>(new Contributor.ContributorTypeEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((Contributor.ContributorType)((Object)src.getValue())) {
            case AUTHOR: {
                tgt.setValue((Object)Contributor.ContributorType.AUTHOR);
                break;
            }
            case EDITOR: {
                tgt.setValue((Object)Contributor.ContributorType.EDITOR);
                break;
            }
            case REVIEWER: {
                tgt.setValue((Object)Contributor.ContributorType.REVIEWER);
                break;
            }
            case ENDORSER: {
                tgt.setValue((Object)Contributor.ContributorType.ENDORSER);
                break;
            }
            default: {
                tgt.setValue((Object)Contributor.ContributorType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Contributor.ContributorType> convertContributorType(org.hl7.fhir.r4.model.Enumeration<Contributor.ContributorType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Contributor.ContributorType> tgt = new Enumeration<Contributor.ContributorType>(new Contributor.ContributorTypeEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((Contributor.ContributorType)((Object)src.getValue())) {
            case AUTHOR: {
                tgt.setValue((Object)Contributor.ContributorType.AUTHOR);
                break;
            }
            case EDITOR: {
                tgt.setValue((Object)Contributor.ContributorType.EDITOR);
                break;
            }
            case REVIEWER: {
                tgt.setValue((Object)Contributor.ContributorType.REVIEWER);
                break;
            }
            case ENDORSER: {
                tgt.setValue((Object)Contributor.ContributorType.ENDORSER);
                break;
            }
            default: {
                tgt.setValue((Object)Contributor.ContributorType.NULL);
            }
        }
        return tgt;
    }

    public static Dosage convertDosage(org.hl7.fhir.dstu3.model.Dosage src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Dosage tgt = new Dosage();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasSequence()) {
            tgt.setSequenceElement(VersionConvertor_30_40.convertInteger(src.getSequenceElement()));
        }
        if (src.hasText()) {
            tgt.setTextElement(VersionConvertor_30_40.convertString(src.getTextElement()));
        }
        for (CodeableConcept t : src.getAdditionalInstruction()) {
            tgt.addAdditionalInstruction(VersionConvertor_30_40.convertCodeableConcept(t));
        }
        if (src.hasPatientInstruction()) {
            tgt.setPatientInstructionElement(VersionConvertor_30_40.convertString(src.getPatientInstructionElement()));
        }
        if (src.hasTiming()) {
            tgt.setTiming(VersionConvertor_30_40.convertTiming(src.getTiming()));
        }
        if (src.hasAsNeeded()) {
            tgt.setAsNeeded(VersionConvertor_30_40.convertType(src.getAsNeeded()));
        }
        if (src.hasSite()) {
            tgt.setSite(VersionConvertor_30_40.convertCodeableConcept(src.getSite()));
        }
        if (src.hasRoute()) {
            tgt.setRoute(VersionConvertor_30_40.convertCodeableConcept(src.getRoute()));
        }
        if (src.hasMethod()) {
            tgt.setMethod(VersionConvertor_30_40.convertCodeableConcept(src.getMethod()));
        }
        if (src.hasDose() || src.hasRate()) {
            Dosage.DosageDoseAndRateComponent dr = tgt.addDoseAndRate();
            if (src.hasDose()) {
                dr.setDose(VersionConvertor_30_40.convertType(src.getDose()));
            }
            if (src.hasRate()) {
                dr.setRate(VersionConvertor_30_40.convertType(src.getRate()));
            }
        }
        if (src.hasMaxDosePerPeriod()) {
            tgt.setMaxDosePerPeriod(VersionConvertor_30_40.convertRatio(src.getMaxDosePerPeriod()));
        }
        if (src.hasMaxDosePerAdministration()) {
            tgt.setMaxDosePerAdministration(VersionConvertor_30_40.convertSimpleQuantity(src.getMaxDosePerAdministration()));
        }
        if (src.hasMaxDosePerLifetime()) {
            tgt.setMaxDosePerLifetime(VersionConvertor_30_40.convertSimpleQuantity(src.getMaxDosePerLifetime()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Dosage convertDosage(Dosage src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Dosage tgt = new org.hl7.fhir.dstu3.model.Dosage();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasSequence()) {
            tgt.setSequenceElement(VersionConvertor_30_40.convertInteger(src.getSequenceElement()));
        }
        if (src.hasText()) {
            tgt.setTextElement(VersionConvertor_30_40.convertString(src.getTextElement()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept t : src.getAdditionalInstruction()) {
            tgt.addAdditionalInstruction(VersionConvertor_30_40.convertCodeableConcept(t));
        }
        if (src.hasPatientInstruction()) {
            tgt.setPatientInstructionElement(VersionConvertor_30_40.convertString(src.getPatientInstructionElement()));
        }
        if (src.hasTiming()) {
            tgt.setTiming(VersionConvertor_30_40.convertTiming(src.getTiming()));
        }
        if (src.hasAsNeeded()) {
            tgt.setAsNeeded(VersionConvertor_30_40.convertType(src.getAsNeeded()));
        }
        if (src.hasSite()) {
            tgt.setSite(VersionConvertor_30_40.convertCodeableConcept(src.getSite()));
        }
        if (src.hasRoute()) {
            tgt.setRoute(VersionConvertor_30_40.convertCodeableConcept(src.getRoute()));
        }
        if (src.hasMethod()) {
            tgt.setMethod(VersionConvertor_30_40.convertCodeableConcept(src.getMethod()));
        }
        if (src.hasDoseAndRate() && src.getDoseAndRate().get(0).hasDose()) {
            if (src.getDoseAndRate().get(0).getDose() instanceof Quantity) {
                tgt.setDose(VersionConvertor_30_40.convertSimpleQuantity((Quantity)src.getDoseAndRate().get(0).getDose()));
            } else {
                tgt.setDose(VersionConvertor_30_40.convertType(src.getDoseAndRate().get(0).getDose()));
            }
        }
        if (src.hasMaxDosePerPeriod()) {
            tgt.setMaxDosePerPeriod(VersionConvertor_30_40.convertRatio(src.getMaxDosePerPeriod()));
        }
        if (src.hasMaxDosePerAdministration()) {
            tgt.setMaxDosePerAdministration(VersionConvertor_30_40.convertSimpleQuantity(src.getMaxDosePerAdministration()));
        }
        if (src.hasMaxDosePerLifetime()) {
            tgt.setMaxDosePerLifetime(VersionConvertor_30_40.convertSimpleQuantity(src.getMaxDosePerLifetime()));
        }
        if (src.hasDoseAndRate() && src.getDoseAndRate().get(0).hasRate()) {
            if (src.getDoseAndRate().get(0).getRate() instanceof Quantity) {
                tgt.setRate(VersionConvertor_30_40.convertSimpleQuantity((Quantity)src.getDoseAndRate().get(0).getRate()));
            } else {
                tgt.setRate(VersionConvertor_30_40.convertType(src.getDoseAndRate().get(0).getRate()));
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.ElementDefinition convertElementDefinition(ElementDefinition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.ElementDefinition tgt = new org.hl7.fhir.r4.model.ElementDefinition();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasPath()) {
            tgt.setPathElement(VersionConvertor_30_40.convertString(src.getPathElement()));
        }
        tgt.setRepresentation(src.getRepresentation().stream().map(VersionConvertor_30_40::convertPropertyRepresentation).collect(Collectors.toList()));
        if (src.hasSliceName()) {
            tgt.setSliceNameElement(VersionConvertor_30_40.convertString(src.getSliceNameElement()));
        }
        if (src.hasLabel()) {
            tgt.setLabelElement(VersionConvertor_30_40.convertString(src.getLabelElement()));
        }
        for (Coding coding : src.getCode()) {
            tgt.addCode(VersionConvertor_30_40.convertCoding(coding));
        }
        if (src.hasSlicing()) {
            tgt.setSlicing(VersionConvertor_30_40.convertElementDefinitionSlicingComponent(src.getSlicing()));
        }
        if (src.hasShort()) {
            tgt.setShortElement(VersionConvertor_30_40.convertString(src.getShortElement()));
        }
        if (src.hasDefinition()) {
            tgt.setDefinitionElement(VersionConvertor_30_40.convertMarkdown(src.getDefinitionElement()));
        }
        if (src.hasComment()) {
            tgt.setCommentElement(VersionConvertor_30_40.convertMarkdown(src.getCommentElement()));
        }
        if (src.hasRequirements()) {
            tgt.setRequirementsElement(VersionConvertor_30_40.convertMarkdown(src.getRequirementsElement()));
        }
        for (org.hl7.fhir.dstu3.model.StringType stringType : src.getAlias()) {
            tgt.addAlias((String)stringType.getValue());
        }
        if (src.hasMin()) {
            tgt.setMinElement(VersionConvertor_30_40.convertUnsignedInt(src.getMinElement()));
        }
        if (src.hasMax()) {
            tgt.setMaxElement(VersionConvertor_30_40.convertString(src.getMaxElement()));
        }
        if (src.hasBase()) {
            tgt.setBase(VersionConvertor_30_40.convertElementDefinitionBaseComponent(src.getBase()));
        }
        if (src.hasContentReference()) {
            tgt.setContentReferenceElement(VersionConvertor_30_40.convertUri(src.getContentReferenceElement()));
        }
        for (ElementDefinition.TypeRefComponent typeRefComponent : src.getType()) {
            VersionConvertor_30_40.convertTypeRefComponent(typeRefComponent, tgt.getType());
        }
        if (src.hasDefaultValue()) {
            tgt.setDefaultValue(VersionConvertor_30_40.convertType(src.getDefaultValue()));
        }
        if (src.hasMeaningWhenMissing()) {
            tgt.setMeaningWhenMissingElement(VersionConvertor_30_40.convertMarkdown(src.getMeaningWhenMissingElement()));
        }
        if (src.hasOrderMeaning()) {
            tgt.setOrderMeaningElement(VersionConvertor_30_40.convertString(src.getOrderMeaningElement()));
        }
        if (src.hasFixed()) {
            tgt.setFixed(VersionConvertor_30_40.convertType(src.getFixed()));
        }
        if (src.hasPattern()) {
            tgt.setPattern(VersionConvertor_30_40.convertType(src.getPattern()));
        }
        for (ElementDefinition.ElementDefinitionExampleComponent elementDefinitionExampleComponent : src.getExample()) {
            tgt.addExample(VersionConvertor_30_40.convertElementDefinitionExampleComponent(elementDefinitionExampleComponent));
        }
        if (src.hasMinValue()) {
            tgt.setMinValue(VersionConvertor_30_40.convertType(src.getMinValue()));
        }
        if (src.hasMaxValue()) {
            tgt.setMaxValue(VersionConvertor_30_40.convertType(src.getMaxValue()));
        }
        if (src.hasMaxLength()) {
            tgt.setMaxLengthElement(VersionConvertor_30_40.convertInteger(src.getMaxLengthElement()));
        }
        for (org.hl7.fhir.dstu3.model.IdType idType : src.getCondition()) {
            tgt.addCondition(idType.getValue());
        }
        for (ElementDefinition.ElementDefinitionConstraintComponent elementDefinitionConstraintComponent : src.getConstraint()) {
            tgt.addConstraint(VersionConvertor_30_40.convertElementDefinitionConstraintComponent(elementDefinitionConstraintComponent));
        }
        if (src.hasMustSupport()) {
            tgt.setMustSupportElement(VersionConvertor_30_40.convertBoolean(src.getMustSupportElement()));
        }
        if (src.hasIsModifier()) {
            tgt.setIsModifierElement(VersionConvertor_30_40.convertBoolean(src.getIsModifierElement()));
        }
        if (tgt.getIsModifier()) {
            String reason = ToolingExtensions.readStringExtension(src, "http://hl7.org/fhir/4.0/StructureDefinition/extension-ElementDefinition.isModifierReason");
            if (Utilities.noString(reason)) {
                reason = "No Modifier Reason provideed in previous versions of FHIR";
            }
            tgt.setIsModifierReason(reason);
        }
        if (src.hasIsSummary()) {
            tgt.setIsSummaryElement(VersionConvertor_30_40.convertBoolean(src.getIsSummaryElement()));
        }
        if (src.hasBinding()) {
            tgt.setBinding(VersionConvertor_30_40.convertElementDefinitionBindingComponent(src.getBinding()));
        }
        for (ElementDefinition.ElementDefinitionMappingComponent elementDefinitionMappingComponent : src.getMapping()) {
            tgt.addMapping(VersionConvertor_30_40.convertElementDefinitionMappingComponent(elementDefinitionMappingComponent));
        }
        return tgt;
    }

    public static ElementDefinition convertElementDefinition(org.hl7.fhir.r4.model.ElementDefinition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ElementDefinition tgt = new ElementDefinition();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasPath()) {
            tgt.setPathElement(VersionConvertor_30_40.convertString(src.getPathElement()));
        }
        tgt.setRepresentation(src.getRepresentation().stream().map(VersionConvertor_30_40::convertPropertyRepresentation).collect(Collectors.toList()));
        if (src.hasSliceName()) {
            tgt.setSliceNameElement(VersionConvertor_30_40.convertString(src.getSliceNameElement()));
        }
        if (src.hasLabel()) {
            tgt.setLabelElement(VersionConvertor_30_40.convertString(src.getLabelElement()));
        }
        for (org.hl7.fhir.r4.model.Coding coding : src.getCode()) {
            tgt.addCode(VersionConvertor_30_40.convertCoding(coding));
        }
        if (src.hasSlicing()) {
            tgt.setSlicing(VersionConvertor_30_40.convertElementDefinitionSlicingComponent(src.getSlicing()));
        }
        if (src.hasShort()) {
            tgt.setShortElement(VersionConvertor_30_40.convertString(src.getShortElement()));
        }
        if (src.hasDefinition()) {
            tgt.setDefinitionElement(VersionConvertor_30_40.convertMarkdown(src.getDefinitionElement()));
        }
        if (src.hasComment()) {
            tgt.setCommentElement(VersionConvertor_30_40.convertMarkdown(src.getCommentElement()));
        }
        if (src.hasRequirements()) {
            tgt.setRequirementsElement(VersionConvertor_30_40.convertMarkdown(src.getRequirementsElement()));
        }
        for (StringType stringType : src.getAlias()) {
            tgt.addAlias((String)stringType.getValue());
        }
        if (src.hasMin()) {
            tgt.setMinElement(VersionConvertor_30_40.convertUnsignedInt(src.getMinElement()));
        }
        if (src.hasMax()) {
            tgt.setMaxElement(VersionConvertor_30_40.convertString(src.getMaxElement()));
        }
        if (src.hasBase()) {
            tgt.setBase(VersionConvertor_30_40.convertElementDefinitionBaseComponent(src.getBase()));
        }
        if (src.hasContentReference()) {
            tgt.setContentReferenceElement(VersionConvertor_30_40.convertUri(src.getContentReferenceElement()));
        }
        for (ElementDefinition.TypeRefComponent typeRefComponent : src.getType()) {
            VersionConvertor_30_40.convertTypeRefComponent(typeRefComponent, tgt.getType());
        }
        if (src.hasDefaultValue()) {
            tgt.setDefaultValue(VersionConvertor_30_40.convertType(src.getDefaultValue()));
        }
        if (src.hasMeaningWhenMissing()) {
            tgt.setMeaningWhenMissingElement(VersionConvertor_30_40.convertMarkdown(src.getMeaningWhenMissingElement()));
        }
        if (src.hasOrderMeaning()) {
            tgt.setOrderMeaningElement(VersionConvertor_30_40.convertString(src.getOrderMeaningElement()));
        }
        if (src.hasFixed()) {
            tgt.setFixed(VersionConvertor_30_40.convertType(src.getFixed()));
        }
        if (src.hasPattern()) {
            tgt.setPattern(VersionConvertor_30_40.convertType(src.getPattern()));
        }
        for (ElementDefinition.ElementDefinitionExampleComponent elementDefinitionExampleComponent : src.getExample()) {
            tgt.addExample(VersionConvertor_30_40.convertElementDefinitionExampleComponent(elementDefinitionExampleComponent));
        }
        if (src.hasMinValue()) {
            tgt.setMinValue(VersionConvertor_30_40.convertType(src.getMinValue()));
        }
        if (src.hasMaxValue()) {
            tgt.setMaxValue(VersionConvertor_30_40.convertType(src.getMaxValue()));
        }
        if (src.hasMaxLength()) {
            tgt.setMaxLengthElement(VersionConvertor_30_40.convertInteger(src.getMaxLengthElement()));
        }
        for (IdType idType : src.getCondition()) {
            tgt.addCondition(idType.getValue());
        }
        for (ElementDefinition.ElementDefinitionConstraintComponent elementDefinitionConstraintComponent : src.getConstraint()) {
            tgt.addConstraint(VersionConvertor_30_40.convertElementDefinitionConstraintComponent(elementDefinitionConstraintComponent));
        }
        if (src.hasMustSupport()) {
            tgt.setMustSupportElement(VersionConvertor_30_40.convertBoolean(src.getMustSupportElement()));
        }
        if (src.hasIsModifier()) {
            tgt.setIsModifierElement(VersionConvertor_30_40.convertBoolean(src.getIsModifierElement()));
        }
        if (src.hasIsModifierReason() && !"No Modifier Reason provideed in previous versions of FHIR".equals(src.getIsModifierReason())) {
            ToolingExtensions.setStringExtension(tgt, "http://hl7.org/fhir/4.0/StructureDefinition/extension-ElementDefinition.isModifierReason", src.getIsModifierReason());
        }
        if (src.hasIsSummary()) {
            tgt.setIsSummaryElement(VersionConvertor_30_40.convertBoolean(src.getIsSummaryElement()));
        }
        if (src.hasBinding()) {
            tgt.setBinding(VersionConvertor_30_40.convertElementDefinitionBindingComponent(src.getBinding()));
        }
        for (ElementDefinition.ElementDefinitionMappingComponent elementDefinitionMappingComponent : src.getMapping()) {
            tgt.addMapping(VersionConvertor_30_40.convertElementDefinitionMappingComponent(elementDefinitionMappingComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Enumeration<ElementDefinition.PropertyRepresentation> convertPropertyRepresentation(Enumeration<ElementDefinition.PropertyRepresentation> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Enumeration<ElementDefinition.PropertyRepresentation> tgt = new org.hl7.fhir.r4.model.Enumeration<ElementDefinition.PropertyRepresentation>(new ElementDefinition.PropertyRepresentationEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((ElementDefinition.PropertyRepresentation)((Object)src.getValue())) {
            case XMLATTR: {
                tgt.setValue((Object)ElementDefinition.PropertyRepresentation.XMLATTR);
                break;
            }
            case XMLTEXT: {
                tgt.setValue((Object)ElementDefinition.PropertyRepresentation.XMLTEXT);
                break;
            }
            case TYPEATTR: {
                tgt.setValue((Object)ElementDefinition.PropertyRepresentation.TYPEATTR);
                break;
            }
            case CDATEXT: {
                tgt.setValue((Object)ElementDefinition.PropertyRepresentation.CDATEXT);
                break;
            }
            case XHTML: {
                tgt.setValue((Object)ElementDefinition.PropertyRepresentation.XHTML);
                break;
            }
            default: {
                tgt.setValue((Object)ElementDefinition.PropertyRepresentation.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<ElementDefinition.PropertyRepresentation> convertPropertyRepresentation(org.hl7.fhir.r4.model.Enumeration<ElementDefinition.PropertyRepresentation> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ElementDefinition.PropertyRepresentation> tgt = new Enumeration<ElementDefinition.PropertyRepresentation>(new ElementDefinition.PropertyRepresentationEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((ElementDefinition.PropertyRepresentation)((Object)src.getValue())) {
            case XMLATTR: {
                tgt.setValue((Object)ElementDefinition.PropertyRepresentation.XMLATTR);
                break;
            }
            case XMLTEXT: {
                tgt.setValue((Object)ElementDefinition.PropertyRepresentation.XMLTEXT);
                break;
            }
            case TYPEATTR: {
                tgt.setValue((Object)ElementDefinition.PropertyRepresentation.TYPEATTR);
                break;
            }
            case CDATEXT: {
                tgt.setValue((Object)ElementDefinition.PropertyRepresentation.CDATEXT);
                break;
            }
            case XHTML: {
                tgt.setValue((Object)ElementDefinition.PropertyRepresentation.XHTML);
                break;
            }
            default: {
                tgt.setValue((Object)ElementDefinition.PropertyRepresentation.NULL);
            }
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionSlicingComponent convertElementDefinitionSlicingComponent(ElementDefinition.ElementDefinitionSlicingComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ElementDefinition.ElementDefinitionSlicingComponent tgt = new ElementDefinition.ElementDefinitionSlicingComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        for (ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent t : src.getDiscriminator()) {
            tgt.addDiscriminator(VersionConvertor_30_40.convertElementDefinitionSlicingDiscriminatorComponent(t));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_40.convertString(src.getDescriptionElement()));
        }
        if (src.hasOrdered()) {
            tgt.setOrderedElement(VersionConvertor_30_40.convertBoolean(src.getOrderedElement()));
        }
        if (src.hasRules()) {
            tgt.setRulesElement(VersionConvertor_30_40.convertSlicingRules(src.getRulesElement()));
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionSlicingComponent convertElementDefinitionSlicingComponent(ElementDefinition.ElementDefinitionSlicingComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ElementDefinition.ElementDefinitionSlicingComponent tgt = new ElementDefinition.ElementDefinitionSlicingComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        for (ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent t : src.getDiscriminator()) {
            tgt.addDiscriminator(VersionConvertor_30_40.convertElementDefinitionSlicingDiscriminatorComponent(t));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_40.convertString(src.getDescriptionElement()));
        }
        if (src.hasOrdered()) {
            tgt.setOrderedElement(VersionConvertor_30_40.convertBoolean(src.getOrderedElement()));
        }
        if (src.hasRules()) {
            tgt.setRulesElement(VersionConvertor_30_40.convertSlicingRules(src.getRulesElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Enumeration<ElementDefinition.SlicingRules> convertSlicingRules(Enumeration<ElementDefinition.SlicingRules> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Enumeration<ElementDefinition.SlicingRules> tgt = new org.hl7.fhir.r4.model.Enumeration<ElementDefinition.SlicingRules>(new ElementDefinition.SlicingRulesEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((ElementDefinition.SlicingRules)((Object)src.getValue())) {
            case CLOSED: {
                tgt.setValue((Object)ElementDefinition.SlicingRules.CLOSED);
                break;
            }
            case OPEN: {
                tgt.setValue((Object)ElementDefinition.SlicingRules.OPEN);
                break;
            }
            case OPENATEND: {
                tgt.setValue((Object)ElementDefinition.SlicingRules.OPENATEND);
                break;
            }
            default: {
                tgt.setValue((Object)ElementDefinition.SlicingRules.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<ElementDefinition.SlicingRules> convertSlicingRules(org.hl7.fhir.r4.model.Enumeration<ElementDefinition.SlicingRules> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ElementDefinition.SlicingRules> tgt = new Enumeration<ElementDefinition.SlicingRules>(new ElementDefinition.SlicingRulesEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((ElementDefinition.SlicingRules)((Object)src.getValue())) {
            case CLOSED: {
                tgt.setValue((Object)ElementDefinition.SlicingRules.CLOSED);
                break;
            }
            case OPEN: {
                tgt.setValue((Object)ElementDefinition.SlicingRules.OPEN);
                break;
            }
            case OPENATEND: {
                tgt.setValue((Object)ElementDefinition.SlicingRules.OPENATEND);
                break;
            }
            default: {
                tgt.setValue((Object)ElementDefinition.SlicingRules.NULL);
            }
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent convertElementDefinitionSlicingDiscriminatorComponent(ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent tgt = new ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(VersionConvertor_30_40.convertDiscriminatorType(src.getTypeElement()));
        }
        if (src.hasPath()) {
            tgt.setPathElement(VersionConvertor_30_40.convertString(src.getPathElement()));
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent convertElementDefinitionSlicingDiscriminatorComponent(ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent tgt = new ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(VersionConvertor_30_40.convertDiscriminatorType(src.getTypeElement()));
        }
        if (src.hasPath()) {
            tgt.setPathElement(VersionConvertor_30_40.convertString(src.getPathElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Enumeration<ElementDefinition.DiscriminatorType> convertDiscriminatorType(Enumeration<ElementDefinition.DiscriminatorType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Enumeration<ElementDefinition.DiscriminatorType> tgt = new org.hl7.fhir.r4.model.Enumeration<ElementDefinition.DiscriminatorType>(new ElementDefinition.DiscriminatorTypeEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((ElementDefinition.DiscriminatorType)((Object)src.getValue())) {
            case VALUE: {
                tgt.setValue((Object)ElementDefinition.DiscriminatorType.VALUE);
                break;
            }
            case EXISTS: {
                tgt.setValue((Object)ElementDefinition.DiscriminatorType.EXISTS);
                break;
            }
            case PATTERN: {
                tgt.setValue((Object)ElementDefinition.DiscriminatorType.PATTERN);
                break;
            }
            case TYPE: {
                tgt.setValue((Object)ElementDefinition.DiscriminatorType.TYPE);
                break;
            }
            case PROFILE: {
                tgt.setValue((Object)ElementDefinition.DiscriminatorType.PROFILE);
                break;
            }
            default: {
                tgt.setValue((Object)ElementDefinition.DiscriminatorType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<ElementDefinition.DiscriminatorType> convertDiscriminatorType(org.hl7.fhir.r4.model.Enumeration<ElementDefinition.DiscriminatorType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ElementDefinition.DiscriminatorType> tgt = new Enumeration<ElementDefinition.DiscriminatorType>(new ElementDefinition.DiscriminatorTypeEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((ElementDefinition.DiscriminatorType)((Object)src.getValue())) {
            case VALUE: {
                tgt.setValue((Object)ElementDefinition.DiscriminatorType.VALUE);
                break;
            }
            case EXISTS: {
                tgt.setValue((Object)ElementDefinition.DiscriminatorType.EXISTS);
                break;
            }
            case PATTERN: {
                tgt.setValue((Object)ElementDefinition.DiscriminatorType.PATTERN);
                break;
            }
            case TYPE: {
                tgt.setValue((Object)ElementDefinition.DiscriminatorType.TYPE);
                break;
            }
            case PROFILE: {
                tgt.setValue((Object)ElementDefinition.DiscriminatorType.PROFILE);
                break;
            }
            default: {
                tgt.setValue((Object)ElementDefinition.DiscriminatorType.NULL);
            }
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionBaseComponent convertElementDefinitionBaseComponent(ElementDefinition.ElementDefinitionBaseComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ElementDefinition.ElementDefinitionBaseComponent tgt = new ElementDefinition.ElementDefinitionBaseComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasPath()) {
            tgt.setPathElement(VersionConvertor_30_40.convertString(src.getPathElement()));
        }
        if (src.hasMin()) {
            tgt.setMinElement(VersionConvertor_30_40.convertUnsignedInt(src.getMinElement()));
        }
        if (src.hasMax()) {
            tgt.setMaxElement(VersionConvertor_30_40.convertString(src.getMaxElement()));
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionBaseComponent convertElementDefinitionBaseComponent(ElementDefinition.ElementDefinitionBaseComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ElementDefinition.ElementDefinitionBaseComponent tgt = new ElementDefinition.ElementDefinitionBaseComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasPath()) {
            tgt.setPathElement(VersionConvertor_30_40.convertString(src.getPathElement()));
        }
        if (src.hasMin()) {
            tgt.setMinElement(VersionConvertor_30_40.convertUnsignedInt(src.getMinElement()));
        }
        if (src.hasMax()) {
            tgt.setMaxElement(VersionConvertor_30_40.convertString(src.getMaxElement()));
        }
        return tgt;
    }

    public static void convertTypeRefComponent(ElementDefinition.TypeRefComponent src, List<ElementDefinition.TypeRefComponent> list) throws FHIRException {
        if (src == null) {
            return;
        }
        ElementDefinition.TypeRefComponent tgt = null;
        for (ElementDefinition.TypeRefComponent typeRefComponent : list) {
            if (!typeRefComponent.getCode().equals(src.getCode())) continue;
            tgt = typeRefComponent;
        }
        if (tgt == null) {
            tgt = new ElementDefinition.TypeRefComponent();
            list.add(tgt);
            VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
            tgt.setCodeElement(VersionConvertor_30_40.convertUri(src.getCodeElement()));
        }
        if (src.hasProfile()) {
            tgt.addProfile(src.getProfile());
        }
        if (src.hasTargetProfile()) {
            tgt.addTargetProfile(src.getTargetProfile());
        }
        for (Enumeration enumeration : src.getAggregation()) {
            org.hl7.fhir.r4.model.Enumeration<ElementDefinition.AggregationMode> a = VersionConvertor_30_40.convertAggregationMode(enumeration);
            if (tgt.hasAggregation((ElementDefinition.AggregationMode)((Object)a.getValue()))) continue;
            VersionConvertor_30_40.copyElement(enumeration, tgt.addAggregation((ElementDefinition.AggregationMode)((Object)a.getValue())), new String[0]);
        }
        if (src.hasVersioning()) {
            tgt.setVersioningElement(VersionConvertor_30_40.convertReferenceVersionRules(src.getVersioningElement()));
        }
    }

    public static void convertTypeRefComponent(ElementDefinition.TypeRefComponent src, List<ElementDefinition.TypeRefComponent> list) throws FHIRException {
        if (src == null) {
            return;
        }
        ElementDefinition.TypeRefComponent tgt = new ElementDefinition.TypeRefComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        tgt.setCodeElement(VersionConvertor_30_40.convertUri(src.getCodeElement()));
        list.add(tgt);
        if (src.hasTarget()) {
            if (src.hasProfile()) {
                tgt.setProfile((String)src.getProfile().get(0).getValue());
            }
            for (org.hl7.fhir.r4.model.UriType uriType : src.getTargetProfile()) {
                if (tgt.hasTargetProfile()) {
                    tgt = new ElementDefinition.TypeRefComponent();
                    list.add(tgt);
                    VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
                    tgt.setCode(src.getCode());
                    if (src.hasProfile()) {
                        tgt.setProfile((String)src.getProfile().get(0).getValue());
                    }
                }
                tgt.setTargetProfile((String)uriType.getValue());
            }
        } else {
            for (org.hl7.fhir.r4.model.UriType uriType : src.getProfile()) {
                if (tgt.hasProfile()) {
                    tgt = new ElementDefinition.TypeRefComponent();
                    list.add(tgt);
                    VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
                    tgt.setCode(src.getCode());
                }
                tgt.setProfile((String)uriType.getValue());
            }
        }
    }

    public static org.hl7.fhir.r4.model.Enumeration<ElementDefinition.AggregationMode> convertAggregationMode(Enumeration<ElementDefinition.AggregationMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Enumeration<ElementDefinition.AggregationMode> tgt = new org.hl7.fhir.r4.model.Enumeration<ElementDefinition.AggregationMode>(new ElementDefinition.AggregationModeEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((ElementDefinition.AggregationMode)((Object)src.getValue())) {
            case CONTAINED: {
                tgt.setValue((Object)ElementDefinition.AggregationMode.CONTAINED);
                break;
            }
            case REFERENCED: {
                tgt.setValue((Object)ElementDefinition.AggregationMode.REFERENCED);
                break;
            }
            case BUNDLED: {
                tgt.setValue((Object)ElementDefinition.AggregationMode.BUNDLED);
                break;
            }
            default: {
                tgt.setValue((Object)ElementDefinition.AggregationMode.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<ElementDefinition.AggregationMode> convertAggregationMode(org.hl7.fhir.r4.model.Enumeration<ElementDefinition.AggregationMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ElementDefinition.AggregationMode> tgt = new Enumeration<ElementDefinition.AggregationMode>(new ElementDefinition.AggregationModeEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((ElementDefinition.AggregationMode)((Object)src.getValue())) {
            case CONTAINED: {
                tgt.setValue((Object)ElementDefinition.AggregationMode.CONTAINED);
                break;
            }
            case REFERENCED: {
                tgt.setValue((Object)ElementDefinition.AggregationMode.REFERENCED);
                break;
            }
            case BUNDLED: {
                tgt.setValue((Object)ElementDefinition.AggregationMode.BUNDLED);
                break;
            }
            default: {
                tgt.setValue((Object)ElementDefinition.AggregationMode.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Enumeration<ElementDefinition.ReferenceVersionRules> convertReferenceVersionRules(Enumeration<ElementDefinition.ReferenceVersionRules> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Enumeration<ElementDefinition.ReferenceVersionRules> tgt = new org.hl7.fhir.r4.model.Enumeration<ElementDefinition.ReferenceVersionRules>(new ElementDefinition.ReferenceVersionRulesEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((ElementDefinition.ReferenceVersionRules)((Object)src.getValue())) {
            case EITHER: {
                tgt.setValue((Object)ElementDefinition.ReferenceVersionRules.EITHER);
                break;
            }
            case INDEPENDENT: {
                tgt.setValue((Object)ElementDefinition.ReferenceVersionRules.INDEPENDENT);
                break;
            }
            case SPECIFIC: {
                tgt.setValue((Object)ElementDefinition.ReferenceVersionRules.SPECIFIC);
                break;
            }
            default: {
                tgt.setValue((Object)ElementDefinition.ReferenceVersionRules.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<ElementDefinition.ReferenceVersionRules> convertReferenceVersionRules(org.hl7.fhir.r4.model.Enumeration<ElementDefinition.ReferenceVersionRules> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ElementDefinition.ReferenceVersionRules> tgt = new Enumeration<ElementDefinition.ReferenceVersionRules>(new ElementDefinition.ReferenceVersionRulesEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((ElementDefinition.ReferenceVersionRules)((Object)src.getValue())) {
            case EITHER: {
                tgt.setValue((Object)ElementDefinition.ReferenceVersionRules.EITHER);
                break;
            }
            case INDEPENDENT: {
                tgt.setValue((Object)ElementDefinition.ReferenceVersionRules.INDEPENDENT);
                break;
            }
            case SPECIFIC: {
                tgt.setValue((Object)ElementDefinition.ReferenceVersionRules.SPECIFIC);
                break;
            }
            default: {
                tgt.setValue((Object)ElementDefinition.ReferenceVersionRules.NULL);
            }
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionExampleComponent convertElementDefinitionExampleComponent(ElementDefinition.ElementDefinitionExampleComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ElementDefinition.ElementDefinitionExampleComponent tgt = new ElementDefinition.ElementDefinitionExampleComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasLabel()) {
            tgt.setLabelElement(VersionConvertor_30_40.convertString(src.getLabelElement()));
        }
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_30_40.convertType(src.getValue()));
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionExampleComponent convertElementDefinitionExampleComponent(ElementDefinition.ElementDefinitionExampleComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ElementDefinition.ElementDefinitionExampleComponent tgt = new ElementDefinition.ElementDefinitionExampleComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasLabel()) {
            tgt.setLabelElement(VersionConvertor_30_40.convertString(src.getLabelElement()));
        }
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_30_40.convertType(src.getValue()));
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionConstraintComponent convertElementDefinitionConstraintComponent(ElementDefinition.ElementDefinitionConstraintComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ElementDefinition.ElementDefinitionConstraintComponent tgt = new ElementDefinition.ElementDefinitionConstraintComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasKey()) {
            tgt.setKeyElement(VersionConvertor_30_40.convertId(src.getKeyElement()));
        }
        if (src.hasRequirements()) {
            tgt.setRequirementsElement(VersionConvertor_30_40.convertString(src.getRequirementsElement()));
        }
        if (src.hasSeverity()) {
            tgt.setSeverityElement(VersionConvertor_30_40.convertConstraintSeverity(src.getSeverityElement()));
        }
        if (src.hasHuman()) {
            tgt.setHumanElement(VersionConvertor_30_40.convertString(src.getHumanElement()));
        }
        if (src.hasExpression()) {
            tgt.setExpressionElement(VersionConvertor_30_40.convertString(src.getExpressionElement()));
        }
        if (src.hasXpath()) {
            tgt.setXpathElement(VersionConvertor_30_40.convertString(src.getXpathElement()));
        }
        if (src.hasSource()) {
            tgt.setSource(src.getSource());
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionConstraintComponent convertElementDefinitionConstraintComponent(ElementDefinition.ElementDefinitionConstraintComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ElementDefinition.ElementDefinitionConstraintComponent tgt = new ElementDefinition.ElementDefinitionConstraintComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasKey()) {
            tgt.setKeyElement(VersionConvertor_30_40.convertId(src.getKeyElement()));
        }
        if (src.hasRequirements()) {
            tgt.setRequirementsElement(VersionConvertor_30_40.convertString(src.getRequirementsElement()));
        }
        if (src.hasSeverity()) {
            tgt.setSeverityElement(VersionConvertor_30_40.convertConstraintSeverity(src.getSeverityElement()));
        }
        if (src.hasHuman()) {
            tgt.setHumanElement(VersionConvertor_30_40.convertString(src.getHumanElement()));
        }
        if (src.hasExpression()) {
            tgt.setExpressionElement(VersionConvertor_30_40.convertString(src.getExpressionElement()));
        }
        if (src.hasXpath()) {
            tgt.setXpathElement(VersionConvertor_30_40.convertString(src.getXpathElement()));
        }
        if (src.hasSource()) {
            tgt.setSource(src.getSource());
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Enumeration<ElementDefinition.ConstraintSeverity> convertConstraintSeverity(Enumeration<ElementDefinition.ConstraintSeverity> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Enumeration<ElementDefinition.ConstraintSeverity> tgt = new org.hl7.fhir.r4.model.Enumeration<ElementDefinition.ConstraintSeverity>(new ElementDefinition.ConstraintSeverityEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((ElementDefinition.ConstraintSeverity)((Object)src.getValue())) {
            case ERROR: {
                tgt.setValue((Object)ElementDefinition.ConstraintSeverity.ERROR);
                break;
            }
            case WARNING: {
                tgt.setValue((Object)ElementDefinition.ConstraintSeverity.WARNING);
                break;
            }
            default: {
                tgt.setValue((Object)ElementDefinition.ConstraintSeverity.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<ElementDefinition.ConstraintSeverity> convertConstraintSeverity(org.hl7.fhir.r4.model.Enumeration<ElementDefinition.ConstraintSeverity> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ElementDefinition.ConstraintSeverity> tgt = new Enumeration<ElementDefinition.ConstraintSeverity>(new ElementDefinition.ConstraintSeverityEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((ElementDefinition.ConstraintSeverity)((Object)src.getValue())) {
            case ERROR: {
                tgt.setValue((Object)ElementDefinition.ConstraintSeverity.ERROR);
                break;
            }
            case WARNING: {
                tgt.setValue((Object)ElementDefinition.ConstraintSeverity.WARNING);
                break;
            }
            default: {
                tgt.setValue((Object)ElementDefinition.ConstraintSeverity.NULL);
            }
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionBindingComponent convertElementDefinitionBindingComponent(ElementDefinition.ElementDefinitionBindingComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ElementDefinition.ElementDefinitionBindingComponent tgt = new ElementDefinition.ElementDefinitionBindingComponent();
        VersionConvertor_30_40.copyElement(src, tgt, EXT_SRC_TYPE);
        if (src.hasStrength()) {
            tgt.setStrengthElement(VersionConvertor_30_40.convertBindingStrength(src.getStrengthElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_40.convertString(src.getDescriptionElement()));
        }
        if (src.hasValueSet()) {
            org.hl7.fhir.r4.model.Type t = VersionConvertor_30_40.convertType(src.getValueSet());
            if (t instanceof Reference) {
                tgt.setValueSet(((Reference)t).getReference());
                tgt.getValueSetElement().addExtension(EXT_SRC_TYPE, new org.hl7.fhir.r4.model.UriType("Reference"));
            } else {
                tgt.setValueSet(t.primitiveValue());
                tgt.getValueSetElement().addExtension(EXT_SRC_TYPE, new org.hl7.fhir.r4.model.UriType("uri"));
            }
            tgt.setValueSet(VersionConvertorConstants.refToVS(tgt.getValueSet()));
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionBindingComponent convertElementDefinitionBindingComponent(ElementDefinition.ElementDefinitionBindingComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ElementDefinition.ElementDefinitionBindingComponent tgt = new ElementDefinition.ElementDefinitionBindingComponent();
        VersionConvertor_30_40.copyElement(src, tgt, EXT_SRC_TYPE);
        if (src.hasStrength()) {
            tgt.setStrengthElement(VersionConvertor_30_40.convertBindingStrength(src.getStrengthElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_40.convertString(src.getDescriptionElement()));
        }
        if (src.hasValueSet()) {
            Extension ex = src.getValueSetElement().getExtensionByUrl(EXT_SRC_TYPE);
            String vsr = VersionConvertorConstants.vsToRef(src.getValueSet());
            if (ex != null) {
                if ("uri".equals(ex.getValue().primitiveValue())) {
                    tgt.setValueSet(new UriType(vsr == null ? src.getValueSet() : vsr));
                } else {
                    tgt.setValueSet(new org.hl7.fhir.dstu3.model.Reference(src.getValueSet()));
                }
            } else if (vsr != null) {
                tgt.setValueSet(new UriType(vsr));
            } else {
                tgt.setValueSet(new org.hl7.fhir.dstu3.model.Reference(src.getValueSet()));
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Enumeration<Enumerations.BindingStrength> convertBindingStrength(Enumeration<Enumerations.BindingStrength> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Enumeration<Enumerations.BindingStrength> tgt = new org.hl7.fhir.r4.model.Enumeration<Enumerations.BindingStrength>(new Enumerations.BindingStrengthEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.BindingStrength)((Object)src.getValue())) {
            case REQUIRED: {
                tgt.setValue((Object)Enumerations.BindingStrength.REQUIRED);
                break;
            }
            case EXTENSIBLE: {
                tgt.setValue((Object)Enumerations.BindingStrength.EXTENSIBLE);
                break;
            }
            case PREFERRED: {
                tgt.setValue((Object)Enumerations.BindingStrength.PREFERRED);
                break;
            }
            case EXAMPLE: {
                tgt.setValue((Object)Enumerations.BindingStrength.EXAMPLE);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.BindingStrength.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Enumerations.BindingStrength> convertBindingStrength(org.hl7.fhir.r4.model.Enumeration<Enumerations.BindingStrength> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Enumerations.BindingStrength> tgt = new Enumeration<Enumerations.BindingStrength>(new Enumerations.BindingStrengthEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.BindingStrength)((Object)src.getValue())) {
            case REQUIRED: {
                tgt.setValue((Object)Enumerations.BindingStrength.REQUIRED);
                break;
            }
            case EXTENSIBLE: {
                tgt.setValue((Object)Enumerations.BindingStrength.EXTENSIBLE);
                break;
            }
            case PREFERRED: {
                tgt.setValue((Object)Enumerations.BindingStrength.PREFERRED);
                break;
            }
            case EXAMPLE: {
                tgt.setValue((Object)Enumerations.BindingStrength.EXAMPLE);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.BindingStrength.NULL);
            }
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionMappingComponent convertElementDefinitionMappingComponent(ElementDefinition.ElementDefinitionMappingComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ElementDefinition.ElementDefinitionMappingComponent tgt = new ElementDefinition.ElementDefinitionMappingComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasIdentity()) {
            tgt.setIdentityElement(VersionConvertor_30_40.convertId(src.getIdentityElement()));
        }
        if (src.hasLanguage()) {
            tgt.setLanguageElement(VersionConvertor_30_40.convertCode(src.getLanguageElement()));
        }
        if (src.hasMap()) {
            tgt.setMapElement(VersionConvertor_30_40.convertString(src.getMapElement()));
        }
        if (src.hasComment()) {
            tgt.setCommentElement(VersionConvertor_30_40.convertString(src.getCommentElement()));
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionMappingComponent convertElementDefinitionMappingComponent(ElementDefinition.ElementDefinitionMappingComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ElementDefinition.ElementDefinitionMappingComponent tgt = new ElementDefinition.ElementDefinitionMappingComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasIdentity()) {
            tgt.setIdentityElement(VersionConvertor_30_40.convertId(src.getIdentityElement()));
        }
        if (src.hasLanguage()) {
            tgt.setLanguageElement(VersionConvertor_30_40.convertCode(src.getLanguageElement()));
        }
        if (src.hasMap()) {
            tgt.setMapElement(VersionConvertor_30_40.convertString(src.getMapElement()));
        }
        if (src.hasComment()) {
            tgt.setCommentElement(VersionConvertor_30_40.convertString(src.getCommentElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.HumanName convertHumanName(HumanName src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.HumanName tgt = new org.hl7.fhir.r4.model.HumanName();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasUse()) {
            tgt.setUseElement(VersionConvertor_30_40.convertNameUse(src.getUseElement()));
        }
        if (src.hasText()) {
            tgt.setTextElement(VersionConvertor_30_40.convertString(src.getTextElement()));
        }
        if (src.hasFamily()) {
            tgt.setFamilyElement(VersionConvertor_30_40.convertString(src.getFamilyElement()));
        }
        for (org.hl7.fhir.dstu3.model.StringType t : src.getGiven()) {
            tgt.addGiven((String)t.getValue());
        }
        for (org.hl7.fhir.dstu3.model.StringType t : src.getPrefix()) {
            tgt.addPrefix((String)t.getValue());
        }
        for (org.hl7.fhir.dstu3.model.StringType t : src.getSuffix()) {
            tgt.addSuffix((String)t.getValue());
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_40.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static HumanName convertHumanName(org.hl7.fhir.r4.model.HumanName src) throws FHIRException {
        if (src == null) {
            return null;
        }
        HumanName tgt = new HumanName();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasUse()) {
            tgt.setUseElement(VersionConvertor_30_40.convertNameUse(src.getUseElement()));
        }
        if (src.hasText()) {
            tgt.setTextElement(VersionConvertor_30_40.convertString(src.getTextElement()));
        }
        if (src.hasFamily()) {
            tgt.setFamilyElement(VersionConvertor_30_40.convertString(src.getFamilyElement()));
        }
        for (StringType t : src.getGiven()) {
            tgt.addGiven((String)t.getValue());
        }
        for (StringType t : src.getPrefix()) {
            tgt.addPrefix((String)t.getValue());
        }
        for (StringType t : src.getSuffix()) {
            tgt.addSuffix((String)t.getValue());
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_40.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Enumeration<HumanName.NameUse> convertNameUse(Enumeration<HumanName.NameUse> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Enumeration<HumanName.NameUse> tgt = new org.hl7.fhir.r4.model.Enumeration<HumanName.NameUse>(new HumanName.NameUseEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((HumanName.NameUse)((Object)src.getValue())) {
            case USUAL: {
                tgt.setValue((Object)HumanName.NameUse.USUAL);
                break;
            }
            case OFFICIAL: {
                tgt.setValue((Object)HumanName.NameUse.OFFICIAL);
                break;
            }
            case TEMP: {
                tgt.setValue((Object)HumanName.NameUse.TEMP);
                break;
            }
            case NICKNAME: {
                tgt.setValue((Object)HumanName.NameUse.NICKNAME);
                break;
            }
            case ANONYMOUS: {
                tgt.setValue((Object)HumanName.NameUse.ANONYMOUS);
                break;
            }
            case OLD: {
                tgt.setValue((Object)HumanName.NameUse.OLD);
                break;
            }
            case MAIDEN: {
                tgt.setValue((Object)HumanName.NameUse.MAIDEN);
                break;
            }
            default: {
                tgt.setValue((Object)HumanName.NameUse.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<HumanName.NameUse> convertNameUse(org.hl7.fhir.r4.model.Enumeration<HumanName.NameUse> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<HumanName.NameUse> tgt = new Enumeration<HumanName.NameUse>(new HumanName.NameUseEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((HumanName.NameUse)((Object)src.getValue())) {
            case USUAL: {
                tgt.setValue((Object)HumanName.NameUse.USUAL);
                break;
            }
            case OFFICIAL: {
                tgt.setValue((Object)HumanName.NameUse.OFFICIAL);
                break;
            }
            case TEMP: {
                tgt.setValue((Object)HumanName.NameUse.TEMP);
                break;
            }
            case NICKNAME: {
                tgt.setValue((Object)HumanName.NameUse.NICKNAME);
                break;
            }
            case ANONYMOUS: {
                tgt.setValue((Object)HumanName.NameUse.ANONYMOUS);
                break;
            }
            case OLD: {
                tgt.setValue((Object)HumanName.NameUse.OLD);
                break;
            }
            case MAIDEN: {
                tgt.setValue((Object)HumanName.NameUse.MAIDEN);
                break;
            }
            default: {
                tgt.setValue((Object)HumanName.NameUse.NULL);
            }
        }
        return tgt;
    }

    public static Meta convertMeta(org.hl7.fhir.dstu3.model.Meta src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Meta tgt = new Meta();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasVersionId()) {
            tgt.setVersionIdElement(VersionConvertor_30_40.convertId(src.getVersionIdElement()));
        }
        if (src.hasLastUpdated()) {
            tgt.setLastUpdatedElement(VersionConvertor_30_40.convertInstant(src.getLastUpdatedElement()));
        }
        for (UriType uriType : src.getProfile()) {
            tgt.addProfile((String)uriType.getValue());
        }
        for (Coding coding : src.getSecurity()) {
            tgt.addSecurity(VersionConvertor_30_40.convertCoding(coding));
        }
        for (Coding coding : src.getTag()) {
            tgt.addTag(VersionConvertor_30_40.convertCoding(coding));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Meta convertMeta(Meta src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Meta tgt = new org.hl7.fhir.dstu3.model.Meta();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasVersionId()) {
            tgt.setVersionIdElement(VersionConvertor_30_40.convertId(src.getVersionIdElement()));
        }
        if (src.hasLastUpdated()) {
            tgt.setLastUpdatedElement(VersionConvertor_30_40.convertInstant(src.getLastUpdatedElement()));
        }
        for (org.hl7.fhir.r4.model.UriType uriType : src.getProfile()) {
            tgt.addProfile((String)uriType.getValue());
        }
        for (org.hl7.fhir.r4.model.Coding coding : src.getSecurity()) {
            tgt.addSecurity(VersionConvertor_30_40.convertCoding(coding));
        }
        for (org.hl7.fhir.r4.model.Coding coding : src.getTag()) {
            tgt.addTag(VersionConvertor_30_40.convertCoding(coding));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.ParameterDefinition convertParameterDefinition(ParameterDefinition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.ParameterDefinition tgt = new org.hl7.fhir.r4.model.ParameterDefinition();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_40.convertCode(src.getNameElement()));
        }
        if (src.hasUse()) {
            tgt.setUseElement(VersionConvertor_30_40.convertParameterUse(src.getUseElement()));
        }
        if (src.hasMin()) {
            tgt.setMinElement(VersionConvertor_30_40.convertInteger(src.getMinElement()));
        }
        if (src.hasMax()) {
            tgt.setMaxElement(VersionConvertor_30_40.convertString(src.getMaxElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentationElement(VersionConvertor_30_40.convertString(src.getDocumentationElement()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(VersionConvertor_30_40.convertCode(src.getTypeElement()));
        }
        if (src.hasProfile()) {
            tgt.setProfile(VersionConvertor_30_40.convertReference(src.getProfile()).getReference());
        }
        return tgt;
    }

    public static ParameterDefinition convertParameterDefinition(org.hl7.fhir.r4.model.ParameterDefinition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ParameterDefinition tgt = new ParameterDefinition();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_40.convertCode(src.getNameElement()));
        }
        if (src.hasUse()) {
            tgt.setUseElement(VersionConvertor_30_40.convertParameterUse(src.getUseElement()));
        }
        if (src.hasMin()) {
            tgt.setMinElement(VersionConvertor_30_40.convertInteger(src.getMinElement()));
        }
        if (src.hasMax()) {
            tgt.setMaxElement(VersionConvertor_30_40.convertString(src.getMaxElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentationElement(VersionConvertor_30_40.convertString(src.getDocumentationElement()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(VersionConvertor_30_40.convertCode(src.getTypeElement()));
        }
        if (src.hasProfile()) {
            tgt.setProfile(new org.hl7.fhir.dstu3.model.Reference(src.getProfile()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Enumeration<ParameterDefinition.ParameterUse> convertParameterUse(Enumeration<ParameterDefinition.ParameterUse> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Enumeration<ParameterDefinition.ParameterUse> tgt = new org.hl7.fhir.r4.model.Enumeration<ParameterDefinition.ParameterUse>(new ParameterDefinition.ParameterUseEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((ParameterDefinition.ParameterUse)((Object)src.getValue())) {
            case IN: {
                tgt.setValue((Object)ParameterDefinition.ParameterUse.IN);
                break;
            }
            case OUT: {
                tgt.setValue((Object)ParameterDefinition.ParameterUse.OUT);
                break;
            }
            default: {
                tgt.setValue((Object)ParameterDefinition.ParameterUse.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<ParameterDefinition.ParameterUse> convertParameterUse(org.hl7.fhir.r4.model.Enumeration<ParameterDefinition.ParameterUse> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ParameterDefinition.ParameterUse> tgt = new Enumeration<ParameterDefinition.ParameterUse>(new ParameterDefinition.ParameterUseEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((ParameterDefinition.ParameterUse)((Object)src.getValue())) {
            case IN: {
                tgt.setValue((Object)ParameterDefinition.ParameterUse.IN);
                break;
            }
            case OUT: {
                tgt.setValue((Object)ParameterDefinition.ParameterUse.OUT);
                break;
            }
            default: {
                tgt.setValue((Object)ParameterDefinition.ParameterUse.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.RelatedArtifact convertRelatedArtifact(RelatedArtifact src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.RelatedArtifact tgt = new org.hl7.fhir.r4.model.RelatedArtifact();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(VersionConvertor_30_40.convertRelatedArtifactType(src.getTypeElement()));
        }
        if (src.hasDisplay()) {
            tgt.setDisplayElement(VersionConvertor_30_40.convertString(src.getDisplayElement()));
        }
        if (src.hasCitation()) {
            tgt.setCitation(src.getCitation());
        }
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        if (src.hasDocument()) {
            tgt.setDocument(VersionConvertor_30_40.convertAttachment(src.getDocument()));
        }
        if (src.hasResource()) {
            tgt.setResourceElement(VersionConvertor_30_40.convertReferenceToCanonical(src.getResource()));
        }
        return tgt;
    }

    public static RelatedArtifact convertRelatedArtifact(org.hl7.fhir.r4.model.RelatedArtifact src) throws FHIRException {
        if (src == null) {
            return null;
        }
        RelatedArtifact tgt = new RelatedArtifact();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(VersionConvertor_30_40.convertRelatedArtifactType(src.getTypeElement()));
        }
        if (src.hasDisplay()) {
            tgt.setDisplayElement(VersionConvertor_30_40.convertString(src.getDisplayElement()));
        }
        if (src.hasCitation()) {
            tgt.setCitation(src.getCitation());
        }
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        if (src.hasDocument()) {
            tgt.setDocument(VersionConvertor_30_40.convertAttachment(src.getDocument()));
        }
        if (src.hasResource()) {
            tgt.setResource(VersionConvertor_30_40.convertCanonicalToReference(src.getResourceElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Enumeration<RelatedArtifact.RelatedArtifactType> convertRelatedArtifactType(Enumeration<RelatedArtifact.RelatedArtifactType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Enumeration<RelatedArtifact.RelatedArtifactType> tgt = new org.hl7.fhir.r4.model.Enumeration<RelatedArtifact.RelatedArtifactType>(new RelatedArtifact.RelatedArtifactTypeEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((RelatedArtifact.RelatedArtifactType)((Object)src.getValue())) {
            case DOCUMENTATION: {
                tgt.setValue((Object)RelatedArtifact.RelatedArtifactType.DOCUMENTATION);
                break;
            }
            case JUSTIFICATION: {
                tgt.setValue((Object)RelatedArtifact.RelatedArtifactType.JUSTIFICATION);
                break;
            }
            case CITATION: {
                tgt.setValue((Object)RelatedArtifact.RelatedArtifactType.CITATION);
                break;
            }
            case PREDECESSOR: {
                tgt.setValue((Object)RelatedArtifact.RelatedArtifactType.PREDECESSOR);
                break;
            }
            case SUCCESSOR: {
                tgt.setValue((Object)RelatedArtifact.RelatedArtifactType.SUCCESSOR);
                break;
            }
            case DERIVEDFROM: {
                tgt.setValue((Object)RelatedArtifact.RelatedArtifactType.DERIVEDFROM);
                break;
            }
            case DEPENDSON: {
                tgt.setValue((Object)RelatedArtifact.RelatedArtifactType.DEPENDSON);
                break;
            }
            case COMPOSEDOF: {
                tgt.setValue((Object)RelatedArtifact.RelatedArtifactType.COMPOSEDOF);
                break;
            }
            default: {
                tgt.setValue((Object)RelatedArtifact.RelatedArtifactType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<RelatedArtifact.RelatedArtifactType> convertRelatedArtifactType(org.hl7.fhir.r4.model.Enumeration<RelatedArtifact.RelatedArtifactType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<RelatedArtifact.RelatedArtifactType> tgt = new Enumeration<RelatedArtifact.RelatedArtifactType>(new RelatedArtifact.RelatedArtifactTypeEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((RelatedArtifact.RelatedArtifactType)((Object)src.getValue())) {
            case DOCUMENTATION: {
                tgt.setValue((Object)RelatedArtifact.RelatedArtifactType.DOCUMENTATION);
                break;
            }
            case JUSTIFICATION: {
                tgt.setValue((Object)RelatedArtifact.RelatedArtifactType.JUSTIFICATION);
                break;
            }
            case CITATION: {
                tgt.setValue((Object)RelatedArtifact.RelatedArtifactType.CITATION);
                break;
            }
            case PREDECESSOR: {
                tgt.setValue((Object)RelatedArtifact.RelatedArtifactType.PREDECESSOR);
                break;
            }
            case SUCCESSOR: {
                tgt.setValue((Object)RelatedArtifact.RelatedArtifactType.SUCCESSOR);
                break;
            }
            case DERIVEDFROM: {
                tgt.setValue((Object)RelatedArtifact.RelatedArtifactType.DERIVEDFROM);
                break;
            }
            case DEPENDSON: {
                tgt.setValue((Object)RelatedArtifact.RelatedArtifactType.DEPENDSON);
                break;
            }
            case COMPOSEDOF: {
                tgt.setValue((Object)RelatedArtifact.RelatedArtifactType.COMPOSEDOF);
                break;
            }
            default: {
                tgt.setValue((Object)RelatedArtifact.RelatedArtifactType.NULL);
            }
        }
        return tgt;
    }

    public static Timing convertTiming(org.hl7.fhir.dstu3.model.Timing src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Timing tgt = new Timing();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        for (org.hl7.fhir.dstu3.model.DateTimeType t : src.getEvent()) {
            tgt.addEvent((Date)t.getValue());
        }
        if (src.hasRepeat()) {
            tgt.setRepeat(VersionConvertor_30_40.convertTimingRepeatComponent(src.getRepeat()));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertCodeableConcept(src.getCode()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Timing convertTiming(Timing src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Timing tgt = new org.hl7.fhir.dstu3.model.Timing();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        for (DateTimeType t : src.getEvent()) {
            tgt.addEvent((Date)t.getValue());
        }
        if (src.hasRepeat()) {
            tgt.setRepeat(VersionConvertor_30_40.convertTimingRepeatComponent(src.getRepeat()));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertCodeableConcept(src.getCode()));
        }
        return tgt;
    }

    public static Timing.TimingRepeatComponent convertTimingRepeatComponent(Timing.TimingRepeatComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Timing.TimingRepeatComponent tgt = new Timing.TimingRepeatComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasBounds()) {
            tgt.setBounds(VersionConvertor_30_40.convertType(src.getBounds()));
        }
        if (src.hasCount()) {
            tgt.setCount(src.getCount());
        }
        if (src.hasCountMax()) {
            tgt.setCountMax(src.getCountMax());
        }
        if (src.hasDuration()) {
            tgt.setDurationElement(VersionConvertor_30_40.convertDecimal(src.getDurationElement()));
        }
        if (src.hasDurationMax()) {
            tgt.setDurationMaxElement(VersionConvertor_30_40.convertDecimal(src.getDurationMaxElement()));
        }
        if (src.hasDurationUnit()) {
            tgt.setDurationUnitElement(VersionConvertor_30_40.convertUnitsOfTime(src.getDurationUnitElement()));
        }
        if (src.hasFrequency()) {
            tgt.setFrequency(src.getFrequency());
        }
        if (src.hasFrequencyMax()) {
            tgt.setFrequencyMax(src.getFrequencyMax());
        }
        if (src.hasPeriod()) {
            tgt.setPeriodElement(VersionConvertor_30_40.convertDecimal(src.getPeriodElement()));
        }
        if (src.hasPeriodMax()) {
            tgt.setPeriodMaxElement(VersionConvertor_30_40.convertDecimal(src.getPeriodMaxElement()));
        }
        if (src.hasPeriodUnit()) {
            tgt.setPeriodUnitElement(VersionConvertor_30_40.convertUnitsOfTime(src.getPeriodUnitElement()));
        }
        tgt.setDayOfWeek(src.getDayOfWeek().stream().map(VersionConvertor_30_40::convertDayOfWeek).collect(Collectors.toList()));
        for (org.hl7.fhir.dstu3.model.TimeType t : src.getTimeOfDay()) {
            tgt.addTimeOfDay((String)t.getValue());
        }
        tgt.setWhen(src.getWhen().stream().map(VersionConvertor_30_40::convertEventTiming).collect(Collectors.toList()));
        if (src.hasOffset()) {
            tgt.setOffsetElement(VersionConvertor_30_40.convertUnsignedInt(src.getOffsetElement()));
        }
        return tgt;
    }

    public static Timing.TimingRepeatComponent convertTimingRepeatComponent(Timing.TimingRepeatComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Timing.TimingRepeatComponent tgt = new Timing.TimingRepeatComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasBounds()) {
            tgt.setBounds(VersionConvertor_30_40.convertType(src.getBounds()));
        }
        if (src.hasCount()) {
            tgt.setCount(src.getCount());
        }
        if (src.hasCountMax()) {
            tgt.setCountMax(src.getCountMax());
        }
        if (src.hasDuration()) {
            tgt.setDurationElement(VersionConvertor_30_40.convertDecimal(src.getDurationElement()));
        }
        if (src.hasDurationMax()) {
            tgt.setDurationMaxElement(VersionConvertor_30_40.convertDecimal(src.getDurationMaxElement()));
        }
        if (src.hasDurationUnit()) {
            tgt.setDurationUnitElement(VersionConvertor_30_40.convertUnitsOfTime(src.getDurationUnitElement()));
        }
        if (src.hasFrequency()) {
            tgt.setFrequency(src.getFrequency());
        }
        if (src.hasFrequencyMax()) {
            tgt.setFrequencyMax(src.getFrequencyMax());
        }
        if (src.hasPeriod()) {
            tgt.setPeriodElement(VersionConvertor_30_40.convertDecimal(src.getPeriodElement()));
        }
        if (src.hasPeriodMax()) {
            tgt.setPeriodMaxElement(VersionConvertor_30_40.convertDecimal(src.getPeriodMaxElement()));
        }
        if (src.hasPeriodUnit()) {
            tgt.setPeriodUnitElement(VersionConvertor_30_40.convertUnitsOfTime(src.getPeriodUnitElement()));
        }
        tgt.setDayOfWeek(src.getDayOfWeek().stream().map(VersionConvertor_30_40::convertDayOfWeek).collect(Collectors.toList()));
        for (TimeType t : src.getTimeOfDay()) {
            tgt.addTimeOfDay((String)t.getValue());
        }
        tgt.setWhen(src.getWhen().stream().map(VersionConvertor_30_40::convertEventTiming).collect(Collectors.toList()));
        if (src.hasOffset()) {
            tgt.setOffsetElement(VersionConvertor_30_40.convertUnsignedInt(src.getOffsetElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Enumeration<Timing.UnitsOfTime> convertUnitsOfTime(Enumeration<Timing.UnitsOfTime> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Enumeration<Timing.UnitsOfTime> tgt = new org.hl7.fhir.r4.model.Enumeration<Timing.UnitsOfTime>(new Timing.UnitsOfTimeEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((Timing.UnitsOfTime)((Object)src.getValue())) {
            case S: {
                tgt.setValue((Object)Timing.UnitsOfTime.S);
                break;
            }
            case MIN: {
                tgt.setValue((Object)Timing.UnitsOfTime.MIN);
                break;
            }
            case H: {
                tgt.setValue((Object)Timing.UnitsOfTime.H);
                break;
            }
            case D: {
                tgt.setValue((Object)Timing.UnitsOfTime.D);
                break;
            }
            case WK: {
                tgt.setValue((Object)Timing.UnitsOfTime.WK);
                break;
            }
            case MO: {
                tgt.setValue((Object)Timing.UnitsOfTime.MO);
                break;
            }
            case A: {
                tgt.setValue((Object)Timing.UnitsOfTime.A);
                break;
            }
            default: {
                tgt.setValue((Object)Timing.UnitsOfTime.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Timing.UnitsOfTime> convertUnitsOfTime(org.hl7.fhir.r4.model.Enumeration<Timing.UnitsOfTime> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Timing.UnitsOfTime> tgt = new Enumeration<Timing.UnitsOfTime>(new Timing.UnitsOfTimeEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((Timing.UnitsOfTime)((Object)src.getValue())) {
            case S: {
                tgt.setValue((Object)Timing.UnitsOfTime.S);
                break;
            }
            case MIN: {
                tgt.setValue((Object)Timing.UnitsOfTime.MIN);
                break;
            }
            case H: {
                tgt.setValue((Object)Timing.UnitsOfTime.H);
                break;
            }
            case D: {
                tgt.setValue((Object)Timing.UnitsOfTime.D);
                break;
            }
            case WK: {
                tgt.setValue((Object)Timing.UnitsOfTime.WK);
                break;
            }
            case MO: {
                tgt.setValue((Object)Timing.UnitsOfTime.MO);
                break;
            }
            case A: {
                tgt.setValue((Object)Timing.UnitsOfTime.A);
                break;
            }
            default: {
                tgt.setValue((Object)Timing.UnitsOfTime.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Enumeration<Timing.DayOfWeek> convertDayOfWeek(Enumeration<Timing.DayOfWeek> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Enumeration<Timing.DayOfWeek> tgt = new org.hl7.fhir.r4.model.Enumeration<Timing.DayOfWeek>(new Timing.DayOfWeekEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((Timing.DayOfWeek)((Object)src.getValue())) {
            case MON: {
                tgt.setValue((Object)Timing.DayOfWeek.MON);
                break;
            }
            case TUE: {
                tgt.setValue((Object)Timing.DayOfWeek.TUE);
                break;
            }
            case WED: {
                tgt.setValue((Object)Timing.DayOfWeek.WED);
                break;
            }
            case THU: {
                tgt.setValue((Object)Timing.DayOfWeek.THU);
                break;
            }
            case FRI: {
                tgt.setValue((Object)Timing.DayOfWeek.FRI);
                break;
            }
            case SAT: {
                tgt.setValue((Object)Timing.DayOfWeek.SAT);
                break;
            }
            case SUN: {
                tgt.setValue((Object)Timing.DayOfWeek.SUN);
                break;
            }
            default: {
                tgt.setValue((Object)Timing.DayOfWeek.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Timing.DayOfWeek> convertDayOfWeek(org.hl7.fhir.r4.model.Enumeration<Timing.DayOfWeek> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Timing.DayOfWeek> tgt = new Enumeration<Timing.DayOfWeek>(new Timing.DayOfWeekEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((Timing.DayOfWeek)((Object)src.getValue())) {
            case MON: {
                tgt.setValue((Object)Timing.DayOfWeek.MON);
                break;
            }
            case TUE: {
                tgt.setValue((Object)Timing.DayOfWeek.TUE);
                break;
            }
            case WED: {
                tgt.setValue((Object)Timing.DayOfWeek.WED);
                break;
            }
            case THU: {
                tgt.setValue((Object)Timing.DayOfWeek.THU);
                break;
            }
            case FRI: {
                tgt.setValue((Object)Timing.DayOfWeek.FRI);
                break;
            }
            case SAT: {
                tgt.setValue((Object)Timing.DayOfWeek.SAT);
                break;
            }
            case SUN: {
                tgt.setValue((Object)Timing.DayOfWeek.SUN);
                break;
            }
            default: {
                tgt.setValue((Object)Timing.DayOfWeek.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Enumeration<Timing.EventTiming> convertEventTiming(Enumeration<Timing.EventTiming> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Enumeration<Timing.EventTiming> tgt = new org.hl7.fhir.r4.model.Enumeration<Timing.EventTiming>(new Timing.EventTimingEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((Timing.EventTiming)((Object)src.getValue())) {
            case MORN: {
                tgt.setValue((Object)Timing.EventTiming.MORN);
                break;
            }
            case AFT: {
                tgt.setValue((Object)Timing.EventTiming.AFT);
                break;
            }
            case EVE: {
                tgt.setValue((Object)Timing.EventTiming.EVE);
                break;
            }
            case NIGHT: {
                tgt.setValue((Object)Timing.EventTiming.NIGHT);
                break;
            }
            case PHS: {
                tgt.setValue((Object)Timing.EventTiming.PHS);
                break;
            }
            case HS: {
                tgt.setValue((Object)Timing.EventTiming.HS);
                break;
            }
            case WAKE: {
                tgt.setValue((Object)Timing.EventTiming.WAKE);
                break;
            }
            case C: {
                tgt.setValue((Object)Timing.EventTiming.C);
                break;
            }
            case CM: {
                tgt.setValue((Object)Timing.EventTiming.CM);
                break;
            }
            case CD: {
                tgt.setValue((Object)Timing.EventTiming.CD);
                break;
            }
            case CV: {
                tgt.setValue((Object)Timing.EventTiming.CV);
                break;
            }
            case AC: {
                tgt.setValue((Object)Timing.EventTiming.AC);
                break;
            }
            case ACM: {
                tgt.setValue((Object)Timing.EventTiming.ACM);
                break;
            }
            case ACD: {
                tgt.setValue((Object)Timing.EventTiming.ACD);
                break;
            }
            case ACV: {
                tgt.setValue((Object)Timing.EventTiming.ACV);
                break;
            }
            case PC: {
                tgt.setValue((Object)Timing.EventTiming.PC);
                break;
            }
            case PCM: {
                tgt.setValue((Object)Timing.EventTiming.PCM);
                break;
            }
            case PCD: {
                tgt.setValue((Object)Timing.EventTiming.PCD);
                break;
            }
            case PCV: {
                tgt.setValue((Object)Timing.EventTiming.PCV);
                break;
            }
            default: {
                tgt.setValue((Object)Timing.EventTiming.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Timing.EventTiming> convertEventTiming(org.hl7.fhir.r4.model.Enumeration<Timing.EventTiming> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Timing.EventTiming> tgt = new Enumeration<Timing.EventTiming>(new Timing.EventTimingEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((Timing.EventTiming)((Object)src.getValue())) {
            case MORN: {
                tgt.setValue((Object)Timing.EventTiming.MORN);
                break;
            }
            case AFT: {
                tgt.setValue((Object)Timing.EventTiming.AFT);
                break;
            }
            case EVE: {
                tgt.setValue((Object)Timing.EventTiming.EVE);
                break;
            }
            case NIGHT: {
                tgt.setValue((Object)Timing.EventTiming.NIGHT);
                break;
            }
            case PHS: {
                tgt.setValue((Object)Timing.EventTiming.PHS);
                break;
            }
            case HS: {
                tgt.setValue((Object)Timing.EventTiming.HS);
                break;
            }
            case WAKE: {
                tgt.setValue((Object)Timing.EventTiming.WAKE);
                break;
            }
            case C: {
                tgt.setValue((Object)Timing.EventTiming.C);
                break;
            }
            case CM: {
                tgt.setValue((Object)Timing.EventTiming.CM);
                break;
            }
            case CD: {
                tgt.setValue((Object)Timing.EventTiming.CD);
                break;
            }
            case CV: {
                tgt.setValue((Object)Timing.EventTiming.CV);
                break;
            }
            case AC: {
                tgt.setValue((Object)Timing.EventTiming.AC);
                break;
            }
            case ACM: {
                tgt.setValue((Object)Timing.EventTiming.ACM);
                break;
            }
            case ACD: {
                tgt.setValue((Object)Timing.EventTiming.ACD);
                break;
            }
            case ACV: {
                tgt.setValue((Object)Timing.EventTiming.ACV);
                break;
            }
            case PC: {
                tgt.setValue((Object)Timing.EventTiming.PC);
                break;
            }
            case PCM: {
                tgt.setValue((Object)Timing.EventTiming.PCM);
                break;
            }
            case PCD: {
                tgt.setValue((Object)Timing.EventTiming.PCD);
                break;
            }
            case PCV: {
                tgt.setValue((Object)Timing.EventTiming.PCV);
                break;
            }
            default: {
                tgt.setValue((Object)Timing.EventTiming.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.UsageContext convertUsageContext(UsageContext src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.UsageContext tgt = new org.hl7.fhir.r4.model.UsageContext();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertCoding(src.getCode()));
        }
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_30_40.convertType(src.getValue()));
        }
        return tgt;
    }

    public static UsageContext convertUsageContext(org.hl7.fhir.r4.model.UsageContext src) throws FHIRException {
        if (src == null) {
            return null;
        }
        UsageContext tgt = new UsageContext();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertCoding(src.getCode()));
        }
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_30_40.convertType(src.getValue()));
        }
        return tgt;
    }

    public static Quantity convertSimpleQuantity(SimpleQuantity src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.SimpleQuantity tgt = new org.hl7.fhir.r4.model.SimpleQuantity();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_30_40.convertDecimal(src.getValueElement()));
        }
        if (src.hasComparator()) {
            tgt.setComparatorElement(VersionConvertor_30_40.convertQuantityComparator(src.getComparatorElement()));
        }
        if (src.hasUnit()) {
            tgt.setUnitElement(VersionConvertor_30_40.convertString(src.getUnitElement()));
        }
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_30_40.convertUri(src.getSystemElement()));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_30_40.convertCode(src.getCodeElement()));
        }
        return tgt;
    }

    public static SimpleQuantity convertSimpleQuantity(Quantity src) throws FHIRException {
        if (src == null) {
            return null;
        }
        SimpleQuantity tgt = new SimpleQuantity();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_30_40.convertDecimal(src.getValueElement()));
        }
        if (src.hasComparator()) {
            tgt.setComparatorElement(VersionConvertor_30_40.convertQuantityComparator(src.getComparatorElement()));
        }
        if (src.hasUnit()) {
            tgt.setUnitElement(VersionConvertor_30_40.convertString(src.getUnitElement()));
        }
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_30_40.convertUri(src.getSystemElement()));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_30_40.convertCode(src.getCodeElement()));
        }
        return tgt;
    }

    public static TriggerDefinition convertTriggerDefinition(org.hl7.fhir.dstu3.model.TriggerDefinition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TriggerDefinition tgt = new TriggerDefinition();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(VersionConvertor_30_40.convertTriggerType(src.getTypeElement()));
        }
        if (src.hasEventName()) {
            tgt.setNameElement(VersionConvertor_30_40.convertString(src.getEventNameElement()));
        }
        if (src.hasEventTiming()) {
            tgt.setTiming(VersionConvertor_30_40.convertType(src.getEventTiming()));
        }
        if (src.hasEventData()) {
            tgt.addData(VersionConvertor_30_40.convertDataRequirement(src.getEventData()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.TriggerDefinition convertTriggerDefinition(TriggerDefinition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.TriggerDefinition tgt = new org.hl7.fhir.dstu3.model.TriggerDefinition();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(VersionConvertor_30_40.convertTriggerType(src.getTypeElement()));
        }
        if (src.hasName()) {
            tgt.setEventNameElement(VersionConvertor_30_40.convertString(src.getNameElement()));
        }
        if (src.hasTiming()) {
            tgt.setEventTiming(VersionConvertor_30_40.convertType(src.getTiming()));
        }
        if (src.hasData()) {
            tgt.setEventData(VersionConvertor_30_40.convertDataRequirement(src.getDataFirstRep()));
        }
        return tgt;
    }

    public static DataRequirement convertDataRequirement(org.hl7.fhir.dstu3.model.DataRequirement src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DataRequirement tgt = new DataRequirement();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(VersionConvertor_30_40.convertCode(src.getTypeElement()));
        }
        for (UriType uriType : src.getProfile()) {
            tgt.addProfile((String)uriType.getValue());
        }
        for (org.hl7.fhir.dstu3.model.StringType stringType : src.getMustSupport()) {
            tgt.addMustSupport((String)stringType.getValue());
        }
        for (DataRequirement.DataRequirementCodeFilterComponent dataRequirementCodeFilterComponent : src.getCodeFilter()) {
            tgt.addCodeFilter(VersionConvertor_30_40.convertDataRequirementCodeFilterComponent(dataRequirementCodeFilterComponent));
        }
        for (DataRequirement.DataRequirementDateFilterComponent dataRequirementDateFilterComponent : src.getDateFilter()) {
            tgt.addDateFilter(VersionConvertor_30_40.convertDataRequirementDateFilterComponent(dataRequirementDateFilterComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.DataRequirement convertDataRequirement(DataRequirement src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.DataRequirement tgt = new org.hl7.fhir.dstu3.model.DataRequirement();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(VersionConvertor_30_40.convertCode(src.getTypeElement()));
        }
        for (org.hl7.fhir.r4.model.UriType uriType : src.getProfile()) {
            tgt.addProfile((String)uriType.getValue());
        }
        for (StringType stringType : src.getMustSupport()) {
            tgt.addMustSupport((String)stringType.getValue());
        }
        for (DataRequirement.DataRequirementCodeFilterComponent dataRequirementCodeFilterComponent : src.getCodeFilter()) {
            tgt.addCodeFilter(VersionConvertor_30_40.convertDataRequirementCodeFilterComponent(dataRequirementCodeFilterComponent));
        }
        for (DataRequirement.DataRequirementDateFilterComponent dataRequirementDateFilterComponent : src.getDateFilter()) {
            tgt.addDateFilter(VersionConvertor_30_40.convertDataRequirementDateFilterComponent(dataRequirementDateFilterComponent));
        }
        return tgt;
    }

    public static DataRequirement.DataRequirementCodeFilterComponent convertDataRequirementCodeFilterComponent(DataRequirement.DataRequirementCodeFilterComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DataRequirement.DataRequirementCodeFilterComponent tgt = new DataRequirement.DataRequirementCodeFilterComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasPath()) {
            tgt.setPathElement(VersionConvertor_30_40.convertString(src.getPathElement()));
        }
        if (src.hasValueSet()) {
            org.hl7.fhir.r4.model.Type t = VersionConvertor_30_40.convertType(src.getValueSet());
            if (t instanceof Reference) {
                tgt.setValueSet(((Reference)t).getReference());
            } else {
                tgt.setValueSet(t.primitiveValue());
            }
            tgt.setValueSet(VersionConvertorConstants.refToVS(tgt.getValueSet()));
        }
        for (CodeType codeType : src.getValueCode()) {
            tgt.addCode(VersionConvertor_30_40.convertCoding(codeType));
        }
        for (Coding coding : src.getValueCoding()) {
            tgt.addCode(VersionConvertor_30_40.convertCoding(coding));
        }
        for (CodeableConcept codeableConcept : src.getValueCodeableConcept()) {
            tgt.addCode(VersionConvertor_30_40.convertCoding(codeableConcept));
        }
        return tgt;
    }

    public static DataRequirement.DataRequirementCodeFilterComponent convertDataRequirementCodeFilterComponent(DataRequirement.DataRequirementCodeFilterComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DataRequirement.DataRequirementCodeFilterComponent tgt = new DataRequirement.DataRequirementCodeFilterComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasPath()) {
            tgt.setPathElement(VersionConvertor_30_40.convertString(src.getPathElement()));
        }
        if (src.hasValueSet()) {
            String vsr = VersionConvertorConstants.vsToRef(src.getValueSet());
            if (vsr != null) {
                tgt.setValueSet(new UriType(vsr));
            } else {
                tgt.setValueSet(new org.hl7.fhir.dstu3.model.Reference(src.getValueSet()));
            }
        }
        for (org.hl7.fhir.r4.model.Coding t : src.getCode()) {
            tgt.addValueCoding(VersionConvertor_30_40.convertCoding(t));
        }
        return tgt;
    }

    public static DataRequirement.DataRequirementDateFilterComponent convertDataRequirementDateFilterComponent(DataRequirement.DataRequirementDateFilterComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DataRequirement.DataRequirementDateFilterComponent tgt = new DataRequirement.DataRequirementDateFilterComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasPath()) {
            tgt.setPathElement(VersionConvertor_30_40.convertString(src.getPathElement()));
        }
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_30_40.convertType(src.getValue()));
        }
        return tgt;
    }

    public static DataRequirement.DataRequirementDateFilterComponent convertDataRequirementDateFilterComponent(DataRequirement.DataRequirementDateFilterComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DataRequirement.DataRequirementDateFilterComponent tgt = new DataRequirement.DataRequirementDateFilterComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasPath()) {
            tgt.setPathElement(VersionConvertor_30_40.convertString(src.getPathElement()));
        }
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_30_40.convertType(src.getValue()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Enumeration<TriggerDefinition.TriggerType> convertTriggerType(Enumeration<TriggerDefinition.TriggerType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Enumeration<TriggerDefinition.TriggerType> tgt = new org.hl7.fhir.r4.model.Enumeration<TriggerDefinition.TriggerType>(new TriggerDefinition.TriggerTypeEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((TriggerDefinition.TriggerType)((Object)src.getValue())) {
            case NAMEDEVENT: {
                tgt.setValue((Object)TriggerDefinition.TriggerType.NAMEDEVENT);
                break;
            }
            case PERIODIC: {
                tgt.setValue((Object)TriggerDefinition.TriggerType.PERIODIC);
                break;
            }
            case DATAADDED: {
                tgt.setValue((Object)TriggerDefinition.TriggerType.DATAADDED);
                break;
            }
            case DATAMODIFIED: {
                tgt.setValue((Object)TriggerDefinition.TriggerType.DATAMODIFIED);
                break;
            }
            case DATAREMOVED: {
                tgt.setValue((Object)TriggerDefinition.TriggerType.DATAREMOVED);
                break;
            }
            case DATAACCESSED: {
                tgt.setValue((Object)TriggerDefinition.TriggerType.DATAACCESSED);
                break;
            }
            case DATAACCESSENDED: {
                tgt.setValue((Object)TriggerDefinition.TriggerType.DATAACCESSENDED);
                break;
            }
            default: {
                tgt.setValue((Object)TriggerDefinition.TriggerType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<TriggerDefinition.TriggerType> convertTriggerType(org.hl7.fhir.r4.model.Enumeration<TriggerDefinition.TriggerType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<TriggerDefinition.TriggerType> tgt = new Enumeration<TriggerDefinition.TriggerType>(new TriggerDefinition.TriggerTypeEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((TriggerDefinition.TriggerType)((Object)src.getValue())) {
            case NAMEDEVENT: {
                tgt.setValue((Object)TriggerDefinition.TriggerType.NAMEDEVENT);
                break;
            }
            case PERIODIC: {
                tgt.setValue((Object)TriggerDefinition.TriggerType.PERIODIC);
                break;
            }
            case DATAADDED: {
                tgt.setValue((Object)TriggerDefinition.TriggerType.DATAADDED);
                break;
            }
            case DATAMODIFIED: {
                tgt.setValue((Object)TriggerDefinition.TriggerType.DATAMODIFIED);
                break;
            }
            case DATAREMOVED: {
                tgt.setValue((Object)TriggerDefinition.TriggerType.DATAREMOVED);
                break;
            }
            case DATAACCESSED: {
                tgt.setValue((Object)TriggerDefinition.TriggerType.DATAACCESSED);
                break;
            }
            case DATAACCESSENDED: {
                tgt.setValue((Object)TriggerDefinition.TriggerType.DATAACCESSENDED);
                break;
            }
            default: {
                tgt.setValue((Object)TriggerDefinition.TriggerType.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Type convertType(Type src) throws FHIRException {
        if (src == null) {
            return null;
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Base64BinaryType) {
            return VersionConvertor_30_40.convertBase64Binary((org.hl7.fhir.dstu3.model.Base64BinaryType)src);
        }
        if (src instanceof BooleanType) {
            return VersionConvertor_30_40.convertBoolean((BooleanType)src);
        }
        if (src instanceof CodeType) {
            return VersionConvertor_30_40.convertCode((CodeType)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.DateType) {
            return VersionConvertor_30_40.convertDate((org.hl7.fhir.dstu3.model.DateType)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.DateTimeType) {
            return VersionConvertor_30_40.convertDateTime((org.hl7.fhir.dstu3.model.DateTimeType)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.DecimalType) {
            return VersionConvertor_30_40.convertDecimal((org.hl7.fhir.dstu3.model.DecimalType)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.IdType) {
            return VersionConvertor_30_40.convertId((org.hl7.fhir.dstu3.model.IdType)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.InstantType) {
            return VersionConvertor_30_40.convertInstant((org.hl7.fhir.dstu3.model.InstantType)src);
        }
        if (src instanceof IntegerType) {
            return VersionConvertor_30_40.convertInteger((IntegerType)src);
        }
        if (src instanceof MarkdownType) {
            return VersionConvertor_30_40.convertMarkdown((MarkdownType)src);
        }
        if (src instanceof OidType) {
            return VersionConvertor_30_40.convertOid((OidType)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.PositiveIntType) {
            return VersionConvertor_30_40.convertPositiveInt((org.hl7.fhir.dstu3.model.PositiveIntType)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.StringType) {
            return VersionConvertor_30_40.convertString((org.hl7.fhir.dstu3.model.StringType)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.TimeType) {
            return VersionConvertor_30_40.convertTime((org.hl7.fhir.dstu3.model.TimeType)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.UnsignedIntType) {
            return VersionConvertor_30_40.convertUnsignedInt((org.hl7.fhir.dstu3.model.UnsignedIntType)src);
        }
        if (src instanceof UriType) {
            return VersionConvertor_30_40.convertUri((UriType)src);
        }
        if (src instanceof UuidType) {
            return VersionConvertor_30_40.convertUuid((UuidType)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Extension) {
            return VersionConvertor_30_40.convertExtension((org.hl7.fhir.dstu3.model.Extension)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Narrative) {
            return VersionConvertor_30_40.convertNarrative((org.hl7.fhir.dstu3.model.Narrative)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Age) {
            return VersionConvertor_30_40.convertAge((org.hl7.fhir.dstu3.model.Age)src);
        }
        if (src instanceof Annotation) {
            return VersionConvertor_30_40.convertAnnotation((Annotation)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Attachment) {
            return VersionConvertor_30_40.convertAttachment((org.hl7.fhir.dstu3.model.Attachment)src);
        }
        if (src instanceof CodeableConcept) {
            return VersionConvertor_30_40.convertCodeableConcept((CodeableConcept)src);
        }
        if (src instanceof Coding) {
            return VersionConvertor_30_40.convertCoding((Coding)src);
        }
        if (src instanceof Count) {
            return VersionConvertor_30_40.convertCount((Count)src);
        }
        if (src instanceof Distance) {
            return VersionConvertor_30_40.convertDistance((Distance)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Duration) {
            return VersionConvertor_30_40.convertDuration((org.hl7.fhir.dstu3.model.Duration)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Identifier) {
            return VersionConvertor_30_40.convertIdentifier((org.hl7.fhir.dstu3.model.Identifier)src);
        }
        if (src instanceof Money) {
            return VersionConvertor_30_40.convertMoney((Money)src);
        }
        if (src instanceof Period) {
            return VersionConvertor_30_40.convertPeriod((Period)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Quantity) {
            return VersionConvertor_30_40.convertQuantity((org.hl7.fhir.dstu3.model.Quantity)src);
        }
        if (src instanceof Range) {
            return VersionConvertor_30_40.convertRange((Range)src);
        }
        if (src instanceof Ratio) {
            return VersionConvertor_30_40.convertRatio((Ratio)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Reference) {
            return VersionConvertor_30_40.convertReference((org.hl7.fhir.dstu3.model.Reference)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.SampledData) {
            return VersionConvertor_30_40.convertSampledData((org.hl7.fhir.dstu3.model.SampledData)src);
        }
        if (src instanceof Signature) {
            return VersionConvertor_30_40.convertSignature((Signature)src);
        }
        if (src instanceof Address) {
            return VersionConvertor_30_40.convertAddress((Address)src);
        }
        if (src instanceof ContactDetail) {
            return VersionConvertor_30_40.convertContactDetail((ContactDetail)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.ContactPoint) {
            return VersionConvertor_30_40.convertContactPoint((org.hl7.fhir.dstu3.model.ContactPoint)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Contributor) {
            return VersionConvertor_30_40.convertContributor((org.hl7.fhir.dstu3.model.Contributor)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Dosage) {
            return VersionConvertor_30_40.convertDosage((org.hl7.fhir.dstu3.model.Dosage)src);
        }
        if (src instanceof HumanName) {
            return VersionConvertor_30_40.convertHumanName((HumanName)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Meta) {
            return VersionConvertor_30_40.convertMeta((org.hl7.fhir.dstu3.model.Meta)src);
        }
        if (src instanceof ParameterDefinition) {
            return VersionConvertor_30_40.convertParameterDefinition((ParameterDefinition)src);
        }
        if (src instanceof RelatedArtifact) {
            return VersionConvertor_30_40.convertRelatedArtifact((RelatedArtifact)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Timing) {
            return VersionConvertor_30_40.convertTiming((org.hl7.fhir.dstu3.model.Timing)src);
        }
        if (src instanceof UsageContext) {
            return VersionConvertor_30_40.convertUsageContext((UsageContext)src);
        }
        if (src instanceof ElementDefinition) {
            return VersionConvertor_30_40.convertElementDefinition((ElementDefinition)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.DataRequirement) {
            return VersionConvertor_30_40.convertDataRequirement((org.hl7.fhir.dstu3.model.DataRequirement)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.TriggerDefinition) {
            return VersionConvertor_30_40.convertTriggerDefinition((org.hl7.fhir.dstu3.model.TriggerDefinition)src);
        }
        throw new FHIRException("Unknown type " + src.fhirType());
    }

    public static Type convertType(org.hl7.fhir.r4.model.Type src) throws FHIRException {
        if (src == null) {
            return null;
        }
        if (src instanceof Base64BinaryType) {
            return VersionConvertor_30_40.convertBase64Binary((Base64BinaryType)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.BooleanType) {
            return VersionConvertor_30_40.convertBoolean((org.hl7.fhir.r4.model.BooleanType)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.CodeType) {
            return VersionConvertor_30_40.convertCode((org.hl7.fhir.r4.model.CodeType)src);
        }
        if (src instanceof DateType) {
            return VersionConvertor_30_40.convertDate((DateType)src);
        }
        if (src instanceof DateTimeType) {
            return VersionConvertor_30_40.convertDateTime((DateTimeType)src);
        }
        if (src instanceof DecimalType) {
            return VersionConvertor_30_40.convertDecimal((DecimalType)src);
        }
        if (src instanceof IdType) {
            return VersionConvertor_30_40.convertId((IdType)src);
        }
        if (src instanceof InstantType) {
            return VersionConvertor_30_40.convertInstant((InstantType)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.IntegerType) {
            return VersionConvertor_30_40.convertInteger((org.hl7.fhir.r4.model.IntegerType)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.MarkdownType) {
            return VersionConvertor_30_40.convertMarkdown((org.hl7.fhir.r4.model.MarkdownType)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.OidType) {
            return VersionConvertor_30_40.convertOid((org.hl7.fhir.r4.model.OidType)src);
        }
        if (src instanceof PositiveIntType) {
            return VersionConvertor_30_40.convertPositiveInt((PositiveIntType)src);
        }
        if (src instanceof StringType) {
            return VersionConvertor_30_40.convertString((StringType)src);
        }
        if (src instanceof TimeType) {
            return VersionConvertor_30_40.convertTime((TimeType)src);
        }
        if (src instanceof UnsignedIntType) {
            return VersionConvertor_30_40.convertUnsignedInt((UnsignedIntType)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.UriType) {
            return VersionConvertor_30_40.convertUri((org.hl7.fhir.r4.model.UriType)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.UuidType) {
            return VersionConvertor_30_40.convertUuid((org.hl7.fhir.r4.model.UuidType)src);
        }
        if (src instanceof Extension) {
            return VersionConvertor_30_40.convertExtension((Extension)src);
        }
        if (src instanceof Narrative) {
            return VersionConvertor_30_40.convertNarrative((Narrative)src);
        }
        if (src instanceof Age) {
            return VersionConvertor_30_40.convertAge((Age)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Annotation) {
            return VersionConvertor_30_40.convertAnnotation((org.hl7.fhir.r4.model.Annotation)src);
        }
        if (src instanceof Attachment) {
            return VersionConvertor_30_40.convertAttachment((Attachment)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.CodeableConcept) {
            return VersionConvertor_30_40.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Coding) {
            return VersionConvertor_30_40.convertCoding((org.hl7.fhir.r4.model.Coding)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Count) {
            return VersionConvertor_30_40.convertCount((org.hl7.fhir.r4.model.Count)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Distance) {
            return VersionConvertor_30_40.convertDistance((org.hl7.fhir.r4.model.Distance)src);
        }
        if (src instanceof Duration) {
            return VersionConvertor_30_40.convertDuration((Duration)src);
        }
        if (src instanceof Identifier) {
            return VersionConvertor_30_40.convertIdentifier((Identifier)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Money) {
            return VersionConvertor_30_40.convertMoney((org.hl7.fhir.r4.model.Money)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Period) {
            return VersionConvertor_30_40.convertPeriod((org.hl7.fhir.r4.model.Period)src);
        }
        if (src instanceof Quantity) {
            return VersionConvertor_30_40.convertQuantity((Quantity)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Range) {
            return VersionConvertor_30_40.convertRange((org.hl7.fhir.r4.model.Range)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Ratio) {
            return VersionConvertor_30_40.convertRatio((org.hl7.fhir.r4.model.Ratio)src);
        }
        if (src instanceof Reference) {
            return VersionConvertor_30_40.convertReference((Reference)src);
        }
        if (src instanceof SampledData) {
            return VersionConvertor_30_40.convertSampledData((SampledData)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Signature) {
            return VersionConvertor_30_40.convertSignature((org.hl7.fhir.r4.model.Signature)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Address) {
            return VersionConvertor_30_40.convertAddress((org.hl7.fhir.r4.model.Address)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.ContactDetail) {
            return VersionConvertor_30_40.convertContactDetail((org.hl7.fhir.r4.model.ContactDetail)src);
        }
        if (src instanceof ContactPoint) {
            return VersionConvertor_30_40.convertContactPoint((ContactPoint)src);
        }
        if (src instanceof Contributor) {
            return VersionConvertor_30_40.convertContributor((Contributor)src);
        }
        if (src instanceof Dosage) {
            return VersionConvertor_30_40.convertDosage((Dosage)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.HumanName) {
            return VersionConvertor_30_40.convertHumanName((org.hl7.fhir.r4.model.HumanName)src);
        }
        if (src instanceof Meta) {
            return VersionConvertor_30_40.convertMeta((Meta)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.ParameterDefinition) {
            return VersionConvertor_30_40.convertParameterDefinition((org.hl7.fhir.r4.model.ParameterDefinition)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.RelatedArtifact) {
            return VersionConvertor_30_40.convertRelatedArtifact((org.hl7.fhir.r4.model.RelatedArtifact)src);
        }
        if (src instanceof Timing) {
            return VersionConvertor_30_40.convertTiming((Timing)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.UsageContext) {
            return VersionConvertor_30_40.convertUsageContext((org.hl7.fhir.r4.model.UsageContext)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.ElementDefinition) {
            return VersionConvertor_30_40.convertElementDefinition((org.hl7.fhir.r4.model.ElementDefinition)src);
        }
        if (src instanceof DataRequirement) {
            return VersionConvertor_30_40.convertDataRequirement((DataRequirement)src);
        }
        if (src instanceof TriggerDefinition) {
            return VersionConvertor_30_40.convertTriggerDefinition((TriggerDefinition)src);
        }
        throw new FHIRException("Unknown type " + src.fhirType());
    }

    public static boolean isExemptExtension(String url, String[] extensionsToIgnore) {
        boolean ok = false;
        for (String s2 : extensionsToIgnore) {
            if (!s2.equals(url)) continue;
            ok = true;
        }
        return ok;
    }

    public static void copyDomainResource(DomainResource src, org.hl7.fhir.r4.model.DomainResource tgt, String ... extensionsToIgnore) throws FHIRException {
        VersionConvertor_30_40.copyResource(src, tgt);
        if (src.hasText()) {
            tgt.setText(VersionConvertor_30_40.convertNarrative(src.getText()));
        }
        for (org.hl7.fhir.dstu3.model.Resource t1 : src.getContained()) {
            tgt.addContained(VersionConvertor_30_40.convertResource(t1, false));
        }
        for (org.hl7.fhir.dstu3.model.Extension t2 : src.getExtension()) {
            if (VersionConvertor_30_40.isExemptExtension(t2.getUrl(), extensionsToIgnore)) continue;
            tgt.addExtension(VersionConvertor_30_40.convertExtension(t2));
        }
        for (org.hl7.fhir.dstu3.model.Extension t3 : src.getModifierExtension()) {
            if (VersionConvertor_30_40.isExemptExtension(t3.getUrl(), extensionsToIgnore)) continue;
            tgt.addModifierExtension(VersionConvertor_30_40.convertExtension(t3));
        }
    }

    public static void copyDomainResource(org.hl7.fhir.r4.model.DomainResource src, DomainResource tgt, String ... extensionsToIgnore) throws FHIRException {
        VersionConvertor_30_40.copyResource(src, tgt);
        if (src.hasText()) {
            tgt.setText(VersionConvertor_30_40.convertNarrative(src.getText()));
        }
        for (Resource t1 : src.getContained()) {
            tgt.addContained(VersionConvertor_30_40.convertResource(t1, false));
        }
        for (Extension t2 : src.getExtension()) {
            if (VersionConvertor_30_40.isExemptExtension(t2.getUrl(), extensionsToIgnore)) continue;
            tgt.addExtension(VersionConvertor_30_40.convertExtension(t2));
        }
        for (Extension t3 : src.getModifierExtension()) {
            if (VersionConvertor_30_40.isExemptExtension(t3.getUrl(), extensionsToIgnore)) continue;
            tgt.addModifierExtension(VersionConvertor_30_40.convertExtension(t3));
        }
    }

    public static void copyResource(org.hl7.fhir.dstu3.model.Resource src, Resource tgt) throws FHIRException {
        if (src.hasId()) {
            tgt.setId(src.getId());
        }
        if (src.hasMeta()) {
            tgt.setMeta(VersionConvertor_30_40.convertMeta(src.getMeta()));
        }
        if (src.hasImplicitRules()) {
            tgt.setImplicitRules(src.getImplicitRules());
        }
        if (src.hasLanguage()) {
            tgt.setLanguage(src.getLanguage());
        }
    }

    public static void copyResource(Resource src, org.hl7.fhir.dstu3.model.Resource tgt) throws FHIRException {
        if (src.hasId()) {
            tgt.setId(src.getId());
        }
        if (src.hasMeta()) {
            tgt.setMeta(VersionConvertor_30_40.convertMeta(src.getMeta()));
        }
        if (src.hasImplicitRules()) {
            tgt.setImplicitRules(src.getImplicitRules());
        }
        if (src.hasLanguage()) {
            tgt.setLanguage(src.getLanguage());
        }
    }

    public static org.hl7.fhir.r4.model.Enumeration<Enumerations.PublicationStatus> convertPublicationStatus(Enumeration<Enumerations.PublicationStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Enumeration<Enumerations.PublicationStatus> tgt = new org.hl7.fhir.r4.model.Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.PublicationStatus)((Object)src.getValue())) {
            case DRAFT: {
                tgt.setValue((Object)Enumerations.PublicationStatus.DRAFT);
                break;
            }
            case ACTIVE: {
                tgt.setValue((Object)Enumerations.PublicationStatus.ACTIVE);
                break;
            }
            case RETIRED: {
                tgt.setValue((Object)Enumerations.PublicationStatus.RETIRED);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)Enumerations.PublicationStatus.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.PublicationStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Enumerations.PublicationStatus> convertPublicationStatus(org.hl7.fhir.r4.model.Enumeration<Enumerations.PublicationStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Enumerations.PublicationStatus> tgt = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.PublicationStatus)((Object)src.getValue())) {
            case DRAFT: {
                tgt.setValue((Object)Enumerations.PublicationStatus.DRAFT);
                break;
            }
            case ACTIVE: {
                tgt.setValue((Object)Enumerations.PublicationStatus.ACTIVE);
                break;
            }
            case RETIRED: {
                tgt.setValue((Object)Enumerations.PublicationStatus.RETIRED);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)Enumerations.PublicationStatus.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.PublicationStatus.NULL);
            }
        }
        return tgt;
    }

    public static CanonicalType convertReferenceToCanonical(org.hl7.fhir.dstu3.model.Reference src) throws FHIRException {
        CanonicalType dst = new CanonicalType(src.getReference());
        VersionConvertor_30_40.copyElement(src, dst, new String[0]);
        return dst;
    }

    public static org.hl7.fhir.dstu3.model.Reference convertCanonicalToReference(CanonicalType src) throws FHIRException {
        org.hl7.fhir.dstu3.model.Reference dst = new org.hl7.fhir.dstu3.model.Reference((String)src.getValue());
        VersionConvertor_30_40.copyElement(src, dst, new String[0]);
        return dst;
    }

    public static org.hl7.fhir.r4.model.Enumeration<Enumerations.SearchParamType> convertSearchParamType(Enumeration<Enumerations.SearchParamType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Enumeration<Enumerations.SearchParamType> tgt = new org.hl7.fhir.r4.model.Enumeration<Enumerations.SearchParamType>(new Enumerations.SearchParamTypeEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.SearchParamType)((Object)src.getValue())) {
            case NUMBER: {
                tgt.setValue((Object)Enumerations.SearchParamType.NUMBER);
                break;
            }
            case DATE: {
                tgt.setValue((Object)Enumerations.SearchParamType.DATE);
                break;
            }
            case STRING: {
                tgt.setValue((Object)Enumerations.SearchParamType.STRING);
                break;
            }
            case TOKEN: {
                tgt.setValue((Object)Enumerations.SearchParamType.TOKEN);
                break;
            }
            case REFERENCE: {
                tgt.setValue((Object)Enumerations.SearchParamType.REFERENCE);
                break;
            }
            case COMPOSITE: {
                tgt.setValue((Object)Enumerations.SearchParamType.COMPOSITE);
                break;
            }
            case QUANTITY: {
                tgt.setValue((Object)Enumerations.SearchParamType.QUANTITY);
                break;
            }
            case URI: {
                tgt.setValue((Object)Enumerations.SearchParamType.URI);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.SearchParamType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Enumerations.SearchParamType> convertSearchParamType(org.hl7.fhir.r4.model.Enumeration<Enumerations.SearchParamType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Enumerations.SearchParamType> tgt = new Enumeration<Enumerations.SearchParamType>(new Enumerations.SearchParamTypeEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.SearchParamType)((Object)src.getValue())) {
            case NUMBER: {
                tgt.setValue((Object)Enumerations.SearchParamType.NUMBER);
                break;
            }
            case DATE: {
                tgt.setValue((Object)Enumerations.SearchParamType.DATE);
                break;
            }
            case STRING: {
                tgt.setValue((Object)Enumerations.SearchParamType.STRING);
                break;
            }
            case TOKEN: {
                tgt.setValue((Object)Enumerations.SearchParamType.TOKEN);
                break;
            }
            case REFERENCE: {
                tgt.setValue((Object)Enumerations.SearchParamType.REFERENCE);
                break;
            }
            case COMPOSITE: {
                tgt.setValue((Object)Enumerations.SearchParamType.COMPOSITE);
                break;
            }
            case QUANTITY: {
                tgt.setValue((Object)Enumerations.SearchParamType.QUANTITY);
                break;
            }
            case URI: {
                tgt.setValue((Object)Enumerations.SearchParamType.URI);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.SearchParamType.NULL);
            }
        }
        return tgt;
    }

    public static DocumentManifest.DocumentManifestRelatedComponent convertDocumentManifestRelatedComponent(DocumentManifest.DocumentManifestRelatedComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DocumentManifest.DocumentManifestRelatedComponent tgt = new DocumentManifest.DocumentManifestRelatedComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_30_40.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasRef()) {
            tgt.setRef(VersionConvertor_30_40.convertReference(src.getRef()));
        }
        return tgt;
    }

    public static DocumentManifest.DocumentManifestRelatedComponent convertDocumentManifestRelatedComponent(DocumentManifest.DocumentManifestRelatedComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DocumentManifest.DocumentManifestRelatedComponent tgt = new DocumentManifest.DocumentManifestRelatedComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_30_40.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasRef()) {
            tgt.setRef(VersionConvertor_30_40.convertReference(src.getRef()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Enumeration<DocumentReference.DocumentRelationshipType> convertDocumentRelationshipType(Enumeration<DocumentReference.DocumentRelationshipType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Enumeration<DocumentReference.DocumentRelationshipType> tgt = new org.hl7.fhir.r4.model.Enumeration<DocumentReference.DocumentRelationshipType>(new DocumentReference.DocumentRelationshipTypeEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((DocumentReference.DocumentRelationshipType)((Object)src.getValue())) {
            case REPLACES: {
                tgt.setValue((Object)DocumentReference.DocumentRelationshipType.REPLACES);
                break;
            }
            case TRANSFORMS: {
                tgt.setValue((Object)DocumentReference.DocumentRelationshipType.TRANSFORMS);
                break;
            }
            case SIGNS: {
                tgt.setValue((Object)DocumentReference.DocumentRelationshipType.SIGNS);
                break;
            }
            case APPENDS: {
                tgt.setValue((Object)DocumentReference.DocumentRelationshipType.APPENDS);
                break;
            }
            default: {
                tgt.setValue((Object)DocumentReference.DocumentRelationshipType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<DocumentReference.DocumentRelationshipType> convertDocumentRelationshipType(org.hl7.fhir.r4.model.Enumeration<DocumentReference.DocumentRelationshipType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<DocumentReference.DocumentRelationshipType> tgt = new Enumeration<DocumentReference.DocumentRelationshipType>(new DocumentReference.DocumentRelationshipTypeEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((DocumentReference.DocumentRelationshipType)((Object)src.getValue())) {
            case REPLACES: {
                tgt.setValue((Object)DocumentReference.DocumentRelationshipType.REPLACES);
                break;
            }
            case TRANSFORMS: {
                tgt.setValue((Object)DocumentReference.DocumentRelationshipType.TRANSFORMS);
                break;
            }
            case SIGNS: {
                tgt.setValue((Object)DocumentReference.DocumentRelationshipType.SIGNS);
                break;
            }
            case APPENDS: {
                tgt.setValue((Object)DocumentReference.DocumentRelationshipType.APPENDS);
                break;
            }
            default: {
                tgt.setValue((Object)DocumentReference.DocumentRelationshipType.NULL);
            }
        }
        return tgt;
    }

    public static Encounter.DiagnosisComponent convertDiagnosisComponent(Encounter.DiagnosisComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Encounter.DiagnosisComponent tgt = new Encounter.DiagnosisComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasCondition()) {
            tgt.setCondition(VersionConvertor_30_40.convertReference(src.getCondition()));
        }
        if (src.hasRole()) {
            tgt.setUse(VersionConvertor_30_40.convertCodeableConcept(src.getRole()));
        }
        if (src.hasRank()) {
            tgt.setRankElement(VersionConvertor_30_40.convertPositiveInt(src.getRankElement()));
        }
        return tgt;
    }

    public static Encounter.DiagnosisComponent convertDiagnosisComponent(Encounter.DiagnosisComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Encounter.DiagnosisComponent tgt = new Encounter.DiagnosisComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasCondition()) {
            tgt.setCondition(VersionConvertor_30_40.convertReference(src.getCondition()));
        }
        if (src.hasUse()) {
            tgt.setRole(VersionConvertor_30_40.convertCodeableConcept(src.getUse()));
        }
        if (src.hasRank()) {
            tgt.setRankElement(VersionConvertor_30_40.convertPositiveInt(src.getRankElement()));
        }
        return tgt;
    }

    public static EpisodeOfCare.DiagnosisComponent convertDiagnosisComponent(EpisodeOfCare.DiagnosisComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        EpisodeOfCare.DiagnosisComponent tgt = new EpisodeOfCare.DiagnosisComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasCondition()) {
            tgt.setCondition(VersionConvertor_30_40.convertReference(src.getCondition()));
        }
        if (src.hasRole()) {
            tgt.setRole(VersionConvertor_30_40.convertCodeableConcept(src.getRole()));
        }
        if (src.hasRank()) {
            tgt.setRankElement(VersionConvertor_30_40.convertPositiveInt(src.getRankElement()));
        }
        return tgt;
    }

    public static EpisodeOfCare.DiagnosisComponent convertDiagnosisComponent(EpisodeOfCare.DiagnosisComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        EpisodeOfCare.DiagnosisComponent tgt = new EpisodeOfCare.DiagnosisComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasCondition()) {
            tgt.setCondition(VersionConvertor_30_40.convertReference(src.getCondition()));
        }
        if (src.hasRole()) {
            tgt.setRole(VersionConvertor_30_40.convertCodeableConcept(src.getRole()));
        }
        if (src.hasRank()) {
            tgt.setRankElement(VersionConvertor_30_40.convertPositiveInt(src.getRankElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Enumeration<Enumerations.AdministrativeGender> convertAdministrativeGender(Enumeration<Enumerations.AdministrativeGender> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Enumeration<Enumerations.AdministrativeGender> tgt = new org.hl7.fhir.r4.model.Enumeration<Enumerations.AdministrativeGender>(new Enumerations.AdministrativeGenderEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.AdministrativeGender)((Object)src.getValue())) {
            case MALE: {
                tgt.setValue((Object)Enumerations.AdministrativeGender.MALE);
                break;
            }
            case FEMALE: {
                tgt.setValue((Object)Enumerations.AdministrativeGender.FEMALE);
                break;
            }
            case OTHER: {
                tgt.setValue((Object)Enumerations.AdministrativeGender.OTHER);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)Enumerations.AdministrativeGender.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.AdministrativeGender.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Enumerations.AdministrativeGender> convertAdministrativeGender(org.hl7.fhir.r4.model.Enumeration<Enumerations.AdministrativeGender> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Enumerations.AdministrativeGender> tgt = new Enumeration<Enumerations.AdministrativeGender>(new Enumerations.AdministrativeGenderEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.AdministrativeGender)((Object)src.getValue())) {
            case MALE: {
                tgt.setValue((Object)Enumerations.AdministrativeGender.MALE);
                break;
            }
            case FEMALE: {
                tgt.setValue((Object)Enumerations.AdministrativeGender.FEMALE);
                break;
            }
            case OTHER: {
                tgt.setValue((Object)Enumerations.AdministrativeGender.OTHER);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)Enumerations.AdministrativeGender.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.AdministrativeGender.NULL);
            }
        }
        return tgt;
    }

    public static String convertCoding2Uri(Coding code) {
        return code.getSystem() + "/" + code.getCode();
    }

    public static Coding convertUri2Coding(String uri) {
        int i = uri.lastIndexOf("/");
        return new Coding().setSystem(uri.substring(0, i)).setCode(uri.substring(i + 1));
    }

    public static org.hl7.fhir.r4.model.Enumeration<PractitionerRole.DaysOfWeek> convertDaysOfWeek(Enumeration<PractitionerRole.DaysOfWeek> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Enumeration<PractitionerRole.DaysOfWeek> tgt = new org.hl7.fhir.r4.model.Enumeration<PractitionerRole.DaysOfWeek>(new PractitionerRole.DaysOfWeekEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((PractitionerRole.DaysOfWeek)((Object)src.getValue())) {
            case MON: {
                tgt.setValue((Object)PractitionerRole.DaysOfWeek.MON);
                break;
            }
            case TUE: {
                tgt.setValue((Object)PractitionerRole.DaysOfWeek.TUE);
                break;
            }
            case WED: {
                tgt.setValue((Object)PractitionerRole.DaysOfWeek.WED);
                break;
            }
            case THU: {
                tgt.setValue((Object)PractitionerRole.DaysOfWeek.THU);
                break;
            }
            case FRI: {
                tgt.setValue((Object)PractitionerRole.DaysOfWeek.FRI);
                break;
            }
            case SAT: {
                tgt.setValue((Object)PractitionerRole.DaysOfWeek.SAT);
                break;
            }
            case SUN: {
                tgt.setValue((Object)PractitionerRole.DaysOfWeek.SUN);
                break;
            }
            default: {
                tgt.setValue((Object)PractitionerRole.DaysOfWeek.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<PractitionerRole.DaysOfWeek> convertDaysOfWeek(org.hl7.fhir.r4.model.Enumeration<PractitionerRole.DaysOfWeek> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<PractitionerRole.DaysOfWeek> tgt = new Enumeration<PractitionerRole.DaysOfWeek>(new PractitionerRole.DaysOfWeekEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((PractitionerRole.DaysOfWeek)((Object)src.getValue())) {
            case MON: {
                tgt.setValue((Object)PractitionerRole.DaysOfWeek.MON);
                break;
            }
            case TUE: {
                tgt.setValue((Object)PractitionerRole.DaysOfWeek.TUE);
                break;
            }
            case WED: {
                tgt.setValue((Object)PractitionerRole.DaysOfWeek.WED);
                break;
            }
            case THU: {
                tgt.setValue((Object)PractitionerRole.DaysOfWeek.THU);
                break;
            }
            case FRI: {
                tgt.setValue((Object)PractitionerRole.DaysOfWeek.FRI);
                break;
            }
            case SAT: {
                tgt.setValue((Object)PractitionerRole.DaysOfWeek.SAT);
                break;
            }
            case SUN: {
                tgt.setValue((Object)PractitionerRole.DaysOfWeek.SUN);
                break;
            }
            default: {
                tgt.setValue((Object)PractitionerRole.DaysOfWeek.NULL);
            }
        }
        return tgt;
    }

    public static TestReport.SetupActionComponent convertSetupActionComponent(TestReport.SetupActionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestReport.SetupActionComponent tgt = new TestReport.SetupActionComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasOperation()) {
            tgt.setOperation(VersionConvertor_30_40.convertSetupActionOperationComponent(src.getOperation()));
        }
        if (src.hasAssert()) {
            tgt.setAssert(VersionConvertor_30_40.convertSetupActionAssertComponent(src.getAssert()));
        }
        return tgt;
    }

    public static TestReport.SetupActionComponent convertSetupActionComponent(TestReport.SetupActionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestReport.SetupActionComponent tgt = new TestReport.SetupActionComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasOperation()) {
            tgt.setOperation(VersionConvertor_30_40.convertSetupActionOperationComponent(src.getOperation()));
        }
        if (src.hasAssert()) {
            tgt.setAssert(VersionConvertor_30_40.convertSetupActionAssertComponent(src.getAssert()));
        }
        return tgt;
    }

    public static TestReport.SetupActionOperationComponent convertSetupActionOperationComponent(TestReport.SetupActionOperationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestReport.SetupActionOperationComponent tgt = new TestReport.SetupActionOperationComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasResult()) {
            tgt.setResultElement(VersionConvertor_30_40.convertTestReportActionResult(src.getResultElement()));
        }
        if (src.hasMessage()) {
            tgt.setMessageElement(VersionConvertor_30_40.convertMarkdown(src.getMessageElement()));
        }
        if (src.hasDetail()) {
            tgt.setDetailElement(VersionConvertor_30_40.convertUri(src.getDetailElement()));
        }
        return tgt;
    }

    public static TestReport.SetupActionOperationComponent convertSetupActionOperationComponent(TestReport.SetupActionOperationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestReport.SetupActionOperationComponent tgt = new TestReport.SetupActionOperationComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasResult()) {
            tgt.setResultElement(VersionConvertor_30_40.convertTestReportActionResult(src.getResultElement()));
        }
        if (src.hasMessage()) {
            tgt.setMessageElement(VersionConvertor_30_40.convertMarkdown(src.getMessageElement()));
        }
        if (src.hasDetail()) {
            tgt.setDetailElement(VersionConvertor_30_40.convertUri(src.getDetailElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Enumeration<TestReport.TestReportActionResult> convertTestReportActionResult(Enumeration<TestReport.TestReportActionResult> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Enumeration<TestReport.TestReportActionResult> tgt = new org.hl7.fhir.r4.model.Enumeration<TestReport.TestReportActionResult>(new TestReport.TestReportActionResultEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((TestReport.TestReportActionResult)((Object)src.getValue())) {
            case PASS: {
                tgt.setValue((Object)TestReport.TestReportActionResult.PASS);
                break;
            }
            case SKIP: {
                tgt.setValue((Object)TestReport.TestReportActionResult.SKIP);
                break;
            }
            case FAIL: {
                tgt.setValue((Object)TestReport.TestReportActionResult.FAIL);
                break;
            }
            case WARNING: {
                tgt.setValue((Object)TestReport.TestReportActionResult.WARNING);
                break;
            }
            case ERROR: {
                tgt.setValue((Object)TestReport.TestReportActionResult.ERROR);
                break;
            }
            default: {
                tgt.setValue((Object)TestReport.TestReportActionResult.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<TestReport.TestReportActionResult> convertTestReportActionResult(org.hl7.fhir.r4.model.Enumeration<TestReport.TestReportActionResult> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<TestReport.TestReportActionResult> tgt = new Enumeration<TestReport.TestReportActionResult>(new TestReport.TestReportActionResultEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((TestReport.TestReportActionResult)((Object)src.getValue())) {
            case PASS: {
                tgt.setValue((Object)TestReport.TestReportActionResult.PASS);
                break;
            }
            case SKIP: {
                tgt.setValue((Object)TestReport.TestReportActionResult.SKIP);
                break;
            }
            case FAIL: {
                tgt.setValue((Object)TestReport.TestReportActionResult.FAIL);
                break;
            }
            case WARNING: {
                tgt.setValue((Object)TestReport.TestReportActionResult.WARNING);
                break;
            }
            case ERROR: {
                tgt.setValue((Object)TestReport.TestReportActionResult.ERROR);
                break;
            }
            default: {
                tgt.setValue((Object)TestReport.TestReportActionResult.NULL);
            }
        }
        return tgt;
    }

    public static TestReport.SetupActionAssertComponent convertSetupActionAssertComponent(TestReport.SetupActionAssertComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestReport.SetupActionAssertComponent tgt = new TestReport.SetupActionAssertComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasResult()) {
            tgt.setResultElement(VersionConvertor_30_40.convertTestReportActionResult(src.getResultElement()));
        }
        if (src.hasMessage()) {
            tgt.setMessageElement(VersionConvertor_30_40.convertMarkdown(src.getMessageElement()));
        }
        if (src.hasDetail()) {
            tgt.setDetailElement(VersionConvertor_30_40.convertString(src.getDetailElement()));
        }
        return tgt;
    }

    public static TestReport.SetupActionAssertComponent convertSetupActionAssertComponent(TestReport.SetupActionAssertComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestReport.SetupActionAssertComponent tgt = new TestReport.SetupActionAssertComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasResult()) {
            tgt.setResultElement(VersionConvertor_30_40.convertTestReportActionResult(src.getResultElement()));
        }
        if (src.hasMessage()) {
            tgt.setMessageElement(VersionConvertor_30_40.convertMarkdown(src.getMessageElement()));
        }
        if (src.hasDetail()) {
            tgt.setDetailElement(VersionConvertor_30_40.convertString(src.getDetailElement()));
        }
        return tgt;
    }

    public static TestReport.TestActionComponent convertTestActionComponent(TestReport.TestActionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestReport.TestActionComponent tgt = new TestReport.TestActionComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasOperation()) {
            tgt.setOperation(VersionConvertor_30_40.convertSetupActionOperationComponent(src.getOperation()));
        }
        if (src.hasAssert()) {
            tgt.setAssert(VersionConvertor_30_40.convertSetupActionAssertComponent(src.getAssert()));
        }
        return tgt;
    }

    public static TestReport.TestActionComponent convertTestActionComponent(TestReport.TestActionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestReport.TestActionComponent tgt = new TestReport.TestActionComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasOperation()) {
            tgt.setOperation(VersionConvertor_30_40.convertSetupActionOperationComponent(src.getOperation()));
        }
        if (src.hasAssert()) {
            tgt.setAssert(VersionConvertor_30_40.convertSetupActionAssertComponent(src.getAssert()));
        }
        return tgt;
    }

    public static TestReport.TeardownActionComponent convertTeardownActionComponent(TestReport.TeardownActionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestReport.TeardownActionComponent tgt = new TestReport.TeardownActionComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasOperation()) {
            tgt.setOperation(VersionConvertor_30_40.convertSetupActionOperationComponent(src.getOperation()));
        }
        return tgt;
    }

    public static TestReport.TeardownActionComponent convertTeardownActionComponent(TestReport.TeardownActionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestReport.TeardownActionComponent tgt = new TestReport.TeardownActionComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasOperation()) {
            tgt.setOperation(VersionConvertor_30_40.convertSetupActionOperationComponent(src.getOperation()));
        }
        return tgt;
    }

    public static TestScript.SetupActionComponent convertSetupActionComponent(TestScript.SetupActionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestScript.SetupActionComponent tgt = new TestScript.SetupActionComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasOperation()) {
            tgt.setOperation(VersionConvertor_30_40.convertSetupActionOperationComponent(src.getOperation()));
        }
        if (src.hasAssert()) {
            tgt.setAssert(VersionConvertor_30_40.convertSetupActionAssertComponent(src.getAssert()));
        }
        return tgt;
    }

    public static TestScript.SetupActionComponent convertSetupActionComponent(TestScript.SetupActionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestScript.SetupActionComponent tgt = new TestScript.SetupActionComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasOperation()) {
            tgt.setOperation(VersionConvertor_30_40.convertSetupActionOperationComponent(src.getOperation()));
        }
        if (src.hasAssert()) {
            tgt.setAssert(VersionConvertor_30_40.convertSetupActionAssertComponent(src.getAssert()));
        }
        return tgt;
    }

    public static TestScript.SetupActionOperationComponent convertSetupActionOperationComponent(TestScript.SetupActionOperationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestScript.SetupActionOperationComponent tgt = new TestScript.SetupActionOperationComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertCoding(src.getType()));
        }
        if (src.hasResource()) {
            tgt.setResourceElement(VersionConvertor_30_40.convertCode(src.getResourceElement()));
        }
        if (src.hasLabel()) {
            tgt.setLabelElement(VersionConvertor_30_40.convertString(src.getLabelElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_40.convertString(src.getDescriptionElement()));
        }
        if (src.hasAccept()) {
            tgt.setAccept(VersionConvertor_30_40.convertContentType(src.getAccept()));
        }
        if (src.hasContentType()) {
            tgt.setContentType(VersionConvertor_30_40.convertContentType(src.getContentType()));
        }
        if (src.hasDestination()) {
            tgt.setDestinationElement(VersionConvertor_30_40.convertInteger(src.getDestinationElement()));
        }
        if (src.hasEncodeRequestUrl()) {
            tgt.setEncodeRequestUrlElement(VersionConvertor_30_40.convertBoolean(src.getEncodeRequestUrlElement()));
        }
        if (src.hasOrigin()) {
            tgt.setOriginElement(VersionConvertor_30_40.convertInteger(src.getOriginElement()));
        }
        if (src.hasParams()) {
            tgt.setParamsElement(VersionConvertor_30_40.convertString(src.getParamsElement()));
        }
        for (TestScript.SetupActionOperationRequestHeaderComponent t : src.getRequestHeader()) {
            tgt.addRequestHeader(VersionConvertor_30_40.convertSetupActionOperationRequestHeaderComponent(t));
        }
        if (src.hasRequestId()) {
            tgt.setRequestIdElement(VersionConvertor_30_40.convertId(src.getRequestIdElement()));
        }
        if (src.hasResponseId()) {
            tgt.setResponseIdElement(VersionConvertor_30_40.convertId(src.getResponseIdElement()));
        }
        if (src.hasSourceId()) {
            tgt.setSourceIdElement(VersionConvertor_30_40.convertId(src.getSourceIdElement()));
        }
        if (src.hasTargetId()) {
            tgt.setTargetId(src.getTargetId());
        }
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_30_40.convertString(src.getUrlElement()));
        }
        return tgt;
    }

    public static TestScript.SetupActionOperationComponent convertSetupActionOperationComponent(TestScript.SetupActionOperationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestScript.SetupActionOperationComponent tgt = new TestScript.SetupActionOperationComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertCoding(src.getType()));
        }
        if (src.hasResource()) {
            tgt.setResourceElement(VersionConvertor_30_40.convertCode(src.getResourceElement()));
        }
        if (src.hasLabel()) {
            tgt.setLabelElement(VersionConvertor_30_40.convertString(src.getLabelElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_40.convertString(src.getDescriptionElement()));
        }
        if (src.hasAccept()) {
            tgt.setAccept(VersionConvertor_30_40.convertContentType(src.getAccept()));
        }
        if (src.hasContentType()) {
            tgt.setContentType(VersionConvertor_30_40.convertContentType(src.getContentType()));
        }
        if (src.hasDestination()) {
            tgt.setDestinationElement(VersionConvertor_30_40.convertInteger(src.getDestinationElement()));
        }
        if (src.hasEncodeRequestUrl()) {
            tgt.setEncodeRequestUrlElement(VersionConvertor_30_40.convertBoolean(src.getEncodeRequestUrlElement()));
        }
        if (src.hasOrigin()) {
            tgt.setOriginElement(VersionConvertor_30_40.convertInteger(src.getOriginElement()));
        }
        if (src.hasParams()) {
            tgt.setParamsElement(VersionConvertor_30_40.convertString(src.getParamsElement()));
        }
        for (TestScript.SetupActionOperationRequestHeaderComponent t : src.getRequestHeader()) {
            tgt.addRequestHeader(VersionConvertor_30_40.convertSetupActionOperationRequestHeaderComponent(t));
        }
        if (src.hasRequestId()) {
            tgt.setRequestIdElement(VersionConvertor_30_40.convertId(src.getRequestIdElement()));
        }
        if (src.hasResponseId()) {
            tgt.setResponseIdElement(VersionConvertor_30_40.convertId(src.getResponseIdElement()));
        }
        if (src.hasSourceId()) {
            tgt.setSourceIdElement(VersionConvertor_30_40.convertId(src.getSourceIdElement()));
        }
        if (src.hasTargetId()) {
            tgt.setTargetId(src.getTargetId());
        }
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_30_40.convertString(src.getUrlElement()));
        }
        return tgt;
    }

    public static String convertContentType(TestScript.ContentType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case XML: {
                return "application/fhir+xml";
            }
            case JSON: {
                return "application/fhir+json";
            }
            case TTL: {
                return "text/turtle";
            }
            case NONE: {
                return null;
            }
        }
        return null;
    }

    public static TestScript.ContentType convertContentType(String src) throws FHIRException {
        if (src == null) {
            return null;
        }
        if (src.contains("xml")) {
            return TestScript.ContentType.XML;
        }
        if (src.contains("json")) {
            return TestScript.ContentType.JSON;
        }
        if (src.contains("tu")) {
            return TestScript.ContentType.TTL;
        }
        return TestScript.ContentType.NONE;
    }

    public static TestScript.SetupActionOperationRequestHeaderComponent convertSetupActionOperationRequestHeaderComponent(TestScript.SetupActionOperationRequestHeaderComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestScript.SetupActionOperationRequestHeaderComponent tgt = new TestScript.SetupActionOperationRequestHeaderComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasField()) {
            tgt.setFieldElement(VersionConvertor_30_40.convertString(src.getFieldElement()));
        }
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_30_40.convertString(src.getValueElement()));
        }
        return tgt;
    }

    public static TestScript.SetupActionOperationRequestHeaderComponent convertSetupActionOperationRequestHeaderComponent(TestScript.SetupActionOperationRequestHeaderComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestScript.SetupActionOperationRequestHeaderComponent tgt = new TestScript.SetupActionOperationRequestHeaderComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasField()) {
            tgt.setFieldElement(VersionConvertor_30_40.convertString(src.getFieldElement()));
        }
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_30_40.convertString(src.getValueElement()));
        }
        return tgt;
    }

    public static TestScript.SetupActionAssertComponent convertSetupActionAssertComponent(TestScript.SetupActionAssertComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestScript.SetupActionAssertComponent tgt = new TestScript.SetupActionAssertComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasLabel()) {
            tgt.setLabelElement(VersionConvertor_30_40.convertString(src.getLabelElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_40.convertString(src.getDescriptionElement()));
        }
        if (src.hasDirection()) {
            tgt.setDirectionElement(VersionConvertor_30_40.convertAssertionDirectionType(src.getDirectionElement()));
        }
        if (src.hasCompareToSourceId()) {
            tgt.setCompareToSourceIdElement(VersionConvertor_30_40.convertString(src.getCompareToSourceIdElement()));
        }
        if (src.hasCompareToSourceExpression()) {
            tgt.setCompareToSourceExpressionElement(VersionConvertor_30_40.convertString(src.getCompareToSourceExpressionElement()));
        }
        if (src.hasCompareToSourcePath()) {
            tgt.setCompareToSourcePathElement(VersionConvertor_30_40.convertString(src.getCompareToSourcePathElement()));
        }
        if (src.hasContentType()) {
            tgt.setContentType(VersionConvertor_30_40.convertContentType(src.getContentType()));
        }
        if (src.hasExpression()) {
            tgt.setExpressionElement(VersionConvertor_30_40.convertString(src.getExpressionElement()));
        }
        if (src.hasHeaderField()) {
            tgt.setHeaderFieldElement(VersionConvertor_30_40.convertString(src.getHeaderFieldElement()));
        }
        if (src.hasMinimumId()) {
            tgt.setMinimumIdElement(VersionConvertor_30_40.convertString(src.getMinimumIdElement()));
        }
        if (src.hasNavigationLinks()) {
            tgt.setNavigationLinksElement(VersionConvertor_30_40.convertBoolean(src.getNavigationLinksElement()));
        }
        if (src.hasOperator()) {
            tgt.setOperatorElement(VersionConvertor_30_40.convertAssertionOperatorType(src.getOperatorElement()));
        }
        if (src.hasPath()) {
            tgt.setPathElement(VersionConvertor_30_40.convertString(src.getPathElement()));
        }
        if (src.hasRequestMethod()) {
            tgt.setRequestMethodElement(VersionConvertor_30_40.convertTestScriptRequestMethodCode(src.getRequestMethodElement()));
        }
        if (src.hasRequestURL()) {
            tgt.setRequestURLElement(VersionConvertor_30_40.convertString(src.getRequestURLElement()));
        }
        if (src.hasResource()) {
            tgt.setResourceElement(VersionConvertor_30_40.convertCode(src.getResourceElement()));
        }
        if (src.hasResponse()) {
            tgt.setResponseElement(VersionConvertor_30_40.convertAssertionResponseTypes(src.getResponseElement()));
        }
        if (src.hasResponseCode()) {
            tgt.setResponseCodeElement(VersionConvertor_30_40.convertString(src.getResponseCodeElement()));
        }
        if (src.hasSourceId()) {
            tgt.setSourceIdElement(VersionConvertor_30_40.convertId(src.getSourceIdElement()));
        }
        if (src.hasValidateProfileId()) {
            tgt.setValidateProfileIdElement(VersionConvertor_30_40.convertId(src.getValidateProfileIdElement()));
        }
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_30_40.convertString(src.getValueElement()));
        }
        if (src.hasWarningOnly()) {
            tgt.setWarningOnlyElement(VersionConvertor_30_40.convertBoolean(src.getWarningOnlyElement()));
        }
        return tgt;
    }

    public static TestScript.SetupActionAssertComponent convertSetupActionAssertComponent(TestScript.SetupActionAssertComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestScript.SetupActionAssertComponent tgt = new TestScript.SetupActionAssertComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasLabel()) {
            tgt.setLabelElement(VersionConvertor_30_40.convertString(src.getLabelElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_40.convertString(src.getDescriptionElement()));
        }
        if (src.hasDirection()) {
            tgt.setDirectionElement(VersionConvertor_30_40.convertAssertionDirectionType(src.getDirectionElement()));
        }
        if (src.hasCompareToSourceId()) {
            tgt.setCompareToSourceIdElement(VersionConvertor_30_40.convertString(src.getCompareToSourceIdElement()));
        }
        if (src.hasCompareToSourceExpression()) {
            tgt.setCompareToSourceExpressionElement(VersionConvertor_30_40.convertString(src.getCompareToSourceExpressionElement()));
        }
        if (src.hasCompareToSourcePath()) {
            tgt.setCompareToSourcePathElement(VersionConvertor_30_40.convertString(src.getCompareToSourcePathElement()));
        }
        if (src.hasContentType()) {
            tgt.setContentType(VersionConvertor_30_40.convertContentType(src.getContentType()));
        }
        if (src.hasExpression()) {
            tgt.setExpressionElement(VersionConvertor_30_40.convertString(src.getExpressionElement()));
        }
        if (src.hasHeaderField()) {
            tgt.setHeaderFieldElement(VersionConvertor_30_40.convertString(src.getHeaderFieldElement()));
        }
        if (src.hasMinimumId()) {
            tgt.setMinimumIdElement(VersionConvertor_30_40.convertString(src.getMinimumIdElement()));
        }
        if (src.hasNavigationLinks()) {
            tgt.setNavigationLinksElement(VersionConvertor_30_40.convertBoolean(src.getNavigationLinksElement()));
        }
        if (src.hasOperator()) {
            tgt.setOperatorElement(VersionConvertor_30_40.convertAssertionOperatorType(src.getOperatorElement()));
        }
        if (src.hasPath()) {
            tgt.setPathElement(VersionConvertor_30_40.convertString(src.getPathElement()));
        }
        if (src.hasRequestMethod()) {
            tgt.setRequestMethodElement(VersionConvertor_30_40.convertTestScriptRequestMethodCode(src.getRequestMethodElement()));
        }
        if (src.hasRequestURL()) {
            tgt.setRequestURLElement(VersionConvertor_30_40.convertString(src.getRequestURLElement()));
        }
        if (src.hasResource()) {
            tgt.setResourceElement(VersionConvertor_30_40.convertCode(src.getResourceElement()));
        }
        if (src.hasResponse()) {
            tgt.setResponseElement(VersionConvertor_30_40.convertAssertionResponseTypes(src.getResponseElement()));
        }
        if (src.hasResponseCode()) {
            tgt.setResponseCodeElement(VersionConvertor_30_40.convertString(src.getResponseCodeElement()));
        }
        if (src.hasSourceId()) {
            tgt.setSourceIdElement(VersionConvertor_30_40.convertId(src.getSourceIdElement()));
        }
        if (src.hasValidateProfileId()) {
            tgt.setValidateProfileIdElement(VersionConvertor_30_40.convertId(src.getValidateProfileIdElement()));
        }
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_30_40.convertString(src.getValueElement()));
        }
        if (src.hasWarningOnly()) {
            tgt.setWarningOnlyElement(VersionConvertor_30_40.convertBoolean(src.getWarningOnlyElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Enumeration<TestScript.AssertionDirectionType> convertAssertionDirectionType(Enumeration<TestScript.AssertionDirectionType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Enumeration<TestScript.AssertionDirectionType> tgt = new org.hl7.fhir.r4.model.Enumeration<TestScript.AssertionDirectionType>(new TestScript.AssertionDirectionTypeEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((TestScript.AssertionDirectionType)((Object)src.getValue())) {
            case RESPONSE: {
                tgt.setValue((Object)TestScript.AssertionDirectionType.RESPONSE);
                break;
            }
            case REQUEST: {
                tgt.setValue((Object)TestScript.AssertionDirectionType.REQUEST);
                break;
            }
            default: {
                tgt.setValue((Object)TestScript.AssertionDirectionType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<TestScript.AssertionDirectionType> convertAssertionDirectionType(org.hl7.fhir.r4.model.Enumeration<TestScript.AssertionDirectionType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<TestScript.AssertionDirectionType> tgt = new Enumeration<TestScript.AssertionDirectionType>(new TestScript.AssertionDirectionTypeEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((TestScript.AssertionDirectionType)((Object)src.getValue())) {
            case RESPONSE: {
                tgt.setValue((Object)TestScript.AssertionDirectionType.RESPONSE);
                break;
            }
            case REQUEST: {
                tgt.setValue((Object)TestScript.AssertionDirectionType.REQUEST);
                break;
            }
            default: {
                tgt.setValue((Object)TestScript.AssertionDirectionType.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Enumeration<TestScript.AssertionOperatorType> convertAssertionOperatorType(Enumeration<TestScript.AssertionOperatorType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Enumeration<TestScript.AssertionOperatorType> tgt = new org.hl7.fhir.r4.model.Enumeration<TestScript.AssertionOperatorType>(new TestScript.AssertionOperatorTypeEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((TestScript.AssertionOperatorType)((Object)src.getValue())) {
            case EQUALS: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.EQUALS);
                break;
            }
            case NOTEQUALS: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.NOTEQUALS);
                break;
            }
            case IN: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.IN);
                break;
            }
            case NOTIN: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.NOTIN);
                break;
            }
            case GREATERTHAN: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.GREATERTHAN);
                break;
            }
            case LESSTHAN: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.LESSTHAN);
                break;
            }
            case EMPTY: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.EMPTY);
                break;
            }
            case NOTEMPTY: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.NOTEMPTY);
                break;
            }
            case CONTAINS: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.CONTAINS);
                break;
            }
            case NOTCONTAINS: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.NOTCONTAINS);
                break;
            }
            case EVAL: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.EVAL);
                break;
            }
            default: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<TestScript.AssertionOperatorType> convertAssertionOperatorType(org.hl7.fhir.r4.model.Enumeration<TestScript.AssertionOperatorType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<TestScript.AssertionOperatorType> tgt = new Enumeration<TestScript.AssertionOperatorType>(new TestScript.AssertionOperatorTypeEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((TestScript.AssertionOperatorType)((Object)src.getValue())) {
            case EQUALS: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.EQUALS);
                break;
            }
            case NOTEQUALS: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.NOTEQUALS);
                break;
            }
            case IN: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.IN);
                break;
            }
            case NOTIN: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.NOTIN);
                break;
            }
            case GREATERTHAN: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.GREATERTHAN);
                break;
            }
            case LESSTHAN: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.LESSTHAN);
                break;
            }
            case EMPTY: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.EMPTY);
                break;
            }
            case NOTEMPTY: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.NOTEMPTY);
                break;
            }
            case CONTAINS: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.CONTAINS);
                break;
            }
            case NOTCONTAINS: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.NOTCONTAINS);
                break;
            }
            case EVAL: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.EVAL);
                break;
            }
            default: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Enumeration<TestScript.TestScriptRequestMethodCode> convertTestScriptRequestMethodCode(Enumeration<TestScript.TestScriptRequestMethodCode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Enumeration<TestScript.TestScriptRequestMethodCode> tgt = new org.hl7.fhir.r4.model.Enumeration<TestScript.TestScriptRequestMethodCode>(new TestScript.TestScriptRequestMethodCodeEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((TestScript.TestScriptRequestMethodCode)((Object)src.getValue())) {
            case DELETE: {
                tgt.setValue((Object)TestScript.TestScriptRequestMethodCode.DELETE);
                break;
            }
            case GET: {
                tgt.setValue((Object)TestScript.TestScriptRequestMethodCode.GET);
                break;
            }
            case OPTIONS: {
                tgt.setValue((Object)TestScript.TestScriptRequestMethodCode.OPTIONS);
                break;
            }
            case PATCH: {
                tgt.setValue((Object)TestScript.TestScriptRequestMethodCode.PATCH);
                break;
            }
            case POST: {
                tgt.setValue((Object)TestScript.TestScriptRequestMethodCode.POST);
                break;
            }
            case PUT: {
                tgt.setValue((Object)TestScript.TestScriptRequestMethodCode.PUT);
                break;
            }
            default: {
                tgt.setValue((Object)TestScript.TestScriptRequestMethodCode.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<TestScript.TestScriptRequestMethodCode> convertTestScriptRequestMethodCode(org.hl7.fhir.r4.model.Enumeration<TestScript.TestScriptRequestMethodCode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<TestScript.TestScriptRequestMethodCode> tgt = new Enumeration<TestScript.TestScriptRequestMethodCode>(new TestScript.TestScriptRequestMethodCodeEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((TestScript.TestScriptRequestMethodCode)((Object)src.getValue())) {
            case DELETE: {
                tgt.setValue((Object)TestScript.TestScriptRequestMethodCode.DELETE);
                break;
            }
            case GET: {
                tgt.setValue((Object)TestScript.TestScriptRequestMethodCode.GET);
                break;
            }
            case OPTIONS: {
                tgt.setValue((Object)TestScript.TestScriptRequestMethodCode.OPTIONS);
                break;
            }
            case PATCH: {
                tgt.setValue((Object)TestScript.TestScriptRequestMethodCode.PATCH);
                break;
            }
            case POST: {
                tgt.setValue((Object)TestScript.TestScriptRequestMethodCode.POST);
                break;
            }
            case PUT: {
                tgt.setValue((Object)TestScript.TestScriptRequestMethodCode.PUT);
                break;
            }
            default: {
                tgt.setValue((Object)TestScript.TestScriptRequestMethodCode.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Enumeration<TestScript.AssertionResponseTypes> convertAssertionResponseTypes(Enumeration<TestScript.AssertionResponseTypes> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Enumeration<TestScript.AssertionResponseTypes> tgt = new org.hl7.fhir.r4.model.Enumeration<TestScript.AssertionResponseTypes>(new TestScript.AssertionResponseTypesEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((TestScript.AssertionResponseTypes)((Object)src.getValue())) {
            case OKAY: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.OKAY);
                break;
            }
            case CREATED: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.CREATED);
                break;
            }
            case NOCONTENT: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.NOCONTENT);
                break;
            }
            case NOTMODIFIED: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.NOTMODIFIED);
                break;
            }
            case BAD: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.BAD);
                break;
            }
            case FORBIDDEN: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.FORBIDDEN);
                break;
            }
            case NOTFOUND: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.NOTFOUND);
                break;
            }
            case METHODNOTALLOWED: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.METHODNOTALLOWED);
                break;
            }
            case CONFLICT: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.CONFLICT);
                break;
            }
            case GONE: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.GONE);
                break;
            }
            case PRECONDITIONFAILED: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.PRECONDITIONFAILED);
                break;
            }
            case UNPROCESSABLE: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.UNPROCESSABLE);
                break;
            }
            default: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<TestScript.AssertionResponseTypes> convertAssertionResponseTypes(org.hl7.fhir.r4.model.Enumeration<TestScript.AssertionResponseTypes> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<TestScript.AssertionResponseTypes> tgt = new Enumeration<TestScript.AssertionResponseTypes>(new TestScript.AssertionResponseTypesEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((TestScript.AssertionResponseTypes)((Object)src.getValue())) {
            case OKAY: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.OKAY);
                break;
            }
            case CREATED: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.CREATED);
                break;
            }
            case NOCONTENT: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.NOCONTENT);
                break;
            }
            case NOTMODIFIED: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.NOTMODIFIED);
                break;
            }
            case BAD: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.BAD);
                break;
            }
            case FORBIDDEN: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.FORBIDDEN);
                break;
            }
            case NOTFOUND: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.NOTFOUND);
                break;
            }
            case METHODNOTALLOWED: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.METHODNOTALLOWED);
                break;
            }
            case CONFLICT: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.CONFLICT);
                break;
            }
            case GONE: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.GONE);
                break;
            }
            case PRECONDITIONFAILED: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.PRECONDITIONFAILED);
                break;
            }
            case UNPROCESSABLE: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.UNPROCESSABLE);
                break;
            }
            default: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.NULL);
            }
        }
        return tgt;
    }

    public static TestScript.TestActionComponent convertTestActionComponent(TestScript.TestActionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestScript.TestActionComponent tgt = new TestScript.TestActionComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasOperation()) {
            tgt.setOperation(VersionConvertor_30_40.convertSetupActionOperationComponent(src.getOperation()));
        }
        if (src.hasAssert()) {
            tgt.setAssert(VersionConvertor_30_40.convertSetupActionAssertComponent(src.getAssert()));
        }
        return tgt;
    }

    public static TestScript.TestActionComponent convertTestActionComponent(TestScript.TestActionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestScript.TestActionComponent tgt = new TestScript.TestActionComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasOperation()) {
            tgt.setOperation(VersionConvertor_30_40.convertSetupActionOperationComponent(src.getOperation()));
        }
        if (src.hasAssert()) {
            tgt.setAssert(VersionConvertor_30_40.convertSetupActionAssertComponent(src.getAssert()));
        }
        return tgt;
    }

    public static TestScript.TeardownActionComponent convertTeardownActionComponent(TestScript.TeardownActionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestScript.TeardownActionComponent tgt = new TestScript.TeardownActionComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasOperation()) {
            tgt.setOperation(VersionConvertor_30_40.convertSetupActionOperationComponent(src.getOperation()));
        }
        return tgt;
    }

    public static TestScript.TeardownActionComponent convertTeardownActionComponent(TestScript.TeardownActionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestScript.TeardownActionComponent tgt = new TestScript.TeardownActionComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasOperation()) {
            tgt.setOperation(VersionConvertor_30_40.convertSetupActionOperationComponent(src.getOperation()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Enumeration<ValueSet.FilterOperator> convertFilterOperator(Enumeration<ValueSet.FilterOperator> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Enumeration<ValueSet.FilterOperator> tgt = new org.hl7.fhir.r4.model.Enumeration<ValueSet.FilterOperator>(new ValueSet.FilterOperatorEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((ValueSet.FilterOperator)((Object)src.getValue())) {
            case EQUAL: {
                tgt.setValue((Object)ValueSet.FilterOperator.EQUAL);
                break;
            }
            case ISA: {
                tgt.setValue((Object)ValueSet.FilterOperator.ISA);
                break;
            }
            case DESCENDENTOF: {
                tgt.setValue((Object)ValueSet.FilterOperator.DESCENDENTOF);
                break;
            }
            case ISNOTA: {
                tgt.setValue((Object)ValueSet.FilterOperator.ISNOTA);
                break;
            }
            case REGEX: {
                tgt.setValue((Object)ValueSet.FilterOperator.REGEX);
                break;
            }
            case IN: {
                tgt.setValue((Object)ValueSet.FilterOperator.IN);
                break;
            }
            case NOTIN: {
                tgt.setValue((Object)ValueSet.FilterOperator.NOTIN);
                break;
            }
            case GENERALIZES: {
                tgt.setValue((Object)ValueSet.FilterOperator.GENERALIZES);
                break;
            }
            case EXISTS: {
                tgt.setValue((Object)ValueSet.FilterOperator.EXISTS);
                break;
            }
            default: {
                tgt.setValue((Object)ValueSet.FilterOperator.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<ValueSet.FilterOperator> convertFilterOperator(org.hl7.fhir.r4.model.Enumeration<ValueSet.FilterOperator> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ValueSet.FilterOperator> tgt = new Enumeration<ValueSet.FilterOperator>(new ValueSet.FilterOperatorEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((ValueSet.FilterOperator)((Object)src.getValue())) {
            case EQUAL: {
                tgt.setValue((Object)ValueSet.FilterOperator.EQUAL);
                break;
            }
            case ISA: {
                tgt.setValue((Object)ValueSet.FilterOperator.ISA);
                break;
            }
            case DESCENDENTOF: {
                tgt.setValue((Object)ValueSet.FilterOperator.DESCENDENTOF);
                break;
            }
            case ISNOTA: {
                tgt.setValue((Object)ValueSet.FilterOperator.ISNOTA);
                break;
            }
            case REGEX: {
                tgt.setValue((Object)ValueSet.FilterOperator.REGEX);
                break;
            }
            case IN: {
                tgt.setValue((Object)ValueSet.FilterOperator.IN);
                break;
            }
            case NOTIN: {
                tgt.setValue((Object)ValueSet.FilterOperator.NOTIN);
                break;
            }
            case GENERALIZES: {
                tgt.setValue((Object)ValueSet.FilterOperator.GENERALIZES);
                break;
            }
            case EXISTS: {
                tgt.setValue((Object)ValueSet.FilterOperator.EXISTS);
                break;
            }
            default: {
                tgt.setValue((Object)ValueSet.FilterOperator.NULL);
            }
        }
        return tgt;
    }

    public static Resource convertResource(org.hl7.fhir.dstu3.model.Resource src, boolean nullOk) throws FHIRException {
        if (src == null) {
            return null;
        }
        if (src instanceof Parameters) {
            return Parameters30_40.convertParameters((Parameters)src);
        }
        if (src instanceof ActivityDefinition) {
            return ActivityDefinition30_40.convertActivityDefinition((ActivityDefinition)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.AllergyIntolerance) {
            return AllergyIntolerance30_40.convertAllergyIntolerance((org.hl7.fhir.dstu3.model.AllergyIntolerance)src);
        }
        if (src instanceof Appointment) {
            return Appointment30_40.convertAppointment((Appointment)src);
        }
        if (src instanceof AppointmentResponse) {
            return AppointmentResponse30_40.convertAppointmentResponse((AppointmentResponse)src);
        }
        if (src instanceof AuditEvent) {
            return AuditEvent30_40.convertAuditEvent((AuditEvent)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Basic) {
            return Basic30_40.convertBasic((org.hl7.fhir.dstu3.model.Basic)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Binary) {
            return Binary30_40.convertBinary((org.hl7.fhir.dstu3.model.Binary)src);
        }
        if (src instanceof BodySite) {
            return BodySite30_40.convertBodySite((BodySite)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Bundle) {
            return Bundle30_40.convertBundle((org.hl7.fhir.dstu3.model.Bundle)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.CapabilityStatement) {
            return CapabilityStatement30_40.convertCapabilityStatement((org.hl7.fhir.dstu3.model.CapabilityStatement)src);
        }
        if (src instanceof CarePlan) {
            return CarePlan30_40.convertCarePlan((CarePlan)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.CareTeam) {
            return CareTeam30_40.convertCareTeam((org.hl7.fhir.dstu3.model.CareTeam)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.ClinicalImpression) {
            return ClinicalImpression30_40.convertClinicalImpression((org.hl7.fhir.dstu3.model.ClinicalImpression)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.CodeSystem) {
            return CodeSystem30_40.convertCodeSystem((org.hl7.fhir.dstu3.model.CodeSystem)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Communication) {
            return Communication30_40.convertCommunication((org.hl7.fhir.dstu3.model.Communication)src);
        }
        if (src instanceof CompartmentDefinition) {
            return CompartmentDefinition30_40.convertCompartmentDefinition((CompartmentDefinition)src);
        }
        if (src instanceof Composition) {
            return Composition30_40.convertComposition((Composition)src);
        }
        if (src instanceof ConceptMap) {
            return ConceptMap30_40.convertConceptMap((ConceptMap)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Condition) {
            return Condition30_40.convertCondition((org.hl7.fhir.dstu3.model.Condition)src);
        }
        if (src instanceof Consent) {
            return Consent30_40.convertConsent((Consent)src);
        }
        if (src instanceof DataElement) {
            return DataElement30_40.convertDataElement((DataElement)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.DetectedIssue) {
            return DetectedIssue30_40.convertDetectedIssue((org.hl7.fhir.dstu3.model.DetectedIssue)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.DeviceUseStatement) {
            return DeviceUseStatement30_40.convertDeviceUseStatement((org.hl7.fhir.dstu3.model.DeviceUseStatement)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.DiagnosticReport) {
            return DiagnosticReport30_40.convertDiagnosticReport((org.hl7.fhir.dstu3.model.DiagnosticReport)src);
        }
        if (src instanceof DocumentReference) {
            return DocumentReference30_40.convertDocumentReference((DocumentReference)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Encounter) {
            return Encounter30_40.convertEncounter((org.hl7.fhir.dstu3.model.Encounter)src);
        }
        if (src instanceof Endpoint) {
            return Endpoint30_40.convertEndpoint((Endpoint)src);
        }
        if (src instanceof EpisodeOfCare) {
            return EpisodeOfCare30_40.convertEpisodeOfCare((EpisodeOfCare)src);
        }
        if (src instanceof ExpansionProfile) {
            return ExpansionProfile30_40.convertExpansionProfile((ExpansionProfile)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.FamilyMemberHistory) {
            return FamilyMemberHistory30_40.convertFamilyMemberHistory((org.hl7.fhir.dstu3.model.FamilyMemberHistory)src);
        }
        if (src instanceof Flag) {
            return Flag30_40.convertFlag((Flag)src);
        }
        if (src instanceof Goal) {
            return Goal30_40.convertGoal((Goal)src);
        }
        if (src instanceof GraphDefinition) {
            return GraphDefinition30_40.convertGraphDefinition((GraphDefinition)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Group) {
            return Group30_40.convertGroup((org.hl7.fhir.dstu3.model.Group)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.HealthcareService) {
            return HealthcareService30_40.convertHealthcareService((org.hl7.fhir.dstu3.model.HealthcareService)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.ImagingStudy) {
            return ImagingStudy30_40.convertImagingStudy((org.hl7.fhir.dstu3.model.ImagingStudy)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Immunization) {
            return Immunization30_40.convertImmunization((org.hl7.fhir.dstu3.model.Immunization)src);
        }
        if (src instanceof ImplementationGuide) {
            return ImplementationGuide30_40.convertImplementationGuide((ImplementationGuide)src);
        }
        if (src instanceof Library) {
            return Library30_40.convertLibrary((Library)src);
        }
        if (src instanceof Linkage) {
            return Linkage30_40.convertLinkage((Linkage)src);
        }
        if (src instanceof ListResource) {
            return List30_40.convertList((ListResource)src);
        }
        if (src instanceof Location) {
            return Location30_40.convertLocation((Location)src);
        }
        if (src instanceof Media) {
            return Media30_40.convertMedia((Media)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Medication) {
            return Medication30_40.convertMedication((org.hl7.fhir.dstu3.model.Medication)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.MedicationAdministration) {
            return MedicationAdministration30_40.convertMedicationAdministration((org.hl7.fhir.dstu3.model.MedicationAdministration)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.MedicationDispense) {
            return MedicationDispense30_40.convertMedicationDispense((org.hl7.fhir.dstu3.model.MedicationDispense)src);
        }
        if (src instanceof MedicationRequest) {
            return MedicationRequest30_40.convertMedicationRequest((MedicationRequest)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.MedicationStatement) {
            return MedicationStatement30_40.convertMedicationStatement((org.hl7.fhir.dstu3.model.MedicationStatement)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.MessageDefinition) {
            return MessageDefinition30_40.convertMessageDefinition((org.hl7.fhir.dstu3.model.MessageDefinition)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.MessageHeader) {
            return MessageHeader30_40.convertMessageHeader((org.hl7.fhir.dstu3.model.MessageHeader)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.NamingSystem) {
            return NamingSystem30_40.convertNamingSystem((org.hl7.fhir.dstu3.model.NamingSystem)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Observation) {
            return Observation30_40.convertObservation((org.hl7.fhir.dstu3.model.Observation)src);
        }
        if (src instanceof OperationDefinition) {
            return OperationDefinition30_40.convertOperationDefinition((OperationDefinition)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.OperationOutcome) {
            return OperationOutcome30_40.convertOperationOutcome((org.hl7.fhir.dstu3.model.OperationOutcome)src);
        }
        if (src instanceof Organization) {
            return Organization30_40.convertOrganization((Organization)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Patient) {
            return Patient30_40.convertPatient((org.hl7.fhir.dstu3.model.Patient)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.PaymentNotice) {
            return PaymentNotice30_40.convertPaymentNotice((org.hl7.fhir.dstu3.model.PaymentNotice)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Person) {
            return Person30_40.convertPerson((org.hl7.fhir.dstu3.model.Person)src);
        }
        if (src instanceof PlanDefinition) {
            return PlanDefinition30_40.convertPlanDefinition((PlanDefinition)src);
        }
        if (src instanceof Practitioner) {
            return Practitioner30_40.convertPractitioner((Practitioner)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.PractitionerRole) {
            return PractitionerRole30_40.convertPractitionerRole((org.hl7.fhir.dstu3.model.PractitionerRole)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Procedure) {
            return Procedure30_40.convertProcedure((org.hl7.fhir.dstu3.model.Procedure)src);
        }
        if (src instanceof ProcedureRequest) {
            return ProcedureRequest30_40.convertProcedureRequest((ProcedureRequest)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Provenance) {
            return Provenance30_40.convertProvenance((org.hl7.fhir.dstu3.model.Provenance)src);
        }
        if (src instanceof Questionnaire) {
            return Questionnaire30_40.convertQuestionnaire((Questionnaire)src);
        }
        if (src instanceof QuestionnaireResponse) {
            return QuestionnaireResponse30_40.convertQuestionnaireResponse((QuestionnaireResponse)src);
        }
        if (src instanceof RelatedPerson) {
            return RelatedPerson30_40.convertRelatedPerson((RelatedPerson)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.RiskAssessment) {
            return RiskAssessment30_40.convertRiskAssessment((org.hl7.fhir.dstu3.model.RiskAssessment)src);
        }
        if (src instanceof Schedule) {
            return Schedule30_40.convertSchedule((Schedule)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.SearchParameter) {
            return SearchParameter30_40.convertSearchParameter((org.hl7.fhir.dstu3.model.SearchParameter)src);
        }
        if (src instanceof Sequence) {
            return Sequence30_40.convertSequence((Sequence)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Slot) {
            return Slot30_40.convertSlot((org.hl7.fhir.dstu3.model.Slot)src);
        }
        if (src instanceof Specimen) {
            return Specimen30_40.convertSpecimen((Specimen)src);
        }
        if (src instanceof StructureDefinition) {
            return StructureDefinition30_40.convertStructureDefinition((StructureDefinition)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.StructureMap) {
            return StructureMap30_40.convertStructureMap((org.hl7.fhir.dstu3.model.StructureMap)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Subscription) {
            return Subscription30_40.convertSubscription((org.hl7.fhir.dstu3.model.Subscription)src);
        }
        if (src instanceof Substance) {
            return Substance30_40.convertSubstance((Substance)src);
        }
        if (src instanceof SupplyDelivery) {
            return SupplyDelivery30_40.convertSupplyDelivery((SupplyDelivery)src);
        }
        if (src instanceof TestReport) {
            return TestReport30_40.convertTestReport((TestReport)src);
        }
        if (src instanceof TestScript) {
            return TestScript30_40.convertTestScript((TestScript)src);
        }
        if (src instanceof ValueSet) {
            return ValueSet30_40.convertValueSet((ValueSet)src);
        }
        if (!nullOk) {
            throw new FHIRException("Unknown resource " + src.fhirType());
        }
        return null;
    }

    public static org.hl7.fhir.dstu3.model.Resource convertResource(Resource src, boolean nullOk) throws FHIRException {
        if (src == null) {
            return null;
        }
        if (src instanceof org.hl7.fhir.r4.model.Parameters) {
            if (((org.hl7.fhir.r4.model.Parameters)src).hasParameter("profile-url")) {
                return ExpansionProfile30_40.convertExpansionProfile((org.hl7.fhir.r4.model.Parameters)src);
            }
            return Parameters30_40.convertParameters((org.hl7.fhir.r4.model.Parameters)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.ActivityDefinition) {
            return ActivityDefinition30_40.convertActivityDefinition((org.hl7.fhir.r4.model.ActivityDefinition)src);
        }
        if (src instanceof AllergyIntolerance) {
            return AllergyIntolerance30_40.convertAllergyIntolerance((AllergyIntolerance)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Appointment) {
            return Appointment30_40.convertAppointment((org.hl7.fhir.r4.model.Appointment)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.AppointmentResponse) {
            return AppointmentResponse30_40.convertAppointmentResponse((org.hl7.fhir.r4.model.AppointmentResponse)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.AuditEvent) {
            return AuditEvent30_40.convertAuditEvent((org.hl7.fhir.r4.model.AuditEvent)src);
        }
        if (src instanceof Basic) {
            return Basic30_40.convertBasic((Basic)src);
        }
        if (src instanceof Binary) {
            return Binary30_40.convertBinary((Binary)src);
        }
        if (src instanceof BodyStructure) {
            return BodySite30_40.convertBodySite((BodyStructure)src);
        }
        if (src instanceof Bundle) {
            return Bundle30_40.convertBundle((Bundle)src);
        }
        if (src instanceof CapabilityStatement) {
            return CapabilityStatement30_40.convertCapabilityStatement((CapabilityStatement)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.CarePlan) {
            return CarePlan30_40.convertCarePlan((org.hl7.fhir.r4.model.CarePlan)src);
        }
        if (src instanceof CareTeam) {
            return CareTeam30_40.convertCareTeam((CareTeam)src);
        }
        if (src instanceof ClinicalImpression) {
            return ClinicalImpression30_40.convertClinicalImpression((ClinicalImpression)src);
        }
        if (src instanceof CodeSystem) {
            return CodeSystem30_40.convertCodeSystem((CodeSystem)src);
        }
        if (src instanceof Communication) {
            return Communication30_40.convertCommunication((Communication)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.CompartmentDefinition) {
            return CompartmentDefinition30_40.convertCompartmentDefinition((org.hl7.fhir.r4.model.CompartmentDefinition)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Composition) {
            return Composition30_40.convertComposition((org.hl7.fhir.r4.model.Composition)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.ConceptMap) {
            return ConceptMap30_40.convertConceptMap((org.hl7.fhir.r4.model.ConceptMap)src);
        }
        if (src instanceof Condition) {
            return Condition30_40.convertCondition((Condition)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Consent) {
            return Consent30_40.convertConsent((org.hl7.fhir.r4.model.Consent)src);
        }
        if (src instanceof DetectedIssue) {
            return DetectedIssue30_40.convertDetectedIssue((DetectedIssue)src);
        }
        if (src instanceof DeviceUseStatement) {
            return DeviceUseStatement30_40.convertDeviceUseStatement((DeviceUseStatement)src);
        }
        if (src instanceof DiagnosticReport) {
            return DiagnosticReport30_40.convertDiagnosticReport((DiagnosticReport)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.DocumentReference) {
            return DocumentReference30_40.convertDocumentReference((org.hl7.fhir.r4.model.DocumentReference)src);
        }
        if (src instanceof Encounter) {
            return Encounter30_40.convertEncounter((Encounter)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Endpoint) {
            return Endpoint30_40.convertEndpoint((org.hl7.fhir.r4.model.Endpoint)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.EpisodeOfCare) {
            return EpisodeOfCare30_40.convertEpisodeOfCare((org.hl7.fhir.r4.model.EpisodeOfCare)src);
        }
        if (src instanceof FamilyMemberHistory) {
            return FamilyMemberHistory30_40.convertFamilyMemberHistory((FamilyMemberHistory)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Flag) {
            return Flag30_40.convertFlag((org.hl7.fhir.r4.model.Flag)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Goal) {
            return Goal30_40.convertGoal((org.hl7.fhir.r4.model.Goal)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.GraphDefinition) {
            return GraphDefinition30_40.convertGraphDefinition((org.hl7.fhir.r4.model.GraphDefinition)src);
        }
        if (src instanceof Group) {
            return Group30_40.convertGroup((Group)src);
        }
        if (src instanceof HealthcareService) {
            return HealthcareService30_40.convertHealthcareService((HealthcareService)src);
        }
        if (src instanceof ImagingStudy) {
            return ImagingStudy30_40.convertImagingStudy((ImagingStudy)src);
        }
        if (src instanceof Immunization) {
            return Immunization30_40.convertImmunization((Immunization)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.ImplementationGuide) {
            return ImplementationGuide30_40.convertImplementationGuide((org.hl7.fhir.r4.model.ImplementationGuide)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Library) {
            return Library30_40.convertLibrary((org.hl7.fhir.r4.model.Library)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Linkage) {
            return Linkage30_40.convertLinkage((org.hl7.fhir.r4.model.Linkage)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.ListResource) {
            return List30_40.convertList((org.hl7.fhir.r4.model.ListResource)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Location) {
            return Location30_40.convertLocation((org.hl7.fhir.r4.model.Location)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Media) {
            return Media30_40.convertMedia((org.hl7.fhir.r4.model.Media)src);
        }
        if (src instanceof Medication) {
            return Medication30_40.convertMedication((Medication)src);
        }
        if (src instanceof MedicationAdministration) {
            return MedicationAdministration30_40.convertMedicationAdministration((MedicationAdministration)src);
        }
        if (src instanceof MedicationDispense) {
            return MedicationDispense30_40.convertMedicationDispense((MedicationDispense)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.MedicationRequest) {
            return MedicationRequest30_40.convertMedicationRequest((org.hl7.fhir.r4.model.MedicationRequest)src);
        }
        if (src instanceof MedicationStatement) {
            return MedicationStatement30_40.convertMedicationStatement((MedicationStatement)src);
        }
        if (src instanceof MessageDefinition) {
            return MessageDefinition30_40.convertMessageDefinition((MessageDefinition)src);
        }
        if (src instanceof MessageHeader) {
            return MessageHeader30_40.convertMessageHeader((MessageHeader)src);
        }
        if (src instanceof NamingSystem) {
            return NamingSystem30_40.convertNamingSystem((NamingSystem)src);
        }
        if (src instanceof Observation) {
            return Observation30_40.convertObservation((Observation)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.OperationDefinition) {
            return OperationDefinition30_40.convertOperationDefinition((org.hl7.fhir.r4.model.OperationDefinition)src);
        }
        if (src instanceof OperationOutcome) {
            return OperationOutcome30_40.convertOperationOutcome((OperationOutcome)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Organization) {
            return Organization30_40.convertOrganization((org.hl7.fhir.r4.model.Organization)src);
        }
        if (src instanceof Patient) {
            return Patient30_40.convertPatient((Patient)src);
        }
        if (src instanceof PaymentNotice) {
            return PaymentNotice30_40.convertPaymentNotice((PaymentNotice)src);
        }
        if (src instanceof Person) {
            return Person30_40.convertPerson((Person)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.PlanDefinition) {
            return PlanDefinition30_40.convertPlanDefinition((org.hl7.fhir.r4.model.PlanDefinition)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Practitioner) {
            return Practitioner30_40.convertPractitioner((org.hl7.fhir.r4.model.Practitioner)src);
        }
        if (src instanceof PractitionerRole) {
            return PractitionerRole30_40.convertPractitionerRole((PractitionerRole)src);
        }
        if (src instanceof Procedure) {
            return Procedure30_40.convertProcedure((Procedure)src);
        }
        if (src instanceof ServiceRequest) {
            return ProcedureRequest30_40.convertProcedureRequest((ServiceRequest)src);
        }
        if (src instanceof Provenance) {
            return Provenance30_40.convertProvenance((Provenance)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Questionnaire) {
            return Questionnaire30_40.convertQuestionnaire((org.hl7.fhir.r4.model.Questionnaire)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.QuestionnaireResponse) {
            return QuestionnaireResponse30_40.convertQuestionnaireResponse((org.hl7.fhir.r4.model.QuestionnaireResponse)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.RelatedPerson) {
            return RelatedPerson30_40.convertRelatedPerson((org.hl7.fhir.r4.model.RelatedPerson)src);
        }
        if (src instanceof RiskAssessment) {
            return RiskAssessment30_40.convertRiskAssessment((RiskAssessment)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Schedule) {
            return Schedule30_40.convertSchedule((org.hl7.fhir.r4.model.Schedule)src);
        }
        if (src instanceof SearchParameter) {
            return SearchParameter30_40.convertSearchParameter((SearchParameter)src);
        }
        if (src instanceof MolecularSequence) {
            return Sequence30_40.convertSequence((MolecularSequence)src);
        }
        if (src instanceof Slot) {
            return Slot30_40.convertSlot((Slot)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Specimen) {
            return Specimen30_40.convertSpecimen((org.hl7.fhir.r4.model.Specimen)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.StructureDefinition) {
            return StructureDefinition30_40.convertStructureDefinition((org.hl7.fhir.r4.model.StructureDefinition)src);
        }
        if (src instanceof StructureMap) {
            return StructureMap30_40.convertStructureMap((StructureMap)src);
        }
        if (src instanceof Subscription) {
            return Subscription30_40.convertSubscription((Subscription)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Substance) {
            return Substance30_40.convertSubstance((org.hl7.fhir.r4.model.Substance)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.SupplyDelivery) {
            return SupplyDelivery30_40.convertSupplyDelivery((org.hl7.fhir.r4.model.SupplyDelivery)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.TestReport) {
            return TestReport30_40.convertTestReport((org.hl7.fhir.r4.model.TestReport)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.TestScript) {
            return TestScript30_40.convertTestScript((org.hl7.fhir.r4.model.TestScript)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.ValueSet) {
            return ValueSet30_40.convertValueSet((org.hl7.fhir.r4.model.ValueSet)src);
        }
        if (!nullOk) {
            throw new FHIRException("Unknown resource " + src.fhirType());
        }
        return null;
    }

    public static TerminologyCapabilities convertTerminologyCapabilities(Parameters src, boolean b) {
        TerminologyCapabilities res = new TerminologyCapabilities();
        for (Parameters.ParametersParameterComponent p : src.getParameter()) {
            if (!p.getName().equals("system")) continue;
            res.addCodeSystem().setUri(p.getValue().primitiveValue());
        }
        return res;
    }

    public static boolean convertsResource(String rt) {
        return Utilities.existsInList(rt, "Parameters", "ActivityDefinition", "AllergyIntolerance", "Appointment", "AppointmentResponse", "AuditEvent", "Basic", "Binary", "BodyStructure", "Bundle", "CapabilityStatement", "CarePlan", "CareTeam", "ClinicalImpression", "CodeSystem", "Communication", "CompartmentDefinition", "Composition", "ConceptMap", "Condition", "Consent", "DetectedIssue", "DeviceUseStatement", "DiagnosticReport", "DocumentReference", "Encounter", "Endpoint", "EpisodeOfCare", "FamilyMemberHistory", "Flag", "Goal", "GraphDefinition", "Group", "HealthcareService", "ImagingStudy", "Immunization", "ImplementationGuide", "Library", "Linkage", "ListResource", "Location", "Media", "Medication", "MedicationAdministration", "MedicationDispense", "MedicationRequest", "MedicationStatement", "MessageDefinition", "MessageHeader", "NamingSystem", "Observation", "OperationDefinition", "OperationOutcome", "Organization", "Patient", "PaymentNotice", "Person", "PlanDefinition", "Practitioner", "PractitionerRole", "Procedure", "ProcedureRequest", "ProcessRequest", "Provenance", "Questionnaire", "QuestionnaireResponse", "RelatedPerson", "RiskAssessment", "Schedule", "SearchParameter", "Sequence", "Slot", "Specimen", "StructureDefinition", "StructureMap", "Subscription", "Substance", "SupplyDelivery", "TestReport", "TestScript", "ValueSet");
    }

    static {
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/11179-permitted-value-conceptmap");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/11179-permitted-value-valueset");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/codesystem-map");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/cqif-library");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/elementdefinition-allowedUnits");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/elementdefinition-inheritedExtensibleValueSet");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/elementdefinition-minValueSet");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/event-instantiatesCanonical");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/questionnaire-allowedProfile");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/questionnaire-deMap");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/questionnaire-sourceStructureMap");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/questionnaire-targetStructureMap");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/questionnaire-unit-valueSet");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/valueset-map");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/valueset-supplement");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/valueset-system");
    }
}

