/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.hl7.fhir.convertors.VersionConvertorConstants;
import org.hl7.fhir.convertors.conv14_40.Bundle14_40;
import org.hl7.fhir.convertors.conv14_40.CodeSystem14_40;
import org.hl7.fhir.convertors.conv14_40.CompartmentDefinition14_40;
import org.hl7.fhir.convertors.conv14_40.ConceptMap14_40;
import org.hl7.fhir.convertors.conv14_40.Conformance14_40;
import org.hl7.fhir.convertors.conv14_40.DataElement14_40;
import org.hl7.fhir.convertors.conv14_40.ImplementationGuide14_40;
import org.hl7.fhir.convertors.conv14_40.NamingSystem14_40;
import org.hl7.fhir.convertors.conv14_40.OperationDefinition14_40;
import org.hl7.fhir.convertors.conv14_40.OperationOutcome14_40;
import org.hl7.fhir.convertors.conv14_40.Parameters14_40;
import org.hl7.fhir.convertors.conv14_40.Questionnaire14_40;
import org.hl7.fhir.convertors.conv14_40.QuestionnaireResponse14_40;
import org.hl7.fhir.convertors.conv14_40.SearchParameter14_40;
import org.hl7.fhir.convertors.conv14_40.StructureDefinition14_40;
import org.hl7.fhir.convertors.conv14_40.StructureMap14_40;
import org.hl7.fhir.convertors.conv14_40.ValueSet14_40;
import org.hl7.fhir.dstu2016may.model.Address;
import org.hl7.fhir.dstu2016may.model.Age;
import org.hl7.fhir.dstu2016may.model.Annotation;
import org.hl7.fhir.dstu2016may.model.BackboneElement;
import org.hl7.fhir.dstu2016may.model.Base64BinaryType;
import org.hl7.fhir.dstu2016may.model.Binary;
import org.hl7.fhir.dstu2016may.model.Bundle;
import org.hl7.fhir.dstu2016may.model.CodeableConcept;
import org.hl7.fhir.dstu2016may.model.CompartmentDefinition;
import org.hl7.fhir.dstu2016may.model.ConceptMap;
import org.hl7.fhir.dstu2016may.model.Conformance;
import org.hl7.fhir.dstu2016may.model.ContactPoint;
import org.hl7.fhir.dstu2016may.model.Count;
import org.hl7.fhir.dstu2016may.model.DataElement;
import org.hl7.fhir.dstu2016may.model.DecimalType;
import org.hl7.fhir.dstu2016may.model.Distance;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.Element;
import org.hl7.fhir.dstu2016may.model.ElementDefinition;
import org.hl7.fhir.dstu2016may.model.Enumerations;
import org.hl7.fhir.dstu2016may.model.HumanName;
import org.hl7.fhir.dstu2016may.model.IdType;
import org.hl7.fhir.dstu2016may.model.Identifier;
import org.hl7.fhir.dstu2016may.model.ImplementationGuide;
import org.hl7.fhir.dstu2016may.model.IntegerType;
import org.hl7.fhir.dstu2016may.model.MarkdownType;
import org.hl7.fhir.dstu2016may.model.Meta;
import org.hl7.fhir.dstu2016may.model.Money;
import org.hl7.fhir.dstu2016may.model.NamingSystem;
import org.hl7.fhir.dstu2016may.model.Narrative;
import org.hl7.fhir.dstu2016may.model.OperationDefinition;
import org.hl7.fhir.dstu2016may.model.OperationOutcome;
import org.hl7.fhir.dstu2016may.model.PositiveIntType;
import org.hl7.fhir.dstu2016may.model.PrimitiveType;
import org.hl7.fhir.dstu2016may.model.Quantity;
import org.hl7.fhir.dstu2016may.model.Ratio;
import org.hl7.fhir.dstu2016may.model.SampledData;
import org.hl7.fhir.dstu2016may.model.SearchParameter;
import org.hl7.fhir.dstu2016may.model.SimpleQuantity;
import org.hl7.fhir.dstu2016may.model.Timing;
import org.hl7.fhir.dstu2016may.model.UnsignedIntType;
import org.hl7.fhir.dstu2016may.model.ValueSet;
import org.hl7.fhir.dstu2016may.utils.ToolingExtensions;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.conformance.ProfileUtilities;
import org.hl7.fhir.r4.model.Address;
import org.hl7.fhir.r4.model.Attachment;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.CapabilityStatement;
import org.hl7.fhir.r4.model.CodeSystem;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.ConceptMap;
import org.hl7.fhir.r4.model.ContactPoint;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.DateType;
import org.hl7.fhir.r4.model.Duration;
import org.hl7.fhir.r4.model.ElementDefinition;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.HumanName;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.InstantType;
import org.hl7.fhir.r4.model.Narrative;
import org.hl7.fhir.r4.model.OidType;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r4.model.Period;
import org.hl7.fhir.r4.model.Quantity;
import org.hl7.fhir.r4.model.Questionnaire;
import org.hl7.fhir.r4.model.QuestionnaireResponse;
import org.hl7.fhir.r4.model.Range;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.Signature;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.StructureDefinition;
import org.hl7.fhir.r4.model.StructureMap;
import org.hl7.fhir.r4.model.TimeType;
import org.hl7.fhir.r4.model.Timing;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.r4.model.UsageContext;
import org.hl7.fhir.r4.model.UuidType;
import org.hl7.fhir.utilities.Utilities;

public class VersionConvertor_14_40 {
    public static List<String> CANONICAL_URLS = new ArrayList<String>();

    public static void copyElement(Element src, org.hl7.fhir.r4.model.Element tgt, String ... exemptExtensions) throws FHIRException {
        if (src.hasId()) {
            tgt.setId(src.getId());
        }
        for (org.hl7.fhir.dstu2016may.model.Extension e : src.getExtension()) {
            if (Utilities.existsInList(e.getUrl(), exemptExtensions) || e.getUrl().equals("http://hl7.org/fhir/4.0/StructureDefinition/extension-ElementDefinition.type.profile") || e.getUrl().equals("http://hl7.org/fhir/4.0/StructureDefinition/extension-ImplementationGuide.dependsOn.packageId") || e.getUrl().equals("http://hl7.org/fhir/4.0/StructureDefinition/extension-ImplementationGuide.dependsOn.version")) continue;
            tgt.addExtension(VersionConvertor_14_40.convertExtension(e));
        }
    }

    public static void copyElement(org.hl7.fhir.r4.model.Element src, Element tgt, String ... exemptExtensions) throws FHIRException {
        if (src.hasId()) {
            tgt.setId(src.getId());
        }
        for (Extension e : src.getExtension()) {
            if (Utilities.existsInList(e.getUrl(), exemptExtensions)) continue;
            tgt.addExtension(VersionConvertor_14_40.convertExtension(e));
        }
    }

    public static void copyBackboneElement(BackboneElement src, org.hl7.fhir.r4.model.BackboneElement tgt) throws FHIRException {
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        for (org.hl7.fhir.dstu2016may.model.Extension e : src.getModifierExtension()) {
            tgt.addModifierExtension(VersionConvertor_14_40.convertExtension(e));
        }
    }

    public static void copyBackboneElement(org.hl7.fhir.r4.model.BackboneElement src, BackboneElement tgt) throws FHIRException {
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        for (Extension e : src.getModifierExtension()) {
            tgt.addModifierExtension(VersionConvertor_14_40.convertExtension(e));
        }
    }

    public static org.hl7.fhir.r4.model.Base64BinaryType convertBase64Binary(Base64BinaryType src) throws FHIRException {
        org.hl7.fhir.r4.model.Base64BinaryType tgt = new org.hl7.fhir.r4.model.Base64BinaryType();
        if (src.hasValue()) {
            tgt.setValue((byte[])src.getValue());
        }
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static Base64BinaryType convertBase64Binary(org.hl7.fhir.r4.model.Base64BinaryType src) throws FHIRException {
        Base64BinaryType tgt = new Base64BinaryType();
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static BooleanType convertBoolean(org.hl7.fhir.dstu2016may.model.BooleanType src) throws FHIRException {
        BooleanType tgt = new BooleanType();
        if (src.hasValue()) {
            tgt.setValue((Boolean)src.getValue());
        }
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.BooleanType convertBoolean(BooleanType src) throws FHIRException {
        org.hl7.fhir.dstu2016may.model.BooleanType tgt = new org.hl7.fhir.dstu2016may.model.BooleanType();
        if (src.hasValue()) {
            tgt.setValue((Boolean)src.getValue());
        }
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static CodeType convertCode(org.hl7.fhir.dstu2016may.model.CodeType src) throws FHIRException {
        CodeType tgt = new CodeType();
        if (src.hasValue()) {
            tgt.setValue((String)src.getValue());
        }
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.CodeType convertCode(CodeType src) throws FHIRException {
        org.hl7.fhir.dstu2016may.model.CodeType tgt = new org.hl7.fhir.dstu2016may.model.CodeType();
        if (src.hasValue()) {
            tgt.setValue((String)src.getValue());
        }
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static DateType convertDate(org.hl7.fhir.dstu2016may.model.DateType src) throws FHIRException {
        DateType tgt = new DateType();
        if (src.hasValue()) {
            tgt.setValue((Date)src.getValue());
        }
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.DateType convertDate(DateType src) throws FHIRException {
        org.hl7.fhir.dstu2016may.model.DateType tgt = new org.hl7.fhir.dstu2016may.model.DateType();
        if (src.hasValue()) {
            tgt.setValue((Date)src.getValue());
        }
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static DateTimeType convertDateTime(org.hl7.fhir.dstu2016may.model.DateTimeType src) throws FHIRException {
        DateTimeType tgt = new DateTimeType();
        if (src.hasValue()) {
            tgt.setValue((Date)src.getValue());
        }
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.DateTimeType convertDateTime(DateTimeType src) throws FHIRException {
        org.hl7.fhir.dstu2016may.model.DateTimeType tgt = new org.hl7.fhir.dstu2016may.model.DateTimeType();
        if (src.hasValue()) {
            tgt.setValue((Date)src.getValue());
        }
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.r4.model.DecimalType convertDecimal(DecimalType src) throws FHIRException {
        org.hl7.fhir.r4.model.DecimalType tgt = new org.hl7.fhir.r4.model.DecimalType();
        if (src.hasValue()) {
            tgt.setValue((BigDecimal)src.getValue());
        }
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static DecimalType convertDecimal(org.hl7.fhir.r4.model.DecimalType src) throws FHIRException {
        DecimalType tgt = new DecimalType();
        if (src.hasValue()) {
            tgt.setValue((BigDecimal)src.getValue());
        }
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.r4.model.IdType convertId(IdType src) throws FHIRException {
        org.hl7.fhir.r4.model.IdType tgt = new org.hl7.fhir.r4.model.IdType();
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static IdType convertId(org.hl7.fhir.r4.model.IdType src) throws FHIRException {
        IdType tgt = new IdType();
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static InstantType convertInstant(org.hl7.fhir.dstu2016may.model.InstantType src) throws FHIRException {
        InstantType tgt = new InstantType();
        if (src.hasValue()) {
            tgt.setValue((Date)src.getValue());
        }
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.InstantType convertInstant(InstantType src) throws FHIRException {
        org.hl7.fhir.dstu2016may.model.InstantType tgt = new org.hl7.fhir.dstu2016may.model.InstantType();
        if (src.hasValue()) {
            tgt.setValue((Date)src.getValue());
        }
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.r4.model.IntegerType convertInteger(IntegerType src) throws FHIRException {
        org.hl7.fhir.r4.model.IntegerType tgt = new org.hl7.fhir.r4.model.IntegerType();
        if (src.hasValue()) {
            tgt.setValue((Integer)src.getValue());
        }
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static IntegerType convertInteger(org.hl7.fhir.r4.model.IntegerType src) throws FHIRException {
        IntegerType tgt = new IntegerType();
        if (src.hasValue()) {
            tgt.setValue((Integer)src.getValue());
        }
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.r4.model.MarkdownType convertMarkdown(MarkdownType src) throws FHIRException {
        org.hl7.fhir.r4.model.MarkdownType tgt = new org.hl7.fhir.r4.model.MarkdownType();
        if (src.hasValue()) {
            tgt.setValue((String)src.getValue());
        }
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static MarkdownType convertMarkdown(org.hl7.fhir.r4.model.MarkdownType src) throws FHIRException {
        MarkdownType tgt = new MarkdownType();
        if (src.hasValue()) {
            tgt.setValue((String)src.getValue());
        }
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static OidType convertOid(org.hl7.fhir.dstu2016may.model.OidType src) throws FHIRException {
        OidType tgt = new OidType();
        if (src.hasValue()) {
            tgt.setValue((String)src.getValue());
        }
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.OidType convertOid(OidType src) throws FHIRException {
        org.hl7.fhir.dstu2016may.model.OidType tgt = new org.hl7.fhir.dstu2016may.model.OidType();
        if (src.hasValue()) {
            tgt.setValue((String)src.getValue());
        }
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.r4.model.PositiveIntType convertPositiveInt(PositiveIntType src) throws FHIRException {
        org.hl7.fhir.r4.model.PositiveIntType tgt = new org.hl7.fhir.r4.model.PositiveIntType();
        if (src.hasValue()) {
            tgt.setValue((Integer)src.getValue());
        }
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static PositiveIntType convertPositiveInt(org.hl7.fhir.r4.model.PositiveIntType src) throws FHIRException {
        PositiveIntType tgt = new PositiveIntType();
        if (src.hasValue()) {
            tgt.setValue((Integer)src.getValue());
        }
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static StringType convertString(org.hl7.fhir.dstu2016may.model.StringType src) throws FHIRException {
        StringType tgt = new StringType();
        if (src.hasValue()) {
            tgt.setValue((String)src.getValue());
        }
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.StringType convertString(StringType src) throws FHIRException {
        org.hl7.fhir.dstu2016may.model.StringType tgt = new org.hl7.fhir.dstu2016may.model.StringType();
        if (src.hasValue()) {
            tgt.setValue((String)src.getValue());
        }
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static TimeType convertTime(org.hl7.fhir.dstu2016may.model.TimeType src) throws FHIRException {
        TimeType tgt = new TimeType();
        if (src.hasValue()) {
            tgt.setValue((String)src.getValue());
        }
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.TimeType convertTime(TimeType src) throws FHIRException {
        org.hl7.fhir.dstu2016may.model.TimeType tgt = new org.hl7.fhir.dstu2016may.model.TimeType();
        if (src.hasValue()) {
            tgt.setValue((String)src.getValue());
        }
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.r4.model.UnsignedIntType convertUnsignedInt(UnsignedIntType src) throws FHIRException {
        org.hl7.fhir.r4.model.UnsignedIntType tgt = new org.hl7.fhir.r4.model.UnsignedIntType();
        if (src.hasValue()) {
            tgt.setValue((Integer)src.getValue());
        }
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static UnsignedIntType convertUnsignedInt(org.hl7.fhir.r4.model.UnsignedIntType src) throws FHIRException {
        UnsignedIntType tgt = new UnsignedIntType();
        if (src.hasValue()) {
            tgt.setValue((Integer)src.getValue());
        }
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static UriType convertUri(org.hl7.fhir.dstu2016may.model.UriType src) throws FHIRException {
        UriType tgt = new UriType();
        if (src.hasValue()) {
            tgt.setValue((String)src.getValue());
        }
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.UriType convertUri(UriType src) throws FHIRException {
        org.hl7.fhir.dstu2016may.model.UriType tgt = new org.hl7.fhir.dstu2016may.model.UriType();
        if (src.hasValue()) {
            tgt.setValue((String)src.getValue());
        }
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static UuidType convertUuid(org.hl7.fhir.dstu2016may.model.UuidType src) throws FHIRException {
        UuidType tgt = new UuidType();
        if (src.hasValue()) {
            tgt.setValue((String)src.getValue());
        }
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.UuidType convertUuid(UuidType src) throws FHIRException {
        org.hl7.fhir.dstu2016may.model.UuidType tgt = new org.hl7.fhir.dstu2016may.model.UuidType();
        if (src.hasValue()) {
            tgt.setValue((String)src.getValue());
        }
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static Extension convertExtension(org.hl7.fhir.dstu2016may.model.Extension src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Extension tgt = new Extension();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasUrlElement()) {
            tgt.setUrlElement(VersionConvertor_14_40.convertUri(src.getUrlElement()));
        }
        if (src.hasValue()) {
            if (CANONICAL_URLS.contains(src.getUrl()) && src.getValue() instanceof org.hl7.fhir.dstu2016may.model.Reference) {
                tgt.setValue(VersionConvertor_14_40.convertReferenceToCanonical((org.hl7.fhir.dstu2016may.model.Reference)src.getValue()));
            } else {
                tgt.setValue(VersionConvertor_14_40.convertType(src.getValue()));
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Extension convertExtension(Extension src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Extension tgt = new org.hl7.fhir.dstu2016may.model.Extension();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasUrlElement()) {
            tgt.setUrlElement(VersionConvertor_14_40.convertUri(src.getUrlElement()));
        }
        if (src.hasValue()) {
            if (CANONICAL_URLS.contains(src.getUrl()) && src.getValue() instanceof CanonicalType) {
                tgt.setValue(VersionConvertor_14_40.convertCanonicalToReference((CanonicalType)src.getValue()));
            } else {
                tgt.setValue(VersionConvertor_14_40.convertType(src.getValue()));
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Narrative convertNarrative(Narrative src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Narrative tgt = new org.hl7.fhir.r4.model.Narrative();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasStatus()) {
            tgt.setStatusElement(VersionConvertor_14_40.convertNarrativeStatus(src.getStatusElement()));
        }
        tgt.setDiv(src.getDiv());
        return tgt;
    }

    public static Narrative convertNarrative(org.hl7.fhir.r4.model.Narrative src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Narrative tgt = new Narrative();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasStatus()) {
            tgt.setStatusElement(VersionConvertor_14_40.convertNarrativeStatus(src.getStatusElement()));
        }
        tgt.setDiv(src.getDiv());
        return tgt;
    }

    public static Enumeration<Narrative.NarrativeStatus> convertNarrativeStatus(org.hl7.fhir.dstu2016may.model.Enumeration<Narrative.NarrativeStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Narrative.NarrativeStatus> tgt = new Enumeration<Narrative.NarrativeStatus>(new Narrative.NarrativeStatusEnumFactory());
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        switch ((Narrative.NarrativeStatus)((Object)src.getValue())) {
            case GENERATED: {
                tgt.setValue((Object)Narrative.NarrativeStatus.GENERATED);
                break;
            }
            case EXTENSIONS: {
                tgt.setValue((Object)Narrative.NarrativeStatus.EXTENSIONS);
                break;
            }
            case ADDITIONAL: {
                tgt.setValue((Object)Narrative.NarrativeStatus.ADDITIONAL);
                break;
            }
            case EMPTY: {
                tgt.setValue((Object)Narrative.NarrativeStatus.EMPTY);
                break;
            }
            default: {
                tgt.setValue((Object)Narrative.NarrativeStatus.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Enumeration<Narrative.NarrativeStatus> convertNarrativeStatus(Enumeration<Narrative.NarrativeStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Enumeration<Narrative.NarrativeStatus> tgt = new org.hl7.fhir.dstu2016may.model.Enumeration<Narrative.NarrativeStatus>(new Narrative.NarrativeStatusEnumFactory());
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        switch ((Narrative.NarrativeStatus)((Object)src.getValue())) {
            case GENERATED: {
                tgt.setValue((Object)Narrative.NarrativeStatus.GENERATED);
                break;
            }
            case EXTENSIONS: {
                tgt.setValue((Object)Narrative.NarrativeStatus.EXTENSIONS);
                break;
            }
            case ADDITIONAL: {
                tgt.setValue((Object)Narrative.NarrativeStatus.ADDITIONAL);
                break;
            }
            case EMPTY: {
                tgt.setValue((Object)Narrative.NarrativeStatus.EMPTY);
                break;
            }
            default: {
                tgt.setValue((Object)Narrative.NarrativeStatus.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Age convertAge(Age src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Age tgt = new org.hl7.fhir.r4.model.Age();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_14_40.convertDecimal(src.getValueElement()));
        }
        if (src.hasComparator()) {
            tgt.setComparatorElement(VersionConvertor_14_40.convertQuantityComparator(src.getComparatorElement()));
        }
        if (src.hasUnit()) {
            tgt.setUnitElement(VersionConvertor_14_40.convertString(src.getUnitElement()));
        }
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_14_40.convertUri(src.getSystemElement()));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_14_40.convertCode(src.getCodeElement()));
        }
        return tgt;
    }

    public static Age convertAge(org.hl7.fhir.r4.model.Age src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Age tgt = new Age();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_14_40.convertDecimal(src.getValueElement()));
        }
        if (src.hasComparator()) {
            tgt.setComparatorElement(VersionConvertor_14_40.convertQuantityComparator(src.getComparatorElement()));
        }
        if (src.hasUnit()) {
            tgt.setUnitElement(VersionConvertor_14_40.convertString(src.getUnitElement()));
        }
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_14_40.convertUri(src.getSystemElement()));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_14_40.convertCode(src.getCodeElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Annotation convertAnnotation(Annotation src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Annotation tgt = new org.hl7.fhir.r4.model.Annotation();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasAuthor()) {
            tgt.setAuthor(VersionConvertor_14_40.convertType(src.getAuthor()));
        }
        if (src.hasTime()) {
            tgt.setTimeElement(VersionConvertor_14_40.convertDateTime(src.getTimeElement()));
        }
        tgt.setText(src.getText());
        return tgt;
    }

    public static Annotation convertAnnotation(org.hl7.fhir.r4.model.Annotation src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Annotation tgt = new Annotation();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasAuthor()) {
            tgt.setAuthor(VersionConvertor_14_40.convertType(src.getAuthor()));
        }
        if (src.hasTime()) {
            tgt.setTimeElement(VersionConvertor_14_40.convertDateTime(src.getTimeElement()));
        }
        tgt.setText(src.getText());
        return tgt;
    }

    public static Attachment convertAttachment(org.hl7.fhir.dstu2016may.model.Attachment src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Attachment tgt = new Attachment();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasContentType()) {
            tgt.setContentTypeElement(VersionConvertor_14_40.convertCode(src.getContentTypeElement()));
        }
        if (src.hasLanguage()) {
            tgt.setLanguageElement(VersionConvertor_14_40.convertCode(src.getLanguageElement()));
        }
        if (src.hasData()) {
            tgt.setDataElement(VersionConvertor_14_40.convertBase64Binary(src.getDataElement()));
        }
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        if (src.hasSize()) {
            tgt.setSizeElement(VersionConvertor_14_40.convertUnsignedInt(src.getSizeElement()));
        }
        if (src.hasHash()) {
            tgt.setHashElement(VersionConvertor_14_40.convertBase64Binary(src.getHashElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(VersionConvertor_14_40.convertString(src.getTitleElement()));
        }
        if (src.hasCreation()) {
            tgt.setCreationElement(VersionConvertor_14_40.convertDateTime(src.getCreationElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Attachment convertAttachment(Attachment src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Attachment tgt = new org.hl7.fhir.dstu2016may.model.Attachment();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasContentType()) {
            tgt.setContentTypeElement(VersionConvertor_14_40.convertCode(src.getContentTypeElement()));
        }
        if (src.hasLanguage()) {
            tgt.setLanguageElement(VersionConvertor_14_40.convertCode(src.getLanguageElement()));
        }
        if (src.hasData()) {
            tgt.setDataElement(VersionConvertor_14_40.convertBase64Binary(src.getDataElement()));
        }
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        if (src.hasSize()) {
            tgt.setSizeElement(VersionConvertor_14_40.convertUnsignedInt(src.getSizeElement()));
        }
        if (src.hasHash()) {
            tgt.setHashElement(VersionConvertor_14_40.convertBase64Binary(src.getHashElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(VersionConvertor_14_40.convertString(src.getTitleElement()));
        }
        if (src.hasCreation()) {
            tgt.setCreationElement(VersionConvertor_14_40.convertDateTime(src.getCreationElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.CodeableConcept convertCodeableConcept(CodeableConcept src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.CodeableConcept tgt = new org.hl7.fhir.r4.model.CodeableConcept();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        for (org.hl7.fhir.dstu2016may.model.Coding t : src.getCoding()) {
            tgt.addCoding(VersionConvertor_14_40.convertCoding(t));
        }
        if (src.hasText()) {
            tgt.setTextElement(VersionConvertor_14_40.convertString(src.getTextElement()));
        }
        return tgt;
    }

    public static CodeableConcept convertCodeableConcept(org.hl7.fhir.r4.model.CodeableConcept src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CodeableConcept tgt = new CodeableConcept();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        for (Coding t : src.getCoding()) {
            tgt.addCoding(VersionConvertor_14_40.convertCoding(t));
        }
        if (src.hasText()) {
            tgt.setTextElement(VersionConvertor_14_40.convertString(src.getTextElement()));
        }
        return tgt;
    }

    public static Coding convertCoding(org.hl7.fhir.dstu2016may.model.Coding src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Coding tgt = new Coding();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_14_40.convertUri(src.getSystemElement()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_14_40.convertString(src.getVersionElement()));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_14_40.convertCode(src.getCodeElement()));
        }
        if (src.hasDisplay()) {
            tgt.setDisplayElement(VersionConvertor_14_40.convertString(src.getDisplayElement()));
        }
        if (src.hasUserSelected()) {
            tgt.setUserSelectedElement(VersionConvertor_14_40.convertBoolean(src.getUserSelectedElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Coding convertCoding(Coding src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Coding tgt = new org.hl7.fhir.dstu2016may.model.Coding();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_14_40.convertUri(src.getSystemElement()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_14_40.convertString(src.getVersionElement()));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_14_40.convertCode(src.getCodeElement()));
        }
        if (src.hasDisplay()) {
            tgt.setDisplayElement(VersionConvertor_14_40.convertString(src.getDisplayElement()));
        }
        if (src.hasUserSelected()) {
            tgt.setUserSelectedElement(VersionConvertor_14_40.convertBoolean(src.getUserSelectedElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Count convertCount(Count src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Count tgt = new org.hl7.fhir.r4.model.Count();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_14_40.convertDecimal(src.getValueElement()));
        }
        if (src.hasComparator()) {
            tgt.setComparatorElement(VersionConvertor_14_40.convertQuantityComparator(src.getComparatorElement()));
        }
        if (src.hasUnit()) {
            tgt.setUnitElement(VersionConvertor_14_40.convertString(src.getUnitElement()));
        }
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_14_40.convertUri(src.getSystemElement()));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_14_40.convertCode(src.getCodeElement()));
        }
        return tgt;
    }

    public static Count convertCount(org.hl7.fhir.r4.model.Count src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Count tgt = new Count();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_14_40.convertDecimal(src.getValueElement()));
        }
        if (src.hasComparator()) {
            tgt.setComparatorElement(VersionConvertor_14_40.convertQuantityComparator(src.getComparatorElement()));
        }
        if (src.hasUnit()) {
            tgt.setUnitElement(VersionConvertor_14_40.convertString(src.getUnitElement()));
        }
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_14_40.convertUri(src.getSystemElement()));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_14_40.convertCode(src.getCodeElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Distance convertDistance(Distance src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Distance tgt = new org.hl7.fhir.r4.model.Distance();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_14_40.convertDecimal(src.getValueElement()));
        }
        if (src.hasComparator()) {
            tgt.setComparatorElement(VersionConvertor_14_40.convertQuantityComparator(src.getComparatorElement()));
        }
        if (src.hasUnit()) {
            tgt.setUnitElement(VersionConvertor_14_40.convertString(src.getUnitElement()));
        }
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_14_40.convertUri(src.getSystemElement()));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_14_40.convertCode(src.getCodeElement()));
        }
        return tgt;
    }

    public static Distance convertDistance(org.hl7.fhir.r4.model.Distance src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Distance tgt = new Distance();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_14_40.convertDecimal(src.getValueElement()));
        }
        if (src.hasComparator()) {
            tgt.setComparatorElement(VersionConvertor_14_40.convertQuantityComparator(src.getComparatorElement()));
        }
        if (src.hasUnit()) {
            tgt.setUnitElement(VersionConvertor_14_40.convertString(src.getUnitElement()));
        }
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_14_40.convertUri(src.getSystemElement()));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_14_40.convertCode(src.getCodeElement()));
        }
        return tgt;
    }

    public static Duration convertDuration(org.hl7.fhir.dstu2016may.model.Duration src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Duration tgt = new Duration();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_14_40.convertDecimal(src.getValueElement()));
        }
        if (src.hasComparator()) {
            tgt.setComparatorElement(VersionConvertor_14_40.convertQuantityComparator(src.getComparatorElement()));
        }
        if (src.hasUnit()) {
            tgt.setUnitElement(VersionConvertor_14_40.convertString(src.getUnitElement()));
        }
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_14_40.convertUri(src.getSystemElement()));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_14_40.convertCode(src.getCodeElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Duration convertDuration(Duration src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Duration tgt = new org.hl7.fhir.dstu2016may.model.Duration();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_14_40.convertDecimal(src.getValueElement()));
        }
        if (src.hasComparator()) {
            tgt.setComparatorElement(VersionConvertor_14_40.convertQuantityComparator(src.getComparatorElement()));
        }
        if (src.hasUnit()) {
            tgt.setUnitElement(VersionConvertor_14_40.convertString(src.getUnitElement()));
        }
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_14_40.convertUri(src.getSystemElement()));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_14_40.convertCode(src.getCodeElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Money convertMoney(Money src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Money tgt = new org.hl7.fhir.r4.model.Money();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_14_40.convertDecimal(src.getValueElement()));
        }
        if (src.hasCode()) {
            tgt.setCurrencyElement(VersionConvertor_14_40.convertCode(src.getCodeElement()));
        }
        return tgt;
    }

    public static Money convertMoney(org.hl7.fhir.r4.model.Money src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Money tgt = new Money();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_14_40.convertDecimal(src.getValueElement()));
        }
        if (src.hasCurrency()) {
            tgt.setCodeElement(VersionConvertor_14_40.convertCode(src.getCurrencyElement()));
        }
        return tgt;
    }

    public static Identifier convertIdentifier(org.hl7.fhir.dstu2016may.model.Identifier src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Identifier tgt = new Identifier();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasUse()) {
            tgt.setUseElement(VersionConvertor_14_40.convertIdentifierUse(src.getUseElement()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_14_40.convertCodeableConcept(src.getType()));
        }
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_14_40.convertUri(src.getSystemElement()));
        }
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_14_40.convertString(src.getValueElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_14_40.convertPeriod(src.getPeriod()));
        }
        if (src.hasAssigner()) {
            tgt.setAssigner(VersionConvertor_14_40.convertReference(src.getAssigner()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Identifier convertIdentifier(Identifier src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Identifier tgt = new org.hl7.fhir.dstu2016may.model.Identifier();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasUse()) {
            tgt.setUseElement(VersionConvertor_14_40.convertIdentifierUse(src.getUseElement()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_14_40.convertCodeableConcept(src.getType()));
        }
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_14_40.convertUri(src.getSystemElement()));
        }
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_14_40.convertString(src.getValueElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_14_40.convertPeriod(src.getPeriod()));
        }
        if (src.hasAssigner()) {
            tgt.setAssigner(VersionConvertor_14_40.convertReference(src.getAssigner()));
        }
        return tgt;
    }

    public static Enumeration<Identifier.IdentifierUse> convertIdentifierUse(org.hl7.fhir.dstu2016may.model.Enumeration<Identifier.IdentifierUse> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Identifier.IdentifierUse> tgt = new Enumeration<Identifier.IdentifierUse>(new Identifier.IdentifierUseEnumFactory());
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        switch ((Identifier.IdentifierUse)((Object)src.getValue())) {
            case USUAL: {
                tgt.setValue((Object)Identifier.IdentifierUse.USUAL);
                break;
            }
            case OFFICIAL: {
                tgt.setValue((Object)Identifier.IdentifierUse.OFFICIAL);
                break;
            }
            case TEMP: {
                tgt.setValue((Object)Identifier.IdentifierUse.TEMP);
                break;
            }
            case SECONDARY: {
                tgt.setValue((Object)Identifier.IdentifierUse.SECONDARY);
                break;
            }
            default: {
                tgt.setValue((Object)Identifier.IdentifierUse.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Enumeration<Identifier.IdentifierUse> convertIdentifierUse(Enumeration<Identifier.IdentifierUse> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Enumeration<Identifier.IdentifierUse> tgt = new org.hl7.fhir.dstu2016may.model.Enumeration<Identifier.IdentifierUse>(new Identifier.IdentifierUseEnumFactory());
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        switch ((Identifier.IdentifierUse)((Object)src.getValue())) {
            case USUAL: {
                tgt.setValue((Object)Identifier.IdentifierUse.USUAL);
                break;
            }
            case OFFICIAL: {
                tgt.setValue((Object)Identifier.IdentifierUse.OFFICIAL);
                break;
            }
            case TEMP: {
                tgt.setValue((Object)Identifier.IdentifierUse.TEMP);
                break;
            }
            case SECONDARY: {
                tgt.setValue((Object)Identifier.IdentifierUse.SECONDARY);
                break;
            }
            default: {
                tgt.setValue((Object)Identifier.IdentifierUse.NULL);
            }
        }
        return tgt;
    }

    public static Period convertPeriod(org.hl7.fhir.dstu2016may.model.Period src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Period tgt = new Period();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasStart()) {
            tgt.setStartElement(VersionConvertor_14_40.convertDateTime(src.getStartElement()));
        }
        if (src.hasEnd()) {
            tgt.setEndElement(VersionConvertor_14_40.convertDateTime(src.getEndElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Period convertPeriod(Period src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Period tgt = new org.hl7.fhir.dstu2016may.model.Period();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasStart()) {
            tgt.setStartElement(VersionConvertor_14_40.convertDateTime(src.getStartElement()));
        }
        if (src.hasEnd()) {
            tgt.setEndElement(VersionConvertor_14_40.convertDateTime(src.getEndElement()));
        }
        return tgt;
    }

    public static Quantity convertQuantity(org.hl7.fhir.dstu2016may.model.Quantity src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Quantity tgt = new Quantity();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_14_40.convertDecimal(src.getValueElement()));
        }
        if (src.hasComparator()) {
            tgt.setComparatorElement(VersionConvertor_14_40.convertQuantityComparator(src.getComparatorElement()));
        }
        if (src.hasUnit()) {
            tgt.setUnitElement(VersionConvertor_14_40.convertString(src.getUnitElement()));
        }
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_14_40.convertUri(src.getSystemElement()));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_14_40.convertCode(src.getCodeElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Quantity convertQuantity(Quantity src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Quantity tgt = new org.hl7.fhir.dstu2016may.model.Quantity();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_14_40.convertDecimal(src.getValueElement()));
        }
        if (src.hasComparator()) {
            tgt.setComparatorElement(VersionConvertor_14_40.convertQuantityComparator(src.getComparatorElement()));
        }
        if (src.hasUnit()) {
            tgt.setUnitElement(VersionConvertor_14_40.convertString(src.getUnitElement()));
        }
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_14_40.convertUri(src.getSystemElement()));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_14_40.convertCode(src.getCodeElement()));
        }
        return tgt;
    }

    public static Enumeration<Quantity.QuantityComparator> convertQuantityComparator(org.hl7.fhir.dstu2016may.model.Enumeration<Quantity.QuantityComparator> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Quantity.QuantityComparator> tgt = new Enumeration<Quantity.QuantityComparator>(new Quantity.QuantityComparatorEnumFactory());
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        switch ((Quantity.QuantityComparator)((Object)src.getValue())) {
            case LESS_THAN: {
                tgt.setValue((Object)Quantity.QuantityComparator.LESS_THAN);
                break;
            }
            case LESS_OR_EQUAL: {
                tgt.setValue((Object)Quantity.QuantityComparator.LESS_OR_EQUAL);
                break;
            }
            case GREATER_OR_EQUAL: {
                tgt.setValue((Object)Quantity.QuantityComparator.GREATER_OR_EQUAL);
                break;
            }
            case GREATER_THAN: {
                tgt.setValue((Object)Quantity.QuantityComparator.GREATER_THAN);
                break;
            }
            default: {
                tgt.setValue((Object)Quantity.QuantityComparator.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Enumeration<Quantity.QuantityComparator> convertQuantityComparator(Enumeration<Quantity.QuantityComparator> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Enumeration<Quantity.QuantityComparator> tgt = new org.hl7.fhir.dstu2016may.model.Enumeration<Quantity.QuantityComparator>(new Quantity.QuantityComparatorEnumFactory());
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        switch ((Quantity.QuantityComparator)((Object)src.getValue())) {
            case LESS_THAN: {
                tgt.setValue((Object)Quantity.QuantityComparator.LESS_THAN);
                break;
            }
            case LESS_OR_EQUAL: {
                tgt.setValue((Object)Quantity.QuantityComparator.LESS_OR_EQUAL);
                break;
            }
            case GREATER_OR_EQUAL: {
                tgt.setValue((Object)Quantity.QuantityComparator.GREATER_OR_EQUAL);
                break;
            }
            case GREATER_THAN: {
                tgt.setValue((Object)Quantity.QuantityComparator.GREATER_THAN);
                break;
            }
            default: {
                tgt.setValue((Object)Quantity.QuantityComparator.NULL);
            }
        }
        return tgt;
    }

    public static Range convertRange(org.hl7.fhir.dstu2016may.model.Range src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Range tgt = new Range();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasLow()) {
            tgt.setLow(VersionConvertor_14_40.convertSimpleQuantity(src.getLow()));
        }
        if (src.hasHigh()) {
            tgt.setHigh(VersionConvertor_14_40.convertSimpleQuantity(src.getHigh()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Range convertRange(Range src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Range tgt = new org.hl7.fhir.dstu2016may.model.Range();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasLow()) {
            tgt.setLow(VersionConvertor_14_40.convertSimpleQuantity(src.getLow()));
        }
        if (src.hasHigh()) {
            tgt.setHigh(VersionConvertor_14_40.convertSimpleQuantity(src.getHigh()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Ratio convertRatio(Ratio src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Ratio tgt = new org.hl7.fhir.r4.model.Ratio();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasNumerator()) {
            tgt.setNumerator(VersionConvertor_14_40.convertQuantity(src.getNumerator()));
        }
        if (src.hasDenominator()) {
            tgt.setDenominator(VersionConvertor_14_40.convertQuantity(src.getDenominator()));
        }
        return tgt;
    }

    public static Ratio convertRatio(org.hl7.fhir.r4.model.Ratio src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Ratio tgt = new Ratio();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasNumerator()) {
            tgt.setNumerator(VersionConvertor_14_40.convertQuantity(src.getNumerator()));
        }
        if (src.hasDenominator()) {
            tgt.setDenominator(VersionConvertor_14_40.convertQuantity(src.getDenominator()));
        }
        return tgt;
    }

    public static Reference convertReference(org.hl7.fhir.dstu2016may.model.Reference src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Reference tgt = new Reference();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasReference()) {
            tgt.setReference(src.getReference());
        }
        if (src.hasDisplay()) {
            tgt.setDisplayElement(VersionConvertor_14_40.convertString(src.getDisplayElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Reference convertReference(Reference src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Reference tgt = new org.hl7.fhir.dstu2016may.model.Reference();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasReference()) {
            tgt.setReference(src.getReference());
        }
        if (src.hasDisplay()) {
            tgt.setDisplayElement(VersionConvertor_14_40.convertString(src.getDisplayElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.SampledData convertSampledData(SampledData src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.SampledData tgt = new org.hl7.fhir.r4.model.SampledData();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasOrigin()) {
            tgt.setOrigin(VersionConvertor_14_40.convertSimpleQuantity(src.getOrigin()));
        }
        if (src.hasPeriodElement()) {
            tgt.setPeriodElement(VersionConvertor_14_40.convertDecimal(src.getPeriodElement()));
        }
        if (src.hasFactor()) {
            tgt.setFactorElement(VersionConvertor_14_40.convertDecimal(src.getFactorElement()));
        }
        if (src.hasLowerLimit()) {
            tgt.setLowerLimitElement(VersionConvertor_14_40.convertDecimal(src.getLowerLimitElement()));
        }
        if (src.hasUpperLimit()) {
            tgt.setUpperLimitElement(VersionConvertor_14_40.convertDecimal(src.getUpperLimitElement()));
        }
        if (src.hasDimensionsElement()) {
            tgt.setDimensionsElement(VersionConvertor_14_40.convertPositiveInt(src.getDimensionsElement()));
        }
        if (src.hasDataElement()) {
            tgt.setDataElement(VersionConvertor_14_40.convertString(src.getDataElement()));
        }
        return tgt;
    }

    public static SampledData convertSampledData(org.hl7.fhir.r4.model.SampledData src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        SampledData tgt = new SampledData();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasOrigin()) {
            tgt.setOrigin(VersionConvertor_14_40.convertSimpleQuantity(src.getOrigin()));
        }
        if (src.hasPeriodElement()) {
            tgt.setPeriodElement(VersionConvertor_14_40.convertDecimal(src.getPeriodElement()));
        }
        if (src.hasFactor()) {
            tgt.setFactorElement(VersionConvertor_14_40.convertDecimal(src.getFactorElement()));
        }
        if (src.hasLowerLimit()) {
            tgt.setLowerLimitElement(VersionConvertor_14_40.convertDecimal(src.getLowerLimitElement()));
        }
        if (src.hasUpperLimit()) {
            tgt.setUpperLimitElement(VersionConvertor_14_40.convertDecimal(src.getUpperLimitElement()));
        }
        if (src.hasDimensionsElement()) {
            tgt.setDimensionsElement(VersionConvertor_14_40.convertPositiveInt(src.getDimensionsElement()));
        }
        if (src.hasDataElement()) {
            tgt.setDataElement(VersionConvertor_14_40.convertString(src.getDataElement()));
        }
        return tgt;
    }

    public static Signature convertSignature(org.hl7.fhir.dstu2016may.model.Signature src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Signature tgt = new Signature();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        for (org.hl7.fhir.dstu2016may.model.Coding t : src.getType()) {
            tgt.addType(VersionConvertor_14_40.convertCoding(t));
        }
        if (src.hasWhenElement()) {
            tgt.setWhenElement(VersionConvertor_14_40.convertInstant(src.getWhenElement()));
        }
        if (src.hasWhoUriType()) {
            tgt.setWho(new Reference((String)src.getWhoUriType().getValue()));
        } else {
            tgt.setWho(VersionConvertor_14_40.convertReference(src.getWhoReference()));
        }
        if (src.hasContentType()) {
            tgt.setSigFormatElement(VersionConvertor_14_40.convertCode(src.getContentTypeElement()));
        }
        if (src.hasBlob()) {
            tgt.setDataElement(VersionConvertor_14_40.convertBase64Binary(src.getBlobElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Signature convertSignature(Signature src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Signature tgt = new org.hl7.fhir.dstu2016may.model.Signature();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        for (Coding t : src.getType()) {
            tgt.addType(VersionConvertor_14_40.convertCoding(t));
        }
        if (src.hasWhenElement()) {
            tgt.setWhenElement(VersionConvertor_14_40.convertInstant(src.getWhenElement()));
        }
        if (src.hasWho()) {
            tgt.setWho(VersionConvertor_14_40.convertType(src.getWho()));
        }
        if (src.hasSigFormat()) {
            tgt.setContentTypeElement(VersionConvertor_14_40.convertCode(src.getSigFormatElement()));
        }
        if (src.hasData()) {
            tgt.setBlobElement(VersionConvertor_14_40.convertBase64Binary(src.getDataElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Address convertAddress(Address src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Address tgt = new org.hl7.fhir.r4.model.Address();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasUse()) {
            tgt.setUseElement(VersionConvertor_14_40.convertAddressUse(src.getUseElement()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(VersionConvertor_14_40.convertAddressType(src.getTypeElement()));
        }
        if (src.hasText()) {
            tgt.setTextElement(VersionConvertor_14_40.convertString(src.getTextElement()));
        }
        for (org.hl7.fhir.dstu2016may.model.StringType t : src.getLine()) {
            tgt.addLine((String)t.getValue());
        }
        if (src.hasCity()) {
            tgt.setCityElement(VersionConvertor_14_40.convertString(src.getCityElement()));
        }
        if (src.hasDistrict()) {
            tgt.setDistrictElement(VersionConvertor_14_40.convertString(src.getDistrictElement()));
        }
        if (src.hasState()) {
            tgt.setStateElement(VersionConvertor_14_40.convertString(src.getStateElement()));
        }
        if (src.hasPostalCode()) {
            tgt.setPostalCodeElement(VersionConvertor_14_40.convertString(src.getPostalCodeElement()));
        }
        if (src.hasCountry()) {
            tgt.setCountryElement(VersionConvertor_14_40.convertString(src.getCountryElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_14_40.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static Address convertAddress(org.hl7.fhir.r4.model.Address src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Address tgt = new Address();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasUse()) {
            tgt.setUseElement(VersionConvertor_14_40.convertAddressUse(src.getUseElement()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(VersionConvertor_14_40.convertAddressType(src.getTypeElement()));
        }
        if (src.hasText()) {
            tgt.setTextElement(VersionConvertor_14_40.convertString(src.getTextElement()));
        }
        for (StringType t : src.getLine()) {
            tgt.addLine((String)t.getValue());
        }
        if (src.hasCity()) {
            tgt.setCityElement(VersionConvertor_14_40.convertString(src.getCityElement()));
        }
        if (src.hasDistrict()) {
            tgt.setDistrictElement(VersionConvertor_14_40.convertString(src.getDistrictElement()));
        }
        if (src.hasState()) {
            tgt.setStateElement(VersionConvertor_14_40.convertString(src.getStateElement()));
        }
        if (src.hasPostalCode()) {
            tgt.setPostalCodeElement(VersionConvertor_14_40.convertString(src.getPostalCodeElement()));
        }
        if (src.hasCountry()) {
            tgt.setCountryElement(VersionConvertor_14_40.convertString(src.getCountryElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_14_40.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static Enumeration<Address.AddressUse> convertAddressUse(org.hl7.fhir.dstu2016may.model.Enumeration<Address.AddressUse> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Address.AddressUse> tgt = new Enumeration<Address.AddressUse>(new Address.AddressUseEnumFactory());
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        switch ((Address.AddressUse)((Object)src.getValue())) {
            case HOME: {
                tgt.setValue((Object)Address.AddressUse.HOME);
                break;
            }
            case WORK: {
                tgt.setValue((Object)Address.AddressUse.WORK);
                break;
            }
            case TEMP: {
                tgt.setValue((Object)Address.AddressUse.TEMP);
                break;
            }
            case OLD: {
                tgt.setValue((Object)Address.AddressUse.OLD);
                break;
            }
            default: {
                tgt.setValue((Object)Address.AddressUse.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Enumeration<Address.AddressUse> convertAddressUse(Enumeration<Address.AddressUse> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Enumeration<Address.AddressUse> tgt = new org.hl7.fhir.dstu2016may.model.Enumeration<Address.AddressUse>(new Address.AddressUseEnumFactory());
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        switch ((Address.AddressUse)((Object)src.getValue())) {
            case HOME: {
                tgt.setValue((Object)Address.AddressUse.HOME);
                break;
            }
            case WORK: {
                tgt.setValue((Object)Address.AddressUse.WORK);
                break;
            }
            case TEMP: {
                tgt.setValue((Object)Address.AddressUse.TEMP);
                break;
            }
            case OLD: {
                tgt.setValue((Object)Address.AddressUse.OLD);
                break;
            }
            default: {
                tgt.setValue((Object)Address.AddressUse.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Address.AddressType> convertAddressType(org.hl7.fhir.dstu2016may.model.Enumeration<Address.AddressType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Address.AddressType> tgt = new Enumeration<Address.AddressType>(new Address.AddressTypeEnumFactory());
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        switch ((Address.AddressType)((Object)src.getValue())) {
            case POSTAL: {
                tgt.setValue((Object)Address.AddressType.POSTAL);
                break;
            }
            case PHYSICAL: {
                tgt.setValue((Object)Address.AddressType.PHYSICAL);
                break;
            }
            case BOTH: {
                tgt.setValue((Object)Address.AddressType.BOTH);
                break;
            }
            default: {
                tgt.setValue((Object)Address.AddressType.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Enumeration<Address.AddressType> convertAddressType(Enumeration<Address.AddressType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Enumeration<Address.AddressType> tgt = new org.hl7.fhir.dstu2016may.model.Enumeration<Address.AddressType>(new Address.AddressTypeEnumFactory());
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        switch ((Address.AddressType)((Object)src.getValue())) {
            case POSTAL: {
                tgt.setValue((Object)Address.AddressType.POSTAL);
                break;
            }
            case PHYSICAL: {
                tgt.setValue((Object)Address.AddressType.PHYSICAL);
                break;
            }
            case BOTH: {
                tgt.setValue((Object)Address.AddressType.BOTH);
                break;
            }
            default: {
                tgt.setValue((Object)Address.AddressType.NULL);
            }
        }
        return tgt;
    }

    public static ContactPoint convertContactPoint(org.hl7.fhir.dstu2016may.model.ContactPoint src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ContactPoint tgt = new ContactPoint();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_14_40.convertContactPointSystem(src.getSystemElement()));
        }
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_14_40.convertString(src.getValueElement()));
        }
        if (src.hasUse()) {
            tgt.setUseElement(VersionConvertor_14_40.convertContactPointUse(src.getUseElement()));
        }
        if (src.hasRank()) {
            tgt.setRankElement(VersionConvertor_14_40.convertPositiveInt(src.getRankElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_14_40.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.ContactPoint convertContactPoint(ContactPoint src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.ContactPoint tgt = new org.hl7.fhir.dstu2016may.model.ContactPoint();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_14_40.convertContactPointSystem(src.getSystemElement()));
        }
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_14_40.convertString(src.getValueElement()));
        }
        if (src.hasUse()) {
            tgt.setUseElement(VersionConvertor_14_40.convertContactPointUse(src.getUseElement()));
        }
        if (src.hasRank()) {
            tgt.setRankElement(VersionConvertor_14_40.convertPositiveInt(src.getRankElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_14_40.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static Enumeration<ContactPoint.ContactPointSystem> convertContactPointSystem(org.hl7.fhir.dstu2016may.model.Enumeration<ContactPoint.ContactPointSystem> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ContactPoint.ContactPointSystem> tgt = new Enumeration<ContactPoint.ContactPointSystem>(new ContactPoint.ContactPointSystemEnumFactory());
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        switch ((ContactPoint.ContactPointSystem)((Object)src.getValue())) {
            case PHONE: {
                tgt.setValue((Object)ContactPoint.ContactPointSystem.PHONE);
                break;
            }
            case FAX: {
                tgt.setValue((Object)ContactPoint.ContactPointSystem.FAX);
                break;
            }
            case EMAIL: {
                tgt.setValue((Object)ContactPoint.ContactPointSystem.EMAIL);
                break;
            }
            case PAGER: {
                tgt.setValue((Object)ContactPoint.ContactPointSystem.PAGER);
                break;
            }
            case OTHER: {
                tgt.setValue((Object)ContactPoint.ContactPointSystem.URL);
                break;
            }
            default: {
                tgt.setValue((Object)ContactPoint.ContactPointSystem.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Enumeration<ContactPoint.ContactPointSystem> convertContactPointSystem(Enumeration<ContactPoint.ContactPointSystem> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Enumeration<ContactPoint.ContactPointSystem> tgt = new org.hl7.fhir.dstu2016may.model.Enumeration<ContactPoint.ContactPointSystem>(new ContactPoint.ContactPointSystemEnumFactory());
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        switch ((ContactPoint.ContactPointSystem)((Object)src.getValue())) {
            case PHONE: {
                tgt.setValue((Object)ContactPoint.ContactPointSystem.PHONE);
                break;
            }
            case FAX: {
                tgt.setValue((Object)ContactPoint.ContactPointSystem.FAX);
                break;
            }
            case EMAIL: {
                tgt.setValue((Object)ContactPoint.ContactPointSystem.EMAIL);
                break;
            }
            case PAGER: {
                tgt.setValue((Object)ContactPoint.ContactPointSystem.PAGER);
                break;
            }
            case URL: {
                tgt.setValue((Object)ContactPoint.ContactPointSystem.OTHER);
                break;
            }
            default: {
                tgt.setValue((Object)ContactPoint.ContactPointSystem.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<ContactPoint.ContactPointUse> convertContactPointUse(org.hl7.fhir.dstu2016may.model.Enumeration<ContactPoint.ContactPointUse> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ContactPoint.ContactPointUse> tgt = new Enumeration<ContactPoint.ContactPointUse>(new ContactPoint.ContactPointUseEnumFactory());
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        switch ((ContactPoint.ContactPointUse)((Object)src.getValue())) {
            case HOME: {
                tgt.setValue((Object)ContactPoint.ContactPointUse.HOME);
                break;
            }
            case WORK: {
                tgt.setValue((Object)ContactPoint.ContactPointUse.WORK);
                break;
            }
            case TEMP: {
                tgt.setValue((Object)ContactPoint.ContactPointUse.TEMP);
                break;
            }
            case OLD: {
                tgt.setValue((Object)ContactPoint.ContactPointUse.OLD);
                break;
            }
            case MOBILE: {
                tgt.setValue((Object)ContactPoint.ContactPointUse.MOBILE);
                break;
            }
            default: {
                tgt.setValue((Object)ContactPoint.ContactPointUse.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Enumeration<ContactPoint.ContactPointUse> convertContactPointUse(Enumeration<ContactPoint.ContactPointUse> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Enumeration<ContactPoint.ContactPointUse> tgt = new org.hl7.fhir.dstu2016may.model.Enumeration<ContactPoint.ContactPointUse>(new ContactPoint.ContactPointUseEnumFactory());
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        switch ((ContactPoint.ContactPointUse)((Object)src.getValue())) {
            case HOME: {
                tgt.setValue((Object)ContactPoint.ContactPointUse.HOME);
                break;
            }
            case WORK: {
                tgt.setValue((Object)ContactPoint.ContactPointUse.WORK);
                break;
            }
            case TEMP: {
                tgt.setValue((Object)ContactPoint.ContactPointUse.TEMP);
                break;
            }
            case OLD: {
                tgt.setValue((Object)ContactPoint.ContactPointUse.OLD);
                break;
            }
            case MOBILE: {
                tgt.setValue((Object)ContactPoint.ContactPointUse.MOBILE);
                break;
            }
            default: {
                tgt.setValue((Object)ContactPoint.ContactPointUse.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.ElementDefinition convertElementDefinition(ElementDefinition src, List<ElementDefinition> context, int pos) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.ElementDefinition tgt = new org.hl7.fhir.r4.model.ElementDefinition();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasPathElement()) {
            tgt.setPathElement(VersionConvertor_14_40.convertString(src.getPathElement()));
        }
        tgt.setRepresentation(src.getRepresentation().stream().map(VersionConvertor_14_40::convertPropertyRepresentation).collect(Collectors.toList()));
        if (src.hasName()) {
            tgt.setSliceNameElement(VersionConvertor_14_40.convertString(src.getNameElement()));
        }
        if (src.hasLabel()) {
            tgt.setLabelElement(VersionConvertor_14_40.convertString(src.getLabelElement()));
        }
        for (org.hl7.fhir.dstu2016may.model.Coding coding : src.getCode()) {
            tgt.addCode(VersionConvertor_14_40.convertCoding(coding));
        }
        if (src.hasSlicing()) {
            tgt.setSlicing(VersionConvertor_14_40.convertElementDefinitionSlicingComponent(src.getSlicing(), context, pos));
        }
        if (src.hasShort()) {
            tgt.setShortElement(VersionConvertor_14_40.convertString(src.getShortElement()));
        }
        if (src.hasDefinition()) {
            tgt.setDefinitionElement(VersionConvertor_14_40.convertMarkdown(src.getDefinitionElement()));
        }
        if (src.hasComments()) {
            tgt.setCommentElement(VersionConvertor_14_40.convertMarkdown(src.getCommentsElement()));
        }
        if (src.hasRequirements()) {
            tgt.setRequirementsElement(VersionConvertor_14_40.convertMarkdown(src.getRequirementsElement()));
        }
        for (org.hl7.fhir.dstu2016may.model.StringType stringType : src.getAlias()) {
            tgt.addAlias((String)stringType.getValue());
        }
        if (src.hasMin()) {
            tgt.setMin(src.getMin());
        }
        if (src.hasMax()) {
            tgt.setMaxElement(VersionConvertor_14_40.convertString(src.getMaxElement()));
        }
        if (src.hasBase()) {
            tgt.setBase(VersionConvertor_14_40.convertElementDefinitionBaseComponent(src.getBase()));
        }
        if (src.hasContentReference()) {
            tgt.setContentReferenceElement(VersionConvertor_14_40.convertUri(src.getContentReferenceElement()));
        }
        for (ElementDefinition.TypeRefComponent typeRefComponent : src.getType()) {
            VersionConvertor_14_40.convertTypeRefComponent(typeRefComponent, tgt.getType());
        }
        if (src.hasDefaultValue()) {
            tgt.setDefaultValue(VersionConvertor_14_40.convertType(src.getDefaultValue()));
        }
        if (src.hasMeaningWhenMissing()) {
            tgt.setMeaningWhenMissingElement(VersionConvertor_14_40.convertMarkdown(src.getMeaningWhenMissingElement()));
        }
        if (src.hasFixed()) {
            tgt.setFixed(VersionConvertor_14_40.convertType(src.getFixed()));
        }
        if (src.hasPattern()) {
            tgt.setPattern(VersionConvertor_14_40.convertType(src.getPattern()));
        }
        if (src.hasExample()) {
            tgt.addExample().setLabel("General").setValue(VersionConvertor_14_40.convertType(src.getExample()));
        }
        if (src.hasMinValue()) {
            tgt.setMinValue(VersionConvertor_14_40.convertType(src.getMinValue()));
        }
        if (src.hasMaxValue()) {
            tgt.setMaxValue(VersionConvertor_14_40.convertType(src.getMaxValue()));
        }
        if (src.hasMaxLength()) {
            tgt.setMaxLengthElement(VersionConvertor_14_40.convertInteger(src.getMaxLengthElement()));
        }
        for (IdType idType : src.getCondition()) {
            tgt.addCondition(idType.getValue());
        }
        for (ElementDefinition.ElementDefinitionConstraintComponent elementDefinitionConstraintComponent : src.getConstraint()) {
            tgt.addConstraint(VersionConvertor_14_40.convertElementDefinitionConstraintComponent(elementDefinitionConstraintComponent));
        }
        if (src.hasMustSupport()) {
            tgt.setMustSupportElement(VersionConvertor_14_40.convertBoolean(src.getMustSupportElement()));
        }
        if (src.hasIsModifier()) {
            tgt.setIsModifierElement(VersionConvertor_14_40.convertBoolean(src.getIsModifierElement()));
        }
        if (tgt.getIsModifier()) {
            String reason = ToolingExtensions.readStringExtension(src, "http://hl7.org/fhir/4.0/StructureDefinition/extension-ElementDefinition.isModifierReason");
            if (Utilities.noString(reason)) {
                reason = "No Modifier Reason provideed in previous versions of FHIR";
            }
            tgt.setIsModifierReason(reason);
        }
        if (src.hasIsSummary()) {
            tgt.setIsSummaryElement(VersionConvertor_14_40.convertBoolean(src.getIsSummaryElement()));
        }
        if (src.hasBinding()) {
            tgt.setBinding(VersionConvertor_14_40.convertElementDefinitionBindingComponent(src.getBinding()));
        }
        for (ElementDefinition.ElementDefinitionMappingComponent elementDefinitionMappingComponent : src.getMapping()) {
            tgt.addMapping(VersionConvertor_14_40.convertElementDefinitionMappingComponent(elementDefinitionMappingComponent));
        }
        return tgt;
    }

    public static ElementDefinition convertElementDefinition(org.hl7.fhir.r4.model.ElementDefinition src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ElementDefinition tgt = new ElementDefinition();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasPathElement()) {
            tgt.setPathElement(VersionConvertor_14_40.convertString(src.getPathElement()));
        }
        tgt.setRepresentation(src.getRepresentation().stream().map(VersionConvertor_14_40::convertPropertyRepresentation).collect(Collectors.toList()));
        if (src.hasSliceName()) {
            tgt.setNameElement(VersionConvertor_14_40.convertString(src.getSliceNameElement()));
        }
        if (src.hasLabel()) {
            tgt.setLabelElement(VersionConvertor_14_40.convertString(src.getLabelElement()));
        }
        for (Coding coding : src.getCode()) {
            tgt.addCode(VersionConvertor_14_40.convertCoding(coding));
        }
        if (src.hasSlicing()) {
            tgt.setSlicing(VersionConvertor_14_40.convertElementDefinitionSlicingComponent(src.getSlicing()));
        }
        if (src.hasShort()) {
            tgt.setShortElement(VersionConvertor_14_40.convertString(src.getShortElement()));
        }
        if (src.hasDefinition()) {
            tgt.setDefinitionElement(VersionConvertor_14_40.convertMarkdown(src.getDefinitionElement()));
        }
        if (src.hasComment()) {
            tgt.setCommentsElement(VersionConvertor_14_40.convertMarkdown(src.getCommentElement()));
        }
        if (src.hasRequirements()) {
            tgt.setRequirementsElement(VersionConvertor_14_40.convertMarkdown(src.getRequirementsElement()));
        }
        for (StringType stringType : src.getAlias()) {
            tgt.addAlias((String)stringType.getValue());
        }
        if (src.hasMin()) {
            tgt.setMin(src.getMin());
        }
        if (src.hasMax()) {
            tgt.setMaxElement(VersionConvertor_14_40.convertString(src.getMaxElement()));
        }
        if (src.hasBase()) {
            tgt.setBase(VersionConvertor_14_40.convertElementDefinitionBaseComponent(src.getBase()));
        }
        if (src.hasContentReference()) {
            tgt.setContentReferenceElement(VersionConvertor_14_40.convertUri(src.getContentReferenceElement()));
        }
        for (ElementDefinition.TypeRefComponent typeRefComponent : src.getType()) {
            VersionConvertor_14_40.convertTypeRefComponent(typeRefComponent, tgt.getType());
        }
        if (src.hasDefaultValue()) {
            tgt.setDefaultValue(VersionConvertor_14_40.convertType(src.getDefaultValue()));
        }
        if (src.hasMeaningWhenMissing()) {
            tgt.setMeaningWhenMissingElement(VersionConvertor_14_40.convertMarkdown(src.getMeaningWhenMissingElement()));
        }
        if (src.hasFixed()) {
            tgt.setFixed(VersionConvertor_14_40.convertType(src.getFixed()));
        }
        if (src.hasPattern()) {
            tgt.setPattern(VersionConvertor_14_40.convertType(src.getPattern()));
        }
        if (src.hasExample()) {
            tgt.setExample(VersionConvertor_14_40.convertType(src.getExample().get(0).getValue()));
        }
        if (src.hasMinValue()) {
            tgt.setMinValue(VersionConvertor_14_40.convertType(src.getMinValue()));
        }
        if (src.hasMaxValue()) {
            tgt.setMaxValue(VersionConvertor_14_40.convertType(src.getMaxValue()));
        }
        if (src.hasMaxLength()) {
            tgt.setMaxLengthElement(VersionConvertor_14_40.convertInteger(src.getMaxLengthElement()));
        }
        for (org.hl7.fhir.r4.model.IdType idType : src.getCondition()) {
            tgt.addCondition(idType.getValue());
        }
        for (ElementDefinition.ElementDefinitionConstraintComponent elementDefinitionConstraintComponent : src.getConstraint()) {
            tgt.addConstraint(VersionConvertor_14_40.convertElementDefinitionConstraintComponent(elementDefinitionConstraintComponent));
        }
        if (src.hasMustSupport()) {
            tgt.setMustSupportElement(VersionConvertor_14_40.convertBoolean(src.getMustSupportElement()));
        }
        if (src.hasIsModifier()) {
            tgt.setIsModifierElement(VersionConvertor_14_40.convertBoolean(src.getIsModifierElement()));
        }
        if (src.hasIsModifierReason() && !"No Modifier Reason provideed in previous versions of FHIR".equals(src.getIsModifierReason())) {
            ToolingExtensions.setStringExtension(tgt, "http://hl7.org/fhir/4.0/StructureDefinition/extension-ElementDefinition.isModifierReason", src.getIsModifierReason());
        }
        if (src.hasIsSummary()) {
            tgt.setIsSummaryElement(VersionConvertor_14_40.convertBoolean(src.getIsSummaryElement()));
        }
        if (src.hasBinding()) {
            tgt.setBinding(VersionConvertor_14_40.convertElementDefinitionBindingComponent(src.getBinding()));
        }
        for (ElementDefinition.ElementDefinitionMappingComponent elementDefinitionMappingComponent : src.getMapping()) {
            tgt.addMapping(VersionConvertor_14_40.convertElementDefinitionMappingComponent(elementDefinitionMappingComponent));
        }
        return tgt;
    }

    public static Enumeration<ElementDefinition.PropertyRepresentation> convertPropertyRepresentation(org.hl7.fhir.dstu2016may.model.Enumeration<ElementDefinition.PropertyRepresentation> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ElementDefinition.PropertyRepresentation> tgt = new Enumeration<ElementDefinition.PropertyRepresentation>(new ElementDefinition.PropertyRepresentationEnumFactory());
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        switch ((ElementDefinition.PropertyRepresentation)((Object)src.getValue())) {
            case XMLATTR: {
                tgt.setValue((Object)ElementDefinition.PropertyRepresentation.XMLATTR);
                break;
            }
            case XMLTEXT: {
                tgt.setValue((Object)ElementDefinition.PropertyRepresentation.XMLTEXT);
                break;
            }
            case TYPEATTR: {
                tgt.setValue((Object)ElementDefinition.PropertyRepresentation.TYPEATTR);
                break;
            }
            case CDATEXT: {
                tgt.setValue((Object)ElementDefinition.PropertyRepresentation.CDATEXT);
                break;
            }
            default: {
                tgt.setValue((Object)ElementDefinition.PropertyRepresentation.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Enumeration<ElementDefinition.PropertyRepresentation> convertPropertyRepresentation(Enumeration<ElementDefinition.PropertyRepresentation> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Enumeration<ElementDefinition.PropertyRepresentation> tgt = new org.hl7.fhir.dstu2016may.model.Enumeration<ElementDefinition.PropertyRepresentation>(new ElementDefinition.PropertyRepresentationEnumFactory());
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        switch ((ElementDefinition.PropertyRepresentation)((Object)src.getValue())) {
            case XMLATTR: {
                tgt.setValue((Object)ElementDefinition.PropertyRepresentation.XMLATTR);
                break;
            }
            case XMLTEXT: {
                tgt.setValue((Object)ElementDefinition.PropertyRepresentation.XMLTEXT);
                break;
            }
            case TYPEATTR: {
                tgt.setValue((Object)ElementDefinition.PropertyRepresentation.TYPEATTR);
                break;
            }
            case CDATEXT: {
                tgt.setValue((Object)ElementDefinition.PropertyRepresentation.CDATEXT);
                break;
            }
            default: {
                tgt.setValue((Object)ElementDefinition.PropertyRepresentation.NULL);
            }
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionSlicingComponent convertElementDefinitionSlicingComponent(ElementDefinition.ElementDefinitionSlicingComponent src, List<ElementDefinition> context, int pos) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ElementDefinition.ElementDefinitionSlicingComponent tgt = new ElementDefinition.ElementDefinitionSlicingComponent();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        ElementDefinition slicingElement = context.get(pos);
        for (org.hl7.fhir.dstu2016may.model.StringType t : src.getDiscriminator()) {
            boolean isExists = false;
            if (!t.asStringValue().contains("@")) {
                int slices = 0;
                boolean existsSlicePresent = false;
                boolean notExistsSlicePresent = false;
                String existsPath = slicingElement.getPath() + "." + t.asStringValue();
                for (int i = pos + 1; i < context.size(); ++i) {
                    ElementDefinition e = context.get(i);
                    if (e.getPath().equals(slicingElement.getPath())) {
                        ++slices;
                        continue;
                    }
                    if (!e.getPath().startsWith(slicingElement.getPath() + ".")) break;
                    if (!e.getPath().equals(existsPath)) continue;
                    if (e.hasMin() && e.getMin() > 0 && !e.hasFixed()) {
                        existsSlicePresent = true;
                        continue;
                    }
                    if (!e.hasMax() || !e.getMax().equals("0")) continue;
                    notExistsSlicePresent = true;
                }
                isExists = slices == 2 && existsSlicePresent && notExistsSlicePresent || slices == 1 && existsSlicePresent != notExistsSlicePresent;
            }
            tgt.addDiscriminator(ProfileUtilities.interpretR2Discriminator((String)t.getValue(), isExists));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_14_40.convertString(src.getDescriptionElement()));
        }
        if (src.hasOrdered()) {
            tgt.setOrderedElement(VersionConvertor_14_40.convertBoolean(src.getOrderedElement()));
        }
        if (src.hasRules()) {
            tgt.setRulesElement(VersionConvertor_14_40.convertSlicingRules(src.getRulesElement()));
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionSlicingComponent convertElementDefinitionSlicingComponent(ElementDefinition.ElementDefinitionSlicingComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ElementDefinition.ElementDefinitionSlicingComponent tgt = new ElementDefinition.ElementDefinitionSlicingComponent();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        for (ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent t : src.getDiscriminator()) {
            tgt.addDiscriminator(ProfileUtilities.buildR2Discriminator(t));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_14_40.convertString(src.getDescriptionElement()));
        }
        if (src.hasOrdered()) {
            tgt.setOrderedElement(VersionConvertor_14_40.convertBoolean(src.getOrderedElement()));
        }
        if (src.hasRules()) {
            tgt.setRulesElement(VersionConvertor_14_40.convertSlicingRules(src.getRulesElement()));
        }
        return tgt;
    }

    public static Enumeration<ElementDefinition.SlicingRules> convertSlicingRules(org.hl7.fhir.dstu2016may.model.Enumeration<ElementDefinition.SlicingRules> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ElementDefinition.SlicingRules> tgt = new Enumeration<ElementDefinition.SlicingRules>(new ElementDefinition.SlicingRulesEnumFactory());
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        switch ((ElementDefinition.SlicingRules)((Object)src.getValue())) {
            case CLOSED: {
                tgt.setValue((Object)ElementDefinition.SlicingRules.CLOSED);
                break;
            }
            case OPEN: {
                tgt.setValue((Object)ElementDefinition.SlicingRules.OPEN);
                break;
            }
            case OPENATEND: {
                tgt.setValue((Object)ElementDefinition.SlicingRules.OPENATEND);
                break;
            }
            default: {
                tgt.setValue((Object)ElementDefinition.SlicingRules.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Enumeration<ElementDefinition.SlicingRules> convertSlicingRules(Enumeration<ElementDefinition.SlicingRules> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Enumeration<ElementDefinition.SlicingRules> tgt = new org.hl7.fhir.dstu2016may.model.Enumeration<ElementDefinition.SlicingRules>(new ElementDefinition.SlicingRulesEnumFactory());
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        switch ((ElementDefinition.SlicingRules)((Object)src.getValue())) {
            case CLOSED: {
                tgt.setValue((Object)ElementDefinition.SlicingRules.CLOSED);
                break;
            }
            case OPEN: {
                tgt.setValue((Object)ElementDefinition.SlicingRules.OPEN);
                break;
            }
            case OPENATEND: {
                tgt.setValue((Object)ElementDefinition.SlicingRules.OPENATEND);
                break;
            }
            default: {
                tgt.setValue((Object)ElementDefinition.SlicingRules.NULL);
            }
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionBaseComponent convertElementDefinitionBaseComponent(ElementDefinition.ElementDefinitionBaseComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ElementDefinition.ElementDefinitionBaseComponent tgt = new ElementDefinition.ElementDefinitionBaseComponent();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasPathElement()) {
            tgt.setPathElement(VersionConvertor_14_40.convertString(src.getPathElement()));
        }
        tgt.setMin(src.getMin());
        if (src.hasMaxElement()) {
            tgt.setMaxElement(VersionConvertor_14_40.convertString(src.getMaxElement()));
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionBaseComponent convertElementDefinitionBaseComponent(ElementDefinition.ElementDefinitionBaseComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ElementDefinition.ElementDefinitionBaseComponent tgt = new ElementDefinition.ElementDefinitionBaseComponent();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasPathElement()) {
            tgt.setPathElement(VersionConvertor_14_40.convertString(src.getPathElement()));
        }
        tgt.setMin(src.getMin());
        if (src.hasMaxElement()) {
            tgt.setMaxElement(VersionConvertor_14_40.convertString(src.getMaxElement()));
        }
        return tgt;
    }

    public static void convertTypeRefComponent(ElementDefinition.TypeRefComponent src, List<ElementDefinition.TypeRefComponent> list) throws FHIRException {
        if (src == null) {
            return;
        }
        ElementDefinition.TypeRefComponent tgt = null;
        for (ElementDefinition.TypeRefComponent typeRefComponent : list) {
            if (!typeRefComponent.getCode().equals(src.getCode())) continue;
            tgt = typeRefComponent;
        }
        if (tgt == null) {
            tgt = new ElementDefinition.TypeRefComponent();
            list.add(tgt);
            VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
            tgt.setCode(src.getCode());
        }
        if (tgt.hasTarget()) {
            for (org.hl7.fhir.dstu2016may.model.UriType uriType : src.getProfile()) {
                if (src.getCode().equals("Reference")) {
                    tgt.addTargetProfile((String)uriType.getValue());
                    continue;
                }
                tgt.addProfile((String)uriType.getValue());
            }
            for (org.hl7.fhir.dstu2016may.model.Extension extension : src.getExtensionsByUrl("http://hl7.org/fhir/4.0/StructureDefinition/extension-ElementDefinition.type.profile")) {
                String s2 = (String)((PrimitiveType)extension.getValue()).getValue();
                tgt.addProfile(s2);
            }
        } else {
            for (org.hl7.fhir.dstu2016may.model.UriType uriType : src.getProfile()) {
                tgt.addProfile((String)uriType.getValue());
            }
        }
        for (org.hl7.fhir.dstu2016may.model.Enumeration enumeration : src.getAggregation()) {
            Enumeration<ElementDefinition.AggregationMode> a = VersionConvertor_14_40.convertAggregationMode(enumeration);
            if (tgt.hasAggregation((ElementDefinition.AggregationMode)((Object)a.getValue()))) continue;
            VersionConvertor_14_40.copyElement(enumeration, tgt.addAggregation((ElementDefinition.AggregationMode)((Object)a.getValue())), new String[0]);
        }
        if (src.hasVersioning()) {
            tgt.setVersioningElement(VersionConvertor_14_40.convertReferenceVersionRules(src.getVersioningElement()));
        }
    }

    public static void convertTypeRefComponent(ElementDefinition.TypeRefComponent src, List<ElementDefinition.TypeRefComponent> list) throws FHIRException {
        if (src == null) {
            return;
        }
        ElementDefinition.TypeRefComponent tgt = new ElementDefinition.TypeRefComponent();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        tgt.setCode(src.getCode());
        list.add(tgt);
        if (src.hasTarget()) {
            for (UriType uriType : src.getTargetProfile()) {
                tgt.addProfile((String)uriType.getValue());
                String baseName = ((String)uriType.getValue()).toLowerCase();
                if (!baseName.contains("reference") || baseName.contains("documentreference")) continue;
                throw new Error("2016May Target profile contains the word 'reference':" + uriType);
            }
            for (UriType uriType : src.getProfile()) {
                if (src.getCode().equals("Reference")) {
                    org.hl7.fhir.dstu2016may.model.Extension t = new org.hl7.fhir.dstu2016may.model.Extension("http://hl7.org/fhir/4.0/StructureDefinition/extension-ElementDefinition.type.profile");
                    t.setValue(VersionConvertor_14_40.convertType(uriType));
                    tgt.addExtension(t);
                    continue;
                }
                tgt.addProfile((String)uriType.getValue());
            }
        } else {
            for (UriType uriType : src.getProfile()) {
                tgt.addProfile((String)uriType.getValue());
            }
        }
        for (Enumeration enumeration : src.getAggregation()) {
            org.hl7.fhir.dstu2016may.model.Enumeration<ElementDefinition.AggregationMode> a = VersionConvertor_14_40.convertAggregationMode(enumeration);
            if (tgt.hasAggregation((ElementDefinition.AggregationMode)((Object)a.getValue()))) continue;
            VersionConvertor_14_40.copyElement(enumeration, tgt.addAggregation((ElementDefinition.AggregationMode)((Object)a.getValue())), new String[0]);
        }
        if (src.hasVersioning()) {
            tgt.setVersioningElement(VersionConvertor_14_40.convertReferenceVersionRules(src.getVersioningElement()));
        }
    }

    public static Enumeration<ElementDefinition.AggregationMode> convertAggregationMode(org.hl7.fhir.dstu2016may.model.Enumeration<ElementDefinition.AggregationMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ElementDefinition.AggregationMode> tgt = new Enumeration<ElementDefinition.AggregationMode>(new ElementDefinition.AggregationModeEnumFactory());
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        switch ((ElementDefinition.AggregationMode)((Object)src.getValue())) {
            case CONTAINED: {
                tgt.setValue((Object)ElementDefinition.AggregationMode.CONTAINED);
                break;
            }
            case REFERENCED: {
                tgt.setValue((Object)ElementDefinition.AggregationMode.REFERENCED);
                break;
            }
            case BUNDLED: {
                tgt.setValue((Object)ElementDefinition.AggregationMode.BUNDLED);
                break;
            }
            default: {
                tgt.setValue((Object)ElementDefinition.AggregationMode.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Enumeration<ElementDefinition.AggregationMode> convertAggregationMode(Enumeration<ElementDefinition.AggregationMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Enumeration<ElementDefinition.AggregationMode> tgt = new org.hl7.fhir.dstu2016may.model.Enumeration<ElementDefinition.AggregationMode>(new ElementDefinition.AggregationModeEnumFactory());
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        switch ((ElementDefinition.AggregationMode)((Object)src.getValue())) {
            case CONTAINED: {
                tgt.setValue((Object)ElementDefinition.AggregationMode.CONTAINED);
                break;
            }
            case REFERENCED: {
                tgt.setValue((Object)ElementDefinition.AggregationMode.REFERENCED);
                break;
            }
            case BUNDLED: {
                tgt.setValue((Object)ElementDefinition.AggregationMode.BUNDLED);
                break;
            }
            default: {
                tgt.setValue((Object)ElementDefinition.AggregationMode.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<ElementDefinition.ReferenceVersionRules> convertReferenceVersionRules(org.hl7.fhir.dstu2016may.model.Enumeration<ElementDefinition.ReferenceVersionRules> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ElementDefinition.ReferenceVersionRules> tgt = new Enumeration<ElementDefinition.ReferenceVersionRules>(new ElementDefinition.ReferenceVersionRulesEnumFactory());
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        switch ((ElementDefinition.ReferenceVersionRules)((Object)src.getValue())) {
            case EITHER: {
                tgt.setValue((Object)ElementDefinition.ReferenceVersionRules.EITHER);
                break;
            }
            case INDEPENDENT: {
                tgt.setValue((Object)ElementDefinition.ReferenceVersionRules.INDEPENDENT);
                break;
            }
            case SPECIFIC: {
                tgt.setValue((Object)ElementDefinition.ReferenceVersionRules.SPECIFIC);
                break;
            }
            default: {
                tgt.setValue((Object)ElementDefinition.ReferenceVersionRules.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Enumeration<ElementDefinition.ReferenceVersionRules> convertReferenceVersionRules(Enumeration<ElementDefinition.ReferenceVersionRules> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Enumeration<ElementDefinition.ReferenceVersionRules> tgt = new org.hl7.fhir.dstu2016may.model.Enumeration<ElementDefinition.ReferenceVersionRules>(new ElementDefinition.ReferenceVersionRulesEnumFactory());
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        switch ((ElementDefinition.ReferenceVersionRules)((Object)src.getValue())) {
            case EITHER: {
                tgt.setValue((Object)ElementDefinition.ReferenceVersionRules.EITHER);
                break;
            }
            case INDEPENDENT: {
                tgt.setValue((Object)ElementDefinition.ReferenceVersionRules.INDEPENDENT);
                break;
            }
            case SPECIFIC: {
                tgt.setValue((Object)ElementDefinition.ReferenceVersionRules.SPECIFIC);
                break;
            }
            default: {
                tgt.setValue((Object)ElementDefinition.ReferenceVersionRules.NULL);
            }
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionConstraintComponent convertElementDefinitionConstraintComponent(ElementDefinition.ElementDefinitionConstraintComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ElementDefinition.ElementDefinitionConstraintComponent tgt = new ElementDefinition.ElementDefinitionConstraintComponent();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasKeyElement()) {
            tgt.setKeyElement(VersionConvertor_14_40.convertId(src.getKeyElement()));
        }
        if (src.hasRequirements()) {
            tgt.setRequirementsElement(VersionConvertor_14_40.convertString(src.getRequirementsElement()));
        }
        if (src.hasSeverity()) {
            tgt.setSeverityElement(VersionConvertor_14_40.convertConstraintSeverity(src.getSeverityElement()));
        }
        if (src.hasHumanElement()) {
            tgt.setHumanElement(VersionConvertor_14_40.convertString(src.getHumanElement()));
        }
        if (src.hasExpression()) {
            tgt.setExpression(VersionConvertor_14_40.convertToR4Expression(src.getExpression()));
        }
        if (src.hasXpathElement()) {
            tgt.setXpathElement(VersionConvertor_14_40.convertString(src.getXpathElement()));
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionConstraintComponent convertElementDefinitionConstraintComponent(ElementDefinition.ElementDefinitionConstraintComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ElementDefinition.ElementDefinitionConstraintComponent tgt = new ElementDefinition.ElementDefinitionConstraintComponent();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasKeyElement()) {
            tgt.setKeyElement(VersionConvertor_14_40.convertId(src.getKeyElement()));
        }
        if (src.hasRequirements()) {
            tgt.setRequirementsElement(VersionConvertor_14_40.convertString(src.getRequirementsElement()));
        }
        if (src.hasSeverity()) {
            tgt.setSeverityElement(VersionConvertor_14_40.convertConstraintSeverity(src.getSeverityElement()));
        }
        if (src.hasHumanElement()) {
            tgt.setHumanElement(VersionConvertor_14_40.convertString(src.getHumanElement()));
        }
        if (src.hasExpression()) {
            tgt.setExpression(VersionConvertor_14_40.convertTo2016MayExpression(src.getExpression()));
        }
        if (src.hasXpathElement()) {
            tgt.setXpathElement(VersionConvertor_14_40.convertString(src.getXpathElement()));
        }
        return tgt;
    }

    public static String convertToR4Expression(String oldExpression) {
        String pass1;
        String pass2 = pass1 = oldExpression.replaceAll("\\$context", "%context").replaceAll("\\$resource", "%resource").replaceAll("code\\+profile", "code&profile").replaceAll("path\\+'\\.'", "path&'.'").replaceAll("fullUrl\\+resource", "fullUrl&resource");
        if (pass1.endsWith(".distinct()")) {
            pass2 = pass1.substring(0, pass2.length() - 11) + ".isDistinct()";
        }
        String pass3 = pass2;
        if (pass2.endsWith(".empty() or (type.count() = 1)")) {
            pass3 = pass2.substring(0, pass2.length() - 30) + ".empty() or (type.count() <= 1)";
        }
        String pass4 = pass3;
        if (pass3.equals("duration >= 0")) {
            pass4 = "duration.exists() implies duration >= 0";
        } else if (pass3.equals("period >= 0")) {
            pass4 = "period.exists() implies period >= 0";
        } else if (pass3.equals("fullUrl.empty() xor resource")) {
            pass4 = "fullUrl.empty() xor resource.exists()";
        }
        return pass4;
    }

    public static String convertTo2016MayExpression(String newExpression) {
        String pass1;
        String pass2 = pass1 = newExpression.replaceAll("%context", "\\$context").replaceAll("%resource", "\\$resource").replaceAll("code&profile", "code+profile").replaceAll("path&'\\.'", "path+'.'").replaceAll("fullUrl%resource", "fullUrl+resource");
        if (pass1.endsWith(".isDistinct()")) {
            pass2 = pass1.substring(0, pass1.length() - 13) + ".distinct()";
        }
        String pass3 = pass2;
        if (pass2.endsWith(".empty() or (type.count() <= 1)")) {
            pass3 = pass2.substring(0, pass2.length() - 31) + ".empty() or (type.count() = 1)";
        }
        String pass4 = pass3;
        if (pass3.equals("duration.exists() implies duration >= 0")) {
            pass4 = "duration >= 0";
        } else if (pass3.equals("period.exists() implies period >= 0")) {
            pass4 = "period >= 0";
        } else if (pass3.equals("fullUrl.empty() xor resource.exists()")) {
            pass4 = "fullUrl.empty() xor resource";
        }
        return pass4;
    }

    public static Enumeration<ElementDefinition.ConstraintSeverity> convertConstraintSeverity(org.hl7.fhir.dstu2016may.model.Enumeration<ElementDefinition.ConstraintSeverity> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ElementDefinition.ConstraintSeverity> tgt = new Enumeration<ElementDefinition.ConstraintSeverity>(new ElementDefinition.ConstraintSeverityEnumFactory());
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        switch ((ElementDefinition.ConstraintSeverity)((Object)src.getValue())) {
            case ERROR: {
                tgt.setValue((Object)ElementDefinition.ConstraintSeverity.ERROR);
                break;
            }
            case WARNING: {
                tgt.setValue((Object)ElementDefinition.ConstraintSeverity.WARNING);
                break;
            }
            default: {
                tgt.setValue((Object)ElementDefinition.ConstraintSeverity.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Enumeration<ElementDefinition.ConstraintSeverity> convertConstraintSeverity(Enumeration<ElementDefinition.ConstraintSeverity> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Enumeration<ElementDefinition.ConstraintSeverity> tgt = new org.hl7.fhir.dstu2016may.model.Enumeration<ElementDefinition.ConstraintSeverity>(new ElementDefinition.ConstraintSeverityEnumFactory());
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        switch ((ElementDefinition.ConstraintSeverity)((Object)src.getValue())) {
            case ERROR: {
                tgt.setValue((Object)ElementDefinition.ConstraintSeverity.ERROR);
                break;
            }
            case WARNING: {
                tgt.setValue((Object)ElementDefinition.ConstraintSeverity.WARNING);
                break;
            }
            default: {
                tgt.setValue((Object)ElementDefinition.ConstraintSeverity.NULL);
            }
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionBindingComponent convertElementDefinitionBindingComponent(ElementDefinition.ElementDefinitionBindingComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ElementDefinition.ElementDefinitionBindingComponent tgt = new ElementDefinition.ElementDefinitionBindingComponent();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasStrength()) {
            tgt.setStrengthElement(VersionConvertor_14_40.convertBindingStrength(src.getStrengthElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_14_40.convertString(src.getDescriptionElement()));
        }
        if (src.hasValueSet()) {
            Type t = VersionConvertor_14_40.convertType(src.getValueSet());
            if (t instanceof Reference) {
                tgt.setValueSet(((Reference)t).getReference());
            } else {
                tgt.setValueSet(t.primitiveValue());
            }
            tgt.setValueSet(VersionConvertorConstants.refToVS(tgt.getValueSet()));
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionBindingComponent convertElementDefinitionBindingComponent(ElementDefinition.ElementDefinitionBindingComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ElementDefinition.ElementDefinitionBindingComponent tgt = new ElementDefinition.ElementDefinitionBindingComponent();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasStrength()) {
            tgt.setStrengthElement(VersionConvertor_14_40.convertBindingStrength(src.getStrengthElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_14_40.convertString(src.getDescriptionElement()));
        }
        if (src.hasValueSet()) {
            String vsr = VersionConvertorConstants.vsToRef(src.getValueSet());
            if (vsr != null) {
                tgt.setValueSet(new org.hl7.fhir.dstu2016may.model.UriType(vsr));
            } else {
                tgt.setValueSet(new org.hl7.fhir.dstu2016may.model.Reference(src.getValueSet()));
            }
        }
        return tgt;
    }

    public static Enumeration<Enumerations.BindingStrength> convertBindingStrength(org.hl7.fhir.dstu2016may.model.Enumeration<Enumerations.BindingStrength> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Enumerations.BindingStrength> tgt = new Enumeration<Enumerations.BindingStrength>(new Enumerations.BindingStrengthEnumFactory());
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.BindingStrength)((Object)src.getValue())) {
            case REQUIRED: {
                tgt.setValue((Object)Enumerations.BindingStrength.REQUIRED);
                break;
            }
            case EXTENSIBLE: {
                tgt.setValue((Object)Enumerations.BindingStrength.EXTENSIBLE);
                break;
            }
            case PREFERRED: {
                tgt.setValue((Object)Enumerations.BindingStrength.PREFERRED);
                break;
            }
            case EXAMPLE: {
                tgt.setValue((Object)Enumerations.BindingStrength.EXAMPLE);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.BindingStrength.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Enumeration<Enumerations.BindingStrength> convertBindingStrength(Enumeration<Enumerations.BindingStrength> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Enumeration<Enumerations.BindingStrength> tgt = new org.hl7.fhir.dstu2016may.model.Enumeration<Enumerations.BindingStrength>(new Enumerations.BindingStrengthEnumFactory());
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.BindingStrength)((Object)src.getValue())) {
            case REQUIRED: {
                tgt.setValue((Object)Enumerations.BindingStrength.REQUIRED);
                break;
            }
            case EXTENSIBLE: {
                tgt.setValue((Object)Enumerations.BindingStrength.EXTENSIBLE);
                break;
            }
            case PREFERRED: {
                tgt.setValue((Object)Enumerations.BindingStrength.PREFERRED);
                break;
            }
            case EXAMPLE: {
                tgt.setValue((Object)Enumerations.BindingStrength.EXAMPLE);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.BindingStrength.NULL);
            }
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionMappingComponent convertElementDefinitionMappingComponent(ElementDefinition.ElementDefinitionMappingComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ElementDefinition.ElementDefinitionMappingComponent tgt = new ElementDefinition.ElementDefinitionMappingComponent();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasIdentityElement()) {
            tgt.setIdentityElement(VersionConvertor_14_40.convertId(src.getIdentityElement()));
        }
        if (src.hasLanguage()) {
            tgt.setLanguageElement(VersionConvertor_14_40.convertCode(src.getLanguageElement()));
        }
        if (src.hasMapElement()) {
            tgt.setMapElement(VersionConvertor_14_40.convertString(src.getMapElement()));
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionMappingComponent convertElementDefinitionMappingComponent(ElementDefinition.ElementDefinitionMappingComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ElementDefinition.ElementDefinitionMappingComponent tgt = new ElementDefinition.ElementDefinitionMappingComponent();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasIdentityElement()) {
            tgt.setIdentityElement(VersionConvertor_14_40.convertId(src.getIdentityElement()));
        }
        if (src.hasLanguage()) {
            tgt.setLanguageElement(VersionConvertor_14_40.convertCode(src.getLanguageElement()));
        }
        if (src.hasMapElement()) {
            tgt.setMapElement(VersionConvertor_14_40.convertString(src.getMapElement()));
        }
        return tgt;
    }

    public static HumanName convertHumanName(org.hl7.fhir.dstu2016may.model.HumanName src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        HumanName tgt = new HumanName();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasUse()) {
            tgt.setUseElement(VersionConvertor_14_40.convertNameUse(src.getUseElement()));
        }
        if (src.hasText()) {
            tgt.setTextElement(VersionConvertor_14_40.convertString(src.getTextElement()));
        }
        for (org.hl7.fhir.dstu2016may.model.StringType t : src.getFamily()) {
            tgt.setFamily((String)t.getValue());
        }
        for (org.hl7.fhir.dstu2016may.model.StringType t : src.getGiven()) {
            tgt.addGiven((String)t.getValue());
        }
        for (org.hl7.fhir.dstu2016may.model.StringType t : src.getPrefix()) {
            tgt.addPrefix((String)t.getValue());
        }
        for (org.hl7.fhir.dstu2016may.model.StringType t : src.getSuffix()) {
            tgt.addSuffix((String)t.getValue());
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_14_40.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.HumanName convertHumanName(HumanName src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.HumanName tgt = new org.hl7.fhir.dstu2016may.model.HumanName();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasUse()) {
            tgt.setUseElement(VersionConvertor_14_40.convertNameUse(src.getUseElement()));
        }
        if (src.hasText()) {
            tgt.setTextElement(VersionConvertor_14_40.convertString(src.getTextElement()));
        }
        if (src.hasFamily()) {
            tgt.addFamily(src.getFamily());
        }
        for (StringType t : src.getGiven()) {
            tgt.addGiven((String)t.getValue());
        }
        for (StringType t : src.getPrefix()) {
            tgt.addPrefix((String)t.getValue());
        }
        for (StringType t : src.getSuffix()) {
            tgt.addSuffix((String)t.getValue());
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_14_40.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static Enumeration<HumanName.NameUse> convertNameUse(org.hl7.fhir.dstu2016may.model.Enumeration<HumanName.NameUse> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<HumanName.NameUse> tgt = new Enumeration<HumanName.NameUse>(new HumanName.NameUseEnumFactory());
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        switch ((HumanName.NameUse)((Object)src.getValue())) {
            case USUAL: {
                tgt.setValue((Object)HumanName.NameUse.USUAL);
                break;
            }
            case OFFICIAL: {
                tgt.setValue((Object)HumanName.NameUse.OFFICIAL);
                break;
            }
            case TEMP: {
                tgt.setValue((Object)HumanName.NameUse.TEMP);
                break;
            }
            case NICKNAME: {
                tgt.setValue((Object)HumanName.NameUse.NICKNAME);
                break;
            }
            case ANONYMOUS: {
                tgt.setValue((Object)HumanName.NameUse.ANONYMOUS);
                break;
            }
            case OLD: {
                tgt.setValue((Object)HumanName.NameUse.OLD);
                break;
            }
            case MAIDEN: {
                tgt.setValue((Object)HumanName.NameUse.MAIDEN);
                break;
            }
            default: {
                tgt.setValue((Object)HumanName.NameUse.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Enumeration<HumanName.NameUse> convertNameUse(Enumeration<HumanName.NameUse> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Enumeration<HumanName.NameUse> tgt = new org.hl7.fhir.dstu2016may.model.Enumeration<HumanName.NameUse>(new HumanName.NameUseEnumFactory());
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        switch ((HumanName.NameUse)((Object)src.getValue())) {
            case USUAL: {
                tgt.setValue((Object)HumanName.NameUse.USUAL);
                break;
            }
            case OFFICIAL: {
                tgt.setValue((Object)HumanName.NameUse.OFFICIAL);
                break;
            }
            case TEMP: {
                tgt.setValue((Object)HumanName.NameUse.TEMP);
                break;
            }
            case NICKNAME: {
                tgt.setValue((Object)HumanName.NameUse.NICKNAME);
                break;
            }
            case ANONYMOUS: {
                tgt.setValue((Object)HumanName.NameUse.ANONYMOUS);
                break;
            }
            case OLD: {
                tgt.setValue((Object)HumanName.NameUse.OLD);
                break;
            }
            case MAIDEN: {
                tgt.setValue((Object)HumanName.NameUse.MAIDEN);
                break;
            }
            default: {
                tgt.setValue((Object)HumanName.NameUse.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Meta convertMeta(Meta src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Meta tgt = new org.hl7.fhir.r4.model.Meta();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasVersionId()) {
            tgt.setVersionIdElement(VersionConvertor_14_40.convertId(src.getVersionIdElement()));
        }
        if (src.hasLastUpdated()) {
            tgt.setLastUpdatedElement(VersionConvertor_14_40.convertInstant(src.getLastUpdatedElement()));
        }
        for (org.hl7.fhir.dstu2016may.model.UriType uriType : src.getProfile()) {
            tgt.addProfile((String)uriType.getValue());
        }
        for (org.hl7.fhir.dstu2016may.model.Coding coding : src.getSecurity()) {
            tgt.addSecurity(VersionConvertor_14_40.convertCoding(coding));
        }
        for (org.hl7.fhir.dstu2016may.model.Coding coding : src.getTag()) {
            tgt.addTag(VersionConvertor_14_40.convertCoding(coding));
        }
        return tgt;
    }

    public static Meta convertMeta(org.hl7.fhir.r4.model.Meta src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Meta tgt = new Meta();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasVersionId()) {
            tgt.setVersionIdElement(VersionConvertor_14_40.convertId(src.getVersionIdElement()));
        }
        if (src.hasLastUpdated()) {
            tgt.setLastUpdatedElement(VersionConvertor_14_40.convertInstant(src.getLastUpdatedElement()));
        }
        for (UriType uriType : src.getProfile()) {
            tgt.addProfile((String)uriType.getValue());
        }
        for (Coding coding : src.getSecurity()) {
            tgt.addSecurity(VersionConvertor_14_40.convertCoding(coding));
        }
        for (Coding coding : src.getTag()) {
            tgt.addTag(VersionConvertor_14_40.convertCoding(coding));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Timing convertTiming(Timing src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Timing tgt = new org.hl7.fhir.r4.model.Timing();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        for (org.hl7.fhir.dstu2016may.model.DateTimeType t : src.getEvent()) {
            tgt.addEvent((Date)t.getValue());
        }
        if (src.hasRepeat()) {
            tgt.setRepeat(VersionConvertor_14_40.convertTimingRepeatComponent(src.getRepeat()));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_14_40.convertCodeableConcept(src.getCode()));
        }
        return tgt;
    }

    public static Timing convertTiming(org.hl7.fhir.r4.model.Timing src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Timing tgt = new Timing();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        for (DateTimeType t : src.getEvent()) {
            tgt.addEvent((Date)t.getValue());
        }
        if (src.hasRepeat()) {
            tgt.setRepeat(VersionConvertor_14_40.convertTimingRepeatComponent(src.getRepeat()));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_14_40.convertCodeableConcept(src.getCode()));
        }
        return tgt;
    }

    public static Timing.TimingRepeatComponent convertTimingRepeatComponent(Timing.TimingRepeatComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Timing.TimingRepeatComponent tgt = new Timing.TimingRepeatComponent();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasBounds()) {
            tgt.setBounds(VersionConvertor_14_40.convertType(src.getBounds()));
        }
        if (src.hasCount()) {
            tgt.setCount(src.getCount());
        }
        if (src.hasCountMax()) {
            tgt.setCountMax(src.getCountMax());
        }
        if (src.hasDuration()) {
            tgt.setDurationElement(VersionConvertor_14_40.convertDecimal(src.getDurationElement()));
        }
        if (src.hasDurationMax()) {
            tgt.setDurationMaxElement(VersionConvertor_14_40.convertDecimal(src.getDurationMaxElement()));
        }
        if (src.hasDurationUnit()) {
            tgt.setDurationUnitElement(VersionConvertor_14_40.convertUnitsOfTime(src.getDurationUnitElement()));
        }
        if (src.hasFrequency()) {
            tgt.setFrequency(src.getFrequency());
        }
        if (src.hasFrequencyMax()) {
            tgt.setFrequencyMax(src.getFrequencyMax());
        }
        if (src.hasPeriod()) {
            tgt.setPeriodElement(VersionConvertor_14_40.convertDecimal(src.getPeriodElement()));
        }
        if (src.hasPeriodMax()) {
            tgt.setPeriodMaxElement(VersionConvertor_14_40.convertDecimal(src.getPeriodMaxElement()));
        }
        if (src.hasPeriodUnit()) {
            tgt.setPeriodUnitElement(VersionConvertor_14_40.convertUnitsOfTime(src.getPeriodUnitElement()));
        }
        if (src.hasWhen()) {
            tgt.setWhen(Collections.singletonList(VersionConvertor_14_40.convertEventTiming(src.getWhenElement())));
        }
        if (src.hasOffset()) {
            tgt.setOffsetElement(VersionConvertor_14_40.convertUnsignedInt(src.getOffsetElement()));
        }
        return tgt;
    }

    public static Timing.TimingRepeatComponent convertTimingRepeatComponent(Timing.TimingRepeatComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Timing.TimingRepeatComponent tgt = new Timing.TimingRepeatComponent();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasBounds()) {
            tgt.setBounds(VersionConvertor_14_40.convertType(src.getBounds()));
        }
        if (src.hasCount()) {
            tgt.setCount(src.getCount());
        }
        if (src.hasCountMax()) {
            tgt.setCountMax(src.getCountMax());
        }
        if (src.hasDuration()) {
            tgt.setDurationElement(VersionConvertor_14_40.convertDecimal(src.getDurationElement()));
        }
        if (src.hasDurationMax()) {
            tgt.setDurationMaxElement(VersionConvertor_14_40.convertDecimal(src.getDurationMaxElement()));
        }
        if (src.hasDurationUnit()) {
            tgt.setDurationUnitElement(VersionConvertor_14_40.convertUnitsOfTime(src.getDurationUnitElement()));
        }
        if (src.hasFrequency()) {
            tgt.setFrequency(src.getFrequency());
        }
        if (src.hasFrequencyMax()) {
            tgt.setFrequencyMax(src.getFrequencyMax());
        }
        if (src.hasPeriod()) {
            tgt.setPeriodElement(VersionConvertor_14_40.convertDecimal(src.getPeriodElement()));
        }
        if (src.hasPeriodMax()) {
            tgt.setPeriodMaxElement(VersionConvertor_14_40.convertDecimal(src.getPeriodMaxElement()));
        }
        if (src.hasPeriodUnit()) {
            tgt.setPeriodUnitElement(VersionConvertor_14_40.convertUnitsOfTime(src.getPeriodUnitElement()));
        }
        if (src.hasWhen()) {
            tgt.setWhenElement(VersionConvertor_14_40.convertEventTiming(src.getWhen().get(0)));
        }
        if (src.hasOffset()) {
            tgt.setOffsetElement(VersionConvertor_14_40.convertUnsignedInt(src.getOffsetElement()));
        }
        return tgt;
    }

    public static Enumeration<Timing.UnitsOfTime> convertUnitsOfTime(org.hl7.fhir.dstu2016may.model.Enumeration<Timing.UnitsOfTime> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Timing.UnitsOfTime> tgt = new Enumeration<Timing.UnitsOfTime>(new Timing.UnitsOfTimeEnumFactory());
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        switch ((Timing.UnitsOfTime)((Object)src.getValue())) {
            case S: {
                tgt.setValue((Object)Timing.UnitsOfTime.S);
                break;
            }
            case MIN: {
                tgt.setValue((Object)Timing.UnitsOfTime.MIN);
                break;
            }
            case H: {
                tgt.setValue((Object)Timing.UnitsOfTime.H);
                break;
            }
            case D: {
                tgt.setValue((Object)Timing.UnitsOfTime.D);
                break;
            }
            case WK: {
                tgt.setValue((Object)Timing.UnitsOfTime.WK);
                break;
            }
            case MO: {
                tgt.setValue((Object)Timing.UnitsOfTime.MO);
                break;
            }
            case A: {
                tgt.setValue((Object)Timing.UnitsOfTime.A);
                break;
            }
            default: {
                tgt.setValue((Object)Timing.UnitsOfTime.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Enumeration<Timing.UnitsOfTime> convertUnitsOfTime(Enumeration<Timing.UnitsOfTime> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Enumeration<Timing.UnitsOfTime> tgt = new org.hl7.fhir.dstu2016may.model.Enumeration<Timing.UnitsOfTime>(new Timing.UnitsOfTimeEnumFactory());
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        switch ((Timing.UnitsOfTime)((Object)src.getValue())) {
            case S: {
                tgt.setValue((Object)Timing.UnitsOfTime.S);
                break;
            }
            case MIN: {
                tgt.setValue((Object)Timing.UnitsOfTime.MIN);
                break;
            }
            case H: {
                tgt.setValue((Object)Timing.UnitsOfTime.H);
                break;
            }
            case D: {
                tgt.setValue((Object)Timing.UnitsOfTime.D);
                break;
            }
            case WK: {
                tgt.setValue((Object)Timing.UnitsOfTime.WK);
                break;
            }
            case MO: {
                tgt.setValue((Object)Timing.UnitsOfTime.MO);
                break;
            }
            case A: {
                tgt.setValue((Object)Timing.UnitsOfTime.A);
                break;
            }
            default: {
                tgt.setValue((Object)Timing.UnitsOfTime.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Timing.EventTiming> convertEventTiming(org.hl7.fhir.dstu2016may.model.Enumeration<Timing.EventTiming> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Timing.EventTiming> tgt = new Enumeration<Timing.EventTiming>(new Timing.EventTimingEnumFactory());
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        switch ((Timing.EventTiming)((Object)src.getValue())) {
            case HS: {
                tgt.setValue((Object)Timing.EventTiming.HS);
                break;
            }
            case WAKE: {
                tgt.setValue((Object)Timing.EventTiming.WAKE);
                break;
            }
            case C: {
                tgt.setValue((Object)Timing.EventTiming.C);
                break;
            }
            case CM: {
                tgt.setValue((Object)Timing.EventTiming.CM);
                break;
            }
            case CD: {
                tgt.setValue((Object)Timing.EventTiming.CD);
                break;
            }
            case CV: {
                tgt.setValue((Object)Timing.EventTiming.CV);
                break;
            }
            case AC: {
                tgt.setValue((Object)Timing.EventTiming.AC);
                break;
            }
            case ACM: {
                tgt.setValue((Object)Timing.EventTiming.ACM);
                break;
            }
            case ACD: {
                tgt.setValue((Object)Timing.EventTiming.ACD);
                break;
            }
            case ACV: {
                tgt.setValue((Object)Timing.EventTiming.ACV);
                break;
            }
            case PC: {
                tgt.setValue((Object)Timing.EventTiming.PC);
                break;
            }
            case PCM: {
                tgt.setValue((Object)Timing.EventTiming.PCM);
                break;
            }
            case PCD: {
                tgt.setValue((Object)Timing.EventTiming.PCD);
                break;
            }
            case PCV: {
                tgt.setValue((Object)Timing.EventTiming.PCV);
                break;
            }
            default: {
                tgt.setValue((Object)Timing.EventTiming.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Enumeration<Timing.EventTiming> convertEventTiming(Enumeration<Timing.EventTiming> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Enumeration<Timing.EventTiming> tgt = new org.hl7.fhir.dstu2016may.model.Enumeration<Timing.EventTiming>(new Timing.EventTimingEnumFactory());
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        switch ((Timing.EventTiming)((Object)src.getValue())) {
            case HS: {
                tgt.setValue((Object)Timing.EventTiming.HS);
                break;
            }
            case WAKE: {
                tgt.setValue((Object)Timing.EventTiming.WAKE);
                break;
            }
            case C: {
                tgt.setValue((Object)Timing.EventTiming.C);
                break;
            }
            case CM: {
                tgt.setValue((Object)Timing.EventTiming.CM);
                break;
            }
            case CD: {
                tgt.setValue((Object)Timing.EventTiming.CD);
                break;
            }
            case CV: {
                tgt.setValue((Object)Timing.EventTiming.CV);
                break;
            }
            case AC: {
                tgt.setValue((Object)Timing.EventTiming.AC);
                break;
            }
            case ACM: {
                tgt.setValue((Object)Timing.EventTiming.ACM);
                break;
            }
            case ACD: {
                tgt.setValue((Object)Timing.EventTiming.ACD);
                break;
            }
            case ACV: {
                tgt.setValue((Object)Timing.EventTiming.ACV);
                break;
            }
            case PC: {
                tgt.setValue((Object)Timing.EventTiming.PC);
                break;
            }
            case PCM: {
                tgt.setValue((Object)Timing.EventTiming.PCM);
                break;
            }
            case PCD: {
                tgt.setValue((Object)Timing.EventTiming.PCD);
                break;
            }
            case PCV: {
                tgt.setValue((Object)Timing.EventTiming.PCV);
                break;
            }
            default: {
                tgt.setValue((Object)Timing.EventTiming.NULL);
            }
        }
        return tgt;
    }

    public static Quantity convertSimpleQuantity(SimpleQuantity src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.SimpleQuantity tgt = new org.hl7.fhir.r4.model.SimpleQuantity();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_14_40.convertDecimal(src.getValueElement()));
        }
        if (src.hasComparator()) {
            tgt.setComparatorElement(VersionConvertor_14_40.convertQuantityComparator(src.getComparatorElement()));
        }
        if (src.hasUnit()) {
            tgt.setUnitElement(VersionConvertor_14_40.convertString(src.getUnitElement()));
        }
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_14_40.convertUri(src.getSystemElement()));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_14_40.convertCode(src.getCodeElement()));
        }
        return tgt;
    }

    public static SimpleQuantity convertSimpleQuantity(Quantity src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        SimpleQuantity tgt = new SimpleQuantity();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_14_40.convertDecimal(src.getValueElement()));
        }
        if (src.hasComparator()) {
            tgt.setComparatorElement(VersionConvertor_14_40.convertQuantityComparator(src.getComparatorElement()));
        }
        if (src.hasUnit()) {
            tgt.setUnitElement(VersionConvertor_14_40.convertString(src.getUnitElement()));
        }
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_14_40.convertUri(src.getSystemElement()));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_14_40.convertCode(src.getCodeElement()));
        }
        return tgt;
    }

    public static Type convertType(org.hl7.fhir.dstu2016may.model.Type src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        if (src instanceof Base64BinaryType) {
            return VersionConvertor_14_40.convertBase64Binary((Base64BinaryType)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.BooleanType) {
            return VersionConvertor_14_40.convertBoolean((org.hl7.fhir.dstu2016may.model.BooleanType)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.CodeType) {
            return VersionConvertor_14_40.convertCode((org.hl7.fhir.dstu2016may.model.CodeType)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.DateType) {
            return VersionConvertor_14_40.convertDate((org.hl7.fhir.dstu2016may.model.DateType)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.DateTimeType) {
            return VersionConvertor_14_40.convertDateTime((org.hl7.fhir.dstu2016may.model.DateTimeType)src);
        }
        if (src instanceof DecimalType) {
            return VersionConvertor_14_40.convertDecimal((DecimalType)src);
        }
        if (src instanceof IdType) {
            return VersionConvertor_14_40.convertId((IdType)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.InstantType) {
            return VersionConvertor_14_40.convertInstant((org.hl7.fhir.dstu2016may.model.InstantType)src);
        }
        if (src instanceof IntegerType) {
            return VersionConvertor_14_40.convertInteger((IntegerType)src);
        }
        if (src instanceof MarkdownType) {
            return VersionConvertor_14_40.convertMarkdown((MarkdownType)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.OidType) {
            return VersionConvertor_14_40.convertOid((org.hl7.fhir.dstu2016may.model.OidType)src);
        }
        if (src instanceof PositiveIntType) {
            return VersionConvertor_14_40.convertPositiveInt((PositiveIntType)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.StringType) {
            return VersionConvertor_14_40.convertString((org.hl7.fhir.dstu2016may.model.StringType)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.TimeType) {
            return VersionConvertor_14_40.convertTime((org.hl7.fhir.dstu2016may.model.TimeType)src);
        }
        if (src instanceof UnsignedIntType) {
            return VersionConvertor_14_40.convertUnsignedInt((UnsignedIntType)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.UriType) {
            return VersionConvertor_14_40.convertUri((org.hl7.fhir.dstu2016may.model.UriType)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.UuidType) {
            return VersionConvertor_14_40.convertUuid((org.hl7.fhir.dstu2016may.model.UuidType)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.Extension) {
            return VersionConvertor_14_40.convertExtension((org.hl7.fhir.dstu2016may.model.Extension)src);
        }
        if (src instanceof Narrative) {
            return VersionConvertor_14_40.convertNarrative((Narrative)src);
        }
        if (src instanceof Age) {
            return VersionConvertor_14_40.convertAge((Age)src);
        }
        if (src instanceof Annotation) {
            return VersionConvertor_14_40.convertAnnotation((Annotation)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.Attachment) {
            return VersionConvertor_14_40.convertAttachment((org.hl7.fhir.dstu2016may.model.Attachment)src);
        }
        if (src instanceof CodeableConcept) {
            return VersionConvertor_14_40.convertCodeableConcept((CodeableConcept)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.Coding) {
            return VersionConvertor_14_40.convertCoding((org.hl7.fhir.dstu2016may.model.Coding)src);
        }
        if (src instanceof Count) {
            return VersionConvertor_14_40.convertCount((Count)src);
        }
        if (src instanceof Distance) {
            return VersionConvertor_14_40.convertDistance((Distance)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.Duration) {
            return VersionConvertor_14_40.convertDuration((org.hl7.fhir.dstu2016may.model.Duration)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.Identifier) {
            return VersionConvertor_14_40.convertIdentifier((org.hl7.fhir.dstu2016may.model.Identifier)src);
        }
        if (src instanceof Money) {
            return VersionConvertor_14_40.convertMoney((Money)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.Period) {
            return VersionConvertor_14_40.convertPeriod((org.hl7.fhir.dstu2016may.model.Period)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.Quantity) {
            return VersionConvertor_14_40.convertQuantity((org.hl7.fhir.dstu2016may.model.Quantity)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.Range) {
            return VersionConvertor_14_40.convertRange((org.hl7.fhir.dstu2016may.model.Range)src);
        }
        if (src instanceof Ratio) {
            return VersionConvertor_14_40.convertRatio((Ratio)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.Reference) {
            return VersionConvertor_14_40.convertReference((org.hl7.fhir.dstu2016may.model.Reference)src);
        }
        if (src instanceof SampledData) {
            return VersionConvertor_14_40.convertSampledData((SampledData)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.Signature) {
            return VersionConvertor_14_40.convertSignature((org.hl7.fhir.dstu2016may.model.Signature)src);
        }
        if (src instanceof Address) {
            return VersionConvertor_14_40.convertAddress((Address)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.ContactPoint) {
            return VersionConvertor_14_40.convertContactPoint((org.hl7.fhir.dstu2016may.model.ContactPoint)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.HumanName) {
            return VersionConvertor_14_40.convertHumanName((org.hl7.fhir.dstu2016may.model.HumanName)src);
        }
        if (src instanceof Meta) {
            return VersionConvertor_14_40.convertMeta((Meta)src);
        }
        if (src instanceof Timing) {
            return VersionConvertor_14_40.convertTiming((Timing)src);
        }
        throw new FHIRException("Unknown type " + src.fhirType());
    }

    public static org.hl7.fhir.dstu2016may.model.Type convertType(Type src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        if (src instanceof org.hl7.fhir.r4.model.Base64BinaryType) {
            return VersionConvertor_14_40.convertBase64Binary((org.hl7.fhir.r4.model.Base64BinaryType)src);
        }
        if (src instanceof BooleanType) {
            return VersionConvertor_14_40.convertBoolean((BooleanType)src);
        }
        if (src instanceof CodeType) {
            return VersionConvertor_14_40.convertCode((CodeType)src);
        }
        if (src instanceof DateType) {
            return VersionConvertor_14_40.convertDate((DateType)src);
        }
        if (src instanceof DateTimeType) {
            return VersionConvertor_14_40.convertDateTime((DateTimeType)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.DecimalType) {
            return VersionConvertor_14_40.convertDecimal((org.hl7.fhir.r4.model.DecimalType)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.IdType) {
            return VersionConvertor_14_40.convertId((org.hl7.fhir.r4.model.IdType)src);
        }
        if (src instanceof InstantType) {
            return VersionConvertor_14_40.convertInstant((InstantType)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.IntegerType) {
            return VersionConvertor_14_40.convertInteger((org.hl7.fhir.r4.model.IntegerType)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.MarkdownType) {
            return VersionConvertor_14_40.convertMarkdown((org.hl7.fhir.r4.model.MarkdownType)src);
        }
        if (src instanceof OidType) {
            return VersionConvertor_14_40.convertOid((OidType)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.PositiveIntType) {
            return VersionConvertor_14_40.convertPositiveInt((org.hl7.fhir.r4.model.PositiveIntType)src);
        }
        if (src instanceof StringType) {
            return VersionConvertor_14_40.convertString((StringType)src);
        }
        if (src instanceof TimeType) {
            return VersionConvertor_14_40.convertTime((TimeType)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.UnsignedIntType) {
            return VersionConvertor_14_40.convertUnsignedInt((org.hl7.fhir.r4.model.UnsignedIntType)src);
        }
        if (src instanceof UriType) {
            return VersionConvertor_14_40.convertUri((UriType)src);
        }
        if (src instanceof UuidType) {
            return VersionConvertor_14_40.convertUuid((UuidType)src);
        }
        if (src instanceof Extension) {
            return VersionConvertor_14_40.convertExtension((Extension)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Narrative) {
            return VersionConvertor_14_40.convertNarrative((org.hl7.fhir.r4.model.Narrative)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Age) {
            return VersionConvertor_14_40.convertAge((org.hl7.fhir.r4.model.Age)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Annotation) {
            return VersionConvertor_14_40.convertAnnotation((org.hl7.fhir.r4.model.Annotation)src);
        }
        if (src instanceof Attachment) {
            return VersionConvertor_14_40.convertAttachment((Attachment)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.CodeableConcept) {
            return VersionConvertor_14_40.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)src);
        }
        if (src instanceof Coding) {
            return VersionConvertor_14_40.convertCoding((Coding)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Count) {
            return VersionConvertor_14_40.convertCount((org.hl7.fhir.r4.model.Count)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Distance) {
            return VersionConvertor_14_40.convertDistance((org.hl7.fhir.r4.model.Distance)src);
        }
        if (src instanceof Duration) {
            return VersionConvertor_14_40.convertDuration((Duration)src);
        }
        if (src instanceof Identifier) {
            return VersionConvertor_14_40.convertIdentifier((Identifier)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Money) {
            return VersionConvertor_14_40.convertMoney((org.hl7.fhir.r4.model.Money)src);
        }
        if (src instanceof Period) {
            return VersionConvertor_14_40.convertPeriod((Period)src);
        }
        if (src instanceof Quantity) {
            return VersionConvertor_14_40.convertQuantity((Quantity)src);
        }
        if (src instanceof Range) {
            return VersionConvertor_14_40.convertRange((Range)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Ratio) {
            return VersionConvertor_14_40.convertRatio((org.hl7.fhir.r4.model.Ratio)src);
        }
        if (src instanceof Reference) {
            return VersionConvertor_14_40.convertReference((Reference)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.SampledData) {
            return VersionConvertor_14_40.convertSampledData((org.hl7.fhir.r4.model.SampledData)src);
        }
        if (src instanceof Signature) {
            return VersionConvertor_14_40.convertSignature((Signature)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Address) {
            return VersionConvertor_14_40.convertAddress((org.hl7.fhir.r4.model.Address)src);
        }
        if (src instanceof ContactPoint) {
            return VersionConvertor_14_40.convertContactPoint((ContactPoint)src);
        }
        if (src instanceof HumanName) {
            return VersionConvertor_14_40.convertHumanName((HumanName)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Meta) {
            return VersionConvertor_14_40.convertMeta((org.hl7.fhir.r4.model.Meta)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Timing) {
            return VersionConvertor_14_40.convertTiming((org.hl7.fhir.r4.model.Timing)src);
        }
        throw new FHIRException("Unknown type " + src.fhirType());
    }

    public static boolean isExemptExtension(String url, String[] extensionsToIgnore) {
        boolean ok = false;
        for (String s2 : extensionsToIgnore) {
            if (!s2.equals(url)) continue;
            ok = true;
        }
        return ok;
    }

    public static void copyDomainResource(DomainResource src, org.hl7.fhir.r4.model.DomainResource tgt, String ... extensionsToIgnore) throws FHIRException {
        VersionConvertor_14_40.copyResource(src, tgt);
        tgt.setText(VersionConvertor_14_40.convertNarrative(src.getText()));
        for (org.hl7.fhir.dstu2016may.model.Resource resource : src.getContained()) {
            tgt.addContained(VersionConvertor_14_40.convertResource(resource));
        }
        for (org.hl7.fhir.dstu2016may.model.Extension extension : src.getExtension()) {
            if (VersionConvertor_14_40.isExemptExtension(extension.getUrl(), extensionsToIgnore)) continue;
            tgt.addExtension(VersionConvertor_14_40.convertExtension(extension));
        }
        for (org.hl7.fhir.dstu2016may.model.Extension extension : src.getModifierExtension()) {
            if (VersionConvertor_14_40.isExemptExtension(extension.getUrl(), extensionsToIgnore)) continue;
            tgt.addModifierExtension(VersionConvertor_14_40.convertExtension(extension));
        }
    }

    public static void copyDomainResource(org.hl7.fhir.r4.model.DomainResource src, DomainResource tgt, String ... extensionsToIgnore) throws FHIRException {
        VersionConvertor_14_40.copyResource(src, tgt);
        if (src.hasText()) {
            tgt.setText(VersionConvertor_14_40.convertNarrative(src.getText()));
        }
        for (Resource resource : src.getContained()) {
            tgt.addContained(VersionConvertor_14_40.convertResource(resource));
        }
        for (Extension extension : src.getExtension()) {
            if (VersionConvertor_14_40.isExemptExtension(extension.getUrl(), extensionsToIgnore)) continue;
            tgt.addExtension(VersionConvertor_14_40.convertExtension(extension));
        }
        for (Extension extension : src.getModifierExtension()) {
            if (VersionConvertor_14_40.isExemptExtension(extension.getUrl(), extensionsToIgnore)) continue;
            tgt.addModifierExtension(VersionConvertor_14_40.convertExtension(extension));
        }
    }

    public static void copyResource(org.hl7.fhir.dstu2016may.model.Resource src, Resource tgt) throws FHIRException {
        if (src.hasId()) {
            tgt.setId(src.getId());
        }
        tgt.setMeta(VersionConvertor_14_40.convertMeta(src.getMeta()));
        if (src.hasImplicitRules()) {
            tgt.setImplicitRules(src.getImplicitRules());
        }
        if (src.hasLanguage()) {
            tgt.setLanguage(src.getLanguage());
        }
    }

    public static void copyResource(Resource src, org.hl7.fhir.dstu2016may.model.Resource tgt) throws FHIRException {
        if (src.hasId()) {
            tgt.setId(src.getId());
        }
        if (src.hasMeta()) {
            tgt.setMeta(VersionConvertor_14_40.convertMeta(src.getMeta()));
        }
        if (src.hasImplicitRules()) {
            tgt.setImplicitRules(src.getImplicitRules());
        }
        if (src.hasLanguage()) {
            tgt.setLanguage(src.getLanguage());
        }
    }

    public static org.hl7.fhir.r4.model.Binary convertBinary(Binary src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Binary tgt = new org.hl7.fhir.r4.model.Binary();
        VersionConvertor_14_40.copyResource(src, tgt);
        if (src.hasContentTypeElement()) {
            tgt.setContentTypeElement(VersionConvertor_14_40.convertCode(src.getContentTypeElement()));
        }
        tgt.setContent(src.getContent());
        return tgt;
    }

    public static Binary convertBinary(org.hl7.fhir.r4.model.Binary src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Binary tgt = new Binary();
        VersionConvertor_14_40.copyResource(src, tgt);
        if (src.hasContentTypeElement()) {
            tgt.setContentTypeElement(VersionConvertor_14_40.convertCode(src.getContentTypeElement()));
        }
        tgt.setContent(src.getContent());
        return tgt;
    }

    public static Enumeration<Enumerations.PublicationStatus> convertConformanceResourceStatus(org.hl7.fhir.dstu2016may.model.Enumeration<Enumerations.ConformanceResourceStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Enumerations.PublicationStatus> tgt = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.ConformanceResourceStatus)((Object)src.getValue())) {
            case DRAFT: {
                tgt.setValue((Object)Enumerations.PublicationStatus.DRAFT);
                break;
            }
            case ACTIVE: {
                tgt.setValue((Object)Enumerations.PublicationStatus.ACTIVE);
                break;
            }
            case RETIRED: {
                tgt.setValue((Object)Enumerations.PublicationStatus.RETIRED);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.PublicationStatus.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Enumeration<Enumerations.ConformanceResourceStatus> convertConformanceResourceStatus(Enumeration<Enumerations.PublicationStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Enumeration<Enumerations.ConformanceResourceStatus> tgt = new org.hl7.fhir.dstu2016may.model.Enumeration<Enumerations.ConformanceResourceStatus>(new Enumerations.ConformanceResourceStatusEnumFactory());
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.PublicationStatus)((Object)src.getValue())) {
            case DRAFT: {
                tgt.setValue((Object)Enumerations.ConformanceResourceStatus.DRAFT);
                break;
            }
            case ACTIVE: {
                tgt.setValue((Object)Enumerations.ConformanceResourceStatus.ACTIVE);
                break;
            }
            case RETIRED: {
                tgt.setValue((Object)Enumerations.ConformanceResourceStatus.RETIRED);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.ConformanceResourceStatus.NULL);
            }
        }
        return tgt;
    }

    public static boolean isJurisdiction(CodeableConcept t) {
        return t.hasCoding() && ("http://unstats.un.org/unsd/methods/m49/m49.htm".equals(t.getCoding().get(0).getSystem()) || "urn:iso:std:iso:3166".equals(t.getCoding().get(0).getSystem()) || "https://www.usps.com/".equals(t.getCoding().get(0).getSystem()));
    }

    public static UsageContext convertCodeableConceptToUsageContext(CodeableConcept t) throws FHIRException {
        UsageContext result = new UsageContext();
        result.setValue(VersionConvertor_14_40.convertCodeableConcept(t));
        return result;
    }

    public static CanonicalType convertReferenceToCanonical(org.hl7.fhir.dstu2016may.model.Reference src) throws FHIRException {
        CanonicalType dst = new CanonicalType(src.getReference());
        VersionConvertor_14_40.copyElement(src, dst, new String[0]);
        return dst;
    }

    public static org.hl7.fhir.dstu2016may.model.Reference convertCanonicalToReference(CanonicalType src) throws FHIRException {
        org.hl7.fhir.dstu2016may.model.Reference dst = new org.hl7.fhir.dstu2016may.model.Reference((String)src.getValue());
        VersionConvertor_14_40.copyElement(src, dst, new String[0]);
        return dst;
    }

    public static Enumeration<Enumerations.SearchParamType> convertSearchParamType(org.hl7.fhir.dstu2016may.model.Enumeration<Enumerations.SearchParamType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Enumerations.SearchParamType> tgt = new Enumeration<Enumerations.SearchParamType>(new Enumerations.SearchParamTypeEnumFactory());
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.SearchParamType)((Object)src.getValue())) {
            case NUMBER: {
                tgt.setValue((Object)Enumerations.SearchParamType.NUMBER);
                break;
            }
            case DATE: {
                tgt.setValue((Object)Enumerations.SearchParamType.DATE);
                break;
            }
            case STRING: {
                tgt.setValue((Object)Enumerations.SearchParamType.STRING);
                break;
            }
            case TOKEN: {
                tgt.setValue((Object)Enumerations.SearchParamType.TOKEN);
                break;
            }
            case REFERENCE: {
                tgt.setValue((Object)Enumerations.SearchParamType.REFERENCE);
                break;
            }
            case COMPOSITE: {
                tgt.setValue((Object)Enumerations.SearchParamType.COMPOSITE);
                break;
            }
            case QUANTITY: {
                tgt.setValue((Object)Enumerations.SearchParamType.QUANTITY);
                break;
            }
            case URI: {
                tgt.setValue((Object)Enumerations.SearchParamType.URI);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.SearchParamType.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Enumeration<Enumerations.SearchParamType> convertSearchParamType(Enumeration<Enumerations.SearchParamType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Enumeration<Enumerations.SearchParamType> tgt = new org.hl7.fhir.dstu2016may.model.Enumeration<Enumerations.SearchParamType>(new Enumerations.SearchParamTypeEnumFactory());
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.SearchParamType)((Object)src.getValue())) {
            case NUMBER: {
                tgt.setValue((Object)Enumerations.SearchParamType.NUMBER);
                break;
            }
            case DATE: {
                tgt.setValue((Object)Enumerations.SearchParamType.DATE);
                break;
            }
            case STRING: {
                tgt.setValue((Object)Enumerations.SearchParamType.STRING);
                break;
            }
            case TOKEN: {
                tgt.setValue((Object)Enumerations.SearchParamType.TOKEN);
                break;
            }
            case REFERENCE: {
                tgt.setValue((Object)Enumerations.SearchParamType.REFERENCE);
                break;
            }
            case COMPOSITE: {
                tgt.setValue((Object)Enumerations.SearchParamType.COMPOSITE);
                break;
            }
            case QUANTITY: {
                tgt.setValue((Object)Enumerations.SearchParamType.QUANTITY);
                break;
            }
            case URI: {
                tgt.setValue((Object)Enumerations.SearchParamType.URI);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.SearchParamType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<CapabilityStatement.EventCapabilityMode> convertConformanceEventMode(org.hl7.fhir.dstu2016may.model.Enumeration<Conformance.ConformanceEventMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<CapabilityStatement.EventCapabilityMode> tgt = new Enumeration<CapabilityStatement.EventCapabilityMode>(new CapabilityStatement.EventCapabilityModeEnumFactory());
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        switch ((Conformance.ConformanceEventMode)((Object)src.getValue())) {
            case SENDER: {
                tgt.setValue((Object)CapabilityStatement.EventCapabilityMode.SENDER);
                break;
            }
            case RECEIVER: {
                tgt.setValue((Object)CapabilityStatement.EventCapabilityMode.RECEIVER);
                break;
            }
            default: {
                tgt.setValue((Object)CapabilityStatement.EventCapabilityMode.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Enumeration<Conformance.ConformanceEventMode> convertConformanceEventMode(Enumeration<CapabilityStatement.EventCapabilityMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Enumeration<Conformance.ConformanceEventMode> tgt = new org.hl7.fhir.dstu2016may.model.Enumeration<Conformance.ConformanceEventMode>(new Conformance.ConformanceEventModeEnumFactory());
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        switch ((CapabilityStatement.EventCapabilityMode)((Object)src.getValue())) {
            case SENDER: {
                tgt.setValue((Object)Conformance.ConformanceEventMode.SENDER);
                break;
            }
            case RECEIVER: {
                tgt.setValue((Object)Conformance.ConformanceEventMode.RECEIVER);
                break;
            }
            default: {
                tgt.setValue((Object)Conformance.ConformanceEventMode.NULL);
            }
        }
        return tgt;
    }

    public static Resource convertResource(org.hl7.fhir.dstu2016may.model.Resource src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.Parameters) {
            return Parameters14_40.convertParameters((org.hl7.fhir.dstu2016may.model.Parameters)src);
        }
        if (src instanceof Bundle) {
            return Bundle14_40.convertBundle((Bundle)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.CodeSystem) {
            return CodeSystem14_40.convertCodeSystem((org.hl7.fhir.dstu2016may.model.CodeSystem)src);
        }
        if (src instanceof CompartmentDefinition) {
            return CompartmentDefinition14_40.convertCompartmentDefinition((CompartmentDefinition)src);
        }
        if (src instanceof ConceptMap) {
            return ConceptMap14_40.convertConceptMap((ConceptMap)src);
        }
        if (src instanceof Conformance) {
            return Conformance14_40.convertConformance((Conformance)src);
        }
        if (src instanceof DataElement) {
            return DataElement14_40.convertDataElement((DataElement)src);
        }
        if (src instanceof ImplementationGuide) {
            return ImplementationGuide14_40.convertImplementationGuide((ImplementationGuide)src);
        }
        if (src instanceof NamingSystem) {
            return NamingSystem14_40.convertNamingSystem((NamingSystem)src);
        }
        if (src instanceof OperationDefinition) {
            return OperationDefinition14_40.convertOperationDefinition((OperationDefinition)src);
        }
        if (src instanceof OperationOutcome) {
            return OperationOutcome14_40.convertOperationOutcome((OperationOutcome)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.Questionnaire) {
            return Questionnaire14_40.convertQuestionnaire((org.hl7.fhir.dstu2016may.model.Questionnaire)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.QuestionnaireResponse) {
            return QuestionnaireResponse14_40.convertQuestionnaireResponse((org.hl7.fhir.dstu2016may.model.QuestionnaireResponse)src);
        }
        if (src instanceof SearchParameter) {
            return SearchParameter14_40.convertSearchParameter((SearchParameter)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.StructureDefinition) {
            return StructureDefinition14_40.convertStructureDefinition((org.hl7.fhir.dstu2016may.model.StructureDefinition)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.StructureMap) {
            return StructureMap14_40.convertStructureMap((org.hl7.fhir.dstu2016may.model.StructureMap)src);
        }
        if (src instanceof ValueSet) {
            return ValueSet14_40.convertValueSet((ValueSet)src);
        }
        throw new FHIRException("Unknown resource " + src.fhirType());
    }

    public static org.hl7.fhir.dstu2016may.model.Resource convertResource(Resource src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        if (src instanceof Parameters) {
            return Parameters14_40.convertParameters((Parameters)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Bundle) {
            return Bundle14_40.convertBundle((org.hl7.fhir.r4.model.Bundle)src);
        }
        if (src instanceof CodeSystem) {
            return CodeSystem14_40.convertCodeSystem((CodeSystem)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.CompartmentDefinition) {
            return CompartmentDefinition14_40.convertCompartmentDefinition((org.hl7.fhir.r4.model.CompartmentDefinition)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.ConceptMap) {
            return ConceptMap14_40.convertConceptMap((org.hl7.fhir.r4.model.ConceptMap)src);
        }
        if (src instanceof CapabilityStatement) {
            return Conformance14_40.convertConformance((CapabilityStatement)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.ImplementationGuide) {
            return ImplementationGuide14_40.convertImplementationGuide((org.hl7.fhir.r4.model.ImplementationGuide)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.NamingSystem) {
            return NamingSystem14_40.convertNamingSystem((org.hl7.fhir.r4.model.NamingSystem)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.OperationDefinition) {
            return OperationDefinition14_40.convertOperationDefinition((org.hl7.fhir.r4.model.OperationDefinition)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.OperationOutcome) {
            return OperationOutcome14_40.convertOperationOutcome((org.hl7.fhir.r4.model.OperationOutcome)src);
        }
        if (src instanceof Questionnaire) {
            return Questionnaire14_40.convertQuestionnaire((Questionnaire)src);
        }
        if (src instanceof QuestionnaireResponse) {
            return QuestionnaireResponse14_40.convertQuestionnaireResponse((QuestionnaireResponse)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.SearchParameter) {
            return SearchParameter14_40.convertSearchParameter((org.hl7.fhir.r4.model.SearchParameter)src);
        }
        if (src instanceof StructureDefinition) {
            return StructureDefinition14_40.convertStructureDefinition((StructureDefinition)src);
        }
        if (src instanceof StructureMap) {
            return StructureMap14_40.convertStructureMap((StructureMap)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.ValueSet) {
            return ValueSet14_40.convertValueSet((org.hl7.fhir.r4.model.ValueSet)src);
        }
        throw new FHIRException("Unknown resource " + src.fhirType());
    }

    public static boolean convertsResource(String rt) {
        return Utilities.existsInList(rt, "Parameters", "Bundle", "CodeSystem", "CompartmentDefinition", "ConceptMap", "CapabilityStatement", "ImplementationGuide", "NamingSystem", "OperationDefinition", "OperationOutcome", "Questionnaire", "QuestionnaireResponse", "SearchParameter", "StructureDefinition", "StructureMap", "ValueSet");
    }

    static {
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/11179-permitted-value-conceptmap");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/11179-permitted-value-valueset");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/codesystem-map");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/cqif-library");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/elementdefinition-allowedUnits");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/elementdefinition-inheritedExtensibleValueSet");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/elementdefinition-minValueSet");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/event-instantiatesCanonical");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/questionnaire-allowedProfile");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/questionnaire-deMap");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/questionnaire-sourceStructureMap");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/questionnaire-targetStructureMap");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/questionnaire-unit-valueSet");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/valueset-map");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/valueset-supplement");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/valueset-system");
    }

    public static class SourceElementComponentWrapper {
        public String source;
        public String target;
        public ConceptMap.SourceElementComponent comp;

        public SourceElementComponentWrapper(ConceptMap.SourceElementComponent comp, String source, String target) {
            this.source = source;
            this.target = target;
            this.comp = comp;
        }
    }
}

