/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.stream.Collectors;
import org.hl7.fhir.convertors.conv14_30.Bundle14_30;
import org.hl7.fhir.convertors.conv14_30.CodeSystem14_30;
import org.hl7.fhir.convertors.conv14_30.CompartmentDefinition14_30;
import org.hl7.fhir.convertors.conv14_30.ConceptMap14_30;
import org.hl7.fhir.convertors.conv14_30.Conformance14_30;
import org.hl7.fhir.convertors.conv14_30.DataElement14_30;
import org.hl7.fhir.convertors.conv14_30.ImplementationGuide14_30;
import org.hl7.fhir.convertors.conv14_30.NamingSystem14_30;
import org.hl7.fhir.convertors.conv14_30.OperationDefinition14_30;
import org.hl7.fhir.convertors.conv14_30.OperationOutcome14_30;
import org.hl7.fhir.convertors.conv14_30.Parameters14_30;
import org.hl7.fhir.convertors.conv14_30.Questionnaire14_30;
import org.hl7.fhir.convertors.conv14_30.QuestionnaireResponse14_30;
import org.hl7.fhir.convertors.conv14_30.SearchParameter14_30;
import org.hl7.fhir.convertors.conv14_30.StructureDefinition14_30;
import org.hl7.fhir.convertors.conv14_30.TestScript14_30;
import org.hl7.fhir.convertors.conv14_30.ValueSet14_30;
import org.hl7.fhir.dstu2016may.model.Address;
import org.hl7.fhir.dstu2016may.model.Age;
import org.hl7.fhir.dstu2016may.model.BackboneElement;
import org.hl7.fhir.dstu2016may.model.Base64BinaryType;
import org.hl7.fhir.dstu2016may.model.Binary;
import org.hl7.fhir.dstu2016may.model.Bundle;
import org.hl7.fhir.dstu2016may.model.CodeSystem;
import org.hl7.fhir.dstu2016may.model.CodeableConcept;
import org.hl7.fhir.dstu2016may.model.CompartmentDefinition;
import org.hl7.fhir.dstu2016may.model.Conformance;
import org.hl7.fhir.dstu2016may.model.ContactPoint;
import org.hl7.fhir.dstu2016may.model.DataElement;
import org.hl7.fhir.dstu2016may.model.DateTimeType;
import org.hl7.fhir.dstu2016may.model.DateType;
import org.hl7.fhir.dstu2016may.model.DecimalType;
import org.hl7.fhir.dstu2016may.model.Distance;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.Element;
import org.hl7.fhir.dstu2016may.model.ElementDefinition;
import org.hl7.fhir.dstu2016may.model.Enumerations;
import org.hl7.fhir.dstu2016may.model.Extension;
import org.hl7.fhir.dstu2016may.model.HumanName;
import org.hl7.fhir.dstu2016may.model.Identifier;
import org.hl7.fhir.dstu2016may.model.ImplementationGuide;
import org.hl7.fhir.dstu2016may.model.IntegerType;
import org.hl7.fhir.dstu2016may.model.Meta;
import org.hl7.fhir.dstu2016may.model.Money;
import org.hl7.fhir.dstu2016may.model.NamingSystem;
import org.hl7.fhir.dstu2016may.model.Narrative;
import org.hl7.fhir.dstu2016may.model.OperationOutcome;
import org.hl7.fhir.dstu2016may.model.PositiveIntType;
import org.hl7.fhir.dstu2016may.model.PrimitiveType;
import org.hl7.fhir.dstu2016may.model.Quantity;
import org.hl7.fhir.dstu2016may.model.Reference;
import org.hl7.fhir.dstu2016may.model.SampledData;
import org.hl7.fhir.dstu2016may.model.StringType;
import org.hl7.fhir.dstu2016may.model.Timing;
import org.hl7.fhir.dstu2016may.model.UnsignedIntType;
import org.hl7.fhir.dstu2016may.model.ValueSet;
import org.hl7.fhir.dstu3.conformance.ProfileUtilities;
import org.hl7.fhir.dstu3.model.Address;
import org.hl7.fhir.dstu3.model.Annotation;
import org.hl7.fhir.dstu3.model.Attachment;
import org.hl7.fhir.dstu3.model.BooleanType;
import org.hl7.fhir.dstu3.model.CapabilityStatement;
import org.hl7.fhir.dstu3.model.CodeType;
import org.hl7.fhir.dstu3.model.Coding;
import org.hl7.fhir.dstu3.model.ConceptMap;
import org.hl7.fhir.dstu3.model.ContactPoint;
import org.hl7.fhir.dstu3.model.Count;
import org.hl7.fhir.dstu3.model.Duration;
import org.hl7.fhir.dstu3.model.ElementDefinition;
import org.hl7.fhir.dstu3.model.Enumeration;
import org.hl7.fhir.dstu3.model.Enumerations;
import org.hl7.fhir.dstu3.model.HumanName;
import org.hl7.fhir.dstu3.model.IdType;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.InstantType;
import org.hl7.fhir.dstu3.model.MarkdownType;
import org.hl7.fhir.dstu3.model.Narrative;
import org.hl7.fhir.dstu3.model.OidType;
import org.hl7.fhir.dstu3.model.OperationDefinition;
import org.hl7.fhir.dstu3.model.Parameters;
import org.hl7.fhir.dstu3.model.Period;
import org.hl7.fhir.dstu3.model.Quantity;
import org.hl7.fhir.dstu3.model.Questionnaire;
import org.hl7.fhir.dstu3.model.QuestionnaireResponse;
import org.hl7.fhir.dstu3.model.Range;
import org.hl7.fhir.dstu3.model.Ratio;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.dstu3.model.SearchParameter;
import org.hl7.fhir.dstu3.model.Signature;
import org.hl7.fhir.dstu3.model.SimpleQuantity;
import org.hl7.fhir.dstu3.model.StructureDefinition;
import org.hl7.fhir.dstu3.model.TestScript;
import org.hl7.fhir.dstu3.model.TimeType;
import org.hl7.fhir.dstu3.model.Timing;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.dstu3.model.UriType;
import org.hl7.fhir.dstu3.model.UsageContext;
import org.hl7.fhir.dstu3.model.UuidType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.utilities.Utilities;

public class VersionConvertor_14_30 {
    public static void copyElement(Element src, org.hl7.fhir.dstu3.model.Element tgt, String ... exemptExtensions) throws FHIRException {
        if (src.hasId()) {
            tgt.setId(src.getId());
        }
        for (Extension e : src.getExtension()) {
            if (Utilities.existsInList(e.getUrl(), exemptExtensions) || e.getUrl().equals("http://hl7.org/fhir/4.0/StructureDefinition/extension-ElementDefinition.type.profile") || e.getUrl().equals("http://hl7.org/fhir/4.0/StructureDefinition/extension-ImplementationGuide.dependsOn.packageId") || e.getUrl().equals("http://hl7.org/fhir/4.0/StructureDefinition/extension-ImplementationGuide.dependsOn.version")) continue;
            tgt.addExtension(VersionConvertor_14_30.convertExtension(e));
        }
    }

    public static void copyElement(org.hl7.fhir.dstu3.model.Element src, Element tgt, String ... exemptExtensions) throws FHIRException {
        if (src.hasId()) {
            tgt.setId(src.getId());
        }
        for (org.hl7.fhir.dstu3.model.Extension e : src.getExtension()) {
            if (Utilities.existsInList(e.getUrl(), exemptExtensions)) continue;
            tgt.addExtension(VersionConvertor_14_30.convertExtension(e));
        }
    }

    public static void copyBackboneElement(BackboneElement src, org.hl7.fhir.dstu3.model.BackboneElement tgt) throws FHIRException {
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        for (Extension e : src.getModifierExtension()) {
            tgt.addModifierExtension(VersionConvertor_14_30.convertExtension(e));
        }
    }

    public static void copyBackboneElement(org.hl7.fhir.dstu3.model.BackboneElement src, BackboneElement tgt) throws FHIRException {
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        for (org.hl7.fhir.dstu3.model.Extension e : src.getModifierExtension()) {
            tgt.addModifierExtension(VersionConvertor_14_30.convertExtension(e));
        }
    }

    public static org.hl7.fhir.dstu3.model.Base64BinaryType convertBase64Binary(Base64BinaryType src) throws FHIRException {
        org.hl7.fhir.dstu3.model.Base64BinaryType tgt = new org.hl7.fhir.dstu3.model.Base64BinaryType();
        if (src.hasValue()) {
            tgt.setValue((byte[])src.getValue());
        }
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static Base64BinaryType convertBase64Binary(org.hl7.fhir.dstu3.model.Base64BinaryType src) throws FHIRException {
        Base64BinaryType tgt = new Base64BinaryType();
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static BooleanType convertBoolean(org.hl7.fhir.dstu2016may.model.BooleanType src) throws FHIRException {
        BooleanType tgt = new BooleanType();
        if (src.hasValue()) {
            tgt.setValue((Boolean)src.getValue());
        }
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.BooleanType convertBoolean(BooleanType src) throws FHIRException {
        org.hl7.fhir.dstu2016may.model.BooleanType tgt = new org.hl7.fhir.dstu2016may.model.BooleanType();
        if (src.hasValue()) {
            tgt.setValue((Boolean)src.getValue());
        }
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static CodeType convertCode(org.hl7.fhir.dstu2016may.model.CodeType src) throws FHIRException {
        CodeType tgt = new CodeType();
        if (src.hasValue()) {
            tgt.setValue((String)src.getValue());
        }
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.CodeType convertCode(CodeType src) throws FHIRException {
        org.hl7.fhir.dstu2016may.model.CodeType tgt = new org.hl7.fhir.dstu2016may.model.CodeType();
        if (src.hasValue()) {
            tgt.setValue((String)src.getValue());
        }
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.DateType convertDate(DateType src) throws FHIRException {
        org.hl7.fhir.dstu3.model.DateType tgt = new org.hl7.fhir.dstu3.model.DateType();
        if (src.hasValue()) {
            tgt.setValue((Date)src.getValue());
        }
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static DateType convertDate(org.hl7.fhir.dstu3.model.DateType src) throws FHIRException {
        DateType tgt = new DateType();
        if (src.hasValue()) {
            tgt.setValue((Date)src.getValue());
        }
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.DateTimeType convertDateTime(DateTimeType src) throws FHIRException {
        org.hl7.fhir.dstu3.model.DateTimeType tgt = new org.hl7.fhir.dstu3.model.DateTimeType();
        if (src.hasValue()) {
            tgt.setValue((Date)src.getValue());
        }
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static DateTimeType convertDateTime(org.hl7.fhir.dstu3.model.DateTimeType src) throws FHIRException {
        DateTimeType tgt = new DateTimeType();
        if (src.hasValue()) {
            tgt.setValue((Date)src.getValue());
        }
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.DecimalType convertDecimal(DecimalType src) throws FHIRException {
        org.hl7.fhir.dstu3.model.DecimalType tgt = new org.hl7.fhir.dstu3.model.DecimalType();
        if (src.hasValue()) {
            tgt.setValue((BigDecimal)src.getValue());
        }
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static DecimalType convertDecimal(org.hl7.fhir.dstu3.model.DecimalType src) throws FHIRException {
        DecimalType tgt = new DecimalType();
        if (src.hasValue()) {
            tgt.setValue((BigDecimal)src.getValue());
        }
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static IdType convertId(org.hl7.fhir.dstu2016may.model.IdType src) throws FHIRException {
        IdType tgt = new IdType();
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.IdType convertId(IdType src) throws FHIRException {
        org.hl7.fhir.dstu2016may.model.IdType tgt = new org.hl7.fhir.dstu2016may.model.IdType();
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static InstantType convertInstant(org.hl7.fhir.dstu2016may.model.InstantType src) throws FHIRException {
        InstantType tgt = new InstantType();
        if (src.hasValue()) {
            tgt.setValue((Date)src.getValue());
        }
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.InstantType convertInstant(InstantType src) throws FHIRException {
        org.hl7.fhir.dstu2016may.model.InstantType tgt = new org.hl7.fhir.dstu2016may.model.InstantType();
        if (src.hasValue()) {
            tgt.setValue((Date)src.getValue());
        }
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.IntegerType convertInteger(IntegerType src) throws FHIRException {
        org.hl7.fhir.dstu3.model.IntegerType tgt = new org.hl7.fhir.dstu3.model.IntegerType();
        if (src.hasValue()) {
            tgt.setValue((Integer)src.getValue());
        }
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static IntegerType convertInteger(org.hl7.fhir.dstu3.model.IntegerType src) throws FHIRException {
        IntegerType tgt = new IntegerType();
        if (src.hasValue()) {
            tgt.setValue((Integer)src.getValue());
        }
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static MarkdownType convertMarkdown(org.hl7.fhir.dstu2016may.model.MarkdownType src) throws FHIRException {
        MarkdownType tgt = new MarkdownType();
        if (src.hasValue()) {
            tgt.setValue((String)src.getValue());
        }
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.MarkdownType convertMarkdown(MarkdownType src) throws FHIRException {
        org.hl7.fhir.dstu2016may.model.MarkdownType tgt = new org.hl7.fhir.dstu2016may.model.MarkdownType();
        if (src.hasValue()) {
            tgt.setValue((String)src.getValue());
        }
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static OidType convertOid(org.hl7.fhir.dstu2016may.model.OidType src) throws FHIRException {
        OidType tgt = new OidType();
        if (src.hasValue()) {
            tgt.setValue((String)src.getValue());
        }
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.OidType convertOid(OidType src) throws FHIRException {
        org.hl7.fhir.dstu2016may.model.OidType tgt = new org.hl7.fhir.dstu2016may.model.OidType();
        if (src.hasValue()) {
            tgt.setValue((String)src.getValue());
        }
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.PositiveIntType convertPositiveInt(PositiveIntType src) throws FHIRException {
        org.hl7.fhir.dstu3.model.PositiveIntType tgt = new org.hl7.fhir.dstu3.model.PositiveIntType();
        if (src.hasValue()) {
            tgt.setValue((Integer)src.getValue());
        }
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static PositiveIntType convertPositiveInt(org.hl7.fhir.dstu3.model.PositiveIntType src) throws FHIRException {
        PositiveIntType tgt = new PositiveIntType();
        if (src.hasValue()) {
            tgt.setValue((Integer)src.getValue());
        }
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.StringType convertString(StringType src) throws FHIRException {
        org.hl7.fhir.dstu3.model.StringType tgt = new org.hl7.fhir.dstu3.model.StringType();
        if (src.hasValue()) {
            tgt.setValue((String)src.getValue());
        }
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static StringType convertString(org.hl7.fhir.dstu3.model.StringType src) throws FHIRException {
        StringType tgt = new StringType();
        if (src.hasValue()) {
            tgt.setValue((String)src.getValue());
        }
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static TimeType convertTime(org.hl7.fhir.dstu2016may.model.TimeType src) throws FHIRException {
        TimeType tgt = new TimeType();
        if (src.hasValue()) {
            tgt.setValue((String)src.getValue());
        }
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.TimeType convertTime(TimeType src) throws FHIRException {
        org.hl7.fhir.dstu2016may.model.TimeType tgt = new org.hl7.fhir.dstu2016may.model.TimeType();
        if (src.hasValue()) {
            tgt.setValue((String)src.getValue());
        }
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.UnsignedIntType convertUnsignedInt(UnsignedIntType src) throws FHIRException {
        org.hl7.fhir.dstu3.model.UnsignedIntType tgt = new org.hl7.fhir.dstu3.model.UnsignedIntType();
        if (src.hasValue()) {
            tgt.setValue((Integer)src.getValue());
        }
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static UnsignedIntType convertUnsignedInt(org.hl7.fhir.dstu3.model.UnsignedIntType src) throws FHIRException {
        UnsignedIntType tgt = new UnsignedIntType();
        if (src.hasValue()) {
            tgt.setValue((Integer)src.getValue());
        }
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static UriType convertUri(org.hl7.fhir.dstu2016may.model.UriType src) throws FHIRException {
        UriType tgt = new UriType();
        if (src.hasValue()) {
            tgt.setValue((String)src.getValue());
        }
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.UriType convertUri(UriType src) throws FHIRException {
        org.hl7.fhir.dstu2016may.model.UriType tgt = new org.hl7.fhir.dstu2016may.model.UriType();
        if (src.hasValue()) {
            tgt.setValue((String)src.getValue());
        }
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static UuidType convertUuid(org.hl7.fhir.dstu2016may.model.UuidType src) throws FHIRException {
        UuidType tgt = new UuidType();
        if (src.hasValue()) {
            tgt.setValue((String)src.getValue());
        }
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.UuidType convertUuid(UuidType src) throws FHIRException {
        org.hl7.fhir.dstu2016may.model.UuidType tgt = new org.hl7.fhir.dstu2016may.model.UuidType();
        if (src.hasValue()) {
            tgt.setValue((String)src.getValue());
        }
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Extension convertExtension(Extension src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Extension tgt = new org.hl7.fhir.dstu3.model.Extension();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasUrlElement()) {
            tgt.setUrlElement(VersionConvertor_14_30.convertUri(src.getUrlElement()));
        }
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_14_30.convertType(src.getValue()));
        }
        return tgt;
    }

    public static Extension convertExtension(org.hl7.fhir.dstu3.model.Extension src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Extension tgt = new Extension();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasUrlElement()) {
            tgt.setUrlElement(VersionConvertor_14_30.convertUri(src.getUrlElement()));
        }
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_14_30.convertType(src.getValue()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Narrative convertNarrative(Narrative src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Narrative tgt = new org.hl7.fhir.dstu3.model.Narrative();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasStatus()) {
            tgt.setStatusElement(VersionConvertor_14_30.convertNarrativeStatus(src.getStatusElement()));
        }
        tgt.setDiv(src.getDiv());
        return tgt;
    }

    public static Narrative convertNarrative(org.hl7.fhir.dstu3.model.Narrative src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Narrative tgt = new Narrative();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasStatus()) {
            tgt.setStatusElement(VersionConvertor_14_30.convertNarrativeStatus(src.getStatusElement()));
        }
        tgt.setDiv(src.getDiv());
        return tgt;
    }

    public static Enumeration<Narrative.NarrativeStatus> convertNarrativeStatus(org.hl7.fhir.dstu2016may.model.Enumeration<Narrative.NarrativeStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Narrative.NarrativeStatus> tgt = new Enumeration<Narrative.NarrativeStatus>(new Narrative.NarrativeStatusEnumFactory());
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        switch ((Narrative.NarrativeStatus)((Object)src.getValue())) {
            case GENERATED: {
                tgt.setValue((Object)Narrative.NarrativeStatus.GENERATED);
                break;
            }
            case EXTENSIONS: {
                tgt.setValue((Object)Narrative.NarrativeStatus.EXTENSIONS);
                break;
            }
            case ADDITIONAL: {
                tgt.setValue((Object)Narrative.NarrativeStatus.ADDITIONAL);
                break;
            }
            case EMPTY: {
                tgt.setValue((Object)Narrative.NarrativeStatus.EMPTY);
                break;
            }
            default: {
                tgt.setValue((Object)Narrative.NarrativeStatus.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Enumeration<Narrative.NarrativeStatus> convertNarrativeStatus(Enumeration<Narrative.NarrativeStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Enumeration<Narrative.NarrativeStatus> tgt = new org.hl7.fhir.dstu2016may.model.Enumeration<Narrative.NarrativeStatus>(new Narrative.NarrativeStatusEnumFactory());
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        switch ((Narrative.NarrativeStatus)((Object)src.getValue())) {
            case GENERATED: {
                tgt.setValue((Object)Narrative.NarrativeStatus.GENERATED);
                break;
            }
            case EXTENSIONS: {
                tgt.setValue((Object)Narrative.NarrativeStatus.EXTENSIONS);
                break;
            }
            case ADDITIONAL: {
                tgt.setValue((Object)Narrative.NarrativeStatus.ADDITIONAL);
                break;
            }
            case EMPTY: {
                tgt.setValue((Object)Narrative.NarrativeStatus.EMPTY);
                break;
            }
            default: {
                tgt.setValue((Object)Narrative.NarrativeStatus.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Age convertAge(Age src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Age tgt = new org.hl7.fhir.dstu3.model.Age();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_14_30.convertDecimal(src.getValueElement()));
        }
        if (src.hasComparator()) {
            tgt.setComparatorElement(VersionConvertor_14_30.convertQuantityComparator(src.getComparatorElement()));
        }
        if (src.hasUnit()) {
            tgt.setUnitElement(VersionConvertor_14_30.convertString(src.getUnitElement()));
        }
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_14_30.convertUri(src.getSystemElement()));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_14_30.convertCode(src.getCodeElement()));
        }
        return tgt;
    }

    public static Age convertAge(org.hl7.fhir.dstu3.model.Age src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Age tgt = new Age();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_14_30.convertDecimal(src.getValueElement()));
        }
        if (src.hasComparator()) {
            tgt.setComparatorElement(VersionConvertor_14_30.convertQuantityComparator(src.getComparatorElement()));
        }
        if (src.hasUnit()) {
            tgt.setUnitElement(VersionConvertor_14_30.convertString(src.getUnitElement()));
        }
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_14_30.convertUri(src.getSystemElement()));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_14_30.convertCode(src.getCodeElement()));
        }
        return tgt;
    }

    public static Annotation convertAnnotation(org.hl7.fhir.dstu2016may.model.Annotation src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Annotation tgt = new Annotation();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasAuthor()) {
            tgt.setAuthor(VersionConvertor_14_30.convertType(src.getAuthor()));
        }
        if (src.hasTime()) {
            tgt.setTimeElement(VersionConvertor_14_30.convertDateTime(src.getTimeElement()));
        }
        if (src.hasTextElement()) {
            tgt.setTextElement(VersionConvertor_14_30.convertString(src.getTextElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Annotation convertAnnotation(Annotation src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Annotation tgt = new org.hl7.fhir.dstu2016may.model.Annotation();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasAuthor()) {
            tgt.setAuthor(VersionConvertor_14_30.convertType(src.getAuthor()));
        }
        if (src.hasTime()) {
            tgt.setTimeElement(VersionConvertor_14_30.convertDateTime(src.getTimeElement()));
        }
        if (src.hasTextElement()) {
            tgt.setTextElement(VersionConvertor_14_30.convertString(src.getTextElement()));
        }
        return tgt;
    }

    public static Attachment convertAttachment(org.hl7.fhir.dstu2016may.model.Attachment src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Attachment tgt = new Attachment();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasContentType()) {
            tgt.setContentTypeElement(VersionConvertor_14_30.convertCode(src.getContentTypeElement()));
        }
        if (src.hasLanguage()) {
            tgt.setLanguageElement(VersionConvertor_14_30.convertCode(src.getLanguageElement()));
        }
        if (src.hasData()) {
            tgt.setDataElement(VersionConvertor_14_30.convertBase64Binary(src.getDataElement()));
        }
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_14_30.convertUri(src.getUrlElement()));
        }
        if (src.hasSize()) {
            tgt.setSizeElement(VersionConvertor_14_30.convertUnsignedInt(src.getSizeElement()));
        }
        if (src.hasHash()) {
            tgt.setHashElement(VersionConvertor_14_30.convertBase64Binary(src.getHashElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(VersionConvertor_14_30.convertString(src.getTitleElement()));
        }
        if (src.hasCreation()) {
            tgt.setCreationElement(VersionConvertor_14_30.convertDateTime(src.getCreationElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Attachment convertAttachment(Attachment src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Attachment tgt = new org.hl7.fhir.dstu2016may.model.Attachment();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasContentType()) {
            tgt.setContentTypeElement(VersionConvertor_14_30.convertCode(src.getContentTypeElement()));
        }
        if (src.hasLanguage()) {
            tgt.setLanguageElement(VersionConvertor_14_30.convertCode(src.getLanguageElement()));
        }
        if (src.hasData()) {
            tgt.setDataElement(VersionConvertor_14_30.convertBase64Binary(src.getDataElement()));
        }
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_14_30.convertUri(src.getUrlElement()));
        }
        if (src.hasSize()) {
            tgt.setSizeElement(VersionConvertor_14_30.convertUnsignedInt(src.getSizeElement()));
        }
        if (src.hasHash()) {
            tgt.setHashElement(VersionConvertor_14_30.convertBase64Binary(src.getHashElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(VersionConvertor_14_30.convertString(src.getTitleElement()));
        }
        if (src.hasCreation()) {
            tgt.setCreationElement(VersionConvertor_14_30.convertDateTime(src.getCreationElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.CodeableConcept convertCodeableConcept(CodeableConcept src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.CodeableConcept tgt = new org.hl7.fhir.dstu3.model.CodeableConcept();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        for (org.hl7.fhir.dstu2016may.model.Coding t : src.getCoding()) {
            tgt.addCoding(VersionConvertor_14_30.convertCoding(t));
        }
        if (src.hasText()) {
            tgt.setTextElement(VersionConvertor_14_30.convertString(src.getTextElement()));
        }
        return tgt;
    }

    public static CodeableConcept convertCodeableConcept(org.hl7.fhir.dstu3.model.CodeableConcept src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CodeableConcept tgt = new CodeableConcept();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        for (Coding t : src.getCoding()) {
            tgt.addCoding(VersionConvertor_14_30.convertCoding(t));
        }
        if (src.hasText()) {
            tgt.setTextElement(VersionConvertor_14_30.convertString(src.getTextElement()));
        }
        return tgt;
    }

    public static Coding convertCoding(org.hl7.fhir.dstu2016may.model.Coding src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Coding tgt = new Coding();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_14_30.convertUri(src.getSystemElement()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_14_30.convertString(src.getVersionElement()));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_14_30.convertCode(src.getCodeElement()));
        }
        if (src.hasDisplay()) {
            tgt.setDisplayElement(VersionConvertor_14_30.convertString(src.getDisplayElement()));
        }
        if (src.hasUserSelected()) {
            tgt.setUserSelectedElement(VersionConvertor_14_30.convertBoolean(src.getUserSelectedElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Coding convertCoding(Coding src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Coding tgt = new org.hl7.fhir.dstu2016may.model.Coding();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_14_30.convertUri(src.getSystemElement()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_14_30.convertString(src.getVersionElement()));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_14_30.convertCode(src.getCodeElement()));
        }
        if (src.hasDisplay()) {
            tgt.setDisplayElement(VersionConvertor_14_30.convertString(src.getDisplayElement()));
        }
        if (src.hasUserSelected()) {
            tgt.setUserSelectedElement(VersionConvertor_14_30.convertBoolean(src.getUserSelectedElement()));
        }
        return tgt;
    }

    public static Count convertCount(org.hl7.fhir.dstu2016may.model.Count src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Count tgt = new Count();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_14_30.convertDecimal(src.getValueElement()));
        }
        if (src.hasComparator()) {
            tgt.setComparatorElement(VersionConvertor_14_30.convertQuantityComparator(src.getComparatorElement()));
        }
        if (src.hasUnit()) {
            tgt.setUnitElement(VersionConvertor_14_30.convertString(src.getUnitElement()));
        }
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_14_30.convertUri(src.getSystemElement()));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_14_30.convertCode(src.getCodeElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Count convertCount(Count src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Count tgt = new org.hl7.fhir.dstu2016may.model.Count();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_14_30.convertDecimal(src.getValueElement()));
        }
        if (src.hasComparator()) {
            tgt.setComparatorElement(VersionConvertor_14_30.convertQuantityComparator(src.getComparatorElement()));
        }
        if (src.hasUnit()) {
            tgt.setUnitElement(VersionConvertor_14_30.convertString(src.getUnitElement()));
        }
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_14_30.convertUri(src.getSystemElement()));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_14_30.convertCode(src.getCodeElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Distance convertDistance(Distance src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Distance tgt = new org.hl7.fhir.dstu3.model.Distance();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_14_30.convertDecimal(src.getValueElement()));
        }
        if (src.hasComparator()) {
            tgt.setComparatorElement(VersionConvertor_14_30.convertQuantityComparator(src.getComparatorElement()));
        }
        if (src.hasUnit()) {
            tgt.setUnitElement(VersionConvertor_14_30.convertString(src.getUnitElement()));
        }
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_14_30.convertUri(src.getSystemElement()));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_14_30.convertCode(src.getCodeElement()));
        }
        return tgt;
    }

    public static Distance convertDistance(org.hl7.fhir.dstu3.model.Distance src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Distance tgt = new Distance();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_14_30.convertDecimal(src.getValueElement()));
        }
        if (src.hasComparator()) {
            tgt.setComparatorElement(VersionConvertor_14_30.convertQuantityComparator(src.getComparatorElement()));
        }
        if (src.hasUnit()) {
            tgt.setUnitElement(VersionConvertor_14_30.convertString(src.getUnitElement()));
        }
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_14_30.convertUri(src.getSystemElement()));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_14_30.convertCode(src.getCodeElement()));
        }
        return tgt;
    }

    public static Duration convertDuration(org.hl7.fhir.dstu2016may.model.Duration src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Duration tgt = new Duration();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_14_30.convertDecimal(src.getValueElement()));
        }
        if (src.hasComparator()) {
            tgt.setComparatorElement(VersionConvertor_14_30.convertQuantityComparator(src.getComparatorElement()));
        }
        if (src.hasUnit()) {
            tgt.setUnitElement(VersionConvertor_14_30.convertString(src.getUnitElement()));
        }
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_14_30.convertUri(src.getSystemElement()));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_14_30.convertCode(src.getCodeElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Duration convertDuration(Duration src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Duration tgt = new org.hl7.fhir.dstu2016may.model.Duration();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_14_30.convertDecimal(src.getValueElement()));
        }
        if (src.hasComparator()) {
            tgt.setComparatorElement(VersionConvertor_14_30.convertQuantityComparator(src.getComparatorElement()));
        }
        if (src.hasUnit()) {
            tgt.setUnitElement(VersionConvertor_14_30.convertString(src.getUnitElement()));
        }
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_14_30.convertUri(src.getSystemElement()));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_14_30.convertCode(src.getCodeElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Money convertMoney(Money src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Money tgt = new org.hl7.fhir.dstu3.model.Money();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_14_30.convertDecimal(src.getValueElement()));
        }
        if (src.hasComparator()) {
            tgt.setComparatorElement(VersionConvertor_14_30.convertQuantityComparator(src.getComparatorElement()));
        }
        if (src.hasUnit()) {
            tgt.setUnitElement(VersionConvertor_14_30.convertString(src.getUnitElement()));
        }
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_14_30.convertUri(src.getSystemElement()));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_14_30.convertCode(src.getCodeElement()));
        }
        return tgt;
    }

    public static Money convertMoney(org.hl7.fhir.dstu3.model.Money src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Money tgt = new Money();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_14_30.convertDecimal(src.getValueElement()));
        }
        if (src.hasComparator()) {
            tgt.setComparatorElement(VersionConvertor_14_30.convertQuantityComparator(src.getComparatorElement()));
        }
        if (src.hasUnit()) {
            tgt.setUnitElement(VersionConvertor_14_30.convertString(src.getUnitElement()));
        }
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_14_30.convertUri(src.getSystemElement()));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_14_30.convertCode(src.getCodeElement()));
        }
        return tgt;
    }

    public static Identifier convertIdentifier(org.hl7.fhir.dstu2016may.model.Identifier src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Identifier tgt = new Identifier();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasUse()) {
            tgt.setUseElement(VersionConvertor_14_30.convertIdentifierUse(src.getUseElement()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_14_30.convertCodeableConcept(src.getType()));
        }
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_14_30.convertUri(src.getSystemElement()));
        }
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_14_30.convertString(src.getValueElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_14_30.convertPeriod(src.getPeriod()));
        }
        if (src.hasAssigner()) {
            tgt.setAssigner(VersionConvertor_14_30.convertReference(src.getAssigner()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Identifier convertIdentifier(Identifier src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Identifier tgt = new org.hl7.fhir.dstu2016may.model.Identifier();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasUse()) {
            tgt.setUseElement(VersionConvertor_14_30.convertIdentifierUse(src.getUseElement()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_14_30.convertCodeableConcept(src.getType()));
        }
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_14_30.convertUri(src.getSystemElement()));
        }
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_14_30.convertString(src.getValueElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_14_30.convertPeriod(src.getPeriod()));
        }
        if (src.hasAssigner()) {
            tgt.setAssigner(VersionConvertor_14_30.convertReference(src.getAssigner()));
        }
        return tgt;
    }

    public static Enumeration<Identifier.IdentifierUse> convertIdentifierUse(org.hl7.fhir.dstu2016may.model.Enumeration<Identifier.IdentifierUse> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Identifier.IdentifierUse> tgt = new Enumeration<Identifier.IdentifierUse>(new Identifier.IdentifierUseEnumFactory());
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        switch ((Identifier.IdentifierUse)((Object)src.getValue())) {
            case USUAL: {
                tgt.setValue((Object)Identifier.IdentifierUse.USUAL);
                break;
            }
            case OFFICIAL: {
                tgt.setValue((Object)Identifier.IdentifierUse.OFFICIAL);
                break;
            }
            case TEMP: {
                tgt.setValue((Object)Identifier.IdentifierUse.TEMP);
                break;
            }
            case SECONDARY: {
                tgt.setValue((Object)Identifier.IdentifierUse.SECONDARY);
                break;
            }
            default: {
                tgt.setValue((Object)Identifier.IdentifierUse.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Enumeration<Identifier.IdentifierUse> convertIdentifierUse(Enumeration<Identifier.IdentifierUse> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Enumeration<Identifier.IdentifierUse> tgt = new org.hl7.fhir.dstu2016may.model.Enumeration<Identifier.IdentifierUse>(new Identifier.IdentifierUseEnumFactory());
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        switch ((Identifier.IdentifierUse)((Object)src.getValue())) {
            case USUAL: {
                tgt.setValue((Object)Identifier.IdentifierUse.USUAL);
                break;
            }
            case OFFICIAL: {
                tgt.setValue((Object)Identifier.IdentifierUse.OFFICIAL);
                break;
            }
            case TEMP: {
                tgt.setValue((Object)Identifier.IdentifierUse.TEMP);
                break;
            }
            case SECONDARY: {
                tgt.setValue((Object)Identifier.IdentifierUse.SECONDARY);
                break;
            }
            default: {
                tgt.setValue((Object)Identifier.IdentifierUse.NULL);
            }
        }
        return tgt;
    }

    public static Period convertPeriod(org.hl7.fhir.dstu2016may.model.Period src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Period tgt = new Period();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasStart()) {
            tgt.setStartElement(VersionConvertor_14_30.convertDateTime(src.getStartElement()));
        }
        if (src.hasEnd()) {
            tgt.setEndElement(VersionConvertor_14_30.convertDateTime(src.getEndElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Period convertPeriod(Period src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Period tgt = new org.hl7.fhir.dstu2016may.model.Period();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasStart()) {
            tgt.setStartElement(VersionConvertor_14_30.convertDateTime(src.getStartElement()));
        }
        if (src.hasEnd()) {
            tgt.setEndElement(VersionConvertor_14_30.convertDateTime(src.getEndElement()));
        }
        return tgt;
    }

    public static Quantity convertQuantity(org.hl7.fhir.dstu2016may.model.Quantity src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Quantity tgt = new Quantity();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_14_30.convertDecimal(src.getValueElement()));
        }
        if (src.hasComparator()) {
            tgt.setComparatorElement(VersionConvertor_14_30.convertQuantityComparator(src.getComparatorElement()));
        }
        if (src.hasUnit()) {
            tgt.setUnitElement(VersionConvertor_14_30.convertString(src.getUnitElement()));
        }
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_14_30.convertUri(src.getSystemElement()));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_14_30.convertCode(src.getCodeElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Quantity convertQuantity(Quantity src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Quantity tgt = new org.hl7.fhir.dstu2016may.model.Quantity();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_14_30.convertDecimal(src.getValueElement()));
        }
        if (src.hasComparator()) {
            tgt.setComparatorElement(VersionConvertor_14_30.convertQuantityComparator(src.getComparatorElement()));
        }
        if (src.hasUnit()) {
            tgt.setUnitElement(VersionConvertor_14_30.convertString(src.getUnitElement()));
        }
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_14_30.convertUri(src.getSystemElement()));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_14_30.convertCode(src.getCodeElement()));
        }
        return tgt;
    }

    public static Enumeration<Quantity.QuantityComparator> convertQuantityComparator(org.hl7.fhir.dstu2016may.model.Enumeration<Quantity.QuantityComparator> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Quantity.QuantityComparator> tgt = new Enumeration<Quantity.QuantityComparator>(new Quantity.QuantityComparatorEnumFactory());
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        switch ((Quantity.QuantityComparator)((Object)src.getValue())) {
            case LESS_THAN: {
                tgt.setValue((Object)Quantity.QuantityComparator.LESS_THAN);
                break;
            }
            case LESS_OR_EQUAL: {
                tgt.setValue((Object)Quantity.QuantityComparator.LESS_OR_EQUAL);
                break;
            }
            case GREATER_OR_EQUAL: {
                tgt.setValue((Object)Quantity.QuantityComparator.GREATER_OR_EQUAL);
                break;
            }
            case GREATER_THAN: {
                tgt.setValue((Object)Quantity.QuantityComparator.GREATER_THAN);
                break;
            }
            default: {
                tgt.setValue((Object)Quantity.QuantityComparator.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Enumeration<Quantity.QuantityComparator> convertQuantityComparator(Enumeration<Quantity.QuantityComparator> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Enumeration<Quantity.QuantityComparator> tgt = new org.hl7.fhir.dstu2016may.model.Enumeration<Quantity.QuantityComparator>(new Quantity.QuantityComparatorEnumFactory());
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        switch ((Quantity.QuantityComparator)((Object)src.getValue())) {
            case LESS_THAN: {
                tgt.setValue((Object)Quantity.QuantityComparator.LESS_THAN);
                break;
            }
            case LESS_OR_EQUAL: {
                tgt.setValue((Object)Quantity.QuantityComparator.LESS_OR_EQUAL);
                break;
            }
            case GREATER_OR_EQUAL: {
                tgt.setValue((Object)Quantity.QuantityComparator.GREATER_OR_EQUAL);
                break;
            }
            case GREATER_THAN: {
                tgt.setValue((Object)Quantity.QuantityComparator.GREATER_THAN);
                break;
            }
            default: {
                tgt.setValue((Object)Quantity.QuantityComparator.NULL);
            }
        }
        return tgt;
    }

    public static Range convertRange(org.hl7.fhir.dstu2016may.model.Range src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Range tgt = new Range();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasLow()) {
            tgt.setLow(VersionConvertor_14_30.convertSimpleQuantity(src.getLow()));
        }
        if (src.hasHigh()) {
            tgt.setHigh(VersionConvertor_14_30.convertSimpleQuantity(src.getHigh()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Range convertRange(Range src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Range tgt = new org.hl7.fhir.dstu2016may.model.Range();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasLow()) {
            tgt.setLow(VersionConvertor_14_30.convertSimpleQuantity(src.getLow()));
        }
        if (src.hasHigh()) {
            tgt.setHigh(VersionConvertor_14_30.convertSimpleQuantity(src.getHigh()));
        }
        return tgt;
    }

    public static Ratio convertRatio(org.hl7.fhir.dstu2016may.model.Ratio src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Ratio tgt = new Ratio();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasNumerator()) {
            tgt.setNumerator(VersionConvertor_14_30.convertQuantity(src.getNumerator()));
        }
        if (src.hasDenominator()) {
            tgt.setDenominator(VersionConvertor_14_30.convertQuantity(src.getDenominator()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Ratio convertRatio(Ratio src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Ratio tgt = new org.hl7.fhir.dstu2016may.model.Ratio();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasNumerator()) {
            tgt.setNumerator(VersionConvertor_14_30.convertQuantity(src.getNumerator()));
        }
        if (src.hasDenominator()) {
            tgt.setDenominator(VersionConvertor_14_30.convertQuantity(src.getDenominator()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Reference convertReference(Reference src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Reference tgt = new org.hl7.fhir.dstu3.model.Reference();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasReference()) {
            tgt.setReference(src.getReference());
        }
        if (src.hasDisplay()) {
            tgt.setDisplayElement(VersionConvertor_14_30.convertString(src.getDisplayElement()));
        }
        return tgt;
    }

    public static Reference convertReference(org.hl7.fhir.dstu3.model.Reference src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Reference tgt = new Reference();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasReference()) {
            tgt.setReference(src.getReference());
        }
        if (src.hasDisplay()) {
            tgt.setDisplayElement(VersionConvertor_14_30.convertString(src.getDisplayElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.SampledData convertSampledData(SampledData src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.SampledData tgt = new org.hl7.fhir.dstu3.model.SampledData();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasOrigin()) {
            tgt.setOrigin(VersionConvertor_14_30.convertSimpleQuantity(src.getOrigin()));
        }
        if (src.hasPeriodElement()) {
            tgt.setPeriodElement(VersionConvertor_14_30.convertDecimal(src.getPeriodElement()));
        }
        if (src.hasFactor()) {
            tgt.setFactorElement(VersionConvertor_14_30.convertDecimal(src.getFactorElement()));
        }
        if (src.hasLowerLimit()) {
            tgt.setLowerLimitElement(VersionConvertor_14_30.convertDecimal(src.getLowerLimitElement()));
        }
        if (src.hasUpperLimit()) {
            tgt.setUpperLimitElement(VersionConvertor_14_30.convertDecimal(src.getUpperLimitElement()));
        }
        if (src.hasDimensionsElement()) {
            tgt.setDimensionsElement(VersionConvertor_14_30.convertPositiveInt(src.getDimensionsElement()));
        }
        if (src.hasDataElement()) {
            tgt.setDataElement(VersionConvertor_14_30.convertString(src.getDataElement()));
        }
        return tgt;
    }

    public static SampledData convertSampledData(org.hl7.fhir.dstu3.model.SampledData src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        SampledData tgt = new SampledData();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasOrigin()) {
            tgt.setOrigin(VersionConvertor_14_30.convertSimpleQuantity(src.getOrigin()));
        }
        if (src.hasPeriodElement()) {
            tgt.setPeriodElement(VersionConvertor_14_30.convertDecimal(src.getPeriodElement()));
        }
        if (src.hasFactor()) {
            tgt.setFactorElement(VersionConvertor_14_30.convertDecimal(src.getFactorElement()));
        }
        if (src.hasLowerLimit()) {
            tgt.setLowerLimitElement(VersionConvertor_14_30.convertDecimal(src.getLowerLimitElement()));
        }
        if (src.hasUpperLimit()) {
            tgt.setUpperLimitElement(VersionConvertor_14_30.convertDecimal(src.getUpperLimitElement()));
        }
        if (src.hasDimensionsElement()) {
            tgt.setDimensionsElement(VersionConvertor_14_30.convertPositiveInt(src.getDimensionsElement()));
        }
        if (src.hasDataElement()) {
            tgt.setDataElement(VersionConvertor_14_30.convertString(src.getDataElement()));
        }
        return tgt;
    }

    public static Signature convertSignature(org.hl7.fhir.dstu2016may.model.Signature src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Signature tgt = new Signature();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        for (org.hl7.fhir.dstu2016may.model.Coding t : src.getType()) {
            tgt.addType(VersionConvertor_14_30.convertCoding(t));
        }
        if (src.hasWhenElement()) {
            tgt.setWhenElement(VersionConvertor_14_30.convertInstant(src.getWhenElement()));
        }
        if (src.hasWho()) {
            tgt.setWho(VersionConvertor_14_30.convertType(src.getWho()));
        }
        if (src.hasContentType()) {
            tgt.setContentTypeElement(VersionConvertor_14_30.convertCode(src.getContentTypeElement()));
        }
        if (src.hasBlob()) {
            tgt.setBlobElement(VersionConvertor_14_30.convertBase64Binary(src.getBlobElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Signature convertSignature(Signature src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Signature tgt = new org.hl7.fhir.dstu2016may.model.Signature();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        for (Coding t : src.getType()) {
            tgt.addType(VersionConvertor_14_30.convertCoding(t));
        }
        if (src.hasWhenElement()) {
            tgt.setWhenElement(VersionConvertor_14_30.convertInstant(src.getWhenElement()));
        }
        if (src.hasWho()) {
            tgt.setWho(VersionConvertor_14_30.convertType(src.getWho()));
        }
        if (src.hasContentType()) {
            tgt.setContentTypeElement(VersionConvertor_14_30.convertCode(src.getContentTypeElement()));
        }
        if (src.hasBlob()) {
            tgt.setBlobElement(VersionConvertor_14_30.convertBase64Binary(src.getBlobElement()));
        }
        return tgt;
    }

    public static Address convertAddress(org.hl7.fhir.dstu2016may.model.Address src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Address tgt = new Address();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasUse()) {
            tgt.setUseElement(VersionConvertor_14_30.convertAddressUse(src.getUseElement()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(VersionConvertor_14_30.convertAddressType(src.getTypeElement()));
        }
        if (src.hasText()) {
            tgt.setTextElement(VersionConvertor_14_30.convertString(src.getTextElement()));
        }
        for (StringType t : src.getLine()) {
            tgt.addLine((String)t.getValue());
        }
        if (src.hasCity()) {
            tgt.setCityElement(VersionConvertor_14_30.convertString(src.getCityElement()));
        }
        if (src.hasDistrict()) {
            tgt.setDistrictElement(VersionConvertor_14_30.convertString(src.getDistrictElement()));
        }
        if (src.hasState()) {
            tgt.setStateElement(VersionConvertor_14_30.convertString(src.getStateElement()));
        }
        if (src.hasPostalCode()) {
            tgt.setPostalCodeElement(VersionConvertor_14_30.convertString(src.getPostalCodeElement()));
        }
        if (src.hasCountry()) {
            tgt.setCountryElement(VersionConvertor_14_30.convertString(src.getCountryElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_14_30.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Address convertAddress(Address src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Address tgt = new org.hl7.fhir.dstu2016may.model.Address();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasUse()) {
            tgt.setUseElement(VersionConvertor_14_30.convertAddressUse(src.getUseElement()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(VersionConvertor_14_30.convertAddressType(src.getTypeElement()));
        }
        if (src.hasText()) {
            tgt.setTextElement(VersionConvertor_14_30.convertString(src.getTextElement()));
        }
        for (org.hl7.fhir.dstu3.model.StringType t : src.getLine()) {
            tgt.addLine((String)t.getValue());
        }
        if (src.hasCity()) {
            tgt.setCityElement(VersionConvertor_14_30.convertString(src.getCityElement()));
        }
        if (src.hasDistrict()) {
            tgt.setDistrictElement(VersionConvertor_14_30.convertString(src.getDistrictElement()));
        }
        if (src.hasState()) {
            tgt.setStateElement(VersionConvertor_14_30.convertString(src.getStateElement()));
        }
        if (src.hasPostalCode()) {
            tgt.setPostalCodeElement(VersionConvertor_14_30.convertString(src.getPostalCodeElement()));
        }
        if (src.hasCountry()) {
            tgt.setCountryElement(VersionConvertor_14_30.convertString(src.getCountryElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_14_30.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static Enumeration<Address.AddressUse> convertAddressUse(org.hl7.fhir.dstu2016may.model.Enumeration<Address.AddressUse> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Address.AddressUse> tgt = new Enumeration<Address.AddressUse>(new Address.AddressUseEnumFactory());
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        switch ((Address.AddressUse)((Object)src.getValue())) {
            case HOME: {
                tgt.setValue((Object)Address.AddressUse.HOME);
                break;
            }
            case WORK: {
                tgt.setValue((Object)Address.AddressUse.WORK);
                break;
            }
            case TEMP: {
                tgt.setValue((Object)Address.AddressUse.TEMP);
                break;
            }
            case OLD: {
                tgt.setValue((Object)Address.AddressUse.OLD);
                break;
            }
            default: {
                tgt.setValue((Object)Address.AddressUse.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Enumeration<Address.AddressUse> convertAddressUse(Enumeration<Address.AddressUse> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Enumeration<Address.AddressUse> tgt = new org.hl7.fhir.dstu2016may.model.Enumeration<Address.AddressUse>(new Address.AddressUseEnumFactory());
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        switch ((Address.AddressUse)((Object)src.getValue())) {
            case HOME: {
                tgt.setValue((Object)Address.AddressUse.HOME);
                break;
            }
            case WORK: {
                tgt.setValue((Object)Address.AddressUse.WORK);
                break;
            }
            case TEMP: {
                tgt.setValue((Object)Address.AddressUse.TEMP);
                break;
            }
            case OLD: {
                tgt.setValue((Object)Address.AddressUse.OLD);
                break;
            }
            default: {
                tgt.setValue((Object)Address.AddressUse.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Address.AddressType> convertAddressType(org.hl7.fhir.dstu2016may.model.Enumeration<Address.AddressType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Address.AddressType> tgt = new Enumeration<Address.AddressType>(new Address.AddressTypeEnumFactory());
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        switch ((Address.AddressType)((Object)src.getValue())) {
            case POSTAL: {
                tgt.setValue((Object)Address.AddressType.POSTAL);
                break;
            }
            case PHYSICAL: {
                tgt.setValue((Object)Address.AddressType.PHYSICAL);
                break;
            }
            case BOTH: {
                tgt.setValue((Object)Address.AddressType.BOTH);
                break;
            }
            default: {
                tgt.setValue((Object)Address.AddressType.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Enumeration<Address.AddressType> convertAddressType(Enumeration<Address.AddressType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Enumeration<Address.AddressType> tgt = new org.hl7.fhir.dstu2016may.model.Enumeration<Address.AddressType>(new Address.AddressTypeEnumFactory());
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        switch ((Address.AddressType)((Object)src.getValue())) {
            case POSTAL: {
                tgt.setValue((Object)Address.AddressType.POSTAL);
                break;
            }
            case PHYSICAL: {
                tgt.setValue((Object)Address.AddressType.PHYSICAL);
                break;
            }
            case BOTH: {
                tgt.setValue((Object)Address.AddressType.BOTH);
                break;
            }
            default: {
                tgt.setValue((Object)Address.AddressType.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.ContactPoint convertContactPoint(ContactPoint src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.ContactPoint tgt = new org.hl7.fhir.dstu3.model.ContactPoint();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_14_30.convertContactPointSystem(src.getSystemElement()));
        }
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_14_30.convertString(src.getValueElement()));
        }
        if (src.hasUse()) {
            tgt.setUseElement(VersionConvertor_14_30.convertContactPointUse(src.getUseElement()));
        }
        if (src.hasRank()) {
            tgt.setRankElement(VersionConvertor_14_30.convertPositiveInt(src.getRankElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_14_30.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static ContactPoint convertContactPoint(org.hl7.fhir.dstu3.model.ContactPoint src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ContactPoint tgt = new ContactPoint();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_14_30.convertContactPointSystem(src.getSystemElement()));
        }
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_14_30.convertString(src.getValueElement()));
        }
        if (src.hasUse()) {
            tgt.setUseElement(VersionConvertor_14_30.convertContactPointUse(src.getUseElement()));
        }
        if (src.hasRank()) {
            tgt.setRankElement(VersionConvertor_14_30.convertPositiveInt(src.getRankElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_14_30.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static Enumeration<ContactPoint.ContactPointSystem> convertContactPointSystem(org.hl7.fhir.dstu2016may.model.Enumeration<ContactPoint.ContactPointSystem> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ContactPoint.ContactPointSystem> tgt = new Enumeration<ContactPoint.ContactPointSystem>(new ContactPoint.ContactPointSystemEnumFactory());
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        switch ((ContactPoint.ContactPointSystem)((Object)src.getValue())) {
            case PHONE: {
                tgt.setValue((Object)ContactPoint.ContactPointSystem.PHONE);
                break;
            }
            case FAX: {
                tgt.setValue((Object)ContactPoint.ContactPointSystem.FAX);
                break;
            }
            case EMAIL: {
                tgt.setValue((Object)ContactPoint.ContactPointSystem.EMAIL);
                break;
            }
            case PAGER: {
                tgt.setValue((Object)ContactPoint.ContactPointSystem.PAGER);
                break;
            }
            case OTHER: {
                tgt.setValue((Object)ContactPoint.ContactPointSystem.URL);
                break;
            }
            default: {
                tgt.setValue((Object)ContactPoint.ContactPointSystem.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Enumeration<ContactPoint.ContactPointSystem> convertContactPointSystem(Enumeration<ContactPoint.ContactPointSystem> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Enumeration<ContactPoint.ContactPointSystem> tgt = new org.hl7.fhir.dstu2016may.model.Enumeration<ContactPoint.ContactPointSystem>(new ContactPoint.ContactPointSystemEnumFactory());
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        switch ((ContactPoint.ContactPointSystem)((Object)src.getValue())) {
            case PHONE: {
                tgt.setValue((Object)ContactPoint.ContactPointSystem.PHONE);
                break;
            }
            case FAX: {
                tgt.setValue((Object)ContactPoint.ContactPointSystem.FAX);
                break;
            }
            case EMAIL: {
                tgt.setValue((Object)ContactPoint.ContactPointSystem.EMAIL);
                break;
            }
            case PAGER: {
                tgt.setValue((Object)ContactPoint.ContactPointSystem.PAGER);
                break;
            }
            case URL: {
                tgt.setValue((Object)ContactPoint.ContactPointSystem.OTHER);
                break;
            }
            default: {
                tgt.setValue((Object)ContactPoint.ContactPointSystem.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<ContactPoint.ContactPointUse> convertContactPointUse(org.hl7.fhir.dstu2016may.model.Enumeration<ContactPoint.ContactPointUse> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ContactPoint.ContactPointUse> tgt = new Enumeration<ContactPoint.ContactPointUse>(new ContactPoint.ContactPointUseEnumFactory());
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        switch ((ContactPoint.ContactPointUse)((Object)src.getValue())) {
            case HOME: {
                tgt.setValue((Object)ContactPoint.ContactPointUse.HOME);
                break;
            }
            case WORK: {
                tgt.setValue((Object)ContactPoint.ContactPointUse.WORK);
                break;
            }
            case TEMP: {
                tgt.setValue((Object)ContactPoint.ContactPointUse.TEMP);
                break;
            }
            case OLD: {
                tgt.setValue((Object)ContactPoint.ContactPointUse.OLD);
                break;
            }
            case MOBILE: {
                tgt.setValue((Object)ContactPoint.ContactPointUse.MOBILE);
                break;
            }
            default: {
                tgt.setValue((Object)ContactPoint.ContactPointUse.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Enumeration<ContactPoint.ContactPointUse> convertContactPointUse(Enumeration<ContactPoint.ContactPointUse> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Enumeration<ContactPoint.ContactPointUse> tgt = new org.hl7.fhir.dstu2016may.model.Enumeration<ContactPoint.ContactPointUse>(new ContactPoint.ContactPointUseEnumFactory());
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        switch ((ContactPoint.ContactPointUse)((Object)src.getValue())) {
            case HOME: {
                tgt.setValue((Object)ContactPoint.ContactPointUse.HOME);
                break;
            }
            case WORK: {
                tgt.setValue((Object)ContactPoint.ContactPointUse.WORK);
                break;
            }
            case TEMP: {
                tgt.setValue((Object)ContactPoint.ContactPointUse.TEMP);
                break;
            }
            case OLD: {
                tgt.setValue((Object)ContactPoint.ContactPointUse.OLD);
                break;
            }
            case MOBILE: {
                tgt.setValue((Object)ContactPoint.ContactPointUse.MOBILE);
                break;
            }
            default: {
                tgt.setValue((Object)ContactPoint.ContactPointUse.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.ElementDefinition convertElementDefinition(ElementDefinition src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.ElementDefinition tgt = new org.hl7.fhir.dstu3.model.ElementDefinition();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasPathElement()) {
            tgt.setPathElement(VersionConvertor_14_30.convertString(src.getPathElement()));
        }
        tgt.setRepresentation(src.getRepresentation().stream().map(VersionConvertor_14_30::convertPropertyRepresentation).collect(Collectors.toList()));
        if (src.hasName()) {
            tgt.setSliceNameElement(VersionConvertor_14_30.convertString(src.getNameElement()));
        }
        if (src.hasLabel()) {
            tgt.setLabelElement(VersionConvertor_14_30.convertString(src.getLabelElement()));
        }
        for (org.hl7.fhir.dstu2016may.model.Coding coding : src.getCode()) {
            tgt.addCode(VersionConvertor_14_30.convertCoding(coding));
        }
        if (src.hasSlicing()) {
            tgt.setSlicing(VersionConvertor_14_30.convertElementDefinitionSlicingComponent(src.getSlicing()));
        }
        if (src.hasShort()) {
            tgt.setShortElement(VersionConvertor_14_30.convertString(src.getShortElement()));
        }
        if (src.hasDefinition()) {
            tgt.setDefinitionElement(VersionConvertor_14_30.convertMarkdown(src.getDefinitionElement()));
        }
        if (src.hasComments()) {
            tgt.setCommentElement(VersionConvertor_14_30.convertMarkdown(src.getCommentsElement()));
        }
        if (src.hasRequirements()) {
            tgt.setRequirementsElement(VersionConvertor_14_30.convertMarkdown(src.getRequirementsElement()));
        }
        for (StringType stringType : src.getAlias()) {
            tgt.addAlias((String)stringType.getValue());
        }
        if (src.hasMin()) {
            tgt.setMin(src.getMin());
        }
        if (src.hasMax()) {
            tgt.setMaxElement(VersionConvertor_14_30.convertString(src.getMaxElement()));
        }
        if (src.hasBase()) {
            tgt.setBase(VersionConvertor_14_30.convertElementDefinitionBaseComponent(src.getBase()));
        }
        if (src.hasContentReference()) {
            tgt.setContentReferenceElement(VersionConvertor_14_30.convertUri(src.getContentReferenceElement()));
        }
        for (ElementDefinition.TypeRefComponent typeRefComponent : src.getType()) {
            tgt.addType(VersionConvertor_14_30.convertTypeRefComponent(typeRefComponent));
        }
        if (src.hasDefaultValue()) {
            tgt.setDefaultValue(VersionConvertor_14_30.convertType(src.getDefaultValue()));
        }
        if (src.hasMeaningWhenMissing()) {
            tgt.setMeaningWhenMissingElement(VersionConvertor_14_30.convertMarkdown(src.getMeaningWhenMissingElement()));
        }
        if (src.hasFixed()) {
            tgt.setFixed(VersionConvertor_14_30.convertType(src.getFixed()));
        }
        if (src.hasPattern()) {
            tgt.setPattern(VersionConvertor_14_30.convertType(src.getPattern()));
        }
        if (src.hasExample()) {
            tgt.addExample().setLabel("General").setValue(VersionConvertor_14_30.convertType(src.getExample()));
        }
        if (src.hasMinValue()) {
            tgt.setMinValue(VersionConvertor_14_30.convertType(src.getMinValue()));
        }
        if (src.hasMaxValue()) {
            tgt.setMaxValue(VersionConvertor_14_30.convertType(src.getMaxValue()));
        }
        if (src.hasMaxLength()) {
            tgt.setMaxLengthElement(VersionConvertor_14_30.convertInteger(src.getMaxLengthElement()));
        }
        for (org.hl7.fhir.dstu2016may.model.IdType idType : src.getCondition()) {
            tgt.addCondition(idType.getValue());
        }
        for (ElementDefinition.ElementDefinitionConstraintComponent elementDefinitionConstraintComponent : src.getConstraint()) {
            tgt.addConstraint(VersionConvertor_14_30.convertElementDefinitionConstraintComponent(elementDefinitionConstraintComponent));
        }
        if (src.hasMustSupport()) {
            tgt.setMustSupportElement(VersionConvertor_14_30.convertBoolean(src.getMustSupportElement()));
        }
        if (src.hasIsModifier()) {
            tgt.setIsModifierElement(VersionConvertor_14_30.convertBoolean(src.getIsModifierElement()));
        }
        if (src.hasIsSummary()) {
            tgt.setIsSummaryElement(VersionConvertor_14_30.convertBoolean(src.getIsSummaryElement()));
        }
        if (src.hasBinding()) {
            tgt.setBinding(VersionConvertor_14_30.convertElementDefinitionBindingComponent(src.getBinding()));
        }
        for (ElementDefinition.ElementDefinitionMappingComponent elementDefinitionMappingComponent : src.getMapping()) {
            tgt.addMapping(VersionConvertor_14_30.convertElementDefinitionMappingComponent(elementDefinitionMappingComponent));
        }
        return tgt;
    }

    public static ElementDefinition convertElementDefinition(org.hl7.fhir.dstu3.model.ElementDefinition src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ElementDefinition tgt = new ElementDefinition();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasPathElement()) {
            tgt.setPathElement(VersionConvertor_14_30.convertString(src.getPathElement()));
        }
        tgt.setRepresentation(src.getRepresentation().stream().map(VersionConvertor_14_30::convertPropertyRepresentation).collect(Collectors.toList()));
        if (src.hasSliceName()) {
            tgt.setNameElement(VersionConvertor_14_30.convertString(src.getSliceNameElement()));
        }
        if (src.hasLabel()) {
            tgt.setLabelElement(VersionConvertor_14_30.convertString(src.getLabelElement()));
        }
        for (Coding coding : src.getCode()) {
            tgt.addCode(VersionConvertor_14_30.convertCoding(coding));
        }
        if (src.hasSlicing()) {
            tgt.setSlicing(VersionConvertor_14_30.convertElementDefinitionSlicingComponent(src.getSlicing()));
        }
        if (src.hasShort()) {
            tgt.setShortElement(VersionConvertor_14_30.convertString(src.getShortElement()));
        }
        if (src.hasDefinition()) {
            tgt.setDefinitionElement(VersionConvertor_14_30.convertMarkdown(src.getDefinitionElement()));
        }
        if (src.hasComment()) {
            tgt.setCommentsElement(VersionConvertor_14_30.convertMarkdown(src.getCommentElement()));
        }
        if (src.hasRequirements()) {
            tgt.setRequirementsElement(VersionConvertor_14_30.convertMarkdown(src.getRequirementsElement()));
        }
        for (org.hl7.fhir.dstu3.model.StringType stringType : src.getAlias()) {
            tgt.addAlias((String)stringType.getValue());
        }
        if (src.hasMin()) {
            tgt.setMin(src.getMin());
        }
        if (src.hasMax()) {
            tgt.setMaxElement(VersionConvertor_14_30.convertString(src.getMaxElement()));
        }
        if (src.hasBase()) {
            tgt.setBase(VersionConvertor_14_30.convertElementDefinitionBaseComponent(src.getBase()));
        }
        if (src.hasContentReference()) {
            tgt.setContentReferenceElement(VersionConvertor_14_30.convertUri(src.getContentReferenceElement()));
        }
        for (ElementDefinition.TypeRefComponent typeRefComponent : src.getType()) {
            tgt.addType(VersionConvertor_14_30.convertTypeRefComponent(typeRefComponent));
        }
        if (src.hasDefaultValue()) {
            tgt.setDefaultValue(VersionConvertor_14_30.convertType(src.getDefaultValue()));
        }
        if (src.hasMeaningWhenMissing()) {
            tgt.setMeaningWhenMissingElement(VersionConvertor_14_30.convertMarkdown(src.getMeaningWhenMissingElement()));
        }
        if (src.hasFixed()) {
            tgt.setFixed(VersionConvertor_14_30.convertType(src.getFixed()));
        }
        if (src.hasPattern()) {
            tgt.setPattern(VersionConvertor_14_30.convertType(src.getPattern()));
        }
        if (src.hasExample()) {
            tgt.setExample(VersionConvertor_14_30.convertType(src.getExample().get(0).getValue()));
        }
        if (src.hasMinValue()) {
            tgt.setMinValue(VersionConvertor_14_30.convertType(src.getMinValue()));
        }
        if (src.hasMaxValue()) {
            tgt.setMaxValue(VersionConvertor_14_30.convertType(src.getMaxValue()));
        }
        if (src.hasMaxLength()) {
            tgt.setMaxLengthElement(VersionConvertor_14_30.convertInteger(src.getMaxLengthElement()));
        }
        for (IdType idType : src.getCondition()) {
            tgt.addCondition(idType.getValue());
        }
        for (ElementDefinition.ElementDefinitionConstraintComponent elementDefinitionConstraintComponent : src.getConstraint()) {
            tgt.addConstraint(VersionConvertor_14_30.convertElementDefinitionConstraintComponent(elementDefinitionConstraintComponent));
        }
        if (src.hasMustSupport()) {
            tgt.setMustSupportElement(VersionConvertor_14_30.convertBoolean(src.getMustSupportElement()));
        }
        if (src.hasIsModifier()) {
            tgt.setIsModifierElement(VersionConvertor_14_30.convertBoolean(src.getIsModifierElement()));
        }
        if (src.hasIsSummary()) {
            tgt.setIsSummaryElement(VersionConvertor_14_30.convertBoolean(src.getIsSummaryElement()));
        }
        if (src.hasBinding()) {
            tgt.setBinding(VersionConvertor_14_30.convertElementDefinitionBindingComponent(src.getBinding()));
        }
        for (ElementDefinition.ElementDefinitionMappingComponent elementDefinitionMappingComponent : src.getMapping()) {
            tgt.addMapping(VersionConvertor_14_30.convertElementDefinitionMappingComponent(elementDefinitionMappingComponent));
        }
        return tgt;
    }

    public static Enumeration<ElementDefinition.PropertyRepresentation> convertPropertyRepresentation(org.hl7.fhir.dstu2016may.model.Enumeration<ElementDefinition.PropertyRepresentation> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ElementDefinition.PropertyRepresentation> tgt = new Enumeration<ElementDefinition.PropertyRepresentation>(new ElementDefinition.PropertyRepresentationEnumFactory());
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        switch ((ElementDefinition.PropertyRepresentation)((Object)src.getValue())) {
            case XMLATTR: {
                tgt.setValue((Object)ElementDefinition.PropertyRepresentation.XMLATTR);
                break;
            }
            case XMLTEXT: {
                tgt.setValue((Object)ElementDefinition.PropertyRepresentation.XMLTEXT);
                break;
            }
            case TYPEATTR: {
                tgt.setValue((Object)ElementDefinition.PropertyRepresentation.TYPEATTR);
                break;
            }
            case CDATEXT: {
                tgt.setValue((Object)ElementDefinition.PropertyRepresentation.CDATEXT);
                break;
            }
            default: {
                tgt.setValue((Object)ElementDefinition.PropertyRepresentation.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Enumeration<ElementDefinition.PropertyRepresentation> convertPropertyRepresentation(Enumeration<ElementDefinition.PropertyRepresentation> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Enumeration<ElementDefinition.PropertyRepresentation> tgt = new org.hl7.fhir.dstu2016may.model.Enumeration<ElementDefinition.PropertyRepresentation>(new ElementDefinition.PropertyRepresentationEnumFactory());
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        switch ((ElementDefinition.PropertyRepresentation)((Object)src.getValue())) {
            case XMLATTR: {
                tgt.setValue((Object)ElementDefinition.PropertyRepresentation.XMLATTR);
                break;
            }
            case XMLTEXT: {
                tgt.setValue((Object)ElementDefinition.PropertyRepresentation.XMLTEXT);
                break;
            }
            case TYPEATTR: {
                tgt.setValue((Object)ElementDefinition.PropertyRepresentation.TYPEATTR);
                break;
            }
            case CDATEXT: {
                tgt.setValue((Object)ElementDefinition.PropertyRepresentation.CDATEXT);
                break;
            }
            default: {
                tgt.setValue((Object)ElementDefinition.PropertyRepresentation.NULL);
            }
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionSlicingComponent convertElementDefinitionSlicingComponent(ElementDefinition.ElementDefinitionSlicingComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ElementDefinition.ElementDefinitionSlicingComponent tgt = new ElementDefinition.ElementDefinitionSlicingComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        for (StringType t : src.getDiscriminator()) {
            tgt.addDiscriminator(ProfileUtilities.interpretR2Discriminator((String)t.getValue()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_14_30.convertString(src.getDescriptionElement()));
        }
        if (src.hasOrdered()) {
            tgt.setOrderedElement(VersionConvertor_14_30.convertBoolean(src.getOrderedElement()));
        }
        if (src.hasRules()) {
            tgt.setRulesElement(VersionConvertor_14_30.convertSlicingRules(src.getRulesElement()));
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionSlicingComponent convertElementDefinitionSlicingComponent(ElementDefinition.ElementDefinitionSlicingComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ElementDefinition.ElementDefinitionSlicingComponent tgt = new ElementDefinition.ElementDefinitionSlicingComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        for (ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent t : src.getDiscriminator()) {
            tgt.addDiscriminator(ProfileUtilities.buildR2Discriminator(t));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_14_30.convertString(src.getDescriptionElement()));
        }
        if (src.hasOrdered()) {
            tgt.setOrderedElement(VersionConvertor_14_30.convertBoolean(src.getOrderedElement()));
        }
        if (src.hasRules()) {
            tgt.setRulesElement(VersionConvertor_14_30.convertSlicingRules(src.getRulesElement()));
        }
        return tgt;
    }

    public static Enumeration<ElementDefinition.SlicingRules> convertSlicingRules(org.hl7.fhir.dstu2016may.model.Enumeration<ElementDefinition.SlicingRules> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ElementDefinition.SlicingRules> tgt = new Enumeration<ElementDefinition.SlicingRules>(new ElementDefinition.SlicingRulesEnumFactory());
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        switch ((ElementDefinition.SlicingRules)((Object)src.getValue())) {
            case CLOSED: {
                tgt.setValue((Object)ElementDefinition.SlicingRules.CLOSED);
                break;
            }
            case OPEN: {
                tgt.setValue((Object)ElementDefinition.SlicingRules.OPEN);
                break;
            }
            case OPENATEND: {
                tgt.setValue((Object)ElementDefinition.SlicingRules.OPENATEND);
                break;
            }
            default: {
                tgt.setValue((Object)ElementDefinition.SlicingRules.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Enumeration<ElementDefinition.SlicingRules> convertSlicingRules(Enumeration<ElementDefinition.SlicingRules> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Enumeration<ElementDefinition.SlicingRules> tgt = new org.hl7.fhir.dstu2016may.model.Enumeration<ElementDefinition.SlicingRules>(new ElementDefinition.SlicingRulesEnumFactory());
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        switch ((ElementDefinition.SlicingRules)((Object)src.getValue())) {
            case CLOSED: {
                tgt.setValue((Object)ElementDefinition.SlicingRules.CLOSED);
                break;
            }
            case OPEN: {
                tgt.setValue((Object)ElementDefinition.SlicingRules.OPEN);
                break;
            }
            case OPENATEND: {
                tgt.setValue((Object)ElementDefinition.SlicingRules.OPENATEND);
                break;
            }
            default: {
                tgt.setValue((Object)ElementDefinition.SlicingRules.NULL);
            }
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionBaseComponent convertElementDefinitionBaseComponent(ElementDefinition.ElementDefinitionBaseComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ElementDefinition.ElementDefinitionBaseComponent tgt = new ElementDefinition.ElementDefinitionBaseComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasPathElement()) {
            tgt.setPathElement(VersionConvertor_14_30.convertString(src.getPathElement()));
        }
        tgt.setMin(src.getMin());
        if (src.hasMaxElement()) {
            tgt.setMaxElement(VersionConvertor_14_30.convertString(src.getMaxElement()));
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionBaseComponent convertElementDefinitionBaseComponent(ElementDefinition.ElementDefinitionBaseComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ElementDefinition.ElementDefinitionBaseComponent tgt = new ElementDefinition.ElementDefinitionBaseComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasPathElement()) {
            tgt.setPathElement(VersionConvertor_14_30.convertString(src.getPathElement()));
        }
        tgt.setMin(src.getMin());
        if (src.hasMaxElement()) {
            tgt.setMaxElement(VersionConvertor_14_30.convertString(src.getMaxElement()));
        }
        return tgt;
    }

    public static ElementDefinition.TypeRefComponent convertTypeRefComponent(ElementDefinition.TypeRefComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ElementDefinition.TypeRefComponent tgt = new ElementDefinition.TypeRefComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        tgt.setCode(src.getCode());
        for (org.hl7.fhir.dstu2016may.model.UriType u : src.getProfile()) {
            if (src.getCode().equals("Reference")) {
                tgt.setTargetProfile((String)u.getValue());
                continue;
            }
            tgt.setProfile((String)u.getValue());
        }
        for (Extension t : src.getExtensionsByUrl("http://hl7.org/fhir/4.0/StructureDefinition/extension-ElementDefinition.type.profile")) {
            String s2 = (String)((PrimitiveType)t.getValue()).getValue();
            tgt.setProfile(s2);
        }
        tgt.setAggregation(src.getAggregation().stream().map(VersionConvertor_14_30::convertAggregationMode).collect(Collectors.toList()));
        if (src.hasVersioning()) {
            tgt.setVersioningElement(VersionConvertor_14_30.convertReferenceVersionRules(src.getVersioningElement()));
        }
        return tgt;
    }

    public static ElementDefinition.TypeRefComponent convertTypeRefComponent(ElementDefinition.TypeRefComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ElementDefinition.TypeRefComponent tgt = new ElementDefinition.TypeRefComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        tgt.setCode(src.getCode());
        if (src.hasTarget()) {
            if (src.hasTargetProfile()) {
                tgt.addProfile(src.getTargetProfile());
            }
            if (src.hasProfile()) {
                if (src.getCode().equals("Reference")) {
                    Extension t = new Extension("http://hl7.org/fhir/4.0/StructureDefinition/extension-ElementDefinition.type.profile");
                    t.setValue(new StringType(src.getProfile()));
                    tgt.addExtension(t);
                } else {
                    tgt.addProfile(src.getProfile());
                }
            }
        } else {
            tgt.addProfile(src.getProfile());
        }
        tgt.setAggregation(src.getAggregation().stream().map(VersionConvertor_14_30::convertAggregationMode).collect(Collectors.toList()));
        if (src.hasVersioning()) {
            tgt.setVersioningElement(VersionConvertor_14_30.convertReferenceVersionRules(src.getVersioningElement()));
        }
        return tgt;
    }

    public static Enumeration<ElementDefinition.AggregationMode> convertAggregationMode(org.hl7.fhir.dstu2016may.model.Enumeration<ElementDefinition.AggregationMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ElementDefinition.AggregationMode> tgt = new Enumeration<ElementDefinition.AggregationMode>(new ElementDefinition.AggregationModeEnumFactory());
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        switch ((ElementDefinition.AggregationMode)((Object)src.getValue())) {
            case CONTAINED: {
                tgt.setValue((Object)ElementDefinition.AggregationMode.CONTAINED);
                break;
            }
            case REFERENCED: {
                tgt.setValue((Object)ElementDefinition.AggregationMode.REFERENCED);
                break;
            }
            case BUNDLED: {
                tgt.setValue((Object)ElementDefinition.AggregationMode.BUNDLED);
                break;
            }
            default: {
                tgt.setValue((Object)ElementDefinition.AggregationMode.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Enumeration<ElementDefinition.AggregationMode> convertAggregationMode(Enumeration<ElementDefinition.AggregationMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Enumeration<ElementDefinition.AggregationMode> tgt = new org.hl7.fhir.dstu2016may.model.Enumeration<ElementDefinition.AggregationMode>(new ElementDefinition.AggregationModeEnumFactory());
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        switch ((ElementDefinition.AggregationMode)((Object)src.getValue())) {
            case CONTAINED: {
                tgt.setValue((Object)ElementDefinition.AggregationMode.CONTAINED);
                break;
            }
            case REFERENCED: {
                tgt.setValue((Object)ElementDefinition.AggregationMode.REFERENCED);
                break;
            }
            case BUNDLED: {
                tgt.setValue((Object)ElementDefinition.AggregationMode.BUNDLED);
                break;
            }
            default: {
                tgt.setValue((Object)ElementDefinition.AggregationMode.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<ElementDefinition.ReferenceVersionRules> convertReferenceVersionRules(org.hl7.fhir.dstu2016may.model.Enumeration<ElementDefinition.ReferenceVersionRules> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ElementDefinition.ReferenceVersionRules> tgt = new Enumeration<ElementDefinition.ReferenceVersionRules>(new ElementDefinition.ReferenceVersionRulesEnumFactory());
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        switch ((ElementDefinition.ReferenceVersionRules)((Object)src.getValue())) {
            case EITHER: {
                tgt.setValue((Object)ElementDefinition.ReferenceVersionRules.EITHER);
                break;
            }
            case INDEPENDENT: {
                tgt.setValue((Object)ElementDefinition.ReferenceVersionRules.INDEPENDENT);
                break;
            }
            case SPECIFIC: {
                tgt.setValue((Object)ElementDefinition.ReferenceVersionRules.SPECIFIC);
                break;
            }
            default: {
                tgt.setValue((Object)ElementDefinition.ReferenceVersionRules.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Enumeration<ElementDefinition.ReferenceVersionRules> convertReferenceVersionRules(Enumeration<ElementDefinition.ReferenceVersionRules> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Enumeration<ElementDefinition.ReferenceVersionRules> tgt = new org.hl7.fhir.dstu2016may.model.Enumeration<ElementDefinition.ReferenceVersionRules>(new ElementDefinition.ReferenceVersionRulesEnumFactory());
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        switch ((ElementDefinition.ReferenceVersionRules)((Object)src.getValue())) {
            case EITHER: {
                tgt.setValue((Object)ElementDefinition.ReferenceVersionRules.EITHER);
                break;
            }
            case INDEPENDENT: {
                tgt.setValue((Object)ElementDefinition.ReferenceVersionRules.INDEPENDENT);
                break;
            }
            case SPECIFIC: {
                tgt.setValue((Object)ElementDefinition.ReferenceVersionRules.SPECIFIC);
                break;
            }
            default: {
                tgt.setValue((Object)ElementDefinition.ReferenceVersionRules.NULL);
            }
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionConstraintComponent convertElementDefinitionConstraintComponent(ElementDefinition.ElementDefinitionConstraintComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ElementDefinition.ElementDefinitionConstraintComponent tgt = new ElementDefinition.ElementDefinitionConstraintComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasKeyElement()) {
            tgt.setKeyElement(VersionConvertor_14_30.convertId(src.getKeyElement()));
        }
        if (src.hasRequirements()) {
            tgt.setRequirementsElement(VersionConvertor_14_30.convertString(src.getRequirementsElement()));
        }
        if (src.hasSeverity()) {
            tgt.setSeverityElement(VersionConvertor_14_30.convertConstraintSeverity(src.getSeverityElement()));
        }
        if (src.hasHumanElement()) {
            tgt.setHumanElement(VersionConvertor_14_30.convertString(src.getHumanElement()));
        }
        if (src.hasExpression()) {
            tgt.setExpressionElement(VersionConvertor_14_30.convertString(src.getExpressionElement()));
        }
        if (src.hasXpathElement()) {
            tgt.setXpathElement(VersionConvertor_14_30.convertString(src.getXpathElement()));
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionConstraintComponent convertElementDefinitionConstraintComponent(ElementDefinition.ElementDefinitionConstraintComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ElementDefinition.ElementDefinitionConstraintComponent tgt = new ElementDefinition.ElementDefinitionConstraintComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasKeyElement()) {
            tgt.setKeyElement(VersionConvertor_14_30.convertId(src.getKeyElement()));
        }
        if (src.hasRequirements()) {
            tgt.setRequirementsElement(VersionConvertor_14_30.convertString(src.getRequirementsElement()));
        }
        if (src.hasSeverity()) {
            tgt.setSeverityElement(VersionConvertor_14_30.convertConstraintSeverity(src.getSeverityElement()));
        }
        if (src.hasHumanElement()) {
            tgt.setHumanElement(VersionConvertor_14_30.convertString(src.getHumanElement()));
        }
        if (src.hasExpression()) {
            tgt.setExpressionElement(VersionConvertor_14_30.convertString(src.getExpressionElement()));
        }
        if (src.hasXpathElement()) {
            tgt.setXpathElement(VersionConvertor_14_30.convertString(src.getXpathElement()));
        }
        return tgt;
    }

    public static Enumeration<ElementDefinition.ConstraintSeverity> convertConstraintSeverity(org.hl7.fhir.dstu2016may.model.Enumeration<ElementDefinition.ConstraintSeverity> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ElementDefinition.ConstraintSeverity> tgt = new Enumeration<ElementDefinition.ConstraintSeverity>(new ElementDefinition.ConstraintSeverityEnumFactory());
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        switch ((ElementDefinition.ConstraintSeverity)((Object)src.getValue())) {
            case ERROR: {
                tgt.setValue((Object)ElementDefinition.ConstraintSeverity.ERROR);
                break;
            }
            case WARNING: {
                tgt.setValue((Object)ElementDefinition.ConstraintSeverity.WARNING);
                break;
            }
            default: {
                tgt.setValue((Object)ElementDefinition.ConstraintSeverity.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Enumeration<ElementDefinition.ConstraintSeverity> convertConstraintSeverity(Enumeration<ElementDefinition.ConstraintSeverity> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Enumeration<ElementDefinition.ConstraintSeverity> tgt = new org.hl7.fhir.dstu2016may.model.Enumeration<ElementDefinition.ConstraintSeverity>(new ElementDefinition.ConstraintSeverityEnumFactory());
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        switch ((ElementDefinition.ConstraintSeverity)((Object)src.getValue())) {
            case ERROR: {
                tgt.setValue((Object)ElementDefinition.ConstraintSeverity.ERROR);
                break;
            }
            case WARNING: {
                tgt.setValue((Object)ElementDefinition.ConstraintSeverity.WARNING);
                break;
            }
            default: {
                tgt.setValue((Object)ElementDefinition.ConstraintSeverity.NULL);
            }
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionBindingComponent convertElementDefinitionBindingComponent(ElementDefinition.ElementDefinitionBindingComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ElementDefinition.ElementDefinitionBindingComponent tgt = new ElementDefinition.ElementDefinitionBindingComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasStrength()) {
            tgt.setStrengthElement(VersionConvertor_14_30.convertBindingStrength(src.getStrengthElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_14_30.convertString(src.getDescriptionElement()));
        }
        if (src.hasValueSet()) {
            tgt.setValueSet(VersionConvertor_14_30.convertType(src.getValueSet()));
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionBindingComponent convertElementDefinitionBindingComponent(ElementDefinition.ElementDefinitionBindingComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ElementDefinition.ElementDefinitionBindingComponent tgt = new ElementDefinition.ElementDefinitionBindingComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasStrength()) {
            tgt.setStrengthElement(VersionConvertor_14_30.convertBindingStrength(src.getStrengthElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_14_30.convertString(src.getDescriptionElement()));
        }
        if (src.hasValueSet()) {
            tgt.setValueSet(VersionConvertor_14_30.convertType(src.getValueSet()));
        }
        return tgt;
    }

    public static Enumeration<Enumerations.BindingStrength> convertBindingStrength(org.hl7.fhir.dstu2016may.model.Enumeration<Enumerations.BindingStrength> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Enumerations.BindingStrength> tgt = new Enumeration<Enumerations.BindingStrength>(new Enumerations.BindingStrengthEnumFactory());
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.BindingStrength)((Object)src.getValue())) {
            case REQUIRED: {
                tgt.setValue((Object)Enumerations.BindingStrength.REQUIRED);
                break;
            }
            case EXTENSIBLE: {
                tgt.setValue((Object)Enumerations.BindingStrength.EXTENSIBLE);
                break;
            }
            case PREFERRED: {
                tgt.setValue((Object)Enumerations.BindingStrength.PREFERRED);
                break;
            }
            case EXAMPLE: {
                tgt.setValue((Object)Enumerations.BindingStrength.EXAMPLE);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.BindingStrength.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Enumeration<Enumerations.BindingStrength> convertBindingStrength(Enumeration<Enumerations.BindingStrength> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Enumeration<Enumerations.BindingStrength> tgt = new org.hl7.fhir.dstu2016may.model.Enumeration<Enumerations.BindingStrength>(new Enumerations.BindingStrengthEnumFactory());
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.BindingStrength)((Object)src.getValue())) {
            case REQUIRED: {
                tgt.setValue((Object)Enumerations.BindingStrength.REQUIRED);
                break;
            }
            case EXTENSIBLE: {
                tgt.setValue((Object)Enumerations.BindingStrength.EXTENSIBLE);
                break;
            }
            case PREFERRED: {
                tgt.setValue((Object)Enumerations.BindingStrength.PREFERRED);
                break;
            }
            case EXAMPLE: {
                tgt.setValue((Object)Enumerations.BindingStrength.EXAMPLE);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.BindingStrength.NULL);
            }
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionMappingComponent convertElementDefinitionMappingComponent(ElementDefinition.ElementDefinitionMappingComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ElementDefinition.ElementDefinitionMappingComponent tgt = new ElementDefinition.ElementDefinitionMappingComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasIdentityElement()) {
            tgt.setIdentityElement(VersionConvertor_14_30.convertId(src.getIdentityElement()));
        }
        if (src.hasLanguage()) {
            tgt.setLanguageElement(VersionConvertor_14_30.convertCode(src.getLanguageElement()));
        }
        if (src.hasMapElement()) {
            tgt.setMapElement(VersionConvertor_14_30.convertString(src.getMapElement()));
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionMappingComponent convertElementDefinitionMappingComponent(ElementDefinition.ElementDefinitionMappingComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ElementDefinition.ElementDefinitionMappingComponent tgt = new ElementDefinition.ElementDefinitionMappingComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasIdentityElement()) {
            tgt.setIdentityElement(VersionConvertor_14_30.convertId(src.getIdentityElement()));
        }
        if (src.hasLanguage()) {
            tgt.setLanguageElement(VersionConvertor_14_30.convertCode(src.getLanguageElement()));
        }
        if (src.hasMapElement()) {
            tgt.setMapElement(VersionConvertor_14_30.convertString(src.getMapElement()));
        }
        return tgt;
    }

    public static HumanName convertHumanName(org.hl7.fhir.dstu2016may.model.HumanName src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        HumanName tgt = new HumanName();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasUse()) {
            tgt.setUseElement(VersionConvertor_14_30.convertNameUse(src.getUseElement()));
        }
        if (src.hasText()) {
            tgt.setTextElement(VersionConvertor_14_30.convertString(src.getTextElement()));
        }
        for (StringType t : src.getFamily()) {
            tgt.setFamily((String)t.getValue());
        }
        for (StringType t : src.getGiven()) {
            tgt.addGiven((String)t.getValue());
        }
        for (StringType t : src.getPrefix()) {
            tgt.addPrefix((String)t.getValue());
        }
        for (StringType t : src.getSuffix()) {
            tgt.addSuffix((String)t.getValue());
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_14_30.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.HumanName convertHumanName(HumanName src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.HumanName tgt = new org.hl7.fhir.dstu2016may.model.HumanName();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasUse()) {
            tgt.setUseElement(VersionConvertor_14_30.convertNameUse(src.getUseElement()));
        }
        if (src.hasText()) {
            tgt.setTextElement(VersionConvertor_14_30.convertString(src.getTextElement()));
        }
        if (src.hasFamily()) {
            tgt.addFamily(src.getFamily());
        }
        for (org.hl7.fhir.dstu3.model.StringType t : src.getGiven()) {
            tgt.addGiven((String)t.getValue());
        }
        for (org.hl7.fhir.dstu3.model.StringType t : src.getPrefix()) {
            tgt.addPrefix((String)t.getValue());
        }
        for (org.hl7.fhir.dstu3.model.StringType t : src.getSuffix()) {
            tgt.addSuffix((String)t.getValue());
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_14_30.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static Enumeration<HumanName.NameUse> convertNameUse(org.hl7.fhir.dstu2016may.model.Enumeration<HumanName.NameUse> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<HumanName.NameUse> tgt = new Enumeration<HumanName.NameUse>(new HumanName.NameUseEnumFactory());
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        switch ((HumanName.NameUse)((Object)src.getValue())) {
            case USUAL: {
                tgt.setValue((Object)HumanName.NameUse.USUAL);
                break;
            }
            case OFFICIAL: {
                tgt.setValue((Object)HumanName.NameUse.OFFICIAL);
                break;
            }
            case TEMP: {
                tgt.setValue((Object)HumanName.NameUse.TEMP);
                break;
            }
            case NICKNAME: {
                tgt.setValue((Object)HumanName.NameUse.NICKNAME);
                break;
            }
            case ANONYMOUS: {
                tgt.setValue((Object)HumanName.NameUse.ANONYMOUS);
                break;
            }
            case OLD: {
                tgt.setValue((Object)HumanName.NameUse.OLD);
                break;
            }
            case MAIDEN: {
                tgt.setValue((Object)HumanName.NameUse.MAIDEN);
                break;
            }
            default: {
                tgt.setValue((Object)HumanName.NameUse.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Enumeration<HumanName.NameUse> convertNameUse(Enumeration<HumanName.NameUse> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Enumeration<HumanName.NameUse> tgt = new org.hl7.fhir.dstu2016may.model.Enumeration<HumanName.NameUse>(new HumanName.NameUseEnumFactory());
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        switch ((HumanName.NameUse)((Object)src.getValue())) {
            case USUAL: {
                tgt.setValue((Object)HumanName.NameUse.USUAL);
                break;
            }
            case OFFICIAL: {
                tgt.setValue((Object)HumanName.NameUse.OFFICIAL);
                break;
            }
            case TEMP: {
                tgt.setValue((Object)HumanName.NameUse.TEMP);
                break;
            }
            case NICKNAME: {
                tgt.setValue((Object)HumanName.NameUse.NICKNAME);
                break;
            }
            case ANONYMOUS: {
                tgt.setValue((Object)HumanName.NameUse.ANONYMOUS);
                break;
            }
            case OLD: {
                tgt.setValue((Object)HumanName.NameUse.OLD);
                break;
            }
            case MAIDEN: {
                tgt.setValue((Object)HumanName.NameUse.MAIDEN);
                break;
            }
            default: {
                tgt.setValue((Object)HumanName.NameUse.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Meta convertMeta(Meta src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Meta tgt = new org.hl7.fhir.dstu3.model.Meta();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasVersionId()) {
            tgt.setVersionIdElement(VersionConvertor_14_30.convertId(src.getVersionIdElement()));
        }
        if (src.hasLastUpdated()) {
            tgt.setLastUpdatedElement(VersionConvertor_14_30.convertInstant(src.getLastUpdatedElement()));
        }
        for (org.hl7.fhir.dstu2016may.model.UriType uriType : src.getProfile()) {
            tgt.addProfile((String)uriType.getValue());
        }
        for (org.hl7.fhir.dstu2016may.model.Coding coding : src.getSecurity()) {
            tgt.addSecurity(VersionConvertor_14_30.convertCoding(coding));
        }
        for (org.hl7.fhir.dstu2016may.model.Coding coding : src.getTag()) {
            tgt.addTag(VersionConvertor_14_30.convertCoding(coding));
        }
        return tgt;
    }

    public static Meta convertMeta(org.hl7.fhir.dstu3.model.Meta src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Meta tgt = new Meta();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasVersionId()) {
            tgt.setVersionIdElement(VersionConvertor_14_30.convertId(src.getVersionIdElement()));
        }
        if (src.hasLastUpdated()) {
            tgt.setLastUpdatedElement(VersionConvertor_14_30.convertInstant(src.getLastUpdatedElement()));
        }
        for (UriType uriType : src.getProfile()) {
            tgt.addProfile((String)uriType.getValue());
        }
        for (Coding coding : src.getSecurity()) {
            tgt.addSecurity(VersionConvertor_14_30.convertCoding(coding));
        }
        for (Coding coding : src.getTag()) {
            tgt.addTag(VersionConvertor_14_30.convertCoding(coding));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Timing convertTiming(Timing src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Timing tgt = new org.hl7.fhir.dstu3.model.Timing();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        for (DateTimeType t : src.getEvent()) {
            tgt.addEvent((Date)t.getValue());
        }
        if (src.hasRepeat()) {
            tgt.setRepeat(VersionConvertor_14_30.convertTimingRepeatComponent(src.getRepeat()));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_14_30.convertCodeableConcept(src.getCode()));
        }
        return tgt;
    }

    public static Timing convertTiming(org.hl7.fhir.dstu3.model.Timing src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Timing tgt = new Timing();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        for (org.hl7.fhir.dstu3.model.DateTimeType t : src.getEvent()) {
            tgt.addEvent((Date)t.getValue());
        }
        if (src.hasRepeat()) {
            tgt.setRepeat(VersionConvertor_14_30.convertTimingRepeatComponent(src.getRepeat()));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_14_30.convertCodeableConcept(src.getCode()));
        }
        return tgt;
    }

    public static Timing.TimingRepeatComponent convertTimingRepeatComponent(Timing.TimingRepeatComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Timing.TimingRepeatComponent tgt = new Timing.TimingRepeatComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasBounds()) {
            tgt.setBounds(VersionConvertor_14_30.convertType(src.getBounds()));
        }
        if (src.hasCount()) {
            tgt.setCountElement(VersionConvertor_14_30.convertInteger(src.getCountElement()));
        }
        if (src.hasCountMax()) {
            tgt.setCountMaxElement(VersionConvertor_14_30.convertInteger(src.getCountMaxElement()));
        }
        if (src.hasDuration()) {
            tgt.setDurationElement(VersionConvertor_14_30.convertDecimal(src.getDurationElement()));
        }
        if (src.hasDurationMax()) {
            tgt.setDurationMaxElement(VersionConvertor_14_30.convertDecimal(src.getDurationMaxElement()));
        }
        if (src.hasDurationUnit()) {
            tgt.setDurationUnitElement(VersionConvertor_14_30.convertUnitsOfTime(src.getDurationUnitElement()));
        }
        if (src.hasFrequency()) {
            tgt.setFrequencyElement(VersionConvertor_14_30.convertInteger(src.getFrequencyElement()));
        }
        if (src.hasFrequencyMax()) {
            tgt.setFrequencyMaxElement(VersionConvertor_14_30.convertInteger(src.getFrequencyMaxElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriodElement(VersionConvertor_14_30.convertDecimal(src.getPeriodElement()));
        }
        if (src.hasPeriodMax()) {
            tgt.setPeriodMaxElement(VersionConvertor_14_30.convertDecimal(src.getPeriodMaxElement()));
        }
        if (src.hasPeriodUnit()) {
            tgt.setPeriodUnitElement(VersionConvertor_14_30.convertUnitsOfTime(src.getPeriodUnitElement()));
        }
        if (src.hasWhen()) {
            tgt.setWhen(Collections.singletonList(VersionConvertor_14_30.convertEventTiming(src.getWhenElement())));
        }
        if (src.hasOffset()) {
            tgt.setOffsetElement(VersionConvertor_14_30.convertUnsignedInt(src.getOffsetElement()));
        }
        return tgt;
    }

    public static Timing.TimingRepeatComponent convertTimingRepeatComponent(Timing.TimingRepeatComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Timing.TimingRepeatComponent tgt = new Timing.TimingRepeatComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasBounds()) {
            tgt.setBounds(VersionConvertor_14_30.convertType(src.getBounds()));
        }
        if (src.hasCount()) {
            tgt.setCountElement(VersionConvertor_14_30.convertInteger(src.getCountElement()));
        }
        if (src.hasCountMax()) {
            tgt.setCountMaxElement(VersionConvertor_14_30.convertInteger(src.getCountMaxElement()));
        }
        if (src.hasDuration()) {
            tgt.setDurationElement(VersionConvertor_14_30.convertDecimal(src.getDurationElement()));
        }
        if (src.hasDurationMax()) {
            tgt.setDurationMaxElement(VersionConvertor_14_30.convertDecimal(src.getDurationMaxElement()));
        }
        if (src.hasDurationUnit()) {
            tgt.setDurationUnitElement(VersionConvertor_14_30.convertUnitsOfTime(src.getDurationUnitElement()));
        }
        if (src.hasFrequency()) {
            tgt.setFrequencyElement(VersionConvertor_14_30.convertInteger(src.getFrequencyElement()));
        }
        if (src.hasFrequencyMax()) {
            tgt.setFrequencyMaxElement(VersionConvertor_14_30.convertInteger(src.getFrequencyMaxElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriodElement(VersionConvertor_14_30.convertDecimal(src.getPeriodElement()));
        }
        if (src.hasPeriodMax()) {
            tgt.setPeriodMaxElement(VersionConvertor_14_30.convertDecimal(src.getPeriodMaxElement()));
        }
        if (src.hasPeriodUnit()) {
            tgt.setPeriodUnitElement(VersionConvertor_14_30.convertUnitsOfTime(src.getPeriodUnitElement()));
        }
        if (src.hasWhen()) {
            tgt.setWhenElement(VersionConvertor_14_30.convertEventTiming(src.getWhen().get(0)));
        }
        if (src.hasOffset()) {
            tgt.setOffsetElement(VersionConvertor_14_30.convertUnsignedInt(src.getOffsetElement()));
        }
        return tgt;
    }

    public static Enumeration<Timing.UnitsOfTime> convertUnitsOfTime(org.hl7.fhir.dstu2016may.model.Enumeration<Timing.UnitsOfTime> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Timing.UnitsOfTime> tgt = new Enumeration<Timing.UnitsOfTime>(new Timing.UnitsOfTimeEnumFactory());
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        switch ((Timing.UnitsOfTime)((Object)src.getValue())) {
            case S: {
                tgt.setValue((Object)Timing.UnitsOfTime.S);
                break;
            }
            case MIN: {
                tgt.setValue((Object)Timing.UnitsOfTime.MIN);
                break;
            }
            case H: {
                tgt.setValue((Object)Timing.UnitsOfTime.H);
                break;
            }
            case D: {
                tgt.setValue((Object)Timing.UnitsOfTime.D);
                break;
            }
            case WK: {
                tgt.setValue((Object)Timing.UnitsOfTime.WK);
                break;
            }
            case MO: {
                tgt.setValue((Object)Timing.UnitsOfTime.MO);
                break;
            }
            case A: {
                tgt.setValue((Object)Timing.UnitsOfTime.A);
                break;
            }
            default: {
                tgt.setValue((Object)Timing.UnitsOfTime.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Enumeration<Timing.UnitsOfTime> convertUnitsOfTime(Enumeration<Timing.UnitsOfTime> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Enumeration<Timing.UnitsOfTime> tgt = new org.hl7.fhir.dstu2016may.model.Enumeration<Timing.UnitsOfTime>(new Timing.UnitsOfTimeEnumFactory());
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        switch ((Timing.UnitsOfTime)((Object)src.getValue())) {
            case S: {
                tgt.setValue((Object)Timing.UnitsOfTime.S);
                break;
            }
            case MIN: {
                tgt.setValue((Object)Timing.UnitsOfTime.MIN);
                break;
            }
            case H: {
                tgt.setValue((Object)Timing.UnitsOfTime.H);
                break;
            }
            case D: {
                tgt.setValue((Object)Timing.UnitsOfTime.D);
                break;
            }
            case WK: {
                tgt.setValue((Object)Timing.UnitsOfTime.WK);
                break;
            }
            case MO: {
                tgt.setValue((Object)Timing.UnitsOfTime.MO);
                break;
            }
            case A: {
                tgt.setValue((Object)Timing.UnitsOfTime.A);
                break;
            }
            default: {
                tgt.setValue((Object)Timing.UnitsOfTime.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Timing.EventTiming> convertEventTiming(org.hl7.fhir.dstu2016may.model.Enumeration<Timing.EventTiming> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Timing.EventTiming> tgt = new Enumeration<Timing.EventTiming>(new Timing.EventTimingEnumFactory());
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        switch ((Timing.EventTiming)((Object)src.getValue())) {
            case HS: {
                tgt.setValue((Object)Timing.EventTiming.HS);
                break;
            }
            case WAKE: {
                tgt.setValue((Object)Timing.EventTiming.WAKE);
                break;
            }
            case C: {
                tgt.setValue((Object)Timing.EventTiming.C);
                break;
            }
            case CM: {
                tgt.setValue((Object)Timing.EventTiming.CM);
                break;
            }
            case CD: {
                tgt.setValue((Object)Timing.EventTiming.CD);
                break;
            }
            case CV: {
                tgt.setValue((Object)Timing.EventTiming.CV);
                break;
            }
            case AC: {
                tgt.setValue((Object)Timing.EventTiming.AC);
                break;
            }
            case ACM: {
                tgt.setValue((Object)Timing.EventTiming.ACM);
                break;
            }
            case ACD: {
                tgt.setValue((Object)Timing.EventTiming.ACD);
                break;
            }
            case ACV: {
                tgt.setValue((Object)Timing.EventTiming.ACV);
                break;
            }
            case PC: {
                tgt.setValue((Object)Timing.EventTiming.PC);
                break;
            }
            case PCM: {
                tgt.setValue((Object)Timing.EventTiming.PCM);
                break;
            }
            case PCD: {
                tgt.setValue((Object)Timing.EventTiming.PCD);
                break;
            }
            case PCV: {
                tgt.setValue((Object)Timing.EventTiming.PCV);
                break;
            }
            default: {
                tgt.setValue((Object)Timing.EventTiming.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Enumeration<Timing.EventTiming> convertEventTiming(Enumeration<Timing.EventTiming> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Enumeration<Timing.EventTiming> tgt = new org.hl7.fhir.dstu2016may.model.Enumeration<Timing.EventTiming>(new Timing.EventTimingEnumFactory());
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        switch ((Timing.EventTiming)((Object)src.getValue())) {
            case HS: {
                tgt.setValue((Object)Timing.EventTiming.HS);
                break;
            }
            case WAKE: {
                tgt.setValue((Object)Timing.EventTiming.WAKE);
                break;
            }
            case C: {
                tgt.setValue((Object)Timing.EventTiming.C);
                break;
            }
            case CM: {
                tgt.setValue((Object)Timing.EventTiming.CM);
                break;
            }
            case CD: {
                tgt.setValue((Object)Timing.EventTiming.CD);
                break;
            }
            case CV: {
                tgt.setValue((Object)Timing.EventTiming.CV);
                break;
            }
            case AC: {
                tgt.setValue((Object)Timing.EventTiming.AC);
                break;
            }
            case ACM: {
                tgt.setValue((Object)Timing.EventTiming.ACM);
                break;
            }
            case ACD: {
                tgt.setValue((Object)Timing.EventTiming.ACD);
                break;
            }
            case ACV: {
                tgt.setValue((Object)Timing.EventTiming.ACV);
                break;
            }
            case PC: {
                tgt.setValue((Object)Timing.EventTiming.PC);
                break;
            }
            case PCM: {
                tgt.setValue((Object)Timing.EventTiming.PCM);
                break;
            }
            case PCD: {
                tgt.setValue((Object)Timing.EventTiming.PCD);
                break;
            }
            case PCV: {
                tgt.setValue((Object)Timing.EventTiming.PCV);
                break;
            }
            default: {
                tgt.setValue((Object)Timing.EventTiming.NULL);
            }
        }
        return tgt;
    }

    public static SimpleQuantity convertSimpleQuantity(org.hl7.fhir.dstu2016may.model.SimpleQuantity src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        SimpleQuantity tgt = new SimpleQuantity();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_14_30.convertDecimal(src.getValueElement()));
        }
        if (src.hasComparator()) {
            tgt.setComparatorElement(VersionConvertor_14_30.convertQuantityComparator(src.getComparatorElement()));
        }
        if (src.hasUnit()) {
            tgt.setUnitElement(VersionConvertor_14_30.convertString(src.getUnitElement()));
        }
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_14_30.convertUri(src.getSystemElement()));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_14_30.convertCode(src.getCodeElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.SimpleQuantity convertSimpleQuantity(SimpleQuantity src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.SimpleQuantity tgt = new org.hl7.fhir.dstu2016may.model.SimpleQuantity();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_14_30.convertDecimal(src.getValueElement()));
        }
        if (src.hasComparator()) {
            tgt.setComparatorElement(VersionConvertor_14_30.convertQuantityComparator(src.getComparatorElement()));
        }
        if (src.hasUnit()) {
            tgt.setUnitElement(VersionConvertor_14_30.convertString(src.getUnitElement()));
        }
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_14_30.convertUri(src.getSystemElement()));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_14_30.convertCode(src.getCodeElement()));
        }
        return tgt;
    }

    public static Type convertType(org.hl7.fhir.dstu2016may.model.Type src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        if (src instanceof Base64BinaryType) {
            return VersionConvertor_14_30.convertBase64Binary((Base64BinaryType)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.BooleanType) {
            return VersionConvertor_14_30.convertBoolean((org.hl7.fhir.dstu2016may.model.BooleanType)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.CodeType) {
            return VersionConvertor_14_30.convertCode((org.hl7.fhir.dstu2016may.model.CodeType)src);
        }
        if (src instanceof DateType) {
            return VersionConvertor_14_30.convertDate((DateType)src);
        }
        if (src instanceof DateTimeType) {
            return VersionConvertor_14_30.convertDateTime((DateTimeType)src);
        }
        if (src instanceof DecimalType) {
            return VersionConvertor_14_30.convertDecimal((DecimalType)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.IdType) {
            return VersionConvertor_14_30.convertId((org.hl7.fhir.dstu2016may.model.IdType)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.InstantType) {
            return VersionConvertor_14_30.convertInstant((org.hl7.fhir.dstu2016may.model.InstantType)src);
        }
        if (src instanceof IntegerType) {
            return VersionConvertor_14_30.convertInteger((IntegerType)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.MarkdownType) {
            return VersionConvertor_14_30.convertMarkdown((org.hl7.fhir.dstu2016may.model.MarkdownType)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.OidType) {
            return VersionConvertor_14_30.convertOid((org.hl7.fhir.dstu2016may.model.OidType)src);
        }
        if (src instanceof PositiveIntType) {
            return VersionConvertor_14_30.convertPositiveInt((PositiveIntType)src);
        }
        if (src instanceof StringType) {
            return VersionConvertor_14_30.convertString((StringType)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.TimeType) {
            return VersionConvertor_14_30.convertTime((org.hl7.fhir.dstu2016may.model.TimeType)src);
        }
        if (src instanceof UnsignedIntType) {
            return VersionConvertor_14_30.convertUnsignedInt((UnsignedIntType)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.UriType) {
            return VersionConvertor_14_30.convertUri((org.hl7.fhir.dstu2016may.model.UriType)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.UuidType) {
            return VersionConvertor_14_30.convertUuid((org.hl7.fhir.dstu2016may.model.UuidType)src);
        }
        if (src instanceof Extension) {
            return VersionConvertor_14_30.convertExtension((Extension)src);
        }
        if (src instanceof Narrative) {
            return VersionConvertor_14_30.convertNarrative((Narrative)src);
        }
        if (src instanceof Age) {
            return VersionConvertor_14_30.convertAge((Age)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.Annotation) {
            return VersionConvertor_14_30.convertAnnotation((org.hl7.fhir.dstu2016may.model.Annotation)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.Attachment) {
            return VersionConvertor_14_30.convertAttachment((org.hl7.fhir.dstu2016may.model.Attachment)src);
        }
        if (src instanceof CodeableConcept) {
            return VersionConvertor_14_30.convertCodeableConcept((CodeableConcept)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.Coding) {
            return VersionConvertor_14_30.convertCoding((org.hl7.fhir.dstu2016may.model.Coding)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.Count) {
            return VersionConvertor_14_30.convertCount((org.hl7.fhir.dstu2016may.model.Count)src);
        }
        if (src instanceof Distance) {
            return VersionConvertor_14_30.convertDistance((Distance)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.Duration) {
            return VersionConvertor_14_30.convertDuration((org.hl7.fhir.dstu2016may.model.Duration)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.Identifier) {
            return VersionConvertor_14_30.convertIdentifier((org.hl7.fhir.dstu2016may.model.Identifier)src);
        }
        if (src instanceof Money) {
            return VersionConvertor_14_30.convertMoney((Money)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.Period) {
            return VersionConvertor_14_30.convertPeriod((org.hl7.fhir.dstu2016may.model.Period)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.Quantity) {
            return VersionConvertor_14_30.convertQuantity((org.hl7.fhir.dstu2016may.model.Quantity)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.Range) {
            return VersionConvertor_14_30.convertRange((org.hl7.fhir.dstu2016may.model.Range)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.Ratio) {
            return VersionConvertor_14_30.convertRatio((org.hl7.fhir.dstu2016may.model.Ratio)src);
        }
        if (src instanceof Reference) {
            return VersionConvertor_14_30.convertReference((Reference)src);
        }
        if (src instanceof SampledData) {
            return VersionConvertor_14_30.convertSampledData((SampledData)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.Signature) {
            return VersionConvertor_14_30.convertSignature((org.hl7.fhir.dstu2016may.model.Signature)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.Address) {
            return VersionConvertor_14_30.convertAddress((org.hl7.fhir.dstu2016may.model.Address)src);
        }
        if (src instanceof ContactPoint) {
            return VersionConvertor_14_30.convertContactPoint((ContactPoint)src);
        }
        if (src instanceof ElementDefinition) {
            return VersionConvertor_14_30.convertElementDefinition((ElementDefinition)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.HumanName) {
            return VersionConvertor_14_30.convertHumanName((org.hl7.fhir.dstu2016may.model.HumanName)src);
        }
        if (src instanceof Meta) {
            return VersionConvertor_14_30.convertMeta((Meta)src);
        }
        if (src instanceof Timing) {
            return VersionConvertor_14_30.convertTiming((Timing)src);
        }
        throw new FHIRException("Unknown type " + src.fhirType());
    }

    public static org.hl7.fhir.dstu2016may.model.Type convertType(Type src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Base64BinaryType) {
            return VersionConvertor_14_30.convertBase64Binary((org.hl7.fhir.dstu3.model.Base64BinaryType)src);
        }
        if (src instanceof BooleanType) {
            return VersionConvertor_14_30.convertBoolean((BooleanType)src);
        }
        if (src instanceof CodeType) {
            return VersionConvertor_14_30.convertCode((CodeType)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.DateType) {
            return VersionConvertor_14_30.convertDate((org.hl7.fhir.dstu3.model.DateType)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.DateTimeType) {
            return VersionConvertor_14_30.convertDateTime((org.hl7.fhir.dstu3.model.DateTimeType)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.DecimalType) {
            return VersionConvertor_14_30.convertDecimal((org.hl7.fhir.dstu3.model.DecimalType)src);
        }
        if (src instanceof IdType) {
            return VersionConvertor_14_30.convertId((IdType)src);
        }
        if (src instanceof InstantType) {
            return VersionConvertor_14_30.convertInstant((InstantType)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.IntegerType) {
            return VersionConvertor_14_30.convertInteger((org.hl7.fhir.dstu3.model.IntegerType)src);
        }
        if (src instanceof MarkdownType) {
            return VersionConvertor_14_30.convertMarkdown((MarkdownType)src);
        }
        if (src instanceof OidType) {
            return VersionConvertor_14_30.convertOid((OidType)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.PositiveIntType) {
            return VersionConvertor_14_30.convertPositiveInt((org.hl7.fhir.dstu3.model.PositiveIntType)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.StringType) {
            return VersionConvertor_14_30.convertString((org.hl7.fhir.dstu3.model.StringType)src);
        }
        if (src instanceof TimeType) {
            return VersionConvertor_14_30.convertTime((TimeType)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.UnsignedIntType) {
            return VersionConvertor_14_30.convertUnsignedInt((org.hl7.fhir.dstu3.model.UnsignedIntType)src);
        }
        if (src instanceof UriType) {
            return VersionConvertor_14_30.convertUri((UriType)src);
        }
        if (src instanceof UuidType) {
            return VersionConvertor_14_30.convertUuid((UuidType)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Extension) {
            return VersionConvertor_14_30.convertExtension((org.hl7.fhir.dstu3.model.Extension)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Narrative) {
            return VersionConvertor_14_30.convertNarrative((org.hl7.fhir.dstu3.model.Narrative)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Age) {
            return VersionConvertor_14_30.convertAge((org.hl7.fhir.dstu3.model.Age)src);
        }
        if (src instanceof Annotation) {
            return VersionConvertor_14_30.convertAnnotation((Annotation)src);
        }
        if (src instanceof Attachment) {
            return VersionConvertor_14_30.convertAttachment((Attachment)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.CodeableConcept) {
            return VersionConvertor_14_30.convertCodeableConcept((org.hl7.fhir.dstu3.model.CodeableConcept)src);
        }
        if (src instanceof Coding) {
            return VersionConvertor_14_30.convertCoding((Coding)src);
        }
        if (src instanceof Count) {
            return VersionConvertor_14_30.convertCount((Count)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Distance) {
            return VersionConvertor_14_30.convertDistance((org.hl7.fhir.dstu3.model.Distance)src);
        }
        if (src instanceof Duration) {
            return VersionConvertor_14_30.convertDuration((Duration)src);
        }
        if (src instanceof Identifier) {
            return VersionConvertor_14_30.convertIdentifier((Identifier)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Money) {
            return VersionConvertor_14_30.convertMoney((org.hl7.fhir.dstu3.model.Money)src);
        }
        if (src instanceof Period) {
            return VersionConvertor_14_30.convertPeriod((Period)src);
        }
        if (src instanceof Quantity) {
            return VersionConvertor_14_30.convertQuantity((Quantity)src);
        }
        if (src instanceof Range) {
            return VersionConvertor_14_30.convertRange((Range)src);
        }
        if (src instanceof Ratio) {
            return VersionConvertor_14_30.convertRatio((Ratio)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Reference) {
            return VersionConvertor_14_30.convertReference((org.hl7.fhir.dstu3.model.Reference)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.SampledData) {
            return VersionConvertor_14_30.convertSampledData((org.hl7.fhir.dstu3.model.SampledData)src);
        }
        if (src instanceof Signature) {
            return VersionConvertor_14_30.convertSignature((Signature)src);
        }
        if (src instanceof Address) {
            return VersionConvertor_14_30.convertAddress((Address)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.ContactPoint) {
            return VersionConvertor_14_30.convertContactPoint((org.hl7.fhir.dstu3.model.ContactPoint)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.ElementDefinition) {
            return VersionConvertor_14_30.convertElementDefinition((org.hl7.fhir.dstu3.model.ElementDefinition)src);
        }
        if (src instanceof HumanName) {
            return VersionConvertor_14_30.convertHumanName((HumanName)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Meta) {
            return VersionConvertor_14_30.convertMeta((org.hl7.fhir.dstu3.model.Meta)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Timing) {
            return VersionConvertor_14_30.convertTiming((org.hl7.fhir.dstu3.model.Timing)src);
        }
        throw new FHIRException("Unknown type " + src.fhirType());
    }

    public static void copyDomainResource(DomainResource src, org.hl7.fhir.dstu3.model.DomainResource tgt) throws FHIRException {
        VersionConvertor_14_30.copyResource(src, tgt);
        tgt.setText(VersionConvertor_14_30.convertNarrative(src.getText()));
        for (org.hl7.fhir.dstu2016may.model.Resource resource : src.getContained()) {
            tgt.addContained(VersionConvertor_14_30.convertResource(resource));
        }
        for (Extension extension : src.getExtension()) {
            tgt.addExtension(VersionConvertor_14_30.convertExtension(extension));
        }
        for (Extension extension : src.getModifierExtension()) {
            tgt.addModifierExtension(VersionConvertor_14_30.convertExtension(extension));
        }
    }

    public static void copyDomainResource(org.hl7.fhir.dstu3.model.DomainResource src, DomainResource tgt) throws FHIRException {
        VersionConvertor_14_30.copyResource(src, tgt);
        if (src.hasText()) {
            tgt.setText(VersionConvertor_14_30.convertNarrative(src.getText()));
        }
        for (Resource resource : src.getContained()) {
            tgt.addContained(VersionConvertor_14_30.convertResource(resource));
        }
        for (org.hl7.fhir.dstu3.model.Extension extension : src.getExtension()) {
            tgt.addExtension(VersionConvertor_14_30.convertExtension(extension));
        }
        for (org.hl7.fhir.dstu3.model.Extension extension : src.getModifierExtension()) {
            tgt.addModifierExtension(VersionConvertor_14_30.convertExtension(extension));
        }
    }

    public static void copyResource(org.hl7.fhir.dstu2016may.model.Resource src, Resource tgt) throws FHIRException {
        if (src.hasId()) {
            tgt.setId(src.getId());
        }
        tgt.setMeta(VersionConvertor_14_30.convertMeta(src.getMeta()));
        if (src.hasImplicitRules()) {
            tgt.setImplicitRules(src.getImplicitRules());
        }
        if (src.hasLanguage()) {
            tgt.setLanguage(src.getLanguage());
        }
    }

    public static void copyResource(Resource src, org.hl7.fhir.dstu2016may.model.Resource tgt) throws FHIRException {
        if (src.hasId()) {
            tgt.setId(src.getId());
        }
        if (src.hasMeta()) {
            tgt.setMeta(VersionConvertor_14_30.convertMeta(src.getMeta()));
        }
        if (src.hasImplicitRules()) {
            tgt.setImplicitRules(src.getImplicitRules());
        }
        if (src.hasLanguage()) {
            tgt.setLanguage(src.getLanguage());
        }
    }

    public static org.hl7.fhir.dstu3.model.Binary convertBinary(Binary src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Binary tgt = new org.hl7.fhir.dstu3.model.Binary();
        VersionConvertor_14_30.copyResource(src, tgt);
        if (src.hasContentTypeElement()) {
            tgt.setContentTypeElement(VersionConvertor_14_30.convertCode(src.getContentTypeElement()));
        }
        if (src.hasContentElement()) {
            tgt.setContentElement(VersionConvertor_14_30.convertBase64Binary(src.getContentElement()));
        }
        return tgt;
    }

    public static Binary convertBinary(org.hl7.fhir.dstu3.model.Binary src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Binary tgt = new Binary();
        VersionConvertor_14_30.copyResource(src, tgt);
        if (src.hasContentTypeElement()) {
            tgt.setContentTypeElement(VersionConvertor_14_30.convertCode(src.getContentTypeElement()));
        }
        if (src.hasContentElement()) {
            tgt.setContentElement(VersionConvertor_14_30.convertBase64Binary(src.getContentElement()));
        }
        return tgt;
    }

    public static Enumeration<Enumerations.PublicationStatus> convertConformanceResourceStatus(org.hl7.fhir.dstu2016may.model.Enumeration<Enumerations.ConformanceResourceStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Enumerations.PublicationStatus> tgt = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.ConformanceResourceStatus)((Object)src.getValue())) {
            case DRAFT: {
                tgt.setValue((Object)Enumerations.PublicationStatus.DRAFT);
                break;
            }
            case ACTIVE: {
                tgt.setValue((Object)Enumerations.PublicationStatus.ACTIVE);
                break;
            }
            case RETIRED: {
                tgt.setValue((Object)Enumerations.PublicationStatus.RETIRED);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.PublicationStatus.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Enumeration<Enumerations.ConformanceResourceStatus> convertConformanceResourceStatus(Enumeration<Enumerations.PublicationStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Enumeration<Enumerations.ConformanceResourceStatus> tgt = new org.hl7.fhir.dstu2016may.model.Enumeration<Enumerations.ConformanceResourceStatus>(new Enumerations.ConformanceResourceStatusEnumFactory());
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.PublicationStatus)((Object)src.getValue())) {
            case DRAFT: {
                tgt.setValue((Object)Enumerations.ConformanceResourceStatus.DRAFT);
                break;
            }
            case ACTIVE: {
                tgt.setValue((Object)Enumerations.ConformanceResourceStatus.ACTIVE);
                break;
            }
            case RETIRED: {
                tgt.setValue((Object)Enumerations.ConformanceResourceStatus.RETIRED);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.ConformanceResourceStatus.NULL);
            }
        }
        return tgt;
    }

    public static boolean isJurisdiction(CodeableConcept t) {
        return t.hasCoding() && ("http://unstats.un.org/unsd/methods/m49/m49.htm".equals(t.getCoding().get(0).getSystem()) || "urn:iso:std:iso:3166".equals(t.getCoding().get(0).getSystem()) || "https://www.usps.com/".equals(t.getCoding().get(0).getSystem()));
    }

    public static UsageContext convertCodeableConceptToUsageContext(CodeableConcept t) throws FHIRException {
        UsageContext result = new UsageContext();
        result.setValue(VersionConvertor_14_30.convertCodeableConcept(t));
        return result;
    }

    public static Enumeration<Enumerations.SearchParamType> convertSearchParamType(org.hl7.fhir.dstu2016may.model.Enumeration<Enumerations.SearchParamType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Enumerations.SearchParamType> tgt = new Enumeration<Enumerations.SearchParamType>(new Enumerations.SearchParamTypeEnumFactory());
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.SearchParamType)((Object)src.getValue())) {
            case NUMBER: {
                tgt.setValue((Object)Enumerations.SearchParamType.NUMBER);
                break;
            }
            case DATE: {
                tgt.setValue((Object)Enumerations.SearchParamType.DATE);
                break;
            }
            case STRING: {
                tgt.setValue((Object)Enumerations.SearchParamType.STRING);
                break;
            }
            case TOKEN: {
                tgt.setValue((Object)Enumerations.SearchParamType.TOKEN);
                break;
            }
            case REFERENCE: {
                tgt.setValue((Object)Enumerations.SearchParamType.REFERENCE);
                break;
            }
            case COMPOSITE: {
                tgt.setValue((Object)Enumerations.SearchParamType.COMPOSITE);
                break;
            }
            case QUANTITY: {
                tgt.setValue((Object)Enumerations.SearchParamType.QUANTITY);
                break;
            }
            case URI: {
                tgt.setValue((Object)Enumerations.SearchParamType.URI);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.SearchParamType.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Enumeration<Enumerations.SearchParamType> convertSearchParamType(Enumeration<Enumerations.SearchParamType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Enumeration<Enumerations.SearchParamType> tgt = new org.hl7.fhir.dstu2016may.model.Enumeration<Enumerations.SearchParamType>(new Enumerations.SearchParamTypeEnumFactory());
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.SearchParamType)((Object)src.getValue())) {
            case NUMBER: {
                tgt.setValue((Object)Enumerations.SearchParamType.NUMBER);
                break;
            }
            case DATE: {
                tgt.setValue((Object)Enumerations.SearchParamType.DATE);
                break;
            }
            case STRING: {
                tgt.setValue((Object)Enumerations.SearchParamType.STRING);
                break;
            }
            case TOKEN: {
                tgt.setValue((Object)Enumerations.SearchParamType.TOKEN);
                break;
            }
            case REFERENCE: {
                tgt.setValue((Object)Enumerations.SearchParamType.REFERENCE);
                break;
            }
            case COMPOSITE: {
                tgt.setValue((Object)Enumerations.SearchParamType.COMPOSITE);
                break;
            }
            case QUANTITY: {
                tgt.setValue((Object)Enumerations.SearchParamType.QUANTITY);
                break;
            }
            case URI: {
                tgt.setValue((Object)Enumerations.SearchParamType.URI);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.SearchParamType.NULL);
            }
        }
        return tgt;
    }

    public static Resource convertResource(org.hl7.fhir.dstu2016may.model.Resource src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.Parameters) {
            return Parameters14_30.convertParameters((org.hl7.fhir.dstu2016may.model.Parameters)src);
        }
        if (src instanceof Bundle) {
            return Bundle14_30.convertBundle((Bundle)src);
        }
        if (src instanceof CodeSystem) {
            return CodeSystem14_30.convertCodeSystem((CodeSystem)src);
        }
        if (src instanceof CompartmentDefinition) {
            return CompartmentDefinition14_30.convertCompartmentDefinition((CompartmentDefinition)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.ConceptMap) {
            return ConceptMap14_30.convertConceptMap((org.hl7.fhir.dstu2016may.model.ConceptMap)src);
        }
        if (src instanceof Conformance) {
            return Conformance14_30.convertConformance((Conformance)src);
        }
        if (src instanceof DataElement) {
            return DataElement14_30.convertDataElement((DataElement)src);
        }
        if (src instanceof ImplementationGuide) {
            return ImplementationGuide14_30.convertImplementationGuide((ImplementationGuide)src);
        }
        if (src instanceof NamingSystem) {
            return NamingSystem14_30.convertNamingSystem((NamingSystem)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.OperationDefinition) {
            return OperationDefinition14_30.convertOperationDefinition((org.hl7.fhir.dstu2016may.model.OperationDefinition)src);
        }
        if (src instanceof OperationOutcome) {
            return OperationOutcome14_30.convertOperationOutcome((OperationOutcome)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.Questionnaire) {
            return Questionnaire14_30.convertQuestionnaire((org.hl7.fhir.dstu2016may.model.Questionnaire)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.QuestionnaireResponse) {
            return QuestionnaireResponse14_30.convertQuestionnaireResponse((org.hl7.fhir.dstu2016may.model.QuestionnaireResponse)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.SearchParameter) {
            return SearchParameter14_30.convertSearchParameter((org.hl7.fhir.dstu2016may.model.SearchParameter)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.StructureDefinition) {
            return StructureDefinition14_30.convertStructureDefinition((org.hl7.fhir.dstu2016may.model.StructureDefinition)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.TestScript) {
            return TestScript14_30.convertTestScript((org.hl7.fhir.dstu2016may.model.TestScript)src);
        }
        if (src instanceof ValueSet) {
            return ValueSet14_30.convertValueSet((ValueSet)src);
        }
        throw new FHIRException("Unknown resource " + src.fhirType());
    }

    public static org.hl7.fhir.dstu2016may.model.Resource convertResource(Resource src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        if (src instanceof Parameters) {
            return Parameters14_30.convertParameters((Parameters)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Bundle) {
            return Bundle14_30.convertBundle((org.hl7.fhir.dstu3.model.Bundle)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.CodeSystem) {
            return CodeSystem14_30.convertCodeSystem((org.hl7.fhir.dstu3.model.CodeSystem)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.CompartmentDefinition) {
            return CompartmentDefinition14_30.convertCompartmentDefinition((org.hl7.fhir.dstu3.model.CompartmentDefinition)src);
        }
        if (src instanceof ConceptMap) {
            return ConceptMap14_30.convertConceptMap((ConceptMap)src);
        }
        if (src instanceof CapabilityStatement) {
            return Conformance14_30.convertConformance((CapabilityStatement)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.DataElement) {
            return DataElement14_30.convertDataElement((org.hl7.fhir.dstu3.model.DataElement)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.ImplementationGuide) {
            return ImplementationGuide14_30.convertImplementationGuide((org.hl7.fhir.dstu3.model.ImplementationGuide)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.NamingSystem) {
            return NamingSystem14_30.convertNamingSystem((org.hl7.fhir.dstu3.model.NamingSystem)src);
        }
        if (src instanceof OperationDefinition) {
            return OperationDefinition14_30.convertOperationDefinition((OperationDefinition)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.OperationOutcome) {
            return OperationOutcome14_30.convertOperationOutcome((org.hl7.fhir.dstu3.model.OperationOutcome)src);
        }
        if (src instanceof Questionnaire) {
            return Questionnaire14_30.convertQuestionnaire((Questionnaire)src);
        }
        if (src instanceof QuestionnaireResponse) {
            return QuestionnaireResponse14_30.convertQuestionnaireResponse((QuestionnaireResponse)src);
        }
        if (src instanceof SearchParameter) {
            return SearchParameter14_30.convertSearchParameter((SearchParameter)src);
        }
        if (src instanceof StructureDefinition) {
            return StructureDefinition14_30.convertStructureDefinition((StructureDefinition)src);
        }
        if (src instanceof TestScript) {
            return TestScript14_30.convertTestScript((TestScript)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.ValueSet) {
            return ValueSet14_30.convertValueSet((org.hl7.fhir.dstu3.model.ValueSet)src);
        }
        throw new FHIRException("Unknown resource " + src.fhirType());
    }

    public static boolean convertsResource(String rt) {
        return Utilities.existsInList(rt, "Parameters", "Bundle", "CodeSystem", "CompartmentDefinition", "ConceptMap", "CapabilityStatement", "DataElement", "ImplementationGuide", "NamingSystem", "OperationDefinition", "OperationOutcome", "Questionnaire", "QuestionnaireResponse", "SearchParameter", "StructureDefinition", "TestScript", "ValueSet");
    }

    public static class SourceElementComponentWrapper {
        public String source;
        public String target;
        public ConceptMap.SourceElementComponent comp;

        public SourceElementComponentWrapper(ConceptMap.SourceElementComponent comp, String source, String target) {
            this.source = source;
            this.target = target;
            this.comp = comp;
        }
    }
}

