/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.hl7.fhir.convertors.VersionConvertorAdvisor40;
import org.hl7.fhir.convertors.VersionConvertor_10_40;
import org.hl7.fhir.dstu2.formats.JsonParser;
import org.hl7.fhir.dstu2.formats.XmlParser;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.context.SimpleWorkerContext;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.CodeSystem;
import org.hl7.fhir.r4.model.MetadataResource;
import org.hl7.fhir.r4.model.StructureDefinition;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.r4.model.ValueSet;

public class R2ToR4Loader
implements SimpleWorkerContext.IContextResourceLoader,
VersionConvertorAdvisor40 {
    private List<CodeSystem> cslist = new ArrayList<CodeSystem>();
    private boolean patchUrls;
    private boolean killPrimitives;

    @Override
    public Bundle loadBundle(InputStream stream, boolean isJson) throws FHIRException, IOException {
        Bundle b;
        org.hl7.fhir.dstu2.model.Resource r2 = null;
        r2 = isJson ? new JsonParser().parse(stream) : new XmlParser().parse(stream);
        org.hl7.fhir.r4.model.Resource r4 = VersionConvertor_10_40.convertResource(r2, (VersionConvertorAdvisor40)this);
        if (r4 instanceof Bundle) {
            b = (Bundle)r4;
        } else {
            b = new Bundle();
            b.setId(UUID.randomUUID().toString().toLowerCase());
            b.setType(Bundle.BundleType.COLLECTION);
            b.addEntry().setResource(r4).setFullUrl(r4 instanceof MetadataResource ? ((MetadataResource)r4).getUrl() : null);
        }
        for (CodeSystem codeSystem : this.cslist) {
            Bundle.BundleEntryComponent be = b.addEntry();
            be.setFullUrl(codeSystem.getUrl());
            be.setResource(codeSystem);
        }
        this.cslist.clear();
        if (this.killPrimitives) {
            ArrayList<Bundle.BundleEntryComponent> remove = new ArrayList<Bundle.BundleEntryComponent>();
            for (Bundle.BundleEntryComponent be : b.getEntry()) {
                StructureDefinition sd;
                if (!be.hasResource() || !(be.getResource() instanceof StructureDefinition) || (sd = (StructureDefinition)be.getResource()).getKind() != StructureDefinition.StructureDefinitionKind.PRIMITIVETYPE) continue;
                remove.add(be);
            }
            b.getEntry().removeAll(remove);
        }
        if (this.patchUrls) {
            for (Bundle.BundleEntryComponent bundleEntryComponent : b.getEntry()) {
                if (!bundleEntryComponent.hasResource() || !(bundleEntryComponent.getResource() instanceof StructureDefinition)) continue;
                StructureDefinition sd = (StructureDefinition)bundleEntryComponent.getResource();
                sd.setUrl(sd.getUrl().replace("http://hl7.org/fhir/", "http://hl7.org/fhir/DSTU2/"));
                sd.addExtension().setUrl("http://hl7.org/fhir/StructureDefinition/elementdefinition-namespace").setValue(new UriType("http://hl7.org/fhir"));
            }
        }
        return b;
    }

    @Override
    public boolean ignoreEntry(Bundle.BundleEntryComponent src) {
        return false;
    }

    @Override
    public org.hl7.fhir.dstu2.model.Resource convertR2(org.hl7.fhir.r4.model.Resource resource) throws FHIRException {
        return null;
    }

    @Override
    public org.hl7.fhir.dstu2016may.model.Resource convertR2016May(org.hl7.fhir.r4.model.Resource resource) throws FHIRException {
        return null;
    }

    @Override
    public Resource convertR3(org.hl7.fhir.r4.model.Resource resource) throws FHIRException {
        return null;
    }

    @Override
    public void handleCodeSystem(CodeSystem cs, ValueSet vs) {
        cs.setId(vs.getId());
        cs.setValueSet(vs.getUrl());
        this.cslist.add(cs);
    }

    @Override
    public CodeSystem getCodeSystem(ValueSet src) {
        return null;
    }

    public boolean isPatchUrls() {
        return this.patchUrls;
    }

    public R2ToR4Loader setPatchUrls(boolean patchUrls) {
        this.patchUrls = patchUrls;
        return this;
    }

    public boolean isKillPrimitives() {
        return this.killPrimitives;
    }

    public R2ToR4Loader setKillPrimitives(boolean killPrimitives) {
        this.killPrimitives = killPrimitives;
        return this;
    }
}

