/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Boolean;
import org.hl7.fhir.Code;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.ConformanceResourceStatus;
import org.hl7.fhir.Date;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.String;
import org.hl7.fhir.Uri;
import org.hl7.fhir.ValueSetCompose;
import org.hl7.fhir.ValueSetContact;
import org.hl7.fhir.ValueSetExpansion;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ValueSet", propOrder={"url", "identifier", "version", "name", "status", "experimental", "publisher", "contact", "date", "lockedDate", "description", "useContext", "immutable", "requirements", "copyright", "extensible", "compose", "expansion"})
public class ValueSet
extends DomainResource
implements Equals2,
HashCode2,
ToString2 {
    protected Uri url;
    protected Identifier identifier;
    protected String version;
    protected String name;
    @XmlElement(required=true)
    protected ConformanceResourceStatus status;
    protected Boolean experimental;
    protected String publisher;
    protected List<ValueSetContact> contact;
    protected DateTime date;
    protected Date lockedDate;
    protected String description;
    protected List<CodeableConcept> useContext;
    protected Boolean immutable;
    protected String requirements;
    protected String copyright;
    protected Boolean extensible;
    protected ValueSetCompose compose;
    protected ValueSetExpansion expansion;

    public Uri getUrl() {
        return this.url;
    }

    public void setUrl(Uri value) {
        this.url = value;
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(Identifier value) {
        this.identifier = value;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String value) {
        this.version = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public ConformanceResourceStatus getStatus() {
        return this.status;
    }

    public void setStatus(ConformanceResourceStatus value) {
        this.status = value;
    }

    public Boolean getExperimental() {
        return this.experimental;
    }

    public void setExperimental(Boolean value) {
        this.experimental = value;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public void setPublisher(String value) {
        this.publisher = value;
    }

    public List<ValueSetContact> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<ValueSetContact>();
        }
        return this.contact;
    }

    public DateTime getDate() {
        return this.date;
    }

    public void setDate(DateTime value) {
        this.date = value;
    }

    public Date getLockedDate() {
        return this.lockedDate;
    }

    public void setLockedDate(Date value) {
        this.lockedDate = value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public List<CodeableConcept> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList<CodeableConcept>();
        }
        return this.useContext;
    }

    public Boolean getImmutable() {
        return this.immutable;
    }

    public void setImmutable(Boolean value) {
        this.immutable = value;
    }

    public String getRequirements() {
        return this.requirements;
    }

    public void setRequirements(String value) {
        this.requirements = value;
    }

    public String getCopyright() {
        return this.copyright;
    }

    public void setCopyright(String value) {
        this.copyright = value;
    }

    public Boolean getExtensible() {
        return this.extensible;
    }

    public void setExtensible(Boolean value) {
        this.extensible = value;
    }

    public ValueSetCompose getCompose() {
        return this.compose;
    }

    public void setCompose(ValueSetCompose value) {
        this.compose = value;
    }

    public ValueSetExpansion getExpansion() {
        return this.expansion;
    }

    public void setExpansion(ValueSetExpansion value) {
        this.expansion = value;
    }

    public ValueSet withUrl(Uri value) {
        this.setUrl(value);
        return this;
    }

    public ValueSet withIdentifier(Identifier value) {
        this.setIdentifier(value);
        return this;
    }

    public ValueSet withVersion(String value) {
        this.setVersion(value);
        return this;
    }

    public ValueSet withName(String value) {
        this.setName(value);
        return this;
    }

    public ValueSet withStatus(ConformanceResourceStatus value) {
        this.setStatus(value);
        return this;
    }

    public ValueSet withExperimental(Boolean value) {
        this.setExperimental(value);
        return this;
    }

    public ValueSet withPublisher(String value) {
        this.setPublisher(value);
        return this;
    }

    public ValueSet withContact(ValueSetContact ... values) {
        if (values != null) {
            for (ValueSetContact value : values) {
                this.getContact().add(value);
            }
        }
        return this;
    }

    public ValueSet withContact(Collection<ValueSetContact> values) {
        if (values != null) {
            this.getContact().addAll(values);
        }
        return this;
    }

    public ValueSet withDate(DateTime value) {
        this.setDate(value);
        return this;
    }

    public ValueSet withLockedDate(Date value) {
        this.setLockedDate(value);
        return this;
    }

    public ValueSet withDescription(String value) {
        this.setDescription(value);
        return this;
    }

    public ValueSet withUseContext(CodeableConcept ... values) {
        if (values != null) {
            for (CodeableConcept value : values) {
                this.getUseContext().add(value);
            }
        }
        return this;
    }

    public ValueSet withUseContext(Collection<CodeableConcept> values) {
        if (values != null) {
            this.getUseContext().addAll(values);
        }
        return this;
    }

    public ValueSet withImmutable(Boolean value) {
        this.setImmutable(value);
        return this;
    }

    public ValueSet withRequirements(String value) {
        this.setRequirements(value);
        return this;
    }

    public ValueSet withCopyright(String value) {
        this.setCopyright(value);
        return this;
    }

    public ValueSet withExtensible(Boolean value) {
        this.setExtensible(value);
        return this;
    }

    public ValueSet withCompose(ValueSetCompose value) {
        this.setCompose(value);
        return this;
    }

    public ValueSet withExpansion(ValueSetExpansion value) {
        this.setExpansion(value);
        return this;
    }

    @Override
    public ValueSet withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public ValueSet withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public ValueSet withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public ValueSet withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ValueSet withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ValueSet withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ValueSet withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ValueSet withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public ValueSet withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public ValueSet withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public ValueSet withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        ValueSet that = (ValueSet)object;
        Uri lhsUrl = this.getUrl();
        Uri rhsUrl = that.getUrl();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "url", lhsUrl), (ObjectLocator)LocatorUtils.property(thatLocator, "url", rhsUrl), lhsUrl, rhsUrl, this.url != null, that.url != null)) {
            return false;
        }
        Identifier lhsIdentifier = this.getIdentifier();
        Identifier rhsIdentifier = that.getIdentifier();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "identifier", lhsIdentifier), (ObjectLocator)LocatorUtils.property(thatLocator, "identifier", rhsIdentifier), lhsIdentifier, rhsIdentifier, this.identifier != null, that.identifier != null)) {
            return false;
        }
        String lhsVersion = this.getVersion();
        String rhsVersion = that.getVersion();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "version", lhsVersion), (ObjectLocator)LocatorUtils.property(thatLocator, "version", rhsVersion), lhsVersion, rhsVersion, this.version != null, that.version != null)) {
            return false;
        }
        String lhsName = this.getName();
        String rhsName = that.getName();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "name", lhsName), (ObjectLocator)LocatorUtils.property(thatLocator, "name", rhsName), lhsName, rhsName, this.name != null, that.name != null)) {
            return false;
        }
        ConformanceResourceStatus lhsStatus = this.getStatus();
        ConformanceResourceStatus rhsStatus = that.getStatus();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "status", lhsStatus), (ObjectLocator)LocatorUtils.property(thatLocator, "status", rhsStatus), lhsStatus, rhsStatus, this.status != null, that.status != null)) {
            return false;
        }
        Boolean lhsExperimental = this.getExperimental();
        Boolean rhsExperimental = that.getExperimental();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "experimental", lhsExperimental), (ObjectLocator)LocatorUtils.property(thatLocator, "experimental", rhsExperimental), lhsExperimental, rhsExperimental, this.experimental != null, that.experimental != null)) {
            return false;
        }
        String lhsPublisher = this.getPublisher();
        String rhsPublisher = that.getPublisher();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "publisher", lhsPublisher), (ObjectLocator)LocatorUtils.property(thatLocator, "publisher", rhsPublisher), lhsPublisher, rhsPublisher, this.publisher != null, that.publisher != null)) {
            return false;
        }
        List<ValueSetContact> lhsContact = this.contact != null && !this.contact.isEmpty() ? this.getContact() : null;
        List<ValueSetContact> rhsContact = that.contact != null && !that.contact.isEmpty() ? that.getContact() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "contact", lhsContact), (ObjectLocator)LocatorUtils.property(thatLocator, "contact", rhsContact), lhsContact, rhsContact, this.contact != null && !this.contact.isEmpty(), that.contact != null && !that.contact.isEmpty())) {
            return false;
        }
        DateTime lhsDate = this.getDate();
        DateTime rhsDate = that.getDate();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "date", lhsDate), (ObjectLocator)LocatorUtils.property(thatLocator, "date", rhsDate), lhsDate, rhsDate, this.date != null, that.date != null)) {
            return false;
        }
        Date lhsLockedDate = this.getLockedDate();
        Date rhsLockedDate = that.getLockedDate();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "lockedDate", lhsLockedDate), (ObjectLocator)LocatorUtils.property(thatLocator, "lockedDate", rhsLockedDate), lhsLockedDate, rhsLockedDate, this.lockedDate != null, that.lockedDate != null)) {
            return false;
        }
        String lhsDescription = this.getDescription();
        String rhsDescription = that.getDescription();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "description", lhsDescription), (ObjectLocator)LocatorUtils.property(thatLocator, "description", rhsDescription), lhsDescription, rhsDescription, this.description != null, that.description != null)) {
            return false;
        }
        List<CodeableConcept> lhsUseContext = this.useContext != null && !this.useContext.isEmpty() ? this.getUseContext() : null;
        List<CodeableConcept> rhsUseContext = that.useContext != null && !that.useContext.isEmpty() ? that.getUseContext() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "useContext", lhsUseContext), (ObjectLocator)LocatorUtils.property(thatLocator, "useContext", rhsUseContext), lhsUseContext, rhsUseContext, this.useContext != null && !this.useContext.isEmpty(), that.useContext != null && !that.useContext.isEmpty())) {
            return false;
        }
        Boolean lhsImmutable = this.getImmutable();
        Boolean rhsImmutable = that.getImmutable();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "immutable", lhsImmutable), (ObjectLocator)LocatorUtils.property(thatLocator, "immutable", rhsImmutable), lhsImmutable, rhsImmutable, this.immutable != null, that.immutable != null)) {
            return false;
        }
        String lhsRequirements = this.getRequirements();
        String rhsRequirements = that.getRequirements();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "requirements", lhsRequirements), (ObjectLocator)LocatorUtils.property(thatLocator, "requirements", rhsRequirements), lhsRequirements, rhsRequirements, this.requirements != null, that.requirements != null)) {
            return false;
        }
        String lhsCopyright = this.getCopyright();
        String rhsCopyright = that.getCopyright();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "copyright", lhsCopyright), (ObjectLocator)LocatorUtils.property(thatLocator, "copyright", rhsCopyright), lhsCopyright, rhsCopyright, this.copyright != null, that.copyright != null)) {
            return false;
        }
        Boolean lhsExtensible = this.getExtensible();
        Boolean rhsExtensible = that.getExtensible();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "extensible", lhsExtensible), (ObjectLocator)LocatorUtils.property(thatLocator, "extensible", rhsExtensible), lhsExtensible, rhsExtensible, this.extensible != null, that.extensible != null)) {
            return false;
        }
        ValueSetCompose lhsCompose = this.getCompose();
        ValueSetCompose rhsCompose = that.getCompose();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "compose", lhsCompose), (ObjectLocator)LocatorUtils.property(thatLocator, "compose", rhsCompose), lhsCompose, rhsCompose, this.compose != null, that.compose != null)) {
            return false;
        }
        ValueSetExpansion lhsExpansion = this.getExpansion();
        ValueSetExpansion rhsExpansion = that.getExpansion();
        return strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "expansion", lhsExpansion), (ObjectLocator)LocatorUtils.property(thatLocator, "expansion", rhsExpansion), lhsExpansion, rhsExpansion, this.expansion != null, that.expansion != null);
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE2;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        Uri theUrl = this.getUrl();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "url", theUrl), currentHashCode, theUrl, this.url != null);
        Identifier theIdentifier = this.getIdentifier();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "identifier", theIdentifier), currentHashCode, theIdentifier, this.identifier != null);
        String theVersion = this.getVersion();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "version", theVersion), currentHashCode, theVersion, this.version != null);
        String theName = this.getName();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "name", theName), currentHashCode, theName, this.name != null);
        ConformanceResourceStatus theStatus = this.getStatus();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "status", theStatus), currentHashCode, theStatus, this.status != null);
        Boolean theExperimental = this.getExperimental();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "experimental", theExperimental), currentHashCode, theExperimental, this.experimental != null);
        String thePublisher = this.getPublisher();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "publisher", thePublisher), currentHashCode, thePublisher, this.publisher != null);
        List<ValueSetContact> theContact = this.contact != null && !this.contact.isEmpty() ? this.getContact() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "contact", theContact), currentHashCode, theContact, this.contact != null && !this.contact.isEmpty());
        DateTime theDate = this.getDate();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "date", theDate), currentHashCode, theDate, this.date != null);
        Date theLockedDate = this.getLockedDate();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "lockedDate", theLockedDate), currentHashCode, theLockedDate, this.lockedDate != null);
        String theDescription = this.getDescription();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "description", theDescription), currentHashCode, theDescription, this.description != null);
        List<CodeableConcept> theUseContext = this.useContext != null && !this.useContext.isEmpty() ? this.getUseContext() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "useContext", theUseContext), currentHashCode, theUseContext, this.useContext != null && !this.useContext.isEmpty());
        Boolean theImmutable = this.getImmutable();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "immutable", theImmutable), currentHashCode, theImmutable, this.immutable != null);
        String theRequirements = this.getRequirements();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "requirements", theRequirements), currentHashCode, theRequirements, this.requirements != null);
        String theCopyright = this.getCopyright();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "copyright", theCopyright), currentHashCode, theCopyright, this.copyright != null);
        Boolean theExtensible = this.getExtensible();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "extensible", theExtensible), currentHashCode, theExtensible, this.extensible != null);
        ValueSetCompose theCompose = this.getCompose();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "compose", theCompose), currentHashCode, theCompose, this.compose != null);
        ValueSetExpansion theExpansion = this.getExpansion();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "expansion", theExpansion), currentHashCode, theExpansion, this.expansion != null);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE2;
        return this.hashCode(null, strategy);
    }

    @Override
    public java.lang.String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.INSTANCE2;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        Uri theUrl = this.getUrl();
        strategy.appendField(locator, (Object)this, "url", buffer, theUrl, this.url != null);
        Identifier theIdentifier = this.getIdentifier();
        strategy.appendField(locator, (Object)this, "identifier", buffer, theIdentifier, this.identifier != null);
        String theVersion = this.getVersion();
        strategy.appendField(locator, (Object)this, "version", buffer, theVersion, this.version != null);
        String theName = this.getName();
        strategy.appendField(locator, (Object)this, "name", buffer, theName, this.name != null);
        ConformanceResourceStatus theStatus = this.getStatus();
        strategy.appendField(locator, (Object)this, "status", buffer, theStatus, this.status != null);
        Boolean theExperimental = this.getExperimental();
        strategy.appendField(locator, (Object)this, "experimental", buffer, theExperimental, this.experimental != null);
        String thePublisher = this.getPublisher();
        strategy.appendField(locator, (Object)this, "publisher", buffer, thePublisher, this.publisher != null);
        List<ValueSetContact> theContact = this.contact != null && !this.contact.isEmpty() ? this.getContact() : null;
        strategy.appendField(locator, (Object)this, "contact", buffer, theContact, this.contact != null && !this.contact.isEmpty());
        DateTime theDate = this.getDate();
        strategy.appendField(locator, (Object)this, "date", buffer, theDate, this.date != null);
        Date theLockedDate = this.getLockedDate();
        strategy.appendField(locator, (Object)this, "lockedDate", buffer, theLockedDate, this.lockedDate != null);
        String theDescription = this.getDescription();
        strategy.appendField(locator, (Object)this, "description", buffer, theDescription, this.description != null);
        List<CodeableConcept> theUseContext = this.useContext != null && !this.useContext.isEmpty() ? this.getUseContext() : null;
        strategy.appendField(locator, (Object)this, "useContext", buffer, theUseContext, this.useContext != null && !this.useContext.isEmpty());
        Boolean theImmutable = this.getImmutable();
        strategy.appendField(locator, (Object)this, "immutable", buffer, theImmutable, this.immutable != null);
        String theRequirements = this.getRequirements();
        strategy.appendField(locator, (Object)this, "requirements", buffer, theRequirements, this.requirements != null);
        String theCopyright = this.getCopyright();
        strategy.appendField(locator, (Object)this, "copyright", buffer, theCopyright, this.copyright != null);
        Boolean theExtensible = this.getExtensible();
        strategy.appendField(locator, (Object)this, "extensible", buffer, theExtensible, this.extensible != null);
        ValueSetCompose theCompose = this.getCompose();
        strategy.appendField(locator, (Object)this, "compose", buffer, theCompose, this.compose != null);
        ValueSetExpansion theExpansion = this.getExpansion();
        strategy.appendField(locator, (Object)this, "expansion", buffer, theExpansion, this.expansion != null);
        return buffer;
    }
}

