/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Boolean;
import org.hl7.fhir.Code;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.ConformanceResourceStatus;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.String;
import org.hl7.fhir.StructureMapContact;
import org.hl7.fhir.StructureMapGroup;
import org.hl7.fhir.StructureMapStructure;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="StructureMap", propOrder={"url", "identifier", "version", "name", "status", "experimental", "publisher", "contact", "date", "description", "useContext", "requirements", "copyright", "structure", "_import", "group"})
public class StructureMap
extends DomainResource
implements Equals2,
HashCode2,
ToString2 {
    @XmlElement(required=true)
    protected Uri url;
    protected List<Identifier> identifier;
    protected String version;
    @XmlElement(required=true)
    protected String name;
    @XmlElement(required=true)
    protected ConformanceResourceStatus status;
    protected Boolean experimental;
    protected String publisher;
    protected List<StructureMapContact> contact;
    protected DateTime date;
    protected String description;
    protected List<CodeableConcept> useContext;
    protected String requirements;
    protected String copyright;
    protected List<StructureMapStructure> structure;
    @XmlElement(name="import")
    protected List<Uri> _import;
    @XmlElement(required=true)
    protected List<StructureMapGroup> group;

    public Uri getUrl() {
        return this.url;
    }

    public void setUrl(Uri value) {
        this.url = value;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String value) {
        this.version = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public ConformanceResourceStatus getStatus() {
        return this.status;
    }

    public void setStatus(ConformanceResourceStatus value) {
        this.status = value;
    }

    public Boolean getExperimental() {
        return this.experimental;
    }

    public void setExperimental(Boolean value) {
        this.experimental = value;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public void setPublisher(String value) {
        this.publisher = value;
    }

    public List<StructureMapContact> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<StructureMapContact>();
        }
        return this.contact;
    }

    public DateTime getDate() {
        return this.date;
    }

    public void setDate(DateTime value) {
        this.date = value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public List<CodeableConcept> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList<CodeableConcept>();
        }
        return this.useContext;
    }

    public String getRequirements() {
        return this.requirements;
    }

    public void setRequirements(String value) {
        this.requirements = value;
    }

    public String getCopyright() {
        return this.copyright;
    }

    public void setCopyright(String value) {
        this.copyright = value;
    }

    public List<StructureMapStructure> getStructure() {
        if (this.structure == null) {
            this.structure = new ArrayList<StructureMapStructure>();
        }
        return this.structure;
    }

    public List<Uri> getImport() {
        if (this._import == null) {
            this._import = new ArrayList<Uri>();
        }
        return this._import;
    }

    public List<StructureMapGroup> getGroup() {
        if (this.group == null) {
            this.group = new ArrayList<StructureMapGroup>();
        }
        return this.group;
    }

    public StructureMap withUrl(Uri value) {
        this.setUrl(value);
        return this;
    }

    public StructureMap withIdentifier(Identifier ... values) {
        if (values != null) {
            for (Identifier value : values) {
                this.getIdentifier().add(value);
            }
        }
        return this;
    }

    public StructureMap withIdentifier(Collection<Identifier> values) {
        if (values != null) {
            this.getIdentifier().addAll(values);
        }
        return this;
    }

    public StructureMap withVersion(String value) {
        this.setVersion(value);
        return this;
    }

    public StructureMap withName(String value) {
        this.setName(value);
        return this;
    }

    public StructureMap withStatus(ConformanceResourceStatus value) {
        this.setStatus(value);
        return this;
    }

    public StructureMap withExperimental(Boolean value) {
        this.setExperimental(value);
        return this;
    }

    public StructureMap withPublisher(String value) {
        this.setPublisher(value);
        return this;
    }

    public StructureMap withContact(StructureMapContact ... values) {
        if (values != null) {
            for (StructureMapContact value : values) {
                this.getContact().add(value);
            }
        }
        return this;
    }

    public StructureMap withContact(Collection<StructureMapContact> values) {
        if (values != null) {
            this.getContact().addAll(values);
        }
        return this;
    }

    public StructureMap withDate(DateTime value) {
        this.setDate(value);
        return this;
    }

    public StructureMap withDescription(String value) {
        this.setDescription(value);
        return this;
    }

    public StructureMap withUseContext(CodeableConcept ... values) {
        if (values != null) {
            for (CodeableConcept value : values) {
                this.getUseContext().add(value);
            }
        }
        return this;
    }

    public StructureMap withUseContext(Collection<CodeableConcept> values) {
        if (values != null) {
            this.getUseContext().addAll(values);
        }
        return this;
    }

    public StructureMap withRequirements(String value) {
        this.setRequirements(value);
        return this;
    }

    public StructureMap withCopyright(String value) {
        this.setCopyright(value);
        return this;
    }

    public StructureMap withStructure(StructureMapStructure ... values) {
        if (values != null) {
            for (StructureMapStructure value : values) {
                this.getStructure().add(value);
            }
        }
        return this;
    }

    public StructureMap withStructure(Collection<StructureMapStructure> values) {
        if (values != null) {
            this.getStructure().addAll(values);
        }
        return this;
    }

    public StructureMap withImport(Uri ... values) {
        if (values != null) {
            for (Uri value : values) {
                this.getImport().add(value);
            }
        }
        return this;
    }

    public StructureMap withImport(Collection<Uri> values) {
        if (values != null) {
            this.getImport().addAll(values);
        }
        return this;
    }

    public StructureMap withGroup(StructureMapGroup ... values) {
        if (values != null) {
            for (StructureMapGroup value : values) {
                this.getGroup().add(value);
            }
        }
        return this;
    }

    public StructureMap withGroup(Collection<StructureMapGroup> values) {
        if (values != null) {
            this.getGroup().addAll(values);
        }
        return this;
    }

    @Override
    public StructureMap withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public StructureMap withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public StructureMap withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public StructureMap withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public StructureMap withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public StructureMap withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public StructureMap withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public StructureMap withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public StructureMap withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public StructureMap withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public StructureMap withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        StructureMap that = (StructureMap)object;
        Uri lhsUrl = this.getUrl();
        Uri rhsUrl = that.getUrl();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "url", lhsUrl), (ObjectLocator)LocatorUtils.property(thatLocator, "url", rhsUrl), lhsUrl, rhsUrl, this.url != null, that.url != null)) {
            return false;
        }
        List<Identifier> lhsIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        List<Identifier> rhsIdentifier = that.identifier != null && !that.identifier.isEmpty() ? that.getIdentifier() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "identifier", lhsIdentifier), (ObjectLocator)LocatorUtils.property(thatLocator, "identifier", rhsIdentifier), lhsIdentifier, rhsIdentifier, this.identifier != null && !this.identifier.isEmpty(), that.identifier != null && !that.identifier.isEmpty())) {
            return false;
        }
        String lhsVersion = this.getVersion();
        String rhsVersion = that.getVersion();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "version", lhsVersion), (ObjectLocator)LocatorUtils.property(thatLocator, "version", rhsVersion), lhsVersion, rhsVersion, this.version != null, that.version != null)) {
            return false;
        }
        String lhsName = this.getName();
        String rhsName = that.getName();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "name", lhsName), (ObjectLocator)LocatorUtils.property(thatLocator, "name", rhsName), lhsName, rhsName, this.name != null, that.name != null)) {
            return false;
        }
        ConformanceResourceStatus lhsStatus = this.getStatus();
        ConformanceResourceStatus rhsStatus = that.getStatus();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "status", lhsStatus), (ObjectLocator)LocatorUtils.property(thatLocator, "status", rhsStatus), lhsStatus, rhsStatus, this.status != null, that.status != null)) {
            return false;
        }
        Boolean lhsExperimental = this.getExperimental();
        Boolean rhsExperimental = that.getExperimental();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "experimental", lhsExperimental), (ObjectLocator)LocatorUtils.property(thatLocator, "experimental", rhsExperimental), lhsExperimental, rhsExperimental, this.experimental != null, that.experimental != null)) {
            return false;
        }
        String lhsPublisher = this.getPublisher();
        String rhsPublisher = that.getPublisher();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "publisher", lhsPublisher), (ObjectLocator)LocatorUtils.property(thatLocator, "publisher", rhsPublisher), lhsPublisher, rhsPublisher, this.publisher != null, that.publisher != null)) {
            return false;
        }
        List<StructureMapContact> lhsContact = this.contact != null && !this.contact.isEmpty() ? this.getContact() : null;
        List<StructureMapContact> rhsContact = that.contact != null && !that.contact.isEmpty() ? that.getContact() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "contact", lhsContact), (ObjectLocator)LocatorUtils.property(thatLocator, "contact", rhsContact), lhsContact, rhsContact, this.contact != null && !this.contact.isEmpty(), that.contact != null && !that.contact.isEmpty())) {
            return false;
        }
        DateTime lhsDate = this.getDate();
        DateTime rhsDate = that.getDate();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "date", lhsDate), (ObjectLocator)LocatorUtils.property(thatLocator, "date", rhsDate), lhsDate, rhsDate, this.date != null, that.date != null)) {
            return false;
        }
        String lhsDescription = this.getDescription();
        String rhsDescription = that.getDescription();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "description", lhsDescription), (ObjectLocator)LocatorUtils.property(thatLocator, "description", rhsDescription), lhsDescription, rhsDescription, this.description != null, that.description != null)) {
            return false;
        }
        List<CodeableConcept> lhsUseContext = this.useContext != null && !this.useContext.isEmpty() ? this.getUseContext() : null;
        List<CodeableConcept> rhsUseContext = that.useContext != null && !that.useContext.isEmpty() ? that.getUseContext() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "useContext", lhsUseContext), (ObjectLocator)LocatorUtils.property(thatLocator, "useContext", rhsUseContext), lhsUseContext, rhsUseContext, this.useContext != null && !this.useContext.isEmpty(), that.useContext != null && !that.useContext.isEmpty())) {
            return false;
        }
        String lhsRequirements = this.getRequirements();
        String rhsRequirements = that.getRequirements();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "requirements", lhsRequirements), (ObjectLocator)LocatorUtils.property(thatLocator, "requirements", rhsRequirements), lhsRequirements, rhsRequirements, this.requirements != null, that.requirements != null)) {
            return false;
        }
        String lhsCopyright = this.getCopyright();
        String rhsCopyright = that.getCopyright();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "copyright", lhsCopyright), (ObjectLocator)LocatorUtils.property(thatLocator, "copyright", rhsCopyright), lhsCopyright, rhsCopyright, this.copyright != null, that.copyright != null)) {
            return false;
        }
        List<StructureMapStructure> lhsStructure = this.structure != null && !this.structure.isEmpty() ? this.getStructure() : null;
        List<StructureMapStructure> rhsStructure = that.structure != null && !that.structure.isEmpty() ? that.getStructure() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "structure", lhsStructure), (ObjectLocator)LocatorUtils.property(thatLocator, "structure", rhsStructure), lhsStructure, rhsStructure, this.structure != null && !this.structure.isEmpty(), that.structure != null && !that.structure.isEmpty())) {
            return false;
        }
        List<Uri> lhsImport = this._import != null && !this._import.isEmpty() ? this.getImport() : null;
        List<Uri> rhsImport = that._import != null && !that._import.isEmpty() ? that.getImport() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "_import", lhsImport), (ObjectLocator)LocatorUtils.property(thatLocator, "_import", rhsImport), lhsImport, rhsImport, this._import != null && !this._import.isEmpty(), that._import != null && !that._import.isEmpty())) {
            return false;
        }
        List<StructureMapGroup> lhsGroup = this.group != null && !this.group.isEmpty() ? this.getGroup() : null;
        List<StructureMapGroup> rhsGroup = that.group != null && !that.group.isEmpty() ? that.getGroup() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "group", lhsGroup), (ObjectLocator)LocatorUtils.property(thatLocator, "group", rhsGroup), lhsGroup, rhsGroup, this.group != null && !this.group.isEmpty(), that.group != null && !that.group.isEmpty());
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE2;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        Uri theUrl = this.getUrl();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "url", theUrl), currentHashCode, theUrl, this.url != null);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "identifier", theIdentifier), currentHashCode, theIdentifier, this.identifier != null && !this.identifier.isEmpty());
        String theVersion = this.getVersion();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "version", theVersion), currentHashCode, theVersion, this.version != null);
        String theName = this.getName();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "name", theName), currentHashCode, theName, this.name != null);
        ConformanceResourceStatus theStatus = this.getStatus();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "status", theStatus), currentHashCode, theStatus, this.status != null);
        Boolean theExperimental = this.getExperimental();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "experimental", theExperimental), currentHashCode, theExperimental, this.experimental != null);
        String thePublisher = this.getPublisher();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "publisher", thePublisher), currentHashCode, thePublisher, this.publisher != null);
        List<StructureMapContact> theContact = this.contact != null && !this.contact.isEmpty() ? this.getContact() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "contact", theContact), currentHashCode, theContact, this.contact != null && !this.contact.isEmpty());
        DateTime theDate = this.getDate();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "date", theDate), currentHashCode, theDate, this.date != null);
        String theDescription = this.getDescription();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "description", theDescription), currentHashCode, theDescription, this.description != null);
        List<CodeableConcept> theUseContext = this.useContext != null && !this.useContext.isEmpty() ? this.getUseContext() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "useContext", theUseContext), currentHashCode, theUseContext, this.useContext != null && !this.useContext.isEmpty());
        String theRequirements = this.getRequirements();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "requirements", theRequirements), currentHashCode, theRequirements, this.requirements != null);
        String theCopyright = this.getCopyright();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "copyright", theCopyright), currentHashCode, theCopyright, this.copyright != null);
        List<StructureMapStructure> theStructure = this.structure != null && !this.structure.isEmpty() ? this.getStructure() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "structure", theStructure), currentHashCode, theStructure, this.structure != null && !this.structure.isEmpty());
        List<Uri> theImport = this._import != null && !this._import.isEmpty() ? this.getImport() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "_import", theImport), currentHashCode, theImport, this._import != null && !this._import.isEmpty());
        List<StructureMapGroup> theGroup = this.group != null && !this.group.isEmpty() ? this.getGroup() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "group", theGroup), currentHashCode, theGroup, this.group != null && !this.group.isEmpty());
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE2;
        return this.hashCode(null, strategy);
    }

    @Override
    public java.lang.String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.INSTANCE2;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        Uri theUrl = this.getUrl();
        strategy.appendField(locator, (Object)this, "url", buffer, theUrl, this.url != null);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        strategy.appendField(locator, (Object)this, "identifier", buffer, theIdentifier, this.identifier != null && !this.identifier.isEmpty());
        String theVersion = this.getVersion();
        strategy.appendField(locator, (Object)this, "version", buffer, theVersion, this.version != null);
        String theName = this.getName();
        strategy.appendField(locator, (Object)this, "name", buffer, theName, this.name != null);
        ConformanceResourceStatus theStatus = this.getStatus();
        strategy.appendField(locator, (Object)this, "status", buffer, theStatus, this.status != null);
        Boolean theExperimental = this.getExperimental();
        strategy.appendField(locator, (Object)this, "experimental", buffer, theExperimental, this.experimental != null);
        String thePublisher = this.getPublisher();
        strategy.appendField(locator, (Object)this, "publisher", buffer, thePublisher, this.publisher != null);
        List<StructureMapContact> theContact = this.contact != null && !this.contact.isEmpty() ? this.getContact() : null;
        strategy.appendField(locator, (Object)this, "contact", buffer, theContact, this.contact != null && !this.contact.isEmpty());
        DateTime theDate = this.getDate();
        strategy.appendField(locator, (Object)this, "date", buffer, theDate, this.date != null);
        String theDescription = this.getDescription();
        strategy.appendField(locator, (Object)this, "description", buffer, theDescription, this.description != null);
        List<CodeableConcept> theUseContext = this.useContext != null && !this.useContext.isEmpty() ? this.getUseContext() : null;
        strategy.appendField(locator, (Object)this, "useContext", buffer, theUseContext, this.useContext != null && !this.useContext.isEmpty());
        String theRequirements = this.getRequirements();
        strategy.appendField(locator, (Object)this, "requirements", buffer, theRequirements, this.requirements != null);
        String theCopyright = this.getCopyright();
        strategy.appendField(locator, (Object)this, "copyright", buffer, theCopyright, this.copyright != null);
        List<StructureMapStructure> theStructure = this.structure != null && !this.structure.isEmpty() ? this.getStructure() : null;
        strategy.appendField(locator, (Object)this, "structure", buffer, theStructure, this.structure != null && !this.structure.isEmpty());
        List<Uri> theImport = this._import != null && !this._import.isEmpty() ? this.getImport() : null;
        strategy.appendField(locator, (Object)this, "_import", buffer, theImport, this._import != null && !this._import.isEmpty());
        List<StructureMapGroup> theGroup = this.group != null && !this.group.isEmpty() ? this.getGroup() : null;
        strategy.appendField(locator, (Object)this, "group", buffer, theGroup, this.group != null && !this.group.isEmpty());
        return buffer;
    }
}

