/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Boolean;
import org.hl7.fhir.Code;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.ConformanceResourceStatus;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.SearchParamType;
import org.hl7.fhir.SearchParameterContact;
import org.hl7.fhir.String;
import org.hl7.fhir.Uri;
import org.hl7.fhir.XPathUsageType;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="SearchParameter", propOrder={"url", "name", "status", "experimental", "date", "publisher", "contact", "useContext", "requirements", "code", "base", "type", "description", "expression", "xpath", "xpathUsage", "target"})
public class SearchParameter
extends DomainResource
implements Equals2,
HashCode2,
ToString2 {
    @XmlElement(required=true)
    protected Uri url;
    @XmlElement(required=true)
    protected String name;
    protected ConformanceResourceStatus status;
    protected Boolean experimental;
    protected DateTime date;
    protected String publisher;
    protected List<SearchParameterContact> contact;
    protected List<CodeableConcept> useContext;
    protected String requirements;
    @XmlElement(required=true)
    protected Code code;
    @XmlElement(required=true)
    protected Code base;
    @XmlElement(required=true)
    protected SearchParamType type;
    @XmlElement(required=true)
    protected String description;
    protected String expression;
    protected String xpath;
    protected XPathUsageType xpathUsage;
    protected List<Code> target;

    public Uri getUrl() {
        return this.url;
    }

    public void setUrl(Uri value) {
        this.url = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public ConformanceResourceStatus getStatus() {
        return this.status;
    }

    public void setStatus(ConformanceResourceStatus value) {
        this.status = value;
    }

    public Boolean getExperimental() {
        return this.experimental;
    }

    public void setExperimental(Boolean value) {
        this.experimental = value;
    }

    public DateTime getDate() {
        return this.date;
    }

    public void setDate(DateTime value) {
        this.date = value;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public void setPublisher(String value) {
        this.publisher = value;
    }

    public List<SearchParameterContact> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<SearchParameterContact>();
        }
        return this.contact;
    }

    public List<CodeableConcept> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList<CodeableConcept>();
        }
        return this.useContext;
    }

    public String getRequirements() {
        return this.requirements;
    }

    public void setRequirements(String value) {
        this.requirements = value;
    }

    public Code getCode() {
        return this.code;
    }

    public void setCode(Code value) {
        this.code = value;
    }

    public Code getBase() {
        return this.base;
    }

    public void setBase(Code value) {
        this.base = value;
    }

    public SearchParamType getType() {
        return this.type;
    }

    public void setType(SearchParamType value) {
        this.type = value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String value) {
        this.expression = value;
    }

    public String getXpath() {
        return this.xpath;
    }

    public void setXpath(String value) {
        this.xpath = value;
    }

    public XPathUsageType getXpathUsage() {
        return this.xpathUsage;
    }

    public void setXpathUsage(XPathUsageType value) {
        this.xpathUsage = value;
    }

    public List<Code> getTarget() {
        if (this.target == null) {
            this.target = new ArrayList<Code>();
        }
        return this.target;
    }

    public SearchParameter withUrl(Uri value) {
        this.setUrl(value);
        return this;
    }

    public SearchParameter withName(String value) {
        this.setName(value);
        return this;
    }

    public SearchParameter withStatus(ConformanceResourceStatus value) {
        this.setStatus(value);
        return this;
    }

    public SearchParameter withExperimental(Boolean value) {
        this.setExperimental(value);
        return this;
    }

    public SearchParameter withDate(DateTime value) {
        this.setDate(value);
        return this;
    }

    public SearchParameter withPublisher(String value) {
        this.setPublisher(value);
        return this;
    }

    public SearchParameter withContact(SearchParameterContact ... values) {
        if (values != null) {
            for (SearchParameterContact value : values) {
                this.getContact().add(value);
            }
        }
        return this;
    }

    public SearchParameter withContact(Collection<SearchParameterContact> values) {
        if (values != null) {
            this.getContact().addAll(values);
        }
        return this;
    }

    public SearchParameter withUseContext(CodeableConcept ... values) {
        if (values != null) {
            for (CodeableConcept value : values) {
                this.getUseContext().add(value);
            }
        }
        return this;
    }

    public SearchParameter withUseContext(Collection<CodeableConcept> values) {
        if (values != null) {
            this.getUseContext().addAll(values);
        }
        return this;
    }

    public SearchParameter withRequirements(String value) {
        this.setRequirements(value);
        return this;
    }

    public SearchParameter withCode(Code value) {
        this.setCode(value);
        return this;
    }

    public SearchParameter withBase(Code value) {
        this.setBase(value);
        return this;
    }

    public SearchParameter withType(SearchParamType value) {
        this.setType(value);
        return this;
    }

    public SearchParameter withDescription(String value) {
        this.setDescription(value);
        return this;
    }

    public SearchParameter withExpression(String value) {
        this.setExpression(value);
        return this;
    }

    public SearchParameter withXpath(String value) {
        this.setXpath(value);
        return this;
    }

    public SearchParameter withXpathUsage(XPathUsageType value) {
        this.setXpathUsage(value);
        return this;
    }

    public SearchParameter withTarget(Code ... values) {
        if (values != null) {
            for (Code value : values) {
                this.getTarget().add(value);
            }
        }
        return this;
    }

    public SearchParameter withTarget(Collection<Code> values) {
        if (values != null) {
            this.getTarget().addAll(values);
        }
        return this;
    }

    @Override
    public SearchParameter withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public SearchParameter withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public SearchParameter withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public SearchParameter withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public SearchParameter withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public SearchParameter withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public SearchParameter withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public SearchParameter withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public SearchParameter withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public SearchParameter withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public SearchParameter withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        SearchParameter that = (SearchParameter)object;
        Uri lhsUrl = this.getUrl();
        Uri rhsUrl = that.getUrl();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "url", lhsUrl), (ObjectLocator)LocatorUtils.property(thatLocator, "url", rhsUrl), lhsUrl, rhsUrl, this.url != null, that.url != null)) {
            return false;
        }
        String lhsName = this.getName();
        String rhsName = that.getName();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "name", lhsName), (ObjectLocator)LocatorUtils.property(thatLocator, "name", rhsName), lhsName, rhsName, this.name != null, that.name != null)) {
            return false;
        }
        ConformanceResourceStatus lhsStatus = this.getStatus();
        ConformanceResourceStatus rhsStatus = that.getStatus();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "status", lhsStatus), (ObjectLocator)LocatorUtils.property(thatLocator, "status", rhsStatus), lhsStatus, rhsStatus, this.status != null, that.status != null)) {
            return false;
        }
        Boolean lhsExperimental = this.getExperimental();
        Boolean rhsExperimental = that.getExperimental();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "experimental", lhsExperimental), (ObjectLocator)LocatorUtils.property(thatLocator, "experimental", rhsExperimental), lhsExperimental, rhsExperimental, this.experimental != null, that.experimental != null)) {
            return false;
        }
        DateTime lhsDate = this.getDate();
        DateTime rhsDate = that.getDate();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "date", lhsDate), (ObjectLocator)LocatorUtils.property(thatLocator, "date", rhsDate), lhsDate, rhsDate, this.date != null, that.date != null)) {
            return false;
        }
        String lhsPublisher = this.getPublisher();
        String rhsPublisher = that.getPublisher();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "publisher", lhsPublisher), (ObjectLocator)LocatorUtils.property(thatLocator, "publisher", rhsPublisher), lhsPublisher, rhsPublisher, this.publisher != null, that.publisher != null)) {
            return false;
        }
        List<SearchParameterContact> lhsContact = this.contact != null && !this.contact.isEmpty() ? this.getContact() : null;
        List<SearchParameterContact> rhsContact = that.contact != null && !that.contact.isEmpty() ? that.getContact() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "contact", lhsContact), (ObjectLocator)LocatorUtils.property(thatLocator, "contact", rhsContact), lhsContact, rhsContact, this.contact != null && !this.contact.isEmpty(), that.contact != null && !that.contact.isEmpty())) {
            return false;
        }
        List<CodeableConcept> lhsUseContext = this.useContext != null && !this.useContext.isEmpty() ? this.getUseContext() : null;
        List<CodeableConcept> rhsUseContext = that.useContext != null && !that.useContext.isEmpty() ? that.getUseContext() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "useContext", lhsUseContext), (ObjectLocator)LocatorUtils.property(thatLocator, "useContext", rhsUseContext), lhsUseContext, rhsUseContext, this.useContext != null && !this.useContext.isEmpty(), that.useContext != null && !that.useContext.isEmpty())) {
            return false;
        }
        String lhsRequirements = this.getRequirements();
        String rhsRequirements = that.getRequirements();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "requirements", lhsRequirements), (ObjectLocator)LocatorUtils.property(thatLocator, "requirements", rhsRequirements), lhsRequirements, rhsRequirements, this.requirements != null, that.requirements != null)) {
            return false;
        }
        Code lhsCode = this.getCode();
        Code rhsCode = that.getCode();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "code", lhsCode), (ObjectLocator)LocatorUtils.property(thatLocator, "code", rhsCode), lhsCode, rhsCode, this.code != null, that.code != null)) {
            return false;
        }
        Code lhsBase = this.getBase();
        Code rhsBase = that.getBase();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "base", lhsBase), (ObjectLocator)LocatorUtils.property(thatLocator, "base", rhsBase), lhsBase, rhsBase, this.base != null, that.base != null)) {
            return false;
        }
        SearchParamType lhsType = this.getType();
        SearchParamType rhsType = that.getType();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "type", lhsType), (ObjectLocator)LocatorUtils.property(thatLocator, "type", rhsType), lhsType, rhsType, this.type != null, that.type != null)) {
            return false;
        }
        String lhsDescription = this.getDescription();
        String rhsDescription = that.getDescription();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "description", lhsDescription), (ObjectLocator)LocatorUtils.property(thatLocator, "description", rhsDescription), lhsDescription, rhsDescription, this.description != null, that.description != null)) {
            return false;
        }
        String lhsExpression = this.getExpression();
        String rhsExpression = that.getExpression();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "expression", lhsExpression), (ObjectLocator)LocatorUtils.property(thatLocator, "expression", rhsExpression), lhsExpression, rhsExpression, this.expression != null, that.expression != null)) {
            return false;
        }
        String lhsXpath = this.getXpath();
        String rhsXpath = that.getXpath();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "xpath", lhsXpath), (ObjectLocator)LocatorUtils.property(thatLocator, "xpath", rhsXpath), lhsXpath, rhsXpath, this.xpath != null, that.xpath != null)) {
            return false;
        }
        XPathUsageType lhsXpathUsage = this.getXpathUsage();
        XPathUsageType rhsXpathUsage = that.getXpathUsage();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "xpathUsage", lhsXpathUsage), (ObjectLocator)LocatorUtils.property(thatLocator, "xpathUsage", rhsXpathUsage), lhsXpathUsage, rhsXpathUsage, this.xpathUsage != null, that.xpathUsage != null)) {
            return false;
        }
        List<Code> lhsTarget = this.target != null && !this.target.isEmpty() ? this.getTarget() : null;
        List<Code> rhsTarget = that.target != null && !that.target.isEmpty() ? that.getTarget() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "target", lhsTarget), (ObjectLocator)LocatorUtils.property(thatLocator, "target", rhsTarget), lhsTarget, rhsTarget, this.target != null && !this.target.isEmpty(), that.target != null && !that.target.isEmpty());
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE2;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        Uri theUrl = this.getUrl();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "url", theUrl), currentHashCode, theUrl, this.url != null);
        String theName = this.getName();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "name", theName), currentHashCode, theName, this.name != null);
        ConformanceResourceStatus theStatus = this.getStatus();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "status", theStatus), currentHashCode, theStatus, this.status != null);
        Boolean theExperimental = this.getExperimental();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "experimental", theExperimental), currentHashCode, theExperimental, this.experimental != null);
        DateTime theDate = this.getDate();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "date", theDate), currentHashCode, theDate, this.date != null);
        String thePublisher = this.getPublisher();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "publisher", thePublisher), currentHashCode, thePublisher, this.publisher != null);
        List<SearchParameterContact> theContact = this.contact != null && !this.contact.isEmpty() ? this.getContact() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "contact", theContact), currentHashCode, theContact, this.contact != null && !this.contact.isEmpty());
        List<CodeableConcept> theUseContext = this.useContext != null && !this.useContext.isEmpty() ? this.getUseContext() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "useContext", theUseContext), currentHashCode, theUseContext, this.useContext != null && !this.useContext.isEmpty());
        String theRequirements = this.getRequirements();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "requirements", theRequirements), currentHashCode, theRequirements, this.requirements != null);
        Code theCode = this.getCode();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "code", theCode), currentHashCode, theCode, this.code != null);
        Code theBase = this.getBase();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "base", theBase), currentHashCode, theBase, this.base != null);
        SearchParamType theType = this.getType();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "type", theType), currentHashCode, theType, this.type != null);
        String theDescription = this.getDescription();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "description", theDescription), currentHashCode, theDescription, this.description != null);
        String theExpression = this.getExpression();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "expression", theExpression), currentHashCode, theExpression, this.expression != null);
        String theXpath = this.getXpath();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "xpath", theXpath), currentHashCode, theXpath, this.xpath != null);
        XPathUsageType theXpathUsage = this.getXpathUsage();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "xpathUsage", theXpathUsage), currentHashCode, theXpathUsage, this.xpathUsage != null);
        List<Code> theTarget = this.target != null && !this.target.isEmpty() ? this.getTarget() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "target", theTarget), currentHashCode, theTarget, this.target != null && !this.target.isEmpty());
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE2;
        return this.hashCode(null, strategy);
    }

    @Override
    public java.lang.String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.INSTANCE2;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        Uri theUrl = this.getUrl();
        strategy.appendField(locator, (Object)this, "url", buffer, theUrl, this.url != null);
        String theName = this.getName();
        strategy.appendField(locator, (Object)this, "name", buffer, theName, this.name != null);
        ConformanceResourceStatus theStatus = this.getStatus();
        strategy.appendField(locator, (Object)this, "status", buffer, theStatus, this.status != null);
        Boolean theExperimental = this.getExperimental();
        strategy.appendField(locator, (Object)this, "experimental", buffer, theExperimental, this.experimental != null);
        DateTime theDate = this.getDate();
        strategy.appendField(locator, (Object)this, "date", buffer, theDate, this.date != null);
        String thePublisher = this.getPublisher();
        strategy.appendField(locator, (Object)this, "publisher", buffer, thePublisher, this.publisher != null);
        List<SearchParameterContact> theContact = this.contact != null && !this.contact.isEmpty() ? this.getContact() : null;
        strategy.appendField(locator, (Object)this, "contact", buffer, theContact, this.contact != null && !this.contact.isEmpty());
        List<CodeableConcept> theUseContext = this.useContext != null && !this.useContext.isEmpty() ? this.getUseContext() : null;
        strategy.appendField(locator, (Object)this, "useContext", buffer, theUseContext, this.useContext != null && !this.useContext.isEmpty());
        String theRequirements = this.getRequirements();
        strategy.appendField(locator, (Object)this, "requirements", buffer, theRequirements, this.requirements != null);
        Code theCode = this.getCode();
        strategy.appendField(locator, (Object)this, "code", buffer, theCode, this.code != null);
        Code theBase = this.getBase();
        strategy.appendField(locator, (Object)this, "base", buffer, theBase, this.base != null);
        SearchParamType theType = this.getType();
        strategy.appendField(locator, (Object)this, "type", buffer, theType, this.type != null);
        String theDescription = this.getDescription();
        strategy.appendField(locator, (Object)this, "description", buffer, theDescription, this.description != null);
        String theExpression = this.getExpression();
        strategy.appendField(locator, (Object)this, "expression", buffer, theExpression, this.expression != null);
        String theXpath = this.getXpath();
        strategy.appendField(locator, (Object)this, "xpath", buffer, theXpath, this.xpath != null);
        XPathUsageType theXpathUsage = this.getXpathUsage();
        strategy.appendField(locator, (Object)this, "xpathUsage", buffer, theXpathUsage, this.xpathUsage != null);
        List<Code> theTarget = this.target != null && !this.target.isEmpty() ? this.getTarget() : null;
        strategy.appendField(locator, (Object)this, "target", buffer, theTarget, this.target != null && !this.target.isEmpty());
        return buffer;
    }
}

