/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Code;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Period;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ReferralCategory;
import org.hl7.fhir.ReferralStatus;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.String;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ReferralRequest", propOrder={"identifier", "basedOn", "parent", "status", "category", "type", "priority", "patient", "context", "fulfillmentTime", "authored", "requester", "specialty", "recipient", "reason", "description", "serviceRequested", "supportingInformation"})
public class ReferralRequest
extends DomainResource
implements Equals2,
HashCode2,
ToString2 {
    protected List<Identifier> identifier;
    protected List<Reference> basedOn;
    protected Identifier parent;
    @XmlElement(required=true)
    protected ReferralStatus status;
    @XmlElement(required=true)
    protected ReferralCategory category;
    protected CodeableConcept type;
    protected CodeableConcept priority;
    protected Reference patient;
    protected Reference context;
    protected Period fulfillmentTime;
    protected DateTime authored;
    protected Reference requester;
    protected CodeableConcept specialty;
    protected List<Reference> recipient;
    protected CodeableConcept reason;
    protected String description;
    protected List<CodeableConcept> serviceRequested;
    protected List<Reference> supportingInformation;

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public List<Reference> getBasedOn() {
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        return this.basedOn;
    }

    public Identifier getParent() {
        return this.parent;
    }

    public void setParent(Identifier value) {
        this.parent = value;
    }

    public ReferralStatus getStatus() {
        return this.status;
    }

    public void setStatus(ReferralStatus value) {
        this.status = value;
    }

    public ReferralCategory getCategory() {
        return this.category;
    }

    public void setCategory(ReferralCategory value) {
        this.category = value;
    }

    public CodeableConcept getType() {
        return this.type;
    }

    public void setType(CodeableConcept value) {
        this.type = value;
    }

    public CodeableConcept getPriority() {
        return this.priority;
    }

    public void setPriority(CodeableConcept value) {
        this.priority = value;
    }

    public Reference getPatient() {
        return this.patient;
    }

    public void setPatient(Reference value) {
        this.patient = value;
    }

    public Reference getContext() {
        return this.context;
    }

    public void setContext(Reference value) {
        this.context = value;
    }

    public Period getFulfillmentTime() {
        return this.fulfillmentTime;
    }

    public void setFulfillmentTime(Period value) {
        this.fulfillmentTime = value;
    }

    public DateTime getAuthored() {
        return this.authored;
    }

    public void setAuthored(DateTime value) {
        this.authored = value;
    }

    public Reference getRequester() {
        return this.requester;
    }

    public void setRequester(Reference value) {
        this.requester = value;
    }

    public CodeableConcept getSpecialty() {
        return this.specialty;
    }

    public void setSpecialty(CodeableConcept value) {
        this.specialty = value;
    }

    public List<Reference> getRecipient() {
        if (this.recipient == null) {
            this.recipient = new ArrayList<Reference>();
        }
        return this.recipient;
    }

    public CodeableConcept getReason() {
        return this.reason;
    }

    public void setReason(CodeableConcept value) {
        this.reason = value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public List<CodeableConcept> getServiceRequested() {
        if (this.serviceRequested == null) {
            this.serviceRequested = new ArrayList<CodeableConcept>();
        }
        return this.serviceRequested;
    }

    public List<Reference> getSupportingInformation() {
        if (this.supportingInformation == null) {
            this.supportingInformation = new ArrayList<Reference>();
        }
        return this.supportingInformation;
    }

    public ReferralRequest withIdentifier(Identifier ... values) {
        if (values != null) {
            for (Identifier value : values) {
                this.getIdentifier().add(value);
            }
        }
        return this;
    }

    public ReferralRequest withIdentifier(Collection<Identifier> values) {
        if (values != null) {
            this.getIdentifier().addAll(values);
        }
        return this;
    }

    public ReferralRequest withBasedOn(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getBasedOn().add(value);
            }
        }
        return this;
    }

    public ReferralRequest withBasedOn(Collection<Reference> values) {
        if (values != null) {
            this.getBasedOn().addAll(values);
        }
        return this;
    }

    public ReferralRequest withParent(Identifier value) {
        this.setParent(value);
        return this;
    }

    public ReferralRequest withStatus(ReferralStatus value) {
        this.setStatus(value);
        return this;
    }

    public ReferralRequest withCategory(ReferralCategory value) {
        this.setCategory(value);
        return this;
    }

    public ReferralRequest withType(CodeableConcept value) {
        this.setType(value);
        return this;
    }

    public ReferralRequest withPriority(CodeableConcept value) {
        this.setPriority(value);
        return this;
    }

    public ReferralRequest withPatient(Reference value) {
        this.setPatient(value);
        return this;
    }

    public ReferralRequest withContext(Reference value) {
        this.setContext(value);
        return this;
    }

    public ReferralRequest withFulfillmentTime(Period value) {
        this.setFulfillmentTime(value);
        return this;
    }

    public ReferralRequest withAuthored(DateTime value) {
        this.setAuthored(value);
        return this;
    }

    public ReferralRequest withRequester(Reference value) {
        this.setRequester(value);
        return this;
    }

    public ReferralRequest withSpecialty(CodeableConcept value) {
        this.setSpecialty(value);
        return this;
    }

    public ReferralRequest withRecipient(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getRecipient().add(value);
            }
        }
        return this;
    }

    public ReferralRequest withRecipient(Collection<Reference> values) {
        if (values != null) {
            this.getRecipient().addAll(values);
        }
        return this;
    }

    public ReferralRequest withReason(CodeableConcept value) {
        this.setReason(value);
        return this;
    }

    public ReferralRequest withDescription(String value) {
        this.setDescription(value);
        return this;
    }

    public ReferralRequest withServiceRequested(CodeableConcept ... values) {
        if (values != null) {
            for (CodeableConcept value : values) {
                this.getServiceRequested().add(value);
            }
        }
        return this;
    }

    public ReferralRequest withServiceRequested(Collection<CodeableConcept> values) {
        if (values != null) {
            this.getServiceRequested().addAll(values);
        }
        return this;
    }

    public ReferralRequest withSupportingInformation(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getSupportingInformation().add(value);
            }
        }
        return this;
    }

    public ReferralRequest withSupportingInformation(Collection<Reference> values) {
        if (values != null) {
            this.getSupportingInformation().addAll(values);
        }
        return this;
    }

    @Override
    public ReferralRequest withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public ReferralRequest withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public ReferralRequest withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public ReferralRequest withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ReferralRequest withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ReferralRequest withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ReferralRequest withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ReferralRequest withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public ReferralRequest withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public ReferralRequest withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public ReferralRequest withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        ReferralRequest that = (ReferralRequest)object;
        List<Identifier> lhsIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        List<Identifier> rhsIdentifier = that.identifier != null && !that.identifier.isEmpty() ? that.getIdentifier() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "identifier", lhsIdentifier), (ObjectLocator)LocatorUtils.property(thatLocator, "identifier", rhsIdentifier), lhsIdentifier, rhsIdentifier, this.identifier != null && !this.identifier.isEmpty(), that.identifier != null && !that.identifier.isEmpty())) {
            return false;
        }
        List<Reference> lhsBasedOn = this.basedOn != null && !this.basedOn.isEmpty() ? this.getBasedOn() : null;
        List<Reference> rhsBasedOn = that.basedOn != null && !that.basedOn.isEmpty() ? that.getBasedOn() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "basedOn", lhsBasedOn), (ObjectLocator)LocatorUtils.property(thatLocator, "basedOn", rhsBasedOn), lhsBasedOn, rhsBasedOn, this.basedOn != null && !this.basedOn.isEmpty(), that.basedOn != null && !that.basedOn.isEmpty())) {
            return false;
        }
        Identifier lhsParent = this.getParent();
        Identifier rhsParent = that.getParent();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "parent", lhsParent), (ObjectLocator)LocatorUtils.property(thatLocator, "parent", rhsParent), lhsParent, rhsParent, this.parent != null, that.parent != null)) {
            return false;
        }
        ReferralStatus lhsStatus = this.getStatus();
        ReferralStatus rhsStatus = that.getStatus();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "status", lhsStatus), (ObjectLocator)LocatorUtils.property(thatLocator, "status", rhsStatus), lhsStatus, rhsStatus, this.status != null, that.status != null)) {
            return false;
        }
        ReferralCategory lhsCategory = this.getCategory();
        ReferralCategory rhsCategory = that.getCategory();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "category", lhsCategory), (ObjectLocator)LocatorUtils.property(thatLocator, "category", rhsCategory), lhsCategory, rhsCategory, this.category != null, that.category != null)) {
            return false;
        }
        CodeableConcept lhsType = this.getType();
        CodeableConcept rhsType = that.getType();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "type", lhsType), (ObjectLocator)LocatorUtils.property(thatLocator, "type", rhsType), lhsType, rhsType, this.type != null, that.type != null)) {
            return false;
        }
        CodeableConcept lhsPriority = this.getPriority();
        CodeableConcept rhsPriority = that.getPriority();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "priority", lhsPriority), (ObjectLocator)LocatorUtils.property(thatLocator, "priority", rhsPriority), lhsPriority, rhsPriority, this.priority != null, that.priority != null)) {
            return false;
        }
        Reference lhsPatient = this.getPatient();
        Reference rhsPatient = that.getPatient();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "patient", lhsPatient), (ObjectLocator)LocatorUtils.property(thatLocator, "patient", rhsPatient), lhsPatient, rhsPatient, this.patient != null, that.patient != null)) {
            return false;
        }
        Reference lhsContext = this.getContext();
        Reference rhsContext = that.getContext();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "context", lhsContext), (ObjectLocator)LocatorUtils.property(thatLocator, "context", rhsContext), lhsContext, rhsContext, this.context != null, that.context != null)) {
            return false;
        }
        Period lhsFulfillmentTime = this.getFulfillmentTime();
        Period rhsFulfillmentTime = that.getFulfillmentTime();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "fulfillmentTime", lhsFulfillmentTime), (ObjectLocator)LocatorUtils.property(thatLocator, "fulfillmentTime", rhsFulfillmentTime), lhsFulfillmentTime, rhsFulfillmentTime, this.fulfillmentTime != null, that.fulfillmentTime != null)) {
            return false;
        }
        DateTime lhsAuthored = this.getAuthored();
        DateTime rhsAuthored = that.getAuthored();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "authored", lhsAuthored), (ObjectLocator)LocatorUtils.property(thatLocator, "authored", rhsAuthored), lhsAuthored, rhsAuthored, this.authored != null, that.authored != null)) {
            return false;
        }
        Reference lhsRequester = this.getRequester();
        Reference rhsRequester = that.getRequester();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "requester", lhsRequester), (ObjectLocator)LocatorUtils.property(thatLocator, "requester", rhsRequester), lhsRequester, rhsRequester, this.requester != null, that.requester != null)) {
            return false;
        }
        CodeableConcept lhsSpecialty = this.getSpecialty();
        CodeableConcept rhsSpecialty = that.getSpecialty();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "specialty", lhsSpecialty), (ObjectLocator)LocatorUtils.property(thatLocator, "specialty", rhsSpecialty), lhsSpecialty, rhsSpecialty, this.specialty != null, that.specialty != null)) {
            return false;
        }
        List<Reference> lhsRecipient = this.recipient != null && !this.recipient.isEmpty() ? this.getRecipient() : null;
        List<Reference> rhsRecipient = that.recipient != null && !that.recipient.isEmpty() ? that.getRecipient() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "recipient", lhsRecipient), (ObjectLocator)LocatorUtils.property(thatLocator, "recipient", rhsRecipient), lhsRecipient, rhsRecipient, this.recipient != null && !this.recipient.isEmpty(), that.recipient != null && !that.recipient.isEmpty())) {
            return false;
        }
        CodeableConcept lhsReason = this.getReason();
        CodeableConcept rhsReason = that.getReason();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "reason", lhsReason), (ObjectLocator)LocatorUtils.property(thatLocator, "reason", rhsReason), lhsReason, rhsReason, this.reason != null, that.reason != null)) {
            return false;
        }
        String lhsDescription = this.getDescription();
        String rhsDescription = that.getDescription();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "description", lhsDescription), (ObjectLocator)LocatorUtils.property(thatLocator, "description", rhsDescription), lhsDescription, rhsDescription, this.description != null, that.description != null)) {
            return false;
        }
        List<CodeableConcept> lhsServiceRequested = this.serviceRequested != null && !this.serviceRequested.isEmpty() ? this.getServiceRequested() : null;
        List<CodeableConcept> rhsServiceRequested = that.serviceRequested != null && !that.serviceRequested.isEmpty() ? that.getServiceRequested() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "serviceRequested", lhsServiceRequested), (ObjectLocator)LocatorUtils.property(thatLocator, "serviceRequested", rhsServiceRequested), lhsServiceRequested, rhsServiceRequested, this.serviceRequested != null && !this.serviceRequested.isEmpty(), that.serviceRequested != null && !that.serviceRequested.isEmpty())) {
            return false;
        }
        List<Reference> lhsSupportingInformation = this.supportingInformation != null && !this.supportingInformation.isEmpty() ? this.getSupportingInformation() : null;
        List<Reference> rhsSupportingInformation = that.supportingInformation != null && !that.supportingInformation.isEmpty() ? that.getSupportingInformation() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "supportingInformation", lhsSupportingInformation), (ObjectLocator)LocatorUtils.property(thatLocator, "supportingInformation", rhsSupportingInformation), lhsSupportingInformation, rhsSupportingInformation, this.supportingInformation != null && !this.supportingInformation.isEmpty(), that.supportingInformation != null && !that.supportingInformation.isEmpty());
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE2;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "identifier", theIdentifier), currentHashCode, theIdentifier, this.identifier != null && !this.identifier.isEmpty());
        List<Reference> theBasedOn = this.basedOn != null && !this.basedOn.isEmpty() ? this.getBasedOn() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "basedOn", theBasedOn), currentHashCode, theBasedOn, this.basedOn != null && !this.basedOn.isEmpty());
        Identifier theParent = this.getParent();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "parent", theParent), currentHashCode, theParent, this.parent != null);
        ReferralStatus theStatus = this.getStatus();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "status", theStatus), currentHashCode, theStatus, this.status != null);
        ReferralCategory theCategory = this.getCategory();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "category", theCategory), currentHashCode, theCategory, this.category != null);
        CodeableConcept theType = this.getType();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "type", theType), currentHashCode, theType, this.type != null);
        CodeableConcept thePriority = this.getPriority();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "priority", thePriority), currentHashCode, thePriority, this.priority != null);
        Reference thePatient = this.getPatient();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "patient", thePatient), currentHashCode, thePatient, this.patient != null);
        Reference theContext = this.getContext();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "context", theContext), currentHashCode, theContext, this.context != null);
        Period theFulfillmentTime = this.getFulfillmentTime();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "fulfillmentTime", theFulfillmentTime), currentHashCode, theFulfillmentTime, this.fulfillmentTime != null);
        DateTime theAuthored = this.getAuthored();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "authored", theAuthored), currentHashCode, theAuthored, this.authored != null);
        Reference theRequester = this.getRequester();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "requester", theRequester), currentHashCode, theRequester, this.requester != null);
        CodeableConcept theSpecialty = this.getSpecialty();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "specialty", theSpecialty), currentHashCode, theSpecialty, this.specialty != null);
        List<Reference> theRecipient = this.recipient != null && !this.recipient.isEmpty() ? this.getRecipient() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "recipient", theRecipient), currentHashCode, theRecipient, this.recipient != null && !this.recipient.isEmpty());
        CodeableConcept theReason = this.getReason();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "reason", theReason), currentHashCode, theReason, this.reason != null);
        String theDescription = this.getDescription();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "description", theDescription), currentHashCode, theDescription, this.description != null);
        List<CodeableConcept> theServiceRequested = this.serviceRequested != null && !this.serviceRequested.isEmpty() ? this.getServiceRequested() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "serviceRequested", theServiceRequested), currentHashCode, theServiceRequested, this.serviceRequested != null && !this.serviceRequested.isEmpty());
        List<Reference> theSupportingInformation = this.supportingInformation != null && !this.supportingInformation.isEmpty() ? this.getSupportingInformation() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "supportingInformation", theSupportingInformation), currentHashCode, theSupportingInformation, this.supportingInformation != null && !this.supportingInformation.isEmpty());
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE2;
        return this.hashCode(null, strategy);
    }

    @Override
    public java.lang.String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.INSTANCE2;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        strategy.appendField(locator, (Object)this, "identifier", buffer, theIdentifier, this.identifier != null && !this.identifier.isEmpty());
        List<Reference> theBasedOn = this.basedOn != null && !this.basedOn.isEmpty() ? this.getBasedOn() : null;
        strategy.appendField(locator, (Object)this, "basedOn", buffer, theBasedOn, this.basedOn != null && !this.basedOn.isEmpty());
        Identifier theParent = this.getParent();
        strategy.appendField(locator, (Object)this, "parent", buffer, theParent, this.parent != null);
        ReferralStatus theStatus = this.getStatus();
        strategy.appendField(locator, (Object)this, "status", buffer, theStatus, this.status != null);
        ReferralCategory theCategory = this.getCategory();
        strategy.appendField(locator, (Object)this, "category", buffer, theCategory, this.category != null);
        CodeableConcept theType = this.getType();
        strategy.appendField(locator, (Object)this, "type", buffer, theType, this.type != null);
        CodeableConcept thePriority = this.getPriority();
        strategy.appendField(locator, (Object)this, "priority", buffer, thePriority, this.priority != null);
        Reference thePatient = this.getPatient();
        strategy.appendField(locator, (Object)this, "patient", buffer, thePatient, this.patient != null);
        Reference theContext = this.getContext();
        strategy.appendField(locator, (Object)this, "context", buffer, theContext, this.context != null);
        Period theFulfillmentTime = this.getFulfillmentTime();
        strategy.appendField(locator, (Object)this, "fulfillmentTime", buffer, theFulfillmentTime, this.fulfillmentTime != null);
        DateTime theAuthored = this.getAuthored();
        strategy.appendField(locator, (Object)this, "authored", buffer, theAuthored, this.authored != null);
        Reference theRequester = this.getRequester();
        strategy.appendField(locator, (Object)this, "requester", buffer, theRequester, this.requester != null);
        CodeableConcept theSpecialty = this.getSpecialty();
        strategy.appendField(locator, (Object)this, "specialty", buffer, theSpecialty, this.specialty != null);
        List<Reference> theRecipient = this.recipient != null && !this.recipient.isEmpty() ? this.getRecipient() : null;
        strategy.appendField(locator, (Object)this, "recipient", buffer, theRecipient, this.recipient != null && !this.recipient.isEmpty());
        CodeableConcept theReason = this.getReason();
        strategy.appendField(locator, (Object)this, "reason", buffer, theReason, this.reason != null);
        String theDescription = this.getDescription();
        strategy.appendField(locator, (Object)this, "description", buffer, theDescription, this.description != null);
        List<CodeableConcept> theServiceRequested = this.serviceRequested != null && !this.serviceRequested.isEmpty() ? this.getServiceRequested() : null;
        strategy.appendField(locator, (Object)this, "serviceRequested", buffer, theServiceRequested, this.serviceRequested != null && !this.serviceRequested.isEmpty());
        List<Reference> theSupportingInformation = this.supportingInformation != null && !this.supportingInformation.isEmpty() ? this.getSupportingInformation() : null;
        strategy.appendField(locator, (Object)this, "supportingInformation", buffer, theSupportingInformation, this.supportingInformation != null && !this.supportingInformation.isEmpty());
        return buffer;
    }
}

