/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Annotation;
import org.hl7.fhir.Boolean;
import org.hl7.fhir.Code;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Period;
import org.hl7.fhir.ProcedureRequestPriority;
import org.hl7.fhir.ProcedureRequestStatus;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.Timing;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ProcedureRequest", propOrder={"identifier", "subject", "code", "bodySite", "reasonCodeableConcept", "reasonReference", "scheduledDateTime", "scheduledPeriod", "scheduledTiming", "encounter", "performer", "status", "notes", "asNeededBoolean", "asNeededCodeableConcept", "orderedOn", "orderer", "priority"})
public class ProcedureRequest
extends DomainResource
implements Equals2,
HashCode2,
ToString2 {
    protected List<Identifier> identifier;
    @XmlElement(required=true)
    protected Reference subject;
    @XmlElement(required=true)
    protected CodeableConcept code;
    protected List<CodeableConcept> bodySite;
    protected CodeableConcept reasonCodeableConcept;
    protected Reference reasonReference;
    protected DateTime scheduledDateTime;
    protected Period scheduledPeriod;
    protected Timing scheduledTiming;
    protected Reference encounter;
    protected Reference performer;
    protected ProcedureRequestStatus status;
    protected List<Annotation> notes;
    protected Boolean asNeededBoolean;
    protected CodeableConcept asNeededCodeableConcept;
    protected DateTime orderedOn;
    protected Reference orderer;
    protected ProcedureRequestPriority priority;

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Reference getSubject() {
        return this.subject;
    }

    public void setSubject(Reference value) {
        this.subject = value;
    }

    public CodeableConcept getCode() {
        return this.code;
    }

    public void setCode(CodeableConcept value) {
        this.code = value;
    }

    public List<CodeableConcept> getBodySite() {
        if (this.bodySite == null) {
            this.bodySite = new ArrayList<CodeableConcept>();
        }
        return this.bodySite;
    }

    public CodeableConcept getReasonCodeableConcept() {
        return this.reasonCodeableConcept;
    }

    public void setReasonCodeableConcept(CodeableConcept value) {
        this.reasonCodeableConcept = value;
    }

    public Reference getReasonReference() {
        return this.reasonReference;
    }

    public void setReasonReference(Reference value) {
        this.reasonReference = value;
    }

    public DateTime getScheduledDateTime() {
        return this.scheduledDateTime;
    }

    public void setScheduledDateTime(DateTime value) {
        this.scheduledDateTime = value;
    }

    public Period getScheduledPeriod() {
        return this.scheduledPeriod;
    }

    public void setScheduledPeriod(Period value) {
        this.scheduledPeriod = value;
    }

    public Timing getScheduledTiming() {
        return this.scheduledTiming;
    }

    public void setScheduledTiming(Timing value) {
        this.scheduledTiming = value;
    }

    public Reference getEncounter() {
        return this.encounter;
    }

    public void setEncounter(Reference value) {
        this.encounter = value;
    }

    public Reference getPerformer() {
        return this.performer;
    }

    public void setPerformer(Reference value) {
        this.performer = value;
    }

    public ProcedureRequestStatus getStatus() {
        return this.status;
    }

    public void setStatus(ProcedureRequestStatus value) {
        this.status = value;
    }

    public List<Annotation> getNotes() {
        if (this.notes == null) {
            this.notes = new ArrayList<Annotation>();
        }
        return this.notes;
    }

    public Boolean getAsNeededBoolean() {
        return this.asNeededBoolean;
    }

    public void setAsNeededBoolean(Boolean value) {
        this.asNeededBoolean = value;
    }

    public CodeableConcept getAsNeededCodeableConcept() {
        return this.asNeededCodeableConcept;
    }

    public void setAsNeededCodeableConcept(CodeableConcept value) {
        this.asNeededCodeableConcept = value;
    }

    public DateTime getOrderedOn() {
        return this.orderedOn;
    }

    public void setOrderedOn(DateTime value) {
        this.orderedOn = value;
    }

    public Reference getOrderer() {
        return this.orderer;
    }

    public void setOrderer(Reference value) {
        this.orderer = value;
    }

    public ProcedureRequestPriority getPriority() {
        return this.priority;
    }

    public void setPriority(ProcedureRequestPriority value) {
        this.priority = value;
    }

    public ProcedureRequest withIdentifier(Identifier ... values) {
        if (values != null) {
            for (Identifier value : values) {
                this.getIdentifier().add(value);
            }
        }
        return this;
    }

    public ProcedureRequest withIdentifier(Collection<Identifier> values) {
        if (values != null) {
            this.getIdentifier().addAll(values);
        }
        return this;
    }

    public ProcedureRequest withSubject(Reference value) {
        this.setSubject(value);
        return this;
    }

    public ProcedureRequest withCode(CodeableConcept value) {
        this.setCode(value);
        return this;
    }

    public ProcedureRequest withBodySite(CodeableConcept ... values) {
        if (values != null) {
            for (CodeableConcept value : values) {
                this.getBodySite().add(value);
            }
        }
        return this;
    }

    public ProcedureRequest withBodySite(Collection<CodeableConcept> values) {
        if (values != null) {
            this.getBodySite().addAll(values);
        }
        return this;
    }

    public ProcedureRequest withReasonCodeableConcept(CodeableConcept value) {
        this.setReasonCodeableConcept(value);
        return this;
    }

    public ProcedureRequest withReasonReference(Reference value) {
        this.setReasonReference(value);
        return this;
    }

    public ProcedureRequest withScheduledDateTime(DateTime value) {
        this.setScheduledDateTime(value);
        return this;
    }

    public ProcedureRequest withScheduledPeriod(Period value) {
        this.setScheduledPeriod(value);
        return this;
    }

    public ProcedureRequest withScheduledTiming(Timing value) {
        this.setScheduledTiming(value);
        return this;
    }

    public ProcedureRequest withEncounter(Reference value) {
        this.setEncounter(value);
        return this;
    }

    public ProcedureRequest withPerformer(Reference value) {
        this.setPerformer(value);
        return this;
    }

    public ProcedureRequest withStatus(ProcedureRequestStatus value) {
        this.setStatus(value);
        return this;
    }

    public ProcedureRequest withNotes(Annotation ... values) {
        if (values != null) {
            for (Annotation value : values) {
                this.getNotes().add(value);
            }
        }
        return this;
    }

    public ProcedureRequest withNotes(Collection<Annotation> values) {
        if (values != null) {
            this.getNotes().addAll(values);
        }
        return this;
    }

    public ProcedureRequest withAsNeededBoolean(Boolean value) {
        this.setAsNeededBoolean(value);
        return this;
    }

    public ProcedureRequest withAsNeededCodeableConcept(CodeableConcept value) {
        this.setAsNeededCodeableConcept(value);
        return this;
    }

    public ProcedureRequest withOrderedOn(DateTime value) {
        this.setOrderedOn(value);
        return this;
    }

    public ProcedureRequest withOrderer(Reference value) {
        this.setOrderer(value);
        return this;
    }

    public ProcedureRequest withPriority(ProcedureRequestPriority value) {
        this.setPriority(value);
        return this;
    }

    @Override
    public ProcedureRequest withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public ProcedureRequest withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public ProcedureRequest withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public ProcedureRequest withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ProcedureRequest withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ProcedureRequest withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ProcedureRequest withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ProcedureRequest withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public ProcedureRequest withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public ProcedureRequest withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public ProcedureRequest withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        ProcedureRequest that = (ProcedureRequest)object;
        List<Identifier> lhsIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        List<Identifier> rhsIdentifier = that.identifier != null && !that.identifier.isEmpty() ? that.getIdentifier() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "identifier", lhsIdentifier), (ObjectLocator)LocatorUtils.property(thatLocator, "identifier", rhsIdentifier), lhsIdentifier, rhsIdentifier, this.identifier != null && !this.identifier.isEmpty(), that.identifier != null && !that.identifier.isEmpty())) {
            return false;
        }
        Reference lhsSubject = this.getSubject();
        Reference rhsSubject = that.getSubject();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "subject", lhsSubject), (ObjectLocator)LocatorUtils.property(thatLocator, "subject", rhsSubject), lhsSubject, rhsSubject, this.subject != null, that.subject != null)) {
            return false;
        }
        CodeableConcept lhsCode = this.getCode();
        CodeableConcept rhsCode = that.getCode();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "code", lhsCode), (ObjectLocator)LocatorUtils.property(thatLocator, "code", rhsCode), lhsCode, rhsCode, this.code != null, that.code != null)) {
            return false;
        }
        List<CodeableConcept> lhsBodySite = this.bodySite != null && !this.bodySite.isEmpty() ? this.getBodySite() : null;
        List<CodeableConcept> rhsBodySite = that.bodySite != null && !that.bodySite.isEmpty() ? that.getBodySite() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "bodySite", lhsBodySite), (ObjectLocator)LocatorUtils.property(thatLocator, "bodySite", rhsBodySite), lhsBodySite, rhsBodySite, this.bodySite != null && !this.bodySite.isEmpty(), that.bodySite != null && !that.bodySite.isEmpty())) {
            return false;
        }
        CodeableConcept lhsReasonCodeableConcept = this.getReasonCodeableConcept();
        CodeableConcept rhsReasonCodeableConcept = that.getReasonCodeableConcept();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "reasonCodeableConcept", lhsReasonCodeableConcept), (ObjectLocator)LocatorUtils.property(thatLocator, "reasonCodeableConcept", rhsReasonCodeableConcept), lhsReasonCodeableConcept, rhsReasonCodeableConcept, this.reasonCodeableConcept != null, that.reasonCodeableConcept != null)) {
            return false;
        }
        Reference lhsReasonReference = this.getReasonReference();
        Reference rhsReasonReference = that.getReasonReference();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "reasonReference", lhsReasonReference), (ObjectLocator)LocatorUtils.property(thatLocator, "reasonReference", rhsReasonReference), lhsReasonReference, rhsReasonReference, this.reasonReference != null, that.reasonReference != null)) {
            return false;
        }
        DateTime lhsScheduledDateTime = this.getScheduledDateTime();
        DateTime rhsScheduledDateTime = that.getScheduledDateTime();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "scheduledDateTime", lhsScheduledDateTime), (ObjectLocator)LocatorUtils.property(thatLocator, "scheduledDateTime", rhsScheduledDateTime), lhsScheduledDateTime, rhsScheduledDateTime, this.scheduledDateTime != null, that.scheduledDateTime != null)) {
            return false;
        }
        Period lhsScheduledPeriod = this.getScheduledPeriod();
        Period rhsScheduledPeriod = that.getScheduledPeriod();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "scheduledPeriod", lhsScheduledPeriod), (ObjectLocator)LocatorUtils.property(thatLocator, "scheduledPeriod", rhsScheduledPeriod), lhsScheduledPeriod, rhsScheduledPeriod, this.scheduledPeriod != null, that.scheduledPeriod != null)) {
            return false;
        }
        Timing lhsScheduledTiming = this.getScheduledTiming();
        Timing rhsScheduledTiming = that.getScheduledTiming();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "scheduledTiming", lhsScheduledTiming), (ObjectLocator)LocatorUtils.property(thatLocator, "scheduledTiming", rhsScheduledTiming), lhsScheduledTiming, rhsScheduledTiming, this.scheduledTiming != null, that.scheduledTiming != null)) {
            return false;
        }
        Reference lhsEncounter = this.getEncounter();
        Reference rhsEncounter = that.getEncounter();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "encounter", lhsEncounter), (ObjectLocator)LocatorUtils.property(thatLocator, "encounter", rhsEncounter), lhsEncounter, rhsEncounter, this.encounter != null, that.encounter != null)) {
            return false;
        }
        Reference lhsPerformer = this.getPerformer();
        Reference rhsPerformer = that.getPerformer();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "performer", lhsPerformer), (ObjectLocator)LocatorUtils.property(thatLocator, "performer", rhsPerformer), lhsPerformer, rhsPerformer, this.performer != null, that.performer != null)) {
            return false;
        }
        ProcedureRequestStatus lhsStatus = this.getStatus();
        ProcedureRequestStatus rhsStatus = that.getStatus();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "status", lhsStatus), (ObjectLocator)LocatorUtils.property(thatLocator, "status", rhsStatus), lhsStatus, rhsStatus, this.status != null, that.status != null)) {
            return false;
        }
        List<Annotation> lhsNotes = this.notes != null && !this.notes.isEmpty() ? this.getNotes() : null;
        List<Annotation> rhsNotes = that.notes != null && !that.notes.isEmpty() ? that.getNotes() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "notes", lhsNotes), (ObjectLocator)LocatorUtils.property(thatLocator, "notes", rhsNotes), lhsNotes, rhsNotes, this.notes != null && !this.notes.isEmpty(), that.notes != null && !that.notes.isEmpty())) {
            return false;
        }
        Boolean lhsAsNeededBoolean = this.getAsNeededBoolean();
        Boolean rhsAsNeededBoolean = that.getAsNeededBoolean();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "asNeededBoolean", lhsAsNeededBoolean), (ObjectLocator)LocatorUtils.property(thatLocator, "asNeededBoolean", rhsAsNeededBoolean), lhsAsNeededBoolean, rhsAsNeededBoolean, this.asNeededBoolean != null, that.asNeededBoolean != null)) {
            return false;
        }
        CodeableConcept lhsAsNeededCodeableConcept = this.getAsNeededCodeableConcept();
        CodeableConcept rhsAsNeededCodeableConcept = that.getAsNeededCodeableConcept();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "asNeededCodeableConcept", lhsAsNeededCodeableConcept), (ObjectLocator)LocatorUtils.property(thatLocator, "asNeededCodeableConcept", rhsAsNeededCodeableConcept), lhsAsNeededCodeableConcept, rhsAsNeededCodeableConcept, this.asNeededCodeableConcept != null, that.asNeededCodeableConcept != null)) {
            return false;
        }
        DateTime lhsOrderedOn = this.getOrderedOn();
        DateTime rhsOrderedOn = that.getOrderedOn();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "orderedOn", lhsOrderedOn), (ObjectLocator)LocatorUtils.property(thatLocator, "orderedOn", rhsOrderedOn), lhsOrderedOn, rhsOrderedOn, this.orderedOn != null, that.orderedOn != null)) {
            return false;
        }
        Reference lhsOrderer = this.getOrderer();
        Reference rhsOrderer = that.getOrderer();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "orderer", lhsOrderer), (ObjectLocator)LocatorUtils.property(thatLocator, "orderer", rhsOrderer), lhsOrderer, rhsOrderer, this.orderer != null, that.orderer != null)) {
            return false;
        }
        ProcedureRequestPriority lhsPriority = this.getPriority();
        ProcedureRequestPriority rhsPriority = that.getPriority();
        return strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "priority", lhsPriority), (ObjectLocator)LocatorUtils.property(thatLocator, "priority", rhsPriority), lhsPriority, rhsPriority, this.priority != null, that.priority != null);
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE2;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "identifier", theIdentifier), currentHashCode, theIdentifier, this.identifier != null && !this.identifier.isEmpty());
        Reference theSubject = this.getSubject();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "subject", theSubject), currentHashCode, theSubject, this.subject != null);
        CodeableConcept theCode = this.getCode();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "code", theCode), currentHashCode, theCode, this.code != null);
        List<CodeableConcept> theBodySite = this.bodySite != null && !this.bodySite.isEmpty() ? this.getBodySite() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "bodySite", theBodySite), currentHashCode, theBodySite, this.bodySite != null && !this.bodySite.isEmpty());
        CodeableConcept theReasonCodeableConcept = this.getReasonCodeableConcept();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "reasonCodeableConcept", theReasonCodeableConcept), currentHashCode, theReasonCodeableConcept, this.reasonCodeableConcept != null);
        Reference theReasonReference = this.getReasonReference();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "reasonReference", theReasonReference), currentHashCode, theReasonReference, this.reasonReference != null);
        DateTime theScheduledDateTime = this.getScheduledDateTime();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "scheduledDateTime", theScheduledDateTime), currentHashCode, theScheduledDateTime, this.scheduledDateTime != null);
        Period theScheduledPeriod = this.getScheduledPeriod();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "scheduledPeriod", theScheduledPeriod), currentHashCode, theScheduledPeriod, this.scheduledPeriod != null);
        Timing theScheduledTiming = this.getScheduledTiming();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "scheduledTiming", theScheduledTiming), currentHashCode, theScheduledTiming, this.scheduledTiming != null);
        Reference theEncounter = this.getEncounter();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "encounter", theEncounter), currentHashCode, theEncounter, this.encounter != null);
        Reference thePerformer = this.getPerformer();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "performer", thePerformer), currentHashCode, thePerformer, this.performer != null);
        ProcedureRequestStatus theStatus = this.getStatus();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "status", theStatus), currentHashCode, theStatus, this.status != null);
        List<Annotation> theNotes = this.notes != null && !this.notes.isEmpty() ? this.getNotes() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "notes", theNotes), currentHashCode, theNotes, this.notes != null && !this.notes.isEmpty());
        Boolean theAsNeededBoolean = this.getAsNeededBoolean();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "asNeededBoolean", theAsNeededBoolean), currentHashCode, theAsNeededBoolean, this.asNeededBoolean != null);
        CodeableConcept theAsNeededCodeableConcept = this.getAsNeededCodeableConcept();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "asNeededCodeableConcept", theAsNeededCodeableConcept), currentHashCode, theAsNeededCodeableConcept, this.asNeededCodeableConcept != null);
        DateTime theOrderedOn = this.getOrderedOn();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "orderedOn", theOrderedOn), currentHashCode, theOrderedOn, this.orderedOn != null);
        Reference theOrderer = this.getOrderer();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "orderer", theOrderer), currentHashCode, theOrderer, this.orderer != null);
        ProcedureRequestPriority thePriority = this.getPriority();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "priority", thePriority), currentHashCode, thePriority, this.priority != null);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE2;
        return this.hashCode(null, strategy);
    }

    @Override
    public String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.INSTANCE2;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        strategy.appendField(locator, (Object)this, "identifier", buffer, theIdentifier, this.identifier != null && !this.identifier.isEmpty());
        Reference theSubject = this.getSubject();
        strategy.appendField(locator, (Object)this, "subject", buffer, theSubject, this.subject != null);
        CodeableConcept theCode = this.getCode();
        strategy.appendField(locator, (Object)this, "code", buffer, theCode, this.code != null);
        List<CodeableConcept> theBodySite = this.bodySite != null && !this.bodySite.isEmpty() ? this.getBodySite() : null;
        strategy.appendField(locator, (Object)this, "bodySite", buffer, theBodySite, this.bodySite != null && !this.bodySite.isEmpty());
        CodeableConcept theReasonCodeableConcept = this.getReasonCodeableConcept();
        strategy.appendField(locator, (Object)this, "reasonCodeableConcept", buffer, theReasonCodeableConcept, this.reasonCodeableConcept != null);
        Reference theReasonReference = this.getReasonReference();
        strategy.appendField(locator, (Object)this, "reasonReference", buffer, theReasonReference, this.reasonReference != null);
        DateTime theScheduledDateTime = this.getScheduledDateTime();
        strategy.appendField(locator, (Object)this, "scheduledDateTime", buffer, theScheduledDateTime, this.scheduledDateTime != null);
        Period theScheduledPeriod = this.getScheduledPeriod();
        strategy.appendField(locator, (Object)this, "scheduledPeriod", buffer, theScheduledPeriod, this.scheduledPeriod != null);
        Timing theScheduledTiming = this.getScheduledTiming();
        strategy.appendField(locator, (Object)this, "scheduledTiming", buffer, theScheduledTiming, this.scheduledTiming != null);
        Reference theEncounter = this.getEncounter();
        strategy.appendField(locator, (Object)this, "encounter", buffer, theEncounter, this.encounter != null);
        Reference thePerformer = this.getPerformer();
        strategy.appendField(locator, (Object)this, "performer", buffer, thePerformer, this.performer != null);
        ProcedureRequestStatus theStatus = this.getStatus();
        strategy.appendField(locator, (Object)this, "status", buffer, theStatus, this.status != null);
        List<Annotation> theNotes = this.notes != null && !this.notes.isEmpty() ? this.getNotes() : null;
        strategy.appendField(locator, (Object)this, "notes", buffer, theNotes, this.notes != null && !this.notes.isEmpty());
        Boolean theAsNeededBoolean = this.getAsNeededBoolean();
        strategy.appendField(locator, (Object)this, "asNeededBoolean", buffer, theAsNeededBoolean, this.asNeededBoolean != null);
        CodeableConcept theAsNeededCodeableConcept = this.getAsNeededCodeableConcept();
        strategy.appendField(locator, (Object)this, "asNeededCodeableConcept", buffer, theAsNeededCodeableConcept, this.asNeededCodeableConcept != null);
        DateTime theOrderedOn = this.getOrderedOn();
        strategy.appendField(locator, (Object)this, "orderedOn", buffer, theOrderedOn, this.orderedOn != null);
        Reference theOrderer = this.getOrderer();
        strategy.appendField(locator, (Object)this, "orderer", buffer, theOrderer, this.orderer != null);
        ProcedureRequestPriority thePriority = this.getPriority();
        strategy.appendField(locator, (Object)this, "priority", buffer, thePriority, this.priority != null);
        return buffer;
    }
}

