/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Code;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.ConformanceResourceStatus;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Meta;
import org.hl7.fhir.NamingSystemContact;
import org.hl7.fhir.NamingSystemType;
import org.hl7.fhir.NamingSystemUniqueId;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.String;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="NamingSystem", propOrder={"name", "status", "kind", "date", "publisher", "contact", "responsible", "type", "description", "useContext", "usage", "uniqueId", "replacedBy"})
public class NamingSystem
extends DomainResource
implements Equals2,
HashCode2,
ToString2 {
    @XmlElement(required=true)
    protected String name;
    @XmlElement(required=true)
    protected ConformanceResourceStatus status;
    @XmlElement(required=true)
    protected NamingSystemType kind;
    @XmlElement(required=true)
    protected DateTime date;
    protected String publisher;
    protected List<NamingSystemContact> contact;
    protected String responsible;
    protected CodeableConcept type;
    protected String description;
    protected List<CodeableConcept> useContext;
    protected String usage;
    @XmlElement(required=true)
    protected List<NamingSystemUniqueId> uniqueId;
    protected Reference replacedBy;

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public ConformanceResourceStatus getStatus() {
        return this.status;
    }

    public void setStatus(ConformanceResourceStatus value) {
        this.status = value;
    }

    public NamingSystemType getKind() {
        return this.kind;
    }

    public void setKind(NamingSystemType value) {
        this.kind = value;
    }

    public DateTime getDate() {
        return this.date;
    }

    public void setDate(DateTime value) {
        this.date = value;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public void setPublisher(String value) {
        this.publisher = value;
    }

    public List<NamingSystemContact> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<NamingSystemContact>();
        }
        return this.contact;
    }

    public String getResponsible() {
        return this.responsible;
    }

    public void setResponsible(String value) {
        this.responsible = value;
    }

    public CodeableConcept getType() {
        return this.type;
    }

    public void setType(CodeableConcept value) {
        this.type = value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public List<CodeableConcept> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList<CodeableConcept>();
        }
        return this.useContext;
    }

    public String getUsage() {
        return this.usage;
    }

    public void setUsage(String value) {
        this.usage = value;
    }

    public List<NamingSystemUniqueId> getUniqueId() {
        if (this.uniqueId == null) {
            this.uniqueId = new ArrayList<NamingSystemUniqueId>();
        }
        return this.uniqueId;
    }

    public Reference getReplacedBy() {
        return this.replacedBy;
    }

    public void setReplacedBy(Reference value) {
        this.replacedBy = value;
    }

    public NamingSystem withName(String value) {
        this.setName(value);
        return this;
    }

    public NamingSystem withStatus(ConformanceResourceStatus value) {
        this.setStatus(value);
        return this;
    }

    public NamingSystem withKind(NamingSystemType value) {
        this.setKind(value);
        return this;
    }

    public NamingSystem withDate(DateTime value) {
        this.setDate(value);
        return this;
    }

    public NamingSystem withPublisher(String value) {
        this.setPublisher(value);
        return this;
    }

    public NamingSystem withContact(NamingSystemContact ... values) {
        if (values != null) {
            for (NamingSystemContact value : values) {
                this.getContact().add(value);
            }
        }
        return this;
    }

    public NamingSystem withContact(Collection<NamingSystemContact> values) {
        if (values != null) {
            this.getContact().addAll(values);
        }
        return this;
    }

    public NamingSystem withResponsible(String value) {
        this.setResponsible(value);
        return this;
    }

    public NamingSystem withType(CodeableConcept value) {
        this.setType(value);
        return this;
    }

    public NamingSystem withDescription(String value) {
        this.setDescription(value);
        return this;
    }

    public NamingSystem withUseContext(CodeableConcept ... values) {
        if (values != null) {
            for (CodeableConcept value : values) {
                this.getUseContext().add(value);
            }
        }
        return this;
    }

    public NamingSystem withUseContext(Collection<CodeableConcept> values) {
        if (values != null) {
            this.getUseContext().addAll(values);
        }
        return this;
    }

    public NamingSystem withUsage(String value) {
        this.setUsage(value);
        return this;
    }

    public NamingSystem withUniqueId(NamingSystemUniqueId ... values) {
        if (values != null) {
            for (NamingSystemUniqueId value : values) {
                this.getUniqueId().add(value);
            }
        }
        return this;
    }

    public NamingSystem withUniqueId(Collection<NamingSystemUniqueId> values) {
        if (values != null) {
            this.getUniqueId().addAll(values);
        }
        return this;
    }

    public NamingSystem withReplacedBy(Reference value) {
        this.setReplacedBy(value);
        return this;
    }

    @Override
    public NamingSystem withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public NamingSystem withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public NamingSystem withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public NamingSystem withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public NamingSystem withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public NamingSystem withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public NamingSystem withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public NamingSystem withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public NamingSystem withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public NamingSystem withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public NamingSystem withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        NamingSystem that = (NamingSystem)object;
        String lhsName = this.getName();
        String rhsName = that.getName();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "name", lhsName), (ObjectLocator)LocatorUtils.property(thatLocator, "name", rhsName), lhsName, rhsName, this.name != null, that.name != null)) {
            return false;
        }
        ConformanceResourceStatus lhsStatus = this.getStatus();
        ConformanceResourceStatus rhsStatus = that.getStatus();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "status", lhsStatus), (ObjectLocator)LocatorUtils.property(thatLocator, "status", rhsStatus), lhsStatus, rhsStatus, this.status != null, that.status != null)) {
            return false;
        }
        NamingSystemType lhsKind = this.getKind();
        NamingSystemType rhsKind = that.getKind();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "kind", lhsKind), (ObjectLocator)LocatorUtils.property(thatLocator, "kind", rhsKind), lhsKind, rhsKind, this.kind != null, that.kind != null)) {
            return false;
        }
        DateTime lhsDate = this.getDate();
        DateTime rhsDate = that.getDate();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "date", lhsDate), (ObjectLocator)LocatorUtils.property(thatLocator, "date", rhsDate), lhsDate, rhsDate, this.date != null, that.date != null)) {
            return false;
        }
        String lhsPublisher = this.getPublisher();
        String rhsPublisher = that.getPublisher();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "publisher", lhsPublisher), (ObjectLocator)LocatorUtils.property(thatLocator, "publisher", rhsPublisher), lhsPublisher, rhsPublisher, this.publisher != null, that.publisher != null)) {
            return false;
        }
        List<NamingSystemContact> lhsContact = this.contact != null && !this.contact.isEmpty() ? this.getContact() : null;
        List<NamingSystemContact> rhsContact = that.contact != null && !that.contact.isEmpty() ? that.getContact() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "contact", lhsContact), (ObjectLocator)LocatorUtils.property(thatLocator, "contact", rhsContact), lhsContact, rhsContact, this.contact != null && !this.contact.isEmpty(), that.contact != null && !that.contact.isEmpty())) {
            return false;
        }
        String lhsResponsible = this.getResponsible();
        String rhsResponsible = that.getResponsible();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "responsible", lhsResponsible), (ObjectLocator)LocatorUtils.property(thatLocator, "responsible", rhsResponsible), lhsResponsible, rhsResponsible, this.responsible != null, that.responsible != null)) {
            return false;
        }
        CodeableConcept lhsType = this.getType();
        CodeableConcept rhsType = that.getType();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "type", lhsType), (ObjectLocator)LocatorUtils.property(thatLocator, "type", rhsType), lhsType, rhsType, this.type != null, that.type != null)) {
            return false;
        }
        String lhsDescription = this.getDescription();
        String rhsDescription = that.getDescription();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "description", lhsDescription), (ObjectLocator)LocatorUtils.property(thatLocator, "description", rhsDescription), lhsDescription, rhsDescription, this.description != null, that.description != null)) {
            return false;
        }
        List<CodeableConcept> lhsUseContext = this.useContext != null && !this.useContext.isEmpty() ? this.getUseContext() : null;
        List<CodeableConcept> rhsUseContext = that.useContext != null && !that.useContext.isEmpty() ? that.getUseContext() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "useContext", lhsUseContext), (ObjectLocator)LocatorUtils.property(thatLocator, "useContext", rhsUseContext), lhsUseContext, rhsUseContext, this.useContext != null && !this.useContext.isEmpty(), that.useContext != null && !that.useContext.isEmpty())) {
            return false;
        }
        String lhsUsage = this.getUsage();
        String rhsUsage = that.getUsage();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "usage", lhsUsage), (ObjectLocator)LocatorUtils.property(thatLocator, "usage", rhsUsage), lhsUsage, rhsUsage, this.usage != null, that.usage != null)) {
            return false;
        }
        List<NamingSystemUniqueId> lhsUniqueId = this.uniqueId != null && !this.uniqueId.isEmpty() ? this.getUniqueId() : null;
        List<NamingSystemUniqueId> rhsUniqueId = that.uniqueId != null && !that.uniqueId.isEmpty() ? that.getUniqueId() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "uniqueId", lhsUniqueId), (ObjectLocator)LocatorUtils.property(thatLocator, "uniqueId", rhsUniqueId), lhsUniqueId, rhsUniqueId, this.uniqueId != null && !this.uniqueId.isEmpty(), that.uniqueId != null && !that.uniqueId.isEmpty())) {
            return false;
        }
        Reference lhsReplacedBy = this.getReplacedBy();
        Reference rhsReplacedBy = that.getReplacedBy();
        return strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "replacedBy", lhsReplacedBy), (ObjectLocator)LocatorUtils.property(thatLocator, "replacedBy", rhsReplacedBy), lhsReplacedBy, rhsReplacedBy, this.replacedBy != null, that.replacedBy != null);
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE2;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        String theName = this.getName();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "name", theName), currentHashCode, theName, this.name != null);
        ConformanceResourceStatus theStatus = this.getStatus();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "status", theStatus), currentHashCode, theStatus, this.status != null);
        NamingSystemType theKind = this.getKind();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "kind", theKind), currentHashCode, theKind, this.kind != null);
        DateTime theDate = this.getDate();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "date", theDate), currentHashCode, theDate, this.date != null);
        String thePublisher = this.getPublisher();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "publisher", thePublisher), currentHashCode, thePublisher, this.publisher != null);
        List<NamingSystemContact> theContact = this.contact != null && !this.contact.isEmpty() ? this.getContact() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "contact", theContact), currentHashCode, theContact, this.contact != null && !this.contact.isEmpty());
        String theResponsible = this.getResponsible();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "responsible", theResponsible), currentHashCode, theResponsible, this.responsible != null);
        CodeableConcept theType = this.getType();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "type", theType), currentHashCode, theType, this.type != null);
        String theDescription = this.getDescription();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "description", theDescription), currentHashCode, theDescription, this.description != null);
        List<CodeableConcept> theUseContext = this.useContext != null && !this.useContext.isEmpty() ? this.getUseContext() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "useContext", theUseContext), currentHashCode, theUseContext, this.useContext != null && !this.useContext.isEmpty());
        String theUsage = this.getUsage();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "usage", theUsage), currentHashCode, theUsage, this.usage != null);
        List<NamingSystemUniqueId> theUniqueId = this.uniqueId != null && !this.uniqueId.isEmpty() ? this.getUniqueId() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "uniqueId", theUniqueId), currentHashCode, theUniqueId, this.uniqueId != null && !this.uniqueId.isEmpty());
        Reference theReplacedBy = this.getReplacedBy();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "replacedBy", theReplacedBy), currentHashCode, theReplacedBy, this.replacedBy != null);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE2;
        return this.hashCode(null, strategy);
    }

    @Override
    public java.lang.String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.INSTANCE2;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        String theName = this.getName();
        strategy.appendField(locator, (Object)this, "name", buffer, theName, this.name != null);
        ConformanceResourceStatus theStatus = this.getStatus();
        strategy.appendField(locator, (Object)this, "status", buffer, theStatus, this.status != null);
        NamingSystemType theKind = this.getKind();
        strategy.appendField(locator, (Object)this, "kind", buffer, theKind, this.kind != null);
        DateTime theDate = this.getDate();
        strategy.appendField(locator, (Object)this, "date", buffer, theDate, this.date != null);
        String thePublisher = this.getPublisher();
        strategy.appendField(locator, (Object)this, "publisher", buffer, thePublisher, this.publisher != null);
        List<NamingSystemContact> theContact = this.contact != null && !this.contact.isEmpty() ? this.getContact() : null;
        strategy.appendField(locator, (Object)this, "contact", buffer, theContact, this.contact != null && !this.contact.isEmpty());
        String theResponsible = this.getResponsible();
        strategy.appendField(locator, (Object)this, "responsible", buffer, theResponsible, this.responsible != null);
        CodeableConcept theType = this.getType();
        strategy.appendField(locator, (Object)this, "type", buffer, theType, this.type != null);
        String theDescription = this.getDescription();
        strategy.appendField(locator, (Object)this, "description", buffer, theDescription, this.description != null);
        List<CodeableConcept> theUseContext = this.useContext != null && !this.useContext.isEmpty() ? this.getUseContext() : null;
        strategy.appendField(locator, (Object)this, "useContext", buffer, theUseContext, this.useContext != null && !this.useContext.isEmpty());
        String theUsage = this.getUsage();
        strategy.appendField(locator, (Object)this, "usage", buffer, theUsage, this.usage != null);
        List<NamingSystemUniqueId> theUniqueId = this.uniqueId != null && !this.uniqueId.isEmpty() ? this.getUniqueId() : null;
        strategy.appendField(locator, (Object)this, "uniqueId", buffer, theUniqueId, this.uniqueId != null && !this.uniqueId.isEmpty());
        Reference theReplacedBy = this.getReplacedBy();
        strategy.appendField(locator, (Object)this, "replacedBy", buffer, theReplacedBy, this.replacedBy != null);
        return buffer;
    }
}

