/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Annotation;
import org.hl7.fhir.Boolean;
import org.hl7.fhir.Code;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.MedicationStatementDosage;
import org.hl7.fhir.MedicationStatementStatus;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Period;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="MedicationStatement", propOrder={"identifier", "status", "medicationCodeableConcept", "medicationReference", "patient", "effectiveDateTime", "effectivePeriod", "informationSource", "supportingInformation", "dateAsserted", "wasNotTaken", "reasonNotTaken", "reasonForUseCodeableConcept", "reasonForUseReference", "note", "dosage"})
public class MedicationStatement
extends DomainResource
implements Equals2,
HashCode2,
ToString2 {
    protected List<Identifier> identifier;
    @XmlElement(required=true)
    protected MedicationStatementStatus status;
    protected CodeableConcept medicationCodeableConcept;
    protected Reference medicationReference;
    @XmlElement(required=true)
    protected Reference patient;
    protected DateTime effectiveDateTime;
    protected Period effectivePeriod;
    protected Reference informationSource;
    protected List<Reference> supportingInformation;
    protected DateTime dateAsserted;
    protected Boolean wasNotTaken;
    protected List<CodeableConcept> reasonNotTaken;
    protected CodeableConcept reasonForUseCodeableConcept;
    protected Reference reasonForUseReference;
    protected List<Annotation> note;
    protected List<MedicationStatementDosage> dosage;

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public MedicationStatementStatus getStatus() {
        return this.status;
    }

    public void setStatus(MedicationStatementStatus value) {
        this.status = value;
    }

    public CodeableConcept getMedicationCodeableConcept() {
        return this.medicationCodeableConcept;
    }

    public void setMedicationCodeableConcept(CodeableConcept value) {
        this.medicationCodeableConcept = value;
    }

    public Reference getMedicationReference() {
        return this.medicationReference;
    }

    public void setMedicationReference(Reference value) {
        this.medicationReference = value;
    }

    public Reference getPatient() {
        return this.patient;
    }

    public void setPatient(Reference value) {
        this.patient = value;
    }

    public DateTime getEffectiveDateTime() {
        return this.effectiveDateTime;
    }

    public void setEffectiveDateTime(DateTime value) {
        this.effectiveDateTime = value;
    }

    public Period getEffectivePeriod() {
        return this.effectivePeriod;
    }

    public void setEffectivePeriod(Period value) {
        this.effectivePeriod = value;
    }

    public Reference getInformationSource() {
        return this.informationSource;
    }

    public void setInformationSource(Reference value) {
        this.informationSource = value;
    }

    public List<Reference> getSupportingInformation() {
        if (this.supportingInformation == null) {
            this.supportingInformation = new ArrayList<Reference>();
        }
        return this.supportingInformation;
    }

    public DateTime getDateAsserted() {
        return this.dateAsserted;
    }

    public void setDateAsserted(DateTime value) {
        this.dateAsserted = value;
    }

    public Boolean getWasNotTaken() {
        return this.wasNotTaken;
    }

    public void setWasNotTaken(Boolean value) {
        this.wasNotTaken = value;
    }

    public List<CodeableConcept> getReasonNotTaken() {
        if (this.reasonNotTaken == null) {
            this.reasonNotTaken = new ArrayList<CodeableConcept>();
        }
        return this.reasonNotTaken;
    }

    public CodeableConcept getReasonForUseCodeableConcept() {
        return this.reasonForUseCodeableConcept;
    }

    public void setReasonForUseCodeableConcept(CodeableConcept value) {
        this.reasonForUseCodeableConcept = value;
    }

    public Reference getReasonForUseReference() {
        return this.reasonForUseReference;
    }

    public void setReasonForUseReference(Reference value) {
        this.reasonForUseReference = value;
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public List<MedicationStatementDosage> getDosage() {
        if (this.dosage == null) {
            this.dosage = new ArrayList<MedicationStatementDosage>();
        }
        return this.dosage;
    }

    public MedicationStatement withIdentifier(Identifier ... values) {
        if (values != null) {
            for (Identifier value : values) {
                this.getIdentifier().add(value);
            }
        }
        return this;
    }

    public MedicationStatement withIdentifier(Collection<Identifier> values) {
        if (values != null) {
            this.getIdentifier().addAll(values);
        }
        return this;
    }

    public MedicationStatement withStatus(MedicationStatementStatus value) {
        this.setStatus(value);
        return this;
    }

    public MedicationStatement withMedicationCodeableConcept(CodeableConcept value) {
        this.setMedicationCodeableConcept(value);
        return this;
    }

    public MedicationStatement withMedicationReference(Reference value) {
        this.setMedicationReference(value);
        return this;
    }

    public MedicationStatement withPatient(Reference value) {
        this.setPatient(value);
        return this;
    }

    public MedicationStatement withEffectiveDateTime(DateTime value) {
        this.setEffectiveDateTime(value);
        return this;
    }

    public MedicationStatement withEffectivePeriod(Period value) {
        this.setEffectivePeriod(value);
        return this;
    }

    public MedicationStatement withInformationSource(Reference value) {
        this.setInformationSource(value);
        return this;
    }

    public MedicationStatement withSupportingInformation(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getSupportingInformation().add(value);
            }
        }
        return this;
    }

    public MedicationStatement withSupportingInformation(Collection<Reference> values) {
        if (values != null) {
            this.getSupportingInformation().addAll(values);
        }
        return this;
    }

    public MedicationStatement withDateAsserted(DateTime value) {
        this.setDateAsserted(value);
        return this;
    }

    public MedicationStatement withWasNotTaken(Boolean value) {
        this.setWasNotTaken(value);
        return this;
    }

    public MedicationStatement withReasonNotTaken(CodeableConcept ... values) {
        if (values != null) {
            for (CodeableConcept value : values) {
                this.getReasonNotTaken().add(value);
            }
        }
        return this;
    }

    public MedicationStatement withReasonNotTaken(Collection<CodeableConcept> values) {
        if (values != null) {
            this.getReasonNotTaken().addAll(values);
        }
        return this;
    }

    public MedicationStatement withReasonForUseCodeableConcept(CodeableConcept value) {
        this.setReasonForUseCodeableConcept(value);
        return this;
    }

    public MedicationStatement withReasonForUseReference(Reference value) {
        this.setReasonForUseReference(value);
        return this;
    }

    public MedicationStatement withNote(Annotation ... values) {
        if (values != null) {
            for (Annotation value : values) {
                this.getNote().add(value);
            }
        }
        return this;
    }

    public MedicationStatement withNote(Collection<Annotation> values) {
        if (values != null) {
            this.getNote().addAll(values);
        }
        return this;
    }

    public MedicationStatement withDosage(MedicationStatementDosage ... values) {
        if (values != null) {
            for (MedicationStatementDosage value : values) {
                this.getDosage().add(value);
            }
        }
        return this;
    }

    public MedicationStatement withDosage(Collection<MedicationStatementDosage> values) {
        if (values != null) {
            this.getDosage().addAll(values);
        }
        return this;
    }

    @Override
    public MedicationStatement withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public MedicationStatement withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public MedicationStatement withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public MedicationStatement withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public MedicationStatement withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public MedicationStatement withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public MedicationStatement withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public MedicationStatement withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public MedicationStatement withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public MedicationStatement withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public MedicationStatement withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        MedicationStatement that = (MedicationStatement)object;
        List<Identifier> lhsIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        List<Identifier> rhsIdentifier = that.identifier != null && !that.identifier.isEmpty() ? that.getIdentifier() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "identifier", lhsIdentifier), (ObjectLocator)LocatorUtils.property(thatLocator, "identifier", rhsIdentifier), lhsIdentifier, rhsIdentifier, this.identifier != null && !this.identifier.isEmpty(), that.identifier != null && !that.identifier.isEmpty())) {
            return false;
        }
        MedicationStatementStatus lhsStatus = this.getStatus();
        MedicationStatementStatus rhsStatus = that.getStatus();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "status", lhsStatus), (ObjectLocator)LocatorUtils.property(thatLocator, "status", rhsStatus), lhsStatus, rhsStatus, this.status != null, that.status != null)) {
            return false;
        }
        CodeableConcept lhsMedicationCodeableConcept = this.getMedicationCodeableConcept();
        CodeableConcept rhsMedicationCodeableConcept = that.getMedicationCodeableConcept();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "medicationCodeableConcept", lhsMedicationCodeableConcept), (ObjectLocator)LocatorUtils.property(thatLocator, "medicationCodeableConcept", rhsMedicationCodeableConcept), lhsMedicationCodeableConcept, rhsMedicationCodeableConcept, this.medicationCodeableConcept != null, that.medicationCodeableConcept != null)) {
            return false;
        }
        Reference lhsMedicationReference = this.getMedicationReference();
        Reference rhsMedicationReference = that.getMedicationReference();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "medicationReference", lhsMedicationReference), (ObjectLocator)LocatorUtils.property(thatLocator, "medicationReference", rhsMedicationReference), lhsMedicationReference, rhsMedicationReference, this.medicationReference != null, that.medicationReference != null)) {
            return false;
        }
        Reference lhsPatient = this.getPatient();
        Reference rhsPatient = that.getPatient();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "patient", lhsPatient), (ObjectLocator)LocatorUtils.property(thatLocator, "patient", rhsPatient), lhsPatient, rhsPatient, this.patient != null, that.patient != null)) {
            return false;
        }
        DateTime lhsEffectiveDateTime = this.getEffectiveDateTime();
        DateTime rhsEffectiveDateTime = that.getEffectiveDateTime();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "effectiveDateTime", lhsEffectiveDateTime), (ObjectLocator)LocatorUtils.property(thatLocator, "effectiveDateTime", rhsEffectiveDateTime), lhsEffectiveDateTime, rhsEffectiveDateTime, this.effectiveDateTime != null, that.effectiveDateTime != null)) {
            return false;
        }
        Period lhsEffectivePeriod = this.getEffectivePeriod();
        Period rhsEffectivePeriod = that.getEffectivePeriod();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "effectivePeriod", lhsEffectivePeriod), (ObjectLocator)LocatorUtils.property(thatLocator, "effectivePeriod", rhsEffectivePeriod), lhsEffectivePeriod, rhsEffectivePeriod, this.effectivePeriod != null, that.effectivePeriod != null)) {
            return false;
        }
        Reference lhsInformationSource = this.getInformationSource();
        Reference rhsInformationSource = that.getInformationSource();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "informationSource", lhsInformationSource), (ObjectLocator)LocatorUtils.property(thatLocator, "informationSource", rhsInformationSource), lhsInformationSource, rhsInformationSource, this.informationSource != null, that.informationSource != null)) {
            return false;
        }
        List<Reference> lhsSupportingInformation = this.supportingInformation != null && !this.supportingInformation.isEmpty() ? this.getSupportingInformation() : null;
        List<Reference> rhsSupportingInformation = that.supportingInformation != null && !that.supportingInformation.isEmpty() ? that.getSupportingInformation() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "supportingInformation", lhsSupportingInformation), (ObjectLocator)LocatorUtils.property(thatLocator, "supportingInformation", rhsSupportingInformation), lhsSupportingInformation, rhsSupportingInformation, this.supportingInformation != null && !this.supportingInformation.isEmpty(), that.supportingInformation != null && !that.supportingInformation.isEmpty())) {
            return false;
        }
        DateTime lhsDateAsserted = this.getDateAsserted();
        DateTime rhsDateAsserted = that.getDateAsserted();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "dateAsserted", lhsDateAsserted), (ObjectLocator)LocatorUtils.property(thatLocator, "dateAsserted", rhsDateAsserted), lhsDateAsserted, rhsDateAsserted, this.dateAsserted != null, that.dateAsserted != null)) {
            return false;
        }
        Boolean lhsWasNotTaken = this.getWasNotTaken();
        Boolean rhsWasNotTaken = that.getWasNotTaken();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "wasNotTaken", lhsWasNotTaken), (ObjectLocator)LocatorUtils.property(thatLocator, "wasNotTaken", rhsWasNotTaken), lhsWasNotTaken, rhsWasNotTaken, this.wasNotTaken != null, that.wasNotTaken != null)) {
            return false;
        }
        List<CodeableConcept> lhsReasonNotTaken = this.reasonNotTaken != null && !this.reasonNotTaken.isEmpty() ? this.getReasonNotTaken() : null;
        List<CodeableConcept> rhsReasonNotTaken = that.reasonNotTaken != null && !that.reasonNotTaken.isEmpty() ? that.getReasonNotTaken() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "reasonNotTaken", lhsReasonNotTaken), (ObjectLocator)LocatorUtils.property(thatLocator, "reasonNotTaken", rhsReasonNotTaken), lhsReasonNotTaken, rhsReasonNotTaken, this.reasonNotTaken != null && !this.reasonNotTaken.isEmpty(), that.reasonNotTaken != null && !that.reasonNotTaken.isEmpty())) {
            return false;
        }
        CodeableConcept lhsReasonForUseCodeableConcept = this.getReasonForUseCodeableConcept();
        CodeableConcept rhsReasonForUseCodeableConcept = that.getReasonForUseCodeableConcept();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "reasonForUseCodeableConcept", lhsReasonForUseCodeableConcept), (ObjectLocator)LocatorUtils.property(thatLocator, "reasonForUseCodeableConcept", rhsReasonForUseCodeableConcept), lhsReasonForUseCodeableConcept, rhsReasonForUseCodeableConcept, this.reasonForUseCodeableConcept != null, that.reasonForUseCodeableConcept != null)) {
            return false;
        }
        Reference lhsReasonForUseReference = this.getReasonForUseReference();
        Reference rhsReasonForUseReference = that.getReasonForUseReference();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "reasonForUseReference", lhsReasonForUseReference), (ObjectLocator)LocatorUtils.property(thatLocator, "reasonForUseReference", rhsReasonForUseReference), lhsReasonForUseReference, rhsReasonForUseReference, this.reasonForUseReference != null, that.reasonForUseReference != null)) {
            return false;
        }
        List<Annotation> lhsNote = this.note != null && !this.note.isEmpty() ? this.getNote() : null;
        List<Annotation> rhsNote = that.note != null && !that.note.isEmpty() ? that.getNote() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "note", lhsNote), (ObjectLocator)LocatorUtils.property(thatLocator, "note", rhsNote), lhsNote, rhsNote, this.note != null && !this.note.isEmpty(), that.note != null && !that.note.isEmpty())) {
            return false;
        }
        List<MedicationStatementDosage> lhsDosage = this.dosage != null && !this.dosage.isEmpty() ? this.getDosage() : null;
        List<MedicationStatementDosage> rhsDosage = that.dosage != null && !that.dosage.isEmpty() ? that.getDosage() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "dosage", lhsDosage), (ObjectLocator)LocatorUtils.property(thatLocator, "dosage", rhsDosage), lhsDosage, rhsDosage, this.dosage != null && !this.dosage.isEmpty(), that.dosage != null && !that.dosage.isEmpty());
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE2;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "identifier", theIdentifier), currentHashCode, theIdentifier, this.identifier != null && !this.identifier.isEmpty());
        MedicationStatementStatus theStatus = this.getStatus();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "status", theStatus), currentHashCode, theStatus, this.status != null);
        CodeableConcept theMedicationCodeableConcept = this.getMedicationCodeableConcept();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "medicationCodeableConcept", theMedicationCodeableConcept), currentHashCode, theMedicationCodeableConcept, this.medicationCodeableConcept != null);
        Reference theMedicationReference = this.getMedicationReference();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "medicationReference", theMedicationReference), currentHashCode, theMedicationReference, this.medicationReference != null);
        Reference thePatient = this.getPatient();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "patient", thePatient), currentHashCode, thePatient, this.patient != null);
        DateTime theEffectiveDateTime = this.getEffectiveDateTime();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "effectiveDateTime", theEffectiveDateTime), currentHashCode, theEffectiveDateTime, this.effectiveDateTime != null);
        Period theEffectivePeriod = this.getEffectivePeriod();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "effectivePeriod", theEffectivePeriod), currentHashCode, theEffectivePeriod, this.effectivePeriod != null);
        Reference theInformationSource = this.getInformationSource();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "informationSource", theInformationSource), currentHashCode, theInformationSource, this.informationSource != null);
        List<Reference> theSupportingInformation = this.supportingInformation != null && !this.supportingInformation.isEmpty() ? this.getSupportingInformation() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "supportingInformation", theSupportingInformation), currentHashCode, theSupportingInformation, this.supportingInformation != null && !this.supportingInformation.isEmpty());
        DateTime theDateAsserted = this.getDateAsserted();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "dateAsserted", theDateAsserted), currentHashCode, theDateAsserted, this.dateAsserted != null);
        Boolean theWasNotTaken = this.getWasNotTaken();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "wasNotTaken", theWasNotTaken), currentHashCode, theWasNotTaken, this.wasNotTaken != null);
        List<CodeableConcept> theReasonNotTaken = this.reasonNotTaken != null && !this.reasonNotTaken.isEmpty() ? this.getReasonNotTaken() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "reasonNotTaken", theReasonNotTaken), currentHashCode, theReasonNotTaken, this.reasonNotTaken != null && !this.reasonNotTaken.isEmpty());
        CodeableConcept theReasonForUseCodeableConcept = this.getReasonForUseCodeableConcept();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "reasonForUseCodeableConcept", theReasonForUseCodeableConcept), currentHashCode, theReasonForUseCodeableConcept, this.reasonForUseCodeableConcept != null);
        Reference theReasonForUseReference = this.getReasonForUseReference();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "reasonForUseReference", theReasonForUseReference), currentHashCode, theReasonForUseReference, this.reasonForUseReference != null);
        List<Annotation> theNote = this.note != null && !this.note.isEmpty() ? this.getNote() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "note", theNote), currentHashCode, theNote, this.note != null && !this.note.isEmpty());
        List<MedicationStatementDosage> theDosage = this.dosage != null && !this.dosage.isEmpty() ? this.getDosage() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "dosage", theDosage), currentHashCode, theDosage, this.dosage != null && !this.dosage.isEmpty());
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE2;
        return this.hashCode(null, strategy);
    }

    @Override
    public String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.INSTANCE2;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        strategy.appendField(locator, (Object)this, "identifier", buffer, theIdentifier, this.identifier != null && !this.identifier.isEmpty());
        MedicationStatementStatus theStatus = this.getStatus();
        strategy.appendField(locator, (Object)this, "status", buffer, theStatus, this.status != null);
        CodeableConcept theMedicationCodeableConcept = this.getMedicationCodeableConcept();
        strategy.appendField(locator, (Object)this, "medicationCodeableConcept", buffer, theMedicationCodeableConcept, this.medicationCodeableConcept != null);
        Reference theMedicationReference = this.getMedicationReference();
        strategy.appendField(locator, (Object)this, "medicationReference", buffer, theMedicationReference, this.medicationReference != null);
        Reference thePatient = this.getPatient();
        strategy.appendField(locator, (Object)this, "patient", buffer, thePatient, this.patient != null);
        DateTime theEffectiveDateTime = this.getEffectiveDateTime();
        strategy.appendField(locator, (Object)this, "effectiveDateTime", buffer, theEffectiveDateTime, this.effectiveDateTime != null);
        Period theEffectivePeriod = this.getEffectivePeriod();
        strategy.appendField(locator, (Object)this, "effectivePeriod", buffer, theEffectivePeriod, this.effectivePeriod != null);
        Reference theInformationSource = this.getInformationSource();
        strategy.appendField(locator, (Object)this, "informationSource", buffer, theInformationSource, this.informationSource != null);
        List<Reference> theSupportingInformation = this.supportingInformation != null && !this.supportingInformation.isEmpty() ? this.getSupportingInformation() : null;
        strategy.appendField(locator, (Object)this, "supportingInformation", buffer, theSupportingInformation, this.supportingInformation != null && !this.supportingInformation.isEmpty());
        DateTime theDateAsserted = this.getDateAsserted();
        strategy.appendField(locator, (Object)this, "dateAsserted", buffer, theDateAsserted, this.dateAsserted != null);
        Boolean theWasNotTaken = this.getWasNotTaken();
        strategy.appendField(locator, (Object)this, "wasNotTaken", buffer, theWasNotTaken, this.wasNotTaken != null);
        List<CodeableConcept> theReasonNotTaken = this.reasonNotTaken != null && !this.reasonNotTaken.isEmpty() ? this.getReasonNotTaken() : null;
        strategy.appendField(locator, (Object)this, "reasonNotTaken", buffer, theReasonNotTaken, this.reasonNotTaken != null && !this.reasonNotTaken.isEmpty());
        CodeableConcept theReasonForUseCodeableConcept = this.getReasonForUseCodeableConcept();
        strategy.appendField(locator, (Object)this, "reasonForUseCodeableConcept", buffer, theReasonForUseCodeableConcept, this.reasonForUseCodeableConcept != null);
        Reference theReasonForUseReference = this.getReasonForUseReference();
        strategy.appendField(locator, (Object)this, "reasonForUseReference", buffer, theReasonForUseReference, this.reasonForUseReference != null);
        List<Annotation> theNote = this.note != null && !this.note.isEmpty() ? this.getNote() : null;
        strategy.appendField(locator, (Object)this, "note", buffer, theNote, this.note != null && !this.note.isEmpty());
        List<MedicationStatementDosage> theDosage = this.dosage != null && !this.dosage.isEmpty() ? this.getDosage() : null;
        strategy.appendField(locator, (Object)this, "dosage", buffer, theDosage, this.dosage != null && !this.dosage.isEmpty());
        return buffer;
    }
}

