/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.BackboneElement;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.Extension;
import org.hl7.fhir.MedicationBatch;
import org.hl7.fhir.MedicationIngredient;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Medication.Product", propOrder={"form", "ingredient", "batch"})
public class MedicationProduct
extends BackboneElement
implements Equals2,
HashCode2,
ToString2 {
    protected CodeableConcept form;
    protected List<MedicationIngredient> ingredient;
    protected List<MedicationBatch> batch;

    public CodeableConcept getForm() {
        return this.form;
    }

    public void setForm(CodeableConcept value) {
        this.form = value;
    }

    public List<MedicationIngredient> getIngredient() {
        if (this.ingredient == null) {
            this.ingredient = new ArrayList<MedicationIngredient>();
        }
        return this.ingredient;
    }

    public List<MedicationBatch> getBatch() {
        if (this.batch == null) {
            this.batch = new ArrayList<MedicationBatch>();
        }
        return this.batch;
    }

    public MedicationProduct withForm(CodeableConcept value) {
        this.setForm(value);
        return this;
    }

    public MedicationProduct withIngredient(MedicationIngredient ... values) {
        if (values != null) {
            for (MedicationIngredient value : values) {
                this.getIngredient().add(value);
            }
        }
        return this;
    }

    public MedicationProduct withIngredient(Collection<MedicationIngredient> values) {
        if (values != null) {
            this.getIngredient().addAll(values);
        }
        return this;
    }

    public MedicationProduct withBatch(MedicationBatch ... values) {
        if (values != null) {
            for (MedicationBatch value : values) {
                this.getBatch().add(value);
            }
        }
        return this;
    }

    public MedicationProduct withBatch(Collection<MedicationBatch> values) {
        if (values != null) {
            this.getBatch().addAll(values);
        }
        return this;
    }

    @Override
    public MedicationProduct withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public MedicationProduct withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public MedicationProduct withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public MedicationProduct withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public MedicationProduct withId(String value) {
        this.setId(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        MedicationProduct that = (MedicationProduct)object;
        CodeableConcept lhsForm = this.getForm();
        CodeableConcept rhsForm = that.getForm();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "form", lhsForm), (ObjectLocator)LocatorUtils.property(thatLocator, "form", rhsForm), lhsForm, rhsForm, this.form != null, that.form != null)) {
            return false;
        }
        List<MedicationIngredient> lhsIngredient = this.ingredient != null && !this.ingredient.isEmpty() ? this.getIngredient() : null;
        List<MedicationIngredient> rhsIngredient = that.ingredient != null && !that.ingredient.isEmpty() ? that.getIngredient() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "ingredient", lhsIngredient), (ObjectLocator)LocatorUtils.property(thatLocator, "ingredient", rhsIngredient), lhsIngredient, rhsIngredient, this.ingredient != null && !this.ingredient.isEmpty(), that.ingredient != null && !that.ingredient.isEmpty())) {
            return false;
        }
        List<MedicationBatch> lhsBatch = this.batch != null && !this.batch.isEmpty() ? this.getBatch() : null;
        List<MedicationBatch> rhsBatch = that.batch != null && !that.batch.isEmpty() ? that.getBatch() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "batch", lhsBatch), (ObjectLocator)LocatorUtils.property(thatLocator, "batch", rhsBatch), lhsBatch, rhsBatch, this.batch != null && !this.batch.isEmpty(), that.batch != null && !that.batch.isEmpty());
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE2;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        CodeableConcept theForm = this.getForm();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "form", theForm), currentHashCode, theForm, this.form != null);
        List<MedicationIngredient> theIngredient = this.ingredient != null && !this.ingredient.isEmpty() ? this.getIngredient() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "ingredient", theIngredient), currentHashCode, theIngredient, this.ingredient != null && !this.ingredient.isEmpty());
        List<MedicationBatch> theBatch = this.batch != null && !this.batch.isEmpty() ? this.getBatch() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "batch", theBatch), currentHashCode, theBatch, this.batch != null && !this.batch.isEmpty());
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE2;
        return this.hashCode(null, strategy);
    }

    @Override
    public String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.INSTANCE2;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        CodeableConcept theForm = this.getForm();
        strategy.appendField(locator, (Object)this, "form", buffer, theForm, this.form != null);
        List<MedicationIngredient> theIngredient = this.ingredient != null && !this.ingredient.isEmpty() ? this.getIngredient() : null;
        strategy.appendField(locator, (Object)this, "ingredient", buffer, theIngredient, this.ingredient != null && !this.ingredient.isEmpty());
        List<MedicationBatch> theBatch = this.batch != null && !this.batch.isEmpty() ? this.getBatch() : null;
        strategy.appendField(locator, (Object)this, "batch", buffer, theBatch, this.batch != null && !this.batch.isEmpty());
        return buffer;
    }
}

