/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.BackboneElement;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.Duration;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Period;
import org.hl7.fhir.PositiveInt;
import org.hl7.fhir.Reference;
import org.hl7.fhir.SimpleQuantity;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="MedicationOrder.DispenseRequest", propOrder={"medicationCodeableConcept", "medicationReference", "validityPeriod", "numberOfRepeatsAllowed", "quantity", "expectedSupplyDuration"})
public class MedicationOrderDispenseRequest
extends BackboneElement
implements Equals2,
HashCode2,
ToString2 {
    protected CodeableConcept medicationCodeableConcept;
    protected Reference medicationReference;
    protected Period validityPeriod;
    protected PositiveInt numberOfRepeatsAllowed;
    protected SimpleQuantity quantity;
    protected Duration expectedSupplyDuration;

    public CodeableConcept getMedicationCodeableConcept() {
        return this.medicationCodeableConcept;
    }

    public void setMedicationCodeableConcept(CodeableConcept value) {
        this.medicationCodeableConcept = value;
    }

    public Reference getMedicationReference() {
        return this.medicationReference;
    }

    public void setMedicationReference(Reference value) {
        this.medicationReference = value;
    }

    public Period getValidityPeriod() {
        return this.validityPeriod;
    }

    public void setValidityPeriod(Period value) {
        this.validityPeriod = value;
    }

    public PositiveInt getNumberOfRepeatsAllowed() {
        return this.numberOfRepeatsAllowed;
    }

    public void setNumberOfRepeatsAllowed(PositiveInt value) {
        this.numberOfRepeatsAllowed = value;
    }

    public SimpleQuantity getQuantity() {
        return this.quantity;
    }

    public void setQuantity(SimpleQuantity value) {
        this.quantity = value;
    }

    public Duration getExpectedSupplyDuration() {
        return this.expectedSupplyDuration;
    }

    public void setExpectedSupplyDuration(Duration value) {
        this.expectedSupplyDuration = value;
    }

    public MedicationOrderDispenseRequest withMedicationCodeableConcept(CodeableConcept value) {
        this.setMedicationCodeableConcept(value);
        return this;
    }

    public MedicationOrderDispenseRequest withMedicationReference(Reference value) {
        this.setMedicationReference(value);
        return this;
    }

    public MedicationOrderDispenseRequest withValidityPeriod(Period value) {
        this.setValidityPeriod(value);
        return this;
    }

    public MedicationOrderDispenseRequest withNumberOfRepeatsAllowed(PositiveInt value) {
        this.setNumberOfRepeatsAllowed(value);
        return this;
    }

    public MedicationOrderDispenseRequest withQuantity(SimpleQuantity value) {
        this.setQuantity(value);
        return this;
    }

    public MedicationOrderDispenseRequest withExpectedSupplyDuration(Duration value) {
        this.setExpectedSupplyDuration(value);
        return this;
    }

    @Override
    public MedicationOrderDispenseRequest withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public MedicationOrderDispenseRequest withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public MedicationOrderDispenseRequest withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public MedicationOrderDispenseRequest withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public MedicationOrderDispenseRequest withId(String value) {
        this.setId(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        MedicationOrderDispenseRequest that = (MedicationOrderDispenseRequest)object;
        CodeableConcept lhsMedicationCodeableConcept = this.getMedicationCodeableConcept();
        CodeableConcept rhsMedicationCodeableConcept = that.getMedicationCodeableConcept();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "medicationCodeableConcept", lhsMedicationCodeableConcept), (ObjectLocator)LocatorUtils.property(thatLocator, "medicationCodeableConcept", rhsMedicationCodeableConcept), lhsMedicationCodeableConcept, rhsMedicationCodeableConcept, this.medicationCodeableConcept != null, that.medicationCodeableConcept != null)) {
            return false;
        }
        Reference lhsMedicationReference = this.getMedicationReference();
        Reference rhsMedicationReference = that.getMedicationReference();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "medicationReference", lhsMedicationReference), (ObjectLocator)LocatorUtils.property(thatLocator, "medicationReference", rhsMedicationReference), lhsMedicationReference, rhsMedicationReference, this.medicationReference != null, that.medicationReference != null)) {
            return false;
        }
        Period lhsValidityPeriod = this.getValidityPeriod();
        Period rhsValidityPeriod = that.getValidityPeriod();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "validityPeriod", lhsValidityPeriod), (ObjectLocator)LocatorUtils.property(thatLocator, "validityPeriod", rhsValidityPeriod), lhsValidityPeriod, rhsValidityPeriod, this.validityPeriod != null, that.validityPeriod != null)) {
            return false;
        }
        PositiveInt lhsNumberOfRepeatsAllowed = this.getNumberOfRepeatsAllowed();
        PositiveInt rhsNumberOfRepeatsAllowed = that.getNumberOfRepeatsAllowed();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "numberOfRepeatsAllowed", lhsNumberOfRepeatsAllowed), (ObjectLocator)LocatorUtils.property(thatLocator, "numberOfRepeatsAllowed", rhsNumberOfRepeatsAllowed), lhsNumberOfRepeatsAllowed, rhsNumberOfRepeatsAllowed, this.numberOfRepeatsAllowed != null, that.numberOfRepeatsAllowed != null)) {
            return false;
        }
        SimpleQuantity lhsQuantity = this.getQuantity();
        SimpleQuantity rhsQuantity = that.getQuantity();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "quantity", lhsQuantity), (ObjectLocator)LocatorUtils.property(thatLocator, "quantity", rhsQuantity), lhsQuantity, rhsQuantity, this.quantity != null, that.quantity != null)) {
            return false;
        }
        Duration lhsExpectedSupplyDuration = this.getExpectedSupplyDuration();
        Duration rhsExpectedSupplyDuration = that.getExpectedSupplyDuration();
        return strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "expectedSupplyDuration", lhsExpectedSupplyDuration), (ObjectLocator)LocatorUtils.property(thatLocator, "expectedSupplyDuration", rhsExpectedSupplyDuration), lhsExpectedSupplyDuration, rhsExpectedSupplyDuration, this.expectedSupplyDuration != null, that.expectedSupplyDuration != null);
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE2;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        CodeableConcept theMedicationCodeableConcept = this.getMedicationCodeableConcept();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "medicationCodeableConcept", theMedicationCodeableConcept), currentHashCode, theMedicationCodeableConcept, this.medicationCodeableConcept != null);
        Reference theMedicationReference = this.getMedicationReference();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "medicationReference", theMedicationReference), currentHashCode, theMedicationReference, this.medicationReference != null);
        Period theValidityPeriod = this.getValidityPeriod();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "validityPeriod", theValidityPeriod), currentHashCode, theValidityPeriod, this.validityPeriod != null);
        PositiveInt theNumberOfRepeatsAllowed = this.getNumberOfRepeatsAllowed();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "numberOfRepeatsAllowed", theNumberOfRepeatsAllowed), currentHashCode, theNumberOfRepeatsAllowed, this.numberOfRepeatsAllowed != null);
        SimpleQuantity theQuantity = this.getQuantity();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "quantity", theQuantity), currentHashCode, theQuantity, this.quantity != null);
        Duration theExpectedSupplyDuration = this.getExpectedSupplyDuration();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "expectedSupplyDuration", theExpectedSupplyDuration), currentHashCode, theExpectedSupplyDuration, this.expectedSupplyDuration != null);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE2;
        return this.hashCode(null, strategy);
    }

    @Override
    public String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.INSTANCE2;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        CodeableConcept theMedicationCodeableConcept = this.getMedicationCodeableConcept();
        strategy.appendField(locator, (Object)this, "medicationCodeableConcept", buffer, theMedicationCodeableConcept, this.medicationCodeableConcept != null);
        Reference theMedicationReference = this.getMedicationReference();
        strategy.appendField(locator, (Object)this, "medicationReference", buffer, theMedicationReference, this.medicationReference != null);
        Period theValidityPeriod = this.getValidityPeriod();
        strategy.appendField(locator, (Object)this, "validityPeriod", buffer, theValidityPeriod, this.validityPeriod != null);
        PositiveInt theNumberOfRepeatsAllowed = this.getNumberOfRepeatsAllowed();
        strategy.appendField(locator, (Object)this, "numberOfRepeatsAllowed", buffer, theNumberOfRepeatsAllowed, this.numberOfRepeatsAllowed != null);
        SimpleQuantity theQuantity = this.getQuantity();
        strategy.appendField(locator, (Object)this, "quantity", buffer, theQuantity, this.quantity != null);
        Duration theExpectedSupplyDuration = this.getExpectedSupplyDuration();
        strategy.appendField(locator, (Object)this, "expectedSupplyDuration", buffer, theExpectedSupplyDuration, this.expectedSupplyDuration != null);
        return buffer;
    }
}

