/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Annotation;
import org.hl7.fhir.Code;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.MedicationOrderDispenseRequest;
import org.hl7.fhir.MedicationOrderDosageInstruction;
import org.hl7.fhir.MedicationOrderStatus;
import org.hl7.fhir.MedicationOrderSubstitution;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="MedicationOrder", propOrder={"identifier", "status", "medicationCodeableConcept", "medicationReference", "patient", "encounter", "dateWritten", "prescriber", "reasonCode", "reasonReference", "dateEnded", "reasonEnded", "note", "dosageInstruction", "dispenseRequest", "substitution", "priorPrescription"})
public class MedicationOrder
extends DomainResource
implements Equals2,
HashCode2,
ToString2 {
    protected List<Identifier> identifier;
    protected MedicationOrderStatus status;
    protected CodeableConcept medicationCodeableConcept;
    protected Reference medicationReference;
    protected Reference patient;
    protected Reference encounter;
    protected DateTime dateWritten;
    protected Reference prescriber;
    protected List<CodeableConcept> reasonCode;
    protected List<Reference> reasonReference;
    protected DateTime dateEnded;
    protected CodeableConcept reasonEnded;
    protected List<Annotation> note;
    protected List<MedicationOrderDosageInstruction> dosageInstruction;
    protected MedicationOrderDispenseRequest dispenseRequest;
    protected MedicationOrderSubstitution substitution;
    protected Reference priorPrescription;

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public MedicationOrderStatus getStatus() {
        return this.status;
    }

    public void setStatus(MedicationOrderStatus value) {
        this.status = value;
    }

    public CodeableConcept getMedicationCodeableConcept() {
        return this.medicationCodeableConcept;
    }

    public void setMedicationCodeableConcept(CodeableConcept value) {
        this.medicationCodeableConcept = value;
    }

    public Reference getMedicationReference() {
        return this.medicationReference;
    }

    public void setMedicationReference(Reference value) {
        this.medicationReference = value;
    }

    public Reference getPatient() {
        return this.patient;
    }

    public void setPatient(Reference value) {
        this.patient = value;
    }

    public Reference getEncounter() {
        return this.encounter;
    }

    public void setEncounter(Reference value) {
        this.encounter = value;
    }

    public DateTime getDateWritten() {
        return this.dateWritten;
    }

    public void setDateWritten(DateTime value) {
        this.dateWritten = value;
    }

    public Reference getPrescriber() {
        return this.prescriber;
    }

    public void setPrescriber(Reference value) {
        this.prescriber = value;
    }

    public List<CodeableConcept> getReasonCode() {
        if (this.reasonCode == null) {
            this.reasonCode = new ArrayList<CodeableConcept>();
        }
        return this.reasonCode;
    }

    public List<Reference> getReasonReference() {
        if (this.reasonReference == null) {
            this.reasonReference = new ArrayList<Reference>();
        }
        return this.reasonReference;
    }

    public DateTime getDateEnded() {
        return this.dateEnded;
    }

    public void setDateEnded(DateTime value) {
        this.dateEnded = value;
    }

    public CodeableConcept getReasonEnded() {
        return this.reasonEnded;
    }

    public void setReasonEnded(CodeableConcept value) {
        this.reasonEnded = value;
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public List<MedicationOrderDosageInstruction> getDosageInstruction() {
        if (this.dosageInstruction == null) {
            this.dosageInstruction = new ArrayList<MedicationOrderDosageInstruction>();
        }
        return this.dosageInstruction;
    }

    public MedicationOrderDispenseRequest getDispenseRequest() {
        return this.dispenseRequest;
    }

    public void setDispenseRequest(MedicationOrderDispenseRequest value) {
        this.dispenseRequest = value;
    }

    public MedicationOrderSubstitution getSubstitution() {
        return this.substitution;
    }

    public void setSubstitution(MedicationOrderSubstitution value) {
        this.substitution = value;
    }

    public Reference getPriorPrescription() {
        return this.priorPrescription;
    }

    public void setPriorPrescription(Reference value) {
        this.priorPrescription = value;
    }

    public MedicationOrder withIdentifier(Identifier ... values) {
        if (values != null) {
            for (Identifier value : values) {
                this.getIdentifier().add(value);
            }
        }
        return this;
    }

    public MedicationOrder withIdentifier(Collection<Identifier> values) {
        if (values != null) {
            this.getIdentifier().addAll(values);
        }
        return this;
    }

    public MedicationOrder withStatus(MedicationOrderStatus value) {
        this.setStatus(value);
        return this;
    }

    public MedicationOrder withMedicationCodeableConcept(CodeableConcept value) {
        this.setMedicationCodeableConcept(value);
        return this;
    }

    public MedicationOrder withMedicationReference(Reference value) {
        this.setMedicationReference(value);
        return this;
    }

    public MedicationOrder withPatient(Reference value) {
        this.setPatient(value);
        return this;
    }

    public MedicationOrder withEncounter(Reference value) {
        this.setEncounter(value);
        return this;
    }

    public MedicationOrder withDateWritten(DateTime value) {
        this.setDateWritten(value);
        return this;
    }

    public MedicationOrder withPrescriber(Reference value) {
        this.setPrescriber(value);
        return this;
    }

    public MedicationOrder withReasonCode(CodeableConcept ... values) {
        if (values != null) {
            for (CodeableConcept value : values) {
                this.getReasonCode().add(value);
            }
        }
        return this;
    }

    public MedicationOrder withReasonCode(Collection<CodeableConcept> values) {
        if (values != null) {
            this.getReasonCode().addAll(values);
        }
        return this;
    }

    public MedicationOrder withReasonReference(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getReasonReference().add(value);
            }
        }
        return this;
    }

    public MedicationOrder withReasonReference(Collection<Reference> values) {
        if (values != null) {
            this.getReasonReference().addAll(values);
        }
        return this;
    }

    public MedicationOrder withDateEnded(DateTime value) {
        this.setDateEnded(value);
        return this;
    }

    public MedicationOrder withReasonEnded(CodeableConcept value) {
        this.setReasonEnded(value);
        return this;
    }

    public MedicationOrder withNote(Annotation ... values) {
        if (values != null) {
            for (Annotation value : values) {
                this.getNote().add(value);
            }
        }
        return this;
    }

    public MedicationOrder withNote(Collection<Annotation> values) {
        if (values != null) {
            this.getNote().addAll(values);
        }
        return this;
    }

    public MedicationOrder withDosageInstruction(MedicationOrderDosageInstruction ... values) {
        if (values != null) {
            for (MedicationOrderDosageInstruction value : values) {
                this.getDosageInstruction().add(value);
            }
        }
        return this;
    }

    public MedicationOrder withDosageInstruction(Collection<MedicationOrderDosageInstruction> values) {
        if (values != null) {
            this.getDosageInstruction().addAll(values);
        }
        return this;
    }

    public MedicationOrder withDispenseRequest(MedicationOrderDispenseRequest value) {
        this.setDispenseRequest(value);
        return this;
    }

    public MedicationOrder withSubstitution(MedicationOrderSubstitution value) {
        this.setSubstitution(value);
        return this;
    }

    public MedicationOrder withPriorPrescription(Reference value) {
        this.setPriorPrescription(value);
        return this;
    }

    @Override
    public MedicationOrder withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public MedicationOrder withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public MedicationOrder withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public MedicationOrder withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public MedicationOrder withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public MedicationOrder withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public MedicationOrder withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public MedicationOrder withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public MedicationOrder withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public MedicationOrder withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public MedicationOrder withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        MedicationOrder that = (MedicationOrder)object;
        List<Identifier> lhsIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        List<Identifier> rhsIdentifier = that.identifier != null && !that.identifier.isEmpty() ? that.getIdentifier() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "identifier", lhsIdentifier), (ObjectLocator)LocatorUtils.property(thatLocator, "identifier", rhsIdentifier), lhsIdentifier, rhsIdentifier, this.identifier != null && !this.identifier.isEmpty(), that.identifier != null && !that.identifier.isEmpty())) {
            return false;
        }
        MedicationOrderStatus lhsStatus = this.getStatus();
        MedicationOrderStatus rhsStatus = that.getStatus();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "status", lhsStatus), (ObjectLocator)LocatorUtils.property(thatLocator, "status", rhsStatus), lhsStatus, rhsStatus, this.status != null, that.status != null)) {
            return false;
        }
        CodeableConcept lhsMedicationCodeableConcept = this.getMedicationCodeableConcept();
        CodeableConcept rhsMedicationCodeableConcept = that.getMedicationCodeableConcept();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "medicationCodeableConcept", lhsMedicationCodeableConcept), (ObjectLocator)LocatorUtils.property(thatLocator, "medicationCodeableConcept", rhsMedicationCodeableConcept), lhsMedicationCodeableConcept, rhsMedicationCodeableConcept, this.medicationCodeableConcept != null, that.medicationCodeableConcept != null)) {
            return false;
        }
        Reference lhsMedicationReference = this.getMedicationReference();
        Reference rhsMedicationReference = that.getMedicationReference();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "medicationReference", lhsMedicationReference), (ObjectLocator)LocatorUtils.property(thatLocator, "medicationReference", rhsMedicationReference), lhsMedicationReference, rhsMedicationReference, this.medicationReference != null, that.medicationReference != null)) {
            return false;
        }
        Reference lhsPatient = this.getPatient();
        Reference rhsPatient = that.getPatient();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "patient", lhsPatient), (ObjectLocator)LocatorUtils.property(thatLocator, "patient", rhsPatient), lhsPatient, rhsPatient, this.patient != null, that.patient != null)) {
            return false;
        }
        Reference lhsEncounter = this.getEncounter();
        Reference rhsEncounter = that.getEncounter();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "encounter", lhsEncounter), (ObjectLocator)LocatorUtils.property(thatLocator, "encounter", rhsEncounter), lhsEncounter, rhsEncounter, this.encounter != null, that.encounter != null)) {
            return false;
        }
        DateTime lhsDateWritten = this.getDateWritten();
        DateTime rhsDateWritten = that.getDateWritten();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "dateWritten", lhsDateWritten), (ObjectLocator)LocatorUtils.property(thatLocator, "dateWritten", rhsDateWritten), lhsDateWritten, rhsDateWritten, this.dateWritten != null, that.dateWritten != null)) {
            return false;
        }
        Reference lhsPrescriber = this.getPrescriber();
        Reference rhsPrescriber = that.getPrescriber();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "prescriber", lhsPrescriber), (ObjectLocator)LocatorUtils.property(thatLocator, "prescriber", rhsPrescriber), lhsPrescriber, rhsPrescriber, this.prescriber != null, that.prescriber != null)) {
            return false;
        }
        List<CodeableConcept> lhsReasonCode = this.reasonCode != null && !this.reasonCode.isEmpty() ? this.getReasonCode() : null;
        List<CodeableConcept> rhsReasonCode = that.reasonCode != null && !that.reasonCode.isEmpty() ? that.getReasonCode() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "reasonCode", lhsReasonCode), (ObjectLocator)LocatorUtils.property(thatLocator, "reasonCode", rhsReasonCode), lhsReasonCode, rhsReasonCode, this.reasonCode != null && !this.reasonCode.isEmpty(), that.reasonCode != null && !that.reasonCode.isEmpty())) {
            return false;
        }
        List<Reference> lhsReasonReference = this.reasonReference != null && !this.reasonReference.isEmpty() ? this.getReasonReference() : null;
        List<Reference> rhsReasonReference = that.reasonReference != null && !that.reasonReference.isEmpty() ? that.getReasonReference() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "reasonReference", lhsReasonReference), (ObjectLocator)LocatorUtils.property(thatLocator, "reasonReference", rhsReasonReference), lhsReasonReference, rhsReasonReference, this.reasonReference != null && !this.reasonReference.isEmpty(), that.reasonReference != null && !that.reasonReference.isEmpty())) {
            return false;
        }
        DateTime lhsDateEnded = this.getDateEnded();
        DateTime rhsDateEnded = that.getDateEnded();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "dateEnded", lhsDateEnded), (ObjectLocator)LocatorUtils.property(thatLocator, "dateEnded", rhsDateEnded), lhsDateEnded, rhsDateEnded, this.dateEnded != null, that.dateEnded != null)) {
            return false;
        }
        CodeableConcept lhsReasonEnded = this.getReasonEnded();
        CodeableConcept rhsReasonEnded = that.getReasonEnded();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "reasonEnded", lhsReasonEnded), (ObjectLocator)LocatorUtils.property(thatLocator, "reasonEnded", rhsReasonEnded), lhsReasonEnded, rhsReasonEnded, this.reasonEnded != null, that.reasonEnded != null)) {
            return false;
        }
        List<Annotation> lhsNote = this.note != null && !this.note.isEmpty() ? this.getNote() : null;
        List<Annotation> rhsNote = that.note != null && !that.note.isEmpty() ? that.getNote() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "note", lhsNote), (ObjectLocator)LocatorUtils.property(thatLocator, "note", rhsNote), lhsNote, rhsNote, this.note != null && !this.note.isEmpty(), that.note != null && !that.note.isEmpty())) {
            return false;
        }
        List<MedicationOrderDosageInstruction> lhsDosageInstruction = this.dosageInstruction != null && !this.dosageInstruction.isEmpty() ? this.getDosageInstruction() : null;
        List<MedicationOrderDosageInstruction> rhsDosageInstruction = that.dosageInstruction != null && !that.dosageInstruction.isEmpty() ? that.getDosageInstruction() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "dosageInstruction", lhsDosageInstruction), (ObjectLocator)LocatorUtils.property(thatLocator, "dosageInstruction", rhsDosageInstruction), lhsDosageInstruction, rhsDosageInstruction, this.dosageInstruction != null && !this.dosageInstruction.isEmpty(), that.dosageInstruction != null && !that.dosageInstruction.isEmpty())) {
            return false;
        }
        MedicationOrderDispenseRequest lhsDispenseRequest = this.getDispenseRequest();
        MedicationOrderDispenseRequest rhsDispenseRequest = that.getDispenseRequest();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "dispenseRequest", lhsDispenseRequest), (ObjectLocator)LocatorUtils.property(thatLocator, "dispenseRequest", rhsDispenseRequest), lhsDispenseRequest, rhsDispenseRequest, this.dispenseRequest != null, that.dispenseRequest != null)) {
            return false;
        }
        MedicationOrderSubstitution lhsSubstitution = this.getSubstitution();
        MedicationOrderSubstitution rhsSubstitution = that.getSubstitution();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "substitution", lhsSubstitution), (ObjectLocator)LocatorUtils.property(thatLocator, "substitution", rhsSubstitution), lhsSubstitution, rhsSubstitution, this.substitution != null, that.substitution != null)) {
            return false;
        }
        Reference lhsPriorPrescription = this.getPriorPrescription();
        Reference rhsPriorPrescription = that.getPriorPrescription();
        return strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "priorPrescription", lhsPriorPrescription), (ObjectLocator)LocatorUtils.property(thatLocator, "priorPrescription", rhsPriorPrescription), lhsPriorPrescription, rhsPriorPrescription, this.priorPrescription != null, that.priorPrescription != null);
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE2;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "identifier", theIdentifier), currentHashCode, theIdentifier, this.identifier != null && !this.identifier.isEmpty());
        MedicationOrderStatus theStatus = this.getStatus();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "status", theStatus), currentHashCode, theStatus, this.status != null);
        CodeableConcept theMedicationCodeableConcept = this.getMedicationCodeableConcept();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "medicationCodeableConcept", theMedicationCodeableConcept), currentHashCode, theMedicationCodeableConcept, this.medicationCodeableConcept != null);
        Reference theMedicationReference = this.getMedicationReference();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "medicationReference", theMedicationReference), currentHashCode, theMedicationReference, this.medicationReference != null);
        Reference thePatient = this.getPatient();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "patient", thePatient), currentHashCode, thePatient, this.patient != null);
        Reference theEncounter = this.getEncounter();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "encounter", theEncounter), currentHashCode, theEncounter, this.encounter != null);
        DateTime theDateWritten = this.getDateWritten();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "dateWritten", theDateWritten), currentHashCode, theDateWritten, this.dateWritten != null);
        Reference thePrescriber = this.getPrescriber();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "prescriber", thePrescriber), currentHashCode, thePrescriber, this.prescriber != null);
        List<CodeableConcept> theReasonCode = this.reasonCode != null && !this.reasonCode.isEmpty() ? this.getReasonCode() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "reasonCode", theReasonCode), currentHashCode, theReasonCode, this.reasonCode != null && !this.reasonCode.isEmpty());
        List<Reference> theReasonReference = this.reasonReference != null && !this.reasonReference.isEmpty() ? this.getReasonReference() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "reasonReference", theReasonReference), currentHashCode, theReasonReference, this.reasonReference != null && !this.reasonReference.isEmpty());
        DateTime theDateEnded = this.getDateEnded();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "dateEnded", theDateEnded), currentHashCode, theDateEnded, this.dateEnded != null);
        CodeableConcept theReasonEnded = this.getReasonEnded();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "reasonEnded", theReasonEnded), currentHashCode, theReasonEnded, this.reasonEnded != null);
        List<Annotation> theNote = this.note != null && !this.note.isEmpty() ? this.getNote() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "note", theNote), currentHashCode, theNote, this.note != null && !this.note.isEmpty());
        List<MedicationOrderDosageInstruction> theDosageInstruction = this.dosageInstruction != null && !this.dosageInstruction.isEmpty() ? this.getDosageInstruction() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "dosageInstruction", theDosageInstruction), currentHashCode, theDosageInstruction, this.dosageInstruction != null && !this.dosageInstruction.isEmpty());
        MedicationOrderDispenseRequest theDispenseRequest = this.getDispenseRequest();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "dispenseRequest", theDispenseRequest), currentHashCode, theDispenseRequest, this.dispenseRequest != null);
        MedicationOrderSubstitution theSubstitution = this.getSubstitution();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "substitution", theSubstitution), currentHashCode, theSubstitution, this.substitution != null);
        Reference thePriorPrescription = this.getPriorPrescription();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "priorPrescription", thePriorPrescription), currentHashCode, thePriorPrescription, this.priorPrescription != null);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE2;
        return this.hashCode(null, strategy);
    }

    @Override
    public String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.INSTANCE2;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        strategy.appendField(locator, (Object)this, "identifier", buffer, theIdentifier, this.identifier != null && !this.identifier.isEmpty());
        MedicationOrderStatus theStatus = this.getStatus();
        strategy.appendField(locator, (Object)this, "status", buffer, theStatus, this.status != null);
        CodeableConcept theMedicationCodeableConcept = this.getMedicationCodeableConcept();
        strategy.appendField(locator, (Object)this, "medicationCodeableConcept", buffer, theMedicationCodeableConcept, this.medicationCodeableConcept != null);
        Reference theMedicationReference = this.getMedicationReference();
        strategy.appendField(locator, (Object)this, "medicationReference", buffer, theMedicationReference, this.medicationReference != null);
        Reference thePatient = this.getPatient();
        strategy.appendField(locator, (Object)this, "patient", buffer, thePatient, this.patient != null);
        Reference theEncounter = this.getEncounter();
        strategy.appendField(locator, (Object)this, "encounter", buffer, theEncounter, this.encounter != null);
        DateTime theDateWritten = this.getDateWritten();
        strategy.appendField(locator, (Object)this, "dateWritten", buffer, theDateWritten, this.dateWritten != null);
        Reference thePrescriber = this.getPrescriber();
        strategy.appendField(locator, (Object)this, "prescriber", buffer, thePrescriber, this.prescriber != null);
        List<CodeableConcept> theReasonCode = this.reasonCode != null && !this.reasonCode.isEmpty() ? this.getReasonCode() : null;
        strategy.appendField(locator, (Object)this, "reasonCode", buffer, theReasonCode, this.reasonCode != null && !this.reasonCode.isEmpty());
        List<Reference> theReasonReference = this.reasonReference != null && !this.reasonReference.isEmpty() ? this.getReasonReference() : null;
        strategy.appendField(locator, (Object)this, "reasonReference", buffer, theReasonReference, this.reasonReference != null && !this.reasonReference.isEmpty());
        DateTime theDateEnded = this.getDateEnded();
        strategy.appendField(locator, (Object)this, "dateEnded", buffer, theDateEnded, this.dateEnded != null);
        CodeableConcept theReasonEnded = this.getReasonEnded();
        strategy.appendField(locator, (Object)this, "reasonEnded", buffer, theReasonEnded, this.reasonEnded != null);
        List<Annotation> theNote = this.note != null && !this.note.isEmpty() ? this.getNote() : null;
        strategy.appendField(locator, (Object)this, "note", buffer, theNote, this.note != null && !this.note.isEmpty());
        List<MedicationOrderDosageInstruction> theDosageInstruction = this.dosageInstruction != null && !this.dosageInstruction.isEmpty() ? this.getDosageInstruction() : null;
        strategy.appendField(locator, (Object)this, "dosageInstruction", buffer, theDosageInstruction, this.dosageInstruction != null && !this.dosageInstruction.isEmpty());
        MedicationOrderDispenseRequest theDispenseRequest = this.getDispenseRequest();
        strategy.appendField(locator, (Object)this, "dispenseRequest", buffer, theDispenseRequest, this.dispenseRequest != null);
        MedicationOrderSubstitution theSubstitution = this.getSubstitution();
        strategy.appendField(locator, (Object)this, "substitution", buffer, theSubstitution, this.substitution != null);
        Reference thePriorPrescription = this.getPriorPrescription();
        strategy.appendField(locator, (Object)this, "priorPrescription", buffer, thePriorPrescription, this.priorPrescription != null);
        return buffer;
    }
}

