/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.BackboneElement;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.MeasurePopulation;
import org.hl7.fhir.MeasureStratifier;
import org.hl7.fhir.String;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Measure.Group", propOrder={"identifier", "name", "description", "population", "stratifier"})
public class MeasureGroup
extends BackboneElement
implements Equals2,
HashCode2,
ToString2 {
    @XmlElement(required=true)
    protected Identifier identifier;
    protected String name;
    protected String description;
    protected List<MeasurePopulation> population;
    protected List<MeasureStratifier> stratifier;

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(Identifier value) {
        this.identifier = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public List<MeasurePopulation> getPopulation() {
        if (this.population == null) {
            this.population = new ArrayList<MeasurePopulation>();
        }
        return this.population;
    }

    public List<MeasureStratifier> getStratifier() {
        if (this.stratifier == null) {
            this.stratifier = new ArrayList<MeasureStratifier>();
        }
        return this.stratifier;
    }

    public MeasureGroup withIdentifier(Identifier value) {
        this.setIdentifier(value);
        return this;
    }

    public MeasureGroup withName(String value) {
        this.setName(value);
        return this;
    }

    public MeasureGroup withDescription(String value) {
        this.setDescription(value);
        return this;
    }

    public MeasureGroup withPopulation(MeasurePopulation ... values) {
        if (values != null) {
            for (MeasurePopulation value : values) {
                this.getPopulation().add(value);
            }
        }
        return this;
    }

    public MeasureGroup withPopulation(Collection<MeasurePopulation> values) {
        if (values != null) {
            this.getPopulation().addAll(values);
        }
        return this;
    }

    public MeasureGroup withStratifier(MeasureStratifier ... values) {
        if (values != null) {
            for (MeasureStratifier value : values) {
                this.getStratifier().add(value);
            }
        }
        return this;
    }

    public MeasureGroup withStratifier(Collection<MeasureStratifier> values) {
        if (values != null) {
            this.getStratifier().addAll(values);
        }
        return this;
    }

    @Override
    public MeasureGroup withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public MeasureGroup withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public MeasureGroup withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public MeasureGroup withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public MeasureGroup withId(java.lang.String value) {
        this.setId(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        MeasureGroup that = (MeasureGroup)object;
        Identifier lhsIdentifier = this.getIdentifier();
        Identifier rhsIdentifier = that.getIdentifier();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "identifier", lhsIdentifier), (ObjectLocator)LocatorUtils.property(thatLocator, "identifier", rhsIdentifier), lhsIdentifier, rhsIdentifier, this.identifier != null, that.identifier != null)) {
            return false;
        }
        String lhsName = this.getName();
        String rhsName = that.getName();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "name", lhsName), (ObjectLocator)LocatorUtils.property(thatLocator, "name", rhsName), lhsName, rhsName, this.name != null, that.name != null)) {
            return false;
        }
        String lhsDescription = this.getDescription();
        String rhsDescription = that.getDescription();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "description", lhsDescription), (ObjectLocator)LocatorUtils.property(thatLocator, "description", rhsDescription), lhsDescription, rhsDescription, this.description != null, that.description != null)) {
            return false;
        }
        List<MeasurePopulation> lhsPopulation = this.population != null && !this.population.isEmpty() ? this.getPopulation() : null;
        List<MeasurePopulation> rhsPopulation = that.population != null && !that.population.isEmpty() ? that.getPopulation() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "population", lhsPopulation), (ObjectLocator)LocatorUtils.property(thatLocator, "population", rhsPopulation), lhsPopulation, rhsPopulation, this.population != null && !this.population.isEmpty(), that.population != null && !that.population.isEmpty())) {
            return false;
        }
        List<MeasureStratifier> lhsStratifier = this.stratifier != null && !this.stratifier.isEmpty() ? this.getStratifier() : null;
        List<MeasureStratifier> rhsStratifier = that.stratifier != null && !that.stratifier.isEmpty() ? that.getStratifier() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "stratifier", lhsStratifier), (ObjectLocator)LocatorUtils.property(thatLocator, "stratifier", rhsStratifier), lhsStratifier, rhsStratifier, this.stratifier != null && !this.stratifier.isEmpty(), that.stratifier != null && !that.stratifier.isEmpty());
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE2;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        Identifier theIdentifier = this.getIdentifier();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "identifier", theIdentifier), currentHashCode, theIdentifier, this.identifier != null);
        String theName = this.getName();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "name", theName), currentHashCode, theName, this.name != null);
        String theDescription = this.getDescription();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "description", theDescription), currentHashCode, theDescription, this.description != null);
        List<MeasurePopulation> thePopulation = this.population != null && !this.population.isEmpty() ? this.getPopulation() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "population", thePopulation), currentHashCode, thePopulation, this.population != null && !this.population.isEmpty());
        List<MeasureStratifier> theStratifier = this.stratifier != null && !this.stratifier.isEmpty() ? this.getStratifier() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "stratifier", theStratifier), currentHashCode, theStratifier, this.stratifier != null && !this.stratifier.isEmpty());
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE2;
        return this.hashCode(null, strategy);
    }

    @Override
    public java.lang.String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.INSTANCE2;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        Identifier theIdentifier = this.getIdentifier();
        strategy.appendField(locator, (Object)this, "identifier", buffer, theIdentifier, this.identifier != null);
        String theName = this.getName();
        strategy.appendField(locator, (Object)this, "name", buffer, theName, this.name != null);
        String theDescription = this.getDescription();
        strategy.appendField(locator, (Object)this, "description", buffer, theDescription, this.description != null);
        List<MeasurePopulation> thePopulation = this.population != null && !this.population.isEmpty() ? this.getPopulation() : null;
        strategy.appendField(locator, (Object)this, "population", buffer, thePopulation, this.population != null && !this.population.isEmpty());
        List<MeasureStratifier> theStratifier = this.stratifier != null && !this.stratifier.isEmpty() ? this.getStratifier() : null;
        strategy.appendField(locator, (Object)this, "stratifier", buffer, theStratifier, this.stratifier != null && !this.stratifier.isEmpty());
        return buffer;
    }
}

