/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Address;
import org.hl7.fhir.Code;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.ContactPoint;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.LocationMode;
import org.hl7.fhir.LocationPosition;
import org.hl7.fhir.LocationStatus;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.String;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Location", propOrder={"identifier", "status", "name", "description", "mode", "type", "telecom", "address", "physicalType", "position", "managingOrganization", "partOf"})
public class Location
extends DomainResource
implements Equals2,
HashCode2,
ToString2 {
    protected List<Identifier> identifier;
    protected LocationStatus status;
    protected String name;
    protected String description;
    protected LocationMode mode;
    protected CodeableConcept type;
    protected List<ContactPoint> telecom;
    protected Address address;
    protected CodeableConcept physicalType;
    protected LocationPosition position;
    protected Reference managingOrganization;
    protected Reference partOf;

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public LocationStatus getStatus() {
        return this.status;
    }

    public void setStatus(LocationStatus value) {
        this.status = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public LocationMode getMode() {
        return this.mode;
    }

    public void setMode(LocationMode value) {
        this.mode = value;
    }

    public CodeableConcept getType() {
        return this.type;
    }

    public void setType(CodeableConcept value) {
        this.type = value;
    }

    public List<ContactPoint> getTelecom() {
        if (this.telecom == null) {
            this.telecom = new ArrayList<ContactPoint>();
        }
        return this.telecom;
    }

    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address value) {
        this.address = value;
    }

    public CodeableConcept getPhysicalType() {
        return this.physicalType;
    }

    public void setPhysicalType(CodeableConcept value) {
        this.physicalType = value;
    }

    public LocationPosition getPosition() {
        return this.position;
    }

    public void setPosition(LocationPosition value) {
        this.position = value;
    }

    public Reference getManagingOrganization() {
        return this.managingOrganization;
    }

    public void setManagingOrganization(Reference value) {
        this.managingOrganization = value;
    }

    public Reference getPartOf() {
        return this.partOf;
    }

    public void setPartOf(Reference value) {
        this.partOf = value;
    }

    public Location withIdentifier(Identifier ... values) {
        if (values != null) {
            for (Identifier value : values) {
                this.getIdentifier().add(value);
            }
        }
        return this;
    }

    public Location withIdentifier(Collection<Identifier> values) {
        if (values != null) {
            this.getIdentifier().addAll(values);
        }
        return this;
    }

    public Location withStatus(LocationStatus value) {
        this.setStatus(value);
        return this;
    }

    public Location withName(String value) {
        this.setName(value);
        return this;
    }

    public Location withDescription(String value) {
        this.setDescription(value);
        return this;
    }

    public Location withMode(LocationMode value) {
        this.setMode(value);
        return this;
    }

    public Location withType(CodeableConcept value) {
        this.setType(value);
        return this;
    }

    public Location withTelecom(ContactPoint ... values) {
        if (values != null) {
            for (ContactPoint value : values) {
                this.getTelecom().add(value);
            }
        }
        return this;
    }

    public Location withTelecom(Collection<ContactPoint> values) {
        if (values != null) {
            this.getTelecom().addAll(values);
        }
        return this;
    }

    public Location withAddress(Address value) {
        this.setAddress(value);
        return this;
    }

    public Location withPhysicalType(CodeableConcept value) {
        this.setPhysicalType(value);
        return this;
    }

    public Location withPosition(LocationPosition value) {
        this.setPosition(value);
        return this;
    }

    public Location withManagingOrganization(Reference value) {
        this.setManagingOrganization(value);
        return this;
    }

    public Location withPartOf(Reference value) {
        this.setPartOf(value);
        return this;
    }

    @Override
    public Location withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public Location withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public Location withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public Location withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public Location withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public Location withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public Location withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public Location withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public Location withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public Location withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public Location withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        Location that = (Location)object;
        List<Identifier> lhsIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        List<Identifier> rhsIdentifier = that.identifier != null && !that.identifier.isEmpty() ? that.getIdentifier() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "identifier", lhsIdentifier), (ObjectLocator)LocatorUtils.property(thatLocator, "identifier", rhsIdentifier), lhsIdentifier, rhsIdentifier, this.identifier != null && !this.identifier.isEmpty(), that.identifier != null && !that.identifier.isEmpty())) {
            return false;
        }
        LocationStatus lhsStatus = this.getStatus();
        LocationStatus rhsStatus = that.getStatus();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "status", lhsStatus), (ObjectLocator)LocatorUtils.property(thatLocator, "status", rhsStatus), lhsStatus, rhsStatus, this.status != null, that.status != null)) {
            return false;
        }
        String lhsName = this.getName();
        String rhsName = that.getName();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "name", lhsName), (ObjectLocator)LocatorUtils.property(thatLocator, "name", rhsName), lhsName, rhsName, this.name != null, that.name != null)) {
            return false;
        }
        String lhsDescription = this.getDescription();
        String rhsDescription = that.getDescription();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "description", lhsDescription), (ObjectLocator)LocatorUtils.property(thatLocator, "description", rhsDescription), lhsDescription, rhsDescription, this.description != null, that.description != null)) {
            return false;
        }
        LocationMode lhsMode = this.getMode();
        LocationMode rhsMode = that.getMode();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "mode", lhsMode), (ObjectLocator)LocatorUtils.property(thatLocator, "mode", rhsMode), lhsMode, rhsMode, this.mode != null, that.mode != null)) {
            return false;
        }
        CodeableConcept lhsType = this.getType();
        CodeableConcept rhsType = that.getType();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "type", lhsType), (ObjectLocator)LocatorUtils.property(thatLocator, "type", rhsType), lhsType, rhsType, this.type != null, that.type != null)) {
            return false;
        }
        List<ContactPoint> lhsTelecom = this.telecom != null && !this.telecom.isEmpty() ? this.getTelecom() : null;
        List<ContactPoint> rhsTelecom = that.telecom != null && !that.telecom.isEmpty() ? that.getTelecom() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "telecom", lhsTelecom), (ObjectLocator)LocatorUtils.property(thatLocator, "telecom", rhsTelecom), lhsTelecom, rhsTelecom, this.telecom != null && !this.telecom.isEmpty(), that.telecom != null && !that.telecom.isEmpty())) {
            return false;
        }
        Address lhsAddress = this.getAddress();
        Address rhsAddress = that.getAddress();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "address", lhsAddress), (ObjectLocator)LocatorUtils.property(thatLocator, "address", rhsAddress), lhsAddress, rhsAddress, this.address != null, that.address != null)) {
            return false;
        }
        CodeableConcept lhsPhysicalType = this.getPhysicalType();
        CodeableConcept rhsPhysicalType = that.getPhysicalType();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "physicalType", lhsPhysicalType), (ObjectLocator)LocatorUtils.property(thatLocator, "physicalType", rhsPhysicalType), lhsPhysicalType, rhsPhysicalType, this.physicalType != null, that.physicalType != null)) {
            return false;
        }
        LocationPosition lhsPosition = this.getPosition();
        LocationPosition rhsPosition = that.getPosition();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "position", lhsPosition), (ObjectLocator)LocatorUtils.property(thatLocator, "position", rhsPosition), lhsPosition, rhsPosition, this.position != null, that.position != null)) {
            return false;
        }
        Reference lhsManagingOrganization = this.getManagingOrganization();
        Reference rhsManagingOrganization = that.getManagingOrganization();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "managingOrganization", lhsManagingOrganization), (ObjectLocator)LocatorUtils.property(thatLocator, "managingOrganization", rhsManagingOrganization), lhsManagingOrganization, rhsManagingOrganization, this.managingOrganization != null, that.managingOrganization != null)) {
            return false;
        }
        Reference lhsPartOf = this.getPartOf();
        Reference rhsPartOf = that.getPartOf();
        return strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "partOf", lhsPartOf), (ObjectLocator)LocatorUtils.property(thatLocator, "partOf", rhsPartOf), lhsPartOf, rhsPartOf, this.partOf != null, that.partOf != null);
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE2;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "identifier", theIdentifier), currentHashCode, theIdentifier, this.identifier != null && !this.identifier.isEmpty());
        LocationStatus theStatus = this.getStatus();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "status", theStatus), currentHashCode, theStatus, this.status != null);
        String theName = this.getName();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "name", theName), currentHashCode, theName, this.name != null);
        String theDescription = this.getDescription();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "description", theDescription), currentHashCode, theDescription, this.description != null);
        LocationMode theMode = this.getMode();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "mode", theMode), currentHashCode, theMode, this.mode != null);
        CodeableConcept theType = this.getType();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "type", theType), currentHashCode, theType, this.type != null);
        List<ContactPoint> theTelecom = this.telecom != null && !this.telecom.isEmpty() ? this.getTelecom() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "telecom", theTelecom), currentHashCode, theTelecom, this.telecom != null && !this.telecom.isEmpty());
        Address theAddress = this.getAddress();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "address", theAddress), currentHashCode, theAddress, this.address != null);
        CodeableConcept thePhysicalType = this.getPhysicalType();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "physicalType", thePhysicalType), currentHashCode, thePhysicalType, this.physicalType != null);
        LocationPosition thePosition = this.getPosition();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "position", thePosition), currentHashCode, thePosition, this.position != null);
        Reference theManagingOrganization = this.getManagingOrganization();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "managingOrganization", theManagingOrganization), currentHashCode, theManagingOrganization, this.managingOrganization != null);
        Reference thePartOf = this.getPartOf();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "partOf", thePartOf), currentHashCode, thePartOf, this.partOf != null);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE2;
        return this.hashCode(null, strategy);
    }

    @Override
    public java.lang.String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.INSTANCE2;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        strategy.appendField(locator, (Object)this, "identifier", buffer, theIdentifier, this.identifier != null && !this.identifier.isEmpty());
        LocationStatus theStatus = this.getStatus();
        strategy.appendField(locator, (Object)this, "status", buffer, theStatus, this.status != null);
        String theName = this.getName();
        strategy.appendField(locator, (Object)this, "name", buffer, theName, this.name != null);
        String theDescription = this.getDescription();
        strategy.appendField(locator, (Object)this, "description", buffer, theDescription, this.description != null);
        LocationMode theMode = this.getMode();
        strategy.appendField(locator, (Object)this, "mode", buffer, theMode, this.mode != null);
        CodeableConcept theType = this.getType();
        strategy.appendField(locator, (Object)this, "type", buffer, theType, this.type != null);
        List<ContactPoint> theTelecom = this.telecom != null && !this.telecom.isEmpty() ? this.getTelecom() : null;
        strategy.appendField(locator, (Object)this, "telecom", buffer, theTelecom, this.telecom != null && !this.telecom.isEmpty());
        Address theAddress = this.getAddress();
        strategy.appendField(locator, (Object)this, "address", buffer, theAddress, this.address != null);
        CodeableConcept thePhysicalType = this.getPhysicalType();
        strategy.appendField(locator, (Object)this, "physicalType", buffer, thePhysicalType, this.physicalType != null);
        LocationPosition thePosition = this.getPosition();
        strategy.appendField(locator, (Object)this, "position", buffer, thePosition, this.position != null);
        Reference theManagingOrganization = this.getManagingOrganization();
        strategy.appendField(locator, (Object)this, "managingOrganization", buffer, theManagingOrganization, this.managingOrganization != null);
        Reference thePartOf = this.getPartOf();
        strategy.appendField(locator, (Object)this, "partOf", buffer, thePartOf, this.partOf != null);
        return buffer;
    }
}

