/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Boolean;
import org.hl7.fhir.Code;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.ConformanceResourceStatus;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.ImplementationGuideContact;
import org.hl7.fhir.ImplementationGuideDependency;
import org.hl7.fhir.ImplementationGuideGlobal;
import org.hl7.fhir.ImplementationGuidePackage;
import org.hl7.fhir.ImplementationGuidePage;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.String;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ImplementationGuide", propOrder={"url", "version", "name", "status", "experimental", "publisher", "contact", "date", "description", "useContext", "copyright", "fhirVersion", "dependency", "_package", "global", "binary", "page"})
public class ImplementationGuide
extends DomainResource
implements Equals2,
HashCode2,
ToString2 {
    @XmlElement(required=true)
    protected Uri url;
    protected String version;
    @XmlElement(required=true)
    protected String name;
    @XmlElement(required=true)
    protected ConformanceResourceStatus status;
    protected Boolean experimental;
    protected String publisher;
    protected List<ImplementationGuideContact> contact;
    protected DateTime date;
    protected String description;
    protected List<CodeableConcept> useContext;
    protected String copyright;
    protected Id fhirVersion;
    protected List<ImplementationGuideDependency> dependency;
    @XmlElement(name="package", required=true)
    protected List<ImplementationGuidePackage> _package;
    protected List<ImplementationGuideGlobal> global;
    protected List<Uri> binary;
    @XmlElement(required=true)
    protected ImplementationGuidePage page;

    public Uri getUrl() {
        return this.url;
    }

    public void setUrl(Uri value) {
        this.url = value;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String value) {
        this.version = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public ConformanceResourceStatus getStatus() {
        return this.status;
    }

    public void setStatus(ConformanceResourceStatus value) {
        this.status = value;
    }

    public Boolean getExperimental() {
        return this.experimental;
    }

    public void setExperimental(Boolean value) {
        this.experimental = value;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public void setPublisher(String value) {
        this.publisher = value;
    }

    public List<ImplementationGuideContact> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<ImplementationGuideContact>();
        }
        return this.contact;
    }

    public DateTime getDate() {
        return this.date;
    }

    public void setDate(DateTime value) {
        this.date = value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public List<CodeableConcept> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList<CodeableConcept>();
        }
        return this.useContext;
    }

    public String getCopyright() {
        return this.copyright;
    }

    public void setCopyright(String value) {
        this.copyright = value;
    }

    public Id getFhirVersion() {
        return this.fhirVersion;
    }

    public void setFhirVersion(Id value) {
        this.fhirVersion = value;
    }

    public List<ImplementationGuideDependency> getDependency() {
        if (this.dependency == null) {
            this.dependency = new ArrayList<ImplementationGuideDependency>();
        }
        return this.dependency;
    }

    public List<ImplementationGuidePackage> getPackage() {
        if (this._package == null) {
            this._package = new ArrayList<ImplementationGuidePackage>();
        }
        return this._package;
    }

    public List<ImplementationGuideGlobal> getGlobal() {
        if (this.global == null) {
            this.global = new ArrayList<ImplementationGuideGlobal>();
        }
        return this.global;
    }

    public List<Uri> getBinary() {
        if (this.binary == null) {
            this.binary = new ArrayList<Uri>();
        }
        return this.binary;
    }

    public ImplementationGuidePage getPage() {
        return this.page;
    }

    public void setPage(ImplementationGuidePage value) {
        this.page = value;
    }

    public ImplementationGuide withUrl(Uri value) {
        this.setUrl(value);
        return this;
    }

    public ImplementationGuide withVersion(String value) {
        this.setVersion(value);
        return this;
    }

    public ImplementationGuide withName(String value) {
        this.setName(value);
        return this;
    }

    public ImplementationGuide withStatus(ConformanceResourceStatus value) {
        this.setStatus(value);
        return this;
    }

    public ImplementationGuide withExperimental(Boolean value) {
        this.setExperimental(value);
        return this;
    }

    public ImplementationGuide withPublisher(String value) {
        this.setPublisher(value);
        return this;
    }

    public ImplementationGuide withContact(ImplementationGuideContact ... values) {
        if (values != null) {
            for (ImplementationGuideContact value : values) {
                this.getContact().add(value);
            }
        }
        return this;
    }

    public ImplementationGuide withContact(Collection<ImplementationGuideContact> values) {
        if (values != null) {
            this.getContact().addAll(values);
        }
        return this;
    }

    public ImplementationGuide withDate(DateTime value) {
        this.setDate(value);
        return this;
    }

    public ImplementationGuide withDescription(String value) {
        this.setDescription(value);
        return this;
    }

    public ImplementationGuide withUseContext(CodeableConcept ... values) {
        if (values != null) {
            for (CodeableConcept value : values) {
                this.getUseContext().add(value);
            }
        }
        return this;
    }

    public ImplementationGuide withUseContext(Collection<CodeableConcept> values) {
        if (values != null) {
            this.getUseContext().addAll(values);
        }
        return this;
    }

    public ImplementationGuide withCopyright(String value) {
        this.setCopyright(value);
        return this;
    }

    public ImplementationGuide withFhirVersion(Id value) {
        this.setFhirVersion(value);
        return this;
    }

    public ImplementationGuide withDependency(ImplementationGuideDependency ... values) {
        if (values != null) {
            for (ImplementationGuideDependency value : values) {
                this.getDependency().add(value);
            }
        }
        return this;
    }

    public ImplementationGuide withDependency(Collection<ImplementationGuideDependency> values) {
        if (values != null) {
            this.getDependency().addAll(values);
        }
        return this;
    }

    public ImplementationGuide withPackage(ImplementationGuidePackage ... values) {
        if (values != null) {
            for (ImplementationGuidePackage value : values) {
                this.getPackage().add(value);
            }
        }
        return this;
    }

    public ImplementationGuide withPackage(Collection<ImplementationGuidePackage> values) {
        if (values != null) {
            this.getPackage().addAll(values);
        }
        return this;
    }

    public ImplementationGuide withGlobal(ImplementationGuideGlobal ... values) {
        if (values != null) {
            for (ImplementationGuideGlobal value : values) {
                this.getGlobal().add(value);
            }
        }
        return this;
    }

    public ImplementationGuide withGlobal(Collection<ImplementationGuideGlobal> values) {
        if (values != null) {
            this.getGlobal().addAll(values);
        }
        return this;
    }

    public ImplementationGuide withBinary(Uri ... values) {
        if (values != null) {
            for (Uri value : values) {
                this.getBinary().add(value);
            }
        }
        return this;
    }

    public ImplementationGuide withBinary(Collection<Uri> values) {
        if (values != null) {
            this.getBinary().addAll(values);
        }
        return this;
    }

    public ImplementationGuide withPage(ImplementationGuidePage value) {
        this.setPage(value);
        return this;
    }

    @Override
    public ImplementationGuide withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public ImplementationGuide withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public ImplementationGuide withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public ImplementationGuide withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ImplementationGuide withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ImplementationGuide withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ImplementationGuide withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ImplementationGuide withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public ImplementationGuide withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public ImplementationGuide withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public ImplementationGuide withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        ImplementationGuide that = (ImplementationGuide)object;
        Uri lhsUrl = this.getUrl();
        Uri rhsUrl = that.getUrl();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "url", lhsUrl), (ObjectLocator)LocatorUtils.property(thatLocator, "url", rhsUrl), lhsUrl, rhsUrl, this.url != null, that.url != null)) {
            return false;
        }
        String lhsVersion = this.getVersion();
        String rhsVersion = that.getVersion();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "version", lhsVersion), (ObjectLocator)LocatorUtils.property(thatLocator, "version", rhsVersion), lhsVersion, rhsVersion, this.version != null, that.version != null)) {
            return false;
        }
        String lhsName = this.getName();
        String rhsName = that.getName();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "name", lhsName), (ObjectLocator)LocatorUtils.property(thatLocator, "name", rhsName), lhsName, rhsName, this.name != null, that.name != null)) {
            return false;
        }
        ConformanceResourceStatus lhsStatus = this.getStatus();
        ConformanceResourceStatus rhsStatus = that.getStatus();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "status", lhsStatus), (ObjectLocator)LocatorUtils.property(thatLocator, "status", rhsStatus), lhsStatus, rhsStatus, this.status != null, that.status != null)) {
            return false;
        }
        Boolean lhsExperimental = this.getExperimental();
        Boolean rhsExperimental = that.getExperimental();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "experimental", lhsExperimental), (ObjectLocator)LocatorUtils.property(thatLocator, "experimental", rhsExperimental), lhsExperimental, rhsExperimental, this.experimental != null, that.experimental != null)) {
            return false;
        }
        String lhsPublisher = this.getPublisher();
        String rhsPublisher = that.getPublisher();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "publisher", lhsPublisher), (ObjectLocator)LocatorUtils.property(thatLocator, "publisher", rhsPublisher), lhsPublisher, rhsPublisher, this.publisher != null, that.publisher != null)) {
            return false;
        }
        List<ImplementationGuideContact> lhsContact = this.contact != null && !this.contact.isEmpty() ? this.getContact() : null;
        List<ImplementationGuideContact> rhsContact = that.contact != null && !that.contact.isEmpty() ? that.getContact() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "contact", lhsContact), (ObjectLocator)LocatorUtils.property(thatLocator, "contact", rhsContact), lhsContact, rhsContact, this.contact != null && !this.contact.isEmpty(), that.contact != null && !that.contact.isEmpty())) {
            return false;
        }
        DateTime lhsDate = this.getDate();
        DateTime rhsDate = that.getDate();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "date", lhsDate), (ObjectLocator)LocatorUtils.property(thatLocator, "date", rhsDate), lhsDate, rhsDate, this.date != null, that.date != null)) {
            return false;
        }
        String lhsDescription = this.getDescription();
        String rhsDescription = that.getDescription();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "description", lhsDescription), (ObjectLocator)LocatorUtils.property(thatLocator, "description", rhsDescription), lhsDescription, rhsDescription, this.description != null, that.description != null)) {
            return false;
        }
        List<CodeableConcept> lhsUseContext = this.useContext != null && !this.useContext.isEmpty() ? this.getUseContext() : null;
        List<CodeableConcept> rhsUseContext = that.useContext != null && !that.useContext.isEmpty() ? that.getUseContext() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "useContext", lhsUseContext), (ObjectLocator)LocatorUtils.property(thatLocator, "useContext", rhsUseContext), lhsUseContext, rhsUseContext, this.useContext != null && !this.useContext.isEmpty(), that.useContext != null && !that.useContext.isEmpty())) {
            return false;
        }
        String lhsCopyright = this.getCopyright();
        String rhsCopyright = that.getCopyright();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "copyright", lhsCopyright), (ObjectLocator)LocatorUtils.property(thatLocator, "copyright", rhsCopyright), lhsCopyright, rhsCopyright, this.copyright != null, that.copyright != null)) {
            return false;
        }
        Id lhsFhirVersion = this.getFhirVersion();
        Id rhsFhirVersion = that.getFhirVersion();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "fhirVersion", lhsFhirVersion), (ObjectLocator)LocatorUtils.property(thatLocator, "fhirVersion", rhsFhirVersion), lhsFhirVersion, rhsFhirVersion, this.fhirVersion != null, that.fhirVersion != null)) {
            return false;
        }
        List<ImplementationGuideDependency> lhsDependency = this.dependency != null && !this.dependency.isEmpty() ? this.getDependency() : null;
        List<ImplementationGuideDependency> rhsDependency = that.dependency != null && !that.dependency.isEmpty() ? that.getDependency() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "dependency", lhsDependency), (ObjectLocator)LocatorUtils.property(thatLocator, "dependency", rhsDependency), lhsDependency, rhsDependency, this.dependency != null && !this.dependency.isEmpty(), that.dependency != null && !that.dependency.isEmpty())) {
            return false;
        }
        List<ImplementationGuidePackage> lhsPackage = this._package != null && !this._package.isEmpty() ? this.getPackage() : null;
        List<ImplementationGuidePackage> rhsPackage = that._package != null && !that._package.isEmpty() ? that.getPackage() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "_package", lhsPackage), (ObjectLocator)LocatorUtils.property(thatLocator, "_package", rhsPackage), lhsPackage, rhsPackage, this._package != null && !this._package.isEmpty(), that._package != null && !that._package.isEmpty())) {
            return false;
        }
        List<ImplementationGuideGlobal> lhsGlobal = this.global != null && !this.global.isEmpty() ? this.getGlobal() : null;
        List<ImplementationGuideGlobal> rhsGlobal = that.global != null && !that.global.isEmpty() ? that.getGlobal() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "global", lhsGlobal), (ObjectLocator)LocatorUtils.property(thatLocator, "global", rhsGlobal), lhsGlobal, rhsGlobal, this.global != null && !this.global.isEmpty(), that.global != null && !that.global.isEmpty())) {
            return false;
        }
        List<Uri> lhsBinary = this.binary != null && !this.binary.isEmpty() ? this.getBinary() : null;
        List<Uri> rhsBinary = that.binary != null && !that.binary.isEmpty() ? that.getBinary() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "binary", lhsBinary), (ObjectLocator)LocatorUtils.property(thatLocator, "binary", rhsBinary), lhsBinary, rhsBinary, this.binary != null && !this.binary.isEmpty(), that.binary != null && !that.binary.isEmpty())) {
            return false;
        }
        ImplementationGuidePage lhsPage = this.getPage();
        ImplementationGuidePage rhsPage = that.getPage();
        return strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "page", lhsPage), (ObjectLocator)LocatorUtils.property(thatLocator, "page", rhsPage), lhsPage, rhsPage, this.page != null, that.page != null);
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE2;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        Uri theUrl = this.getUrl();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "url", theUrl), currentHashCode, theUrl, this.url != null);
        String theVersion = this.getVersion();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "version", theVersion), currentHashCode, theVersion, this.version != null);
        String theName = this.getName();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "name", theName), currentHashCode, theName, this.name != null);
        ConformanceResourceStatus theStatus = this.getStatus();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "status", theStatus), currentHashCode, theStatus, this.status != null);
        Boolean theExperimental = this.getExperimental();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "experimental", theExperimental), currentHashCode, theExperimental, this.experimental != null);
        String thePublisher = this.getPublisher();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "publisher", thePublisher), currentHashCode, thePublisher, this.publisher != null);
        List<ImplementationGuideContact> theContact = this.contact != null && !this.contact.isEmpty() ? this.getContact() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "contact", theContact), currentHashCode, theContact, this.contact != null && !this.contact.isEmpty());
        DateTime theDate = this.getDate();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "date", theDate), currentHashCode, theDate, this.date != null);
        String theDescription = this.getDescription();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "description", theDescription), currentHashCode, theDescription, this.description != null);
        List<CodeableConcept> theUseContext = this.useContext != null && !this.useContext.isEmpty() ? this.getUseContext() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "useContext", theUseContext), currentHashCode, theUseContext, this.useContext != null && !this.useContext.isEmpty());
        String theCopyright = this.getCopyright();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "copyright", theCopyright), currentHashCode, theCopyright, this.copyright != null);
        Id theFhirVersion = this.getFhirVersion();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "fhirVersion", theFhirVersion), currentHashCode, theFhirVersion, this.fhirVersion != null);
        List<ImplementationGuideDependency> theDependency = this.dependency != null && !this.dependency.isEmpty() ? this.getDependency() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "dependency", theDependency), currentHashCode, theDependency, this.dependency != null && !this.dependency.isEmpty());
        List<ImplementationGuidePackage> thePackage = this._package != null && !this._package.isEmpty() ? this.getPackage() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "_package", thePackage), currentHashCode, thePackage, this._package != null && !this._package.isEmpty());
        List<ImplementationGuideGlobal> theGlobal = this.global != null && !this.global.isEmpty() ? this.getGlobal() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "global", theGlobal), currentHashCode, theGlobal, this.global != null && !this.global.isEmpty());
        List<Uri> theBinary = this.binary != null && !this.binary.isEmpty() ? this.getBinary() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "binary", theBinary), currentHashCode, theBinary, this.binary != null && !this.binary.isEmpty());
        ImplementationGuidePage thePage = this.getPage();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "page", thePage), currentHashCode, thePage, this.page != null);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE2;
        return this.hashCode(null, strategy);
    }

    @Override
    public java.lang.String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.INSTANCE2;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        Uri theUrl = this.getUrl();
        strategy.appendField(locator, (Object)this, "url", buffer, theUrl, this.url != null);
        String theVersion = this.getVersion();
        strategy.appendField(locator, (Object)this, "version", buffer, theVersion, this.version != null);
        String theName = this.getName();
        strategy.appendField(locator, (Object)this, "name", buffer, theName, this.name != null);
        ConformanceResourceStatus theStatus = this.getStatus();
        strategy.appendField(locator, (Object)this, "status", buffer, theStatus, this.status != null);
        Boolean theExperimental = this.getExperimental();
        strategy.appendField(locator, (Object)this, "experimental", buffer, theExperimental, this.experimental != null);
        String thePublisher = this.getPublisher();
        strategy.appendField(locator, (Object)this, "publisher", buffer, thePublisher, this.publisher != null);
        List<ImplementationGuideContact> theContact = this.contact != null && !this.contact.isEmpty() ? this.getContact() : null;
        strategy.appendField(locator, (Object)this, "contact", buffer, theContact, this.contact != null && !this.contact.isEmpty());
        DateTime theDate = this.getDate();
        strategy.appendField(locator, (Object)this, "date", buffer, theDate, this.date != null);
        String theDescription = this.getDescription();
        strategy.appendField(locator, (Object)this, "description", buffer, theDescription, this.description != null);
        List<CodeableConcept> theUseContext = this.useContext != null && !this.useContext.isEmpty() ? this.getUseContext() : null;
        strategy.appendField(locator, (Object)this, "useContext", buffer, theUseContext, this.useContext != null && !this.useContext.isEmpty());
        String theCopyright = this.getCopyright();
        strategy.appendField(locator, (Object)this, "copyright", buffer, theCopyright, this.copyright != null);
        Id theFhirVersion = this.getFhirVersion();
        strategy.appendField(locator, (Object)this, "fhirVersion", buffer, theFhirVersion, this.fhirVersion != null);
        List<ImplementationGuideDependency> theDependency = this.dependency != null && !this.dependency.isEmpty() ? this.getDependency() : null;
        strategy.appendField(locator, (Object)this, "dependency", buffer, theDependency, this.dependency != null && !this.dependency.isEmpty());
        List<ImplementationGuidePackage> thePackage = this._package != null && !this._package.isEmpty() ? this.getPackage() : null;
        strategy.appendField(locator, (Object)this, "_package", buffer, thePackage, this._package != null && !this._package.isEmpty());
        List<ImplementationGuideGlobal> theGlobal = this.global != null && !this.global.isEmpty() ? this.getGlobal() : null;
        strategy.appendField(locator, (Object)this, "global", buffer, theGlobal, this.global != null && !this.global.isEmpty());
        List<Uri> theBinary = this.binary != null && !this.binary.isEmpty() ? this.getBinary() : null;
        strategy.appendField(locator, (Object)this, "binary", buffer, theBinary, this.binary != null && !this.binary.isEmpty());
        ImplementationGuidePage thePage = this.getPage();
        strategy.appendField(locator, (Object)this, "page", buffer, thePage, this.page != null);
        return buffer;
    }
}

