/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Code;
import org.hl7.fhir.Coding;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.ImagingStudySeries;
import org.hl7.fhir.InstanceAvailability;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Oid;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.String;
import org.hl7.fhir.UnsignedInt;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ImagingStudy", propOrder={"uid", "accession", "identifier", "availability", "modalityList", "patient", "started", "order", "referrer", "interpreter", "url", "numberOfSeries", "numberOfInstances", "procedure", "description", "series"})
public class ImagingStudy
extends DomainResource
implements Equals2,
HashCode2,
ToString2 {
    @XmlElement(required=true)
    protected Oid uid;
    protected Identifier accession;
    protected List<Identifier> identifier;
    protected InstanceAvailability availability;
    protected List<Coding> modalityList;
    @XmlElement(required=true)
    protected Reference patient;
    protected DateTime started;
    protected List<Reference> order;
    protected Reference referrer;
    protected Reference interpreter;
    protected Uri url;
    @XmlElement(required=true)
    protected UnsignedInt numberOfSeries;
    @XmlElement(required=true)
    protected UnsignedInt numberOfInstances;
    protected List<Reference> procedure;
    protected String description;
    protected List<ImagingStudySeries> series;

    public Oid getUid() {
        return this.uid;
    }

    public void setUid(Oid value) {
        this.uid = value;
    }

    public Identifier getAccession() {
        return this.accession;
    }

    public void setAccession(Identifier value) {
        this.accession = value;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public InstanceAvailability getAvailability() {
        return this.availability;
    }

    public void setAvailability(InstanceAvailability value) {
        this.availability = value;
    }

    public List<Coding> getModalityList() {
        if (this.modalityList == null) {
            this.modalityList = new ArrayList<Coding>();
        }
        return this.modalityList;
    }

    public Reference getPatient() {
        return this.patient;
    }

    public void setPatient(Reference value) {
        this.patient = value;
    }

    public DateTime getStarted() {
        return this.started;
    }

    public void setStarted(DateTime value) {
        this.started = value;
    }

    public List<Reference> getOrder() {
        if (this.order == null) {
            this.order = new ArrayList<Reference>();
        }
        return this.order;
    }

    public Reference getReferrer() {
        return this.referrer;
    }

    public void setReferrer(Reference value) {
        this.referrer = value;
    }

    public Reference getInterpreter() {
        return this.interpreter;
    }

    public void setInterpreter(Reference value) {
        this.interpreter = value;
    }

    public Uri getUrl() {
        return this.url;
    }

    public void setUrl(Uri value) {
        this.url = value;
    }

    public UnsignedInt getNumberOfSeries() {
        return this.numberOfSeries;
    }

    public void setNumberOfSeries(UnsignedInt value) {
        this.numberOfSeries = value;
    }

    public UnsignedInt getNumberOfInstances() {
        return this.numberOfInstances;
    }

    public void setNumberOfInstances(UnsignedInt value) {
        this.numberOfInstances = value;
    }

    public List<Reference> getProcedure() {
        if (this.procedure == null) {
            this.procedure = new ArrayList<Reference>();
        }
        return this.procedure;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public List<ImagingStudySeries> getSeries() {
        if (this.series == null) {
            this.series = new ArrayList<ImagingStudySeries>();
        }
        return this.series;
    }

    public ImagingStudy withUid(Oid value) {
        this.setUid(value);
        return this;
    }

    public ImagingStudy withAccession(Identifier value) {
        this.setAccession(value);
        return this;
    }

    public ImagingStudy withIdentifier(Identifier ... values) {
        if (values != null) {
            for (Identifier value : values) {
                this.getIdentifier().add(value);
            }
        }
        return this;
    }

    public ImagingStudy withIdentifier(Collection<Identifier> values) {
        if (values != null) {
            this.getIdentifier().addAll(values);
        }
        return this;
    }

    public ImagingStudy withAvailability(InstanceAvailability value) {
        this.setAvailability(value);
        return this;
    }

    public ImagingStudy withModalityList(Coding ... values) {
        if (values != null) {
            for (Coding value : values) {
                this.getModalityList().add(value);
            }
        }
        return this;
    }

    public ImagingStudy withModalityList(Collection<Coding> values) {
        if (values != null) {
            this.getModalityList().addAll(values);
        }
        return this;
    }

    public ImagingStudy withPatient(Reference value) {
        this.setPatient(value);
        return this;
    }

    public ImagingStudy withStarted(DateTime value) {
        this.setStarted(value);
        return this;
    }

    public ImagingStudy withOrder(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getOrder().add(value);
            }
        }
        return this;
    }

    public ImagingStudy withOrder(Collection<Reference> values) {
        if (values != null) {
            this.getOrder().addAll(values);
        }
        return this;
    }

    public ImagingStudy withReferrer(Reference value) {
        this.setReferrer(value);
        return this;
    }

    public ImagingStudy withInterpreter(Reference value) {
        this.setInterpreter(value);
        return this;
    }

    public ImagingStudy withUrl(Uri value) {
        this.setUrl(value);
        return this;
    }

    public ImagingStudy withNumberOfSeries(UnsignedInt value) {
        this.setNumberOfSeries(value);
        return this;
    }

    public ImagingStudy withNumberOfInstances(UnsignedInt value) {
        this.setNumberOfInstances(value);
        return this;
    }

    public ImagingStudy withProcedure(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getProcedure().add(value);
            }
        }
        return this;
    }

    public ImagingStudy withProcedure(Collection<Reference> values) {
        if (values != null) {
            this.getProcedure().addAll(values);
        }
        return this;
    }

    public ImagingStudy withDescription(String value) {
        this.setDescription(value);
        return this;
    }

    public ImagingStudy withSeries(ImagingStudySeries ... values) {
        if (values != null) {
            for (ImagingStudySeries value : values) {
                this.getSeries().add(value);
            }
        }
        return this;
    }

    public ImagingStudy withSeries(Collection<ImagingStudySeries> values) {
        if (values != null) {
            this.getSeries().addAll(values);
        }
        return this;
    }

    @Override
    public ImagingStudy withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public ImagingStudy withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public ImagingStudy withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public ImagingStudy withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ImagingStudy withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ImagingStudy withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ImagingStudy withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ImagingStudy withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public ImagingStudy withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public ImagingStudy withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public ImagingStudy withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        ImagingStudy that = (ImagingStudy)object;
        Oid lhsUid = this.getUid();
        Oid rhsUid = that.getUid();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "uid", lhsUid), (ObjectLocator)LocatorUtils.property(thatLocator, "uid", rhsUid), lhsUid, rhsUid, this.uid != null, that.uid != null)) {
            return false;
        }
        Identifier lhsAccession = this.getAccession();
        Identifier rhsAccession = that.getAccession();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "accession", lhsAccession), (ObjectLocator)LocatorUtils.property(thatLocator, "accession", rhsAccession), lhsAccession, rhsAccession, this.accession != null, that.accession != null)) {
            return false;
        }
        List<Identifier> lhsIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        List<Identifier> rhsIdentifier = that.identifier != null && !that.identifier.isEmpty() ? that.getIdentifier() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "identifier", lhsIdentifier), (ObjectLocator)LocatorUtils.property(thatLocator, "identifier", rhsIdentifier), lhsIdentifier, rhsIdentifier, this.identifier != null && !this.identifier.isEmpty(), that.identifier != null && !that.identifier.isEmpty())) {
            return false;
        }
        InstanceAvailability lhsAvailability = this.getAvailability();
        InstanceAvailability rhsAvailability = that.getAvailability();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "availability", lhsAvailability), (ObjectLocator)LocatorUtils.property(thatLocator, "availability", rhsAvailability), lhsAvailability, rhsAvailability, this.availability != null, that.availability != null)) {
            return false;
        }
        List<Coding> lhsModalityList = this.modalityList != null && !this.modalityList.isEmpty() ? this.getModalityList() : null;
        List<Coding> rhsModalityList = that.modalityList != null && !that.modalityList.isEmpty() ? that.getModalityList() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "modalityList", lhsModalityList), (ObjectLocator)LocatorUtils.property(thatLocator, "modalityList", rhsModalityList), lhsModalityList, rhsModalityList, this.modalityList != null && !this.modalityList.isEmpty(), that.modalityList != null && !that.modalityList.isEmpty())) {
            return false;
        }
        Reference lhsPatient = this.getPatient();
        Reference rhsPatient = that.getPatient();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "patient", lhsPatient), (ObjectLocator)LocatorUtils.property(thatLocator, "patient", rhsPatient), lhsPatient, rhsPatient, this.patient != null, that.patient != null)) {
            return false;
        }
        DateTime lhsStarted = this.getStarted();
        DateTime rhsStarted = that.getStarted();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "started", lhsStarted), (ObjectLocator)LocatorUtils.property(thatLocator, "started", rhsStarted), lhsStarted, rhsStarted, this.started != null, that.started != null)) {
            return false;
        }
        List<Reference> lhsOrder = this.order != null && !this.order.isEmpty() ? this.getOrder() : null;
        List<Reference> rhsOrder = that.order != null && !that.order.isEmpty() ? that.getOrder() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "order", lhsOrder), (ObjectLocator)LocatorUtils.property(thatLocator, "order", rhsOrder), lhsOrder, rhsOrder, this.order != null && !this.order.isEmpty(), that.order != null && !that.order.isEmpty())) {
            return false;
        }
        Reference lhsReferrer = this.getReferrer();
        Reference rhsReferrer = that.getReferrer();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "referrer", lhsReferrer), (ObjectLocator)LocatorUtils.property(thatLocator, "referrer", rhsReferrer), lhsReferrer, rhsReferrer, this.referrer != null, that.referrer != null)) {
            return false;
        }
        Reference lhsInterpreter = this.getInterpreter();
        Reference rhsInterpreter = that.getInterpreter();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "interpreter", lhsInterpreter), (ObjectLocator)LocatorUtils.property(thatLocator, "interpreter", rhsInterpreter), lhsInterpreter, rhsInterpreter, this.interpreter != null, that.interpreter != null)) {
            return false;
        }
        Uri lhsUrl = this.getUrl();
        Uri rhsUrl = that.getUrl();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "url", lhsUrl), (ObjectLocator)LocatorUtils.property(thatLocator, "url", rhsUrl), lhsUrl, rhsUrl, this.url != null, that.url != null)) {
            return false;
        }
        UnsignedInt lhsNumberOfSeries = this.getNumberOfSeries();
        UnsignedInt rhsNumberOfSeries = that.getNumberOfSeries();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "numberOfSeries", lhsNumberOfSeries), (ObjectLocator)LocatorUtils.property(thatLocator, "numberOfSeries", rhsNumberOfSeries), lhsNumberOfSeries, rhsNumberOfSeries, this.numberOfSeries != null, that.numberOfSeries != null)) {
            return false;
        }
        UnsignedInt lhsNumberOfInstances = this.getNumberOfInstances();
        UnsignedInt rhsNumberOfInstances = that.getNumberOfInstances();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "numberOfInstances", lhsNumberOfInstances), (ObjectLocator)LocatorUtils.property(thatLocator, "numberOfInstances", rhsNumberOfInstances), lhsNumberOfInstances, rhsNumberOfInstances, this.numberOfInstances != null, that.numberOfInstances != null)) {
            return false;
        }
        List<Reference> lhsProcedure = this.procedure != null && !this.procedure.isEmpty() ? this.getProcedure() : null;
        List<Reference> rhsProcedure = that.procedure != null && !that.procedure.isEmpty() ? that.getProcedure() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "procedure", lhsProcedure), (ObjectLocator)LocatorUtils.property(thatLocator, "procedure", rhsProcedure), lhsProcedure, rhsProcedure, this.procedure != null && !this.procedure.isEmpty(), that.procedure != null && !that.procedure.isEmpty())) {
            return false;
        }
        String lhsDescription = this.getDescription();
        String rhsDescription = that.getDescription();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "description", lhsDescription), (ObjectLocator)LocatorUtils.property(thatLocator, "description", rhsDescription), lhsDescription, rhsDescription, this.description != null, that.description != null)) {
            return false;
        }
        List<ImagingStudySeries> lhsSeries = this.series != null && !this.series.isEmpty() ? this.getSeries() : null;
        List<ImagingStudySeries> rhsSeries = that.series != null && !that.series.isEmpty() ? that.getSeries() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "series", lhsSeries), (ObjectLocator)LocatorUtils.property(thatLocator, "series", rhsSeries), lhsSeries, rhsSeries, this.series != null && !this.series.isEmpty(), that.series != null && !that.series.isEmpty());
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE2;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        Oid theUid = this.getUid();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "uid", theUid), currentHashCode, theUid, this.uid != null);
        Identifier theAccession = this.getAccession();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "accession", theAccession), currentHashCode, theAccession, this.accession != null);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "identifier", theIdentifier), currentHashCode, theIdentifier, this.identifier != null && !this.identifier.isEmpty());
        InstanceAvailability theAvailability = this.getAvailability();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "availability", theAvailability), currentHashCode, theAvailability, this.availability != null);
        List<Coding> theModalityList = this.modalityList != null && !this.modalityList.isEmpty() ? this.getModalityList() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "modalityList", theModalityList), currentHashCode, theModalityList, this.modalityList != null && !this.modalityList.isEmpty());
        Reference thePatient = this.getPatient();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "patient", thePatient), currentHashCode, thePatient, this.patient != null);
        DateTime theStarted = this.getStarted();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "started", theStarted), currentHashCode, theStarted, this.started != null);
        List<Reference> theOrder = this.order != null && !this.order.isEmpty() ? this.getOrder() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "order", theOrder), currentHashCode, theOrder, this.order != null && !this.order.isEmpty());
        Reference theReferrer = this.getReferrer();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "referrer", theReferrer), currentHashCode, theReferrer, this.referrer != null);
        Reference theInterpreter = this.getInterpreter();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "interpreter", theInterpreter), currentHashCode, theInterpreter, this.interpreter != null);
        Uri theUrl = this.getUrl();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "url", theUrl), currentHashCode, theUrl, this.url != null);
        UnsignedInt theNumberOfSeries = this.getNumberOfSeries();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "numberOfSeries", theNumberOfSeries), currentHashCode, theNumberOfSeries, this.numberOfSeries != null);
        UnsignedInt theNumberOfInstances = this.getNumberOfInstances();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "numberOfInstances", theNumberOfInstances), currentHashCode, theNumberOfInstances, this.numberOfInstances != null);
        List<Reference> theProcedure = this.procedure != null && !this.procedure.isEmpty() ? this.getProcedure() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "procedure", theProcedure), currentHashCode, theProcedure, this.procedure != null && !this.procedure.isEmpty());
        String theDescription = this.getDescription();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "description", theDescription), currentHashCode, theDescription, this.description != null);
        List<ImagingStudySeries> theSeries = this.series != null && !this.series.isEmpty() ? this.getSeries() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "series", theSeries), currentHashCode, theSeries, this.series != null && !this.series.isEmpty());
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE2;
        return this.hashCode(null, strategy);
    }

    @Override
    public java.lang.String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.INSTANCE2;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        Oid theUid = this.getUid();
        strategy.appendField(locator, (Object)this, "uid", buffer, theUid, this.uid != null);
        Identifier theAccession = this.getAccession();
        strategy.appendField(locator, (Object)this, "accession", buffer, theAccession, this.accession != null);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        strategy.appendField(locator, (Object)this, "identifier", buffer, theIdentifier, this.identifier != null && !this.identifier.isEmpty());
        InstanceAvailability theAvailability = this.getAvailability();
        strategy.appendField(locator, (Object)this, "availability", buffer, theAvailability, this.availability != null);
        List<Coding> theModalityList = this.modalityList != null && !this.modalityList.isEmpty() ? this.getModalityList() : null;
        strategy.appendField(locator, (Object)this, "modalityList", buffer, theModalityList, this.modalityList != null && !this.modalityList.isEmpty());
        Reference thePatient = this.getPatient();
        strategy.appendField(locator, (Object)this, "patient", buffer, thePatient, this.patient != null);
        DateTime theStarted = this.getStarted();
        strategy.appendField(locator, (Object)this, "started", buffer, theStarted, this.started != null);
        List<Reference> theOrder = this.order != null && !this.order.isEmpty() ? this.getOrder() : null;
        strategy.appendField(locator, (Object)this, "order", buffer, theOrder, this.order != null && !this.order.isEmpty());
        Reference theReferrer = this.getReferrer();
        strategy.appendField(locator, (Object)this, "referrer", buffer, theReferrer, this.referrer != null);
        Reference theInterpreter = this.getInterpreter();
        strategy.appendField(locator, (Object)this, "interpreter", buffer, theInterpreter, this.interpreter != null);
        Uri theUrl = this.getUrl();
        strategy.appendField(locator, (Object)this, "url", buffer, theUrl, this.url != null);
        UnsignedInt theNumberOfSeries = this.getNumberOfSeries();
        strategy.appendField(locator, (Object)this, "numberOfSeries", buffer, theNumberOfSeries, this.numberOfSeries != null);
        UnsignedInt theNumberOfInstances = this.getNumberOfInstances();
        strategy.appendField(locator, (Object)this, "numberOfInstances", buffer, theNumberOfInstances, this.numberOfInstances != null);
        List<Reference> theProcedure = this.procedure != null && !this.procedure.isEmpty() ? this.getProcedure() : null;
        strategy.appendField(locator, (Object)this, "procedure", buffer, theProcedure, this.procedure != null && !this.procedure.isEmpty());
        String theDescription = this.getDescription();
        strategy.appendField(locator, (Object)this, "description", buffer, theDescription, this.description != null);
        List<ImagingStudySeries> theSeries = this.series != null && !this.series.isEmpty() ? this.getSeries() : null;
        strategy.appendField(locator, (Object)this, "series", buffer, theSeries, this.series != null && !this.series.isEmpty());
        return buffer;
    }
}

