/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Attachment;
import org.hl7.fhir.BackboneElement;
import org.hl7.fhir.Code;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.Extension;
import org.hl7.fhir.GuidanceResponseBehavior;
import org.hl7.fhir.GuidanceResponseRelatedAction;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.Reference;
import org.hl7.fhir.String;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="GuidanceResponse.Action", propOrder={"actionIdentifier", "label", "title", "description", "textEquivalent", "concept", "supportingEvidence", "relatedAction", "documentation", "participant", "type", "behavior", "resource", "action"})
public class GuidanceResponseAction
extends BackboneElement
implements Equals2,
HashCode2,
ToString2 {
    protected Identifier actionIdentifier;
    protected String label;
    protected String title;
    protected String description;
    protected String textEquivalent;
    protected List<CodeableConcept> concept;
    protected List<Attachment> supportingEvidence;
    protected GuidanceResponseRelatedAction relatedAction;
    protected List<Attachment> documentation;
    protected List<Reference> participant;
    protected Code type;
    protected List<GuidanceResponseBehavior> behavior;
    protected Reference resource;
    protected List<GuidanceResponseAction> action;

    public Identifier getActionIdentifier() {
        return this.actionIdentifier;
    }

    public void setActionIdentifier(Identifier value) {
        this.actionIdentifier = value;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String value) {
        this.label = value;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String value) {
        this.title = value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public String getTextEquivalent() {
        return this.textEquivalent;
    }

    public void setTextEquivalent(String value) {
        this.textEquivalent = value;
    }

    public List<CodeableConcept> getConcept() {
        if (this.concept == null) {
            this.concept = new ArrayList<CodeableConcept>();
        }
        return this.concept;
    }

    public List<Attachment> getSupportingEvidence() {
        if (this.supportingEvidence == null) {
            this.supportingEvidence = new ArrayList<Attachment>();
        }
        return this.supportingEvidence;
    }

    public GuidanceResponseRelatedAction getRelatedAction() {
        return this.relatedAction;
    }

    public void setRelatedAction(GuidanceResponseRelatedAction value) {
        this.relatedAction = value;
    }

    public List<Attachment> getDocumentation() {
        if (this.documentation == null) {
            this.documentation = new ArrayList<Attachment>();
        }
        return this.documentation;
    }

    public List<Reference> getParticipant() {
        if (this.participant == null) {
            this.participant = new ArrayList<Reference>();
        }
        return this.participant;
    }

    public Code getType() {
        return this.type;
    }

    public void setType(Code value) {
        this.type = value;
    }

    public List<GuidanceResponseBehavior> getBehavior() {
        if (this.behavior == null) {
            this.behavior = new ArrayList<GuidanceResponseBehavior>();
        }
        return this.behavior;
    }

    public Reference getResource() {
        return this.resource;
    }

    public void setResource(Reference value) {
        this.resource = value;
    }

    public List<GuidanceResponseAction> getAction() {
        if (this.action == null) {
            this.action = new ArrayList<GuidanceResponseAction>();
        }
        return this.action;
    }

    public GuidanceResponseAction withActionIdentifier(Identifier value) {
        this.setActionIdentifier(value);
        return this;
    }

    public GuidanceResponseAction withLabel(String value) {
        this.setLabel(value);
        return this;
    }

    public GuidanceResponseAction withTitle(String value) {
        this.setTitle(value);
        return this;
    }

    public GuidanceResponseAction withDescription(String value) {
        this.setDescription(value);
        return this;
    }

    public GuidanceResponseAction withTextEquivalent(String value) {
        this.setTextEquivalent(value);
        return this;
    }

    public GuidanceResponseAction withConcept(CodeableConcept ... values) {
        if (values != null) {
            for (CodeableConcept value : values) {
                this.getConcept().add(value);
            }
        }
        return this;
    }

    public GuidanceResponseAction withConcept(Collection<CodeableConcept> values) {
        if (values != null) {
            this.getConcept().addAll(values);
        }
        return this;
    }

    public GuidanceResponseAction withSupportingEvidence(Attachment ... values) {
        if (values != null) {
            for (Attachment value : values) {
                this.getSupportingEvidence().add(value);
            }
        }
        return this;
    }

    public GuidanceResponseAction withSupportingEvidence(Collection<Attachment> values) {
        if (values != null) {
            this.getSupportingEvidence().addAll(values);
        }
        return this;
    }

    public GuidanceResponseAction withRelatedAction(GuidanceResponseRelatedAction value) {
        this.setRelatedAction(value);
        return this;
    }

    public GuidanceResponseAction withDocumentation(Attachment ... values) {
        if (values != null) {
            for (Attachment value : values) {
                this.getDocumentation().add(value);
            }
        }
        return this;
    }

    public GuidanceResponseAction withDocumentation(Collection<Attachment> values) {
        if (values != null) {
            this.getDocumentation().addAll(values);
        }
        return this;
    }

    public GuidanceResponseAction withParticipant(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getParticipant().add(value);
            }
        }
        return this;
    }

    public GuidanceResponseAction withParticipant(Collection<Reference> values) {
        if (values != null) {
            this.getParticipant().addAll(values);
        }
        return this;
    }

    public GuidanceResponseAction withType(Code value) {
        this.setType(value);
        return this;
    }

    public GuidanceResponseAction withBehavior(GuidanceResponseBehavior ... values) {
        if (values != null) {
            for (GuidanceResponseBehavior value : values) {
                this.getBehavior().add(value);
            }
        }
        return this;
    }

    public GuidanceResponseAction withBehavior(Collection<GuidanceResponseBehavior> values) {
        if (values != null) {
            this.getBehavior().addAll(values);
        }
        return this;
    }

    public GuidanceResponseAction withResource(Reference value) {
        this.setResource(value);
        return this;
    }

    public GuidanceResponseAction withAction(GuidanceResponseAction ... values) {
        if (values != null) {
            for (GuidanceResponseAction value : values) {
                this.getAction().add(value);
            }
        }
        return this;
    }

    public GuidanceResponseAction withAction(Collection<GuidanceResponseAction> values) {
        if (values != null) {
            this.getAction().addAll(values);
        }
        return this;
    }

    @Override
    public GuidanceResponseAction withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public GuidanceResponseAction withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public GuidanceResponseAction withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public GuidanceResponseAction withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public GuidanceResponseAction withId(java.lang.String value) {
        this.setId(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        GuidanceResponseAction that = (GuidanceResponseAction)object;
        Identifier lhsActionIdentifier = this.getActionIdentifier();
        Identifier rhsActionIdentifier = that.getActionIdentifier();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "actionIdentifier", lhsActionIdentifier), (ObjectLocator)LocatorUtils.property(thatLocator, "actionIdentifier", rhsActionIdentifier), lhsActionIdentifier, rhsActionIdentifier, this.actionIdentifier != null, that.actionIdentifier != null)) {
            return false;
        }
        String lhsLabel = this.getLabel();
        String rhsLabel = that.getLabel();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "label", lhsLabel), (ObjectLocator)LocatorUtils.property(thatLocator, "label", rhsLabel), lhsLabel, rhsLabel, this.label != null, that.label != null)) {
            return false;
        }
        String lhsTitle = this.getTitle();
        String rhsTitle = that.getTitle();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "title", lhsTitle), (ObjectLocator)LocatorUtils.property(thatLocator, "title", rhsTitle), lhsTitle, rhsTitle, this.title != null, that.title != null)) {
            return false;
        }
        String lhsDescription = this.getDescription();
        String rhsDescription = that.getDescription();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "description", lhsDescription), (ObjectLocator)LocatorUtils.property(thatLocator, "description", rhsDescription), lhsDescription, rhsDescription, this.description != null, that.description != null)) {
            return false;
        }
        String lhsTextEquivalent = this.getTextEquivalent();
        String rhsTextEquivalent = that.getTextEquivalent();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "textEquivalent", lhsTextEquivalent), (ObjectLocator)LocatorUtils.property(thatLocator, "textEquivalent", rhsTextEquivalent), lhsTextEquivalent, rhsTextEquivalent, this.textEquivalent != null, that.textEquivalent != null)) {
            return false;
        }
        List<CodeableConcept> lhsConcept = this.concept != null && !this.concept.isEmpty() ? this.getConcept() : null;
        List<CodeableConcept> rhsConcept = that.concept != null && !that.concept.isEmpty() ? that.getConcept() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "concept", lhsConcept), (ObjectLocator)LocatorUtils.property(thatLocator, "concept", rhsConcept), lhsConcept, rhsConcept, this.concept != null && !this.concept.isEmpty(), that.concept != null && !that.concept.isEmpty())) {
            return false;
        }
        List<Attachment> lhsSupportingEvidence = this.supportingEvidence != null && !this.supportingEvidence.isEmpty() ? this.getSupportingEvidence() : null;
        List<Attachment> rhsSupportingEvidence = that.supportingEvidence != null && !that.supportingEvidence.isEmpty() ? that.getSupportingEvidence() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "supportingEvidence", lhsSupportingEvidence), (ObjectLocator)LocatorUtils.property(thatLocator, "supportingEvidence", rhsSupportingEvidence), lhsSupportingEvidence, rhsSupportingEvidence, this.supportingEvidence != null && !this.supportingEvidence.isEmpty(), that.supportingEvidence != null && !that.supportingEvidence.isEmpty())) {
            return false;
        }
        GuidanceResponseRelatedAction lhsRelatedAction = this.getRelatedAction();
        GuidanceResponseRelatedAction rhsRelatedAction = that.getRelatedAction();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "relatedAction", lhsRelatedAction), (ObjectLocator)LocatorUtils.property(thatLocator, "relatedAction", rhsRelatedAction), lhsRelatedAction, rhsRelatedAction, this.relatedAction != null, that.relatedAction != null)) {
            return false;
        }
        List<Attachment> lhsDocumentation = this.documentation != null && !this.documentation.isEmpty() ? this.getDocumentation() : null;
        List<Attachment> rhsDocumentation = that.documentation != null && !that.documentation.isEmpty() ? that.getDocumentation() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "documentation", lhsDocumentation), (ObjectLocator)LocatorUtils.property(thatLocator, "documentation", rhsDocumentation), lhsDocumentation, rhsDocumentation, this.documentation != null && !this.documentation.isEmpty(), that.documentation != null && !that.documentation.isEmpty())) {
            return false;
        }
        List<Reference> lhsParticipant = this.participant != null && !this.participant.isEmpty() ? this.getParticipant() : null;
        List<Reference> rhsParticipant = that.participant != null && !that.participant.isEmpty() ? that.getParticipant() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "participant", lhsParticipant), (ObjectLocator)LocatorUtils.property(thatLocator, "participant", rhsParticipant), lhsParticipant, rhsParticipant, this.participant != null && !this.participant.isEmpty(), that.participant != null && !that.participant.isEmpty())) {
            return false;
        }
        Code lhsType = this.getType();
        Code rhsType = that.getType();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "type", lhsType), (ObjectLocator)LocatorUtils.property(thatLocator, "type", rhsType), lhsType, rhsType, this.type != null, that.type != null)) {
            return false;
        }
        List<GuidanceResponseBehavior> lhsBehavior = this.behavior != null && !this.behavior.isEmpty() ? this.getBehavior() : null;
        List<GuidanceResponseBehavior> rhsBehavior = that.behavior != null && !that.behavior.isEmpty() ? that.getBehavior() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "behavior", lhsBehavior), (ObjectLocator)LocatorUtils.property(thatLocator, "behavior", rhsBehavior), lhsBehavior, rhsBehavior, this.behavior != null && !this.behavior.isEmpty(), that.behavior != null && !that.behavior.isEmpty())) {
            return false;
        }
        Reference lhsResource = this.getResource();
        Reference rhsResource = that.getResource();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "resource", lhsResource), (ObjectLocator)LocatorUtils.property(thatLocator, "resource", rhsResource), lhsResource, rhsResource, this.resource != null, that.resource != null)) {
            return false;
        }
        List<GuidanceResponseAction> lhsAction = this.action != null && !this.action.isEmpty() ? this.getAction() : null;
        List<GuidanceResponseAction> rhsAction = that.action != null && !that.action.isEmpty() ? that.getAction() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "action", lhsAction), (ObjectLocator)LocatorUtils.property(thatLocator, "action", rhsAction), lhsAction, rhsAction, this.action != null && !this.action.isEmpty(), that.action != null && !that.action.isEmpty());
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE2;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        Identifier theActionIdentifier = this.getActionIdentifier();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "actionIdentifier", theActionIdentifier), currentHashCode, theActionIdentifier, this.actionIdentifier != null);
        String theLabel = this.getLabel();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "label", theLabel), currentHashCode, theLabel, this.label != null);
        String theTitle = this.getTitle();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "title", theTitle), currentHashCode, theTitle, this.title != null);
        String theDescription = this.getDescription();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "description", theDescription), currentHashCode, theDescription, this.description != null);
        String theTextEquivalent = this.getTextEquivalent();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "textEquivalent", theTextEquivalent), currentHashCode, theTextEquivalent, this.textEquivalent != null);
        List<CodeableConcept> theConcept = this.concept != null && !this.concept.isEmpty() ? this.getConcept() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "concept", theConcept), currentHashCode, theConcept, this.concept != null && !this.concept.isEmpty());
        List<Attachment> theSupportingEvidence = this.supportingEvidence != null && !this.supportingEvidence.isEmpty() ? this.getSupportingEvidence() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "supportingEvidence", theSupportingEvidence), currentHashCode, theSupportingEvidence, this.supportingEvidence != null && !this.supportingEvidence.isEmpty());
        GuidanceResponseRelatedAction theRelatedAction = this.getRelatedAction();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "relatedAction", theRelatedAction), currentHashCode, theRelatedAction, this.relatedAction != null);
        List<Attachment> theDocumentation = this.documentation != null && !this.documentation.isEmpty() ? this.getDocumentation() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "documentation", theDocumentation), currentHashCode, theDocumentation, this.documentation != null && !this.documentation.isEmpty());
        List<Reference> theParticipant = this.participant != null && !this.participant.isEmpty() ? this.getParticipant() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "participant", theParticipant), currentHashCode, theParticipant, this.participant != null && !this.participant.isEmpty());
        Code theType = this.getType();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "type", theType), currentHashCode, theType, this.type != null);
        List<GuidanceResponseBehavior> theBehavior = this.behavior != null && !this.behavior.isEmpty() ? this.getBehavior() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "behavior", theBehavior), currentHashCode, theBehavior, this.behavior != null && !this.behavior.isEmpty());
        Reference theResource = this.getResource();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "resource", theResource), currentHashCode, theResource, this.resource != null);
        List<GuidanceResponseAction> theAction = this.action != null && !this.action.isEmpty() ? this.getAction() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "action", theAction), currentHashCode, theAction, this.action != null && !this.action.isEmpty());
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE2;
        return this.hashCode(null, strategy);
    }

    @Override
    public java.lang.String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.INSTANCE2;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        Identifier theActionIdentifier = this.getActionIdentifier();
        strategy.appendField(locator, (Object)this, "actionIdentifier", buffer, theActionIdentifier, this.actionIdentifier != null);
        String theLabel = this.getLabel();
        strategy.appendField(locator, (Object)this, "label", buffer, theLabel, this.label != null);
        String theTitle = this.getTitle();
        strategy.appendField(locator, (Object)this, "title", buffer, theTitle, this.title != null);
        String theDescription = this.getDescription();
        strategy.appendField(locator, (Object)this, "description", buffer, theDescription, this.description != null);
        String theTextEquivalent = this.getTextEquivalent();
        strategy.appendField(locator, (Object)this, "textEquivalent", buffer, theTextEquivalent, this.textEquivalent != null);
        List<CodeableConcept> theConcept = this.concept != null && !this.concept.isEmpty() ? this.getConcept() : null;
        strategy.appendField(locator, (Object)this, "concept", buffer, theConcept, this.concept != null && !this.concept.isEmpty());
        List<Attachment> theSupportingEvidence = this.supportingEvidence != null && !this.supportingEvidence.isEmpty() ? this.getSupportingEvidence() : null;
        strategy.appendField(locator, (Object)this, "supportingEvidence", buffer, theSupportingEvidence, this.supportingEvidence != null && !this.supportingEvidence.isEmpty());
        GuidanceResponseRelatedAction theRelatedAction = this.getRelatedAction();
        strategy.appendField(locator, (Object)this, "relatedAction", buffer, theRelatedAction, this.relatedAction != null);
        List<Attachment> theDocumentation = this.documentation != null && !this.documentation.isEmpty() ? this.getDocumentation() : null;
        strategy.appendField(locator, (Object)this, "documentation", buffer, theDocumentation, this.documentation != null && !this.documentation.isEmpty());
        List<Reference> theParticipant = this.participant != null && !this.participant.isEmpty() ? this.getParticipant() : null;
        strategy.appendField(locator, (Object)this, "participant", buffer, theParticipant, this.participant != null && !this.participant.isEmpty());
        Code theType = this.getType();
        strategy.appendField(locator, (Object)this, "type", buffer, theType, this.type != null);
        List<GuidanceResponseBehavior> theBehavior = this.behavior != null && !this.behavior.isEmpty() ? this.getBehavior() : null;
        strategy.appendField(locator, (Object)this, "behavior", buffer, theBehavior, this.behavior != null && !this.behavior.isEmpty());
        Reference theResource = this.getResource();
        strategy.appendField(locator, (Object)this, "resource", buffer, theResource, this.resource != null);
        List<GuidanceResponseAction> theAction = this.action != null && !this.action.isEmpty() ? this.getAction() : null;
        strategy.appendField(locator, (Object)this, "action", buffer, theAction, this.action != null && !this.action.isEmpty());
        return buffer;
    }
}

