/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.BackboneElement;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.Reference;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Encounter.Hospitalization", propOrder={"preAdmissionIdentifier", "origin", "admitSource", "admittingDiagnosis", "reAdmission", "dietPreference", "specialCourtesy", "specialArrangement", "destination", "dischargeDisposition", "dischargeDiagnosis"})
public class EncounterHospitalization
extends BackboneElement
implements Equals2,
HashCode2,
ToString2 {
    protected Identifier preAdmissionIdentifier;
    protected Reference origin;
    protected CodeableConcept admitSource;
    protected List<Reference> admittingDiagnosis;
    protected CodeableConcept reAdmission;
    protected List<CodeableConcept> dietPreference;
    protected List<CodeableConcept> specialCourtesy;
    protected List<CodeableConcept> specialArrangement;
    protected Reference destination;
    protected CodeableConcept dischargeDisposition;
    protected List<Reference> dischargeDiagnosis;

    public Identifier getPreAdmissionIdentifier() {
        return this.preAdmissionIdentifier;
    }

    public void setPreAdmissionIdentifier(Identifier value) {
        this.preAdmissionIdentifier = value;
    }

    public Reference getOrigin() {
        return this.origin;
    }

    public void setOrigin(Reference value) {
        this.origin = value;
    }

    public CodeableConcept getAdmitSource() {
        return this.admitSource;
    }

    public void setAdmitSource(CodeableConcept value) {
        this.admitSource = value;
    }

    public List<Reference> getAdmittingDiagnosis() {
        if (this.admittingDiagnosis == null) {
            this.admittingDiagnosis = new ArrayList<Reference>();
        }
        return this.admittingDiagnosis;
    }

    public CodeableConcept getReAdmission() {
        return this.reAdmission;
    }

    public void setReAdmission(CodeableConcept value) {
        this.reAdmission = value;
    }

    public List<CodeableConcept> getDietPreference() {
        if (this.dietPreference == null) {
            this.dietPreference = new ArrayList<CodeableConcept>();
        }
        return this.dietPreference;
    }

    public List<CodeableConcept> getSpecialCourtesy() {
        if (this.specialCourtesy == null) {
            this.specialCourtesy = new ArrayList<CodeableConcept>();
        }
        return this.specialCourtesy;
    }

    public List<CodeableConcept> getSpecialArrangement() {
        if (this.specialArrangement == null) {
            this.specialArrangement = new ArrayList<CodeableConcept>();
        }
        return this.specialArrangement;
    }

    public Reference getDestination() {
        return this.destination;
    }

    public void setDestination(Reference value) {
        this.destination = value;
    }

    public CodeableConcept getDischargeDisposition() {
        return this.dischargeDisposition;
    }

    public void setDischargeDisposition(CodeableConcept value) {
        this.dischargeDisposition = value;
    }

    public List<Reference> getDischargeDiagnosis() {
        if (this.dischargeDiagnosis == null) {
            this.dischargeDiagnosis = new ArrayList<Reference>();
        }
        return this.dischargeDiagnosis;
    }

    public EncounterHospitalization withPreAdmissionIdentifier(Identifier value) {
        this.setPreAdmissionIdentifier(value);
        return this;
    }

    public EncounterHospitalization withOrigin(Reference value) {
        this.setOrigin(value);
        return this;
    }

    public EncounterHospitalization withAdmitSource(CodeableConcept value) {
        this.setAdmitSource(value);
        return this;
    }

    public EncounterHospitalization withAdmittingDiagnosis(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getAdmittingDiagnosis().add(value);
            }
        }
        return this;
    }

    public EncounterHospitalization withAdmittingDiagnosis(Collection<Reference> values) {
        if (values != null) {
            this.getAdmittingDiagnosis().addAll(values);
        }
        return this;
    }

    public EncounterHospitalization withReAdmission(CodeableConcept value) {
        this.setReAdmission(value);
        return this;
    }

    public EncounterHospitalization withDietPreference(CodeableConcept ... values) {
        if (values != null) {
            for (CodeableConcept value : values) {
                this.getDietPreference().add(value);
            }
        }
        return this;
    }

    public EncounterHospitalization withDietPreference(Collection<CodeableConcept> values) {
        if (values != null) {
            this.getDietPreference().addAll(values);
        }
        return this;
    }

    public EncounterHospitalization withSpecialCourtesy(CodeableConcept ... values) {
        if (values != null) {
            for (CodeableConcept value : values) {
                this.getSpecialCourtesy().add(value);
            }
        }
        return this;
    }

    public EncounterHospitalization withSpecialCourtesy(Collection<CodeableConcept> values) {
        if (values != null) {
            this.getSpecialCourtesy().addAll(values);
        }
        return this;
    }

    public EncounterHospitalization withSpecialArrangement(CodeableConcept ... values) {
        if (values != null) {
            for (CodeableConcept value : values) {
                this.getSpecialArrangement().add(value);
            }
        }
        return this;
    }

    public EncounterHospitalization withSpecialArrangement(Collection<CodeableConcept> values) {
        if (values != null) {
            this.getSpecialArrangement().addAll(values);
        }
        return this;
    }

    public EncounterHospitalization withDestination(Reference value) {
        this.setDestination(value);
        return this;
    }

    public EncounterHospitalization withDischargeDisposition(CodeableConcept value) {
        this.setDischargeDisposition(value);
        return this;
    }

    public EncounterHospitalization withDischargeDiagnosis(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getDischargeDiagnosis().add(value);
            }
        }
        return this;
    }

    public EncounterHospitalization withDischargeDiagnosis(Collection<Reference> values) {
        if (values != null) {
            this.getDischargeDiagnosis().addAll(values);
        }
        return this;
    }

    @Override
    public EncounterHospitalization withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public EncounterHospitalization withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public EncounterHospitalization withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public EncounterHospitalization withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public EncounterHospitalization withId(String value) {
        this.setId(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        EncounterHospitalization that = (EncounterHospitalization)object;
        Identifier lhsPreAdmissionIdentifier = this.getPreAdmissionIdentifier();
        Identifier rhsPreAdmissionIdentifier = that.getPreAdmissionIdentifier();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "preAdmissionIdentifier", lhsPreAdmissionIdentifier), (ObjectLocator)LocatorUtils.property(thatLocator, "preAdmissionIdentifier", rhsPreAdmissionIdentifier), lhsPreAdmissionIdentifier, rhsPreAdmissionIdentifier, this.preAdmissionIdentifier != null, that.preAdmissionIdentifier != null)) {
            return false;
        }
        Reference lhsOrigin = this.getOrigin();
        Reference rhsOrigin = that.getOrigin();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "origin", lhsOrigin), (ObjectLocator)LocatorUtils.property(thatLocator, "origin", rhsOrigin), lhsOrigin, rhsOrigin, this.origin != null, that.origin != null)) {
            return false;
        }
        CodeableConcept lhsAdmitSource = this.getAdmitSource();
        CodeableConcept rhsAdmitSource = that.getAdmitSource();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "admitSource", lhsAdmitSource), (ObjectLocator)LocatorUtils.property(thatLocator, "admitSource", rhsAdmitSource), lhsAdmitSource, rhsAdmitSource, this.admitSource != null, that.admitSource != null)) {
            return false;
        }
        List<Reference> lhsAdmittingDiagnosis = this.admittingDiagnosis != null && !this.admittingDiagnosis.isEmpty() ? this.getAdmittingDiagnosis() : null;
        List<Reference> rhsAdmittingDiagnosis = that.admittingDiagnosis != null && !that.admittingDiagnosis.isEmpty() ? that.getAdmittingDiagnosis() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "admittingDiagnosis", lhsAdmittingDiagnosis), (ObjectLocator)LocatorUtils.property(thatLocator, "admittingDiagnosis", rhsAdmittingDiagnosis), lhsAdmittingDiagnosis, rhsAdmittingDiagnosis, this.admittingDiagnosis != null && !this.admittingDiagnosis.isEmpty(), that.admittingDiagnosis != null && !that.admittingDiagnosis.isEmpty())) {
            return false;
        }
        CodeableConcept lhsReAdmission = this.getReAdmission();
        CodeableConcept rhsReAdmission = that.getReAdmission();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "reAdmission", lhsReAdmission), (ObjectLocator)LocatorUtils.property(thatLocator, "reAdmission", rhsReAdmission), lhsReAdmission, rhsReAdmission, this.reAdmission != null, that.reAdmission != null)) {
            return false;
        }
        List<CodeableConcept> lhsDietPreference = this.dietPreference != null && !this.dietPreference.isEmpty() ? this.getDietPreference() : null;
        List<CodeableConcept> rhsDietPreference = that.dietPreference != null && !that.dietPreference.isEmpty() ? that.getDietPreference() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "dietPreference", lhsDietPreference), (ObjectLocator)LocatorUtils.property(thatLocator, "dietPreference", rhsDietPreference), lhsDietPreference, rhsDietPreference, this.dietPreference != null && !this.dietPreference.isEmpty(), that.dietPreference != null && !that.dietPreference.isEmpty())) {
            return false;
        }
        List<CodeableConcept> lhsSpecialCourtesy = this.specialCourtesy != null && !this.specialCourtesy.isEmpty() ? this.getSpecialCourtesy() : null;
        List<CodeableConcept> rhsSpecialCourtesy = that.specialCourtesy != null && !that.specialCourtesy.isEmpty() ? that.getSpecialCourtesy() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "specialCourtesy", lhsSpecialCourtesy), (ObjectLocator)LocatorUtils.property(thatLocator, "specialCourtesy", rhsSpecialCourtesy), lhsSpecialCourtesy, rhsSpecialCourtesy, this.specialCourtesy != null && !this.specialCourtesy.isEmpty(), that.specialCourtesy != null && !that.specialCourtesy.isEmpty())) {
            return false;
        }
        List<CodeableConcept> lhsSpecialArrangement = this.specialArrangement != null && !this.specialArrangement.isEmpty() ? this.getSpecialArrangement() : null;
        List<CodeableConcept> rhsSpecialArrangement = that.specialArrangement != null && !that.specialArrangement.isEmpty() ? that.getSpecialArrangement() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "specialArrangement", lhsSpecialArrangement), (ObjectLocator)LocatorUtils.property(thatLocator, "specialArrangement", rhsSpecialArrangement), lhsSpecialArrangement, rhsSpecialArrangement, this.specialArrangement != null && !this.specialArrangement.isEmpty(), that.specialArrangement != null && !that.specialArrangement.isEmpty())) {
            return false;
        }
        Reference lhsDestination = this.getDestination();
        Reference rhsDestination = that.getDestination();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "destination", lhsDestination), (ObjectLocator)LocatorUtils.property(thatLocator, "destination", rhsDestination), lhsDestination, rhsDestination, this.destination != null, that.destination != null)) {
            return false;
        }
        CodeableConcept lhsDischargeDisposition = this.getDischargeDisposition();
        CodeableConcept rhsDischargeDisposition = that.getDischargeDisposition();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "dischargeDisposition", lhsDischargeDisposition), (ObjectLocator)LocatorUtils.property(thatLocator, "dischargeDisposition", rhsDischargeDisposition), lhsDischargeDisposition, rhsDischargeDisposition, this.dischargeDisposition != null, that.dischargeDisposition != null)) {
            return false;
        }
        List<Reference> lhsDischargeDiagnosis = this.dischargeDiagnosis != null && !this.dischargeDiagnosis.isEmpty() ? this.getDischargeDiagnosis() : null;
        List<Reference> rhsDischargeDiagnosis = that.dischargeDiagnosis != null && !that.dischargeDiagnosis.isEmpty() ? that.getDischargeDiagnosis() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "dischargeDiagnosis", lhsDischargeDiagnosis), (ObjectLocator)LocatorUtils.property(thatLocator, "dischargeDiagnosis", rhsDischargeDiagnosis), lhsDischargeDiagnosis, rhsDischargeDiagnosis, this.dischargeDiagnosis != null && !this.dischargeDiagnosis.isEmpty(), that.dischargeDiagnosis != null && !that.dischargeDiagnosis.isEmpty());
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE2;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        Identifier thePreAdmissionIdentifier = this.getPreAdmissionIdentifier();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "preAdmissionIdentifier", thePreAdmissionIdentifier), currentHashCode, thePreAdmissionIdentifier, this.preAdmissionIdentifier != null);
        Reference theOrigin = this.getOrigin();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "origin", theOrigin), currentHashCode, theOrigin, this.origin != null);
        CodeableConcept theAdmitSource = this.getAdmitSource();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "admitSource", theAdmitSource), currentHashCode, theAdmitSource, this.admitSource != null);
        List<Reference> theAdmittingDiagnosis = this.admittingDiagnosis != null && !this.admittingDiagnosis.isEmpty() ? this.getAdmittingDiagnosis() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "admittingDiagnosis", theAdmittingDiagnosis), currentHashCode, theAdmittingDiagnosis, this.admittingDiagnosis != null && !this.admittingDiagnosis.isEmpty());
        CodeableConcept theReAdmission = this.getReAdmission();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "reAdmission", theReAdmission), currentHashCode, theReAdmission, this.reAdmission != null);
        List<CodeableConcept> theDietPreference = this.dietPreference != null && !this.dietPreference.isEmpty() ? this.getDietPreference() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "dietPreference", theDietPreference), currentHashCode, theDietPreference, this.dietPreference != null && !this.dietPreference.isEmpty());
        List<CodeableConcept> theSpecialCourtesy = this.specialCourtesy != null && !this.specialCourtesy.isEmpty() ? this.getSpecialCourtesy() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "specialCourtesy", theSpecialCourtesy), currentHashCode, theSpecialCourtesy, this.specialCourtesy != null && !this.specialCourtesy.isEmpty());
        List<CodeableConcept> theSpecialArrangement = this.specialArrangement != null && !this.specialArrangement.isEmpty() ? this.getSpecialArrangement() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "specialArrangement", theSpecialArrangement), currentHashCode, theSpecialArrangement, this.specialArrangement != null && !this.specialArrangement.isEmpty());
        Reference theDestination = this.getDestination();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "destination", theDestination), currentHashCode, theDestination, this.destination != null);
        CodeableConcept theDischargeDisposition = this.getDischargeDisposition();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "dischargeDisposition", theDischargeDisposition), currentHashCode, theDischargeDisposition, this.dischargeDisposition != null);
        List<Reference> theDischargeDiagnosis = this.dischargeDiagnosis != null && !this.dischargeDiagnosis.isEmpty() ? this.getDischargeDiagnosis() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "dischargeDiagnosis", theDischargeDiagnosis), currentHashCode, theDischargeDiagnosis, this.dischargeDiagnosis != null && !this.dischargeDiagnosis.isEmpty());
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE2;
        return this.hashCode(null, strategy);
    }

    @Override
    public String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.INSTANCE2;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        Identifier thePreAdmissionIdentifier = this.getPreAdmissionIdentifier();
        strategy.appendField(locator, (Object)this, "preAdmissionIdentifier", buffer, thePreAdmissionIdentifier, this.preAdmissionIdentifier != null);
        Reference theOrigin = this.getOrigin();
        strategy.appendField(locator, (Object)this, "origin", buffer, theOrigin, this.origin != null);
        CodeableConcept theAdmitSource = this.getAdmitSource();
        strategy.appendField(locator, (Object)this, "admitSource", buffer, theAdmitSource, this.admitSource != null);
        List<Reference> theAdmittingDiagnosis = this.admittingDiagnosis != null && !this.admittingDiagnosis.isEmpty() ? this.getAdmittingDiagnosis() : null;
        strategy.appendField(locator, (Object)this, "admittingDiagnosis", buffer, theAdmittingDiagnosis, this.admittingDiagnosis != null && !this.admittingDiagnosis.isEmpty());
        CodeableConcept theReAdmission = this.getReAdmission();
        strategy.appendField(locator, (Object)this, "reAdmission", buffer, theReAdmission, this.reAdmission != null);
        List<CodeableConcept> theDietPreference = this.dietPreference != null && !this.dietPreference.isEmpty() ? this.getDietPreference() : null;
        strategy.appendField(locator, (Object)this, "dietPreference", buffer, theDietPreference, this.dietPreference != null && !this.dietPreference.isEmpty());
        List<CodeableConcept> theSpecialCourtesy = this.specialCourtesy != null && !this.specialCourtesy.isEmpty() ? this.getSpecialCourtesy() : null;
        strategy.appendField(locator, (Object)this, "specialCourtesy", buffer, theSpecialCourtesy, this.specialCourtesy != null && !this.specialCourtesy.isEmpty());
        List<CodeableConcept> theSpecialArrangement = this.specialArrangement != null && !this.specialArrangement.isEmpty() ? this.getSpecialArrangement() : null;
        strategy.appendField(locator, (Object)this, "specialArrangement", buffer, theSpecialArrangement, this.specialArrangement != null && !this.specialArrangement.isEmpty());
        Reference theDestination = this.getDestination();
        strategy.appendField(locator, (Object)this, "destination", buffer, theDestination, this.destination != null);
        CodeableConcept theDischargeDisposition = this.getDischargeDisposition();
        strategy.appendField(locator, (Object)this, "dischargeDisposition", buffer, theDischargeDisposition, this.dischargeDisposition != null);
        List<Reference> theDischargeDiagnosis = this.dischargeDiagnosis != null && !this.dischargeDiagnosis.isEmpty() ? this.getDischargeDiagnosis() : null;
        strategy.appendField(locator, (Object)this, "dischargeDiagnosis", buffer, theDischargeDiagnosis, this.dischargeDiagnosis != null && !this.dischargeDiagnosis.isEmpty());
        return buffer;
    }
}

